package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.WesternUnion: ImageVector
    get() {
        if (_westernUnion != null) {
            return _westernUnion!!
        }
        _westernUnion = Builder(name = "WesternUnion", defaultWidth = 58.0.dp, defaultHeight =
                40.0.dp, viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFF333333)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFDD00)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(43.8071f, 24.6819f)
                curveTo(43.8071f, 24.3053f, 44.1141f, 24.0f, 44.4927f, 24.0f)
                curveTo(44.8714f, 24.0f, 45.1783f, 24.3053f, 45.1783f, 24.6819f)
                curveTo(45.1783f, 24.8538f, 45.1136f, 25.0105f, 45.0078f, 25.131f)
                horizontalLineTo(43.9777f)
                curveTo(43.8718f, 25.0117f, 43.8071f, 24.8538f, 43.8071f, 24.6819f)
                close()
                moveTo(37.9805f, 27.8234f)
                curveTo(37.9805f, 27.8234f, 38.0628f, 29.0854f, 36.6752f, 29.0854f)
                curveTo(35.2876f, 29.0854f, 35.3711f, 27.8164f, 35.3711f, 27.8164f)
                verticalLineTo(24.5649f)
                horizontalLineTo(34.4174f)
                verticalLineTo(27.786f)
                curveTo(34.4174f, 29.1333f, 35.3041f, 30.0f, 36.6752f, 30.0f)
                curveTo(38.0463f, 30.0f, 38.933f, 29.1333f, 38.933f, 27.793f)
                verticalLineTo(24.5649f)
                horizontalLineTo(37.9793f)
                verticalLineTo(27.8234f)
                horizontalLineTo(37.9805f)
                close()
                moveTo(22.0115f, 29.7743f)
                lineTo(21.8116f, 29.0339f)
                lineTo(21.7411f, 29.0713f)
                curveTo(21.6082f, 29.1392f, 21.4577f, 29.1836f, 21.306f, 29.1743f)
                curveTo(21.0332f, 29.1579f, 20.8568f, 28.9766f, 20.8568f, 28.7135f)
                lineTo(20.8556f, 26.6526f)
                horizontalLineTo(21.8093f)
                verticalLineTo(25.9053f)
                horizontalLineTo(20.8556f)
                verticalLineTo(24.5918f)
                lineTo(19.9525f, 24.8327f)
                verticalLineTo(25.9053f)
                horizontalLineTo(19.1999f)
                verticalLineTo(26.6526f)
                horizontalLineTo(19.9525f)
                lineTo(19.9537f, 28.8281f)
                curveTo(19.9537f, 29.5509f, 20.4076f, 30.0f, 21.1402f, 30.0f)
                curveTo(21.4753f, 30.0f, 21.6929f, 29.9287f, 21.9163f, 29.8222f)
                lineTo(22.0115f, 29.7743f)
                close()
                moveTo(44.0412f, 29.9556f)
                verticalLineTo(25.9041f)
                horizontalLineTo(44.9443f)
                verticalLineTo(29.9556f)
                horizontalLineTo(44.0412f)
                close()
                moveTo(49.7949f, 27.9298f)
                curveTo(49.7949f, 29.1099f, 48.9036f, 30.0f, 47.7206f, 30.0f)
                curveTo(46.5329f, 30.0f, 45.6381f, 29.1099f, 45.6381f, 27.9298f)
                curveTo(45.6381f, 26.7497f, 46.5329f, 25.8596f, 47.7206f, 25.8596f)
                curveTo(48.9036f, 25.8596f, 49.7949f, 26.7497f, 49.7949f, 27.9298f)
                close()
                moveTo(47.7206f, 26.7006f)
                curveTo(48.4015f, 26.7006f, 48.8953f, 27.2175f, 48.8953f, 27.9298f)
                curveTo(48.8953f, 28.6421f, 48.4015f, 29.1591f, 47.7206f, 29.1591f)
                curveTo(47.035f, 29.1591f, 46.5376f, 28.6421f, 46.5376f, 27.9298f)
                curveTo(46.5376f, 27.2175f, 47.035f, 26.7006f, 47.7206f, 26.7006f)
                close()
                moveTo(28.766f, 25.8678f)
                curveTo(28.4944f, 25.9029f, 28.2098f, 25.9942f, 27.9558f, 26.1965f)
                verticalLineTo(25.9041f)
                horizontalLineTo(27.0527f)
                verticalLineTo(29.9556f)
                horizontalLineTo(27.9558f)
                verticalLineTo(27.4924f)
                curveTo(27.9558f, 27.4094f, 27.9699f, 27.3275f, 28.0016f, 27.2503f)
                curveTo(28.0793f, 27.0655f, 28.2286f, 26.8713f, 28.4473f, 26.7778f)
                curveTo(28.5943f, 26.7146f, 28.7342f, 26.6936f, 28.8542f, 26.6936f)
                curveTo(28.9847f, 26.6936f, 29.1764f, 26.7146f, 29.3104f, 26.7836f)
                verticalLineTo(25.9181f)
                lineTo(29.3081f, 25.9175f)
                curveTo(29.281f, 25.9096f, 29.0235f, 25.8346f, 28.766f, 25.8678f)
                close()
                moveTo(9.4339f, 28.4f)
                lineTo(10.4664f, 24.5661f)
                horizontalLineTo(11.4177f)
                lineTo(9.9654f, 29.9556f)
                horizontalLineTo(9.0153f)
                lineTo(7.71f, 25.9579f)
                lineTo(6.4036f, 29.9556f)
                horizontalLineTo(5.4534f)
                lineTo(4.0f, 24.5649f)
                horizontalLineTo(4.9501f)
                lineTo(5.9838f, 28.4f)
                lineTo(7.2232f, 24.5661f)
                horizontalLineTo(8.1945f)
                lineTo(9.4339f, 28.4f)
                close()
                moveTo(13.3862f, 30.0f)
                curveTo(12.1985f, 29.9965f, 11.3095f, 29.1123f, 11.3071f, 27.931f)
                curveTo(11.3071f, 27.6702f, 11.3518f, 27.4082f, 11.4436f, 27.1637f)
                curveTo(11.5835f, 26.7942f, 11.8316f, 26.4678f, 12.155f, 26.2374f)
                curveTo(12.5078f, 25.9871f, 12.9405f, 25.8596f, 13.3721f, 25.8596f)
                curveTo(13.9436f, 25.8596f, 14.4057f, 26.0573f, 14.7385f, 26.4117f)
                curveTo(14.9666f, 26.6561f, 15.1206f, 26.9661f, 15.21f, 27.2854f)
                curveTo(15.29f, 27.5719f, 15.2982f, 27.8596f, 15.2982f, 28.1556f)
                horizontalLineTo(12.1985f)
                lineTo(12.2161f, 28.2433f)
                curveTo(12.3302f, 28.7871f, 12.7982f, 29.152f, 13.3862f, 29.1532f)
                curveTo(13.8942f, 29.152f, 14.227f, 28.9146f, 14.4022f, 28.7392f)
                lineTo(15.0207f, 29.3123f)
                curveTo(14.6456f, 29.7392f, 14.0341f, 29.9988f, 13.3862f, 30.0f)
                close()
                moveTo(14.3702f, 27.5041f)
                lineTo(14.3704f, 27.5053f)
                verticalLineTo(27.5041f)
                horizontalLineTo(14.3702f)
                close()
                moveTo(13.9953f, 26.8491f)
                curveTo(14.2043f, 27.0033f, 14.3301f, 27.2437f, 14.3702f, 27.5041f)
                horizontalLineTo(12.2208f)
                curveTo(12.2208f, 27.5041f, 12.2961f, 27.2409f, 12.4631f, 27.0491f)
                curveTo(12.6724f, 26.807f, 12.9746f, 26.6503f, 13.3074f, 26.6503f)
                curveTo(13.5473f, 26.6503f, 13.7683f, 26.6819f, 13.9953f, 26.8491f)
                close()
                moveTo(24.4468f, 30.0f)
                curveTo(23.2592f, 29.9965f, 22.3702f, 29.1123f, 22.3678f, 27.931f)
                curveTo(22.3678f, 27.6702f, 22.4125f, 27.4082f, 22.5042f, 27.1637f)
                curveTo(22.6442f, 26.7942f, 22.8923f, 26.4678f, 23.2157f, 26.2374f)
                curveTo(23.5684f, 25.9871f, 24.0012f, 25.8596f, 24.4327f, 25.8596f)
                curveTo(25.0042f, 25.8596f, 25.4664f, 26.0573f, 25.7992f, 26.4117f)
                curveTo(26.0273f, 26.6561f, 26.1813f, 26.9661f, 26.2707f, 27.2854f)
                curveTo(26.3507f, 27.5719f, 26.3589f, 27.8596f, 26.3589f, 28.1556f)
                horizontalLineTo(23.2592f)
                lineTo(23.2768f, 28.2433f)
                curveTo(23.3909f, 28.7871f, 23.8589f, 29.152f, 24.4468f, 29.1532f)
                curveTo(24.9548f, 29.152f, 25.2876f, 28.9146f, 25.4628f, 28.7392f)
                lineTo(26.0814f, 29.3123f)
                curveTo(25.7051f, 29.7392f, 25.0948f, 29.9988f, 24.4468f, 30.0f)
                close()
                moveTo(25.4297f, 27.5041f)
                lineTo(25.4299f, 27.5053f)
                verticalLineTo(27.5041f)
                horizontalLineTo(25.4297f)
                close()
                moveTo(25.0548f, 26.8491f)
                curveTo(25.2638f, 27.0033f, 25.3896f, 27.2437f, 25.4297f, 27.5041f)
                horizontalLineTo(23.2803f)
                curveTo(23.2803f, 27.5041f, 23.3556f, 27.2409f, 23.5226f, 27.0491f)
                curveTo(23.7319f, 26.807f, 24.0341f, 26.6503f, 24.3669f, 26.6503f)
                curveTo(24.6068f, 26.6503f, 24.8278f, 26.6819f, 25.0548f, 26.8491f)
                close()
                moveTo(17.5195f, 27.476f)
                curveTo(17.1268f, 27.3836f, 16.8492f, 27.2842f, 16.8445f, 27.0538f)
                curveTo(16.8387f, 26.745f, 17.1115f, 26.6515f, 17.5842f, 26.6515f)
                curveTo(17.7794f, 26.6515f, 18.3991f, 26.6503f, 18.3991f, 26.6503f)
                verticalLineTo(25.9029f)
                lineTo(17.5924f, 25.9041f)
                curveTo(16.8833f, 25.9041f, 15.992f, 26.0561f, 15.992f, 27.1088f)
                curveTo(16.0002f, 27.5813f, 16.3236f, 27.9474f, 16.9257f, 28.1357f)
                curveTo(17.0517f, 28.175f, 17.1796f, 28.2056f, 17.3041f, 28.2354f)
                lineTo(17.342f, 28.2444f)
                curveTo(17.7606f, 28.3439f, 18.1216f, 28.4444f, 18.1263f, 28.7544f)
                curveTo(18.131f, 29.0351f, 17.7547f, 29.2035f, 17.4396f, 29.2094f)
                curveTo(16.8845f, 29.2094f, 16.5176f, 28.8912f, 16.4024f, 28.7754f)
                lineTo(15.8133f, 29.3216f)
                curveTo(15.8133f, 29.3216f, 16.3283f, 29.9977f, 17.4748f, 29.9977f)
                curveTo(18.2262f, 29.9977f, 18.9941f, 29.5135f, 18.9812f, 28.7228f)
                curveTo(18.9671f, 27.9404f, 18.2345f, 27.6456f, 17.5195f, 27.476f)
                close()
                moveTo(40.6357f, 26.1509f)
                curveTo(40.9626f, 25.9135f, 41.3365f, 25.8596f, 41.6564f, 25.8596f)
                curveTo(42.5971f, 25.8596f, 43.2439f, 26.4971f, 43.2439f, 27.5006f)
                verticalLineTo(29.9556f)
                horizontalLineTo(42.3408f)
                verticalLineTo(27.5591f)
                curveTo(42.3408f, 27.0538f, 42.0021f, 26.7146f, 41.5f, 26.7146f)
                curveTo(40.9273f, 26.7146f, 40.6357f, 27.1474f, 40.6357f, 27.5088f)
                verticalLineTo(29.9556f)
                horizontalLineTo(39.7326f)
                verticalLineTo(25.9041f)
                horizontalLineTo(40.6357f)
                verticalLineTo(26.1509f)
                close()
                moveTo(32.0327f, 25.8596f)
                curveTo(31.7128f, 25.8596f, 31.3389f, 25.9135f, 31.012f, 26.1509f)
                verticalLineTo(25.9041f)
                horizontalLineTo(30.1089f)
                verticalLineTo(29.9556f)
                horizontalLineTo(31.012f)
                verticalLineTo(27.5088f)
                curveTo(31.012f, 27.1474f, 31.3036f, 26.7146f, 31.8763f, 26.7146f)
                curveTo(32.3784f, 26.7146f, 32.7171f, 27.0538f, 32.7171f, 27.5591f)
                verticalLineTo(29.9556f)
                horizontalLineTo(33.6202f)
                verticalLineTo(27.5006f)
                curveTo(33.6202f, 26.4971f, 32.9734f, 25.8596f, 32.0327f, 25.8596f)
                close()
                moveTo(51.3918f, 26.1509f)
                curveTo(51.7187f, 25.9135f, 52.0927f, 25.8596f, 52.4125f, 25.8596f)
                curveTo(53.3544f, 25.8596f, 54.0f, 26.4971f, 54.0f, 27.5006f)
                verticalLineTo(29.9556f)
                horizontalLineTo(53.0969f)
                verticalLineTo(27.5591f)
                curveTo(53.0969f, 27.0538f, 52.7582f, 26.7146f, 52.2561f, 26.7146f)
                curveTo(51.6834f, 26.7146f, 51.3918f, 27.1474f, 51.3918f, 27.5088f)
                verticalLineTo(29.9556f)
                horizontalLineTo(50.4887f)
                verticalLineTo(25.9041f)
                horizontalLineTo(51.3918f)
                verticalLineTo(26.1509f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFDD00)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(31.4688f, 21.28f)
                lineTo(34.4784f, 10.2208f)
                horizontalLineTo(32.1384f)
                lineTo(30.3192f, 17.272f)
                lineTo(28.1064f, 10.2208f)
                horizontalLineTo(25.9176f)
                lineTo(23.7432f, 17.2192f)
                lineTo(21.8832f, 10.2208f)
                horizontalLineTo(19.5168f)
                lineTo(22.5552f, 21.28f)
                horizontalLineTo(24.7248f)
                lineTo(27.0048f, 13.948f)
                lineTo(29.2848f, 21.28f)
                horizontalLineTo(31.4688f)
                close()
                moveTo(41.4312f, 17.032f)
                verticalLineTo(10.2208f)
                horizontalLineTo(43.8144f)
                verticalLineTo(16.972f)
                curveTo(43.8144f, 18.3352f, 43.3728f, 19.492f, 42.5376f, 20.3128f)
                curveTo(41.7024f, 21.1336f, 40.5288f, 21.568f, 39.1464f, 21.568f)
                curveTo(37.7616f, 21.568f, 36.5904f, 21.1336f, 35.7552f, 20.3128f)
                curveTo(34.92f, 19.4896f, 34.4784f, 18.3352f, 34.4784f, 16.972f)
                verticalLineTo(15.3712f)
                lineTo(35.88f, 10.2208f)
                horizontalLineTo(36.8616f)
                verticalLineTo(17.0488f)
                curveTo(36.8616f, 17.049f, 36.8616f, 17.0498f, 36.8615f, 17.0509f)
                curveTo(36.8597f, 17.101f, 36.8274f, 17.9995f, 37.4112f, 18.6208f)
                curveTo(37.8f, 19.0336f, 38.3832f, 19.2424f, 39.1464f, 19.2424f)
                curveTo(39.9096f, 19.2424f, 40.4928f, 19.0336f, 40.8816f, 18.6208f)
                curveTo(41.4654f, 17.9995f, 41.4331f, 17.101f, 41.4313f, 17.0509f)
                curveTo(41.4312f, 17.0498f, 41.4312f, 17.049f, 41.4312f, 17.0488f)
                verticalLineTo(17.032f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(15.2304f, 10.2208f)
                lineTo(18.2688f, 21.28f)
                horizontalLineTo(19.0464f)
                lineTo(16.0056f, 10.2208f)
                horizontalLineTo(15.2304f)
                close()
                moveTo(18.1512f, 10.2208f)
                lineTo(21.1896f, 21.28f)
                horizontalLineTo(20.412f)
                lineTo(17.376f, 10.2208f)
                horizontalLineTo(18.1512f)
                close()
            }
        }
        .build()
        return _westernUnion!!
    }

private var _westernUnion: ImageVector? = null
