package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.Sepa: ImageVector
    get() {
        if (_sepa != null) {
            return _sepa!!
        }
        _sepa = Builder(name = "Sepa", defaultWidth = 58.0.dp, defaultHeight = 40.0.dp,
                viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(7.8245f, 26.3484f)
                lineTo(8.267f, 26.3038f)
                curveTo(8.2936f, 26.453f, 8.3477f, 26.5625f, 8.4291f, 26.6326f)
                curveTo(8.5107f, 26.7026f, 8.6205f, 26.7376f, 8.7588f, 26.7376f)
                curveTo(8.9053f, 26.7376f, 9.0156f, 26.7065f, 9.09f, 26.6444f)
                curveTo(9.1642f, 26.5821f, 9.2013f, 26.5094f, 9.2013f, 26.4261f)
                curveTo(9.2013f, 26.3727f, 9.1857f, 26.3274f, 9.1546f, 26.2897f)
                curveTo(9.1235f, 26.2522f, 9.0691f, 26.2197f, 8.9914f, 26.1918f)
                curveTo(8.9382f, 26.1737f, 8.8172f, 26.141f, 8.6282f, 26.0941f)
                curveTo(8.3849f, 26.034f, 8.2144f, 25.9598f, 8.1163f, 25.8718f)
                curveTo(7.9784f, 25.7482f, 7.9094f, 25.5973f, 7.9094f, 25.4193f)
                curveTo(7.9094f, 25.3049f, 7.9419f, 25.1977f, 8.007f, 25.0981f)
                curveTo(8.0719f, 24.9984f, 8.1658f, 24.9224f, 8.2881f, 24.8703f)
                curveTo(8.4105f, 24.8182f, 8.5583f, 24.792f, 8.7314f, 24.792f)
                curveTo(9.014f, 24.792f, 9.2268f, 24.8542f, 9.3696f, 24.9785f)
                curveTo(9.5126f, 25.1028f, 9.5875f, 25.2687f, 9.5947f, 25.4762f)
                lineTo(9.1388f, 25.4941f)
                curveTo(9.1193f, 25.3782f, 9.0775f, 25.2949f, 9.0135f, 25.244f)
                curveTo(8.9495f, 25.1932f, 8.8535f, 25.1677f, 8.7255f, 25.1677f)
                curveTo(8.5933f, 25.1677f, 8.4901f, 25.1949f, 8.4152f, 25.2493f)
                curveTo(8.367f, 25.284f, 8.343f, 25.3307f, 8.343f, 25.3891f)
                curveTo(8.343f, 25.4425f, 8.3656f, 25.488f, 8.4107f, 25.5261f)
                curveTo(8.4679f, 25.5741f, 8.6071f, 25.6244f, 8.8282f, 25.6763f)
                curveTo(9.0492f, 25.7284f, 9.2127f, 25.7824f, 9.3187f, 25.8385f)
                curveTo(9.4246f, 25.8944f, 9.5076f, 25.971f, 9.5675f, 26.068f)
                curveTo(9.6273f, 26.1654f, 9.6573f, 26.2853f, 9.6573f, 26.4281f)
                curveTo(9.6573f, 26.5578f, 9.6214f, 26.679f, 9.5496f, 26.7921f)
                curveTo(9.4778f, 26.9051f, 9.3764f, 26.9892f, 9.2452f, 27.0441f)
                curveTo(9.114f, 27.0991f, 8.9505f, 27.1267f, 8.7547f, 27.1267f)
                curveTo(8.4697f, 27.1267f, 8.2509f, 27.0604f, 8.0981f, 26.9279f)
                curveTo(7.9455f, 26.7954f, 7.8542f, 26.6023f, 7.8245f, 26.3484f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(10.1298f, 25.4539f)
                horizontalLineTo(10.5634f)
                verticalLineTo(27.0863f)
                horizontalLineTo(10.1298f)
                verticalLineTo(25.4539f)
                close()
                moveTo(10.1298f, 24.8322f)
                horizontalLineTo(10.5634f)
                verticalLineTo(25.2303f)
                horizontalLineTo(10.1298f)
                verticalLineTo(24.8322f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(12.5871f, 27.0863f)
                horizontalLineTo(12.1535f)
                verticalLineTo(26.2514f)
                curveTo(12.1535f, 26.0748f, 12.1442f, 25.9606f, 12.1259f, 25.9087f)
                curveTo(12.1074f, 25.8569f, 12.0777f, 25.8164f, 12.0363f, 25.7877f)
                curveTo(11.995f, 25.759f, 11.9452f, 25.7446f, 11.8871f, 25.7446f)
                curveTo(11.8126f, 25.7446f, 11.7458f, 25.7652f, 11.6866f, 25.8063f)
                curveTo(11.6274f, 25.8473f, 11.5869f, 25.9017f, 11.565f, 25.9696f)
                curveTo(11.543f, 26.0373f, 11.5321f, 26.1625f, 11.5321f, 26.3454f)
                verticalLineTo(27.0863f)
                horizontalLineTo(11.0985f)
                verticalLineTo(25.4539f)
                horizontalLineTo(11.5008f)
                verticalLineTo(25.6938f)
                curveTo(11.6431f, 25.507f, 11.8225f, 25.4137f, 12.0385f, 25.4137f)
                curveTo(12.1337f, 25.4137f, 12.2209f, 25.431f, 12.2997f, 25.4654f)
                curveTo(12.3785f, 25.4997f, 12.4381f, 25.5436f, 12.4786f, 25.597f)
                curveTo(12.5191f, 25.6504f, 12.5473f, 25.711f, 12.5632f, 25.7788f)
                curveTo(12.579f, 25.8465f, 12.5871f, 25.9435f, 12.5871f, 26.0698f)
                verticalLineTo(27.0863f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(13.4639f, 26.2349f)
                curveTo(13.4639f, 26.4087f, 13.4971f, 26.5359f, 13.5638f, 26.6165f)
                curveTo(13.6303f, 26.6973f, 13.7124f, 26.7375f, 13.8101f, 26.7375f)
                curveTo(13.9147f, 26.7375f, 14.0031f, 26.6962f, 14.0753f, 26.6135f)
                curveTo(14.1474f, 26.5307f, 14.1836f, 26.4081f, 14.1836f, 26.2456f)
                curveTo(14.1836f, 26.0762f, 14.149f, 25.9503f, 14.0799f, 25.868f)
                curveTo(14.0106f, 25.7858f, 13.9234f, 25.7446f, 13.8177f, 25.7446f)
                curveTo(13.715f, 25.7446f, 13.6303f, 25.7851f, 13.5638f, 25.8657f)
                curveTo(13.4971f, 25.9465f, 13.4639f, 26.0695f, 13.4639f, 26.2349f)
                close()
                moveTo(13.075f, 27.1937f)
                lineTo(13.5666f, 27.2473f)
                curveTo(13.5749f, 27.3082f, 13.5939f, 27.35f, 13.6237f, 27.3729f)
                curveTo(13.6649f, 27.4055f, 13.7297f, 27.4218f, 13.8181f, 27.4218f)
                curveTo(13.9312f, 27.4218f, 14.0161f, 27.4049f, 14.0727f, 27.3711f)
                curveTo(14.1106f, 27.3485f, 14.1395f, 27.3122f, 14.1591f, 27.2619f)
                curveTo(14.1724f, 27.2259f, 14.1791f, 27.1599f, 14.1791f, 27.0634f)
                lineTo(14.1804f, 26.8251f)
                curveTo(14.0526f, 26.9993f, 13.8903f, 27.0863f, 13.6935f, 27.0863f)
                curveTo(13.4739f, 27.0863f, 13.3003f, 26.9936f, 13.1721f, 26.8077f)
                curveTo(13.0715f, 26.6608f, 13.0213f, 26.4779f, 13.0213f, 26.2592f)
                curveTo(13.0213f, 25.985f, 13.0871f, 25.7756f, 13.2189f, 25.6308f)
                curveTo(13.3506f, 25.4861f, 13.5146f, 25.4137f, 13.7104f, 25.4137f)
                curveTo(13.9124f, 25.4137f, 14.079f, 25.5026f, 14.2103f, 25.68f)
                verticalLineTo(25.4539f)
                horizontalLineTo(14.6127f)
                verticalLineTo(26.9213f)
                curveTo(14.6127f, 27.1144f, 14.5968f, 27.2586f, 14.5649f, 27.354f)
                curveTo(14.5332f, 27.4496f, 14.4886f, 27.5244f, 14.4311f, 27.5788f)
                curveTo(14.3735f, 27.6332f, 14.2969f, 27.6758f, 14.2009f, 27.7066f)
                curveTo(14.1049f, 27.7374f, 13.9836f, 27.7528f, 13.837f, 27.7528f)
                curveTo(13.5599f, 27.7528f, 13.3634f, 27.705f, 13.2473f, 27.6096f)
                curveTo(13.1313f, 27.5141f, 13.0734f, 27.393f, 13.0734f, 27.2463f)
                curveTo(13.0734f, 27.2319f, 13.074f, 27.2144f, 13.075f, 27.1937f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(15.132f, 24.8322f)
                horizontalLineTo(15.5656f)
                verticalLineTo(27.0863f)
                horizontalLineTo(15.132f)
                verticalLineTo(24.8322f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(17.0751f, 26.1337f)
                curveTo(17.0721f, 26.0066f, 17.0396f, 25.9102f, 16.9777f, 25.8439f)
                curveTo(16.9159f, 25.7778f, 16.8407f, 25.7446f, 16.752f, 25.7446f)
                curveTo(16.6571f, 25.7446f, 16.5788f, 25.7797f, 16.517f, 25.8494f)
                curveTo(16.455f, 25.9191f, 16.4247f, 26.0139f, 16.4257f, 26.1337f)
                horizontalLineTo(17.0751f)
                close()
                moveTo(17.0528f, 26.5721f)
                lineTo(17.4819f, 26.6437f)
                curveTo(17.4264f, 26.801f, 17.3388f, 26.9209f, 17.219f, 27.0032f)
                curveTo(17.0993f, 27.0856f, 16.9494f, 27.1267f, 16.7696f, 27.1267f)
                curveTo(16.4848f, 27.1267f, 16.2741f, 27.0335f, 16.1375f, 26.8473f)
                curveTo(16.0295f, 26.6982f, 15.9755f, 26.51f, 15.9755f, 26.2824f)
                curveTo(15.9755f, 26.0111f, 16.0463f, 25.7983f, 16.1882f, 25.6444f)
                curveTo(16.33f, 25.4906f, 16.5092f, 25.4137f, 16.7259f, 25.4137f)
                curveTo(16.9696f, 25.4137f, 17.1617f, 25.4944f, 17.3024f, 25.6557f)
                curveTo(17.4432f, 25.8173f, 17.5104f, 26.0645f, 17.5043f, 26.3976f)
                horizontalLineTo(16.4181f)
                curveTo(16.4211f, 26.5262f, 16.4563f, 26.6261f, 16.5235f, 26.6976f)
                curveTo(16.5908f, 26.7689f, 16.6746f, 26.8047f, 16.775f, 26.8047f)
                curveTo(16.8432f, 26.8047f, 16.9007f, 26.7864f, 16.9472f, 26.7496f)
                curveTo(16.9937f, 26.7129f, 17.0291f, 26.6537f, 17.0528f, 26.5721f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(18.923f, 27.0863f)
                verticalLineTo(24.8322f)
                horizontalLineTo(20.5905f)
                verticalLineTo(25.2124f)
                horizontalLineTo(19.379f)
                verticalLineTo(25.7133f)
                horizontalLineTo(20.5055f)
                verticalLineTo(26.0935f)
                horizontalLineTo(19.379f)
                verticalLineTo(26.7062f)
                horizontalLineTo(20.6351f)
                verticalLineTo(27.0863f)
                horizontalLineTo(18.923f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(22.1849f, 27.0863f)
                verticalLineTo(26.8418f)
                curveTo(22.1252f, 26.929f, 22.047f, 26.9983f, 21.9499f, 27.0496f)
                curveTo(21.8527f, 27.1009f, 21.7503f, 27.1266f, 21.6425f, 27.1266f)
                curveTo(21.5325f, 27.1266f, 21.434f, 27.1024f, 21.3466f, 27.0542f)
                curveTo(21.2594f, 27.006f, 21.1962f, 26.9381f, 21.1571f, 26.851f)
                curveTo(21.1181f, 26.7637f, 21.0986f, 26.643f, 21.0986f, 26.489f)
                verticalLineTo(25.4539f)
                horizontalLineTo(21.5322f)
                verticalLineTo(26.2047f)
                curveTo(21.5322f, 26.4345f, 21.54f, 26.5753f, 21.5561f, 26.627f)
                curveTo(21.5719f, 26.6791f, 21.6008f, 26.72f, 21.6429f, 26.7504f)
                curveTo(21.6849f, 26.7806f, 21.7382f, 26.7956f, 21.8028f, 26.7956f)
                curveTo(21.8766f, 26.7956f, 21.9429f, 26.7756f, 22.0012f, 26.7349f)
                curveTo(22.0597f, 26.6944f, 22.0996f, 26.6442f, 22.1212f, 26.5841f)
                curveTo(22.1427f, 26.5241f, 22.1536f, 26.3771f, 22.1536f, 26.1433f)
                verticalLineTo(25.4539f)
                horizontalLineTo(22.5871f)
                verticalLineTo(27.0863f)
                horizontalLineTo(22.1849f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(23.54f, 27.0863f)
                horizontalLineTo(23.1064f)
                verticalLineTo(25.4539f)
                horizontalLineTo(23.5086f)
                verticalLineTo(25.6861f)
                curveTo(23.5774f, 25.5764f, 23.6392f, 25.5037f, 23.6942f, 25.4677f)
                curveTo(23.7491f, 25.4317f, 23.8113f, 25.4137f, 23.8811f, 25.4137f)
                curveTo(23.9795f, 25.4137f, 24.0745f, 25.441f, 24.1658f, 25.4956f)
                lineTo(24.0339f, 25.8735f)
                curveTo(23.9609f, 25.8265f, 23.8929f, 25.8028f, 23.8302f, 25.8028f)
                curveTo(23.7694f, 25.8028f, 23.7181f, 25.8196f, 23.6759f, 25.8528f)
                curveTo(23.6337f, 25.8863f, 23.6005f, 25.9465f, 23.5763f, 26.0337f)
                curveTo(23.5521f, 26.1208f, 23.54f, 26.3036f, 23.54f, 26.5815f)
                verticalLineTo(27.0863f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(24.7832f, 26.2701f)
                curveTo(24.7832f, 26.4328f, 24.8217f, 26.5572f, 24.8988f, 26.6437f)
                curveTo(24.9759f, 26.7301f, 25.0709f, 26.7733f, 25.184f, 26.7733f)
                curveTo(25.297f, 26.7733f, 25.3919f, 26.7301f, 25.4684f, 26.6437f)
                curveTo(25.5449f, 26.5572f, 25.5833f, 26.4317f, 25.5833f, 26.2671f)
                curveTo(25.5833f, 26.1067f, 25.5449f, 25.983f, 25.4684f, 25.8967f)
                curveTo(25.3919f, 25.8103f, 25.297f, 25.7671f, 25.184f, 25.7671f)
                curveTo(25.0709f, 25.7671f, 24.9759f, 25.8103f, 24.8988f, 25.8967f)
                curveTo(24.8217f, 25.983f, 24.7832f, 26.1077f, 24.7832f, 26.2701f)
                close()
                moveTo(24.3406f, 26.2469f)
                curveTo(24.3406f, 26.103f, 24.3759f, 25.9636f, 24.4467f, 25.8287f)
                curveTo(24.5174f, 25.6941f, 24.6175f, 25.5912f, 24.7473f, 25.5202f)
                curveTo(24.8769f, 25.4492f, 25.0218f, 25.4137f, 25.1817f, 25.4137f)
                curveTo(25.4288f, 25.4137f, 25.6312f, 25.4941f, 25.7891f, 25.6551f)
                curveTo(25.9469f, 25.8161f, 26.0258f, 26.0197f, 26.0258f, 26.2655f)
                curveTo(26.0258f, 26.5134f, 25.946f, 26.7191f, 25.7867f, 26.8821f)
                curveTo(25.6273f, 27.0451f, 25.4266f, 27.1267f, 25.1847f, 27.1267f)
                curveTo(25.0351f, 27.1267f, 24.8923f, 27.0926f, 24.7566f, 27.0249f)
                curveTo(24.6207f, 26.957f, 24.5174f, 26.8575f, 24.4467f, 26.7262f)
                curveTo(24.3759f, 26.595f, 24.3406f, 26.4354f, 24.3406f, 26.2469f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(27.8937f, 25.2124f)
                verticalLineTo(25.8565f)
                horizontalLineTo(28.1421f)
                curveTo(28.3209f, 25.8565f, 28.4404f, 25.8447f, 28.5008f, 25.821f)
                curveTo(28.561f, 25.7972f, 28.6084f, 25.76f, 28.6426f, 25.7093f)
                curveTo(28.6768f, 25.6588f, 28.6939f, 25.6f, 28.6939f, 25.5329f)
                curveTo(28.6939f, 25.4503f, 28.6699f, 25.3822f, 28.6218f, 25.3285f)
                curveTo(28.5738f, 25.2748f, 28.513f, 25.2413f, 28.4394f, 25.2279f)
                curveTo(28.3852f, 25.2176f, 28.2765f, 25.2124f, 28.1129f, 25.2124f)
                horizontalLineTo(27.8937f)
                close()
                moveTo(27.4378f, 27.0863f)
                verticalLineTo(24.8322f)
                horizontalLineTo(28.1677f)
                curveTo(28.4442f, 24.8322f, 28.6245f, 24.8436f, 28.7085f, 24.8661f)
                curveTo(28.8375f, 24.8998f, 28.9455f, 24.9736f, 29.0327f, 25.0869f)
                curveTo(29.1198f, 25.2001f, 29.1633f, 25.3465f, 29.1633f, 25.526f)
                curveTo(29.1633f, 25.6644f, 29.1382f, 25.7806f, 29.088f, 25.8752f)
                curveTo(29.038f, 25.9694f, 28.9742f, 26.0435f, 28.8969f, 26.0973f)
                curveTo(28.8197f, 26.1513f, 28.7411f, 26.1868f, 28.6613f, 26.2042f)
                curveTo(28.5527f, 26.2258f, 28.3957f, 26.2366f, 28.1901f, 26.2366f)
                horizontalLineTo(27.8937f)
                verticalLineTo(27.0863f)
                horizontalLineTo(27.4378f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(30.5253f, 26.3038f)
                curveTo(30.47f, 26.3224f, 30.3826f, 26.3444f, 30.263f, 26.3702f)
                curveTo(30.1434f, 26.3958f, 30.0651f, 26.4211f, 30.0285f, 26.4457f)
                curveTo(29.9722f, 26.4859f, 29.9443f, 26.5369f, 29.9443f, 26.5986f)
                curveTo(29.9443f, 26.6594f, 29.9666f, 26.7118f, 30.0115f, 26.7562f)
                curveTo(30.0566f, 26.8004f, 30.1138f, 26.8226f, 30.1834f, 26.8226f)
                curveTo(30.2611f, 26.8226f, 30.3351f, 26.7968f, 30.4057f, 26.7454f)
                curveTo(30.4578f, 26.7062f, 30.4921f, 26.6584f, 30.5085f, 26.6017f)
                curveTo(30.5196f, 26.5647f, 30.5253f, 26.4941f, 30.5253f, 26.3901f)
                verticalLineTo(26.3038f)
                close()
                moveTo(29.9443f, 25.9504f)
                lineTo(29.5553f, 25.8788f)
                curveTo(29.5994f, 25.7207f, 29.6752f, 25.6038f, 29.7828f, 25.5278f)
                curveTo(29.8905f, 25.4518f, 30.0504f, 25.4137f, 30.2626f, 25.4137f)
                curveTo(30.4552f, 25.4137f, 30.5989f, 25.4366f, 30.6931f, 25.4821f)
                curveTo(30.7874f, 25.528f, 30.8539f, 25.586f, 30.8922f, 25.6563f)
                curveTo(30.9307f, 25.7266f, 30.95f, 25.8558f, 30.95f, 26.0437f)
                lineTo(30.9456f, 26.5489f)
                curveTo(30.9456f, 26.6926f, 30.9525f, 26.7988f, 30.9662f, 26.8669f)
                curveTo(30.9801f, 26.9352f, 31.006f, 27.0083f, 31.0439f, 27.0863f)
                horizontalLineTo(30.6147f)
                curveTo(30.6033f, 27.0581f, 30.5896f, 27.0162f, 30.5731f, 26.9607f)
                curveTo(30.566f, 26.9353f, 30.5608f, 26.9187f, 30.5579f, 26.9106f)
                curveTo(30.4841f, 26.9826f, 30.4053f, 27.0367f, 30.3213f, 27.0727f)
                curveTo(30.2374f, 27.1087f, 30.148f, 27.1267f, 30.0527f, 27.1267f)
                curveTo(29.8848f, 27.1267f, 29.7523f, 27.0809f, 29.6556f, 26.9896f)
                curveTo(29.5589f, 26.8981f, 29.5106f, 26.7825f, 29.5106f, 26.6428f)
                curveTo(29.5106f, 26.5505f, 29.5326f, 26.4681f, 29.5765f, 26.3956f)
                curveTo(29.6207f, 26.3232f, 29.6825f, 26.2677f, 29.7619f, 26.2292f)
                curveTo(29.8414f, 26.1908f, 29.956f, 26.1569f, 30.1056f, 26.1281f)
                curveTo(30.3075f, 26.0902f, 30.4474f, 26.0549f, 30.5253f, 26.022f)
                verticalLineTo(25.9783f)
                curveTo(30.5253f, 25.8941f, 30.5047f, 25.8342f, 30.4635f, 25.7983f)
                curveTo(30.4222f, 25.7625f, 30.3445f, 25.7446f, 30.2301f, 25.7446f)
                curveTo(30.1528f, 25.7446f, 30.0926f, 25.7599f, 30.0493f, 25.7902f)
                curveTo(30.0059f, 25.8207f, 29.9709f, 25.8741f, 29.9443f, 25.9504f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(31.2613f, 25.4539f)
                horizontalLineTo(31.7216f)
                lineTo(32.1129f, 26.6128f)
                lineTo(32.4951f, 25.4539f)
                horizontalLineTo(32.9421f)
                lineTo(32.2621f, 27.312f)
                curveTo(32.224f, 27.4076f, 32.1878f, 27.4804f, 32.1535f, 27.5308f)
                curveTo(32.1192f, 27.581f, 32.0795f, 27.622f, 32.0349f, 27.6532f)
                curveTo(31.9901f, 27.6845f, 31.9355f, 27.7091f, 31.8703f, 27.7264f)
                curveTo(31.805f, 27.7441f, 31.7314f, 27.7528f, 31.6493f, 27.7528f)
                curveTo(31.5662f, 27.7528f, 31.4843f, 27.7441f, 31.4044f, 27.7266f)
                lineTo(31.364f, 27.3881f)
                curveTo(31.432f, 27.4017f, 31.4935f, 27.4083f, 31.548f, 27.4083f)
                curveTo(31.6491f, 27.4083f, 31.7236f, 27.3784f, 31.7721f, 27.3188f)
                curveTo(31.8206f, 27.259f, 31.8577f, 27.183f, 31.8834f, 27.0909f)
                lineTo(31.2613f, 25.4539f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(33.2803f, 25.4539f)
                horizontalLineTo(33.6781f)
                verticalLineTo(25.6769f)
                curveTo(33.821f, 25.5014f, 33.9911f, 25.4137f, 34.1885f, 25.4137f)
                curveTo(34.2932f, 25.4137f, 34.3842f, 25.4352f, 34.4613f, 25.4782f)
                curveTo(34.5384f, 25.5215f, 34.6016f, 25.5867f, 34.6508f, 25.6739f)
                curveTo(34.7226f, 25.5867f, 34.8003f, 25.5215f, 34.8833f, 25.4782f)
                curveTo(34.9665f, 25.4352f, 35.055f, 25.4137f, 35.1495f, 25.4137f)
                curveTo(35.2696f, 25.4137f, 35.3712f, 25.438f, 35.4543f, 25.487f)
                curveTo(35.5374f, 25.5355f, 35.5996f, 25.6072f, 35.6407f, 25.7018f)
                curveTo(35.6703f, 25.7715f, 35.6852f, 25.8844f, 35.6852f, 26.0406f)
                verticalLineTo(27.0863f)
                horizontalLineTo(35.2516f)
                verticalLineTo(26.1513f)
                curveTo(35.2516f, 25.989f, 35.2367f, 25.8844f, 35.2071f, 25.8372f)
                curveTo(35.1671f, 25.7754f, 35.1057f, 25.7446f, 35.0229f, 25.7446f)
                curveTo(34.9624f, 25.7446f, 34.9054f, 25.7631f, 34.8522f, 25.8001f)
                curveTo(34.799f, 25.8372f, 34.7607f, 25.8913f, 34.7372f, 25.9627f)
                curveTo(34.7136f, 26.034f, 34.7017f, 26.1468f, 34.7017f, 26.3007f)
                verticalLineTo(27.0863f)
                horizontalLineTo(34.2682f)
                verticalLineTo(26.19f)
                curveTo(34.2682f, 26.0305f, 34.2606f, 25.9281f, 34.2451f, 25.8817f)
                curveTo(34.2298f, 25.8355f, 34.2061f, 25.8011f, 34.1737f, 25.7785f)
                curveTo(34.1414f, 25.756f, 34.0978f, 25.7446f, 34.0424f, 25.7446f)
                curveTo(33.9759f, 25.7446f, 33.916f, 25.7626f, 33.8628f, 25.7985f)
                curveTo(33.8095f, 25.8345f, 33.7715f, 25.8864f, 33.7483f, 25.9541f)
                curveTo(33.7253f, 26.022f, 33.7138f, 26.1343f, 33.7138f, 26.2914f)
                verticalLineTo(27.0863f)
                horizontalLineTo(33.2803f)
                verticalLineTo(25.4539f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(37.1787f, 26.1337f)
                curveTo(37.1756f, 26.0066f, 37.1432f, 25.9102f, 37.0812f, 25.8439f)
                curveTo(37.0195f, 25.7778f, 36.9441f, 25.7446f, 36.8554f, 25.7446f)
                curveTo(36.7607f, 25.7446f, 36.6822f, 25.7797f, 36.6206f, 25.8494f)
                curveTo(36.5586f, 25.9191f, 36.5283f, 26.0139f, 36.5293f, 26.1337f)
                horizontalLineTo(37.1787f)
                close()
                moveTo(37.1564f, 26.5721f)
                lineTo(37.5855f, 26.6437f)
                curveTo(37.5299f, 26.801f, 37.4424f, 26.9209f, 37.3226f, 27.0032f)
                curveTo(37.2028f, 27.0856f, 37.053f, 27.1267f, 36.873f, 27.1267f)
                curveTo(36.5884f, 27.1267f, 36.3777f, 27.0335f, 36.2409f, 26.8473f)
                curveTo(36.1329f, 26.6982f, 36.079f, 26.51f, 36.079f, 26.2824f)
                curveTo(36.079f, 26.0111f, 36.1501f, 25.7983f, 36.2917f, 25.6444f)
                curveTo(36.4336f, 25.4906f, 36.6127f, 25.4137f, 36.8295f, 25.4137f)
                curveTo(37.0732f, 25.4137f, 37.2651f, 25.4944f, 37.4059f, 25.6557f)
                curveTo(37.5466f, 25.8173f, 37.614f, 26.0645f, 37.6079f, 26.3976f)
                horizontalLineTo(36.5216f)
                curveTo(36.5247f, 26.5262f, 36.5599f, 26.6261f, 36.6271f, 26.6976f)
                curveTo(36.6942f, 26.7689f, 36.778f, 26.8047f, 36.8786f, 26.8047f)
                curveTo(36.9468f, 26.8047f, 37.0042f, 26.7864f, 37.0507f, 26.7496f)
                curveTo(37.0975f, 26.7129f, 37.1327f, 26.6537f, 37.1564f, 26.5721f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(39.5374f, 27.0863f)
                horizontalLineTo(39.1038f)
                verticalLineTo(26.2514f)
                curveTo(39.1038f, 26.0748f, 39.0945f, 25.9606f, 39.0764f, 25.9087f)
                curveTo(39.0579f, 25.8569f, 39.028f, 25.8164f, 38.9867f, 25.7877f)
                curveTo(38.9453f, 25.759f, 38.8955f, 25.7446f, 38.8375f, 25.7446f)
                curveTo(38.7631f, 25.7446f, 38.6961f, 25.7652f, 38.6371f, 25.8063f)
                curveTo(38.5778f, 25.8473f, 38.5374f, 25.9017f, 38.5153f, 25.9696f)
                curveTo(38.4934f, 26.0373f, 38.4824f, 26.1625f, 38.4824f, 26.3454f)
                verticalLineTo(27.0863f)
                horizontalLineTo(38.0489f)
                verticalLineTo(25.4539f)
                horizontalLineTo(38.4511f)
                verticalLineTo(25.6938f)
                curveTo(38.5936f, 25.507f, 38.7728f, 25.4137f, 38.9888f, 25.4137f)
                curveTo(39.0841f, 25.4137f, 39.1713f, 25.431f, 39.25f, 25.4654f)
                curveTo(39.3288f, 25.4997f, 39.3886f, 25.5436f, 39.4291f, 25.597f)
                curveTo(39.4696f, 25.6504f, 39.4976f, 25.711f, 39.5135f, 25.7788f)
                curveTo(39.5295f, 25.8465f, 39.5374f, 25.9435f, 39.5374f, 26.0698f)
                verticalLineTo(27.0863f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(40.8167f, 25.4539f)
                verticalLineTo(25.7983f)
                horizontalLineTo(40.5216f)
                verticalLineTo(26.4587f)
                curveTo(40.5216f, 26.5924f, 40.5243f, 26.6704f, 40.5299f, 26.6925f)
                curveTo(40.5353f, 26.7146f, 40.5479f, 26.7328f, 40.5675f, 26.7473f)
                curveTo(40.5872f, 26.7616f, 40.611f, 26.7689f, 40.6391f, 26.7689f)
                curveTo(40.6786f, 26.7689f, 40.7353f, 26.755f, 40.8099f, 26.7274f)
                lineTo(40.8478f, 27.062f)
                curveTo(40.7479f, 27.1051f, 40.6347f, 27.1267f, 40.5084f, 27.1267f)
                curveTo(40.4307f, 27.1267f, 40.3611f, 27.1135f, 40.2988f, 27.0873f)
                curveTo(40.2368f, 27.0613f, 40.1911f, 27.0272f, 40.1619f, 26.9856f)
                curveTo(40.1329f, 26.9441f, 40.1129f, 26.8878f, 40.1017f, 26.817f)
                curveTo(40.0924f, 26.7666f, 40.088f, 26.6648f, 40.088f, 26.5118f)
                verticalLineTo(25.7983f)
                horizontalLineTo(39.8913f)
                verticalLineTo(25.4539f)
                horizontalLineTo(40.088f)
                verticalLineTo(25.1275f)
                lineTo(40.5216f, 24.8726f)
                verticalLineTo(25.4539f)
                horizontalLineTo(40.8167f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(41.0606f, 26.6258f)
                lineTo(41.4942f, 26.5587f)
                curveTo(41.5126f, 26.6421f, 41.5499f, 26.7053f, 41.6062f, 26.7487f)
                curveTo(41.6625f, 26.7921f, 41.7412f, 26.8135f, 41.8425f, 26.8135f)
                curveTo(41.9542f, 26.8135f, 42.0382f, 26.7929f, 42.0944f, 26.7517f)
                curveTo(42.1323f, 26.7227f, 42.1513f, 26.6842f, 42.1513f, 26.6355f)
                curveTo(42.1513f, 26.6026f, 42.1409f, 26.5751f, 42.1203f, 26.5536f)
                curveTo(42.0985f, 26.5329f, 42.0502f, 26.5139f, 41.9749f, 26.4963f)
                curveTo(41.6246f, 26.4188f, 41.4025f, 26.3483f, 41.3089f, 26.2846f)
                curveTo(41.179f, 26.1963f, 41.1142f, 26.0733f, 41.1142f, 25.9163f)
                curveTo(41.1142f, 25.7744f, 41.1702f, 25.6551f, 41.2824f, 25.5587f)
                curveTo(41.3949f, 25.4621f, 41.569f, 25.4137f, 41.8048f, 25.4137f)
                curveTo(42.0294f, 25.4137f, 42.1962f, 25.4499f, 42.3055f, 25.5222f)
                curveTo(42.4147f, 25.5946f, 42.4899f, 25.7015f, 42.5312f, 25.8431f)
                lineTo(42.1244f, 25.9191f)
                curveTo(42.1068f, 25.8556f, 42.0733f, 25.8068f, 42.0241f, 25.7731f)
                curveTo(41.9748f, 25.7391f, 41.9046f, 25.7223f, 41.8134f, 25.7223f)
                curveTo(41.6984f, 25.7223f, 41.6159f, 25.7381f, 41.5662f, 25.7703f)
                curveTo(41.5329f, 25.793f, 41.5165f, 25.8223f, 41.5165f, 25.8584f)
                curveTo(41.5165f, 25.8894f, 41.5308f, 25.9158f, 41.5597f, 25.9375f)
                curveTo(41.5987f, 25.9663f, 41.7339f, 26.0071f, 41.9649f, 26.0597f)
                curveTo(42.1959f, 26.1124f, 42.3573f, 26.1768f, 42.449f, 26.2531f)
                curveTo(42.5394f, 26.3304f, 42.5849f, 26.4381f, 42.5849f, 26.5763f)
                curveTo(42.5849f, 26.7267f, 42.5222f, 26.8561f, 42.3973f, 26.9643f)
                curveTo(42.2722f, 27.0726f, 42.0874f, 27.1267f, 41.8425f, 27.1267f)
                curveTo(41.6203f, 27.1267f, 41.4444f, 27.0816f, 41.3148f, 26.9919f)
                curveTo(41.1852f, 26.9019f, 41.1005f, 26.7801f, 41.0606f, 26.6258f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(45.2236f, 26.1964f)
                lineTo(44.9087f, 25.36f)
                lineTo(44.6043f, 26.1964f)
                horizontalLineTo(45.2236f)
                close()
                moveTo(46.0598f, 27.0863f)
                horizontalLineTo(45.5688f)
                lineTo(45.374f, 26.5765f)
                horizontalLineTo(44.4659f)
                lineTo(44.2803f, 27.0863f)
                horizontalLineTo(43.7978f)
                lineTo(44.6705f, 24.8322f)
                horizontalLineTo(45.15f)
                lineTo(46.0598f, 27.0863f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(46.8042f, 27.0863f)
                horizontalLineTo(46.3706f)
                verticalLineTo(25.4539f)
                horizontalLineTo(46.7729f)
                verticalLineTo(25.6861f)
                curveTo(46.8417f, 25.5764f, 46.9033f, 25.5037f, 46.9584f, 25.4677f)
                curveTo(47.0132f, 25.4317f, 47.0754f, 25.4137f, 47.1453f, 25.4137f)
                curveTo(47.2438f, 25.4137f, 47.3386f, 25.441f, 47.43f, 25.4956f)
                lineTo(47.2981f, 25.8735f)
                curveTo(47.225f, 25.8265f, 47.1571f, 25.8028f, 47.0944f, 25.8028f)
                curveTo(47.0335f, 25.8028f, 46.9821f, 25.8196f, 46.9399f, 25.8528f)
                curveTo(46.8977f, 25.8863f, 46.8645f, 25.9465f, 46.8405f, 26.0337f)
                curveTo(46.8162f, 26.1208f, 46.8042f, 26.3036f, 46.8042f, 26.5815f)
                verticalLineTo(27.0863f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(48.6821f, 26.1337f)
                curveTo(48.6789f, 26.0066f, 48.6465f, 25.9102f, 48.5847f, 25.8439f)
                curveTo(48.5227f, 25.7778f, 48.4475f, 25.7446f, 48.3589f, 25.7446f)
                curveTo(48.264f, 25.7446f, 48.1857f, 25.7797f, 48.1239f, 25.8494f)
                curveTo(48.062f, 25.9191f, 48.0315f, 26.0139f, 48.0326f, 26.1337f)
                horizontalLineTo(48.6821f)
                close()
                moveTo(48.6598f, 26.5721f)
                lineTo(49.0889f, 26.6437f)
                curveTo(49.0334f, 26.801f, 48.9457f, 26.9209f, 48.826f, 27.0032f)
                curveTo(48.7063f, 27.0856f, 48.5563f, 27.1267f, 48.3765f, 27.1267f)
                curveTo(48.0917f, 27.1267f, 47.8809f, 27.0335f, 47.7443f, 26.8473f)
                curveTo(47.6363f, 26.6982f, 47.5823f, 26.51f, 47.5823f, 26.2824f)
                curveTo(47.5823f, 26.0111f, 47.6533f, 25.7983f, 47.7952f, 25.6444f)
                curveTo(47.9368f, 25.4906f, 48.1162f, 25.4137f, 48.3329f, 25.4137f)
                curveTo(48.5764f, 25.4137f, 48.7685f, 25.4944f, 48.9094f, 25.6557f)
                curveTo(49.05f, 25.8173f, 49.1174f, 26.0645f, 49.1112f, 26.3976f)
                horizontalLineTo(48.0249f)
                curveTo(48.0281f, 26.5262f, 48.0633f, 26.6261f, 48.1303f, 26.6976f)
                curveTo(48.1977f, 26.7689f, 48.2815f, 26.8047f, 48.3818f, 26.8047f)
                curveTo(48.4502f, 26.8047f, 48.5076f, 26.7864f, 48.5542f, 26.7496f)
                curveTo(48.6007f, 26.7129f, 48.6359f, 26.6537f, 48.6598f, 26.5721f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(50.4551f, 26.3038f)
                curveTo(50.3999f, 26.3224f, 50.3124f, 26.3444f, 50.1928f, 26.3702f)
                curveTo(50.0732f, 26.3958f, 49.9951f, 26.4211f, 49.9583f, 26.4457f)
                curveTo(49.902f, 26.4859f, 49.8741f, 26.5369f, 49.8741f, 26.5986f)
                curveTo(49.8741f, 26.6594f, 49.8964f, 26.7118f, 49.9415f, 26.7562f)
                curveTo(49.9864f, 26.8004f, 50.0436f, 26.8226f, 50.1133f, 26.8226f)
                curveTo(50.1909f, 26.8226f, 50.2649f, 26.7968f, 50.3356f, 26.7454f)
                curveTo(50.3876f, 26.7062f, 50.422f, 26.6584f, 50.4383f, 26.6017f)
                curveTo(50.4494f, 26.5647f, 50.4551f, 26.4941f, 50.4551f, 26.3901f)
                verticalLineTo(26.3038f)
                close()
                moveTo(49.8741f, 25.9504f)
                lineTo(49.4852f, 25.8788f)
                curveTo(49.5292f, 25.7207f, 49.605f, 25.6038f, 49.7126f, 25.5278f)
                curveTo(49.8203f, 25.4518f, 49.9802f, 25.4137f, 50.1924f, 25.4137f)
                curveTo(50.3851f, 25.4137f, 50.5287f, 25.4366f, 50.6229f, 25.4821f)
                curveTo(50.7172f, 25.528f, 50.7837f, 25.586f, 50.8221f, 25.6563f)
                curveTo(50.8605f, 25.7266f, 50.8799f, 25.8558f, 50.8799f, 26.0437f)
                lineTo(50.8754f, 26.5489f)
                curveTo(50.8754f, 26.6926f, 50.8823f, 26.7988f, 50.896f, 26.8669f)
                curveTo(50.9099f, 26.9352f, 50.9358f, 27.0083f, 50.9735f, 27.0863f)
                horizontalLineTo(50.5446f)
                curveTo(50.5331f, 27.0581f, 50.5195f, 27.0162f, 50.5029f, 26.9607f)
                curveTo(50.4959f, 26.9353f, 50.4906f, 26.9187f, 50.4878f, 26.9106f)
                curveTo(50.414f, 26.9826f, 50.3353f, 27.0367f, 50.2513f, 27.0727f)
                curveTo(50.1673f, 27.1087f, 50.0778f, 27.1267f, 49.9825f, 27.1267f)
                curveTo(49.8146f, 27.1267f, 49.6821f, 27.0809f, 49.5854f, 26.9896f)
                curveTo(49.4889f, 26.8981f, 49.4405f, 26.7825f, 49.4405f, 26.6428f)
                curveTo(49.4405f, 26.5505f, 49.4624f, 26.4681f, 49.5065f, 26.3956f)
                curveTo(49.5505f, 26.3232f, 49.6123f, 26.2677f, 49.6917f, 26.2292f)
                curveTo(49.7712f, 26.1908f, 49.8858f, 26.1569f, 50.0355f, 26.1281f)
                curveTo(50.2373f, 26.0902f, 50.3772f, 26.0549f, 50.4551f, 26.022f)
                verticalLineTo(25.9783f)
                curveTo(50.4551f, 25.8941f, 50.4346f, 25.8342f, 50.3934f, 25.7983f)
                curveTo(50.3522f, 25.7625f, 50.2743f, 25.7446f, 50.1599f, 25.7446f)
                curveTo(50.0827f, 25.7446f, 50.0224f, 25.7599f, 49.9791f, 25.7902f)
                curveTo(49.9359f, 25.8207f, 49.9007f, 25.8741f, 49.8741f, 25.9504f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(17.3991f, 15.9749f)
                horizontalLineTo(14.4469f)
                curveTo(14.4469f, 15.4902f, 14.39f, 15.1649f, 14.2767f, 14.9993f)
                curveTo(14.101f, 14.7543f, 13.6161f, 14.6316f, 12.8225f, 14.6316f)
                curveTo(12.0518f, 14.6316f, 11.5408f, 14.7022f, 11.2915f, 14.8434f)
                curveTo(11.0423f, 14.9851f, 10.9176f, 15.2933f, 10.9176f, 15.7677f)
                curveTo(10.9176f, 16.1972f, 11.028f, 16.48f, 11.2494f, 16.6155f)
                curveTo(11.4081f, 16.7117f, 11.6176f, 16.7683f, 11.879f, 16.7851f)
                lineTo(12.4743f, 16.8272f)
                curveTo(13.7503f, 16.9119f, 14.5472f, 16.9716f, 14.8651f, 17.0055f)
                curveTo(15.8741f, 17.1073f, 16.6056f, 17.3758f, 17.0595f, 17.8109f)
                curveTo(17.4167f, 18.1504f, 17.6297f, 18.594f, 17.6977f, 19.1419f)
                curveTo(17.7374f, 19.4696f, 17.7572f, 19.8405f, 17.7572f, 20.2525f)
                curveTo(17.7572f, 21.2022f, 17.6666f, 21.8978f, 17.4852f, 22.3386f)
                curveTo(17.1565f, 23.1474f, 16.4181f, 23.6582f, 15.2692f, 23.8727f)
                curveTo(14.7878f, 23.9634f, 14.0514f, 24.0088f, 13.061f, 24.0088f)
                curveTo(11.4076f, 24.0088f, 10.2554f, 23.9103f, 9.6048f, 23.7124f)
                curveTo(8.8063f, 23.47f, 8.2799f, 22.9788f, 8.0252f, 22.2391f)
                curveTo(7.8833f, 21.8274f, 7.813f, 21.1417f, 7.813f, 20.1818f)
                horizontalLineTo(10.7652f)
                curveTo(10.7652f, 20.2888f, 10.7655f, 20.3707f, 10.7655f, 20.4271f)
                curveTo(10.7655f, 20.9393f, 10.9127f, 21.2688f, 11.2064f, 21.4155f)
                curveTo(11.4099f, 21.5167f, 11.6557f, 21.5698f, 11.9446f, 21.5761f)
                horizontalLineTo(13.0299f)
                curveTo(13.5838f, 21.5761f, 13.9373f, 21.5477f, 14.0897f, 21.4908f)
                curveTo(14.3611f, 21.384f, 14.5392f, 21.2121f, 14.6243f, 20.9742f)
                curveTo(14.6695f, 20.8278f, 14.692f, 20.6383f, 14.692f, 20.4065f)
                curveTo(14.692f, 19.8871f, 14.5024f, 19.5711f, 14.1241f, 19.4578f)
                curveTo(13.9826f, 19.413f, 13.3243f, 19.3506f, 12.1493f, 19.2714f)
                curveTo(11.2058f, 19.204f, 10.5504f, 19.1392f, 10.1833f, 19.0763f)
                curveTo(9.2167f, 18.8954f, 8.5726f, 18.5235f, 8.2512f, 17.9587f)
                curveTo(7.9686f, 17.4788f, 7.8273f, 16.7528f, 7.8273f, 15.7816f)
                curveTo(7.8273f, 15.042f, 7.9037f, 14.4489f, 8.0563f, 14.0028f)
                curveTo(8.2091f, 13.5565f, 8.4553f, 13.2178f, 8.795f, 12.986f)
                curveTo(9.2927f, 12.6304f, 9.9295f, 12.4216f, 10.7047f, 12.3592f)
                curveTo(11.3497f, 12.3029f, 12.0652f, 12.2742f, 12.8523f, 12.2742f)
                curveTo(14.0913f, 12.2742f, 14.9743f, 12.3454f, 15.5008f, 12.4867f)
                curveTo(16.7855f, 12.832f, 17.4277f, 13.7994f, 17.4277f, 15.389f)
                curveTo(17.4277f, 15.5194f, 17.4182f, 15.7143f, 17.3991f, 15.9749f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(33.5548f, 18.2264f)
                horizontalLineTo(35.5331f)
                curveTo(36.1604f, 18.2038f, 36.5419f, 18.1555f, 36.6792f, 18.08f)
                curveTo(36.8667f, 17.9768f, 36.9926f, 17.7703f, 37.0553f, 17.4604f)
                curveTo(37.0953f, 17.2542f, 37.1153f, 16.9476f, 37.1153f, 16.5403f)
                curveTo(37.1153f, 16.0414f, 37.0756f, 15.6716f, 36.9956f, 15.43f)
                curveTo(36.8815f, 15.0916f, 36.6081f, 14.8855f, 36.1751f, 14.8107f)
                curveTo(36.0896f, 14.7994f, 35.8846f, 14.7934f, 35.5599f, 14.7934f)
                horizontalLineTo(33.5548f)
                verticalLineTo(18.2264f)
                close()
                moveTo(30.3814f, 24.0088f)
                verticalLineTo(12.2118f)
                horizontalLineTo(36.2937f)
                curveTo(37.1046f, 12.2118f, 37.7234f, 12.2781f, 38.1486f, 12.4104f)
                curveTo(39.121f, 12.7153f, 39.7734f, 13.3394f, 40.1076f, 14.2827f)
                curveTo(40.2801f, 14.7778f, 40.3664f, 15.5231f, 40.3664f, 16.5184f)
                curveTo(40.3664f, 17.715f, 40.2707f, 18.575f, 40.0814f, 19.0985f)
                curveTo(39.7022f, 20.1339f, 38.9216f, 20.7303f, 37.7429f, 20.8848f)
                curveTo(37.6043f, 20.908f, 37.0145f, 20.9288f, 35.9736f, 20.9454f)
                lineTo(35.4467f, 20.963f)
                horizontalLineTo(33.5548f)
                verticalLineTo(24.0088f)
                horizontalLineTo(30.3814f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0B4A8E)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(46.5101f, 19.6717f)
                lineTo(45.0232f, 14.5579f)
                lineTo(43.5803f, 19.6717f)
                horizontalLineTo(46.5101f)
                close()
                moveTo(47.1403f, 21.9699f)
                horizontalLineTo(42.8974f)
                lineTo(42.3274f, 24.0088f)
                horizontalLineTo(39.0442f)
                lineTo(42.5869f, 12.2118f)
                horizontalLineTo(47.3738f)
                lineTo(50.96f, 24.0088f)
                horizontalLineTo(47.7457f)
                lineTo(47.1403f, 21.9699f)
                close()
            }
            path(fill = SolidColor(Color(0xFFF6BC25)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(26.0015f, 13.8716f)
                curveTo(27.3104f, 13.8716f, 28.4785f, 14.4748f, 29.2464f, 15.4197f)
                lineTo(29.9304f, 13.9523f)
                curveTo(28.8606f, 12.9406f, 27.4045f, 12.3169f, 25.7985f, 12.3169f)
                curveTo(23.2981f, 12.3169f, 21.1591f, 13.8278f, 20.2812f, 15.9666f)
                horizontalLineTo(18.9473f)
                lineTo(18.1597f, 17.656f)
                horizontalLineTo(19.8757f)
                curveTo(19.8628f, 17.8127f, 19.8545f, 17.9695f, 19.8545f, 18.1295f)
                curveTo(19.8545f, 18.3232f, 19.8645f, 18.5145f, 19.8837f, 18.7036f)
                horizontalLineTo(19.0213f)
                lineTo(18.2338f, 20.3935f)
                horizontalLineTo(20.3221f)
                curveTo(21.225f, 22.4782f, 23.3373f, 23.9418f, 25.7985f, 23.9418f)
                curveTo(27.0389f, 23.9418f, 28.1898f, 23.5699f, 29.1428f, 22.9348f)
                verticalLineTo(20.8637f)
                curveTo(28.3754f, 21.7379f, 27.2529f, 22.2903f, 26.0015f, 22.2903f)
                curveTo(24.5387f, 22.2903f, 23.252f, 21.5356f, 22.5027f, 20.3935f)
                horizontalLineTo(26.8758f)
                lineTo(27.6633f, 18.7036f)
                horizontalLineTo(21.8593f)
                curveTo(21.8294f, 18.5002f, 21.8134f, 18.2924f, 21.8134f, 18.0807f)
                curveTo(21.8134f, 17.9376f, 21.8208f, 17.7959f, 21.8346f, 17.656f)
                horizontalLineTo(28.1513f)
                lineTo(28.9388f, 15.9666f)
                horizontalLineTo(22.3809f)
                curveTo(23.1061f, 14.7143f, 24.4557f, 13.8716f, 26.0015f, 13.8716f)
                close()
            }
        }
        .build()
        return _sepa!!
    }

private var _sepa: ImageVector? = null
