package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.Przelewy24: ImageVector
    get() {
        if (_przelewy24 != null) {
            return _przelewy24!!
        }
        _przelewy24 = Builder(name = "Przelewy24", defaultWidth = 58.0.dp, defaultHeight = 40.0.dp,
                viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFFD13239)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(9.5328f, 19.7844f)
                curveTo(9.6732f, 19.8416f, 9.8006f, 19.9144f, 9.889f, 20.008f)
                curveTo(9.9566f, 20.0782f, 10.0086f, 20.151f, 10.0528f, 20.2316f)
                curveTo(10.1776f, 20.4604f, 10.201f, 20.6996f, 10.1984f, 20.8582f)
                curveTo(10.1984f, 20.9726f, 10.1828f, 21.0454f, 10.1828f, 21.0454f)
                curveTo(10.1828f, 21.0454f, 10.175f, 21.1078f, 10.162f, 21.2066f)
                curveTo(10.1308f, 21.4328f, 10.071f, 21.8592f, 10.0112f, 22.2154f)
                curveTo(9.9566f, 22.5378f, 9.8916f, 22.803f, 9.8916f, 22.803f)
                curveTo(9.8916f, 22.803f, 9.733f, 23.518f, 9.1402f, 23.8326f)
                curveTo(8.5474f, 24.1472f, 7.7102f, 24.1134f, 7.7102f, 24.1134f)
                lineTo(5.5626f, 24.103f)
                lineTo(5.1258f, 26.755f)
                horizontalLineTo(4.0182f)
                lineTo(5.2038f, 19.5946f)
                horizontalLineTo(6.5272f)
                horizontalLineTo(8.3056f)
                curveTo(8.3056f, 19.5946f, 8.3888f, 19.5946f, 8.5188f, 19.5998f)
                curveTo(8.6592f, 19.605f, 8.8568f, 19.6206f, 9.0596f, 19.657f)
                curveTo(9.2208f, 19.6856f, 9.3846f, 19.7272f, 9.5328f, 19.7844f)
                close()
                moveTo(8.8074f, 22.5404f)
                curveTo(8.9374f, 21.8592f, 9.0362f, 21.2846f, 9.0362f, 21.2716f)
                curveTo(9.0362f, 21.2703f, 9.0367f, 21.2665f, 9.0375f, 21.2606f)
                lineTo(9.0375f, 21.2605f)
                lineTo(9.0375f, 21.2605f)
                lineTo(9.0375f, 21.2605f)
                curveTo(9.0415f, 21.2309f, 9.0526f, 21.1484f, 9.044f, 21.0532f)
                curveTo(9.0362f, 20.9752f, 9.0154f, 20.8868f, 8.9608f, 20.8192f)
                curveTo(8.9192f, 20.7672f, 8.7892f, 20.7334f, 8.6254f, 20.7126f)
                curveTo(8.4356f, 20.6866f, 8.2042f, 20.6788f, 8.03f, 20.6762f)
                curveTo(7.8766f, 20.6736f, 7.7674f, 20.6762f, 7.7674f, 20.6762f)
                lineTo(6.1424f, 20.671f)
                lineTo(5.7472f, 23.05f)
                lineTo(7.5412f, 23.0552f)
                curveTo(7.5412f, 23.0552f, 7.9494f, 23.0708f, 8.329f, 22.9902f)
                curveTo(8.5578f, 22.9408f, 8.758f, 22.8004f, 8.8074f, 22.5404f)
                close()
                moveTo(18.404f, 21.5862f)
                lineTo(14.3376f, 21.5914f)
                lineTo(14.1738f, 22.6002f)
                horizontalLineTo(16.7764f)
                lineTo(13.516f, 25.7228f)
                lineTo(13.3392f, 26.755f)
                lineTo(17.5434f, 26.7524f)
                lineTo(17.7098f, 25.754f)
                lineTo(14.855f, 25.7592f)
                lineTo(18.2558f, 22.5118f)
                lineTo(18.404f, 21.5862f)
                close()
                moveTo(23.9186f, 19.5946f)
                horizontalLineTo(24.9846f)
                lineTo(23.7912f, 26.755f)
                lineTo(22.7226f, 26.7524f)
                lineTo(23.9186f, 19.5946f)
                close()
                moveTo(30.6292f, 21.5888f)
                lineTo(29.6074f, 21.5914f)
                lineTo(30.1274f, 26.755f)
                lineTo(31.365f, 26.7498f)
                lineTo(32.9536f, 23.1358f)
                lineTo(33.3176f, 26.7498f)
                horizontalLineTo(34.576f)
                lineTo(36.8276f, 21.5888f)
                horizontalLineTo(35.7668f)
                lineTo(34.1964f, 25.2366f)
                lineTo(33.8246f, 21.5862f)
                lineTo(32.5636f, 21.5836f)
                lineTo(30.9906f, 25.2236f)
                lineTo(30.6292f, 21.5888f)
                close()
                moveTo(20.6946f, 21.5212f)
                curveTo(21.134f, 21.516f, 21.6514f, 21.5368f, 21.9504f, 21.633f)
                curveTo(22.8396f, 21.9242f, 22.9618f, 22.6652f, 22.7902f, 23.6376f)
                lineTo(22.642f, 24.4956f)
                lineTo(19.171f, 24.506f)
                curveTo(19.171f, 24.506f, 19.1034f, 24.6646f, 19.0748f, 25.273f)
                curveTo(19.0722f, 25.2886f, 19.0722f, 25.299f, 19.0722f, 25.3068f)
                curveTo(19.0238f, 25.8048f, 19.5733f, 25.815f, 19.7427f, 25.8182f)
                curveTo(19.7555f, 25.8184f, 19.7662f, 25.8186f, 19.7742f, 25.819f)
                lineTo(19.8092f, 25.8208f)
                curveTo(19.9487f, 25.828f, 20.2626f, 25.8443f, 20.8064f, 25.7826f)
                curveTo(21.4044f, 25.715f, 21.4642f, 24.9844f, 21.4642f, 24.9844f)
                lineTo(22.5692f, 24.9818f)
                lineTo(22.5016f, 25.26f)
                lineTo(22.4999f, 25.267f)
                curveTo(22.491f, 25.3055f, 22.4545f, 25.462f, 22.3534f, 25.6786f)
                curveTo(22.2442f, 25.9126f, 22.0908f, 26.1102f, 22.0908f, 26.1102f)
                curveTo(22.0908f, 26.1102f, 21.7476f, 26.5678f, 21.0976f, 26.7212f)
                curveTo(20.4476f, 26.8746f, 19.5844f, 26.807f, 19.5844f, 26.807f)
                curveTo(19.5844f, 26.807f, 19.1736f, 26.8174f, 18.69f, 26.6302f)
                curveTo(18.2064f, 26.4456f, 18.0738f, 26.0478f, 17.9984f, 25.6214f)
                curveTo(17.923f, 25.1924f, 18.1778f, 23.9106f, 18.1778f, 23.9106f)
                curveTo(18.1778f, 23.9106f, 18.3052f, 22.751f, 18.7342f, 22.2206f)
                curveTo(19.1632f, 21.6902f, 19.9172f, 21.581f, 19.9172f, 21.581f)
                curveTo(20.0758f, 21.5472f, 20.2708f, 21.5264f, 20.6946f, 21.5212f)
                close()
                moveTo(19.34f, 23.5128f)
                lineTo(21.719f, 23.5154f)
                curveTo(21.719f, 23.5154f, 21.8074f, 23.089f, 21.7242f, 22.8082f)
                curveTo(21.6878f, 22.6886f, 21.5526f, 22.608f, 21.4096f, 22.5794f)
                curveTo(20.9806f, 22.491f, 20.4528f, 22.53f, 20.2552f, 22.5482f)
                curveTo(20.0576f, 22.5664f, 19.847f, 22.5898f, 19.6806f, 22.7146f)
                curveTo(19.5168f, 22.8394f, 19.4336f, 23.1358f, 19.4336f, 23.1358f)
                lineTo(19.34f, 23.5128f)
                close()
                moveTo(28.4998f, 21.6356f)
                curveTo(28.2008f, 21.5394f, 27.6834f, 21.5186f, 27.244f, 21.5238f)
                curveTo(26.8202f, 21.529f, 26.6252f, 21.5498f, 26.4666f, 21.5836f)
                curveTo(26.4666f, 21.5836f, 25.7126f, 21.6928f, 25.2836f, 22.2232f)
                curveTo(24.8546f, 22.7536f, 24.7272f, 23.9132f, 24.7272f, 23.9132f)
                curveTo(24.7272f, 23.9132f, 24.4724f, 25.195f, 24.5478f, 25.624f)
                curveTo(24.6232f, 26.0504f, 24.7558f, 26.4482f, 25.2394f, 26.6328f)
                curveTo(25.723f, 26.82f, 26.1338f, 26.8096f, 26.1338f, 26.8096f)
                curveTo(26.1338f, 26.8096f, 26.997f, 26.8772f, 27.647f, 26.7238f)
                curveTo(28.297f, 26.5704f, 28.6402f, 26.1128f, 28.6402f, 26.1128f)
                curveTo(28.6402f, 26.1128f, 28.7936f, 25.9152f, 28.9028f, 25.6812f)
                curveTo(29.0039f, 25.4646f, 29.0404f, 25.3081f, 29.0493f, 25.2696f)
                lineTo(29.051f, 25.2626f)
                lineTo(29.1186f, 24.9844f)
                lineTo(28.0136f, 24.987f)
                curveTo(28.0136f, 24.987f, 27.9538f, 25.7176f, 27.3558f, 25.7852f)
                curveTo(26.8371f, 25.8441f, 26.5276f, 25.832f, 26.3791f, 25.8261f)
                curveTo(26.3571f, 25.8253f, 26.3387f, 25.8245f, 26.3236f, 25.8242f)
                curveTo(26.3158f, 25.8239f, 26.3056f, 25.8236f, 26.2934f, 25.8234f)
                lineTo(26.2933f, 25.8234f)
                lineTo(26.2932f, 25.8234f)
                curveTo(26.1252f, 25.82f, 25.5731f, 25.8087f, 25.6216f, 25.312f)
                curveTo(25.6216f, 25.3042f, 25.6216f, 25.2938f, 25.6242f, 25.2782f)
                curveTo(25.6528f, 24.6698f, 25.7204f, 24.5112f, 25.7204f, 24.5112f)
                lineTo(29.1914f, 24.5008f)
                lineTo(29.3396f, 23.6428f)
                curveTo(29.5112f, 22.6678f, 29.389f, 21.9242f, 28.4998f, 21.6356f)
                close()
                moveTo(28.258f, 23.5154f)
                lineTo(25.879f, 23.5128f)
                lineTo(25.9726f, 23.1358f)
                curveTo(25.9726f, 23.1358f, 26.0558f, 22.8394f, 26.2196f, 22.7146f)
                curveTo(26.3834f, 22.5898f, 26.5966f, 22.5664f, 26.7942f, 22.5482f)
                curveTo(26.9918f, 22.53f, 27.5196f, 22.491f, 27.9486f, 22.5794f)
                curveTo(28.0916f, 22.608f, 28.2268f, 22.6886f, 28.2632f, 22.8082f)
                curveTo(28.3464f, 23.0864f, 28.258f, 23.5154f, 28.258f, 23.5154f)
                close()
                moveTo(38.0548f, 21.5914f)
                lineTo(38.7386f, 25.3666f)
                lineTo(40.6704f, 21.5888f)
                lineTo(41.7572f, 21.5992f)
                lineTo(38.9726f, 26.9942f)
                curveTo(38.9726f, 26.9942f, 38.4682f, 27.9718f, 38.1562f, 28.2188f)
                curveTo(37.8442f, 28.4658f, 37.6518f, 28.5776f, 37.397f, 28.6036f)
                lineTo(37.3287f, 28.6107f)
                curveTo(37.1213f, 28.6325f, 37.0151f, 28.6436f, 36.7938f, 28.6036f)
                lineTo(36.5338f, 28.5568f)
                lineTo(36.695f, 27.5922f)
                curveTo(36.695f, 27.5922f, 37.1266f, 27.6728f, 37.3814f, 27.5714f)
                curveTo(37.6388f, 27.47f, 37.8442f, 27.0332f, 37.8442f, 27.0332f)
                lineTo(37.9742f, 26.8148f)
                lineTo(36.968f, 21.5888f)
                lineTo(38.0548f, 21.5914f)
                close()
                moveTo(11.8f, 21.945f)
                curveTo(12.1458f, 21.7552f, 12.5514f, 21.5862f, 12.9804f, 21.5862f)
                horizontalLineTo(13.5992f)
                lineTo(13.4224f, 22.5846f)
                lineTo(12.8348f, 22.5872f)
                curveTo(11.9924f, 22.5872f, 11.5608f, 23.3022f, 11.4568f, 23.8794f)
                lineTo(10.9524f, 26.7264f)
                horizontalLineTo(9.8136f)
                lineTo(10.7236f, 21.5862f)
                horizontalLineTo(11.8598f)
                lineTo(11.8f, 21.945f)
                close()
            }
            path(fill = SolidColor(Color(0xFFB3B2B1)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(33.835f, 14.6728f)
                lineTo(35.1558f, 12.0182f)
                curveTo(35.1558f, 12.0182f, 38.0496f, 11.961f, 40.5456f, 12.3484f)
                curveTo(43.0416f, 12.7332f, 45.3244f, 13.326f, 45.275f, 13.352f)
                lineTo(38.9466f, 16.6618f)
                curveTo(38.9466f, 16.6618f, 37.4672f, 15.7258f, 35.6316f, 15.1512f)
                curveTo(34.5916f, 14.8444f, 33.835f, 14.6728f, 33.835f, 14.6728f)
                close()
                moveTo(25.4682f, 13.4248f)
                lineTo(25.7438f, 14.9718f)
                curveTo(25.7438f, 14.9718f, 27.0178f, 14.6338f, 28.544f, 14.4518f)
                curveTo(30.5044f, 14.184f, 32.5922f, 14.47f, 32.5922f, 14.47f)
                lineTo(33.3774f, 12.0806f)
                curveTo(33.3774f, 12.0806f, 31.0036f, 12.2392f, 29.2122f, 12.572f)
                curveTo(27.4234f, 12.9048f, 25.4682f, 13.4248f, 25.4682f, 13.4248f)
                close()
                moveTo(19.5766f, 17.5068f)
                lineTo(17.9932f, 16.4408f)
                curveTo(17.9932f, 16.4408f, 19.4258f, 15.627f, 21.3316f, 14.8678f)
                curveTo(23.2348f, 14.1086f, 24.2514f, 13.7914f, 24.2514f, 13.7914f)
                lineTo(24.5738f, 15.302f)
                curveTo(24.5738f, 15.302f, 22.7408f, 15.9156f, 21.6904f, 16.4122f)
                curveTo(20.6036f, 16.875f, 19.5766f, 17.5068f, 19.5766f, 17.5068f)
                close()
                moveTo(15.6532f, 20.1848f)
                horizontalLineTo(12.2394f)
                curveTo(12.2394f, 20.1848f, 13.5706f, 19.1656f, 14.2414f, 18.7262f)
                curveTo(14.933f, 18.2504f, 16.5632f, 17.2416f, 16.5632f, 17.2416f)
                lineTo(18.4924f, 18.1438f)
                curveTo(18.4924f, 18.1438f, 17.5044f, 18.7704f, 16.961f, 19.1682f)
                curveTo(16.4176f, 19.566f, 15.6532f, 20.1848f, 15.6532f, 20.1848f)
                close()
                moveTo(42.1524f, 22.1036f)
                lineTo(43.273f, 22.1062f)
                lineTo(43.3406f, 21.672f)
                curveTo(43.3406f, 21.672f, 43.4602f, 20.8868f, 43.728f, 20.736f)
                curveTo(43.8138f, 20.6866f, 43.9516f, 20.6424f, 44.1102f, 20.6138f)
                curveTo(44.404f, 20.5618f, 44.7758f, 20.5566f, 45.08f, 20.567f)
                lineTo(45.1052f, 20.5679f)
                curveTo(45.552f, 20.5828f, 45.7309f, 20.5888f, 46.1954f, 20.6424f)
                curveTo(46.6686f, 20.697f, 46.549f, 21.1546f, 46.549f, 21.1546f)
                lineTo(46.4554f, 21.8384f)
                curveTo(46.4554f, 21.8384f, 46.4138f, 22.1452f, 46.3046f, 22.335f)
                curveTo(46.2084f, 22.504f, 45.9432f, 22.6184f, 45.7898f, 22.6678f)
                curveTo(45.4206f, 22.7874f, 44.157f, 23.1098f, 44.157f, 23.1098f)
                lineTo(43.1638f, 23.3958f)
                curveTo(43.1638f, 23.3958f, 42.5528f, 23.5726f, 42.2122f, 23.9496f)
                curveTo(41.869f, 24.3292f, 41.7338f, 24.7582f, 41.687f, 24.9818f)
                curveTo(41.6402f, 25.2054f, 41.3776f, 26.7524f, 41.3776f, 26.7524f)
                lineTo(46.7388f, 26.755f)
                lineTo(46.9182f, 25.6838f)
                lineTo(42.6776f, 25.689f)
                lineTo(42.753f, 25.2522f)
                curveTo(42.753f, 25.2522f, 42.8024f, 24.8024f, 42.9844f, 24.6542f)
                curveTo(42.9932f, 24.647f, 43.0014f, 24.6394f, 43.0101f, 24.6313f)
                curveTo(43.0578f, 24.5868f, 43.1224f, 24.5266f, 43.4082f, 24.4254f)
                curveTo(43.611f, 24.3526f, 44.3026f, 24.168f, 44.3026f, 24.168f)
                lineTo(45.9016f, 23.7312f)
                curveTo(45.9016f, 23.7312f, 46.7752f, 23.5076f, 47.1184f, 23.0292f)
                curveTo(47.4616f, 22.5534f, 47.5942f, 21.6408f, 47.5942f, 21.6408f)
                curveTo(47.5942f, 21.6408f, 47.6878f, 20.7542f, 47.615f, 20.476f)
                curveTo(47.5448f, 20.1978f, 47.2822f, 19.865f, 46.9624f, 19.722f)
                curveTo(46.6426f, 19.579f, 46.3098f, 19.4958f, 45.3452f, 19.5088f)
                curveTo(44.3806f, 19.5218f, 43.9022f, 19.566f, 43.4134f, 19.748f)
                curveTo(42.9246f, 19.9274f, 42.6412f, 20.255f, 42.4618f, 20.7178f)
                curveTo(42.2668f, 21.1572f, 42.1524f, 22.1036f, 42.1524f, 22.1036f)
                close()
                moveTo(52.2456f, 24.0952f)
                lineTo(52.997f, 19.592f)
                horizontalLineTo(51.6658f)
                lineTo(47.5214f, 24.0432f)
                lineTo(47.3342f, 25.1716f)
                horizontalLineTo(50.9586f)
                lineTo(50.6934f, 26.7524f)
                lineTo(51.8062f, 26.755f)
                lineTo(52.0688f, 25.1716f)
                lineTo(53.0958f, 25.1742f)
                lineTo(53.2804f, 24.0952f)
                horizontalLineTo(52.2456f)
                close()
                moveTo(51.138f, 24.0978f)
                lineTo(48.7954f, 24.0952f)
                lineTo(51.6476f, 21.0558f)
                lineTo(51.138f, 24.0978f)
                close()
                moveTo(41.4712f, 18.4376f)
                lineTo(40.0802f, 17.382f)
                lineTo(48.005f, 14.3244f)
                lineTo(48.0663f, 14.3523f)
                curveTo(49.0752f, 14.8103f, 49.6369f, 15.0653f, 50.6258f, 15.7076f)
                curveTo(51.021f, 15.965f, 51.5462f, 16.3758f, 51.6788f, 16.5058f)
                curveTo(52.0402f, 16.8672f, 52.386f, 17.2156f, 52.5758f, 17.5432f)
                curveTo(52.88f, 18.0684f, 52.9034f, 18.4376f, 52.9034f, 18.4376f)
                horizontalLineTo(41.4712f)
                close()
            }
        }
        .build()
        return _przelewy24!!
    }

private var _przelewy24: ImageVector? = null
