package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.PaysafeCard: ImageVector
    get() {
        if (_paysafeCard != null) {
            return _paysafeCard!!
        }
        _paysafeCard = Builder(name = "PaysafeCard", defaultWidth = 58.0.dp, defaultHeight =
                40.0.dp, viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF008ACA)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(32.3786f, 17.7964f)
                curveTo(32.3855f, 17.4888f, 32.5006f, 17.2418f, 32.7261f, 17.0565f)
                curveTo(32.9448f, 16.8685f, 33.2319f, 16.7717f, 33.5871f, 16.7664f)
                horizontalLineTo(34.3016f)
                verticalLineTo(17.8673f)
                horizontalLineTo(33.8691f)
                curveTo(33.6313f, 17.8726f, 33.5097f, 17.9849f, 33.5048f, 18.2014f)
                verticalLineTo(18.4428f)
                horizontalLineTo(34.3016f)
                verticalLineTo(19.5835f)
                horizontalLineTo(33.5048f)
                verticalLineTo(22.947f)
                horizontalLineTo(32.3786f)
                verticalLineTo(17.7964f)
                close()
                moveTo(12.3097f, 19.8559f)
                curveTo(12.3041f, 19.6792f, 12.2196f, 19.588f, 12.0553f, 19.5821f)
                horizontalLineTo(11.1791f)
                curveTo(10.9714f, 19.5945f, 10.8646f, 19.7067f, 10.8593f, 19.9175f)
                verticalLineTo(21.4716f)
                curveTo(10.8646f, 21.6894f, 10.9828f, 21.8004f, 11.2135f, 21.8067f)
                horizontalLineTo(12.0163f)
                curveTo(12.0999f, 21.8067f, 12.1693f, 21.7761f, 12.2246f, 21.7138f)
                curveTo(12.2823f, 21.6671f, 12.3097f, 21.6069f, 12.3097f, 21.5324f)
                verticalLineTo(19.8559f)
                close()
                moveTo(9.7341f, 19.6352f)
                curveTo(9.7398f, 19.2465f, 9.8277f, 18.951f, 9.9982f, 18.7489f)
                curveTo(10.0873f, 18.6644f, 10.1992f, 18.5935f, 10.335f, 18.535f)
                curveTo(10.476f, 18.4726f, 10.6127f, 18.4425f, 10.7455f, 18.4425f)
                horizontalLineTo(12.3541f)
                curveTo(13.0637f, 18.4485f, 13.4244f, 18.831f, 13.4359f, 19.591f)
                verticalLineTo(21.9299f)
                curveTo(13.4305f, 22.1997f, 13.3235f, 22.4338f, 13.116f, 22.6297f)
                curveTo(12.9111f, 22.8353f, 12.6659f, 22.9401f, 12.3806f, 22.9464f)
                horizontalLineTo(10.8593f)
                verticalLineTo(24.6327f)
                horizontalLineTo(9.7341f)
                verticalLineTo(19.6352f)
                close()
                moveTo(15.4671f, 21.5811f)
                curveTo(15.4671f, 21.6461f, 15.4973f, 21.6976f, 15.5572f, 21.7361f)
                curveTo(15.61f, 21.7826f, 15.6767f, 21.8067f, 15.7611f, 21.8067f)
                horizontalLineTo(16.6256f)
                curveTo(16.8212f, 21.8067f, 16.9224f, 21.7321f, 16.928f, 21.5811f)
                verticalLineTo(21.2629f)
                curveTo(16.928f, 21.0893f, 16.8248f, 21.0017f, 16.6173f, 21.0017f)
                horizontalLineTo(15.7611f)
                curveTo(15.6487f, 21.0017f, 15.5708f, 21.0201f, 15.5274f, 21.055f)
                curveTo(15.4874f, 21.0961f, 15.4671f, 21.1774f, 15.4671f, 21.298f)
                verticalLineTo(21.5811f)
                close()
                moveTo(16.928f, 19.8285f)
                curveTo(16.9337f, 19.658f, 16.8332f, 19.5765f, 16.6253f, 19.5821f)
                horizontalLineTo(14.3587f)
                verticalLineTo(18.4425f)
                horizontalLineTo(16.9108f)
                curveTo(17.654f, 18.4543f, 18.0313f, 18.8086f, 18.0439f, 19.5073f)
                verticalLineTo(21.8911f)
                curveTo(18.0377f, 22.1927f, 17.9441f, 22.4412f, 17.7624f, 22.6389f)
                curveTo(17.5722f, 22.8436f, 17.3273f, 22.9464f, 17.0271f, 22.9464f)
                horizontalLineTo(15.4845f)
                curveTo(14.7337f, 22.9401f, 14.3532f, 22.6024f, 14.3416f, 21.9307f)
                verticalLineTo(21.0109f)
                curveTo(14.3473f, 20.3089f, 14.7112f, 19.9523f, 15.4312f, 19.94f)
                horizontalLineTo(16.928f)
                verticalLineTo(19.8285f)
                close()
                moveTo(21.4339f, 23.3993f)
                curveTo(21.3709f, 23.4559f, 21.2941f, 23.4877f, 21.2048f, 23.493f)
                horizontalLineTo(18.9584f)
                verticalLineTo(24.6327f)
                horizontalLineTo(21.5853f)
                curveTo(21.9114f, 24.627f, 22.167f, 24.513f, 22.3544f, 24.2899f)
                curveTo(22.5384f, 24.0669f, 22.6342f, 23.7728f, 22.6403f, 23.4056f)
                verticalLineTo(18.4425f)
                horizontalLineTo(21.5244f)
                verticalLineTo(21.5249f)
                curveTo(21.5244f, 21.5985f, 21.4914f, 21.6612f, 21.4248f, 21.7138f)
                curveTo(21.3562f, 21.7761f, 21.2741f, 21.8067f, 21.1797f, 21.8067f)
                horizontalLineTo(20.3854f)
                curveTo(20.1835f, 21.8067f, 20.0838f, 21.6865f, 20.0838f, 21.4457f)
                verticalLineTo(18.4425f)
                horizontalLineTo(18.9584f)
                verticalLineTo(21.8067f)
                curveTo(18.9584f, 21.9903f, 18.9844f, 22.1431f, 19.0359f, 22.263f)
                curveTo(19.0849f, 22.3942f, 19.1658f, 22.5199f, 19.2784f, 22.6399f)
                curveTo(19.3969f, 22.7532f, 19.5151f, 22.833f, 19.6334f, 22.8759f)
                curveTo(19.7455f, 22.9228f, 19.8957f, 22.9464f, 20.0838f, 22.9464f)
                horizontalLineTo(21.5244f)
                verticalLineTo(23.2171f)
                curveTo(21.5244f, 23.2858f, 21.4942f, 23.3465f, 21.4339f, 23.3993f)
                close()
                moveTo(23.5239f, 21.8067f)
                horizontalLineTo(25.5291f)
                curveTo(25.7127f, 21.8004f, 25.8079f, 21.728f, 25.8136f, 21.5892f)
                verticalLineTo(21.4867f)
                curveTo(25.8136f, 21.4572f, 25.8045f, 21.4243f, 25.7871f, 21.3888f)
                curveTo(25.7422f, 21.3028f, 25.6872f, 21.26f, 25.6218f, 21.26f)
                horizontalLineTo(24.6277f)
                curveTo(24.3326f, 21.2544f, 24.0808f, 21.1541f, 23.8692f, 20.9607f)
                curveTo(23.6553f, 20.7822f, 23.5455f, 20.5624f, 23.5393f, 20.3045f)
                verticalLineTo(19.4547f)
                curveTo(23.551f, 18.7918f, 23.9163f, 18.4543f, 24.6359f, 18.4425f)
                horizontalLineTo(26.9616f)
                verticalLineTo(19.5821f)
                horizontalLineTo(24.9914f)
                curveTo(24.76f, 19.5821f, 24.6437f, 19.652f, 24.6437f, 19.7912f)
                verticalLineTo(19.9017f)
                curveTo(24.6437f, 20.0463f, 24.7627f, 20.1186f, 25.0f, 20.1186f)
                horizontalLineTo(25.9909f)
                curveTo(26.2552f, 20.1247f, 26.4801f, 20.2243f, 26.6678f, 20.4186f)
                curveTo(26.8573f, 20.6144f, 26.9556f, 20.8473f, 26.9616f, 21.1176f)
                verticalLineTo(21.949f)
                curveTo(26.9556f, 22.1824f, 26.846f, 22.4155f, 26.6351f, 22.6479f)
                curveTo(26.5323f, 22.762f, 26.4272f, 22.8406f, 26.3221f, 22.8849f)
                curveTo(26.2132f, 22.9257f, 26.0655f, 22.9464f, 25.8765f, 22.9464f)
                horizontalLineTo(23.5239f)
                verticalLineTo(21.8067f)
                close()
                moveTo(28.9785f, 21.7361f)
                curveTo(28.9176f, 21.6976f, 28.8874f, 21.6461f, 28.8874f, 21.5811f)
                verticalLineTo(21.298f)
                curveTo(28.8874f, 21.1774f, 28.9084f, 21.0961f, 28.9484f, 21.055f)
                curveTo(28.9915f, 21.0201f, 29.069f, 21.0017f, 29.1813f, 21.0017f)
                horizontalLineTo(30.038f)
                curveTo(30.245f, 21.0017f, 30.3494f, 21.0893f, 30.3494f, 21.2629f)
                verticalLineTo(21.5811f)
                curveTo(30.3436f, 21.7321f, 30.2428f, 21.8067f, 30.0472f, 21.8067f)
                horizontalLineTo(29.1813f)
                curveTo(29.098f, 21.8067f, 29.0309f, 21.7826f, 28.9785f, 21.7361f)
                close()
                moveTo(30.0457f, 19.5821f)
                curveTo(30.2537f, 19.5765f, 30.3543f, 19.658f, 30.3494f, 19.8285f)
                verticalLineTo(19.94f)
                horizontalLineTo(28.852f)
                curveTo(28.1311f, 19.9523f, 27.7677f, 20.3089f, 27.7627f, 21.0109f)
                verticalLineTo(21.9307f)
                curveTo(27.7732f, 22.6024f, 28.1543f, 22.9401f, 28.9045f, 22.9464f)
                horizontalLineTo(30.448f)
                curveTo(30.7487f, 22.9464f, 30.9939f, 22.8436f, 31.1828f, 22.6389f)
                curveTo(31.3635f, 22.4412f, 31.4578f, 22.1927f, 31.4638f, 21.8911f)
                verticalLineTo(19.5073f)
                curveTo(31.4521f, 18.8086f, 31.0748f, 18.4543f, 30.3321f, 18.4425f)
                horizontalLineTo(27.7797f)
                verticalLineTo(19.5821f)
                horizontalLineTo(30.0457f)
                close()
                moveTo(37.5023f, 19.7806f)
                verticalLineTo(19.8072f)
                lineTo(36.091f, 20.3311f)
                verticalLineTo(19.8735f)
                curveTo(36.091f, 19.7883f, 36.1307f, 19.7191f, 36.2086f, 19.6665f)
                curveTo(36.2713f, 19.6097f, 36.3523f, 19.5821f, 36.4529f, 19.5821f)
                horizontalLineTo(37.2361f)
                curveTo(37.313f, 19.5821f, 37.3772f, 19.5993f, 37.4296f, 19.6352f)
                curveTo(37.4782f, 19.6723f, 37.5023f, 19.722f, 37.5023f, 19.7806f)
                close()
                moveTo(36.109f, 21.4889f)
                verticalLineTo(21.418f)
                lineTo(38.6476f, 20.4341f)
                verticalLineTo(19.5331f)
                curveTo(38.6363f, 18.8175f, 38.2812f, 18.4543f, 37.5804f, 18.4425f)
                horizontalLineTo(36.0634f)
                curveTo(35.3458f, 18.4543f, 34.9806f, 18.8051f, 34.968f, 19.4944f)
                lineTo(34.9776f, 21.7752f)
                curveTo(34.9776f, 21.993f, 35.0006f, 22.1679f, 35.047f, 22.2995f)
                curveTo(35.0894f, 22.4259f, 35.1737f, 22.5487f, 35.2974f, 22.6695f)
                curveTo(35.4032f, 22.7689f, 35.5245f, 22.8406f, 35.6594f, 22.8843f)
                curveTo(35.7831f, 22.9257f, 35.9576f, 22.9464f, 36.1819f, 22.9464f)
                horizontalLineTo(38.64f)
                verticalLineTo(21.8067f)
                horizontalLineTo(36.3283f)
                curveTo(36.2649f, 21.8067f, 36.2173f, 21.7725f, 36.1819f, 21.7052f)
                curveTo(36.133f, 21.6527f, 36.109f, 21.5802f, 36.109f, 21.4889f)
                close()
                moveTo(41.0297f, 22.9464f)
                curveTo(40.8592f, 22.9464f, 40.7037f, 22.9311f, 40.5627f, 22.9027f)
                curveTo(40.4148f, 22.879f, 40.2674f, 22.8113f, 40.1168f, 22.6974f)
                curveTo(39.9623f, 22.5647f, 39.8557f, 22.4162f, 39.7971f, 22.2518f)
                curveTo(39.7353f, 22.0904f, 39.7053f, 21.9076f, 39.7053f, 21.7017f)
                verticalLineTo(19.5749f)
                curveTo(39.6991f, 19.4016f, 39.7167f, 19.2492f, 39.7578f, 19.1173f)
                curveTo(39.7958f, 18.9853f, 39.8752f, 18.8564f, 39.9953f, 18.73f)
                curveTo(40.1323f, 18.5973f, 40.272f, 18.5091f, 40.4198f, 18.4658f)
                curveTo(40.5616f, 18.4307f, 40.7216f, 18.4131f, 40.901f, 18.4131f)
                horizontalLineTo(42.6255f)
                verticalLineTo(18.6795f)
                horizontalLineTo(40.9409f)
                curveTo(40.6435f, 18.6795f, 40.4097f, 18.7398f, 40.2387f, 18.8603f)
                curveTo(40.0637f, 18.9921f, 39.9748f, 19.2188f, 39.9748f, 19.5384f)
                verticalLineTo(21.6666f)
                curveTo(39.9748f, 21.8163f, 39.9978f, 21.9618f, 40.0441f, 22.1024f)
                curveTo(40.0913f, 22.2406f, 40.1698f, 22.3617f, 40.283f, 22.4675f)
                curveTo(40.4054f, 22.5593f, 40.5277f, 22.6166f, 40.6467f, 22.6399f)
                curveTo(40.771f, 22.6669f, 40.9039f, 22.6796f, 41.0452f, 22.6796f)
                horizontalLineTo(42.6528f)
                verticalLineTo(22.9464f)
                horizontalLineTo(41.0297f)
                close()
                moveTo(44.8004f, 20.1872f)
                horizontalLineTo(47.0616f)
                verticalLineTo(21.786f)
                curveTo(47.0616f, 22.3763f, 46.7732f, 22.6737f, 46.2007f, 22.6796f)
                horizontalLineTo(44.8307f)
                curveTo(44.5943f, 22.6796f, 44.378f, 22.6007f, 44.1826f, 22.4412f)
                curveTo(44.0705f, 22.3536f, 43.9995f, 22.2518f, 43.9711f, 22.1379f)
                curveTo(43.9424f, 22.0295f, 43.9285f, 21.9092f, 43.9285f, 21.7776f)
                verticalLineTo(21.0988f)
                curveTo(43.9285f, 20.8176f, 44.0066f, 20.596f, 44.1647f, 20.4348f)
                curveTo(44.3177f, 20.2759f, 44.5294f, 20.1934f, 44.8004f, 20.1872f)
                close()
                moveTo(47.2946f, 22.1734f)
                curveTo(47.317f, 22.0413f, 47.3302f, 21.8908f, 47.3302f, 21.7197f)
                verticalLineTo(19.6763f)
                curveTo(47.3346f, 19.3329f, 47.2334f, 19.0284f, 47.0257f, 18.7642f)
                curveTo(46.957f, 18.6739f, 46.883f, 18.605f, 46.804f, 18.5578f)
                curveTo(46.729f, 18.5083f, 46.6479f, 18.4741f, 46.5585f, 18.4567f)
                curveTo(46.3854f, 18.4278f, 46.1938f, 18.4131f, 45.9821f, 18.4131f)
                horizontalLineTo(43.6657f)
                verticalLineTo(18.6795f)
                horizontalLineTo(46.109f)
                curveTo(46.2649f, 18.6795f, 46.4047f, 18.6958f, 46.5293f, 18.7277f)
                curveTo(46.6525f, 18.7696f, 46.7609f, 18.8502f, 46.8526f, 18.9712f)
                curveTo(46.9972f, 19.1574f, 47.0697f, 19.3741f, 47.0697f, 19.621f)
                verticalLineTo(19.9212f)
                horizontalLineTo(44.83f)
                curveTo(44.0598f, 19.9393f, 43.6688f, 20.3352f, 43.6575f, 21.109f)
                verticalLineTo(21.7944f)
                curveTo(43.6575f, 22.1552f, 43.771f, 22.4364f, 43.995f, 22.6389f)
                curveTo(44.2144f, 22.8436f, 44.4977f, 22.9464f, 44.8468f, 22.9464f)
                horizontalLineTo(46.1915f)
                curveTo(46.5406f, 22.9527f, 46.8336f, 22.833f, 47.0697f, 22.5876f)
                curveTo(47.1832f, 22.4559f, 47.2581f, 22.3173f, 47.2946f, 22.1734f)
                close()
                moveTo(49.8589f, 18.6795f)
                curveTo(49.2316f, 18.6912f, 48.9226f, 19.0284f, 48.9344f, 19.6923f)
                verticalLineTo(22.9464f)
                horizontalLineTo(48.6649f)
                verticalLineTo(19.6934f)
                curveTo(48.6524f, 18.8394f, 49.0646f, 18.4131f, 49.9022f, 18.4131f)
                horizontalLineTo(50.2016f)
                verticalLineTo(18.6795f)
                horizontalLineTo(49.8589f)
                close()
                moveTo(52.2824f, 18.681f)
                horizontalLineTo(54.4137f)
                verticalLineTo(21.6682f)
                curveTo(54.4063f, 22.0356f, 54.2944f, 22.2936f, 54.0743f, 22.443f)
                curveTo(53.8556f, 22.6024f, 53.5708f, 22.6813f, 53.2229f, 22.6813f)
                horizontalLineTo(52.2912f)
                curveTo(52.1382f, 22.6813f, 51.9998f, 22.6651f, 51.8754f, 22.6326f)
                curveTo(51.7503f, 22.6031f, 51.6392f, 22.5593f, 51.5378f, 22.5009f)
                curveTo(51.3323f, 22.3748f, 51.2309f, 22.1401f, 51.2309f, 21.7952f)
                verticalLineTo(19.7204f)
                curveTo(51.2246f, 19.5593f, 51.2423f, 19.4213f, 51.2817f, 19.3062f)
                curveTo(51.3117f, 19.1921f, 51.3823f, 19.078f, 51.4947f, 18.9629f)
                curveTo(51.6121f, 18.8365f, 51.7374f, 18.7589f, 51.8672f, 18.73f)
                curveTo(51.9913f, 18.6979f, 52.1289f, 18.681f, 52.2824f, 18.681f)
                close()
                moveTo(53.2999f, 22.9483f)
                curveTo(54.198f, 22.9661f, 54.659f, 22.5452f, 54.683f, 21.6865f)
                verticalLineTo(16.9444f)
                horizontalLineTo(54.4137f)
                verticalLineTo(18.4144f)
                horizontalLineTo(52.2988f)
                curveTo(51.4182f, 18.4078f, 50.9726f, 18.8414f, 50.9609f, 19.7135f)
                verticalLineTo(21.6497f)
                curveTo(50.9545f, 21.8313f, 50.9726f, 21.9977f, 51.0138f, 22.147f)
                curveTo(51.0445f, 22.2969f, 51.121f, 22.443f, 51.24f, 22.5876f)
                curveTo(51.3982f, 22.7484f, 51.5627f, 22.8517f, 51.7344f, 22.8954f)
                curveTo(51.901f, 22.9302f, 52.0898f, 22.9483f, 52.3008f, 22.9483f)
                horizontalLineTo(53.2999f)
                close()
            }
            path(fill = SolidColor(Color(0xFFE2001A)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(3.7482f, 18.184f)
                curveTo(3.66f, 18.2029f, 3.5716f, 18.2328f, 3.4833f, 18.2712f)
                curveTo(3.3441f, 18.3306f, 3.2259f, 18.4079f, 3.1224f, 18.4939f)
                curveTo(3.1187f, 18.3805f, 3.1208f, 18.2723f, 3.128f, 18.1683f)
                curveTo(3.1802f, 16.9637f, 4.1842f, 16.0f, 5.4176f, 16.0f)
                curveTo(6.6154f, 16.0f, 7.5979f, 16.9065f, 7.7024f, 18.0616f)
                curveTo(7.72f, 18.1946f, 7.7259f, 18.3361f, 7.7193f, 18.4829f)
                curveTo(7.5564f, 18.3329f, 7.3473f, 18.2319f, 7.0944f, 18.1848f)
                curveTo(6.9322f, 17.4204f, 6.245f, 16.8461f, 5.4211f, 16.8461f)
                curveTo(4.5976f, 16.8461f, 3.9107f, 17.4197f, 3.7482f, 18.184f)
                close()
                moveTo(3.6011f, 18.535f)
                curveTo(3.7422f, 18.4727f, 3.8792f, 18.4426f, 4.0116f, 18.4426f)
                horizontalLineTo(6.7599f)
                curveTo(7.4697f, 18.4486f, 7.8309f, 18.831f, 7.8422f, 19.591f)
                verticalLineTo(21.7976f)
                curveTo(7.8309f, 22.5564f, 7.4697f, 22.9402f, 6.7599f, 22.9464f)
                horizontalLineTo(4.0116f)
                curveTo(3.8792f, 22.9464f, 3.7422f, 22.9158f, 3.6011f, 22.8546f)
                curveTo(3.4651f, 22.7956f, 3.3532f, 22.7249f, 3.264f, 22.6389f)
                curveTo(3.0933f, 22.4378f, 3.006f, 22.1428f, 3.0f, 21.7531f)
                verticalLineTo(19.6353f)
                curveTo(3.006f, 19.2465f, 3.0933f, 18.951f, 3.264f, 18.7489f)
                curveTo(3.3532f, 18.6644f, 3.4651f, 18.5936f, 3.6011f, 18.535f)
                close()
            }
        }
        .build()
        return _paysafeCard!!
    }

private var _paysafeCard: ImageVector? = null
