package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.MastercardIdCheck: ImageVector
    get() {
        if (_mastercardIdCheck != null) {
            return _mastercardIdCheck!!
        }
        _mastercardIdCheck = Builder(name = "MastercardIdCheck", defaultWidth = 58.0.dp,
                defaultHeight = 40.0.dp, viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(42.9015f, 27.0102f)
                verticalLineTo(24.6857f)
                horizontalLineTo(42.3406f)
                verticalLineTo(26.034f)
                curveTo(42.1474f, 25.7853f, 41.8463f, 25.6448f, 41.5316f, 25.6565f)
                curveTo(40.7869f, 25.6565f, 40.1833f, 26.2601f, 40.1833f, 27.0048f)
                curveTo(40.1833f, 27.7494f, 40.7869f, 28.3531f, 41.5316f, 28.3531f)
                curveTo(41.8463f, 28.3647f, 42.1474f, 28.2242f, 42.3406f, 27.9756f)
                verticalLineTo(28.2884f)
                horizontalLineTo(42.9015f)
                verticalLineTo(27.0102f)
                close()
                moveTo(26.1716f, 25.7212f)
                horizontalLineTo(27.0885f)
                verticalLineTo(26.2254f)
                horizontalLineTo(26.177f)
                verticalLineTo(27.412f)
                curveTo(26.177f, 27.6708f, 26.2795f, 27.8434f, 26.5491f, 27.8434f)
                curveTo(26.7243f, 27.8302f, 26.8931f, 27.7727f, 27.0399f, 27.6762f)
                lineTo(27.2017f, 28.1562f)
                curveTo(26.9915f, 28.2874f, 26.7484f, 28.3566f, 26.5006f, 28.3558f)
                curveTo(25.8372f, 28.3558f, 25.6053f, 27.9998f, 25.6053f, 27.4012f)
                verticalLineTo(26.2254f)
                horizontalLineTo(25.0822f)
                verticalLineTo(25.7212f)
                horizontalLineTo(25.6053f)
                verticalLineTo(24.9392f)
                horizontalLineTo(26.1716f)
                verticalLineTo(25.7212f)
                close()
                moveTo(18.7127f, 28.3072f)
                verticalLineTo(26.6893f)
                curveTo(18.7318f, 26.414f, 18.6315f, 26.1438f, 18.4374f, 25.9477f)
                curveTo(18.2433f, 25.7515f, 17.9743f, 25.6484f, 17.6988f, 25.6645f)
                curveTo(17.3358f, 25.6407f, 16.9886f, 25.8164f, 16.7927f, 26.123f)
                curveTo(16.6142f, 25.8256f, 16.2872f, 25.6496f, 15.9406f, 25.6645f)
                curveTo(15.6388f, 25.6493f, 15.3515f, 25.795f, 15.1855f, 26.0475f)
                verticalLineTo(25.7293f)
                horizontalLineTo(14.6246f)
                verticalLineTo(28.3072f)
                horizontalLineTo(15.1909f)
                verticalLineTo(26.878f)
                curveTo(15.1665f, 26.6995f, 15.2231f, 26.5195f, 15.3452f, 26.387f)
                curveTo(15.4672f, 26.2545f, 15.642f, 26.1834f, 15.8219f, 26.1931f)
                curveTo(16.1941f, 26.1931f, 16.3828f, 26.4358f, 16.3828f, 26.8726f)
                verticalLineTo(28.3072f)
                horizontalLineTo(16.9491f)
                verticalLineTo(26.878f)
                curveTo(16.9257f, 26.6997f, 16.9826f, 26.5203f, 17.1045f, 26.388f)
                curveTo(17.2263f, 26.2558f, 17.4005f, 26.1844f, 17.5801f, 26.1931f)
                curveTo(17.9631f, 26.1931f, 18.1464f, 26.4358f, 18.1464f, 26.8726f)
                verticalLineTo(28.3072f)
                horizontalLineTo(18.7127f)
                close()
                moveTo(40.9545f, 33.625f)
                horizontalLineTo(40.4395f)
                lineTo(40.4422f, 30.594f)
                horizontalLineTo(40.0592f)
                verticalLineTo(35.4479f)
                horizontalLineTo(40.4637f)
                verticalLineTo(33.9621f)
                horizontalLineTo(40.9788f)
                lineTo(42.3271f, 35.4479f)
                horizontalLineTo(42.8152f)
                lineTo(41.2781f, 33.7733f)
                lineTo(42.7882f, 32.2767f)
                horizontalLineTo(42.3028f)
                lineTo(40.9545f, 33.625f)
                close()
                moveTo(29.386f, 32.5652f)
                curveTo(29.2997f, 32.644f, 29.2253f, 32.7349f, 29.1649f, 32.8349f)
                lineTo(29.1514f, 30.6102f)
                horizontalLineTo(28.7685f)
                verticalLineTo(35.4641f)
                horizontalLineTo(29.1514f)
                verticalLineTo(33.6574f)
                curveTo(29.1501f, 33.5111f, 29.1785f, 33.3662f, 29.235f, 33.2313f)
                curveTo(29.2874f, 33.1058f, 29.3644f, 32.9921f, 29.4615f, 32.8969f)
                curveTo(29.5581f, 32.803f, 29.6728f, 32.7296f, 29.7986f, 32.6812f)
                curveTo(29.931f, 32.6302f, 30.0719f, 32.6046f, 30.2138f, 32.6057f)
                curveTo(30.3607f, 32.6028f, 30.5069f, 32.6266f, 30.6453f, 32.6758f)
                curveTo(30.7661f, 32.7196f, 30.8757f, 32.7896f, 30.9662f, 32.8807f)
                curveTo(31.0564f, 32.9731f, 31.1247f, 33.0846f, 31.1658f, 33.207f)
                curveTo(31.2125f, 33.346f, 31.2352f, 33.4919f, 31.2332f, 33.6385f)
                verticalLineTo(35.4641f)
                horizontalLineTo(31.6188f)
                verticalLineTo(33.5198f)
                curveTo(31.6221f, 33.3354f, 31.5892f, 33.1522f, 31.5217f, 32.9805f)
                curveTo(31.4624f, 32.8284f, 31.3704f, 32.6912f, 31.2521f, 32.5787f)
                curveTo(31.1296f, 32.4663f, 30.9855f, 32.3801f, 30.8287f, 32.3252f)
                curveTo(30.6554f, 32.2645f, 30.4729f, 32.2343f, 30.2894f, 32.2362f)
                curveTo(30.1805f, 32.2363f, 30.0721f, 32.2481f, 29.9658f, 32.2713f)
                curveTo(29.8585f, 32.2948f, 29.7544f, 32.331f, 29.6556f, 32.3792f)
                curveTo(29.5576f, 32.4284f, 29.4668f, 32.491f, 29.386f, 32.5652f)
                close()
                moveTo(25.8688f, 30.6776f)
                curveTo(26.0634f, 30.6778f, 26.2573f, 30.7004f, 26.4467f, 30.745f)
                curveTo(26.6336f, 30.7878f, 26.8147f, 30.853f, 26.986f, 30.9392f)
                curveTo(27.1476f, 31.0212f, 27.298f, 31.1236f, 27.4336f, 31.2439f)
                curveTo(27.5664f, 31.3618f, 27.6817f, 31.498f, 27.7761f, 31.6484f)
                lineTo(27.4336f, 31.8776f)
                curveTo(27.3527f, 31.7538f, 27.2556f, 31.6414f, 27.1451f, 31.5432f)
                curveTo(27.0339f, 31.4438f, 26.9107f, 31.3586f, 26.7783f, 31.2897f)
                curveTo(26.6415f, 31.2193f, 26.4966f, 31.1659f, 26.3469f, 31.1306f)
                curveTo(26.1906f, 31.0929f, 26.0304f, 31.0739f, 25.8696f, 31.074f)
                curveTo(25.6011f, 31.0717f, 25.3347f, 31.1212f, 25.0849f, 31.2196f)
                curveTo(24.8489f, 31.312f, 24.6342f, 31.4514f, 24.4538f, 31.6295f)
                curveTo(24.2725f, 31.8114f, 24.1294f, 32.0278f, 24.0332f, 32.2659f)
                curveTo(23.8284f, 32.7951f, 23.8284f, 33.3816f, 24.0332f, 33.9108f)
                curveTo(24.1294f, 34.149f, 24.2724f, 34.3654f, 24.4538f, 34.5472f)
                curveTo(24.6342f, 34.7253f, 24.8489f, 34.8648f, 25.0849f, 34.9571f)
                curveTo(25.3347f, 35.0556f, 25.6011f, 35.105f, 25.8696f, 35.1027f)
                curveTo(26.0293f, 35.1032f, 26.1886f, 35.0851f, 26.3442f, 35.0488f)
                curveTo(26.6442f, 34.983f, 26.9226f, 34.8419f, 27.1532f, 34.6389f)
                curveTo(27.2644f, 34.5404f, 27.3615f, 34.4269f, 27.4417f, 34.3018f)
                lineTo(27.7788f, 34.5472f)
                curveTo(27.6808f, 34.6941f, 27.5638f, 34.8274f, 27.4309f, 34.9436f)
                curveTo(27.2956f, 35.0615f, 27.1462f, 35.1621f, 26.986f, 35.243f)
                curveTo(26.82f, 35.3278f, 26.6443f, 35.392f, 26.4628f, 35.4344f)
                curveTo(25.9498f, 35.5513f, 25.4135f, 35.5118f, 24.9231f, 35.3212f)
                curveTo(24.6374f, 35.2082f, 24.3771f, 35.0395f, 24.1572f, 34.825f)
                curveTo(23.9384f, 34.6075f, 23.7659f, 34.3479f, 23.6503f, 34.0618f)
                curveTo(23.4055f, 33.435f, 23.4055f, 32.739f, 23.6503f, 32.1122f)
                curveTo(23.7659f, 31.8261f, 23.9384f, 31.5665f, 24.1572f, 31.349f)
                curveTo(24.3771f, 31.1345f, 24.6374f, 30.9658f, 24.9231f, 30.8529f)
                curveTo(25.2243f, 30.7348f, 25.5453f, 30.6753f, 25.8688f, 30.6776f)
                close()
                moveTo(25.8688f, 30.6776f)
                lineTo(25.8588f, 30.6776f)
                horizontalLineTo(25.8696f)
                lineTo(25.8688f, 30.6776f)
                close()
                moveTo(18.2705f, 30.7315f)
                curveTo(18.6314f, 30.7261f, 18.9906f, 30.7817f, 19.3329f, 30.896f)
                curveTo(19.6326f, 30.995f, 19.9082f, 31.1558f, 20.1419f, 31.3679f)
                curveTo(20.3645f, 31.5755f, 20.5385f, 31.8296f, 20.6516f, 32.1122f)
                curveTo(20.8897f, 32.7431f, 20.8897f, 33.4391f, 20.6516f, 34.0699f)
                curveTo(20.5386f, 34.3525f, 20.3646f, 34.6067f, 20.1419f, 34.8142f)
                curveTo(19.9082f, 35.0263f, 19.6326f, 35.1871f, 19.3329f, 35.2861f)
                curveTo(18.9906f, 35.4004f, 18.6314f, 35.456f, 18.2705f, 35.4506f)
                horizontalLineTo(16.5473f)
                verticalLineTo(30.7315f)
                horizontalLineTo(18.2705f)
                close()
                moveTo(14.7217f, 35.4506f)
                horizontalLineTo(15.1343f)
                verticalLineTo(30.7315f)
                horizontalLineTo(14.7217f)
                verticalLineTo(35.4506f)
                close()
                moveTo(43.306f, 35.2915f)
                horizontalLineTo(43.2467f)
                verticalLineTo(35.4506f)
                horizontalLineTo(43.217f)
                verticalLineTo(35.2915f)
                horizontalLineTo(43.1577f)
                verticalLineTo(35.2618f)
                horizontalLineTo(43.3087f)
                lineTo(43.306f, 35.2915f)
                close()
                moveTo(43.5379f, 35.4506f)
                horizontalLineTo(43.5082f)
                verticalLineTo(35.2969f)
                lineTo(43.4543f, 35.4317f)
                horizontalLineTo(43.4219f)
                lineTo(43.368f, 35.2969f)
                verticalLineTo(35.4506f)
                horizontalLineTo(43.3383f)
                verticalLineTo(35.2618f)
                horizontalLineTo(43.3842f)
                lineTo(43.4381f, 35.3967f)
                lineTo(43.4921f, 35.2618f)
                horizontalLineTo(43.5379f)
                verticalLineTo(35.4506f)
                close()
                moveTo(16.9599f, 35.0596f)
                verticalLineTo(31.1225f)
                lineTo(18.2732f, 31.1279f)
                curveTo(18.5817f, 31.1225f, 18.8889f, 31.169f, 19.1819f, 31.2654f)
                curveTo(19.4289f, 31.3485f, 19.6552f, 31.4837f, 19.8453f, 31.6618f)
                curveTo(20.0262f, 31.8362f, 20.1654f, 32.0491f, 20.2525f, 32.2848f)
                curveTo(20.4352f, 32.8086f, 20.4352f, 33.3789f, 20.2525f, 33.9027f)
                curveTo(20.1655f, 34.1377f, 20.0263f, 34.3498f, 19.8453f, 34.523f)
                curveTo(19.6547f, 34.7005f, 19.4286f, 34.8356f, 19.1819f, 34.9194f)
                curveTo(18.8883f, 35.0177f, 18.5801f, 35.0651f, 18.2705f, 35.0596f)
                horizontalLineTo(16.9599f)
                close()
                moveTo(34.1374f, 32.2362f)
                curveTo(34.3395f, 32.2342f, 34.5398f, 32.2747f, 34.7253f, 32.3549f)
                curveTo(34.9033f, 32.4325f, 35.0631f, 32.5464f, 35.1945f, 32.6893f)
                curveTo(35.3305f, 32.8386f, 35.4366f, 33.0125f, 35.5073f, 33.2016f)
                curveTo(35.5859f, 33.4102f, 35.6261f, 33.6313f, 35.626f, 33.8542f)
                verticalLineTo(33.9378f)
                verticalLineTo(34.0133f)
                horizontalLineTo(32.9671f)
                curveTo(32.9775f, 34.1832f, 33.0196f, 34.3497f, 33.0912f, 34.5041f)
                curveTo(33.156f, 34.6429f, 33.2476f, 34.7676f, 33.3608f, 34.8708f)
                curveTo(33.4715f, 34.9705f, 33.6007f, 35.0475f, 33.741f, 35.0974f)
                curveTo(33.8872f, 35.1498f, 34.0415f, 35.1763f, 34.1968f, 35.1756f)
                curveTo(34.4019f, 35.179f, 34.6053f, 35.1376f, 34.7927f, 35.0542f)
                curveTo(34.969f, 34.9721f, 35.1297f, 34.8599f, 35.2673f, 34.7225f)
                lineTo(35.4723f, 34.9922f)
                curveTo(35.379f, 35.0873f, 35.276f, 35.1723f, 35.1649f, 35.2457f)
                curveTo(35.064f, 35.311f, 34.9565f, 35.3653f, 34.844f, 35.4075f)
                curveTo(34.7367f, 35.4471f, 34.6255f, 35.4751f, 34.5123f, 35.4911f)
                curveTo(34.3997f, 35.5069f, 34.2862f, 35.515f, 34.1725f, 35.5153f)
                curveTo(33.9538f, 35.5179f, 33.7366f, 35.4776f, 33.5334f, 35.3967f)
                curveTo(33.3442f, 35.3209f, 33.1726f, 35.2071f, 33.0291f, 35.0623f)
                curveTo(32.8855f, 34.9148f, 32.7736f, 34.7396f, 32.7001f, 34.5472f)
                curveTo(32.6192f, 34.3356f, 32.5789f, 34.1105f, 32.5815f, 33.8839f)
                curveTo(32.5789f, 33.659f, 32.6192f, 33.4357f, 32.7001f, 33.2259f)
                curveTo(32.7709f, 33.0301f, 32.88f, 32.8505f, 33.021f, 32.6974f)
                curveTo(33.1624f, 32.5513f, 33.3322f, 32.4356f, 33.5199f, 32.3576f)
                curveTo(33.7183f, 32.2721f, 33.9322f, 32.228f, 34.1482f, 32.2281f)
                lineTo(34.1374f, 32.2362f)
                close()
                moveTo(33.6952f, 32.6596f)
                curveTo(33.8357f, 32.6031f, 33.986f, 32.5747f, 34.1374f, 32.576f)
                curveTo(34.4192f, 32.5741f, 34.69f, 32.6848f, 34.8898f, 32.8834f)
                curveTo(34.99f, 32.9835f, 35.0704f, 33.1015f, 35.1271f, 33.2313f)
                curveTo(35.1892f, 33.3741f, 35.2266f, 33.5263f, 35.2377f, 33.6816f)
                horizontalLineTo(32.9698f)
                curveTo(32.986f, 33.5274f, 33.0279f, 33.377f, 33.0938f, 33.2367f)
                curveTo(33.1549f, 33.1067f, 33.2389f, 32.9888f, 33.3419f, 32.8888f)
                curveTo(33.444f, 32.7906f, 33.5639f, 32.7128f, 33.6952f, 32.6596f)
                close()
                moveTo(37.9774f, 32.2362f)
                curveTo(38.2021f, 32.2342f, 38.425f, 32.2773f, 38.6327f, 32.363f)
                curveTo(38.83f, 32.4445f, 39.0062f, 32.5699f, 39.1478f, 32.7297f)
                lineTo(38.8997f, 32.9994f)
                curveTo(38.7801f, 32.8785f, 38.6394f, 32.7807f, 38.4844f, 32.7108f)
                curveTo(38.3219f, 32.6406f, 38.1464f, 32.6057f, 37.9694f, 32.6084f)
                curveTo(37.8035f, 32.6076f, 37.6393f, 32.6406f, 37.4867f, 32.7054f)
                curveTo(37.3405f, 32.7684f, 37.2084f, 32.8601f, 37.0983f, 32.9751f)
                curveTo(36.9821f, 33.0904f, 36.8904f, 33.228f, 36.8287f, 33.3796f)
                curveTo(36.705f, 33.709f, 36.705f, 34.0722f, 36.8287f, 34.4016f)
                curveTo(36.9444f, 34.7027f, 37.1782f, 34.9434f, 37.4759f, 35.0677f)
                curveTo(37.6284f, 35.1328f, 37.7927f, 35.1658f, 37.9586f, 35.1648f)
                curveTo(38.1378f, 35.1668f, 38.3153f, 35.13f, 38.479f, 35.0569f)
                curveTo(38.635f, 34.9872f, 38.7774f, 34.8904f, 38.8997f, 34.7711f)
                lineTo(39.1397f, 35.0407f)
                curveTo(38.9974f, 35.1998f, 38.8215f, 35.325f, 38.6246f, 35.4075f)
                curveTo(38.4178f, 35.4931f, 38.1959f, 35.5362f, 37.972f, 35.5342f)
                curveTo(37.7475f, 35.5369f, 37.5248f, 35.4947f, 37.3168f, 35.4102f)
                curveTo(36.9277f, 35.252f, 36.6206f, 34.941f, 36.4673f, 34.5499f)
                curveTo(36.3079f, 34.1314f, 36.3079f, 33.6688f, 36.4673f, 33.2502f)
                curveTo(36.6197f, 32.8579f, 36.9269f, 32.5457f, 37.3168f, 32.3872f)
                curveTo(37.5255f, 32.2891f, 37.7523f, 32.235f, 37.9828f, 32.2281f)
                lineTo(37.9774f, 32.2362f)
                close()
                moveTo(31.8723f, 25.6565f)
                curveTo(31.5937f, 25.6483f, 31.3329f, 25.7931f, 31.1927f, 26.034f)
                verticalLineTo(25.7212f)
                horizontalLineTo(30.6372f)
                verticalLineTo(28.2992f)
                horizontalLineTo(31.1981f)
                verticalLineTo(26.8538f)
                curveTo(31.1981f, 26.4277f, 31.3815f, 26.1904f, 31.7374f, 26.1904f)
                curveTo(31.8574f, 26.1887f, 31.9765f, 26.2107f, 32.088f, 26.2551f)
                lineTo(32.2606f, 25.7158f)
                curveTo(32.1325f, 25.67f, 31.9975f, 25.6462f, 31.8615f, 25.6457f)
                lineTo(31.8723f, 25.6565f)
                close()
                moveTo(23.5882f, 25.6565f)
                curveTo(23.9574f, 25.6437f, 24.3224f, 25.7373f, 24.6399f, 25.9261f)
                lineTo(24.3918f, 26.3792f)
                curveTo(24.1455f, 26.2375f, 23.867f, 26.1613f, 23.5828f, 26.158f)
                curveTo(23.2754f, 26.158f, 23.092f, 26.2875f, 23.092f, 26.4601f)
                curveTo(23.092f, 26.6326f, 23.2862f, 26.6812f, 23.5289f, 26.7135f)
                lineTo(23.7986f, 26.7513f)
                curveTo(24.3595f, 26.8322f, 24.6992f, 27.0317f, 24.6992f, 27.5225f)
                curveTo(24.6992f, 28.0133f, 24.2678f, 28.3639f, 23.5235f, 28.3639f)
                curveTo(23.1252f, 28.3748f, 22.7338f, 28.2576f, 22.4071f, 28.0295f)
                lineTo(22.6768f, 27.5926f)
                curveTo(22.9242f, 27.7762f, 23.2263f, 27.8712f, 23.5343f, 27.8623f)
                curveTo(23.9172f, 27.8623f, 24.1222f, 27.749f, 24.1222f, 27.5495f)
                curveTo(24.1222f, 27.4039f, 23.9765f, 27.323f, 23.6691f, 27.2798f)
                lineTo(23.3995f, 27.2421f)
                curveTo(22.8224f, 27.1612f, 22.5096f, 26.9023f, 22.5096f, 26.4816f)
                curveTo(22.5096f, 25.9693f, 22.9356f, 25.6565f, 23.5882f, 25.6565f)
                close()
                moveTo(39.6628f, 25.6565f)
                curveTo(39.3843f, 25.6483f, 39.1235f, 25.7931f, 38.9833f, 26.034f)
                verticalLineTo(25.7212f)
                horizontalLineTo(38.4278f)
                verticalLineTo(28.2992f)
                horizontalLineTo(38.9887f)
                verticalLineTo(26.8538f)
                curveTo(38.9887f, 26.4277f, 39.1721f, 26.1904f, 39.528f, 26.1904f)
                curveTo(39.648f, 26.1887f, 39.7671f, 26.2107f, 39.8786f, 26.2551f)
                lineTo(40.0512f, 25.7158f)
                curveTo(39.9231f, 25.67f, 39.7881f, 25.6462f, 39.6521f, 25.6457f)
                lineTo(39.6628f, 25.6565f)
                close()
                moveTo(32.8256f, 27.9828f)
                curveTo(32.5639f, 27.7261f, 32.4224f, 27.3711f, 32.4359f, 27.0048f)
                verticalLineTo(26.994f)
                curveTo(32.4224f, 26.6277f, 32.5639f, 26.2726f, 32.8256f, 26.016f)
                curveTo(33.0874f, 25.7594f, 33.4452f, 25.6249f, 33.8111f, 25.6457f)
                curveTo(34.1479f, 25.6285f, 34.4789f, 25.7382f, 34.7388f, 25.9531f)
                lineTo(34.4691f, 26.4061f)
                curveTo(34.2752f, 26.2583f, 34.0388f, 26.1769f, 33.795f, 26.1742f)
                curveTo(33.365f, 26.209f, 33.0339f, 26.568f, 33.0339f, 26.9994f)
                curveTo(33.0339f, 27.4307f, 33.365f, 27.7898f, 33.795f, 27.8245f)
                curveTo(34.0388f, 27.8218f, 34.2752f, 27.7405f, 34.4691f, 27.5926f)
                lineTo(34.7388f, 28.0457f)
                curveTo(34.4789f, 28.2605f, 34.1479f, 28.3702f, 33.8111f, 28.3531f)
                curveTo(33.4452f, 28.3738f, 33.0874f, 28.2394f, 32.8256f, 27.9828f)
                close()
                moveTo(37.6889f, 27.0048f)
                verticalLineTo(25.7158f)
                horizontalLineTo(37.128f)
                verticalLineTo(26.0286f)
                curveTo(36.9348f, 25.7799f, 36.6337f, 25.6395f, 36.319f, 25.6511f)
                curveTo(35.5744f, 25.6511f, 34.9707f, 26.2547f, 34.9707f, 26.9994f)
                curveTo(34.9707f, 27.744f, 35.5744f, 28.3477f, 36.319f, 28.3477f)
                curveTo(36.6337f, 28.3593f, 36.9348f, 28.2188f, 37.128f, 27.9702f)
                verticalLineTo(28.283f)
                horizontalLineTo(37.6889f)
                verticalLineTo(27.0048f)
                close()
                moveTo(36.4089f, 26.2718f)
                curveTo(35.9853f, 26.2559f, 35.6267f, 26.5816f, 35.6017f, 27.0048f)
                curveTo(35.5874f, 27.2202f, 35.6637f, 27.4318f, 35.8122f, 27.5884f)
                curveTo(35.9607f, 27.7451f, 36.1679f, 27.8327f, 36.3837f, 27.8299f)
                curveTo(36.8077f, 27.8277f, 37.1521f, 27.4871f, 37.1589f, 27.0632f)
                curveTo(37.1658f, 26.6393f, 36.8325f, 26.2877f, 36.4089f, 26.2718f)
                close()
                moveTo(28.8332f, 25.6565f)
                curveTo(28.0885f, 25.6669f, 27.4933f, 26.279f, 27.5037f, 27.0236f)
                curveTo(27.5142f, 27.7683f, 28.1263f, 28.3635f, 28.8709f, 28.3531f)
                curveTo(29.2557f, 28.3666f, 29.632f, 28.238f, 29.928f, 27.9917f)
                lineTo(29.6583f, 27.5765f)
                curveTo(29.4454f, 27.7472f, 29.1816f, 27.8421f, 28.9087f, 27.8461f)
                curveTo(28.5232f, 27.8793f, 28.1813f, 27.5996f, 28.1374f, 27.2151f)
                horizontalLineTo(30.0547f)
                verticalLineTo(26.9994f)
                curveTo(30.0547f, 26.1904f, 29.5532f, 25.6511f, 28.8305f, 25.6511f)
                lineTo(28.8332f, 25.6565f)
                close()
                moveTo(29.2891f, 26.3356f)
                curveTo(29.1667f, 26.2183f, 29.0027f, 26.1544f, 28.8332f, 26.158f)
                horizontalLineTo(28.8224f)
                curveTo(28.462f, 26.1457f, 28.1578f, 26.4236f, 28.1374f, 26.7836f)
                horizontalLineTo(29.4858f)
                curveTo(29.4822f, 26.6141f, 29.4115f, 26.453f, 29.2891f, 26.3356f)
                close()
                moveTo(41.6215f, 26.2772f)
                curveTo(41.1979f, 26.2613f, 40.8392f, 26.587f, 40.8143f, 27.0102f)
                curveTo(40.8f, 27.2256f, 40.8763f, 27.4371f, 41.0248f, 27.5938f)
                curveTo(41.1733f, 27.7505f, 41.3805f, 27.8381f, 41.5963f, 27.8353f)
                curveTo(42.0202f, 27.8331f, 42.3646f, 27.4925f, 42.3715f, 27.0686f)
                curveTo(42.3783f, 26.6447f, 42.0451f, 26.2931f, 41.6215f, 26.2772f)
                close()
                moveTo(21.8759f, 27.0102f)
                verticalLineTo(25.7212f)
                horizontalLineTo(21.315f)
                verticalLineTo(26.034f)
                curveTo(21.1217f, 25.7853f, 20.8207f, 25.6448f, 20.506f, 25.6565f)
                curveTo(19.7613f, 25.6565f, 19.1577f, 26.2601f, 19.1577f, 27.0048f)
                curveTo(19.1577f, 27.7494f, 19.7613f, 28.3531f, 20.506f, 28.3531f)
                curveTo(20.8207f, 28.3647f, 21.1217f, 28.2242f, 21.315f, 27.9756f)
                verticalLineTo(28.2884f)
                horizontalLineTo(21.8759f)
                verticalLineTo(27.0102f)
                close()
                moveTo(20.5959f, 26.2772f)
                curveTo(20.1723f, 26.2613f, 19.8136f, 26.587f, 19.7887f, 27.0102f)
                curveTo(19.7744f, 27.2256f, 19.8507f, 27.4371f, 19.9992f, 27.5938f)
                curveTo(20.1477f, 27.7505f, 20.3548f, 27.8381f, 20.5707f, 27.8353f)
                curveTo(20.9946f, 27.8331f, 21.339f, 27.4925f, 21.3459f, 27.0686f)
                curveTo(21.3527f, 26.6447f, 21.0195f, 26.2931f, 20.5959f, 26.2772f)
                close()
                moveTo(43.8345f, 27.9243f)
                curveTo(43.8696f, 27.9239f, 43.9044f, 27.9303f, 43.937f, 27.9432f)
                curveTo(43.968f, 27.9558f, 43.9963f, 27.9741f, 44.0206f, 27.9971f)
                curveTo(44.0443f, 28.0204f, 44.0635f, 28.0478f, 44.0772f, 28.078f)
                curveTo(44.1048f, 28.1417f, 44.1048f, 28.2139f, 44.0772f, 28.2776f)
                curveTo(44.0635f, 28.3078f, 44.0443f, 28.3352f, 44.0206f, 28.3585f)
                curveTo(43.9963f, 28.3815f, 43.968f, 28.3998f, 43.937f, 28.4124f)
                curveTo(43.9047f, 28.4267f, 43.8698f, 28.434f, 43.8345f, 28.434f)
                curveTo(43.7302f, 28.4332f, 43.6356f, 28.3723f, 43.5918f, 28.2776f)
                curveTo(43.5645f, 28.2139f, 43.5645f, 28.1417f, 43.5918f, 28.078f)
                curveTo(43.6056f, 28.0478f, 43.6248f, 28.0204f, 43.6485f, 27.9971f)
                curveTo(43.6727f, 27.9741f, 43.7011f, 27.9558f, 43.732f, 27.9432f)
                curveTo(43.7647f, 27.9303f, 43.7995f, 27.9239f, 43.8345f, 27.9243f)
                close()
                moveTo(43.9127f, 28.3639f)
                curveTo(43.8881f, 28.3747f, 43.8614f, 28.3802f, 43.8345f, 28.3801f)
                verticalLineTo(28.3827f)
                curveTo(43.8074f, 28.3818f, 43.7808f, 28.3754f, 43.7563f, 28.3639f)
                curveTo(43.7321f, 28.3539f, 43.7101f, 28.3392f, 43.6916f, 28.3207f)
                curveTo(43.6217f, 28.2444f, 43.6217f, 28.1274f, 43.6916f, 28.0511f)
                curveTo(43.7101f, 28.0325f, 43.7321f, 28.0179f, 43.7563f, 28.0079f)
                curveTo(43.7811f, 27.9974f, 43.8076f, 27.9919f, 43.8345f, 27.9917f)
                curveTo(43.8614f, 27.9917f, 43.8881f, 27.9972f, 43.9127f, 28.0079f)
                curveTo(43.936f, 28.0182f, 43.957f, 28.0329f, 43.9747f, 28.0511f)
                curveTo(44.0447f, 28.1274f, 44.0447f, 28.2444f, 43.9747f, 28.3207f)
                curveTo(43.957f, 28.3389f, 43.9359f, 28.3535f, 43.9127f, 28.3639f)
                close()
                moveTo(43.8507f, 28.0592f)
                curveTo(43.8759f, 28.0579f, 43.9007f, 28.0656f, 43.9208f, 28.0807f)
                curveTo(43.9376f, 28.0946f, 43.9466f, 28.1157f, 43.9451f, 28.1374f)
                curveTo(43.9459f, 28.1555f, 43.939f, 28.1731f, 43.9262f, 28.1859f)
                curveTo(43.9106f, 28.2001f, 43.8906f, 28.2086f, 43.8696f, 28.2102f)
                lineTo(43.9478f, 28.2992f)
                horizontalLineTo(43.8858f)
                lineTo(43.813f, 28.2102f)
                horizontalLineTo(43.7887f)
                verticalLineTo(28.2992f)
                horizontalLineTo(43.7374f)
                verticalLineTo(28.0618f)
                lineTo(43.8507f, 28.0592f)
                close()
                moveTo(43.7914f, 28.1697f)
                verticalLineTo(28.105f)
                lineTo(43.8507f, 28.1212f)
                curveTo(43.8613f, 28.118f, 43.8725f, 28.118f, 43.8831f, 28.1212f)
                curveTo(43.8869f, 28.1288f, 43.8869f, 28.1378f, 43.8831f, 28.1454f)
                curveTo(43.8869f, 28.1531f, 43.8869f, 28.1621f, 43.8831f, 28.1697f)
                curveTo(43.8725f, 28.1729f, 43.8613f, 28.1729f, 43.8507f, 28.1697f)
                horizontalLineTo(43.7914f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFF5F00)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(24.4592f, 6.0763f)
                horizontalLineToRelative(8.4944f)
                verticalLineToRelative(15.2656f)
                horizontalLineToRelative(-8.4944f)
                close()
            }
            path(fill = SolidColor(Color(0xFFEB001B)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(24.9986f, 13.7105f)
                curveTo(24.9954f, 10.7311f, 26.3628f, 7.9158f, 28.7064f, 6.0763f)
                curveTo(24.7262f, 2.9482f, 19.0103f, 3.4039f, 15.5758f, 7.123f)
                curveTo(12.1414f, 10.8421f, 12.1414f, 16.5761f, 15.5758f, 20.2952f)
                curveTo(19.0103f, 24.0144f, 24.7262f, 24.47f, 28.7064f, 21.3419f)
                curveTo(26.3635f, 19.503f, 24.9962f, 16.6889f, 24.9986f, 13.7105f)
                close()
            }
            path(fill = SolidColor(Color(0xFFF79E1B)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(44.4143f, 13.7104f)
                curveTo(44.4142f, 17.4273f, 42.2919f, 20.8178f, 38.9487f, 22.4421f)
                curveTo(35.6055f, 24.0663f, 31.6284f, 23.6391f, 28.7064f, 21.3419f)
                curveTo(31.0484f, 19.5014f, 32.4157f, 16.6877f, 32.4157f, 13.7091f)
                curveTo(32.4157f, 10.7305f, 31.0484f, 7.9167f, 28.7064f, 6.0763f)
                curveTo(31.6284f, 3.779f, 35.6055f, 3.3518f, 38.9487f, 4.9761f)
                curveTo(42.2919f, 6.6003f, 44.4142f, 9.9909f, 44.4143f, 13.7077f)
                verticalLineTo(13.7104f)
                close()
            }
        }
        .build()
        return _mastercardIdCheck!!
    }

private var _mastercardIdCheck: ImageVector? = null
