package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.Ing: ImageVector
    get() {
        if (_ing != null) {
            return _ing!!
        }
        _ing = Builder(name = "Ing", defaultWidth = 58.0.dp, defaultHeight = 40.0.dp, viewportWidth
                = 58.0f, viewportHeight = 40.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                        strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                        strokeLineMiter = 4.0f, pathFillType = NonZero) {
                    moveTo(54.0f, 0.5f)
                    horizontalLineTo(4.0f)
                    curveTo(2.067f, 0.5f, 0.5f, 2.067f, 0.5f, 4.0f)
                    verticalLineTo(36.0f)
                    curveTo(0.5f, 37.933f, 2.067f, 39.5f, 4.0f, 39.5f)
                    horizontalLineTo(54.0f)
                    curveTo(55.933f, 39.5f, 57.5f, 37.933f, 57.5f, 36.0f)
                    verticalLineTo(4.0f)
                    curveTo(57.5f, 2.067f, 55.933f, 0.5f, 54.0f, 0.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF000066)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(31.43f, 22.63f)
                    verticalLineTo(25.1f)
                    curveTo(30.2234f, 25.7607f, 28.8753f, 26.1209f, 27.5f, 26.15f)
                    curveTo(23.92f, 26.15f, 21.76f, 24.0f, 21.76f, 21.3f)
                    curveTo(21.7742f, 20.5813f, 21.9308f, 19.8725f, 22.2206f, 19.2146f)
                    curveTo(22.5104f, 18.5567f, 22.9277f, 17.9628f, 23.4484f, 17.4672f)
                    curveTo(23.9692f, 16.9715f, 24.583f, 16.584f, 25.2544f, 16.3271f)
                    curveTo(25.9258f, 16.0701f, 26.6414f, 15.9488f, 27.36f, 15.97f)
                    curveTo(28.1764f, 15.9677f, 28.9841f, 16.1381f, 29.73f, 16.47f)
                    curveTo(29.93f, 16.56f, 30.11f, 16.63f, 30.3f, 16.63f)
                    curveTo(30.56f, 16.63f, 30.6f, 16.3f, 30.61f, 16.06f)
                    verticalLineTo(15.98f)
                    horizontalLineTo(30.96f)
                    lineTo(31.28f, 19.32f)
                    horizontalLineTo(30.86f)
                    curveTo(30.7219f, 18.7237f, 30.4166f, 18.1791f, 29.98f, 17.75f)
                    curveTo(29.6481f, 17.4206f, 29.2527f, 17.162f, 28.8177f, 16.9901f)
                    curveTo(28.3828f, 16.8182f, 27.9175f, 16.7365f, 27.45f, 16.75f)
                    curveTo(25.3f, 16.75f, 24.05f, 18.48f, 24.05f, 21.07f)
                    curveTo(24.05f, 23.67f, 25.59f, 25.37f, 27.63f, 25.37f)
                    curveTo(28.2599f, 25.3611f, 28.8792f, 25.2071f, 29.44f, 24.92f)
                    verticalLineTo(22.37f)
                    curveTo(29.44f, 21.55f, 29.32f, 21.23f, 28.14f, 21.23f)
                    verticalLineTo(20.85f)
                    horizontalLineTo(32.46f)
                    verticalLineTo(21.23f)
                    curveTo(31.43f, 21.23f, 31.43f, 21.55f, 31.43f, 22.49f)
                    verticalLineTo(22.63f)
                    close()
                    moveTo(19.56f, 18.5f)
                    verticalLineTo(25.95f)
                    horizontalLineTo(18.99f)
                    lineTo(11.71f, 18.25f)
                    curveTo(11.73f, 18.45f, 11.74f, 18.65f, 11.73f, 18.85f)
                    verticalLineTo(23.52f)
                    curveTo(11.73f, 24.95f, 11.73f, 25.48f, 13.01f, 25.48f)
                    verticalLineTo(25.88f)
                    horizontalLineTo(9.57f)
                    verticalLineTo(25.5f)
                    curveTo(10.9f, 25.5f, 10.9f, 24.87f, 10.9f, 23.55f)
                    verticalLineTo(18.23f)
                    curveTo(10.9f, 17.43f, 10.9f, 16.55f, 9.52f, 16.55f)
                    verticalLineTo(16.2f)
                    horizontalLineTo(12.76f)
                    lineTo(18.77f, 22.45f)
                    curveTo(18.7355f, 22.2856f, 18.7187f, 22.118f, 18.72f, 21.95f)
                    verticalLineTo(18.35f)
                    curveTo(18.72f, 17.08f, 18.72f, 16.52f, 17.5f, 16.52f)
                    verticalLineTo(16.18f)
                    horizontalLineTo(20.9f)
                    verticalLineTo(16.52f)
                    curveTo(19.63f, 16.52f, 19.56f, 17.07f, 19.56f, 18.5f)
                    close()
                    moveTo(3.0f, 25.5f)
                    verticalLineTo(25.9f)
                    horizontalLineTo(7.83f)
                    verticalLineTo(25.5f)
                    curveTo(6.93f, 25.5f, 6.43f, 25.45f, 6.43f, 24.23f)
                    verticalLineTo(17.85f)
                    curveTo(6.43f, 16.57f, 6.85f, 16.55f, 7.83f, 16.55f)
                    verticalLineTo(16.2f)
                    horizontalLineTo(3.0f)
                    verticalLineTo(16.55f)
                    curveTo(3.96f, 16.55f, 4.4f, 16.6f, 4.4f, 17.85f)
                    verticalLineTo(24.23f)
                    curveTo(4.4f, 25.43f, 3.83f, 25.5f, 3.0f, 25.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(48.16f, 18.73f)
                    lineTo(49.19f, 19.53f)
                    lineTo(49.85f, 20.98f)
                    lineTo(50.15f, 24.73f)
                    lineTo(48.55f, 25.9f)
                    horizontalLineTo(40.0f)
                    lineTo(39.59f, 25.75f)
                    lineTo(36.62f, 25.8f)
                    lineTo(35.17f, 25.77f)
                    lineTo(34.93f, 25.65f)
                    lineTo(34.88f, 24.9f)
                    lineTo(35.24f, 24.35f)
                    lineTo(36.25f, 23.87f)
                    lineTo(37.06f, 23.97f)
                    lineTo(37.46f, 22.77f)
                    lineTo(38.04f, 21.73f)
                    lineTo(37.38f, 20.2f)
                    lineTo(37.87f, 19.45f)
                    lineTo(37.3f, 17.32f)
                    lineTo(37.45f, 15.78f)
                    lineTo(37.97f, 14.85f)
                    lineTo(38.27f, 14.13f)
                    lineTo(39.12f, 13.9f)
                    lineTo(40.62f, 14.43f)
                    lineTo(41.74f, 13.93f)
                    lineTo(42.73f, 14.13f)
                    lineTo(43.14f, 15.33f)
                    lineTo(44.27f, 18.57f)
                    lineTo(45.5f, 19.77f)
                    lineTo(47.34f, 19.52f)
                    lineTo(47.66f, 18.82f)
                    lineTo(48.15f, 18.72f)
                    lineTo(48.16f, 18.73f)
                    close()
                    moveTo(50.05f, 15.05f)
                    lineTo(50.63f, 16.25f)
                    lineTo(49.46f, 16.55f)
                    curveTo(49.1828f, 16.4625f, 48.9122f, 16.3555f, 48.65f, 16.23f)
                    curveTo(48.5831f, 16.1505f, 48.5261f, 16.0632f, 48.48f, 15.97f)
                    lineTo(48.43f, 15.9f)
                    lineTo(48.48f, 15.25f)
                    lineTo(49.58f, 14.87f)
                    lineTo(49.92f, 14.97f)
                    lineTo(50.05f, 15.05f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFF6600)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(52.61f, 17.07f)
                    curveTo(56.56f, 22.23f, 54.0f, 26.0f, 47.76f, 25.75f)
                    curveTo(47.47f, 25.7f, 47.84f, 25.11f, 48.1f, 25.0f)
                    lineTo(48.32f, 25.43f)
                    curveTo(48.59f, 25.24f, 48.35f, 24.8f, 48.2f, 24.73f)
                    lineTo(48.42f, 24.53f)
                    curveTo(49.5f, 24.39f, 47.05f, 23.95f, 47.54f, 25.75f)
                    horizontalLineTo(47.17f)
                    curveTo(47.22f, 25.51f, 47.05f, 24.73f, 47.41f, 25.05f)
                    curveTo(47.57f, 24.83f, 47.5f, 24.68f, 47.31f, 24.5f)
                    lineTo(47.41f, 24.25f)
                    curveTo(47.41f, 24.25f, 47.78f, 24.38f, 47.73f, 24.32f)
                    curveTo(47.45f, 23.92f, 48.13f, 24.4f, 48.0f, 24.02f)
                    curveTo(47.78f, 23.95f, 47.24f, 23.86f, 47.2f, 24.1f)
                    curveTo(46.9f, 24.14f, 46.7f, 24.22f, 46.43f, 24.23f)
                    curveTo(46.2238f, 24.4226f, 46.0972f, 24.6854f, 46.075f, 24.9667f)
                    curveTo(46.0528f, 25.248f, 46.1366f, 25.5274f, 46.31f, 25.75f)
                    horizontalLineTo(42.34f)
                    curveTo(42.4f, 25.6f, 42.49f, 25.45f, 42.58f, 25.32f)
                    curveTo(42.61f, 25.56f, 43.13f, 25.48f, 43.22f, 25.32f)
                    curveTo(43.0366f, 25.2755f, 42.8657f, 25.19f, 42.72f, 25.07f)
                    curveTo(42.87f, 24.54f, 42.38f, 24.02f, 41.94f, 24.52f)
                    curveTo(41.83f, 24.48f, 41.7f, 24.32f, 41.58f, 24.32f)
                    curveTo(41.58f, 24.21f, 41.58f, 24.09f, 41.6f, 23.98f)
                    curveTo(41.88f, 23.85f, 42.14f, 24.04f, 42.4f, 24.05f)
                    verticalLineTo(23.98f)
                    curveTo(42.05f, 23.48f, 41.5f, 23.73f, 41.18f, 23.88f)
                    curveTo(40.9747f, 23.9033f, 40.7792f, 23.9806f, 40.6134f, 24.1039f)
                    curveTo(40.4476f, 24.2273f, 40.3175f, 24.3924f, 40.2362f, 24.5824f)
                    curveTo(40.1549f, 24.7723f, 40.1254f, 24.9805f, 40.1507f, 25.1856f)
                    curveTo(40.1759f, 25.3907f, 40.255f, 25.5854f, 40.38f, 25.75f)
                    horizontalLineTo(35.22f)
                    curveTo(35.0757f, 25.5641f, 34.9973f, 25.3354f, 34.9973f, 25.1f)
                    curveTo(34.9973f, 24.8646f, 35.0757f, 24.6359f, 35.22f, 24.45f)
                    curveTo(35.206f, 24.3384f, 35.2221f, 24.2251f, 35.2667f, 24.1219f)
                    curveTo(35.3113f, 24.0186f, 35.3827f, 23.9292f, 35.4735f, 23.8628f)
                    curveTo(35.5644f, 23.7965f, 35.6713f, 23.7557f, 35.7832f, 23.7447f)
                    curveTo(35.8951f, 23.7336f, 36.008f, 23.7527f, 36.11f, 23.8f)
                    curveTo(36.1728f, 23.7094f, 36.2547f, 23.6338f, 36.35f, 23.5784f)
                    curveTo(36.4454f, 23.5231f, 36.5517f, 23.4895f, 36.6615f, 23.4799f)
                    curveTo(36.7713f, 23.4704f, 36.8819f, 23.4852f, 36.9853f, 23.5232f)
                    curveTo(37.0887f, 23.5612f, 37.1825f, 23.6216f, 37.26f, 23.7f)
                    curveTo(37.42f, 22.94f, 37.69f, 22.21f, 38.04f, 21.52f)
                    curveTo(37.77f, 20.67f, 37.09f, 19.68f, 37.74f, 18.9f)
                    curveTo(37.62f, 18.9f, 37.39f, 19.03f, 37.38f, 19.15f)
                    curveTo(37.35f, 18.91f, 37.18f, 18.39f, 37.55f, 18.33f)
                    verticalLineTo(17.85f)
                    lineTo(37.25f, 18.1f)
                    verticalLineTo(17.55f)
                    curveTo(37.73f, 16.93f, 37.15f, 15.64f, 37.95f, 15.07f)
                    verticalLineTo(14.53f)
                    curveTo(38.08f, 14.49f, 38.15f, 14.32f, 38.29f, 14.28f)
                    lineTo(38.09f, 14.25f)
                    curveTo(38.23f, 13.88f, 38.49f, 13.56f, 38.82f, 13.35f)
                    curveTo(39.05f, 13.42f, 39.28f, 13.47f, 39.52f, 13.5f)
                    curveTo(39.4876f, 13.4448f, 39.4443f, 13.3969f, 39.3927f, 13.3591f)
                    curveTo(39.3411f, 13.3212f, 39.2823f, 13.2943f, 39.22f, 13.28f)
                    verticalLineTo(13.25f)
                    curveTo(39.37f, 13.15f, 39.55f, 13.08f, 39.74f, 13.07f)
                    curveTo(39.76f, 13.24f, 39.93f, 13.35f, 39.98f, 13.5f)
                    lineTo(40.1f, 13.55f)
                    curveTo(40.08f, 13.35f, 40.17f, 13.15f, 39.98f, 13.0f)
                    curveTo(40.4f, 13.06f, 40.7f, 13.42f, 41.11f, 13.13f)
                    curveTo(41.04f, 13.33f, 40.99f, 13.53f, 40.96f, 13.75f)
                    curveTo(41.06f, 13.67f, 41.11f, 13.55f, 41.21f, 13.47f)
                    curveTo(41.21f, 13.32f, 41.31f, 13.22f, 41.35f, 13.07f)
                    curveTo(41.55f, 13.04f, 41.76f, 13.04f, 41.97f, 13.07f)
                    curveTo(41.77f, 13.13f, 41.8f, 13.27f, 41.8f, 13.37f)
                    curveTo(42.06f, 13.33f, 42.34f, 13.11f, 42.56f, 13.37f)
                    curveTo(42.45f, 13.43f, 42.34f, 13.48f, 42.24f, 13.55f)
                    curveTo(42.32f, 13.55f, 42.82f, 13.58f, 42.88f, 13.5f)
                    curveTo(43.32f, 13.75f, 43.48f, 14.29f, 43.66f, 14.75f)
                    curveTo(43.5973f, 14.7092f, 43.5302f, 14.6757f, 43.46f, 14.65f)
                    curveTo(43.96f, 15.35f, 44.8f, 16.05f, 44.86f, 17.05f)
                    curveTo(44.74f, 16.95f, 44.58f, 17.02f, 44.47f, 16.85f)
                    curveTo(44.4777f, 16.9773f, 44.5337f, 17.0969f, 44.6266f, 17.1843f)
                    curveTo(44.7196f, 17.2717f, 44.8424f, 17.3202f, 44.97f, 17.32f)
                    curveTo(45.09f, 17.54f, 45.17f, 17.79f, 45.17f, 18.05f)
                    curveTo(45.118f, 17.9965f, 45.0571f, 17.9525f, 44.99f, 17.92f)
                    curveTo(44.79f, 18.07f, 45.14f, 18.3f, 45.23f, 18.32f)
                    verticalLineTo(18.87f)
                    curveTo(45.5484f, 19.1562f, 45.9525f, 19.329f, 46.3794f, 19.3616f)
                    curveTo(46.8062f, 19.3942f, 47.2319f, 19.2846f, 47.59f, 19.05f)
                    curveTo(49.43f, 16.27f, 51.74f, 22.55f, 50.78f, 24.3f)
                    curveTo(55.66f, 24.77f, 53.75f, 17.6f, 50.86f, 16.52f)
                    lineTo(49.75f, 16.57f)
                    curveTo(49.27f, 16.41f, 48.77f, 15.95f, 48.91f, 16.02f)
                    curveTo(48.94f, 15.96f, 49.34f, 16.03f, 49.33f, 15.98f)
                    curveTo(49.51f, 15.88f, 49.72f, 15.85f, 49.92f, 15.88f)
                    curveTo(49.8121f, 15.7889f, 49.6849f, 15.7235f, 49.5481f, 15.6889f)
                    curveTo(49.4112f, 15.6542f, 49.2682f, 15.6512f, 49.13f, 15.68f)
                    curveTo(49.16f, 15.74f, 49.18f, 15.81f, 49.18f, 15.88f)
                    curveTo(49.04f, 15.84f, 48.89f, 15.82f, 48.74f, 15.82f)
                    curveTo(48.56f, 15.58f, 48.49f, 15.17f, 48.15f, 15.07f)
                    verticalLineTo(15.0f)
                    curveTo(48.74f, 14.9f, 49.35f, 14.52f, 49.95f, 14.75f)
                    lineTo(49.8f, 14.9f)
                    curveTo(49.95f, 15.03f, 50.14f, 15.1f, 50.34f, 15.1f)
                    lineTo(50.21f, 14.8f)
                    curveTo(50.96f, 15.61f, 51.76f, 16.37f, 52.61f, 17.07f)
                    close()
                    moveTo(40.96f, 24.8f)
                    curveTo(40.96f, 25.12f, 41.03f, 25.43f, 41.16f, 25.73f)
                    horizontalLineTo(40.76f)
                    curveTo(40.19f, 25.25f, 41.09f, 24.46f, 40.54f, 24.55f)
                    curveTo(40.54f, 24.5f, 40.59f, 24.42f, 40.69f, 24.3f)
                    lineTo(41.06f, 24.23f)
                    curveTo(40.9807f, 24.409f, 40.9463f, 24.6047f, 40.96f, 24.8f)
                    close()
                    moveTo(46.97f, 24.4f)
                    verticalLineTo(24.38f)
                    verticalLineTo(24.4f)
                    close()
                    moveTo(46.97f, 24.4f)
                    curveTo(46.83f, 24.83f, 46.82f, 25.3f, 46.95f, 25.73f)
                    horizontalLineTo(46.63f)
                    curveTo(46.48f, 25.45f, 46.25f, 24.95f, 46.48f, 24.7f)
                    curveTo(46.55f, 24.8f, 46.55f, 24.91f, 46.63f, 25.0f)
                    curveTo(46.6736f, 24.9664f, 46.7089f, 24.9232f, 46.7331f, 24.8738f)
                    curveTo(46.7574f, 24.8244f, 46.7701f, 24.7701f, 46.7701f, 24.715f)
                    curveTo(46.7701f, 24.6599f, 46.7574f, 24.6056f, 46.7331f, 24.5562f)
                    curveTo(46.7089f, 24.5068f, 46.6736f, 24.4636f, 46.63f, 24.43f)
                    lineTo(46.96f, 24.4f)
                    horizontalLineTo(46.97f)
                    close()
                    moveTo(42.24f, 24.65f)
                    curveTo(42.77f, 24.69f, 42.24f, 25.41f, 42.19f, 25.72f)
                    horizontalLineTo(41.97f)
                    curveTo(42.03f, 25.53f, 41.87f, 24.62f, 42.24f, 24.65f)
                    close()
                    moveTo(41.74f, 24.77f)
                    lineTo(41.45f, 24.5f)
                    curveTo(41.1f, 24.76f, 41.36f, 25.36f, 41.45f, 25.73f)
                    horizontalLineTo(41.7f)
                    lineTo(41.75f, 24.77f)
                    horizontalLineTo(41.74f)
                    close()
                    moveTo(50.38f, 15.8f)
                    curveTo(50.4485f, 15.8034f, 50.5147f, 15.8258f, 50.5712f, 15.8646f)
                    curveTo(50.6277f, 15.9035f, 50.6723f, 15.9573f, 50.7f, 16.02f)
                    curveTo(50.73f, 15.86f, 50.51f, 15.51f, 50.43f, 15.38f)
                    curveTo(50.27f, 15.38f, 50.16f, 15.48f, 50.01f, 15.5f)
                    curveTo(50.14f, 15.5f, 50.28f, 15.68f, 50.38f, 15.8f)
                    close()
                    moveTo(49.67f, 15.27f)
                    horizontalLineTo(49.3f)
                    curveTo(49.11f, 15.15f, 49.04f, 15.4f, 48.8f, 15.17f)
                    curveTo(48.98f, 15.15f, 49.15f, 15.09f, 49.3f, 15.0f)
                    curveTo(49.44f, 15.07f, 49.56f, 15.16f, 49.67f, 15.28f)
                    verticalLineTo(15.27f)
                    close()
                    moveTo(48.3f, 19.07f)
                    curveTo(48.5f, 19.11f, 48.69f, 19.17f, 48.86f, 19.27f)
                    curveTo(48.8471f, 19.1489f, 48.806f, 19.0324f, 48.74f, 18.93f)
                    curveTo(48.6f, 18.88f, 48.35f, 18.98f, 48.34f, 18.75f)
                    curveTo(48.09f, 18.58f, 47.76f, 19.07f, 47.88f, 19.25f)
                    curveTo(48.0f, 19.15f, 48.15f, 19.1f, 48.3f, 19.07f)
                    close()
                    moveTo(48.81f, 19.77f)
                    curveTo(48.53f, 19.71f, 48.15f, 19.68f, 47.98f, 19.97f)
                    curveTo(47.75f, 19.45f, 48.78f, 19.19f, 48.84f, 19.77f)
                    horizontalLineTo(48.81f)
                    close()
                    moveTo(49.6f, 20.52f)
                    curveTo(49.372f, 20.3476f, 49.0918f, 20.2585f, 48.8062f, 20.2676f)
                    curveTo(48.5205f, 20.2767f, 48.2465f, 20.3834f, 48.03f, 20.57f)
                    lineTo(47.96f, 20.25f)
                    curveTo(48.47f, 19.95f, 49.44f, 19.77f, 49.59f, 20.52f)
                    horizontalLineTo(49.6f)
                    close()
                    moveTo(49.72f, 21.27f)
                    curveTo(49.72f, 21.17f, 49.62f, 21.03f, 49.62f, 20.93f)
                    curveTo(49.14f, 20.6f, 48.72f, 20.83f, 48.1f, 20.88f)
                    verticalLineTo(21.23f)
                    curveTo(48.9f, 21.11f, 48.85f, 20.86f, 49.72f, 21.27f)
                    close()
                    moveTo(49.4f, 22.02f)
                    curveTo(49.0f, 21.98f, 48.9f, 21.48f, 48.4f, 21.8f)
                    curveTo(48.3373f, 21.725f, 48.2867f, 21.6406f, 48.25f, 21.55f)
                    curveTo(48.8f, 21.32f, 49.37f, 21.35f, 49.4f, 22.02f)
                    close()
                    moveTo(43.41f, 16.98f)
                    lineTo(43.12f, 17.05f)
                    lineTo(43.29f, 16.3f)
                    curveTo(43.3662f, 16.3938f, 43.4172f, 16.5054f, 43.4382f, 16.6244f)
                    curveTo(43.4592f, 16.7434f, 43.4495f, 16.8658f, 43.41f, 16.98f)
                    close()
                    moveTo(49.94f, 23.73f)
                    curveTo(50.0195f, 23.6233f, 50.0598f, 23.4926f, 50.0544f, 23.3597f)
                    curveTo(50.0489f, 23.2268f, 49.9979f, 23.0998f, 49.91f, 23.0f)
                    curveTo(49.82f, 23.16f, 49.82f, 23.28f, 49.74f, 23.43f)
                    lineTo(49.94f, 23.73f)
                    close()
                    moveTo(49.23f, 22.83f)
                    curveTo(48.96f, 22.62f, 48.81f, 22.03f, 48.34f, 22.53f)
                    curveTo(48.26f, 21.76f, 48.82f, 22.17f, 49.23f, 22.27f)
                    verticalLineTo(22.82f)
                    verticalLineTo(22.83f)
                    close()
                    moveTo(46.53f, 20.27f)
                    curveTo(46.68f, 20.5f, 46.87f, 20.69f, 47.09f, 20.85f)
                    curveTo(47.17f, 20.45f, 46.68f, 20.17f, 46.35f, 20.05f)
                    lineTo(46.53f, 20.27f)
                    close()
                    moveTo(44.18f, 18.27f)
                    curveTo(43.83f, 18.29f, 43.68f, 17.88f, 43.76f, 17.57f)
                    curveTo(43.79f, 17.67f, 43.84f, 17.77f, 43.91f, 17.85f)
                    curveTo(44.08f, 17.8f, 44.12f, 18.15f, 44.18f, 18.27f)
                    close()
                    moveTo(49.72f, 24.4f)
                    curveTo(49.75f, 24.3f, 49.88f, 24.1f, 49.74f, 24.1f)
                    curveTo(49.7552f, 24.0022f, 49.7404f, 23.902f, 49.6975f, 23.8128f)
                    curveTo(49.6547f, 23.7235f, 49.5858f, 23.6493f, 49.5f, 23.6f)
                    lineTo(49.38f, 23.85f)
                    curveTo(49.46f, 24.08f, 49.7f, 24.19f, 49.72f, 24.4f)
                    close()
                    moveTo(49.12f, 23.2f)
                    curveTo(49.12f, 23.32f, 49.09f, 23.44f, 49.06f, 23.55f)
                    curveTo(48.81f, 23.52f, 48.81f, 23.25f, 48.81f, 23.2f)
                    curveTo(48.64f, 23.0f, 48.44f, 23.16f, 48.25f, 23.18f)
                    curveTo(48.17f, 22.99f, 48.27f, 22.97f, 48.27f, 22.82f)
                    curveTo(48.37f, 22.82f, 48.47f, 22.75f, 48.57f, 22.82f)
                    curveTo(48.74f, 22.75f, 48.84f, 22.94f, 49.01f, 22.92f)
                    curveTo(49.04f, 23.02f, 49.08f, 23.12f, 49.13f, 23.2f)
                    horizontalLineTo(49.12f)
                    close()
                    moveTo(47.39f, 21.93f)
                    curveTo(47.37f, 21.07f, 46.94f, 21.66f, 47.39f, 22.18f)
                    curveTo(47.3646f, 22.0986f, 47.3646f, 22.0114f, 47.39f, 21.93f)
                    close()
                    moveTo(44.42f, 19.03f)
                    verticalLineTo(19.05f)
                    curveTo(44.22f, 18.93f, 44.1f, 18.73f, 43.83f, 18.87f)
                    curveTo(43.83f, 18.95f, 43.88f, 18.97f, 43.91f, 19.02f)
                    curveTo(44.04f, 18.97f, 44.34f, 19.13f, 44.41f, 19.05f)
                    horizontalLineTo(44.42f)
                    verticalLineTo(19.02f)
                    verticalLineTo(19.03f)
                    close()
                    moveTo(44.59f, 19.8f)
                    curveTo(44.6735f, 19.8655f, 44.7757f, 19.9028f, 44.8817f, 19.9064f)
                    curveTo(44.9878f, 19.91f, 45.0923f, 19.8797f, 45.18f, 19.82f)
                    curveTo(45.0675f, 19.7879f, 44.9599f, 19.7408f, 44.86f, 19.68f)
                    lineTo(44.59f, 19.8f)
                    close()
                    moveTo(46.92f, 21.8f)
                    lineTo(46.9f, 22.5f)
                    curveTo(46.6f, 21.95f, 46.56f, 20.93f, 45.9f, 20.55f)
                    curveTo(45.9877f, 20.5373f, 46.0771f, 20.5441f, 46.1618f, 20.5701f)
                    curveTo(46.2465f, 20.596f, 46.3245f, 20.6404f, 46.39f, 20.7f)
                    curveTo(46.38f, 20.77f, 46.48f, 20.84f, 46.53f, 20.9f)
                    curveTo(46.79f, 20.91f, 46.72f, 21.25f, 46.9f, 21.38f)
                    lineTo(46.7f, 21.6f)
                    curveTo(46.79f, 21.67f, 46.9f, 21.7f, 46.95f, 21.8f)
                    horizontalLineTo(46.92f)
                    close()
                    moveTo(45.51f, 20.92f)
                    curveTo(45.73f, 20.77f, 45.48f, 20.56f, 45.38f, 20.4f)
                    curveTo(45.3372f, 20.4938f, 45.321f, 20.5975f, 45.3334f, 20.6999f)
                    curveTo(45.3457f, 20.8022f, 45.3861f, 20.8991f, 45.45f, 20.98f)
                    curveTo(45.469f, 20.959f, 45.489f, 20.939f, 45.51f, 20.92f)
                    close()
                    moveTo(48.79f, 23.92f)
                    curveTo(48.74f, 23.72f, 48.52f, 23.69f, 48.37f, 23.65f)
                    curveTo(48.3896f, 23.5853f, 48.3964f, 23.5173f, 48.39f, 23.45f)
                    curveTo(48.09f, 23.23f, 47.96f, 23.5f, 47.73f, 23.72f)
                    curveTo(47.99f, 23.6f, 48.21f, 23.44f, 48.25f, 23.9f)
                    curveTo(48.4095f, 23.8919f, 48.5682f, 23.9264f, 48.71f, 24.0f)
                    lineTo(48.79f, 23.92f)
                    close()
                    moveTo(45.89f, 21.65f)
                    curveTo(45.92f, 21.65f, 46.01f, 21.58f, 46.01f, 21.52f)
                    horizontalLineTo(46.04f)
                    curveTo(46.11f, 21.45f, 46.04f, 21.32f, 45.92f, 21.25f)
                    curveTo(45.9f, 21.1f, 45.95f, 20.98f, 45.77f, 20.95f)
                    curveTo(45.7316f, 21.0037f, 45.7043f, 21.0645f, 45.6895f, 21.1289f)
                    curveTo(45.6748f, 21.1933f, 45.673f, 21.2599f, 45.6841f, 21.325f)
                    curveTo(45.6953f, 21.3901f, 45.7192f, 21.4523f, 45.7545f, 21.5081f)
                    curveTo(45.7899f, 21.5639f, 45.8359f, 21.6121f, 45.89f, 21.65f)
                    close()
                    moveTo(43.41f, 18.18f)
                    curveTo(42.9915f, 17.9354f, 42.5232f, 17.7884f, 42.04f, 17.75f)
                    curveTo(42.0547f, 17.8337f, 42.0478f, 17.9197f, 42.02f, 18.0f)
                    curveTo(42.42f, 18.17f, 42.78f, 18.4f, 43.12f, 18.68f)
                    verticalLineTo(19.0f)
                    curveTo(42.8135f, 18.628f, 42.4129f, 18.3449f, 41.96f, 18.18f)
                    curveTo(41.94f, 18.28f, 41.8f, 18.34f, 41.79f, 18.48f)
                    curveTo(41.52f, 18.14f, 40.8f, 18.21f, 40.84f, 17.7f)
                    curveTo(40.919f, 17.6705f, 40.9905f, 17.6237f, 41.0493f, 17.5632f)
                    curveTo(41.1081f, 17.5027f, 41.1528f, 17.4299f, 41.18f, 17.35f)
                    curveTo(42.31f, 16.78f, 39.09f, 16.95f, 40.47f, 17.3f)
                    curveTo(40.458f, 17.3841f, 40.4753f, 17.4697f, 40.519f, 17.5426f)
                    curveTo(40.5627f, 17.6154f, 40.6302f, 17.671f, 40.71f, 17.7f)
                    verticalLineTo(18.08f)
                    curveTo(40.3643f, 18.1015f, 40.0285f, 18.2042f, 39.73f, 18.38f)
                    curveTo(39.6349f, 18.3126f, 39.5534f, 18.2278f, 39.49f, 18.13f)
                    curveTo(39.09f, 18.3f, 38.71f, 18.53f, 38.36f, 18.8f)
                    verticalLineTo(18.55f)
                    curveTo(38.66f, 18.31f, 38.99f, 18.12f, 39.34f, 17.98f)
                    verticalLineTo(17.73f)
                    curveTo(39.1287f, 17.7007f, 38.9138f, 17.7139f, 38.7077f, 17.7688f)
                    curveTo(38.5016f, 17.8238f, 38.3086f, 17.9194f, 38.14f, 18.05f)
                    curveTo(38.14f, 17.97f, 38.14f, 17.9f, 38.12f, 17.82f)
                    curveTo(38.49f, 17.59f, 38.92f, 17.47f, 39.37f, 17.5f)
                    curveTo(39.37f, 17.41f, 39.37f, 17.21f, 39.27f, 17.2f)
                    curveTo(39.05f, 17.0f, 38.9f, 16.74f, 38.85f, 16.45f)
                    lineTo(39.0f, 16.4f)
                    curveTo(38.93f, 16.2f, 38.85f, 15.68f, 39.0f, 15.5f)
                    curveTo(38.8361f, 15.4118f, 38.6954f, 15.2861f, 38.5894f, 15.1332f)
                    curveTo(38.4834f, 14.9802f, 38.4151f, 14.8044f, 38.39f, 14.62f)
                    lineTo(38.66f, 14.12f)
                    curveTo(38.6992f, 14.1227f, 38.7385f, 14.1149f, 38.7736f, 14.0973f)
                    curveTo(38.8088f, 14.0797f, 38.8386f, 14.053f, 38.86f, 14.02f)
                    curveTo(38.9865f, 13.9481f, 39.1295f, 13.9103f, 39.275f, 13.9103f)
                    curveTo(39.4205f, 13.9103f, 39.5635f, 13.9481f, 39.69f, 14.02f)
                    curveTo(39.74f, 14.26f, 40.05f, 14.29f, 40.09f, 14.6f)
                    curveTo(40.3323f, 14.617f, 40.5695f, 14.678f, 40.79f, 14.78f)
                    curveTo(41.05f, 14.63f, 41.36f, 14.58f, 41.65f, 14.63f)
                    curveTo(41.71f, 14.49f, 41.75f, 14.34f, 41.8f, 14.2f)
                    curveTo(41.9195f, 14.1119f, 42.0587f, 14.0543f, 42.2055f, 14.0324f)
                    curveTo(42.3524f, 14.0104f, 42.5024f, 14.0247f, 42.6424f, 14.074f)
                    curveTo(42.7824f, 14.1233f, 42.9083f, 14.2061f, 43.009f, 14.3152f)
                    curveTo(43.1096f, 14.4244f, 43.1821f, 14.5565f, 43.22f, 14.7f)
                    curveTo(43.2106f, 14.8555f, 43.1683f, 15.0072f, 43.0959f, 15.1451f)
                    curveTo(43.0235f, 15.283f, 42.9227f, 15.404f, 42.8f, 15.5f)
                    curveTo(42.73f, 15.5f, 42.7f, 15.59f, 42.63f, 15.57f)
                    curveTo(42.71f, 15.85f, 42.69f, 16.14f, 42.56f, 16.4f)
                    curveTo(42.63f, 16.35f, 42.73f, 16.35f, 42.73f, 16.25f)
                    curveTo(42.7402f, 16.5039f, 42.6791f, 16.7555f, 42.5537f, 16.9765f)
                    curveTo(42.4282f, 17.1974f, 42.2433f, 17.3788f, 42.02f, 17.5f)
                    verticalLineTo(17.6f)
                    curveTo(42.51f, 17.6f, 42.99f, 17.74f, 43.42f, 17.98f)
                    verticalLineTo(18.18f)
                    horizontalLineTo(43.41f)
                    close()
                    moveTo(44.61f, 20.43f)
                    lineTo(44.79f, 20.35f)
                    curveTo(44.5727f, 20.285f, 44.3762f, 20.1644f, 44.22f, 20.0f)
                    curveTo(44.1348f, 20.092f, 44.0229f, 20.1549f, 43.9f, 20.18f)
                    curveTo(43.9969f, 20.2681f, 44.1107f, 20.3357f, 44.2344f, 20.3787f)
                    curveTo(44.3582f, 20.4216f, 44.4893f, 20.4391f, 44.62f, 20.43f)
                    horizontalLineTo(44.61f)
                    close()
                    moveTo(43.83f, 19.57f)
                    curveTo(43.63f, 19.57f, 43.41f, 19.67f, 43.29f, 19.47f)
                    lineTo(43.51f, 19.25f)
                    lineTo(43.83f, 19.57f)
                    close()
                    moveTo(46.45f, 23.17f)
                    curveTo(46.75f, 22.75f, 46.29f, 22.39f, 46.38f, 21.77f)
                    curveTo(45.61f, 22.29f, 46.55f, 22.72f, 46.33f, 23.35f)
                    curveTo(46.36f, 23.29f, 46.4f, 23.23f, 46.45f, 23.18f)
                    verticalLineTo(23.17f)
                    close()
                    moveTo(45.85f, 22.45f)
                    curveTo(45.85f, 22.65f, 45.69f, 22.83f, 45.67f, 23.02f)
                    curveTo(45.6808f, 22.8375f, 45.6198f, 22.6581f, 45.5f, 22.52f)
                    curveTo(45.21f, 21.75f, 45.55f, 21.49f, 45.82f, 22.45f)
                    horizontalLineTo(45.84f)
                    horizontalLineTo(45.85f)
                    close()
                    moveTo(43.0f, 19.95f)
                    horizontalLineTo(43.01f)
                    verticalLineTo(19.97f)
                    lineTo(43.0f, 19.95f)
                    close()
                    moveTo(43.0f, 19.95f)
                    curveTo(42.83f, 19.98f, 42.68f, 19.82f, 42.52f, 19.77f)
                    curveTo(42.4802f, 19.6005f, 42.4301f, 19.4335f, 42.37f, 19.27f)
                    curveTo(42.8f, 19.35f, 42.71f, 19.71f, 43.0f, 19.95f)
                    close()
                    moveTo(43.97f, 20.95f)
                    curveTo(43.8046f, 20.9537f, 43.6404f, 20.9216f, 43.4885f, 20.8561f)
                    curveTo(43.3366f, 20.7905f, 43.2007f, 20.6929f, 43.09f, 20.57f)
                    curveTo(43.2f, 20.51f, 43.33f, 20.46f, 43.46f, 20.43f)
                    curveTo(43.59f, 20.63f, 43.76f, 20.81f, 43.96f, 20.95f)
                    horizontalLineTo(43.97f)
                    close()
                    moveTo(38.01f, 15.68f)
                    lineTo(38.25f, 15.6f)
                    verticalLineTo(15.18f)
                    curveTo(38.17f, 15.2353f, 38.1058f, 15.3105f, 38.0638f, 15.3982f)
                    curveTo(38.0217f, 15.4859f, 38.0031f, 15.583f, 38.01f, 15.68f)
                    close()
                    moveTo(42.61f, 20.43f)
                    curveTo(42.05f, 20.69f, 41.96f, 19.9f, 42.18f, 19.55f)
                    curveTo(42.26f, 19.89f, 42.27f, 20.23f, 42.6f, 20.43f)
                    horizontalLineTo(42.62f)
                    horizontalLineTo(42.61f)
                    close()
                    moveTo(41.34f, 19.2f)
                    curveTo(41.5236f, 19.0203f, 41.6311f, 18.7768f, 41.64f, 18.52f)
                    curveTo(41.3561f, 18.3735f, 41.0418f, 18.2954f, 40.7224f, 18.292f)
                    curveTo(40.4029f, 18.2885f, 40.087f, 18.3597f, 39.8f, 18.5f)
                    curveTo(39.78f, 18.7f, 39.84f, 18.9f, 39.97f, 19.05f)
                    lineTo(40.14f, 18.87f)
                    curveTo(40.17f, 19.01f, 40.18f, 19.14f, 40.17f, 19.27f)
                    curveTo(40.26f, 19.35f, 40.37f, 19.38f, 40.49f, 19.37f)
                    curveTo(40.54f, 19.23f, 40.54f, 19.03f, 40.69f, 18.95f)
                    lineTo(40.73f, 18.98f)
                    lineTo(40.76f, 19.38f)
                    curveTo(40.8167f, 19.3982f, 40.8769f, 19.4031f, 40.9358f, 19.3945f)
                    curveTo(40.9947f, 19.3858f, 41.0509f, 19.3637f, 41.1f, 19.33f)
                    lineTo(41.2f, 18.88f)
                    curveTo(41.29f, 18.96f, 41.34f, 19.08f, 41.34f, 19.2f)
                    close()
                    moveTo(43.4f, 21.33f)
                    curveTo(43.2036f, 21.3695f, 43.0006f, 21.3601f, 42.8087f, 21.3025f)
                    curveTo(42.6169f, 21.245f, 42.4422f, 21.1411f, 42.3f, 21.0f)
                    curveTo(42.5f, 20.93f, 42.7f, 20.9f, 42.91f, 20.9f)
                    lineTo(43.01f, 21.13f)
                    curveTo(43.15f, 21.18f, 43.28f, 21.24f, 43.41f, 21.33f)
                    horizontalLineTo(43.4f)
                    close()
                    moveTo(38.1f, 16.8f)
                    curveTo(38.15f, 16.63f, 38.16f, 16.45f, 38.14f, 16.26f)
                    lineTo(38.32f, 16.06f)
                    curveTo(37.76f, 16.15f, 37.88f, 16.8f, 38.05f, 17.16f)
                    curveTo(38.05f, 17.04f, 38.07f, 16.92f, 38.1f, 16.8f)
                    close()
                    moveTo(41.82f, 20.57f)
                    curveTo(41.42f, 20.46f, 41.24f, 20.17f, 41.65f, 19.94f)
                    curveTo(41.67f, 20.16f, 41.73f, 20.37f, 41.82f, 20.57f)
                    close()
                    moveTo(44.96f, 24.12f)
                    horizontalLineTo(44.98f)
                    curveTo(45.0f, 23.62f, 45.03f, 23.16f, 44.62f, 22.82f)
                    curveTo(44.62f, 23.2f, 44.92f, 23.52f, 44.79f, 23.94f)
                    curveTo(44.86f, 23.94f, 44.91f, 24.05f, 44.96f, 24.12f)
                    close()
                    moveTo(44.2f, 22.82f)
                    curveTo(44.12f, 22.8351f, 44.0374f, 22.826f, 43.9626f, 22.7939f)
                    curveTo(43.8878f, 22.7619f, 43.8242f, 22.7083f, 43.78f, 22.64f)
                    curveTo(43.6102f, 22.5881f, 43.4318f, 22.5702f, 43.255f, 22.5874f)
                    curveTo(43.0783f, 22.6045f, 42.9067f, 22.6564f, 42.75f, 22.74f)
                    curveTo(42.8103f, 22.5927f, 42.9148f, 22.4677f, 43.049f, 22.3822f)
                    curveTo(43.1833f, 22.2967f, 43.3407f, 22.2549f, 43.4997f, 22.2626f)
                    curveTo(43.6587f, 22.2703f, 43.8114f, 22.327f, 43.9368f, 22.4251f)
                    curveTo(44.0622f, 22.5231f, 44.1542f, 22.6576f, 44.2f, 22.81f)
                    verticalLineTo(22.82f)
                    close()
                    moveTo(40.79f, 20.67f)
                    curveTo(41.04f, 20.57f, 41.06f, 20.24f, 41.06f, 19.99f)
                    curveTo(40.96f, 20.12f, 40.85f, 20.23f, 40.72f, 20.31f)
                    lineTo(40.79f, 20.67f)
                    close()
                    moveTo(42.19f, 21.51f)
                    curveTo(42.0864f, 21.6006f, 41.957f, 21.6566f, 41.82f, 21.67f)
                    curveTo(41.606f, 21.4748f, 41.4178f, 21.253f, 41.26f, 21.01f)
                    curveTo(41.4469f, 21.0106f, 41.6309f, 21.0564f, 41.7963f, 21.1435f)
                    curveTo(41.9617f, 21.2305f, 42.1036f, 21.3563f, 42.21f, 21.51f)
                    horizontalLineTo(42.19f)
                    close()
                    moveTo(44.09f, 23.44f)
                    curveTo(44.1457f, 23.4574f, 44.1994f, 23.4809f, 44.25f, 23.51f)
                    curveTo(44.25f, 22.92f, 43.57f, 22.95f, 43.13f, 22.97f)
                    verticalLineTo(22.92f)
                    curveTo(42.91f, 22.94f, 42.7f, 22.98f, 42.49f, 23.04f)
                    lineTo(42.32f, 23.44f)
                    curveTo(42.49f, 23.29f, 42.7f, 23.2f, 42.93f, 23.17f)
                    curveTo(43.15f, 23.37f, 43.55f, 23.12f, 43.83f, 23.24f)
                    curveTo(43.8551f, 23.2891f, 43.8904f, 23.3324f, 43.9335f, 23.3668f)
                    curveTo(43.9766f, 23.4013f, 44.0265f, 23.4263f, 44.08f, 23.44f)
                    horizontalLineTo(44.09f)
                    close()
                    moveTo(40.33f, 20.56f)
                    curveTo(40.13f, 20.36f, 39.96f, 20.19f, 39.96f, 19.96f)
                    curveTo(40.06f, 19.96f, 40.16f, 19.98f, 40.26f, 20.04f)
                    curveTo(40.26f, 20.24f, 40.33f, 20.35f, 40.32f, 20.56f)
                    horizontalLineTo(40.33f)
                    close()
                    moveTo(39.56f, 19.99f)
                    lineTo(39.69f, 19.56f)
                    lineTo(39.32f, 19.36f)
                    curveTo(39.37f, 19.59f, 39.45f, 19.8f, 39.56f, 19.99f)
                    close()
                    moveTo(44.59f, 24.22f)
                    curveTo(44.53f, 24.35f, 44.49f, 24.49f, 44.44f, 24.64f)
                    curveTo(44.37f, 24.42f, 44.3f, 24.11f, 44.05f, 24.12f)
                    curveTo(44.0463f, 24.0689f, 44.0311f, 24.0194f, 44.0055f, 23.975f)
                    curveTo(43.98f, 23.9306f, 43.9447f, 23.8926f, 43.9024f, 23.8638f)
                    curveTo(43.8601f, 23.8349f, 43.8119f, 23.816f, 43.7612f, 23.8084f)
                    curveTo(43.7106f, 23.8009f, 43.6589f, 23.8048f, 43.61f, 23.82f)
                    curveTo(43.62f, 23.95f, 43.83f, 23.94f, 43.68f, 24.12f)
                    curveTo(43.7984f, 24.155f, 43.8997f, 24.2326f, 43.9643f, 24.3379f)
                    curveTo(44.029f, 24.4431f, 44.0524f, 24.5685f, 44.03f, 24.69f)
                    lineTo(43.83f, 24.82f)
                    curveTo(43.8295f, 24.6653f, 43.7912f, 24.513f, 43.7184f, 24.3765f)
                    curveTo(43.6457f, 24.2399f, 43.5407f, 24.1232f, 43.4125f, 24.0365f)
                    curveTo(43.2844f, 23.9497f, 43.137f, 23.8956f, 42.9832f, 23.8788f)
                    curveTo(42.8294f, 23.862f, 42.6738f, 23.883f, 42.53f, 23.94f)
                    curveTo(42.76f, 23.26f, 44.22f, 23.44f, 44.37f, 24.09f)
                    curveTo(44.42f, 24.09f, 44.57f, 24.09f, 44.57f, 24.22f)
                    horizontalLineTo(44.59f)
                    close()
                    moveTo(41.82f, 22.59f)
                    horizontalLineTo(41.9f)
                    lineTo(41.7f, 22.21f)
                    horizontalLineTo(41.43f)
                    curveTo(41.42f, 22.44f, 41.63f, 22.53f, 41.82f, 22.59f)
                    close()
                    moveTo(39.25f, 20.09f)
                    lineTo(39.21f, 20.08f)
                    curveTo(39.1513f, 19.8462f, 39.0263f, 19.6344f, 38.85f, 19.47f)
                    curveTo(38.85f, 19.34f, 38.72f, 19.25f, 38.61f, 19.24f)
                    curveTo(38.6117f, 19.4247f, 38.6703f, 19.6043f, 38.7776f, 19.7546f)
                    curveTo(38.8849f, 19.9048f, 39.0359f, 20.0185f, 39.21f, 20.08f)
                    verticalLineTo(20.12f)
                    lineTo(39.25f, 20.09f)
                    close()
                    moveTo(40.73f, 21.63f)
                    curveTo(40.8104f, 21.5509f, 40.866f, 21.4502f, 40.89f, 21.34f)
                    lineTo(40.86f, 21.31f)
                    curveTo(40.46f, 21.3f, 40.3f, 21.79f, 40.08f, 22.04f)
                    curveTo(40.25f, 21.98f, 40.67f, 21.82f, 40.73f, 21.64f)
                    verticalLineTo(21.63f)
                    close()
                    moveTo(43.39f, 24.69f)
                    lineTo(43.29f, 24.79f)
                    curveTo(43.24f, 24.42f, 42.99f, 24.35f, 42.7f, 24.19f)
                    curveTo(42.97f, 23.99f, 43.49f, 24.39f, 43.36f, 24.69f)
                    horizontalLineTo(43.39f)
                    close()
                    moveTo(39.91f, 21.56f)
                    curveTo(40.1f, 21.46f, 40.25f, 21.28f, 40.32f, 21.06f)
                    curveTo(39.96f, 21.03f, 39.71f, 21.41f, 39.42f, 21.56f)
                    curveTo(39.58f, 21.6f, 39.74f, 21.6f, 39.91f, 21.56f)
                    close()
                    moveTo(41.01f, 22.66f)
                    curveTo(40.75f, 22.89f, 40.51f, 22.69f, 40.39f, 22.44f)
                    horizontalLineTo(40.89f)
                    lineTo(41.01f, 22.67f)
                    verticalLineTo(22.66f)
                    close()
                    moveTo(38.37f, 20.14f)
                    lineTo(38.51f, 20.01f)
                    lineTo(38.21f, 19.94f)
                    curveTo(38.1262f, 20.0012f, 38.0661f, 20.0896f, 38.04f, 20.19f)
                    curveTo(38.09f, 20.29f, 38.11f, 20.39f, 38.12f, 20.49f)
                    curveTo(38.1594f, 20.3501f, 38.2482f, 20.2293f, 38.37f, 20.15f)
                    verticalLineTo(20.14f)
                    close()
                    moveTo(38.9f, 20.54f)
                    curveTo(38.86f, 20.78f, 38.74f, 21.0f, 38.56f, 21.17f)
                    curveTo(38.56f, 20.96f, 38.65f, 20.78f, 38.66f, 20.59f)
                    curveTo(38.74f, 20.55f, 38.83f, 20.49f, 38.9f, 20.54f)
                    close()
                    moveTo(39.24f, 21.47f)
                    lineTo(39.39f, 20.97f)
                    horizontalLineTo(39.24f)
                    curveTo(39.11f, 21.21f, 38.91f, 21.42f, 38.66f, 21.54f)
                    curveTo(38.86f, 21.58f, 39.06f, 21.55f, 39.24f, 21.47f)
                    close()
                    moveTo(39.56f, 22.72f)
                    lineTo(39.51f, 23.26f)
                    curveTo(39.26f, 22.75f, 38.67f, 22.12f, 38.09f, 22.44f)
                    verticalLineTo(22.31f)
                    lineTo(38.33f, 22.04f)
                    curveTo(38.5137f, 22.0372f, 38.6956f, 22.0763f, 38.8619f, 22.1543f)
                    curveTo(39.0282f, 22.2322f, 39.1746f, 22.347f, 39.29f, 22.49f)
                    verticalLineTo(22.59f)
                    curveTo(39.38f, 22.64f, 39.47f, 22.69f, 39.56f, 22.72f)
                    close()
                    moveTo(39.1f, 24.04f)
                    lineTo(39.34f, 23.81f)
                    curveTo(39.4f, 23.49f, 39.06f, 23.5f, 39.03f, 23.24f)
                    curveTo(38.76f, 23.11f, 38.62f, 22.82f, 38.33f, 22.74f)
                    curveTo(38.2807f, 22.6903f, 38.2173f, 22.6571f, 38.1484f, 22.6448f)
                    curveTo(38.0796f, 22.6324f, 38.0086f, 22.6417f, 37.9451f, 22.6712f)
                    curveTo(37.8817f, 22.7007f, 37.8289f, 22.7491f, 37.794f, 22.8098f)
                    curveTo(37.7591f, 22.8704f, 37.7437f, 22.9403f, 37.75f, 23.01f)
                    lineTo(38.17f, 22.94f)
                    curveTo(38.55f, 23.35f, 39.12f, 23.44f, 39.1f, 24.04f)
                    close()
                    moveTo(38.85f, 24.31f)
                    lineTo(38.73f, 24.67f)
                    curveTo(38.6898f, 24.3835f, 38.549f, 24.1206f, 38.3329f, 23.9283f)
                    curveTo(38.1167f, 23.7359f, 37.8392f, 23.6267f, 37.55f, 23.62f)
                    curveTo(37.5451f, 23.5689f, 37.5515f, 23.5172f, 37.5688f, 23.4689f)
                    curveTo(37.5861f, 23.4205f, 37.6138f, 23.3765f, 37.65f, 23.34f)
                    curveTo(37.8437f, 23.3192f, 38.0382f, 23.3727f, 38.194f, 23.4896f)
                    curveTo(38.3499f, 23.6065f, 38.4557f, 23.7782f, 38.49f, 23.97f)
                    lineTo(38.81f, 24.04f)
                    lineTo(38.85f, 24.31f)
                    close()
                    moveTo(37.45f, 25.31f)
                    curveTo(37.45f, 25.31f, 37.89f, 24.91f, 37.89f, 24.67f)
                    lineTo(37.92f, 24.64f)
                    curveTo(37.92f, 24.44f, 37.7f, 24.32f, 37.55f, 24.24f)
                    lineTo(37.7f, 24.04f)
                    curveTo(36.9f, 23.76f, 36.68f, 24.91f, 36.8f, 25.47f)
                    curveTo(36.93f, 25.16f, 37.1f, 24.87f, 37.28f, 24.59f)
                    curveTo(37.38f, 24.6f, 37.48f, 24.65f, 37.55f, 24.72f)
                    curveTo(37.55f, 24.92f, 37.45f, 25.12f, 37.45f, 25.32f)
                    verticalLineTo(25.31f)
                    close()
                    moveTo(36.7f, 24.44f)
                    curveTo(36.7f, 24.58f, 36.67f, 24.72f, 36.6f, 24.84f)
                    curveTo(36.57f, 24.69f, 36.48f, 24.51f, 36.3f, 24.51f)
                    curveTo(36.2246f, 24.6284f, 36.1812f, 24.7645f, 36.1742f, 24.9047f)
                    curveTo(36.1672f, 25.045f, 36.1967f, 25.1846f, 36.26f, 25.31f)
                    curveTo(36.1764f, 25.406f, 36.0744f, 25.4842f, 35.96f, 25.54f)
                    curveTo(35.8659f, 25.2753f, 35.8441f, 24.9902f, 35.8968f, 24.7143f)
                    curveTo(35.9496f, 24.4383f, 36.0749f, 24.1814f, 36.26f, 23.97f)
                    horizontalLineTo(36.65f)
                    curveTo(36.48f, 23.97f, 36.48f, 24.11f, 36.48f, 24.22f)
                    curveTo(36.5105f, 24.2172f, 36.5413f, 24.2208f, 36.5703f, 24.2306f)
                    curveTo(36.5994f, 24.2404f, 36.6261f, 24.2562f, 36.6487f, 24.2769f)
                    curveTo(36.6713f, 24.2976f, 36.6893f, 24.3228f, 36.7016f, 24.3509f)
                    curveTo(36.7138f, 24.379f, 36.7201f, 24.4093f, 36.72f, 24.44f)
                    horizontalLineTo(36.7f)
                    close()
                    moveTo(35.77f, 24.81f)
                    lineTo(35.82f, 24.84f)
                    curveTo(35.8417f, 24.7921f, 35.8538f, 24.7403f, 35.8555f, 24.6877f)
                    curveTo(35.8572f, 24.6351f, 35.8486f, 24.5827f, 35.83f, 24.5335f)
                    curveTo(35.8114f, 24.4843f, 35.7833f, 24.4392f, 35.7473f, 24.4008f)
                    curveTo(35.7112f, 24.3625f, 35.668f, 24.3316f, 35.62f, 24.31f)
                    curveTo(35.3f, 24.55f, 35.14f, 25.36f, 35.54f, 25.54f)
                    curveTo(35.64f, 25.24f, 35.44f, 25.0f, 35.56f, 24.72f)
                    curveTo(35.64f, 24.72f, 35.71f, 24.76f, 35.76f, 24.82f)
                    horizontalLineTo(35.77f)
                    verticalLineTo(24.81f)
                    close()
                    moveTo(42.85f, 15.19f)
                    curveTo(42.9081f, 14.9947f, 42.8923f, 14.7848f, 42.8056f, 14.6004f)
                    curveTo(42.7189f, 14.416f, 42.5674f, 14.2699f, 42.38f, 14.19f)
                    curveTo(42.18f, 14.3f, 41.91f, 14.45f, 41.94f, 14.72f)
                    curveTo(42.18f, 14.85f, 42.38f, 15.05f, 42.51f, 15.29f)
                    curveTo(42.63f, 15.2864f, 42.7471f, 15.2519f, 42.85f, 15.19f)
                    close()
                    moveTo(41.65f, 15.29f)
                    curveTo(41.67f, 15.29f, 41.72f, 15.29f, 41.72f, 15.39f)
                    curveTo(41.35f, 15.5f, 41.35f, 15.18f, 41.09f, 15.09f)
                    curveTo(41.37f, 14.96f, 41.44f, 15.2f, 41.65f, 15.29f)
                    close()
                    moveTo(42.24f, 15.81f)
                    curveTo(42.24f, 15.81f, 42.31f, 15.81f, 42.24f, 15.79f)
                    verticalLineTo(15.81f)
                    close()
                    moveTo(42.24f, 15.79f)
                    lineTo(41.5f, 15.66f)
                    curveTo(41.45f, 15.77f, 41.27f, 15.78f, 41.25f, 15.89f)
                    horizontalLineTo(41.18f)
                    curveTo(41.24f, 16.18f, 41.26f, 16.47f, 41.26f, 16.76f)
                    curveTo(41.3378f, 16.7626f, 41.4116f, 16.7953f, 41.4657f, 16.8513f)
                    curveTo(41.5198f, 16.9073f, 41.55f, 16.9821f, 41.55f, 17.06f)
                    lineTo(41.95f, 17.26f)
                    curveTo(42.02f, 17.25f, 42.05f, 17.11f, 42.09f, 17.01f)
                    curveTo(41.95f, 16.84f, 41.65f, 16.96f, 41.65f, 16.64f)
                    lineTo(41.45f, 16.57f)
                    curveTo(41.45f, 16.38f, 41.43f, 16.2f, 41.4f, 16.02f)
                    horizontalLineTo(41.45f)
                    lineTo(41.55f, 16.14f)
                    curveTo(41.88f, 16.22f, 42.03f, 15.91f, 42.24f, 15.79f)
                    close()
                    moveTo(40.24f, 15.12f)
                    curveTo(40.35f, 15.06f, 40.5f, 15.0f, 40.54f, 15.06f)
                    horizontalLineTo(40.57f)
                    curveTo(40.47f, 15.16f, 40.38f, 15.26f, 40.32f, 15.39f)
                    horizontalLineTo(39.93f)
                    curveTo(39.95f, 15.23f, 40.09f, 15.16f, 40.23f, 15.12f)
                    horizontalLineTo(40.24f)
                    close()
                    moveTo(39.81f, 14.69f)
                    curveTo(39.48f, 13.61f, 38.03f, 14.72f, 39.15f, 15.12f)
                    curveTo(39.35f, 14.95f, 39.57f, 14.81f, 39.81f, 14.69f)
                    close()
                    moveTo(41.81f, 17.72f)
                    verticalLineTo(17.86f)
                    lineTo(41.45f, 17.72f)
                    horizontalLineTo(41.82f)
                    horizontalLineTo(41.81f)
                    close()
                    moveTo(40.27f, 15.86f)
                    curveTo(40.28f, 15.56f, 39.46f, 15.69f, 39.29f, 15.66f)
                    curveTo(39.29f, 15.713f, 39.3111f, 15.7639f, 39.3486f, 15.8014f)
                    curveTo(39.3861f, 15.8389f, 39.437f, 15.86f, 39.49f, 15.86f)
                    curveTo(39.52f, 16.06f, 39.71f, 16.22f, 39.89f, 16.09f)
                    curveTo(40.28f, 16.06f, 39.99f, 16.87f, 39.61f, 16.86f)
                    curveTo(39.61f, 16.99f, 39.5f, 17.15f, 39.61f, 17.26f)
                    curveTo(39.72f, 17.19f, 39.84f, 17.13f, 39.96f, 17.09f)
                    curveTo(39.96f, 16.96f, 40.06f, 16.86f, 40.2f, 16.79f)
                    curveTo(40.18f, 16.48f, 40.27f, 16.17f, 40.27f, 15.86f)
                    close()
                    moveTo(40.0f, 17.7f)
                    lineTo(40.01f, 17.72f)
                    verticalLineTo(17.7f)
                    horizontalLineTo(40.0f)
                    close()
                    moveTo(39.82f, 17.66f)
                    curveTo(39.89f, 17.66f, 39.96f, 17.64f, 40.0f, 17.7f)
                    curveTo(39.887f, 17.7182f, 39.7823f, 17.7705f, 39.7f, 17.85f)
                    curveTo(39.6653f, 17.8304f, 39.6373f, 17.8009f, 39.6194f, 17.7653f)
                    curveTo(39.6016f, 17.7296f, 39.5948f, 17.6895f, 39.6f, 17.65f)
                    curveTo(39.67f, 17.67f, 39.74f, 17.68f, 39.82f, 17.66f)
                    close()
                }
            }
        }
        .build()
        return _ing!!
    }

private var _ing: ImageVector? = null
