package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.DinersClubInternational: ImageVector
    get() {
        if (_dinersClubInternational != null) {
            return _dinersClubInternational!!
        }
        _dinersClubInternational = Builder(name = "DinersClubInternational", defaultWidth = 58.0.dp,
                defaultHeight = 40.0.dp, viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(8.8322f, 24.2047f)
                curveTo(8.8322f, 23.4203f, 8.4224f, 23.4718f, 8.0303f, 23.4636f)
                verticalLineTo(23.2368f)
                curveTo(8.3703f, 23.2533f, 8.7188f, 23.2533f, 9.0597f, 23.2533f)
                curveTo(9.4258f, 23.2533f, 9.9229f, 23.2368f, 10.5688f, 23.2368f)
                curveTo(12.8276f, 23.2368f, 14.058f, 24.7451f, 14.058f, 26.2897f)
                curveTo(14.058f, 27.1541f, 13.552f, 29.3255f, 10.4639f, 29.3255f)
                curveTo(10.0194f, 29.3255f, 9.6089f, 29.3083f, 9.1991f, 29.3083f)
                curveTo(8.8069f, 29.3083f, 8.4224f, 29.3164f, 8.0303f, 29.3255f)
                verticalLineTo(29.0986f)
                curveTo(8.5532f, 29.0458f, 8.8069f, 29.0287f, 8.8322f, 28.4357f)
                verticalLineTo(24.2047f)
                close()
                moveTo(9.687f, 28.2957f)
                curveTo(9.687f, 28.9676f, 10.1673f, 29.0458f, 10.5945f, 29.0458f)
                curveTo(12.4792f, 29.0458f, 13.0977f, 27.6243f, 13.0977f, 26.3247f)
                curveTo(13.0977f, 24.6936f, 12.0511f, 23.5162f, 10.3678f, 23.5162f)
                curveTo(10.0094f, 23.5162f, 9.8444f, 23.5417f, 9.687f, 23.5511f)
                verticalLineTo(28.2957f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(14.3636f, 29.0987f)
                horizontalLineTo(14.5289f)
                curveTo(14.7731f, 29.0987f, 14.9477f, 29.0987f, 14.9477f, 28.8102f)
                verticalLineTo(26.4465f)
                curveTo(14.9477f, 26.0633f, 14.8171f, 26.0103f, 14.4939f, 25.8363f)
                verticalLineTo(25.6971f)
                curveTo(14.9039f, 25.5738f, 15.3928f, 25.4093f, 15.4273f, 25.383f)
                curveTo(15.4887f, 25.348f, 15.5403f, 25.3387f, 15.5847f, 25.3387f)
                curveTo(15.6274f, 25.3387f, 15.6454f, 25.3911f, 15.6454f, 25.4616f)
                verticalLineTo(28.8102f)
                curveTo(15.6454f, 29.0987f, 15.8376f, 29.0987f, 16.0822f, 29.0987f)
                horizontalLineTo(16.2298f)
                verticalLineTo(29.3256f)
                curveTo(15.9332f, 29.3256f, 15.6274f, 29.3084f, 15.3144f, 29.3084f)
                curveTo(15.0004f, 29.3084f, 14.6861f, 29.3165f, 14.3636f, 29.3256f)
                verticalLineTo(29.0987f)
                close()
                moveTo(15.2968f, 23.9958f)
                curveTo(15.0696f, 23.9958f, 14.8694f, 23.7865f, 14.8694f, 23.5598f)
                curveTo(14.8694f, 23.3413f, 15.0791f, 23.1403f, 15.2968f, 23.1403f)
                curveTo(15.5232f, 23.1403f, 15.7244f, 23.3241f, 15.7244f, 23.5598f)
                curveTo(15.7244f, 23.7957f, 15.532f, 23.9958f, 15.2968f, 23.9958f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(17.0588f, 26.4989f)
                curveTo(17.0588f, 26.1768f, 16.9625f, 26.0896f, 16.5532f, 25.9236f)
                verticalLineTo(25.758f)
                curveTo(16.9276f, 25.636f, 17.285f, 25.5221f, 17.7042f, 25.3386f)
                curveTo(17.7306f, 25.3386f, 17.7559f, 25.3561f, 17.7559f, 25.4258f)
                verticalLineTo(25.993f)
                curveTo(18.2539f, 25.636f, 18.6814f, 25.3386f, 19.2667f, 25.3386f)
                curveTo(20.0071f, 25.3386f, 20.2687f, 25.8796f, 20.2687f, 26.56f)
                verticalLineTo(28.8101f)
                curveTo(20.2687f, 29.0987f, 20.4612f, 29.0987f, 20.7051f, 29.0987f)
                horizontalLineTo(20.8625f)
                verticalLineTo(29.3256f)
                curveTo(20.5562f, 29.3256f, 20.2513f, 29.3084f, 19.9376f, 29.3084f)
                curveTo(19.6234f, 29.3084f, 19.3091f, 29.3164f, 18.9951f, 29.3256f)
                verticalLineTo(29.0987f)
                horizontalLineTo(19.1525f)
                curveTo(19.3968f, 29.0987f, 19.5705f, 29.0987f, 19.5705f, 28.8101f)
                verticalLineTo(26.5519f)
                curveTo(19.5705f, 26.0541f, 19.2667f, 25.8101f, 18.7689f, 25.8101f)
                curveTo(18.4895f, 25.8101f, 18.0446f, 26.0364f, 17.7559f, 26.2292f)
                verticalLineTo(28.8101f)
                curveTo(17.7559f, 29.0987f, 17.9487f, 29.0987f, 18.193f, 29.0987f)
                horizontalLineTo(18.3497f)
                verticalLineTo(29.3256f)
                curveTo(18.0446f, 29.3256f, 17.7392f, 29.3084f, 17.4246f, 29.3084f)
                curveTo(17.1113f, 29.3084f, 16.7969f, 29.3164f, 16.4832f, 29.3256f)
                verticalLineTo(29.0987f)
                horizontalLineTo(16.6405f)
                curveTo(16.8845f, 29.0987f, 17.0588f, 29.0987f, 17.0588f, 28.8101f)
                verticalLineTo(26.4989f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(21.5255f, 26.9183f)
                curveTo(21.5077f, 26.9968f, 21.5077f, 27.1274f, 21.5255f, 27.4242f)
                curveTo(21.5769f, 28.2526f, 22.1102f, 28.9327f, 22.8073f, 28.9327f)
                curveTo(23.2877f, 28.9327f, 23.663f, 28.6709f, 23.9852f, 28.3488f)
                lineTo(24.107f, 28.4709f)
                curveTo(23.7056f, 29.0029f, 23.2086f, 29.4568f, 22.4939f, 29.4568f)
                curveTo(21.1065f, 29.4568f, 20.8275f, 28.1127f, 20.8275f, 27.5548f)
                curveTo(20.8275f, 25.8449f, 21.9786f, 25.3386f, 22.5886f, 25.3386f)
                curveTo(23.296f, 25.3386f, 24.0554f, 25.7835f, 24.0635f, 26.7084f)
                curveTo(24.0635f, 26.7614f, 24.0635f, 26.8131f, 24.0554f, 26.8656f)
                lineTo(23.9765f, 26.9183f)
                horizontalLineTo(21.5255f)
                close()
                moveTo(23.0701f, 26.6389f)
                curveTo(23.2877f, 26.6389f, 23.3132f, 26.5253f, 23.3132f, 26.4202f)
                curveTo(23.3132f, 25.9761f, 23.043f, 25.6184f, 22.5543f, 25.6184f)
                curveTo(22.0227f, 25.6184f, 21.6561f, 26.0102f, 21.5516f, 26.6389f)
                horizontalLineTo(23.0701f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(24.2645f, 29.0987f)
                horizontalLineTo(24.5002f)
                curveTo(24.7435f, 29.0987f, 24.9182f, 29.0987f, 24.9182f, 28.8101f)
                verticalLineTo(26.3595f)
                curveTo(24.9182f, 26.0896f, 24.5957f, 26.0364f, 24.4647f, 25.9667f)
                verticalLineTo(25.8363f)
                curveTo(25.1014f, 25.5657f, 25.4505f, 25.3386f, 25.5303f, 25.3386f)
                curveTo(25.5813f, 25.3386f, 25.6075f, 25.3649f, 25.6075f, 25.4525f)
                verticalLineTo(26.2377f)
                horizontalLineTo(25.6259f)
                curveTo(25.8433f, 25.8976f, 26.2103f, 25.3386f, 26.7421f, 25.3386f)
                curveTo(26.9601f, 25.3386f, 27.2389f, 25.4868f, 27.2389f, 25.8011f)
                curveTo(27.2389f, 26.0364f, 27.074f, 26.2468f, 26.8298f, 26.2468f)
                curveTo(26.5585f, 26.2468f, 26.5585f, 26.0364f, 26.2529f, 26.0364f)
                curveTo(26.1049f, 26.0364f, 25.6163f, 26.2377f, 25.6163f, 26.7614f)
                verticalLineTo(28.8101f)
                curveTo(25.6163f, 29.0987f, 25.7906f, 29.0987f, 26.035f, 29.0987f)
                horizontalLineTo(26.5229f)
                verticalLineTo(29.3256f)
                curveTo(26.0432f, 29.3164f, 25.6781f, 29.3084f, 25.3026f, 29.3084f)
                curveTo(24.9449f, 29.3084f, 24.5784f, 29.3164f, 24.2645f, 29.3256f)
                verticalLineTo(29.0987f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(27.6225f, 28.1126f)
                curveTo(27.7362f, 28.6883f, 28.0844f, 29.1775f, 28.7224f, 29.1775f)
                curveTo(29.2362f, 29.1775f, 29.428f, 28.8631f, 29.428f, 28.558f)
                curveTo(29.428f, 27.5282f, 27.5269f, 27.86f, 27.5269f, 26.4557f)
                curveTo(27.5269f, 25.9667f, 27.9197f, 25.3387f, 28.8793f, 25.3387f)
                curveTo(29.1579f, 25.3387f, 29.5329f, 25.4178f, 29.8728f, 25.5924f)
                lineTo(29.9341f, 26.4814f)
                horizontalLineTo(29.7336f)
                curveTo(29.6464f, 25.9322f, 29.3415f, 25.6183f, 28.7826f, 25.6183f)
                curveTo(28.4337f, 25.6183f, 28.1026f, 25.8186f, 28.1026f, 26.1938f)
                curveTo(28.1026f, 27.215f, 30.1258f, 26.9004f, 30.1258f, 28.27f)
                curveTo(30.1258f, 28.8453f, 29.664f, 29.4567f, 28.6256f, 29.4567f)
                curveTo(28.277f, 29.4567f, 27.8663f, 29.3344f, 27.5619f, 29.1599f)
                lineTo(27.4655f, 28.1566f)
                lineTo(27.6225f, 28.1126f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(38.0025f, 24.8152f)
                horizontalLineTo(37.785f)
                curveTo(37.619f, 23.7956f, 36.8949f, 23.3851f, 35.9186f, 23.3851f)
                curveTo(34.9143f, 23.3851f, 33.4581f, 24.0563f, 33.4581f, 26.1498f)
                curveTo(33.4581f, 27.9125f, 34.7146f, 29.1775f, 36.0576f, 29.1775f)
                curveTo(36.9204f, 29.1775f, 37.6373f, 28.5841f, 37.8114f, 27.6676f)
                lineTo(38.0121f, 27.7197f)
                lineTo(37.8114f, 28.9937f)
                curveTo(37.445f, 29.2208f, 36.459f, 29.4567f, 35.8827f, 29.4567f)
                curveTo(33.8424f, 29.4567f, 32.5515f, 28.1392f, 32.5515f, 26.1767f)
                curveTo(32.5515f, 24.388f, 34.1478f, 23.1053f, 35.8575f, 23.1053f)
                curveTo(36.5638f, 23.1053f, 37.244f, 23.3328f, 37.9158f, 23.5685f)
                lineTo(38.0025f, 24.8152f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(38.3175f, 29.0987f)
                horizontalLineTo(38.4826f)
                curveTo(38.7277f, 29.0987f, 38.9018f, 29.0987f, 38.9018f, 28.8102f)
                verticalLineTo(23.9527f)
                curveTo(38.9018f, 23.3851f, 38.7712f, 23.3679f, 38.4393f, 23.2717f)
                verticalLineTo(23.132f)
                curveTo(38.7881f, 23.0188f, 39.1548f, 22.8621f, 39.3384f, 22.7566f)
                curveTo(39.4331f, 22.7051f, 39.5035f, 22.6605f, 39.5292f, 22.6605f)
                curveTo(39.5825f, 22.6605f, 39.5998f, 22.7135f, 39.5998f, 22.7836f)
                verticalLineTo(28.8102f)
                curveTo(39.5998f, 29.0987f, 39.7919f, 29.0987f, 40.0358f, 29.0987f)
                horizontalLineTo(40.1835f)
                verticalLineTo(29.3256f)
                curveTo(39.8878f, 29.3256f, 39.5825f, 29.3084f, 39.2683f, 29.3084f)
                curveTo(38.9544f, 29.3084f, 38.6407f, 29.3165f, 38.3175f, 29.3256f)
                verticalLineTo(29.0987f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(43.9183f, 28.8453f)
                curveTo(43.9183f, 29.0029f, 44.0137f, 29.0111f, 44.1616f, 29.0111f)
                curveTo(44.2668f, 29.0111f, 44.3971f, 29.0029f, 44.5114f, 29.0029f)
                verticalLineTo(29.1865f)
                curveTo(44.136f, 29.221f, 43.4204f, 29.4043f, 43.2544f, 29.4567f)
                lineTo(43.2109f, 29.4301f)
                verticalLineTo(28.7235f)
                curveTo(42.6881f, 29.1507f, 42.2864f, 29.4567f, 41.6662f, 29.4567f)
                curveTo(41.1953f, 29.4567f, 40.7071f, 29.1507f, 40.7071f, 28.419f)
                verticalLineTo(26.1852f)
                curveTo(40.7071f, 25.9581f, 40.6724f, 25.74f, 40.1846f, 25.697f)
                verticalLineTo(25.5308f)
                curveTo(40.4989f, 25.5222f, 41.1953f, 25.4701f, 41.309f, 25.4701f)
                curveTo(41.4058f, 25.4701f, 41.4058f, 25.5308f, 41.4058f, 25.7231f)
                verticalLineTo(27.9734f)
                curveTo(41.4058f, 28.2353f, 41.4058f, 28.9847f, 42.1646f, 28.9847f)
                curveTo(42.4606f, 28.9847f, 42.8532f, 28.7585f, 43.2194f, 28.4536f)
                verticalLineTo(26.1065f)
                curveTo(43.2194f, 25.9322f, 42.8009f, 25.8363f, 42.4874f, 25.7495f)
                verticalLineTo(25.5926f)
                curveTo(43.2717f, 25.5394f, 43.7607f, 25.4701f, 43.8479f, 25.4701f)
                curveTo(43.9183f, 25.4701f, 43.9183f, 25.5308f, 43.9183f, 25.6271f)
                verticalLineTo(28.8453f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(45.6536f, 25.9668f)
                curveTo(46.0024f, 25.6708f, 46.4736f, 25.3386f, 46.9533f, 25.3386f)
                curveTo(47.9654f, 25.3386f, 48.5761f, 26.2206f, 48.5761f, 27.1712f)
                curveTo(48.5761f, 28.3136f, 47.7383f, 29.4568f, 46.4903f, 29.4568f)
                curveTo(45.8455f, 29.4568f, 45.5052f, 29.2467f, 45.278f, 29.1508f)
                lineTo(45.0171f, 29.3515f)
                lineTo(44.8342f, 29.2559f)
                curveTo(44.9122f, 28.7413f, 44.9562f, 28.2354f, 44.9562f, 27.703f)
                verticalLineTo(23.9527f)
                curveTo(44.9562f, 23.3851f, 44.8248f, 23.3679f, 44.4933f, 23.2717f)
                verticalLineTo(23.132f)
                curveTo(44.8426f, 23.0188f, 45.2086f, 22.8621f, 45.3917f, 22.7566f)
                curveTo(45.488f, 22.7051f, 45.5575f, 22.6605f, 45.5841f, 22.6605f)
                curveTo(45.636f, 22.6605f, 45.6536f, 22.7137f, 45.6536f, 22.7836f)
                verticalLineTo(25.9668f)
                close()
                moveTo(45.6536f, 28.3396f)
                curveTo(45.6536f, 28.6709f, 45.9679f, 29.2297f, 46.5521f, 29.2297f)
                curveTo(47.4853f, 29.2297f, 47.8777f, 28.3136f, 47.8777f, 27.5369f)
                curveTo(47.8777f, 26.595f, 47.1632f, 25.8101f, 46.483f, 25.8101f)
                curveTo(46.1589f, 25.8101f, 45.889f, 26.0198f, 45.6536f, 26.2206f)
                verticalLineTo(28.3396f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(12.7292f, 33.6048f)
                lineTo(12.7387f, 33.5954f)
                verticalLineTo(31.816f)
                curveTo(12.7387f, 31.4265f, 12.4678f, 31.3695f, 12.3255f, 31.3695f)
                horizontalLineTo(12.2209f)
                verticalLineTo(31.2271f)
                curveTo(12.4444f, 31.2271f, 12.6627f, 31.2459f, 12.8855f, 31.2459f)
                curveTo(13.0801f, 31.2459f, 13.2755f, 31.2271f, 13.4694f, 31.2271f)
                verticalLineTo(31.3695f)
                horizontalLineTo(13.3988f)
                curveTo(13.1988f, 31.3695f, 12.9757f, 31.4074f, 12.9757f, 31.9723f)
                verticalLineTo(34.1319f)
                curveTo(12.9757f, 34.2983f, 12.9804f, 34.4643f, 13.0037f, 34.6116f)
                horizontalLineTo(12.8233f)
                lineTo(10.3793f, 31.8866f)
                verticalLineTo(33.8426f)
                curveTo(10.3793f, 34.2559f, 10.4596f, 34.3976f, 10.8251f, 34.3976f)
                horizontalLineTo(10.9059f)
                verticalLineTo(34.5403f)
                curveTo(10.7018f, 34.5403f, 10.4979f, 34.5218f, 10.2938f, 34.5218f)
                curveTo(10.0807f, 34.5218f, 9.8621f, 34.5403f, 9.6482f, 34.5403f)
                verticalLineTo(34.3976f)
                horizontalLineTo(9.7149f)
                curveTo(10.0423f, 34.3976f, 10.142f, 34.1745f, 10.142f, 33.7959f)
                verticalLineTo(31.7961f)
                curveTo(10.142f, 31.5305f, 9.923f, 31.3695f, 9.7102f, 31.3695f)
                horizontalLineTo(9.6482f)
                verticalLineTo(31.2271f)
                curveTo(9.8283f, 31.2271f, 10.0137f, 31.2459f, 10.1937f, 31.2459f)
                curveTo(10.3366f, 31.2459f, 10.4742f, 31.2271f, 10.6165f, 31.2271f)
                lineTo(12.7292f, 33.6048f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(13.0037f, 34.6315f)
                lineTo(12.8083f, 34.6248f)
                lineTo(10.3995f, 31.9401f)
                verticalLineTo(33.8425f)
                curveTo(10.4052f, 34.2552f, 10.4679f, 34.3726f, 10.8253f, 34.3771f)
                horizontalLineTo(10.927f)
                verticalLineTo(34.5605f)
                horizontalLineTo(10.9059f)
                curveTo(10.7006f, 34.5605f, 10.4963f, 34.5415f, 10.2938f, 34.5415f)
                curveTo(10.0813f, 34.5415f, 9.8632f, 34.5605f, 9.6481f, 34.5605f)
                horizontalLineTo(9.6273f)
                verticalLineTo(34.3771f)
                horizontalLineTo(9.7149f)
                curveTo(10.0286f, 34.3753f, 10.1183f, 34.1737f, 10.1217f, 33.7957f)
                verticalLineTo(31.7967f)
                curveTo(10.1208f, 31.5439f, 9.9135f, 31.3901f, 9.7104f, 31.3901f)
                horizontalLineTo(9.6273f)
                verticalLineTo(31.2063f)
                horizontalLineTo(9.6481f)
                curveTo(9.8296f, 31.2063f, 10.0153f, 31.2248f, 10.1934f, 31.2248f)
                curveTo(10.335f, 31.2248f, 10.4721f, 31.2063f, 10.6321f, 31.2137f)
                lineTo(12.7181f, 33.5617f)
                verticalLineTo(31.8159f)
                curveTo(12.7157f, 31.439f, 12.4638f, 31.3932f, 12.3257f, 31.3901f)
                horizontalLineTo(12.2001f)
                verticalLineTo(31.2063f)
                horizontalLineTo(12.2211f)
                curveTo(12.4453f, 31.2063f, 12.6638f, 31.2248f, 12.8855f, 31.2248f)
                curveTo(13.0787f, 31.2248f, 13.2732f, 31.2063f, 13.4694f, 31.2063f)
                horizontalLineTo(13.4903f)
                verticalLineTo(31.3901f)
                horizontalLineTo(13.3988f)
                curveTo(13.2028f, 31.3951f, 13.0018f, 31.4124f, 12.996f, 31.9722f)
                verticalLineTo(34.1318f)
                curveTo(12.996f, 34.298f, 13.0012f, 34.4637f, 13.024f, 34.6077f)
                lineTo(13.0284f, 34.6315f)
                horizontalLineTo(13.0037f)
                close()
                moveTo(12.8235f, 34.5901f)
                horizontalLineTo(12.9806f)
                curveTo(12.9594f, 34.4473f, 12.9556f, 34.2897f, 12.9556f, 34.1318f)
                verticalLineTo(31.9722f)
                curveTo(12.9556f, 31.4025f, 13.1944f, 31.3488f, 13.3988f, 31.3484f)
                horizontalLineTo(13.4488f)
                verticalLineTo(31.2474f)
                curveTo(13.2617f, 31.2489f, 13.0743f, 31.2661f, 12.8855f, 31.2661f)
                curveTo(12.6681f, 31.2661f, 12.4568f, 31.2489f, 12.2423f, 31.2474f)
                lineTo(12.2418f, 31.3484f)
                horizontalLineTo(12.3257f)
                curveTo(12.4716f, 31.3488f, 12.7592f, 31.4136f, 12.7592f, 31.8159f)
                lineTo(12.7529f, 33.6102f)
                lineTo(12.7436f, 33.6194f)
                lineTo(12.7274f, 33.6347f)
                lineTo(10.6165f, 31.2474f)
                curveTo(10.4755f, 31.2474f, 10.3382f, 31.2661f, 10.1934f, 31.2661f)
                curveTo(10.0195f, 31.2661f, 9.8412f, 31.2489f, 9.6691f, 31.2474f)
                lineTo(9.6682f, 31.3484f)
                horizontalLineTo(9.7104f)
                curveTo(9.9331f, 31.3488f, 10.1621f, 31.5187f, 10.1621f, 31.7967f)
                verticalLineTo(33.7957f)
                curveTo(10.1621f, 34.1755f, 10.0563f, 34.418f, 9.7149f, 34.4193f)
                lineTo(9.6691f, 34.418f)
                verticalLineTo(34.5199f)
                curveTo(9.8747f, 34.5183f, 10.0865f, 34.5008f, 10.2938f, 34.5008f)
                curveTo(10.4918f, 34.5008f, 10.6894f, 34.5183f, 10.8853f, 34.5199f)
                verticalLineTo(34.4193f)
                horizontalLineTo(10.8253f)
                curveTo(10.4517f, 34.418f, 10.3592f, 34.2552f, 10.3589f, 33.8425f)
                verticalLineTo(31.8333f)
                lineTo(12.8235f, 34.5901f)
                close()
                moveTo(12.7294f, 33.6047f)
                lineTo(12.7443f, 33.591f)
                lineTo(12.7294f, 33.6047f)
                close()
                moveTo(12.7181f, 33.5953f)
                verticalLineTo(33.5935f)
                lineTo(12.7143f, 33.5905f)
                lineTo(12.7181f, 33.5953f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(14.1807f, 31.4643f)
                curveTo(13.8243f, 31.4643f, 13.8104f, 31.5502f, 13.7393f, 31.8962f)
                horizontalLineTo(13.5968f)
                curveTo(13.6155f, 31.7633f, 13.639f, 31.6305f, 13.6538f, 31.4929f)
                curveTo(13.6728f, 31.3594f, 13.6823f, 31.227f, 13.6823f, 31.0897f)
                horizontalLineTo(13.7961f)
                curveTo(13.8343f, 31.2322f, 13.9529f, 31.227f, 14.0817f, 31.227f)
                horizontalLineTo(16.5299f)
                curveTo(16.6587f, 31.227f, 16.7771f, 31.2223f, 16.7868f, 31.0798f)
                lineTo(16.9002f, 31.0992f)
                curveTo(16.8818f, 31.227f, 16.8624f, 31.3553f, 16.8486f, 31.4837f)
                curveTo(16.8392f, 31.6118f, 16.8392f, 31.7396f, 16.8392f, 31.8677f)
                lineTo(16.6966f, 31.9205f)
                curveTo(16.6869f, 31.7451f, 16.6634f, 31.4643f, 16.3453f, 31.4643f)
                horizontalLineTo(15.5668f)
                verticalLineTo(33.9895f)
                curveTo(15.5668f, 34.3557f, 15.7332f, 34.3976f, 15.9607f, 34.3976f)
                horizontalLineTo(16.0512f)
                verticalLineTo(34.5402f)
                curveTo(15.866f, 34.5402f, 15.5336f, 34.5219f, 15.2778f, 34.5219f)
                curveTo(14.9926f, 34.5219f, 14.6601f, 34.5402f, 14.4748f, 34.5402f)
                verticalLineTo(34.3976f)
                horizontalLineTo(14.5654f)
                curveTo(14.827f, 34.3976f, 14.9592f, 34.3742f, 14.9592f, 33.9994f)
                verticalLineTo(31.4643f)
                horizontalLineTo(14.1807f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(16.0516f, 34.5605f)
                curveTo(15.8645f, 34.5605f, 15.5325f, 34.5417f, 15.2777f, 34.5417f)
                curveTo(14.993f, 34.5417f, 14.6609f, 34.5605f, 14.4748f, 34.5605f)
                horizontalLineTo(14.4545f)
                verticalLineTo(34.3771f)
                horizontalLineTo(14.5654f)
                curveTo(14.827f, 34.371f, 14.9321f, 34.3676f, 14.938f, 33.9994f)
                verticalLineTo(31.4847f)
                horizontalLineTo(14.1807f)
                verticalLineTo(31.4431f)
                horizontalLineTo(14.9791f)
                verticalLineTo(33.9994f)
                curveTo(14.9791f, 34.3805f, 14.8255f, 34.419f, 14.5654f, 34.4193f)
                horizontalLineTo(14.4951f)
                verticalLineTo(34.5196f)
                curveTo(14.6823f, 34.5183f, 15.0021f, 34.5009f, 15.2777f, 34.5009f)
                curveTo(15.5248f, 34.5009f, 15.8419f, 34.5183f, 16.03f, 34.5196f)
                verticalLineTo(34.4193f)
                horizontalLineTo(15.9607f)
                curveTo(15.731f, 34.419f, 15.5463f, 34.3626f, 15.5463f, 33.9896f)
                verticalLineTo(31.4431f)
                horizontalLineTo(16.3453f)
                curveTo(16.6637f, 31.4444f, 16.7059f, 31.715f, 16.7158f, 31.8916f)
                lineTo(16.8186f, 31.8537f)
                curveTo(16.8186f, 31.7297f, 16.8191f, 31.6056f, 16.8275f, 31.4809f)
                curveTo(16.8416f, 31.3582f, 16.8588f, 31.2376f, 16.8766f, 31.116f)
                lineTo(16.8045f, 31.1039f)
                curveTo(16.7824f, 31.2421f, 16.6486f, 31.2495f, 16.5297f, 31.2477f)
                horizontalLineTo(14.0569f)
                curveTo(13.9451f, 31.2478f, 13.8235f, 31.2425f, 13.7808f, 31.11f)
                horizontalLineTo(13.7024f)
                curveTo(13.7017f, 31.2412f, 13.6927f, 31.3686f, 13.6748f, 31.4951f)
                curveTo(13.6606f, 31.6255f, 13.6388f, 31.7507f, 13.6216f, 31.8765f)
                horizontalLineTo(13.7229f)
                curveTo(13.7852f, 31.5454f, 13.8259f, 31.4385f, 14.1807f, 31.4431f)
                verticalLineTo(31.4847f)
                curveTo(13.8291f, 31.4917f, 13.8368f, 31.5504f, 13.7594f, 31.9011f)
                lineTo(13.756f, 31.9173f)
                horizontalLineTo(13.5731f)
                lineTo(13.5756f, 31.8927f)
                curveTo(13.595f, 31.7603f, 13.6191f, 31.6269f, 13.6329f, 31.4891f)
                curveTo(13.6527f, 31.3574f, 13.6616f, 31.2258f, 13.6616f, 31.0897f)
                verticalLineTo(31.0687f)
                horizontalLineTo(13.8124f)
                lineTo(13.816f, 31.0836f)
                curveTo(13.8479f, 31.2033f, 13.9358f, 31.2042f, 14.0569f, 31.2063f)
                horizontalLineTo(16.5297f)
                curveTo(16.6619f, 31.2042f, 16.7582f, 31.2024f, 16.7663f, 31.0782f)
                lineTo(16.7679f, 31.0558f)
                lineTo(16.7895f, 31.0601f)
                lineTo(16.9237f, 31.0813f)
                lineTo(16.9203f, 31.1023f)
                curveTo(16.9014f, 31.2297f, 16.8829f, 31.3574f, 16.8685f, 31.4847f)
                curveTo(16.8597f, 31.6119f, 16.8597f, 31.7394f, 16.8597f, 31.8677f)
                verticalLineTo(31.8821f)
                lineTo(16.8459f, 31.8876f)
                lineTo(16.6779f, 31.9491f)
                lineTo(16.6768f, 31.9216f)
                curveTo(16.6637f, 31.743f, 16.6454f, 31.4847f, 16.3453f, 31.4847f)
                horizontalLineTo(15.5877f)
                verticalLineTo(33.9896f)
                curveTo(15.5923f, 34.3475f, 15.7343f, 34.3726f, 15.9607f, 34.3771f)
                horizontalLineTo(16.0717f)
                verticalLineTo(34.5605f)
                horizontalLineTo(16.0516f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(17.0518f, 34.3976f)
                horizontalLineTo(17.1187f)
                curveTo(17.289f, 34.3976f, 17.4699f, 34.3743f, 17.4699f, 34.1272f)
                verticalLineTo(31.6406f)
                curveTo(17.4699f, 31.3932f, 17.289f, 31.3697f, 17.1187f, 31.3697f)
                horizontalLineTo(17.0518f)
                verticalLineTo(31.2271f)
                curveTo(17.3404f, 31.2271f, 17.8352f, 31.2459f, 18.2331f, 31.2459f)
                curveTo(18.6325f, 31.2459f, 19.1255f, 31.2271f, 19.4482f, 31.2271f)
                curveTo(19.4399f, 31.4312f, 19.4444f, 31.7452f, 19.4585f, 31.9536f)
                lineTo(19.3154f, 31.9914f)
                curveTo(19.2926f, 31.6827f, 19.2357f, 31.4365f, 18.7371f, 31.4365f)
                horizontalLineTo(18.0781f)
                verticalLineTo(32.6793f)
                horizontalLineTo(18.6419f)
                curveTo(18.9266f, 32.6793f, 18.9886f, 32.5185f, 19.0168f, 32.2619f)
                horizontalLineTo(19.1591f)
                curveTo(19.1496f, 32.4473f, 19.1446f, 32.6324f, 19.1446f, 32.8173f)
                curveTo(19.1446f, 32.998f, 19.1496f, 33.1782f, 19.1591f, 33.3583f)
                lineTo(19.0168f, 33.3866f)
                curveTo(18.9886f, 33.1022f, 18.9744f, 32.9172f, 18.6465f, 32.9172f)
                horizontalLineTo(18.0781f)
                verticalLineTo(34.0225f)
                curveTo(18.0781f, 34.3315f, 18.3522f, 34.3315f, 18.6562f, 34.3315f)
                curveTo(19.226f, 34.3315f, 19.4773f, 34.2932f, 19.6198f, 33.7528f)
                lineTo(19.7522f, 33.7855f)
                curveTo(19.6906f, 34.0376f, 19.634f, 34.2884f, 19.5914f, 34.5403f)
                curveTo(19.2872f, 34.5403f, 18.7414f, 34.522f, 18.3151f, 34.522f)
                curveTo(17.8869f, 34.522f, 17.3226f, 34.5403f, 17.0518f, 34.5403f)
                verticalLineTo(34.3976f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(19.591f, 34.5605f)
                curveTo(19.2865f, 34.5605f, 18.7403f, 34.5407f, 18.3145f, 34.5407f)
                curveTo(17.8869f, 34.5407f, 17.3227f, 34.5605f, 17.0516f, 34.5605f)
                horizontalLineTo(17.0317f)
                verticalLineTo(34.3771f)
                horizontalLineTo(17.1185f)
                curveTo(17.2902f, 34.3742f, 17.4465f, 34.3591f, 17.4487f, 34.1271f)
                verticalLineTo(31.6406f)
                curveTo(17.4465f, 31.4086f, 17.2902f, 31.3932f, 17.1185f, 31.3901f)
                horizontalLineTo(17.0317f)
                verticalLineTo(31.2063f)
                horizontalLineTo(17.0516f)
                curveTo(17.3416f, 31.2063f, 17.8353f, 31.2248f, 18.2331f, 31.2248f)
                curveTo(18.6321f, 31.2248f, 19.125f, 31.2063f, 19.4482f, 31.2063f)
                horizontalLineTo(19.4692f)
                lineTo(19.4685f, 31.2282f)
                curveTo(19.4654f, 31.2992f, 19.4635f, 31.3836f, 19.4635f, 31.4729f)
                curveTo(19.4635f, 31.637f, 19.4685f, 31.8168f, 19.4778f, 31.9519f)
                lineTo(19.4787f, 31.9688f)
                lineTo(19.4627f, 31.9737f)
                lineTo(19.2958f, 32.0173f)
                lineTo(19.2951f, 31.9929f)
                curveTo(19.2671f, 31.6849f, 19.2258f, 31.4609f, 18.7371f, 31.4562f)
                horizontalLineTo(18.0973f)
                lineTo(18.0969f, 32.6584f)
                horizontalLineTo(18.6417f)
                curveTo(18.9153f, 32.6555f, 18.9642f, 32.5157f, 18.9965f, 32.2597f)
                lineTo(18.9976f, 32.2406f)
                horizontalLineTo(19.1801f)
                lineTo(19.1798f, 32.2624f)
                curveTo(19.1706f, 32.4478f, 19.165f, 32.6323f, 19.165f, 32.8172f)
                curveTo(19.165f, 32.9967f, 19.1706f, 33.1769f, 19.1798f, 33.3573f)
                lineTo(19.1801f, 33.3745f)
                lineTo(19.1629f, 33.3785f)
                lineTo(18.9976f, 33.4113f)
                lineTo(18.9965f, 33.3891f)
                curveTo(18.9636f, 33.0993f, 18.9615f, 32.9404f, 18.6465f, 32.937f)
                horizontalLineTo(18.0973f)
                verticalLineTo(34.0224f)
                curveTo(18.098f, 34.3109f, 18.3467f, 34.3093f, 18.656f, 34.3109f)
                curveTo(19.2276f, 34.3075f, 19.4565f, 34.2795f, 19.5995f, 33.7471f)
                lineTo(19.6043f, 33.7279f)
                lineTo(19.6243f, 33.7312f)
                lineTo(19.7764f, 33.7707f)
                lineTo(19.7721f, 33.7903f)
                curveTo(19.7105f, 34.0414f, 19.6539f, 34.2924f, 19.611f, 34.5436f)
                lineTo(19.6074f, 34.5605f)
                horizontalLineTo(19.591f)
                close()
                moveTo(19.5734f, 34.5195f)
                curveTo(19.6149f, 34.2795f, 19.669f, 34.0398f, 19.7272f, 33.8009f)
                lineTo(19.6338f, 33.7773f)
                curveTo(19.4917f, 34.3082f, 19.2162f, 34.3557f, 18.656f, 34.3521f)
                curveTo(18.3569f, 34.3521f, 18.0579f, 34.3521f, 18.0563f, 34.0224f)
                verticalLineTo(32.8964f)
                horizontalLineTo(18.6465f)
                curveTo(18.978f, 32.893f, 19.0114f, 33.0928f, 19.0351f, 33.3628f)
                lineTo(19.1376f, 33.3418f)
                curveTo(19.1284f, 33.1668f, 19.1237f, 32.9911f, 19.1237f, 32.8172f)
                curveTo(19.1237f, 32.639f, 19.1284f, 32.4611f, 19.1376f, 32.282f)
                horizontalLineTo(19.0351f)
                curveTo(19.0084f, 32.5299f, 18.9309f, 32.7029f, 18.6417f, 32.6999f)
                horizontalLineTo(18.0563f)
                verticalLineTo(31.4151f)
                horizontalLineTo(18.7371f)
                curveTo(19.2306f, 31.4111f, 19.3124f, 31.6666f, 19.3339f, 31.9652f)
                lineTo(19.4362f, 31.9374f)
                curveTo(19.4279f, 31.8035f, 19.4223f, 31.6314f, 19.4223f, 31.4729f)
                curveTo(19.4223f, 31.3917f, 19.4245f, 31.3146f, 19.4272f, 31.2474f)
                curveTo(19.1047f, 31.2489f, 18.6233f, 31.2661f, 18.2331f, 31.2661f)
                curveTo(17.8431f, 31.2661f, 17.363f, 31.2489f, 17.0725f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(17.1185f)
                curveTo(17.2873f, 31.3488f, 17.4893f, 31.3781f, 17.4904f, 31.6406f)
                verticalLineTo(34.1271f)
                curveTo(17.4893f, 34.3891f, 17.2873f, 34.418f, 17.1185f, 34.4193f)
                horizontalLineTo(17.0725f)
                verticalLineTo(34.5195f)
                curveTo(17.3488f, 34.5186f, 17.8975f, 34.5008f, 18.3145f, 34.5008f)
                curveTo(18.7335f, 34.5008f, 19.2675f, 34.5186f, 19.5734f, 34.5195f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(20.3932f, 31.7298f)
                curveTo(20.3932f, 31.3837f, 20.2031f, 31.3695f, 20.0558f, 31.3695f)
                horizontalLineTo(19.9701f)
                verticalLineTo(31.2271f)
                curveTo(20.1221f, 31.2271f, 20.4164f, 31.2459f, 20.7062f, 31.2459f)
                curveTo(20.9904f, 31.2459f, 21.2186f, 31.2271f, 21.4701f, 31.2271f)
                curveTo(22.0673f, 31.2271f, 22.6001f, 31.3882f, 22.6001f, 32.0627f)
                curveTo(22.6001f, 32.4896f, 22.3151f, 32.7503f, 21.9403f, 32.8983f)
                lineTo(22.7515f, 34.1127f)
                curveTo(22.8848f, 34.3135f, 22.979f, 34.3698f, 23.2122f, 34.3976f)
                verticalLineTo(34.5403f)
                curveTo(23.0552f, 34.5403f, 22.9033f, 34.522f, 22.7472f, 34.522f)
                curveTo(22.6001f, 34.522f, 22.4475f, 34.5403f, 22.3011f, 34.5403f)
                curveTo(21.9353f, 34.0611f, 21.6218f, 33.5487f, 21.3135f, 33.002f)
                horizontalLineTo(21.0007f)
                verticalLineTo(34.0184f)
                curveTo(21.0007f, 34.3838f, 21.1712f, 34.3976f, 21.3887f, 34.3976f)
                horizontalLineTo(21.4748f)
                verticalLineTo(34.5403f)
                curveTo(21.2037f, 34.5403f, 20.9295f, 34.522f, 20.6584f, 34.522f)
                curveTo(20.4306f, 34.522f, 20.2074f, 34.5403f, 19.9701f, 34.5403f)
                verticalLineTo(34.3976f)
                horizontalLineTo(20.0558f)
                curveTo(20.232f, 34.3976f, 20.3932f, 34.3173f, 20.3932f, 34.142f)
                verticalLineTo(31.7298f)
                close()
                moveTo(21.0007f, 32.8308f)
                horizontalLineTo(21.2326f)
                curveTo(21.7078f, 32.8308f, 21.9637f, 32.6509f, 21.9637f, 32.0905f)
                curveTo(21.9637f, 31.6685f, 21.6931f, 31.3979f, 21.2702f, 31.3979f)
                curveTo(21.1277f, 31.3979f, 21.067f, 31.4125f, 21.0007f, 31.4171f)
                verticalLineTo(32.8308f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(23.2122f, 34.5605f)
                curveTo(23.053f, 34.5605f, 22.9021f, 34.5415f, 22.746f, 34.5415f)
                curveTo(22.6013f, 34.5415f, 22.4495f, 34.5605f, 22.2842f, 34.5526f)
                curveTo(21.92f, 34.0747f, 21.608f, 33.5651f, 21.3015f, 33.0233f)
                horizontalLineTo(21.021f)
                verticalLineTo(34.0174f)
                curveTo(21.0262f, 34.3747f, 21.1694f, 34.372f, 21.3888f, 34.3771f)
                horizontalLineTo(21.4953f)
                verticalLineTo(34.5605f)
                horizontalLineTo(21.4743f)
                curveTo(21.203f, 34.5605f, 20.9272f, 34.5415f, 20.6582f, 34.5415f)
                curveTo(20.4315f, 34.5415f, 20.2085f, 34.5605f, 19.9701f, 34.5605f)
                horizontalLineTo(19.9495f)
                verticalLineTo(34.3771f)
                horizontalLineTo(20.0558f)
                curveTo(20.2265f, 34.3758f, 20.3708f, 34.3014f, 20.3715f, 34.1419f)
                verticalLineTo(31.7297f)
                curveTo(20.3679f, 31.3932f, 20.2032f, 31.3948f, 20.0558f, 31.3901f)
                horizontalLineTo(19.9495f)
                verticalLineTo(31.2063f)
                horizontalLineTo(19.9701f)
                curveTo(20.1237f, 31.2063f, 20.4168f, 31.2248f, 20.7062f, 31.2248f)
                curveTo(20.9896f, 31.2248f, 21.2172f, 31.2063f, 21.4702f, 31.2063f)
                curveTo(22.0686f, 31.2076f, 22.6193f, 31.3723f, 22.6207f, 32.0619f)
                curveTo(22.6207f, 32.4902f, 22.3376f, 32.7579f, 21.9716f, 32.9072f)
                lineTo(22.7686f, 34.1013f)
                curveTo(22.9014f, 34.2982f, 22.984f, 34.3474f, 23.2149f, 34.3771f)
                lineTo(23.2322f, 34.3798f)
                verticalLineTo(34.5605f)
                horizontalLineTo(23.2122f)
                close()
                moveTo(21.0005f, 32.9814f)
                horizontalLineTo(21.3248f)
                lineTo(21.3307f, 32.992f)
                curveTo(21.6398f, 33.5373f, 21.9517f, 34.0499f, 22.3011f, 34.5199f)
                curveTo(22.4456f, 34.5199f, 22.5981f, 34.5008f, 22.746f, 34.5008f)
                curveTo(22.8974f, 34.5008f, 23.044f, 34.5174f, 23.1914f, 34.5195f)
                verticalLineTo(34.4153f)
                curveTo(22.9689f, 34.3882f, 22.8644f, 34.321f, 22.7348f, 34.1243f)
                lineTo(21.9085f, 32.8887f)
                lineTo(21.9319f, 32.8792f)
                curveTo(22.3036f, 32.7327f, 22.5791f, 32.4792f, 22.5792f, 32.0619f)
                curveTo(22.5791f, 31.4034f, 22.0668f, 31.2507f, 21.4702f, 31.2474f)
                curveTo(21.2202f, 31.2474f, 20.9921f, 31.2667f, 20.7062f, 31.2667f)
                curveTo(20.4274f, 31.2667f, 20.1457f, 31.2489f, 19.9904f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(20.0558f)
                curveTo(20.2032f, 31.3488f, 20.4128f, 31.3732f, 20.4128f, 31.7297f)
                verticalLineTo(34.1419f)
                curveTo(20.4128f, 34.3323f, 20.2344f, 34.4189f, 20.0558f, 34.4193f)
                horizontalLineTo(19.9904f)
                verticalLineTo(34.5195f)
                curveTo(20.2186f, 34.5186f, 20.4353f, 34.5008f, 20.6582f, 34.5008f)
                curveTo(20.9233f, 34.5008f, 21.1913f, 34.5186f, 21.4538f, 34.5195f)
                verticalLineTo(34.4193f)
                horizontalLineTo(21.3888f)
                curveTo(21.1726f, 34.4189f, 20.9795f, 34.3921f, 20.9795f, 34.0174f)
                verticalLineTo(32.9814f)
                horizontalLineTo(21.0005f)
                close()
                moveTo(21.0005f, 32.8511f)
                horizontalLineTo(20.9795f)
                verticalLineTo(31.3978f)
                lineTo(20.9976f, 31.3964f)
                curveTo(21.0627f, 31.3912f, 21.1266f, 31.3781f, 21.2702f, 31.3781f)
                curveTo(21.7025f, 31.3781f, 21.984f, 31.6589f, 21.9844f, 32.0917f)
                curveTo(21.9831f, 32.6584f, 21.7115f, 32.851f, 21.2326f, 32.8511f)
                horizontalLineTo(21.0005f)
                close()
                moveTo(21.2326f, 32.8107f)
                curveTo(21.7025f, 32.8061f, 21.9393f, 32.6431f, 21.9439f, 32.0917f)
                curveTo(21.9411f, 31.677f, 21.6836f, 31.4197f, 21.2702f, 31.4179f)
                curveTo(21.1421f, 31.4179f, 21.0815f, 31.4298f, 21.021f, 31.4357f)
                verticalLineTo(32.8107f)
                horizontalLineTo(21.2326f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(26.4347f, 33.6048f)
                lineTo(26.443f, 33.5954f)
                verticalLineTo(31.816f)
                curveTo(26.443f, 31.4265f, 26.1733f, 31.3695f, 26.0308f, 31.3695f)
                horizontalLineTo(25.9268f)
                verticalLineTo(31.2271f)
                curveTo(26.1499f, 31.2271f, 26.3675f, 31.2459f, 26.5912f, 31.2459f)
                curveTo(26.7863f, 31.2459f, 26.9794f, 31.2271f, 27.1755f, 31.2271f)
                verticalLineTo(31.3695f)
                horizontalLineTo(27.104f)
                curveTo(26.9045f, 31.3695f, 26.6816f, 31.4074f, 26.6816f, 31.9723f)
                verticalLineTo(34.1319f)
                curveTo(26.6816f, 34.2983f, 26.6862f, 34.4643f, 26.7096f, 34.6116f)
                horizontalLineTo(26.5299f)
                lineTo(24.0857f, 31.8866f)
                verticalLineTo(33.8426f)
                curveTo(24.0857f, 34.2559f, 24.1659f, 34.3976f, 24.5313f, 34.3976f)
                horizontalLineTo(24.6122f)
                verticalLineTo(34.5403f)
                curveTo(24.4082f, 34.5403f, 24.2038f, 34.5218f, 23.9998f, 34.5218f)
                curveTo(23.7855f, 34.5218f, 23.5676f, 34.5403f, 23.3541f, 34.5403f)
                verticalLineTo(34.3976f)
                horizontalLineTo(23.4201f)
                curveTo(23.7478f, 34.3976f, 23.848f, 34.1745f, 23.848f, 33.7959f)
                verticalLineTo(31.7961f)
                curveTo(23.848f, 31.5305f, 23.6294f, 31.3695f, 23.4159f, 31.3695f)
                horizontalLineTo(23.3541f)
                verticalLineTo(31.2271f)
                curveTo(23.5338f, 31.2271f, 23.7203f, 31.2459f, 23.9003f, 31.2459f)
                curveTo(24.0414f, 31.2459f, 24.1797f, 31.2271f, 24.3224f, 31.2271f)
                lineTo(26.4347f, 33.6048f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(26.7094f, 34.6315f)
                lineTo(26.5145f, 34.6248f)
                lineTo(24.1053f, 31.9404f)
                verticalLineTo(33.8424f)
                curveTo(24.1109f, 34.2558f, 24.1734f, 34.3726f, 24.5313f, 34.3771f)
                horizontalLineTo(24.6319f)
                verticalLineTo(34.5605f)
                horizontalLineTo(24.6113f)
                curveTo(24.4061f, 34.5605f, 24.2024f, 34.5407f, 23.999f, 34.5407f)
                curveTo(23.7871f, 34.5407f, 23.5678f, 34.5605f, 23.354f, 34.5605f)
                horizontalLineTo(23.3328f)
                verticalLineTo(34.3771f)
                horizontalLineTo(23.4201f)
                curveTo(23.7336f, 34.3758f, 23.8234f, 34.1737f, 23.8265f, 33.7946f)
                verticalLineTo(31.796f)
                curveTo(23.8259f, 31.543f, 23.619f, 31.3901f, 23.4159f, 31.3901f)
                horizontalLineTo(23.3328f)
                verticalLineTo(31.2063f)
                horizontalLineTo(23.354f)
                curveTo(23.5352f, 31.2063f, 23.721f, 31.2248f, 23.9002f, 31.2248f)
                curveTo(24.0396f, 31.2248f, 24.177f, 31.2063f, 24.3362f, 31.2124f)
                lineTo(26.4229f, 33.5617f)
                verticalLineTo(31.8159f)
                curveTo(26.4216f, 31.439f, 26.1688f, 31.3923f, 26.0308f, 31.3901f)
                horizontalLineTo(25.9056f)
                verticalLineTo(31.2063f)
                horizontalLineTo(25.9263f)
                curveTo(26.1505f, 31.2063f, 26.3693f, 31.2248f, 26.5912f, 31.2248f)
                curveTo(26.7845f, 31.2248f, 26.9789f, 31.2063f, 27.1746f, 31.2063f)
                horizontalLineTo(27.1956f)
                verticalLineTo(31.3901f)
                horizontalLineTo(27.104f)
                curveTo(26.9081f, 31.3948f, 26.7064f, 31.4124f, 26.7017f, 31.9722f)
                verticalLineTo(34.1318f)
                curveTo(26.7017f, 34.298f, 26.7058f, 34.4626f, 26.7301f, 34.6081f)
                lineTo(26.7324f, 34.6315f)
                horizontalLineTo(26.7094f)
                close()
                moveTo(26.5298f, 34.5901f)
                horizontalLineTo(26.6853f)
                curveTo(26.6645f, 34.4482f, 26.6604f, 34.2897f, 26.6604f, 34.1318f)
                verticalLineTo(31.9722f)
                curveTo(26.6607f, 31.4025f, 26.9008f, 31.3497f, 27.104f, 31.3484f)
                horizontalLineTo(27.1539f)
                verticalLineTo(31.2474f)
                curveTo(26.9671f, 31.2489f, 26.7795f, 31.2661f, 26.5912f, 31.2661f)
                curveTo(26.3731f, 31.2661f, 26.1616f, 31.2489f, 25.9469f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(26.0308f)
                curveTo(26.1771f, 31.3497f, 26.4645f, 31.4136f, 26.4645f, 31.8159f)
                lineTo(26.4577f, 33.6102f)
                lineTo(26.4491f, 33.6194f)
                lineTo(26.4342f, 33.635f)
                lineTo(24.3224f, 31.2474f)
                curveTo(24.1812f, 31.2474f, 24.0435f, 31.2661f, 23.9002f, 31.2661f)
                curveTo(23.7241f, 31.2661f, 23.5467f, 31.2489f, 23.3743f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(23.4159f)
                curveTo(23.6393f, 31.3497f, 23.8676f, 31.518f, 23.8676f, 31.796f)
                verticalLineTo(33.7946f)
                curveTo(23.8676f, 34.1755f, 23.7604f, 34.418f, 23.4201f, 34.4193f)
                lineTo(23.3743f, 34.4189f)
                verticalLineTo(34.5197f)
                curveTo(23.5793f, 34.5183f, 23.7907f, 34.5008f, 23.999f, 34.5008f)
                curveTo(24.198f, 34.5008f, 24.3953f, 34.5183f, 24.5915f, 34.5197f)
                verticalLineTo(34.4193f)
                horizontalLineTo(24.5313f)
                curveTo(24.1578f, 34.4189f, 24.0647f, 34.2558f, 24.0636f, 33.8424f)
                verticalLineTo(31.8341f)
                lineTo(26.5298f, 34.5901f)
                close()
                moveTo(26.4342f, 33.6047f)
                lineTo(26.4496f, 33.591f)
                lineTo(26.4342f, 33.6047f)
                close()
                moveTo(26.4229f, 33.5953f)
                verticalLineTo(33.5941f)
                lineTo(26.4194f, 33.5905f)
                lineTo(26.4229f, 33.5953f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(27.9385f, 33.8616f)
                curveTo(27.8907f, 34.0224f, 27.8334f, 34.1471f, 27.8334f, 34.2314f)
                curveTo(27.8334f, 34.3742f, 28.0334f, 34.3977f, 28.1895f, 34.3977f)
                horizontalLineTo(28.2425f)
                verticalLineTo(34.5402f)
                curveTo(28.0519f, 34.53f, 27.8582f, 34.5219f, 27.6672f, 34.5219f)
                curveTo(27.4963f, 34.5219f, 27.3264f, 34.53f, 27.155f, 34.5402f)
                verticalLineTo(34.3977f)
                horizontalLineTo(27.1839f)
                curveTo(27.3686f, 34.3977f, 27.5258f, 34.2883f, 27.5962f, 34.0889f)
                lineTo(28.3557f, 31.911f)
                curveTo(28.4177f, 31.7349f, 28.5032f, 31.4977f, 28.5321f, 31.3217f)
                curveTo(28.683f, 31.2697f, 28.8737f, 31.1754f, 28.9635f, 31.1177f)
                curveTo(28.9782f, 31.1129f, 28.987f, 31.108f, 29.0014f, 31.108f)
                curveTo(29.0158f, 31.108f, 29.0246f, 31.108f, 29.035f, 31.1229f)
                curveTo(29.049f, 31.1605f, 29.0628f, 31.2033f, 29.0776f, 31.2412f)
                lineTo(29.9513f, 33.724f)
                curveTo(30.0083f, 33.8896f, 30.0647f, 34.0652f, 30.1254f, 34.2084f)
                curveTo(30.1833f, 34.3415f, 30.283f, 34.3977f, 30.4402f, 34.3977f)
                horizontalLineTo(30.4686f)
                verticalLineTo(34.5402f)
                curveTo(30.2548f, 34.53f, 30.0406f, 34.5219f, 29.8139f, 34.5219f)
                curveTo(29.5812f, 34.5219f, 29.3431f, 34.53f, 29.1011f, 34.5402f)
                verticalLineTo(34.3977f)
                horizontalLineTo(29.1534f)
                curveTo(29.2619f, 34.3977f, 29.4482f, 34.3789f, 29.4482f, 34.2601f)
                curveTo(29.4482f, 34.1988f, 29.4053f, 34.0706f, 29.3523f, 33.918f)
                lineTo(29.1674f, 33.3677f)
                horizontalLineTo(28.0901f)
                lineTo(27.9385f, 33.8616f)
                close()
                moveTo(28.6315f, 31.7588f)
                horizontalLineTo(28.6216f)
                lineTo(28.1805f, 33.1022f)
                horizontalLineTo(29.0673f)
                lineTo(28.6315f, 31.7588f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(30.4672f, 34.5605f)
                curveTo(30.2539f, 34.5514f, 30.0399f, 34.5408f, 29.8139f, 34.5408f)
                curveTo(29.5812f, 34.5408f, 29.3444f, 34.5514f, 29.1022f, 34.5605f)
                lineTo(29.0803f, 34.5616f)
                verticalLineTo(34.3762f)
                horizontalLineTo(29.1534f)
                curveTo(29.2634f, 34.3762f, 29.4265f, 34.3516f, 29.4269f, 34.2601f)
                curveTo(29.428f, 34.206f, 29.3854f, 34.076f, 29.3331f, 33.925f)
                lineTo(29.1524f, 33.388f)
                horizontalLineTo(28.1054f)
                lineTo(27.9578f, 33.8677f)
                curveTo(27.91f, 34.0291f, 27.8523f, 34.1545f, 27.8532f, 34.2317f)
                curveTo(27.8548f, 34.3476f, 28.032f, 34.3762f, 28.1895f, 34.3762f)
                horizontalLineTo(28.2625f)
                verticalLineTo(34.5616f)
                lineTo(28.2409f, 34.5605f)
                curveTo(28.0512f, 34.5514f, 27.8575f, 34.5408f, 27.6676f, 34.5408f)
                curveTo(27.4982f, 34.5408f, 27.3266f, 34.5514f, 27.1566f, 34.5605f)
                lineTo(27.1345f, 34.5616f)
                verticalLineTo(34.3762f)
                horizontalLineTo(27.1838f)
                curveTo(27.3602f, 34.3758f, 27.5075f, 34.275f, 27.5761f, 34.0822f)
                lineTo(28.3363f, 31.9036f)
                curveTo(28.3976f, 31.7279f, 28.4838f, 31.4918f, 28.5248f, 31.3021f)
                curveTo(28.6737f, 31.2516f, 28.8647f, 31.1558f, 28.9558f, 31.0985f)
                curveTo(28.9691f, 31.0938f, 28.9822f, 31.0877f, 29.0013f, 31.0877f)
                curveTo(29.0129f, 31.087f, 29.0385f, 31.0901f, 29.0539f, 31.1149f)
                curveTo(29.0674f, 31.1539f, 29.0825f, 31.1964f, 29.0968f, 31.2347f)
                lineTo(29.9707f, 33.7172f)
                curveTo(30.0266f, 33.8834f, 30.0834f, 34.0587f, 30.1456f, 34.1994f)
                curveTo(30.2005f, 34.3259f, 30.2877f, 34.3758f, 30.4402f, 34.3762f)
                horizontalLineTo(30.4882f)
                verticalLineTo(34.5616f)
                lineTo(30.4672f, 34.5605f)
                close()
                moveTo(29.1218f, 34.5183f)
                curveTo(29.3566f, 34.51f, 29.5872f, 34.5009f, 29.8139f, 34.5009f)
                curveTo(30.034f, 34.5009f, 30.241f, 34.51f, 30.4472f, 34.5183f)
                verticalLineTo(34.4189f)
                horizontalLineTo(30.4402f)
                curveTo(30.2774f, 34.42f, 30.1655f, 34.3561f, 30.1073f, 34.2161f)
                curveTo(30.0455f, 34.0727f, 29.9878f, 33.8965f, 29.9318f, 33.7303f)
                lineTo(29.0579f, 31.2476f)
                curveTo(29.0435f, 31.2097f, 29.03f, 31.1673f, 29.0176f, 31.1336f)
                curveTo(29.0129f, 31.1289f, 29.014f, 31.1289f, 29.0102f, 31.1289f)
                horizontalLineTo(29.0013f)
                curveTo(28.9917f, 31.1289f, 28.986f, 31.1318f, 28.9738f, 31.1348f)
                curveTo(28.8825f, 31.1941f, 28.6922f, 31.2877f, 28.551f, 31.3247f)
                curveTo(28.5221f, 31.5046f, 28.4366f, 31.7417f, 28.3749f, 31.9176f)
                lineTo(27.6155f, 34.0957f)
                curveTo(27.5433f, 34.302f, 27.3764f, 34.4193f, 27.1838f, 34.4189f)
                horizontalLineTo(27.1758f)
                verticalLineTo(34.5183f)
                curveTo(27.3386f, 34.51f, 27.5028f, 34.5009f, 27.6676f, 34.5009f)
                curveTo(27.8512f, 34.5009f, 28.0384f, 34.51f, 28.2201f, 34.5183f)
                verticalLineTo(34.4189f)
                horizontalLineTo(28.1895f)
                curveTo(28.0345f, 34.4168f, 27.8185f, 34.3999f, 27.8131f, 34.2317f)
                curveTo(27.8135f, 34.1376f, 27.8717f, 34.0161f, 27.9182f, 33.8557f)
                lineTo(27.9384f, 33.8616f)
                lineTo(27.9182f, 33.8551f)
                lineTo(28.0745f, 33.3479f)
                horizontalLineTo(29.1813f)
                lineTo(29.3714f, 33.9116f)
                curveTo(29.4247f, 34.0643f, 29.4679f, 34.1908f, 29.4679f, 34.2601f)
                curveTo(29.4608f, 34.4055f, 29.2611f, 34.4162f, 29.1534f, 34.4189f)
                horizontalLineTo(29.1218f)
                verticalLineTo(34.5183f)
                close()
                moveTo(28.1516f, 33.1226f)
                lineTo(28.606f, 31.7378f)
                horizontalLineTo(28.6315f)
                verticalLineTo(31.7588f)
                lineTo(28.6265f, 31.7602f)
                lineTo(28.6315f, 31.7588f)
                verticalLineTo(31.7378f)
                horizontalLineTo(28.6457f)
                lineTo(29.0968f, 33.1226f)
                horizontalLineTo(28.1516f)
                close()
                moveTo(28.2084f, 33.0811f)
                horizontalLineTo(29.0393f)
                lineTo(28.6263f, 31.8093f)
                lineTo(28.2084f, 33.0811f)
                close()
                moveTo(28.6108f, 31.7649f)
                lineTo(28.6218f, 31.7615f)
                lineTo(28.6108f, 31.7649f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(30.6772f, 31.4643f)
                curveTo(30.3212f, 31.4643f, 30.3069f, 31.5502f, 30.2354f, 31.8962f)
                horizontalLineTo(30.0927f)
                curveTo(30.1114f, 31.7633f, 30.1357f, 31.6305f, 30.1504f, 31.4929f)
                curveTo(30.1689f, 31.3594f, 30.1781f, 31.227f, 30.1781f, 31.0897f)
                horizontalLineTo(30.2929f)
                curveTo(30.3301f, 31.2322f, 30.449f, 31.227f, 30.5771f, 31.227f)
                horizontalLineTo(33.0267f)
                curveTo(33.1542f, 31.227f, 33.2728f, 31.2223f, 33.2822f, 31.0798f)
                lineTo(33.3957f, 31.0992f)
                curveTo(33.3781f, 31.227f, 33.3592f, 31.3553f, 33.3443f, 31.4837f)
                curveTo(33.3339f, 31.6118f, 33.3339f, 31.7396f, 33.3339f, 31.8677f)
                lineTo(33.1921f, 31.9205f)
                curveTo(33.1837f, 31.7451f, 33.1598f, 31.4643f, 32.8411f, 31.4643f)
                horizontalLineTo(32.0628f)
                verticalLineTo(33.9895f)
                curveTo(32.0628f, 34.3557f, 32.2291f, 34.3976f, 32.4566f, 34.3976f)
                horizontalLineTo(32.5473f)
                verticalLineTo(34.5402f)
                curveTo(32.3619f, 34.5402f, 32.0302f, 34.5219f, 31.7733f, 34.5219f)
                curveTo(31.4891f, 34.5219f, 31.156f, 34.5402f, 30.9709f, 34.5402f)
                verticalLineTo(34.3976f)
                horizontalLineTo(31.0613f)
                curveTo(31.3229f, 34.3976f, 31.4553f, 34.3742f, 31.4553f, 33.9994f)
                verticalLineTo(31.4643f)
                horizontalLineTo(30.6772f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(32.5474f, 34.5605f)
                curveTo(32.3609f, 34.5605f, 32.0281f, 34.5417f, 31.773f, 34.5417f)
                curveTo(31.4895f, 34.5417f, 31.1571f, 34.5605f, 30.9711f, 34.5605f)
                horizontalLineTo(30.9501f)
                verticalLineTo(34.3771f)
                horizontalLineTo(31.0613f)
                curveTo(31.3231f, 34.371f, 31.428f, 34.3676f, 31.4343f, 33.9994f)
                lineTo(31.434f, 31.4847f)
                horizontalLineTo(30.6772f)
                verticalLineTo(31.4431f)
                horizontalLineTo(31.4758f)
                verticalLineTo(33.9994f)
                curveTo(31.4758f, 34.3805f, 31.322f, 34.4181f, 31.0613f, 34.419f)
                horizontalLineTo(30.9914f)
                verticalLineTo(34.5199f)
                curveTo(31.179f, 34.5183f, 31.4979f, 34.5009f, 31.773f, 34.5009f)
                curveTo(32.0211f, 34.5009f, 32.3388f, 34.5183f, 32.5261f, 34.5199f)
                verticalLineTo(34.419f)
                horizontalLineTo(32.4564f)
                curveTo(32.2277f, 34.4181f, 32.0428f, 34.3631f, 32.0425f, 33.9896f)
                verticalLineTo(31.4431f)
                horizontalLineTo(32.8411f)
                curveTo(33.16f, 31.4444f, 33.2015f, 31.715f, 33.2107f, 31.8916f)
                lineTo(33.3138f, 31.8537f)
                curveTo(33.3138f, 31.7297f, 33.3145f, 31.6056f, 33.3242f, 31.4814f)
                curveTo(33.337f, 31.3591f, 33.355f, 31.2376f, 33.3722f, 31.1165f)
                lineTo(33.3005f, 31.1039f)
                curveTo(33.2788f, 31.2421f, 33.1447f, 31.2498f, 33.0267f, 31.2477f)
                horizontalLineTo(30.5529f)
                curveTo(30.4409f, 31.2489f, 30.3198f, 31.2425f, 30.2767f, 31.1097f)
                horizontalLineTo(30.1991f)
                curveTo(30.198f, 31.241f, 30.1887f, 31.3686f, 30.17f, 31.4951f)
                curveTo(30.1571f, 31.626f, 30.1342f, 31.7516f, 30.1161f, 31.8765f)
                horizontalLineTo(30.2182f)
                curveTo(30.2805f, 31.5454f, 30.3216f, 31.4379f, 30.6772f, 31.4431f)
                verticalLineTo(31.4847f)
                curveTo(30.3252f, 31.4908f, 30.333f, 31.5504f, 30.2555f, 31.9011f)
                lineTo(30.2521f, 31.9173f)
                horizontalLineTo(30.0688f)
                lineTo(30.0717f, 31.8938f)
                curveTo(30.0917f, 31.7603f, 30.115f, 31.6269f, 30.1289f, 31.4902f)
                curveTo(30.1483f, 31.3574f, 30.1571f, 31.2258f, 30.1571f, 31.0897f)
                verticalLineTo(31.0687f)
                horizontalLineTo(30.3078f)
                lineTo(30.3118f, 31.0836f)
                curveTo(30.345f, 31.2033f, 30.4314f, 31.2042f, 30.5529f, 31.2063f)
                horizontalLineTo(33.0267f)
                curveTo(33.158f, 31.2042f, 33.2538f, 31.2024f, 33.2622f, 31.0786f)
                lineTo(33.263f, 31.0558f)
                lineTo(33.2851f, 31.0601f)
                lineTo(33.4198f, 31.0813f)
                lineTo(33.4166f, 31.1023f)
                curveTo(33.397f, 31.2297f, 33.379f, 31.3574f, 33.3647f, 31.4847f)
                curveTo(33.355f, 31.6119f, 33.355f, 31.7396f, 33.355f, 31.8677f)
                verticalLineTo(31.8821f)
                lineTo(33.3411f, 31.8876f)
                lineTo(33.1731f, 31.9491f)
                lineTo(33.1724f, 31.9216f)
                curveTo(33.16f, 31.743f, 33.1411f, 31.4847f, 32.8411f, 31.4847f)
                horizontalLineTo(32.0833f)
                verticalLineTo(33.9896f)
                curveTo(32.0881f, 34.3475f, 32.2302f, 34.3726f, 32.4564f, 34.3771f)
                horizontalLineTo(32.5671f)
                verticalLineTo(34.5605f)
                horizontalLineTo(32.5474f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(33.5714f, 34.3976f)
                horizontalLineTo(33.6379f)
                curveTo(33.8089f, 34.3976f, 33.9886f, 34.3743f, 33.9886f, 34.1272f)
                verticalLineTo(31.6406f)
                curveTo(33.9886f, 31.3932f, 33.8089f, 31.3697f, 33.6379f, 31.3697f)
                horizontalLineTo(33.5714f)
                verticalLineTo(31.2271f)
                curveTo(33.7566f, 31.2271f, 34.0409f, 31.2459f, 34.2732f, 31.2459f)
                curveTo(34.5111f, 31.2459f, 34.796f, 31.2271f, 35.0195f, 31.2271f)
                verticalLineTo(31.3697f)
                horizontalLineTo(34.9529f)
                curveTo(34.7813f, 31.3697f, 34.6009f, 31.3932f, 34.6009f, 31.6406f)
                verticalLineTo(34.1272f)
                curveTo(34.6009f, 34.3743f, 34.7813f, 34.3976f, 34.9529f, 34.3976f)
                horizontalLineTo(35.0195f)
                verticalLineTo(34.5403f)
                curveTo(34.7915f, 34.5403f, 34.5064f, 34.522f, 34.2694f, 34.522f)
                curveTo(34.0364f, 34.522f, 33.7566f, 34.5403f, 33.5714f, 34.5403f)
                verticalLineTo(34.3976f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(35.0196f, 34.5605f)
                curveTo(34.7901f, 34.5605f, 34.5063f, 34.5407f, 34.2695f, 34.5407f)
                curveTo(34.0371f, 34.5407f, 33.7569f, 34.5605f, 33.5714f, 34.5605f)
                horizontalLineTo(33.5511f)
                verticalLineTo(34.3771f)
                horizontalLineTo(33.6381f)
                curveTo(33.8091f, 34.3742f, 33.9669f, 34.3591f, 33.968f, 34.1271f)
                verticalLineTo(31.6406f)
                curveTo(33.9669f, 31.4086f, 33.8091f, 31.3932f, 33.6381f, 31.3901f)
                horizontalLineTo(33.5511f)
                verticalLineTo(31.2063f)
                horizontalLineTo(33.5714f)
                curveTo(33.7569f, 31.2063f, 34.0424f, 31.2248f, 34.2732f, 31.2248f)
                curveTo(34.5098f, 31.2248f, 34.7946f, 31.2063f, 35.0196f, 31.2063f)
                horizontalLineTo(35.0393f)
                verticalLineTo(31.3901f)
                horizontalLineTo(34.9531f)
                curveTo(34.7793f, 31.3932f, 34.6232f, 31.4086f, 34.6216f, 31.6406f)
                verticalLineTo(34.1271f)
                curveTo(34.6232f, 34.3591f, 34.7793f, 34.3742f, 34.9531f, 34.3771f)
                horizontalLineTo(35.0393f)
                verticalLineTo(34.5605f)
                horizontalLineTo(35.0196f)
                close()
                moveTo(34.998f, 34.5195f)
                verticalLineTo(34.4189f)
                horizontalLineTo(34.9531f)
                curveTo(34.7828f, 34.4189f, 34.5814f, 34.3891f, 34.5814f, 34.1271f)
                verticalLineTo(31.6406f)
                curveTo(34.5814f, 31.3781f, 34.7828f, 31.3488f, 34.9531f, 31.3484f)
                horizontalLineTo(34.998f)
                verticalLineTo(31.2474f)
                curveTo(34.7792f, 31.2489f, 34.5043f, 31.2661f, 34.2732f, 31.2661f)
                curveTo(34.0479f, 31.2661f, 33.7763f, 31.2489f, 33.5921f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(33.6381f)
                curveTo(33.8066f, 31.3488f, 34.0089f, 31.3781f, 34.0095f, 31.6406f)
                verticalLineTo(34.1271f)
                curveTo(34.0089f, 34.3891f, 33.8066f, 34.4189f, 33.6381f, 34.4189f)
                horizontalLineTo(33.5921f)
                verticalLineTo(34.5195f)
                curveTo(33.775f, 34.5174f, 34.0434f, 34.5008f, 34.2695f, 34.5008f)
                curveTo(34.4996f, 34.5008f, 34.7741f, 34.5183f, 34.998f, 34.5195f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(36.9122f, 31.1559f)
                curveTo(37.9241f, 31.1559f, 38.7306f, 31.7831f, 38.7306f, 32.7941f)
                curveTo(38.7306f, 33.8859f, 37.9472f, 34.6116f, 36.9366f, 34.6116f)
                curveTo(35.9299f, 34.6116f, 35.1613f, 33.928f, 35.1613f, 32.9073f)
                curveTo(35.1613f, 31.9205f, 35.9253f, 31.1559f, 36.9122f, 31.1559f)
                close()
                moveTo(36.9839f, 34.4026f)
                curveTo(37.905f, 34.4026f, 38.0656f, 33.5904f, 38.0656f, 32.8983f)
                curveTo(38.0656f, 32.2046f, 37.6916f, 31.3648f, 36.9032f, 31.3648f)
                curveTo(36.0728f, 31.3648f, 35.8257f, 32.1054f, 35.8257f, 32.7409f)
                curveTo(35.8257f, 33.5904f, 36.2152f, 34.4026f, 36.9839f, 34.4026f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(35.1401f, 32.9073f)
                curveTo(35.1421f, 31.9091f, 35.9148f, 31.1369f, 36.9119f, 31.1353f)
                verticalLineTo(31.1768f)
                curveTo(35.9362f, 31.1768f, 35.1814f, 31.931f, 35.1803f, 32.9073f)
                curveTo(35.1823f, 33.9165f, 35.9398f, 34.5899f, 36.9367f, 34.5902f)
                curveTo(37.9371f, 34.5899f, 38.7092f, 33.8746f, 38.7104f, 32.7934f)
                curveTo(38.7095f, 31.795f, 37.9157f, 31.1777f, 36.9119f, 31.1768f)
                verticalLineTo(31.1353f)
                curveTo(37.931f, 31.1363f, 38.749f, 31.7697f, 38.7508f, 32.7934f)
                curveTo(38.7498f, 33.8966f, 37.9571f, 34.6298f, 36.9367f, 34.6316f)
                curveTo(35.9214f, 34.6298f, 35.1421f, 33.9393f, 35.1401f, 32.9073f)
                close()
                moveTo(35.8048f, 32.7409f)
                curveTo(35.8063f, 32.1022f, 36.0555f, 31.3437f, 36.903f, 31.3437f)
                curveTo(37.709f, 31.3455f, 38.0848f, 32.2009f, 38.0864f, 32.8983f)
                curveTo(38.0848f, 33.5904f, 37.922f, 34.4221f, 36.984f, 34.4221f)
                verticalLineTo(34.3818f)
                curveTo(37.8865f, 34.3811f, 38.0433f, 33.5904f, 38.0447f, 32.8983f)
                curveTo(38.0447f, 32.2107f, 37.6745f, 31.3868f, 36.903f, 31.3855f)
                curveTo(36.0887f, 31.3864f, 35.8481f, 32.1087f, 35.846f, 32.7409f)
                curveTo(35.8463f, 33.5864f, 36.2323f, 34.3806f, 36.984f, 34.3818f)
                verticalLineTo(34.4221f)
                curveTo(36.1962f, 34.4214f, 35.8063f, 33.5954f, 35.8048f, 32.7409f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(41.929f, 33.6048f)
                lineTo(41.9389f, 33.5954f)
                verticalLineTo(31.816f)
                curveTo(41.9389f, 31.4265f, 41.6674f, 31.3695f, 41.5251f, 31.3695f)
                horizontalLineTo(41.4218f)
                verticalLineTo(31.2271f)
                curveTo(41.6442f, 31.2271f, 41.8631f, 31.2459f, 42.0855f, 31.2459f)
                curveTo(42.2806f, 31.2459f, 42.4752f, 31.2271f, 42.67f, 31.2271f)
                verticalLineTo(31.3695f)
                horizontalLineTo(42.5986f)
                curveTo(42.3997f, 31.3695f, 42.1757f, 31.4074f, 42.1757f, 31.9723f)
                verticalLineTo(34.1319f)
                curveTo(42.1757f, 34.2983f, 42.1807f, 34.4643f, 42.2048f, 34.6116f)
                horizontalLineTo(42.0242f)
                lineTo(39.5793f, 31.8866f)
                verticalLineTo(33.8426f)
                curveTo(39.5793f, 34.2559f, 39.6604f, 34.3976f, 40.0251f, 34.3976f)
                horizontalLineTo(40.1065f)
                verticalLineTo(34.5403f)
                curveTo(39.9022f, 34.5403f, 39.6985f, 34.5218f, 39.4944f, 34.5218f)
                curveTo(39.2805f, 34.5218f, 39.0621f, 34.5403f, 38.8484f, 34.5403f)
                verticalLineTo(34.3976f)
                horizontalLineTo(38.9151f)
                curveTo(39.2432f, 34.3976f, 39.3422f, 34.1745f, 39.3422f, 33.7959f)
                verticalLineTo(31.7961f)
                curveTo(39.3422f, 31.5305f, 39.1246f, 31.3695f, 38.9099f, 31.3695f)
                horizontalLineTo(38.8484f)
                verticalLineTo(31.2271f)
                curveTo(39.0288f, 31.2271f, 39.2137f, 31.2459f, 39.3945f, 31.2459f)
                curveTo(39.5366f, 31.2459f, 39.6735f, 31.2271f, 39.8165f, 31.2271f)
                lineTo(41.929f, 33.6048f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(42.205f, 34.6315f)
                lineTo(42.0086f, 34.6248f)
                lineTo(39.5998f, 31.9404f)
                verticalLineTo(33.8425f)
                curveTo(39.6054f, 34.2558f, 39.6681f, 34.372f, 40.0245f, 34.3762f)
                horizontalLineTo(40.1268f)
                verticalLineTo(34.5605f)
                horizontalLineTo(40.1066f)
                curveTo(39.9011f, 34.5605f, 39.6974f, 34.5415f, 39.4943f, 34.5415f)
                curveTo(39.2816f, 34.5415f, 39.0631f, 34.5605f, 38.8479f, 34.5605f)
                horizontalLineTo(38.8285f)
                verticalLineTo(34.3762f)
                horizontalLineTo(38.9149f)
                curveTo(39.2277f, 34.3753f, 39.3179f, 34.1737f, 39.3217f, 33.7957f)
                verticalLineTo(31.796f)
                curveTo(39.3215f, 31.543f, 39.114f, 31.3901f, 38.9101f, 31.3901f)
                horizontalLineTo(38.8285f)
                verticalLineTo(31.2063f)
                horizontalLineTo(38.8479f)
                curveTo(39.0299f, 31.2063f, 39.215f, 31.2248f, 39.3943f, 31.2248f)
                curveTo(39.5351f, 31.2248f, 39.6715f, 31.2063f, 39.8325f, 31.2137f)
                lineTo(41.918f, 33.5617f)
                verticalLineTo(31.8159f)
                curveTo(41.9164f, 31.439f, 41.6636f, 31.3932f, 41.5251f, 31.3901f)
                horizontalLineTo(41.4001f)
                verticalLineTo(31.2063f)
                horizontalLineTo(41.4218f)
                curveTo(41.6448f, 31.2063f, 41.8638f, 31.2248f, 42.085f, 31.2248f)
                curveTo(42.2792f, 31.2248f, 42.4729f, 31.2063f, 42.6701f, 31.2063f)
                horizontalLineTo(42.6901f)
                verticalLineTo(31.3901f)
                horizontalLineTo(42.5984f)
                curveTo(42.4028f, 31.3951f, 42.2008f, 31.4131f, 42.1969f, 31.9722f)
                verticalLineTo(34.1318f)
                curveTo(42.1969f, 34.298f, 42.2007f, 34.4637f, 42.2237f, 34.6081f)
                lineTo(42.2278f, 34.6315f)
                horizontalLineTo(42.205f)
                close()
                moveTo(42.0242f, 34.5901f)
                horizontalLineTo(42.1798f)
                curveTo(42.1597f, 34.4473f, 42.155f, 34.2897f, 42.155f, 34.1318f)
                verticalLineTo(31.9722f)
                curveTo(42.155f, 31.4016f, 42.3947f, 31.3497f, 42.5984f, 31.3484f)
                horizontalLineTo(42.6498f)
                verticalLineTo(31.2474f)
                curveTo(42.4614f, 31.2489f, 42.2747f, 31.2661f, 42.085f, 31.2661f)
                curveTo(41.8688f, 31.2661f, 41.6566f, 31.2489f, 41.4417f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(41.5251f)
                curveTo(41.6717f, 31.3497f, 41.9583f, 31.4145f, 41.9583f, 31.8159f)
                lineTo(41.9533f, 33.6102f)
                lineTo(41.9441f, 33.6194f)
                lineTo(41.929f, 33.635f)
                lineTo(39.8167f, 31.2474f)
                curveTo(39.6762f, 31.2474f, 39.538f, 31.2661f, 39.3943f, 31.2661f)
                curveTo(39.2193f, 31.2661f, 39.041f, 31.2489f, 38.8684f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(38.9101f)
                curveTo(39.1332f, 31.3497f, 39.3625f, 31.518f, 39.3625f, 31.796f)
                verticalLineTo(33.7957f)
                curveTo(39.3625f, 34.1755f, 39.2565f, 34.418f, 38.9149f, 34.4193f)
                lineTo(38.8684f, 34.4189f)
                verticalLineTo(34.5197f)
                curveTo(39.0745f, 34.5183f, 39.2857f, 34.5008f, 39.4943f, 34.5008f)
                curveTo(39.6923f, 34.5008f, 39.8891f, 34.5183f, 40.0858f, 34.5197f)
                verticalLineTo(34.4193f)
                horizontalLineTo(40.0245f)
                curveTo(39.6521f, 34.4189f, 39.5587f, 34.2558f, 39.5587f, 33.8425f)
                verticalLineTo(31.8333f)
                lineTo(42.0242f, 34.5901f)
                close()
                moveTo(41.929f, 33.6047f)
                lineTo(41.9441f, 33.591f)
                lineTo(41.929f, 33.6047f)
                close()
                moveTo(41.918f, 33.5953f)
                verticalLineTo(33.5941f)
                lineTo(41.9143f, 33.5905f)
                lineTo(41.918f, 33.5953f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(43.4324f, 33.8616f)
                curveTo(43.3859f, 34.0224f, 43.3286f, 34.1471f, 43.3286f, 34.2314f)
                curveTo(43.3286f, 34.3742f, 43.5285f, 34.3977f, 43.6841f, 34.3977f)
                horizontalLineTo(43.7371f)
                verticalLineTo(34.5402f)
                curveTo(43.547f, 34.53f, 43.3523f, 34.5219f, 43.1622f, 34.5219f)
                curveTo(42.9913f, 34.5219f, 42.8207f, 34.53f, 42.6505f, 34.5402f)
                verticalLineTo(34.3977f)
                horizontalLineTo(42.6775f)
                curveTo(42.8636f, 34.3977f, 43.0208f, 34.2883f, 43.0902f, 34.0889f)
                lineTo(43.8512f, 31.911f)
                curveTo(43.9125f, 31.7349f, 43.9984f, 31.4977f, 44.0257f, 31.3217f)
                curveTo(44.1782f, 31.2697f, 44.3676f, 31.1754f, 44.459f, 31.1177f)
                curveTo(44.4723f, 31.1129f, 44.4819f, 31.108f, 44.4966f, 31.108f)
                curveTo(44.5104f, 31.108f, 44.5194f, 31.108f, 44.5291f, 31.1229f)
                curveTo(44.5435f, 31.1605f, 44.5577f, 31.2033f, 44.572f, 31.2412f)
                lineTo(45.4454f, 33.724f)
                curveTo(45.502f, 33.8896f, 45.5593f, 34.0652f, 45.6213f, 34.2084f)
                curveTo(45.6783f, 34.3415f, 45.7778f, 34.3977f, 45.9343f, 34.3977f)
                horizontalLineTo(45.9636f)
                verticalLineTo(34.5402f)
                curveTo(45.7496f, 34.53f, 45.5358f, 34.5219f, 45.3078f, 34.5219f)
                curveTo(45.0757f, 34.5219f, 44.838f, 34.53f, 44.5956f, 34.5402f)
                verticalLineTo(34.3977f)
                horizontalLineTo(44.6482f)
                curveTo(44.7567f, 34.3977f, 44.9429f, 34.3789f, 44.9429f, 34.2601f)
                curveTo(44.9429f, 34.1988f, 44.9003f, 34.0706f, 44.8473f, 33.918f)
                lineTo(44.6622f, 33.3677f)
                horizontalLineTo(43.585f)
                lineTo(43.4324f, 33.8616f)
                close()
                moveTo(44.1265f, 31.7588f)
                horizontalLineTo(44.117f)
                lineTo(43.6744f, 33.1022f)
                horizontalLineTo(44.5634f)
                lineTo(44.1265f, 31.7588f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(45.9614f, 34.5605f)
                curveTo(45.7475f, 34.552f, 45.5344f, 34.5414f, 45.308f, 34.5414f)
                curveTo(45.0764f, 34.5414f, 44.8385f, 34.552f, 44.5967f, 34.5605f)
                lineTo(44.5757f, 34.5616f)
                verticalLineTo(34.3771f)
                horizontalLineTo(44.6479f)
                curveTo(44.7582f, 34.3771f, 44.9217f, 34.3515f, 44.9219f, 34.2601f)
                curveTo(44.9231f, 34.206f, 44.8802f, 34.0765f, 44.8268f, 33.925f)
                lineTo(44.6468f, 33.388f)
                horizontalLineTo(43.599f)
                lineTo(43.4524f, 33.8677f)
                curveTo(43.4046f, 34.0303f, 43.3485f, 34.1544f, 43.3491f, 34.2313f)
                curveTo(43.3491f, 34.3476f, 43.5271f, 34.3771f, 43.684f, 34.3771f)
                horizontalLineTo(43.7566f)
                verticalLineTo(34.5616f)
                lineTo(43.7352f, 34.5605f)
                curveTo(43.5456f, 34.552f, 43.3512f, 34.5414f, 43.1622f, 34.5414f)
                curveTo(42.9921f, 34.5414f, 42.8218f, 34.552f, 42.6505f, 34.5605f)
                lineTo(42.6299f, 34.5616f)
                verticalLineTo(34.3771f)
                horizontalLineTo(42.6775f)
                curveTo(42.8545f, 34.3762f, 43.0025f, 34.2748f, 43.072f, 34.0822f)
                lineTo(43.8311f, 31.9036f)
                curveTo(43.892f, 31.7279f, 43.9777f, 31.4918f, 44.0194f, 31.3028f)
                curveTo(44.1685f, 31.251f, 44.3592f, 31.1558f, 44.4515f, 31.0985f)
                curveTo(44.4637f, 31.0938f, 44.477f, 31.0881f, 44.4964f, 31.0881f)
                curveTo(44.5087f, 31.087f, 44.5336f, 31.09f, 44.5482f, 31.1159f)
                curveTo(44.5626f, 31.1533f, 44.5766f, 31.1964f, 44.592f, 31.2347f)
                lineTo(45.4648f, 33.7171f)
                curveTo(45.522f, 33.8833f, 45.5786f, 34.0587f, 45.6402f, 34.2003f)
                curveTo(45.6961f, 34.3258f, 45.782f, 34.3758f, 45.9338f, 34.3771f)
                horizontalLineTo(45.9828f)
                verticalLineTo(34.5616f)
                lineTo(45.9614f, 34.5605f)
                close()
                moveTo(44.6159f, 34.5186f)
                curveTo(44.8507f, 34.51f, 45.0816f, 34.5008f, 45.308f, 34.5008f)
                curveTo(45.5286f, 34.5008f, 45.7351f, 34.51f, 45.9422f, 34.5183f)
                lineTo(45.9417f, 34.4189f)
                horizontalLineTo(45.9338f)
                curveTo(45.773f, 34.4193f, 45.661f, 34.356f, 45.6018f, 34.2161f)
                curveTo(45.5392f, 34.0727f, 45.4828f, 33.8964f, 45.4259f, 33.7308f)
                lineTo(44.5525f, 31.2476f)
                curveTo(44.5385f, 31.2097f, 44.5234f, 31.1673f, 44.5123f, 31.1344f)
                curveTo(44.5083f, 31.1289f, 44.5087f, 31.1289f, 44.5058f, 31.1289f)
                horizontalLineTo(44.4964f)
                curveTo(44.4862f, 31.1289f, 44.481f, 31.1321f, 44.4697f, 31.1353f)
                curveTo(44.3768f, 31.1934f, 44.1869f, 31.2886f, 44.0467f, 31.3247f)
                curveTo(44.0173f, 31.5045f, 43.931f, 31.7413f, 43.8699f, 31.9176f)
                lineTo(43.1098f, 34.0957f)
                curveTo(43.0375f, 34.302f, 42.8717f, 34.4193f, 42.6775f, 34.4189f)
                horizontalLineTo(42.6705f)
                verticalLineTo(34.5183f)
                curveTo(42.834f, 34.51f, 42.9971f, 34.5008f, 43.1622f, 34.5008f)
                curveTo(43.346f, 34.5008f, 43.5338f, 34.51f, 43.7161f, 34.5183f)
                verticalLineTo(34.4189f)
                horizontalLineTo(43.684f)
                curveTo(43.5297f, 34.4168f, 43.3133f, 34.4004f, 43.3072f, 34.2313f)
                curveTo(43.3085f, 34.1376f, 43.3669f, 34.0165f, 43.4134f, 33.8557f)
                lineTo(43.4325f, 33.8616f)
                lineTo(43.4134f, 33.8551f)
                lineTo(43.5695f, 33.3479f)
                horizontalLineTo(44.6759f)
                lineTo(44.8666f, 33.9115f)
                curveTo(44.9188f, 34.0643f, 44.9621f, 34.1907f, 44.9621f, 34.2601f)
                curveTo(44.9553f, 34.4054f, 44.7557f, 34.4162f, 44.6479f, 34.4189f)
                horizontalLineTo(44.6159f)
                verticalLineTo(34.5186f)
                close()
                moveTo(43.6461f, 33.1224f)
                lineTo(44.1019f, 31.7377f)
                horizontalLineTo(44.1265f)
                verticalLineTo(31.7588f)
                lineTo(44.1211f, 31.7602f)
                lineTo(44.1265f, 31.7588f)
                verticalLineTo(31.7377f)
                horizontalLineTo(44.1409f)
                lineTo(44.5897f, 33.1224f)
                horizontalLineTo(43.6461f)
                close()
                moveTo(43.7034f, 33.0811f)
                horizontalLineTo(44.5338f)
                lineTo(44.1209f, 31.81f)
                lineTo(43.7034f, 33.0811f)
                close()
                moveTo(44.1067f, 31.7649f)
                lineTo(44.1161f, 31.7615f)
                lineTo(44.1067f, 31.7649f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(47.1591f, 34.0748f)
                curveTo(47.1591f, 34.2656f, 47.291f, 34.3218f, 47.4433f, 34.3416f)
                curveTo(47.6376f, 34.3558f, 47.8514f, 34.3558f, 48.0704f, 34.3315f)
                curveTo(48.2695f, 34.3076f, 48.4403f, 34.1944f, 48.5255f, 34.0748f)
                curveTo(48.6009f, 33.9706f, 48.6437f, 33.8376f, 48.6728f, 33.7334f)
                horizontalLineTo(48.8101f)
                curveTo(48.7578f, 34.004f, 48.6915f, 34.2701f, 48.6345f, 34.5403f)
                curveTo(48.2177f, 34.5403f, 47.7987f, 34.522f, 47.3817f, 34.522f)
                curveTo(46.9636f, 34.522f, 46.5463f, 34.5403f, 46.1287f, 34.5403f)
                verticalLineTo(34.3976f)
                horizontalLineTo(46.1945f)
                curveTo(46.3657f, 34.3976f, 46.5515f, 34.3743f, 46.5515f, 34.08f)
                verticalLineTo(31.6406f)
                curveTo(46.5515f, 31.3932f, 46.3657f, 31.3695f, 46.1945f, 31.3695f)
                horizontalLineTo(46.1287f)
                verticalLineTo(31.2271f)
                curveTo(46.3799f, 31.2271f, 46.6271f, 31.2459f, 46.8783f, 31.2459f)
                curveTo(47.1208f, 31.2459f, 47.3576f, 31.2271f, 47.6004f, 31.2271f)
                verticalLineTo(31.3695f)
                horizontalLineTo(47.4811f)
                curveTo(47.3007f, 31.3695f, 47.1591f, 31.3746f, 47.1591f, 31.6261f)
                verticalLineTo(34.0748f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(48.6347f, 34.5605f)
                curveTo(48.2161f, 34.5605f, 47.798f, 34.5415f, 47.3817f, 34.5415f)
                curveTo(46.9641f, 34.5415f, 46.5464f, 34.5605f, 46.1278f, 34.5605f)
                horizontalLineTo(46.1078f)
                verticalLineTo(34.3771f)
                horizontalLineTo(46.1944f)
                curveTo(46.366f, 34.3729f, 46.529f, 34.3609f, 46.531f, 34.0799f)
                verticalLineTo(31.6397f)
                curveTo(46.529f, 31.4086f, 46.3667f, 31.3932f, 46.1944f, 31.3901f)
                horizontalLineTo(46.1078f)
                verticalLineTo(31.2063f)
                horizontalLineTo(46.1278f)
                curveTo(46.3806f, 31.2063f, 46.6276f, 31.2248f, 46.8779f, 31.2248f)
                curveTo(47.1196f, 31.2248f, 47.356f, 31.2063f, 47.6003f, 31.2063f)
                horizontalLineTo(47.6194f)
                verticalLineTo(31.3901f)
                horizontalLineTo(47.481f)
                curveTo(47.2969f, 31.3948f, 47.1826f, 31.3865f, 47.1785f, 31.626f)
                verticalLineTo(34.0747f)
                curveTo(47.1797f, 34.2522f, 47.296f, 34.2996f, 47.4444f, 34.3208f)
                curveTo(47.5279f, 34.3266f, 47.6163f, 34.3296f, 47.7076f, 34.3296f)
                curveTo(47.8237f, 34.3296f, 47.9442f, 34.3242f, 48.0669f, 34.3113f)
                curveTo(48.2603f, 34.2883f, 48.4266f, 34.1765f, 48.5087f, 34.0634f)
                curveTo(48.582f, 33.9618f, 48.6234f, 33.8318f, 48.6521f, 33.7285f)
                lineTo(48.6561f, 33.7128f)
                horizontalLineTo(48.835f)
                lineTo(48.8309f, 33.7378f)
                curveTo(48.7772f, 34.0091f, 48.7118f, 34.2739f, 48.6543f, 34.5445f)
                lineTo(48.6505f, 34.5605f)
                horizontalLineTo(48.6347f)
                close()
                moveTo(48.6173f, 34.5195f)
                curveTo(48.6722f, 34.2617f, 48.7342f, 34.0096f, 48.7856f, 33.7536f)
                horizontalLineTo(48.6877f)
                curveTo(48.6586f, 33.8569f, 48.6162f, 33.9843f, 48.5418f, 34.0876f)
                curveTo(48.453f, 34.2105f, 48.2773f, 34.3266f, 48.0714f, 34.3521f)
                curveTo(47.9473f, 34.3647f, 47.8238f, 34.3711f, 47.7076f, 34.3711f)
                curveTo(47.6156f, 34.3711f, 47.5269f, 34.367f, 47.4404f, 34.3609f)
                curveTo(47.2861f, 34.344f, 47.1368f, 34.2777f, 47.137f, 34.0747f)
                verticalLineTo(31.626f)
                curveTo(47.137f, 31.3621f, 47.3039f, 31.3484f, 47.481f, 31.3484f)
                horizontalLineTo(47.5788f)
                verticalLineTo(31.2474f)
                curveTo(47.345f, 31.2489f, 47.1142f, 31.2667f, 46.8779f, 31.2667f)
                curveTo(46.6327f, 31.2667f, 46.3921f, 31.2489f, 46.1492f, 31.2474f)
                verticalLineTo(31.3484f)
                horizontalLineTo(46.1944f)
                curveTo(46.3637f, 31.3484f, 46.5709f, 31.3781f, 46.5709f, 31.6397f)
                verticalLineTo(34.0799f)
                curveTo(46.5709f, 34.3871f, 46.3646f, 34.4189f, 46.1944f, 34.4189f)
                horizontalLineTo(46.1492f)
                verticalLineTo(34.5195f)
                curveTo(46.5592f, 34.5186f, 46.9695f, 34.5008f, 47.3817f, 34.5008f)
                curveTo(47.7944f, 34.5008f, 48.2064f, 34.5186f, 48.6173f, 34.5195f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFFFFE)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(19.1061f, 14.47f)
                curveTo(19.1061f, 10.0302f, 22.7052f, 6.4311f, 27.1447f, 6.4311f)
                curveTo(31.5845f, 6.4311f, 35.1836f, 10.0302f, 35.1836f, 14.47f)
                curveTo(35.1836f, 18.9097f, 31.5845f, 22.509f, 27.1447f, 22.509f)
                curveTo(22.7052f, 22.509f, 19.1061f, 18.9097f, 19.1061f, 14.47f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0069AA)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(32.0064f, 14.3117f)
                curveTo(32.0031f, 12.2531f, 30.7164f, 10.4974f, 28.9032f, 9.8021f)
                verticalLineTo(18.821f)
                curveTo(30.7164f, 18.1248f, 32.0031f, 16.3707f, 32.0064f, 14.3117f)
                close()
                moveTo(25.4442f, 18.8192f)
                verticalLineTo(9.803f)
                curveTo(23.6326f, 10.5005f, 22.3478f, 12.2537f, 22.343f, 14.3117f)
                curveTo(22.3478f, 16.3693f, 23.6326f, 18.1223f, 25.4442f, 18.8192f)
                close()
                moveTo(27.1746f, 6.6887f)
                curveTo(22.9646f, 6.6903f, 19.5538f, 10.1018f, 19.5531f, 14.3117f)
                curveTo(19.5538f, 18.5212f, 22.9646f, 21.9321f, 27.1746f, 21.9328f)
                curveTo(31.3845f, 21.9321f, 34.7961f, 18.5212f, 34.7971f, 14.3117f)
                curveTo(34.7961f, 10.1018f, 31.3845f, 6.6903f, 27.1746f, 6.6887f)
                close()
                moveTo(27.1559f, 22.6522f)
                curveTo(22.5491f, 22.6742f, 18.7574f, 18.9419f, 18.7574f, 14.3987f)
                curveTo(18.7574f, 9.4334f, 22.5491f, 5.9991f, 27.1559f, 6.0f)
                horizontalLineTo(29.3148f)
                curveTo(33.8672f, 5.9991f, 38.022f, 9.4318f, 38.022f, 14.3987f)
                curveTo(38.022f, 18.9403f, 33.8672f, 22.6522f, 29.3148f, 22.6522f)
                horizontalLineTo(27.1559f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(8.0207f, 34.3976f)
                horizontalLineTo(8.0873f)
                curveTo(8.258f, 34.3976f, 8.4384f, 34.3743f, 8.4384f, 34.1272f)
                verticalLineTo(31.6406f)
                curveTo(8.4384f, 31.3932f, 8.258f, 31.3697f, 8.0873f, 31.3697f)
                horizontalLineTo(8.0207f)
                verticalLineTo(31.2271f)
                curveTo(8.2058f, 31.2271f, 8.4905f, 31.2459f, 8.7237f, 31.2459f)
                curveTo(8.9609f, 31.2459f, 9.2453f, 31.2271f, 9.4684f, 31.2271f)
                verticalLineTo(31.3697f)
                horizontalLineTo(9.4014f)
                curveTo(9.2315f, 31.3697f, 9.0507f, 31.3932f, 9.0507f, 31.6406f)
                verticalLineTo(34.1272f)
                curveTo(9.0507f, 34.3743f, 9.2315f, 34.3976f, 9.4014f, 34.3976f)
                horizontalLineTo(9.4684f)
                verticalLineTo(34.5403f)
                curveTo(9.2408f, 34.5403f, 8.9553f, 34.522f, 8.7189f, 34.522f)
                curveTo(8.4859f, 34.522f, 8.2058f, 34.5403f, 8.0207f, 34.5403f)
                verticalLineTo(34.3976f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(9.4684f, 34.5605f)
                curveTo(9.2388f, 34.5605f, 8.9548f, 34.5415f, 8.7185f, 34.5415f)
                curveTo(8.4862f, 34.5415f, 8.207f, 34.5605f, 8.0207f, 34.5605f)
                horizontalLineTo(8.0f)
                verticalLineTo(34.3771f)
                horizontalLineTo(8.087f)
                curveTo(8.2593f, 34.3729f, 8.4159f, 34.3591f, 8.4174f, 34.1271f)
                verticalLineTo(31.6406f)
                curveTo(8.4159f, 31.4082f, 8.2593f, 31.3932f, 8.087f, 31.3901f)
                horizontalLineTo(8.0f)
                verticalLineTo(31.2063f)
                horizontalLineTo(8.0207f)
                curveTo(8.207f, 31.2063f, 8.4916f, 31.2248f, 8.7237f, 31.2248f)
                curveTo(8.9598f, 31.2248f, 9.244f, 31.2063f, 9.4684f, 31.2063f)
                horizontalLineTo(9.4896f)
                verticalLineTo(31.3901f)
                horizontalLineTo(9.4023f)
                curveTo(9.2298f, 31.3932f, 9.0723f, 31.4082f, 9.0714f, 31.6406f)
                verticalLineTo(34.1271f)
                curveTo(9.0723f, 34.3591f, 9.2298f, 34.3729f, 9.4023f, 34.3771f)
                horizontalLineTo(9.4896f)
                verticalLineTo(34.5605f)
                horizontalLineTo(9.4684f)
                close()
                moveTo(9.4479f, 34.5199f)
                lineTo(9.4481f, 34.4189f)
                horizontalLineTo(9.4023f)
                curveTo(9.2325f, 34.4189f, 9.0308f, 34.3891f, 9.0297f, 34.1271f)
                verticalLineTo(31.6406f)
                curveTo(9.0308f, 31.3781f, 9.2325f, 31.3488f, 9.4023f, 31.3488f)
                horizontalLineTo(9.4479f)
                verticalLineTo(31.2474f)
                curveTo(9.2289f, 31.2476f, 8.9538f, 31.2667f, 8.7237f, 31.2667f)
                curveTo(8.4982f, 31.2667f, 8.2253f, 31.2489f, 8.0415f, 31.2474f)
                verticalLineTo(31.3488f)
                horizontalLineTo(8.087f)
                curveTo(8.2562f, 31.3488f, 8.4583f, 31.3781f, 8.4583f, 31.6406f)
                verticalLineTo(34.1271f)
                curveTo(8.4583f, 34.3891f, 8.2562f, 34.4189f, 8.087f, 34.4189f)
                horizontalLineTo(8.0415f)
                verticalLineTo(34.5199f)
                curveTo(8.2253f, 34.5183f, 8.4934f, 34.5008f, 8.7185f, 34.5008f)
                curveTo(8.9497f, 34.5008f, 9.2241f, 34.5186f, 9.4479f, 34.5199f)
                close()
            }
            path(fill = SolidColor(Color(0xFF1A1919)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(48.7522f, 31.0924f)
                curveTo(49.0386f, 31.0924f, 49.2522f, 31.3123f, 49.2522f, 31.5933f)
                curveTo(49.2522f, 31.8741f, 49.0386f, 32.0917f, 48.7522f, 32.0917f)
                curveTo(48.4665f, 32.0917f, 48.2526f, 31.8741f, 48.2526f, 31.5933f)
                curveTo(48.2526f, 31.3123f, 48.4665f, 31.0924f, 48.7522f, 31.0924f)
                close()
                moveTo(48.7522f, 31.9988f)
                curveTo(48.9764f, 31.9988f, 49.1477f, 31.8082f, 49.1477f, 31.5933f)
                curveTo(49.1477f, 31.3781f, 48.9784f, 31.186f, 48.7522f, 31.186f)
                curveTo(48.5273f, 31.186f, 48.3562f, 31.3781f, 48.3562f, 31.5933f)
                curveTo(48.3562f, 31.8082f, 48.5273f, 31.9988f, 48.7522f, 31.9988f)
                close()
                moveTo(48.5037f, 31.8569f)
                verticalLineTo(31.8326f)
                curveTo(48.5648f, 31.8238f, 48.5763f, 31.8254f, 48.5763f, 31.7881f)
                verticalLineTo(31.4176f)
                curveTo(48.5763f, 31.3655f, 48.5711f, 31.3475f, 48.5057f, 31.3504f)
                verticalLineTo(31.3249f)
                horizontalLineTo(48.7616f)
                curveTo(48.8494f, 31.3249f, 48.9304f, 31.3669f, 48.9304f, 31.4578f)
                curveTo(48.9304f, 31.5321f, 48.8816f, 31.5872f, 48.8122f, 31.6086f)
                lineTo(48.8945f, 31.7232f)
                curveTo(48.9328f, 31.775f, 48.9764f, 31.8238f, 49.0045f, 31.8411f)
                verticalLineTo(31.8569f)
                horizontalLineTo(48.9073f)
                curveTo(48.8606f, 31.8569f, 48.8192f, 31.7588f, 48.7276f, 31.6271f)
                horizontalLineTo(48.6723f)
                verticalLineTo(31.7927f)
                curveTo(48.6723f, 31.8254f, 48.6838f, 31.8238f, 48.7452f, 31.8326f)
                verticalLineTo(31.8569f)
                horizontalLineTo(48.5037f)
                close()
                moveTo(48.6723f, 31.5933f)
                horizontalLineTo(48.7312f)
                curveTo(48.7957f, 31.5933f, 48.8255f, 31.5446f, 48.8255f, 31.4658f)
                curveTo(48.8255f, 31.3863f, 48.7795f, 31.3581f, 48.728f, 31.3581f)
                horizontalLineTo(48.6723f)
                verticalLineTo(31.5933f)
                close()
            }
        }
        .build()
        return _dinersClubInternational!!
    }

private var _dinersClubInternational: ImageVector? = null
