package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.Bitcoin: ImageVector
    get() {
        if (_bitcoin != null) {
            return _bitcoin!!
        }
        _bitcoin = Builder(name = "Bitcoin", defaultWidth = 58.0.dp, defaultHeight = 40.0.dp,
                viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(19.6654f, 16.1744f)
                curveTo(20.0714f, 16.1744f, 20.4218f, 16.2466f, 20.7164f, 16.3889f)
                curveTo(21.0124f, 16.5323f, 21.257f, 16.7256f, 21.4528f, 16.9687f)
                curveTo(21.6461f, 17.213f, 21.79f, 17.4987f, 21.8829f, 17.8258f)
                curveTo(21.9752f, 18.1541f, 22.0215f, 18.5068f, 22.0215f, 18.8846f)
                curveTo(22.0215f, 19.4644f, 21.9148f, 20.0128f, 21.699f, 20.5294f)
                curveTo(21.4835f, 21.0467f, 21.1907f, 21.4954f, 20.8184f, 21.8783f)
                curveTo(20.4465f, 22.2607f, 20.0073f, 22.562f, 19.5008f, 22.7845f)
                curveTo(18.995f, 23.0077f, 18.4454f, 23.1188f, 17.8551f, 23.1188f)
                curveTo(17.7787f, 23.1188f, 17.6445f, 23.1169f, 17.455f, 23.1126f)
                curveTo(17.2654f, 23.1088f, 17.0474f, 23.0895f, 16.8034f, 23.0565f)
                curveTo(16.5578f, 23.0226f, 16.2982f, 22.9722f, 16.0238f, 22.9047f)
                curveTo(15.7498f, 22.8384f, 15.4895f, 22.7453f, 15.2443f, 22.6274f)
                lineTo(17.4359f, 13.4655f)
                lineTo(19.3988f, 13.1627f)
                lineTo(18.6143f, 16.4138f)
                curveTo(18.7823f, 16.3385f, 18.9515f, 16.2799f, 19.1204f, 16.2376f)
                curveTo(19.2903f, 16.1965f, 19.4714f, 16.1744f, 19.6654f, 16.1744f)
                close()
                moveTo(18.019f, 21.5698f)
                curveTo(18.3146f, 21.5698f, 18.593f, 21.4976f, 18.8548f, 21.3554f)
                curveTo(19.1173f, 21.2135f, 19.3438f, 21.0214f, 19.5333f, 20.7821f)
                curveTo(19.7229f, 20.5422f, 19.8734f, 20.2714f, 19.9829f, 19.9689f)
                curveTo(20.0924f, 19.6667f, 20.1477f, 19.3514f, 20.1477f, 19.0231f)
                curveTo(20.1477f, 18.62f, 20.0802f, 18.3054f, 19.945f, 18.0782f)
                curveTo(19.8099f, 17.8516f, 19.5602f, 17.738f, 19.1974f, 17.738f)
                curveTo(19.0785f, 17.738f, 18.9252f, 17.7604f, 18.7353f, 17.8006f)
                curveTo(18.5448f, 17.8438f, 18.3743f, 17.9325f, 18.2214f, 18.0661f)
                lineTo(17.3858f, 21.5191f)
                curveTo(17.4362f, 21.5275f, 17.4809f, 21.5362f, 17.5188f, 21.544f)
                curveTo(17.556f, 21.5524f, 17.597f, 21.5586f, 17.638f, 21.563f)
                curveTo(17.6814f, 21.568f, 17.7309f, 21.5701f, 17.7906f, 21.5701f)
                curveTo(17.8504f, 21.5701f, 17.9261f, 21.5698f, 18.019f, 21.5698f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(24.058f, 22.943f)
                horizontalLineTo(22.1829f)
                lineTo(23.7664f, 16.3142f)
                horizontalLineTo(25.6543f)
                lineTo(24.058f, 22.943f)
                close()
                moveTo(24.9702f, 15.5072f)
                curveTo(24.7083f, 15.5072f, 24.4712f, 15.4294f, 24.2607f, 15.2744f)
                curveTo(24.0483f, 15.1201f, 23.9432f, 14.8823f, 23.9432f, 14.562f)
                curveTo(23.9432f, 14.3859f, 23.9791f, 14.2203f, 24.0505f, 14.0647f)
                curveTo(24.1227f, 13.9091f, 24.2175f, 13.7746f, 24.3361f, 13.661f)
                curveTo(24.4546f, 13.5481f, 24.5916f, 13.4578f, 24.7474f, 13.3896f)
                curveTo(24.9041f, 13.3227f, 25.0709f, 13.2894f, 25.2486f, 13.2894f)
                curveTo(25.5101f, 13.2894f, 25.7463f, 13.3669f, 25.9574f, 13.5222f)
                curveTo(26.1679f, 13.6781f, 26.274f, 13.9159f, 26.274f, 14.2343f)
                curveTo(26.274f, 14.4111f, 26.2383f, 14.5773f, 26.1661f, 14.7329f)
                curveTo(26.0944f, 14.8885f, 26.0f, 15.0223f, 25.8814f, 15.1365f)
                curveTo(25.7641f, 15.2495f, 25.6255f, 15.3395f, 25.47f, 15.407f)
                curveTo(25.3133f, 15.4748f, 25.1475f, 15.5072f, 24.9702f, 15.5072f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(27.2969f, 14.6634f)
                lineTo(29.2608f, 14.3606f)
                lineTo(28.7785f, 16.3142f)
                horizontalLineTo(30.8816f)
                lineTo(30.5018f, 17.8513f)
                horizontalLineTo(28.4112f)
                lineTo(27.8544f, 20.1702f)
                curveTo(27.8031f, 20.3635f, 27.774f, 20.544f, 27.7659f, 20.7114f)
                curveTo(27.7568f, 20.8801f, 27.7781f, 21.0248f, 27.8287f, 21.1465f)
                curveTo(27.8791f, 21.2685f, 27.9698f, 21.3625f, 28.1012f, 21.4294f)
                curveTo(28.232f, 21.497f, 28.4193f, 21.5309f, 28.6646f, 21.5309f)
                curveTo(28.8667f, 21.5309f, 29.0638f, 21.5119f, 29.2543f, 21.4736f)
                curveTo(29.4435f, 21.4366f, 29.6356f, 21.3843f, 29.8299f, 21.3162f)
                lineTo(29.9697f, 22.7537f)
                curveTo(29.7163f, 22.8461f, 29.442f, 22.9258f, 29.1463f, 22.9927f)
                curveTo(28.8504f, 23.0603f, 28.4997f, 23.0929f, 28.0946f, 23.0929f)
                curveTo(27.5122f, 23.0929f, 27.0605f, 23.0073f, 26.7389f, 22.8359f)
                curveTo(26.4176f, 22.6631f, 26.1905f, 22.4275f, 26.0544f, 22.1291f)
                curveTo(25.9202f, 21.8319f, 25.8605f, 21.4889f, 25.8774f, 21.1027f)
                curveTo(25.8949f, 20.7155f, 25.9534f, 20.3084f, 26.0544f, 19.8799f)
                lineTo(27.2969f, 14.6634f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(30.799f, 20.297f)
                curveTo(30.799f, 19.7259f, 30.8919f, 19.1878f, 31.0777f, 18.6833f)
                curveTo(31.2629f, 18.1788f, 31.53f, 17.7378f, 31.8766f, 17.359f)
                curveTo(32.222f, 16.9821f, 32.6424f, 16.6837f, 33.1373f, 16.4649f)
                curveTo(33.63f, 16.2467f, 34.1815f, 16.1368f, 34.7896f, 16.1368f)
                curveTo(35.17f, 16.1368f, 35.51f, 16.1723f, 35.8091f, 16.2442f)
                curveTo(36.1094f, 16.3164f, 36.3812f, 16.4101f, 36.6268f, 16.5274f)
                lineTo(35.9802f, 17.9905f)
                curveTo(35.8113f, 17.9223f, 35.6358f, 17.8623f, 35.4547f, 17.8075f)
                curveTo(35.2732f, 17.7521f, 35.0517f, 17.7253f, 34.7899f, 17.7253f)
                curveTo(34.1643f, 17.7253f, 33.6694f, 17.9398f, 33.3012f, 18.3674f)
                curveTo(32.9346f, 18.7956f, 32.7497f, 19.3717f, 32.7497f, 20.0947f)
                curveTo(32.7497f, 20.5232f, 32.8426f, 20.8693f, 33.029f, 21.1345f)
                curveTo(33.2146f, 21.3993f, 33.5571f, 21.531f, 34.0548f, 21.531f)
                curveTo(34.3004f, 21.531f, 34.5372f, 21.5055f, 34.7643f, 21.4557f)
                curveTo(34.9929f, 21.4052f, 35.1947f, 21.3421f, 35.3727f, 21.2668f)
                lineTo(35.5125f, 22.7662f)
                curveTo(35.2754f, 22.858f, 35.0139f, 22.9408f, 34.727f, 23.013f)
                curveTo(34.4396f, 23.0831f, 34.0973f, 23.1189f, 33.7004f, 23.1189f)
                curveTo(33.1767f, 23.1189f, 32.7331f, 23.0429f, 32.3706f, 22.8926f)
                curveTo(32.0077f, 22.7401f, 31.7077f, 22.5375f, 31.4715f, 22.281f)
                curveTo(31.2341f, 22.024f, 31.0636f, 21.7236f, 30.9582f, 21.3791f)
                curveTo(30.8524f, 21.0358f, 30.799f, 20.6742f, 30.799f, 20.297f)
                horizontalLineTo(30.799f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(39.1275f, 23.1194f)
                curveTo(38.6798f, 23.1194f, 38.2913f, 23.0519f, 37.9616f, 22.9177f)
                curveTo(37.6328f, 22.7833f, 37.3607f, 22.595f, 37.1451f, 22.3507f)
                curveTo(36.9296f, 22.1076f, 36.7679f, 21.8194f, 36.6574f, 21.4876f)
                curveTo(36.5467f, 21.1562f, 36.4938f, 20.7886f, 36.4938f, 20.3862f)
                curveTo(36.4938f, 19.8811f, 36.5755f, 19.3763f, 36.74f, 18.8727f)
                curveTo(36.9039f, 18.3686f, 37.147f, 17.9154f, 37.4692f, 17.5124f)
                curveTo(37.7886f, 17.1087f, 38.1824f, 16.7788f, 38.6467f, 16.5214f)
                curveTo(39.11f, 16.2662f, 39.6433f, 16.1377f, 40.2421f, 16.1377f)
                curveTo(40.6813f, 16.1377f, 41.0682f, 16.2055f, 41.4023f, 16.3397f)
                curveTo(41.7348f, 16.4741f, 42.0089f, 16.6637f, 42.2256f, 16.9067f)
                curveTo(42.4399f, 17.151f, 42.6029f, 17.438f, 42.7124f, 17.7704f)
                curveTo(42.8228f, 18.1012f, 42.8769f, 18.4697f, 42.8769f, 18.8724f)
                curveTo(42.8769f, 19.376f, 42.7965f, 19.8808f, 42.637f, 20.3859f)
                curveTo(42.4772f, 20.8882f, 42.2403f, 21.3426f, 41.9275f, 21.7463f)
                curveTo(41.6153f, 22.1493f, 41.2249f, 22.4789f, 40.756f, 22.7353f)
                curveTo(40.2871f, 22.9912f, 39.7437f, 23.1194f, 39.1275f, 23.1194f)
                close()
                moveTo(40.0644f, 17.7259f)
                curveTo(39.7863f, 17.7259f, 39.5407f, 17.8062f, 39.3302f, 17.9649f)
                curveTo(39.119f, 18.1252f, 38.9417f, 18.3268f, 38.7987f, 18.5699f)
                curveTo(38.6542f, 18.8139f, 38.5469f, 19.0809f, 38.4746f, 19.3701f)
                curveTo(38.403f, 19.6604f, 38.3676f, 19.9346f, 38.3676f, 20.1954f)
                curveTo(38.3676f, 20.6159f, 38.4358f, 20.9433f, 38.5697f, 21.1792f)
                curveTo(38.7058f, 21.4136f, 38.9498f, 21.5315f, 39.3048f, 21.5315f)
                curveTo(39.5839f, 21.5315f, 39.8282f, 21.4519f, 40.04f, 21.2916f)
                curveTo(40.2499f, 21.1325f, 40.4272f, 20.9309f, 40.5715f, 20.6872f)
                curveTo(40.715f, 20.4444f, 40.8233f, 20.1768f, 40.8955f, 19.887f)
                curveTo(40.9665f, 19.5976f, 41.0025f, 19.3218f, 41.0025f, 19.0616f)
                curveTo(41.0025f, 18.6421f, 40.9346f, 18.3141f, 40.7995f, 18.0785f)
                curveTo(40.6644f, 17.8435f, 40.4191f, 17.7259f, 40.0644f, 17.7259f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(44.9197f, 22.943f)
                horizontalLineTo(43.0434f)
                lineTo(44.6269f, 16.3142f)
                horizontalLineTo(46.5157f)
                lineTo(44.9197f, 22.943f)
                close()
                moveTo(45.8306f, 15.5072f)
                curveTo(45.5691f, 15.5072f, 45.332f, 15.4294f, 45.1218f, 15.2744f)
                curveTo(44.9103f, 15.1201f, 44.8043f, 14.8823f, 44.8043f, 14.562f)
                curveTo(44.8043f, 14.3859f, 44.8405f, 14.2203f, 44.9122f, 14.0647f)
                curveTo(44.9838f, 13.9091f, 45.0789f, 13.7746f, 45.1975f, 13.661f)
                curveTo(45.3154f, 13.5481f, 45.4537f, 13.4578f, 45.6091f, 13.3896f)
                curveTo(45.7649f, 13.3227f, 45.9317f, 13.2894f, 46.109f, 13.2894f)
                curveTo(46.3712f, 13.2894f, 46.608f, 13.3669f, 46.8188f, 13.5222f)
                curveTo(47.03f, 13.6781f, 47.1363f, 13.9159f, 47.1363f, 14.2343f)
                curveTo(47.1363f, 14.4111f, 47.0985f, 14.5773f, 47.0275f, 14.7329f)
                curveTo(46.9565f, 14.8885f, 46.8617f, 15.0223f, 46.7434f, 15.1365f)
                curveTo(46.6246f, 15.2495f, 46.4882f, 15.3395f, 46.3324f, 15.407f)
                curveTo(46.1754f, 15.4748f, 46.0089f, 15.5072f, 45.8306f, 15.5072f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(47.8658f, 16.6164f)
                curveTo(48.0082f, 16.575f, 48.1671f, 16.5252f, 48.3401f, 16.4711f)
                curveTo(48.5137f, 16.4169f, 48.7073f, 16.3665f, 48.9238f, 16.3211f)
                curveTo(49.1381f, 16.2744f, 49.3796f, 16.2367f, 49.6455f, 16.2069f)
                curveTo(49.9114f, 16.177f, 50.2139f, 16.1624f, 50.5508f, 16.1624f)
                curveTo(51.5393f, 16.1624f, 52.2212f, 16.4487f, 52.5976f, 17.0201f)
                curveTo(52.9733f, 17.5915f, 53.0386f, 18.3733f, 52.7943f, 19.3639f)
                lineTo(51.9322f, 22.943f)
                horizontalLineTo(50.0449f)
                lineTo(50.8808f, 19.4392f)
                curveTo(50.9315f, 19.2204f, 50.9718f, 19.0088f, 51.0012f, 18.8022f)
                curveTo(51.0313f, 18.5977f, 51.0294f, 18.4172f, 50.9947f, 18.2609f)
                curveTo(50.9618f, 18.1066f, 50.883f, 17.9805f, 50.7613f, 17.8825f)
                curveTo(50.6374f, 17.7857f, 50.4504f, 17.7378f, 50.1967f, 17.7378f)
                curveTo(49.9523f, 17.7378f, 49.7037f, 17.7639f, 49.4496f, 17.8143f)
                lineTo(48.2206f, 22.943f)
                horizontalLineTo(46.3327f)
                lineTo(47.8658f, 16.6164f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(25.2123f, 26.8937f)
                lineTo(24.8444f, 27.5585f)
                horizontalLineTo(24.4465f)
                curveTo(24.7268f, 27.0555f, 25.0002f, 26.5924f, 25.2667f, 26.1692f)
                curveTo(25.5332f, 25.7459f, 25.7966f, 25.3463f, 26.0569f, 24.9703f)
                horizontalLineTo(26.4135f)
                curveTo(26.451f, 25.1571f, 26.4854f, 25.346f, 26.5167f, 25.5361f)
                curveTo(26.548f, 25.7266f, 26.5787f, 25.9264f, 26.6087f, 26.1356f)
                curveTo(26.6387f, 26.3447f, 26.6675f, 26.5666f, 26.695f, 26.8006f)
                curveTo(26.7226f, 27.0347f, 26.7513f, 27.2871f, 26.7814f, 27.5588f)
                horizontalLineTo(26.4135f)
                curveTo(26.401f, 27.4468f, 26.3897f, 27.3341f, 26.3797f, 27.2208f)
                curveTo(26.3697f, 27.1075f, 26.3584f, 26.9986f, 26.3459f, 26.894f)
                horizontalLineTo(25.2123f)
                verticalLineTo(26.8937f)
                close()
                moveTo(26.3121f, 26.6021f)
                curveTo(26.2921f, 26.4007f, 26.269f, 26.2f, 26.2427f, 26.0008f)
                curveTo(26.2164f, 25.8016f, 26.1858f, 25.5962f, 26.1507f, 25.3846f)
                curveTo(26.0631f, 25.5116f, 25.9543f, 25.6756f, 25.8241f, 25.8757f)
                curveTo(25.694f, 26.0764f, 25.5463f, 26.3183f, 25.3812f, 26.6021f)
                horizontalLineTo(26.3121f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(28.1118f, 27.6142f)
                curveTo(27.9491f, 27.6142f, 27.8058f, 27.5905f, 27.682f, 27.5432f)
                curveTo(27.5581f, 27.4959f, 27.4549f, 27.4287f, 27.3723f, 27.3416f)
                curveTo(27.2897f, 27.2547f, 27.2277f, 27.1492f, 27.1865f, 27.026f)
                curveTo(27.1452f, 26.9027f, 27.1245f, 26.7639f, 27.1245f, 26.6096f)
                curveTo(27.1245f, 26.3855f, 27.1602f, 26.1714f, 27.2315f, 25.9672f)
                curveTo(27.3028f, 25.7633f, 27.4042f, 25.5828f, 27.5356f, 25.426f)
                curveTo(27.6669f, 25.2691f, 27.8252f, 25.144f, 28.0104f, 25.0503f)
                curveTo(28.1956f, 24.957f, 28.4018f, 24.9103f, 28.6298f, 24.9103f)
                curveTo(28.825f, 24.9103f, 28.9808f, 24.9302f, 29.0972f, 24.97f)
                curveTo(29.2135f, 25.0099f, 29.2967f, 25.0472f, 29.3468f, 25.0821f)
                lineTo(29.1966f, 25.3808f)
                curveTo(29.1388f, 25.3435f, 29.0609f, 25.308f, 28.962f, 25.2744f)
                curveTo(28.8632f, 25.2411f, 28.7462f, 25.224f, 28.611f, 25.224f)
                curveTo(28.4384f, 25.224f, 28.2832f, 25.2645f, 28.1456f, 25.3457f)
                curveTo(28.0079f, 25.4266f, 27.8915f, 25.5312f, 27.7965f, 25.6594f)
                curveTo(27.7014f, 25.7876f, 27.6288f, 25.932f, 27.5787f, 26.0926f)
                curveTo(27.5287f, 26.2532f, 27.5037f, 26.4119f, 27.5037f, 26.5688f)
                curveTo(27.5037f, 27.0543f, 27.7151f, 27.2971f, 28.1381f, 27.2971f)
                curveTo(28.2281f, 27.2971f, 28.3089f, 27.2905f, 28.3802f, 27.2781f)
                curveTo(28.4515f, 27.2659f, 28.5147f, 27.2513f, 28.5697f, 27.2351f)
                curveTo(28.6248f, 27.2189f, 28.6736f, 27.2012f, 28.7161f, 27.181f)
                curveTo(28.7587f, 27.1611f, 28.7962f, 27.1436f, 28.8288f, 27.1287f)
                lineTo(28.8738f, 27.4424f)
                curveTo(28.8438f, 27.4598f, 28.8044f, 27.4785f, 28.7556f, 27.4984f)
                curveTo(28.7068f, 27.5183f, 28.6498f, 27.537f, 28.5848f, 27.5548f)
                curveTo(28.5197f, 27.5722f, 28.4471f, 27.5865f, 28.367f, 27.5977f)
                curveTo(28.287f, 27.6089f, 28.2019f, 27.6142f, 28.1118f, 27.6142f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(30.2208f, 27.6142f)
                curveTo(30.0582f, 27.6142f, 29.9149f, 27.5905f, 29.791f, 27.5432f)
                curveTo(29.6672f, 27.4959f, 29.5639f, 27.4287f, 29.4813f, 27.3416f)
                curveTo(29.3988f, 27.2547f, 29.3368f, 27.1492f, 29.2955f, 27.026f)
                curveTo(29.2542f, 26.9027f, 29.2336f, 26.7639f, 29.2336f, 26.6096f)
                curveTo(29.2336f, 26.3855f, 29.2692f, 26.1714f, 29.3406f, 25.9672f)
                curveTo(29.4119f, 25.7633f, 29.5132f, 25.5828f, 29.6446f, 25.426f)
                curveTo(29.776f, 25.2691f, 29.9343f, 25.144f, 30.1195f, 25.0503f)
                curveTo(30.3047f, 24.957f, 30.5108f, 24.9103f, 30.7389f, 24.9103f)
                curveTo(30.9341f, 24.9103f, 31.0899f, 24.9302f, 31.2062f, 24.97f)
                curveTo(31.3226f, 25.0099f, 31.4058f, 25.0472f, 31.4559f, 25.0821f)
                lineTo(31.3057f, 25.3808f)
                curveTo(31.2478f, 25.3435f, 31.1699f, 25.308f, 31.0711f, 25.2744f)
                curveTo(30.9722f, 25.2411f, 30.8552f, 25.224f, 30.7201f, 25.224f)
                curveTo(30.5474f, 25.224f, 30.3923f, 25.2645f, 30.2546f, 25.3457f)
                curveTo(30.117f, 25.4266f, 30.0006f, 25.5312f, 29.9055f, 25.6594f)
                curveTo(29.8104f, 25.7876f, 29.7378f, 25.932f, 29.6878f, 26.0926f)
                curveTo(29.6377f, 26.2532f, 29.6127f, 26.4119f, 29.6127f, 26.5688f)
                curveTo(29.6127f, 27.0543f, 29.8242f, 27.2971f, 30.2471f, 27.2971f)
                curveTo(30.3372f, 27.2971f, 30.4179f, 27.2905f, 30.4892f, 27.2781f)
                curveTo(30.5606f, 27.2659f, 30.6238f, 27.2513f, 30.6788f, 27.2351f)
                curveTo(30.7339f, 27.2189f, 30.7827f, 27.2012f, 30.8252f, 27.181f)
                curveTo(30.8678f, 27.1611f, 30.9053f, 27.1436f, 30.9378f, 27.1287f)
                lineTo(30.9829f, 27.4424f)
                curveTo(30.9528f, 27.4598f, 30.9134f, 27.4785f, 30.8646f, 27.4984f)
                curveTo(30.8158f, 27.5183f, 30.7589f, 27.537f, 30.6938f, 27.5548f)
                curveTo(30.6288f, 27.5722f, 30.5562f, 27.5865f, 30.4761f, 27.5977f)
                curveTo(30.396f, 27.6089f, 30.3109f, 27.6142f, 30.2208f, 27.6142f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(31.2288f, 27.5582f)
                lineTo(31.8519f, 24.9701f)
                horizontalLineTo(33.3872f)
                lineTo(33.3159f, 25.2726f)
                horizontalLineTo(32.1409f)
                lineTo(31.9533f, 26.0532f)
                horizontalLineTo(32.9968f)
                lineTo(32.9255f, 26.3482f)
                horizontalLineTo(31.8857f)
                lineTo(31.6642f, 27.2557f)
                horizontalLineTo(32.9255f)
                lineTo(32.8542f, 27.5582f)
                horizontalLineTo(31.2288f)
                horizontalLineTo(31.2288f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(34.4739f, 24.9438f)
                curveTo(34.7768f, 24.9438f, 35.0051f, 25.0011f, 35.159f, 25.1156f)
                curveTo(35.3129f, 25.2302f, 35.3899f, 25.397f, 35.3899f, 25.6161f)
                curveTo(35.3899f, 25.7854f, 35.358f, 25.932f, 35.2942f, 26.0549f)
                curveTo(35.2303f, 26.1782f, 35.1396f, 26.2796f, 35.022f, 26.3596f)
                curveTo(34.9044f, 26.4393f, 34.763f, 26.4981f, 34.5978f, 26.5367f)
                curveTo(34.4326f, 26.5753f, 34.2487f, 26.5949f, 34.046f, 26.5949f)
                horizontalLineTo(33.787f)
                lineTo(33.5542f, 27.5584f)
                horizontalLineTo(33.1901f)
                lineTo(33.8058f, 25.0039f)
                curveTo(33.9109f, 24.979f, 34.0222f, 24.9628f, 34.1398f, 24.9554f)
                curveTo(34.2575f, 24.9476f, 34.3688f, 24.9438f, 34.4739f, 24.9438f)
                close()
                moveTo(34.4289f, 25.2501f)
                curveTo(34.2512f, 25.2501f, 34.1436f, 25.2551f, 34.1061f, 25.265f)
                lineTo(33.8583f, 26.2921f)
                horizontalLineTo(34.0948f)
                curveTo(34.1999f, 26.2921f, 34.3075f, 26.283f, 34.4176f, 26.2641f)
                curveTo(34.5277f, 26.2454f, 34.6266f, 26.2124f, 34.7142f, 26.1654f)
                curveTo(34.8018f, 26.1181f, 34.8737f, 26.0527f, 34.93f, 25.969f)
                curveTo(34.9863f, 25.8856f, 35.0145f, 25.7782f, 35.0145f, 25.6463f)
                curveTo(35.0145f, 25.5044f, 34.9619f, 25.4029f, 34.8568f, 25.3416f)
                curveTo(34.7517f, 25.2806f, 34.6091f, 25.2501f, 34.4289f, 25.2501f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(37.6106f, 24.9701f)
                lineTo(37.5392f, 25.2726f)
                horizontalLineTo(36.7547f)
                lineTo(36.2029f, 27.5582f)
                horizontalLineTo(35.8388f)
                lineTo(36.3906f, 25.2726f)
                horizontalLineTo(35.606f)
                lineTo(35.6773f, 24.9701f)
                horizontalLineTo(37.6106f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(37.2728f, 27.5582f)
                lineTo(37.8959f, 24.9701f)
                horizontalLineTo(39.4312f)
                lineTo(39.3599f, 25.2726f)
                horizontalLineTo(38.185f)
                lineTo(37.9973f, 26.0532f)
                horizontalLineTo(39.0408f)
                lineTo(38.9695f, 26.3482f)
                horizontalLineTo(37.9297f)
                lineTo(37.7082f, 27.2557f)
                horizontalLineTo(38.9695f)
                lineTo(38.8982f, 27.5582f)
                horizontalLineTo(37.2728f)
                horizontalLineTo(37.2728f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(40.5123f, 24.9438f)
                curveTo(40.8977f, 24.9438f, 41.1855f, 25.0341f, 41.3757f, 25.2146f)
                curveTo(41.5659f, 25.3951f, 41.661f, 25.6385f, 41.661f, 25.9447f)
                curveTo(41.661f, 26.1589f, 41.6272f, 26.3649f, 41.5596f, 26.5625f)
                curveTo(41.4921f, 26.7608f, 41.3869f, 26.9354f, 41.2443f, 27.0876f)
                curveTo(41.1017f, 27.2391f, 40.9196f, 27.3602f, 40.6981f, 27.4498f)
                curveTo(40.4766f, 27.5395f, 40.212f, 27.5843f, 39.9042f, 27.5843f)
                curveTo(39.7991f, 27.5843f, 39.6852f, 27.5793f, 39.5626f, 27.5693f)
                curveTo(39.44f, 27.5594f, 39.3323f, 27.5419f, 39.2397f, 27.5171f)
                lineTo(39.8441f, 25.0036f)
                curveTo(39.9492f, 24.9787f, 40.0606f, 24.9625f, 40.1782f, 24.9551f)
                curveTo(40.2958f, 24.9476f, 40.4072f, 24.9438f, 40.5123f, 24.9438f)
                close()
                moveTo(40.4823f, 25.2501f)
                curveTo(40.2946f, 25.2501f, 40.182f, 25.2551f, 40.1444f, 25.265f)
                lineTo(39.6639f, 27.2594f)
                curveTo(39.684f, 27.2643f, 39.7177f, 27.2687f, 39.7653f, 27.2724f)
                curveTo(39.8128f, 27.2762f, 39.8904f, 27.278f, 39.998f, 27.278f)
                curveTo(40.1957f, 27.278f, 40.374f, 27.2454f, 40.5329f, 27.1794f)
                curveTo(40.6919f, 27.1134f, 40.8264f, 27.0213f, 40.9365f, 26.9027f)
                curveTo(41.0466f, 26.7844f, 41.1317f, 26.6441f, 41.1917f, 26.481f)
                curveTo(41.2518f, 26.3179f, 41.2818f, 26.1393f, 41.2818f, 25.9451f)
                curveTo(41.2818f, 25.726f, 41.218f, 25.5554f, 41.0904f, 25.4331f)
                curveTo(40.9628f, 25.3114f, 40.7601f, 25.2501f, 40.4823f, 25.2501f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(44.4651f, 27.5582f)
                horizontalLineTo(44.101f)
                lineTo(44.39f, 26.3557f)
                horizontalLineTo(43.185f)
                lineTo(42.896f, 27.5582f)
                horizontalLineTo(42.5319f)
                lineTo(43.155f, 24.9701f)
                horizontalLineTo(43.5191f)
                lineTo(43.2564f, 26.0532f)
                horizontalLineTo(44.4617f)
                lineTo(44.7244f, 24.9701f)
                horizontalLineTo(45.0885f)
                lineTo(44.4651f, 27.5582f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(45.0394f, 27.5582f)
                lineTo(45.6626f, 24.9701f)
                horizontalLineTo(47.1979f)
                lineTo(47.1263f, 25.2726f)
                horizontalLineTo(45.9513f)
                lineTo(45.7636f, 26.0532f)
                horizontalLineTo(46.8072f)
                lineTo(46.7355f, 26.3482f)
                horizontalLineTo(45.6957f)
                lineTo(45.4746f, 27.2557f)
                horizontalLineTo(46.7355f)
                lineTo(46.6639f, 27.5582f)
                horizontalLineTo(45.0394f)
                horizontalLineTo(45.0394f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(48.2847f, 24.9438f)
                curveTo(48.5625f, 24.9438f, 48.7827f, 24.9999f, 48.9453f, 25.1119f)
                curveTo(49.108f, 25.2239f, 49.189f, 25.3883f, 49.189f, 25.6046f)
                curveTo(49.189f, 25.8237f, 49.1249f, 26.0076f, 48.996f, 26.1558f)
                curveTo(48.8671f, 26.3039f, 48.6863f, 26.4103f, 48.4536f, 26.4748f)
                curveTo(48.4836f, 26.5274f, 48.5187f, 26.594f, 48.5587f, 26.6749f)
                curveTo(48.5987f, 26.7558f, 48.64f, 26.8454f, 48.6826f, 26.9438f)
                curveTo(48.7248f, 27.0418f, 48.7664f, 27.1442f, 48.8065f, 27.2497f)
                curveTo(48.8465f, 27.3558f, 48.8812f, 27.4582f, 48.9116f, 27.5578f)
                horizontalLineTo(48.5399f)
                curveTo(48.5052f, 27.4632f, 48.4686f, 27.3674f, 48.4311f, 27.2703f)
                curveTo(48.3938f, 27.1731f, 48.3554f, 27.0798f, 48.3169f, 26.9901f)
                curveTo(48.2778f, 26.9005f, 48.2393f, 26.8165f, 48.2002f, 26.7381f)
                curveTo(48.1617f, 26.6596f, 48.1258f, 26.5902f, 48.0932f, 26.5308f)
                curveTo(48.0607f, 26.5333f, 48.0282f, 26.5351f, 47.9956f, 26.5364f)
                curveTo(47.9631f, 26.5376f, 47.9309f, 26.5383f, 47.898f, 26.5383f)
                horizontalLineTo(47.609f)
                lineTo(47.365f, 27.5578f)
                horizontalLineTo(47.0009f)
                lineTo(47.6168f, 25.0033f)
                curveTo(47.7219f, 24.9784f, 47.833f, 24.9622f, 47.9509f, 24.9547f)
                curveTo(48.0682f, 24.9476f, 48.1796f, 24.9438f, 48.2847f, 24.9438f)
                close()
                moveTo(48.2396f, 25.2501f)
                curveTo(48.0619f, 25.2501f, 47.9543f, 25.2551f, 47.9165f, 25.265f)
                lineTo(47.68f, 26.2438f)
                horizontalLineTo(47.9018f)
                curveTo(48.0044f, 26.2438f, 48.1095f, 26.2364f, 48.2171f, 26.2214f)
                curveTo(48.3247f, 26.2065f, 48.4229f, 26.1772f, 48.5115f, 26.1337f)
                curveTo(48.6003f, 26.0901f, 48.6729f, 26.0291f, 48.7292f, 25.9507f)
                curveTo(48.7855f, 25.8722f, 48.814f, 25.7683f, 48.814f, 25.6388f)
                curveTo(48.814f, 25.4994f, 48.7608f, 25.3998f, 48.6544f, 25.34f)
                curveTo(48.5481f, 25.28f, 48.4095f, 25.2501f, 48.2396f, 25.2501f)
                close()
            }
            path(fill = SolidColor(Color(0xFF4D4D4D)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(49.2169f, 27.5582f)
                lineTo(49.84f, 24.9701f)
                horizontalLineTo(51.3753f)
                lineTo(51.3037f, 25.2726f)
                horizontalLineTo(50.1287f)
                lineTo(49.941f, 26.0532f)
                horizontalLineTo(50.9846f)
                lineTo(50.913f, 26.3482f)
                horizontalLineTo(49.8732f)
                lineTo(49.652f, 27.2557f)
                horizontalLineTo(50.913f)
                lineTo(50.8413f, 27.5582f)
                horizontalLineTo(49.2169f)
                horizontalLineTo(49.2169f)
                close()
            }
            path(fill = SolidColor(Color(0xFFF7931A)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(10.0033f, 23.1189f)
                curveTo(12.7665f, 23.1189f, 15.0065f, 20.8903f, 15.0065f, 18.1412f)
                curveTo(15.0065f, 15.3921f, 12.7665f, 13.1635f, 10.0033f, 13.1635f)
                curveTo(7.24f, 13.1635f, 5.0f, 15.3921f, 5.0f, 18.1412f)
                curveTo(5.0f, 20.8903f, 7.24f, 23.1189f, 10.0033f, 23.1189f)
                close()
                moveTo(12.2093f, 17.4316f)
                curveTo(12.3087f, 16.769f, 11.8017f, 16.4129f, 11.1084f, 16.1752f)
                lineTo(11.3334f, 15.2773f)
                lineTo(10.7844f, 15.141f)
                lineTo(10.5654f, 16.0152f)
                curveTo(10.4212f, 15.9794f, 10.2729f, 15.9455f, 10.1253f, 15.9122f)
                lineTo(10.3458f, 15.0324f)
                lineTo(9.7971f, 14.896f)
                lineTo(9.5719f, 15.7936f)
                curveTo(9.4524f, 15.7665f, 9.3351f, 15.7398f, 9.2212f, 15.7114f)
                lineTo(9.2218f, 15.7086f)
                lineTo(8.4645f, 15.5207f)
                lineTo(8.3184f, 16.1042f)
                curveTo(8.3184f, 16.1042f, 8.7257f, 16.197f, 8.7172f, 16.2029f)
                curveTo(8.9397f, 16.2583f, 8.98f, 16.4045f, 8.9731f, 16.5206f)
                lineTo(8.7169f, 17.543f)
                curveTo(8.7323f, 17.5467f, 8.752f, 17.552f, 8.7742f, 17.5614f)
                curveTo(8.7557f, 17.5564f, 8.7363f, 17.5517f, 8.716f, 17.5467f)
                lineTo(8.3569f, 18.9796f)
                curveTo(8.3297f, 19.0465f, 8.2605f, 19.1474f, 8.1051f, 19.1091f)
                curveTo(8.1107f, 19.1169f, 7.7059f, 19.0101f, 7.7059f, 19.0101f)
                lineTo(7.4331f, 19.6357f)
                lineTo(8.1476f, 19.8128f)
                curveTo(8.2806f, 19.8458f, 8.411f, 19.8806f, 8.5389f, 19.9133f)
                lineTo(8.3118f, 20.8211f)
                lineTo(8.8602f, 20.9574f)
                lineTo(9.0854f, 20.0593f)
                curveTo(9.2353f, 20.0994f, 9.3807f, 20.1371f, 9.5231f, 20.1722f)
                lineTo(9.2988f, 21.0661f)
                lineTo(9.8478f, 21.2024f)
                lineTo(10.0752f, 20.2964f)
                curveTo(11.0118f, 20.4726f, 11.7159f, 20.4016f, 12.0122f, 19.5588f)
                curveTo(12.2512f, 18.88f, 12.0003f, 18.4888f, 11.5076f, 18.2336f)
                curveTo(11.8667f, 18.1514f, 12.137f, 17.9168f, 12.2093f, 17.4316f)
                close()
                moveTo(10.9545f, 19.1822f)
                curveTo(10.7847f, 19.8607f, 9.6366f, 19.4938f, 9.2644f, 19.4016f)
                lineTo(9.5659f, 18.1991f)
                curveTo(9.9382f, 18.2915f, 11.1319f, 18.4745f, 10.9545f, 19.1822f)
                close()
                moveTo(11.1244f, 17.4219f)
                curveTo(10.9696f, 18.0388f, 10.0139f, 17.7254f, 9.7039f, 17.6488f)
                lineTo(9.9773f, 16.5577f)
                curveTo(10.2873f, 16.6349f, 11.2855f, 16.7783f, 11.1244f, 17.4219f)
                close()
            }
        }
        .build()
        return _bitcoin!!
    }

private var _bitcoin: ImageVector? = null
