package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.BancontactPayconiq: ImageVector
    get() {
        if (_bancontactPayconiq != null) {
            return _bancontactPayconiq!!
        }
        _bancontactPayconiq = Builder(name = "BancontactPayconiq", defaultWidth = 58.0.dp,
                defaultHeight = 40.0.dp, viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFF005697)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(41.2048f, 21.4231f)
                horizontalLineTo(31.4056f)
                lineTo(30.409f, 22.5452f)
                lineTo(27.175f, 26.1861f)
                verticalLineTo(26.1862f)
                lineTo(26.1784f, 27.3082f)
                horizontalLineTo(16.5088f)
                lineTo(17.49f, 26.1719f)
                lineTo(17.9544f, 25.6341f)
                lineTo(18.9356f, 24.4979f)
                horizontalLineTo(14.48f)
                curveTo(13.6661f, 24.4979f, 13.0f, 25.1809f, 13.0f, 26.0155f)
                verticalLineTo(29.2177f)
                curveTo(13.0f, 30.0525f, 13.6661f, 30.7354f, 14.48f, 30.7354f)
                horizontalLineTo(31.5377f)
                curveTo(32.3517f, 30.7354f, 33.4636f, 30.2282f, 34.0087f, 29.6082f)
                lineTo(36.5889f, 26.6734f)
                lineTo(41.2048f, 21.4231f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFBD500)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(43.1736f, 18.0f)
                curveTo(43.9876f, 18.0f, 44.6536f, 18.683f, 44.6536f, 19.5177f)
                verticalLineTo(22.7198f)
                curveTo(44.6536f, 23.5544f, 43.9876f, 24.2375f, 43.1736f, 24.2375f)
                horizontalLineTo(38.7326f)
                lineTo(39.7231f, 23.1098f)
                horizontalLineTo(39.7232f)
                lineTo(40.2143f, 22.5507f)
                lineTo(41.2047f, 21.4231f)
                horizontalLineTo(31.4057f)
                lineTo(26.1785f, 27.3125f)
                horizontalLineTo(16.4489f)
                lineTo(23.4265f, 19.4228f)
                lineTo(23.6905f, 19.1242f)
                curveTo(24.2375f, 18.5059f, 25.3509f, 18.0f, 26.1649f, 18.0f)
                horizontalLineTo(43.1736f)
                verticalLineTo(18.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFF005697)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(16.3355f, 36.179f)
                curveTo(16.3355f, 35.9699f, 16.2862f, 35.7889f, 16.1877f, 35.6361f)
                curveTo(16.0891f, 35.4833f, 15.9595f, 35.3667f, 15.7987f, 35.2863f)
                curveTo(15.9595f, 35.2059f, 16.0841f, 35.0872f, 16.1727f, 34.9304f)
                curveTo(16.2611f, 34.7736f, 16.3053f, 34.5967f, 16.3053f, 34.3997f)
                verticalLineTo(34.2911f)
                curveTo(16.3053f, 34.0498f, 16.2591f, 33.8489f, 16.1667f, 33.6879f)
                curveTo(16.0741f, 33.5271f, 15.9444f, 33.3984f, 15.7775f, 33.3019f)
                curveTo(15.6107f, 33.2054f, 15.4106f, 33.1361f, 15.1775f, 33.0938f)
                curveTo(14.9441f, 33.0516f, 14.6849f, 33.0305f, 14.3993f, 33.0305f)
                curveTo(14.3029f, 33.0305f, 14.2023f, 33.0325f, 14.0978f, 33.0365f)
                curveTo(13.9931f, 33.0405f, 13.8917f, 33.0455f, 13.7932f, 33.0516f)
                curveTo(13.6947f, 33.0576f, 13.6041f, 33.0647f, 13.5218f, 33.0727f)
                curveTo(13.4393f, 33.0809f, 13.3719f, 33.0889f, 13.3197f, 33.0968f)
                curveTo(13.2031f, 33.1171f, 13.1207f, 33.1531f, 13.0725f, 33.2054f)
                curveTo(13.0242f, 33.2577f, 13.0001f, 33.3523f, 13.0001f, 33.4889f)
                verticalLineTo(37.1561f)
                curveTo(13.0001f, 37.2929f, 13.0251f, 37.3873f, 13.0755f, 37.4396f)
                curveTo(13.1257f, 37.4919f, 13.2111f, 37.528f, 13.3318f, 37.5482f)
                curveTo(13.3921f, 37.5602f, 13.4645f, 37.5702f, 13.5489f, 37.5783f)
                curveTo(13.6333f, 37.5864f, 13.7247f, 37.5934f, 13.8233f, 37.5994f)
                curveTo(13.9219f, 37.6054f, 14.0233f, 37.6104f, 14.1279f, 37.6145f)
                curveTo(14.2325f, 37.6184f, 14.3349f, 37.6206f, 14.4355f, 37.6206f)
                curveTo(14.6969f, 37.6206f, 14.9431f, 37.6004f, 15.1745f, 37.5602f)
                curveTo(15.4055f, 37.5201f, 15.6066f, 37.4486f, 15.7775f, 37.346f)
                curveTo(15.9485f, 37.2436f, 16.0841f, 37.1048f, 16.1847f, 36.9299f)
                curveTo(16.2852f, 36.755f, 16.3355f, 36.5348f, 16.3355f, 36.2694f)
                verticalLineTo(36.179f)
                close()
                moveTo(15.3101f, 34.4479f)
                curveTo(15.3101f, 34.5123f, 15.3001f, 34.5737f, 15.2799f, 34.6319f)
                curveTo(15.2598f, 34.6902f, 15.2267f, 34.7404f, 15.1805f, 34.7828f)
                curveTo(15.1341f, 34.8249f, 15.0719f, 34.8591f, 14.9935f, 34.8852f)
                curveTo(14.9151f, 34.9113f, 14.8155f, 34.9244f, 14.6949f, 34.9244f)
                horizontalLineTo(14.0194f)
                verticalLineTo(33.8809f)
                curveTo(14.0395f, 33.8809f, 14.0707f, 33.8801f, 14.1129f, 33.8779f)
                curveTo(14.1551f, 33.8759f, 14.1993f, 33.8749f, 14.2455f, 33.8749f)
                horizontalLineTo(14.4777f)
                curveTo(14.7873f, 33.8749f, 15.0035f, 33.9141f, 15.1261f, 33.9925f)
                curveTo(15.2487f, 34.0709f, 15.3101f, 34.1926f, 15.3101f, 34.3574f)
                verticalLineTo(34.4479f)
                close()
                moveTo(15.1563f, 36.6374f)
                curveTo(15.2749f, 36.5449f, 15.3343f, 36.4142f, 15.3343f, 36.2453f)
                verticalLineTo(36.179f)
                curveTo(15.3343f, 36.0342f, 15.2879f, 35.9086f, 15.1955f, 35.802f)
                curveTo(15.1029f, 35.6955f, 14.9361f, 35.6422f, 14.6949f, 35.6422f)
                horizontalLineTo(14.0194f)
                verticalLineTo(36.77f)
                horizontalLineTo(14.1249f)
                curveTo(14.1711f, 36.77f, 14.2193f, 36.7713f, 14.2697f, 36.7731f)
                curveTo(14.3199f, 36.7751f, 14.3681f, 36.7763f, 14.4145f, 36.7763f)
                horizontalLineTo(14.5139f)
                curveTo(14.8235f, 36.7763f, 15.0377f, 36.7299f, 15.1563f, 36.6374f)
                close()
                moveTo(19.6408f, 35.2923f)
                curveTo(19.6408f, 35.0713f, 19.6076f, 34.8832f, 19.5412f, 34.7284f)
                curveTo(19.4749f, 34.5737f, 19.3814f, 34.4469f, 19.2608f, 34.3484f)
                curveTo(19.1401f, 34.2499f, 18.9924f, 34.1777f, 18.8174f, 34.1313f)
                curveTo(18.6425f, 34.0851f, 18.4465f, 34.0619f, 18.2294f, 34.0619f)
                curveTo(18.0282f, 34.0619f, 17.8322f, 34.0761f, 17.6413f, 34.1043f)
                curveTo(17.4502f, 34.1323f, 17.2984f, 34.1605f, 17.1859f, 34.1885f)
                curveTo(17.1095f, 34.2088f, 17.0713f, 34.2529f, 17.0713f, 34.3212f)
                verticalLineTo(34.8098f)
                curveTo(17.0713f, 34.8501f, 17.0813f, 34.8783f, 17.1015f, 34.8942f)
                curveTo(17.1215f, 34.9103f, 17.1476f, 34.9185f, 17.1799f, 34.9185f)
                horizontalLineTo(17.21f)
                lineTo(17.391f, 34.9033f)
                curveTo(17.4633f, 34.8973f, 17.5448f, 34.8924f, 17.6353f, 34.8882f)
                curveTo(17.7257f, 34.8843f, 17.8202f, 34.8813f, 17.9187f, 34.8792f)
                curveTo(18.0172f, 34.8772f, 18.1148f, 34.8762f, 18.2113f, 34.8762f)
                curveTo(18.352f, 34.8762f, 18.4626f, 34.9023f, 18.543f, 34.9546f)
                curveTo(18.6234f, 35.0069f, 18.6636f, 35.1195f, 18.6636f, 35.2923f)
                verticalLineTo(35.5095f)
                horizontalLineTo(18.3379f)
                curveTo(17.8192f, 35.5095f, 17.4422f, 35.5909f, 17.207f, 35.7538f)
                curveTo(16.9718f, 35.9166f, 16.8541f, 36.175f, 16.8541f, 36.5288f)
                verticalLineTo(36.5833f)
                curveTo(16.8541f, 36.7801f, 16.8833f, 36.945f, 16.9416f, 37.0776f)
                curveTo(16.9998f, 37.2104f, 17.0773f, 37.317f, 17.1738f, 37.3975f)
                curveTo(17.2703f, 37.4778f, 17.3798f, 37.5351f, 17.5025f, 37.5692f)
                curveTo(17.6252f, 37.6034f, 17.7529f, 37.6206f, 17.8856f, 37.6206f)
                curveTo(18.0665f, 37.6206f, 18.2223f, 37.5964f, 18.353f, 37.5482f)
                curveTo(18.4836f, 37.4999f, 18.6072f, 37.4336f, 18.724f, 37.3491f)
                verticalLineTo(37.4456f)
                curveTo(18.724f, 37.4778f, 18.736f, 37.506f, 18.7601f, 37.53f)
                curveTo(18.7843f, 37.5542f, 18.8124f, 37.5662f, 18.8446f, 37.5662f)
                horizontalLineTo(19.5201f)
                curveTo(19.5522f, 37.5662f, 19.5804f, 37.5542f, 19.6046f, 37.53f)
                curveTo(19.6287f, 37.506f, 19.6408f, 37.4778f, 19.6408f, 37.4456f)
                verticalLineTo(35.2923f)
                close()
                moveTo(18.4495f, 36.8454f)
                curveTo(18.5318f, 36.8193f, 18.6094f, 36.7882f, 18.6817f, 36.752f)
                verticalLineTo(36.0885f)
                horizontalLineTo(18.3379f)
                curveTo(18.2334f, 36.0885f, 18.1469f, 36.0976f, 18.0786f, 36.1156f)
                curveTo(18.0102f, 36.1338f, 17.9558f, 36.1609f, 17.9157f, 36.1971f)
                curveTo(17.8755f, 36.2332f, 17.8474f, 36.2795f, 17.8313f, 36.3358f)
                curveTo(17.8152f, 36.3921f, 17.8071f, 36.4564f, 17.8071f, 36.5288f)
                verticalLineTo(36.5833f)
                curveTo(17.8071f, 36.7118f, 17.8382f, 36.7942f, 17.9006f, 36.8304f)
                curveTo(17.963f, 36.8666f, 18.0584f, 36.8846f, 18.1871f, 36.8846f)
                curveTo(18.2796f, 36.8846f, 18.367f, 36.8717f, 18.4495f, 36.8454f)
                close()
                moveTo(23.332f, 37.4396f)
                verticalLineTo(35.431f)
                curveTo(23.332f, 35.2422f, 23.317f, 35.0641f, 23.2868f, 34.8973f)
                curveTo(23.2566f, 34.7306f, 23.2024f, 34.5857f, 23.124f, 34.463f)
                curveTo(23.0456f, 34.3403f, 22.937f, 34.2428f, 22.7982f, 34.1705f)
                curveTo(22.6596f, 34.0981f, 22.4816f, 34.0619f, 22.2644f, 34.0619f)
                curveTo(22.0714f, 34.0619f, 21.9005f, 34.0852f, 21.7518f, 34.1318f)
                curveTo(21.603f, 34.1784f, 21.4462f, 34.2604f, 21.2814f, 34.3779f)
                verticalLineTo(34.2318f)
                curveTo(21.2814f, 34.1994f, 21.2692f, 34.171f, 21.2452f, 34.1467f)
                curveTo(21.221f, 34.1224f, 21.1928f, 34.1101f, 21.1606f, 34.1101f)
                horizontalLineTo(20.4852f)
                curveTo(20.4529f, 34.1101f, 20.4248f, 34.1222f, 20.4008f, 34.1463f)
                curveTo(20.3766f, 34.1705f, 20.3646f, 34.1987f, 20.3646f, 34.2308f)
                verticalLineTo(37.4396f)
                curveTo(20.3646f, 37.4718f, 20.3775f, 37.5009f, 20.4038f, 37.527f)
                curveTo(20.4298f, 37.5532f, 20.459f, 37.5662f, 20.4912f, 37.5662f)
                horizontalLineTo(21.221f)
                curveTo(21.2532f, 37.5662f, 21.2814f, 37.5532f, 21.3054f, 37.5271f)
                curveTo(21.3296f, 37.5011f, 21.3416f, 37.472f, 21.3416f, 37.4398f)
                verticalLineTo(35.0687f)
                curveTo(21.4462f, 35.0125f, 21.5446f, 34.9665f, 21.6372f, 34.9304f)
                curveTo(21.7296f, 34.8942f, 21.82f, 34.8762f, 21.9086f, 34.8762f)
                curveTo(22.001f, 34.8762f, 22.0764f, 34.8852f, 22.1348f, 34.9033f)
                curveTo(22.193f, 34.9214f, 22.2382f, 34.9524f, 22.2704f, 34.9968f)
                curveTo(22.3026f, 35.0407f, 22.3248f, 35.0988f, 22.3368f, 35.171f)
                curveTo(22.3488f, 35.2432f, 22.355f, 35.3315f, 22.355f, 35.4359f)
                verticalLineTo(37.4398f)
                curveTo(22.355f, 37.472f, 22.367f, 37.5011f, 22.3912f, 37.5271f)
                curveTo(22.4152f, 37.5532f, 22.4433f, 37.5662f, 22.4756f, 37.5662f)
                horizontalLineTo(23.2054f)
                curveTo(23.2375f, 37.5662f, 23.2666f, 37.5532f, 23.2928f, 37.527f)
                curveTo(23.319f, 37.5009f, 23.332f, 37.4718f, 23.332f, 37.4396f)
                close()
                moveTo(26.2996f, 36.8547f)
                verticalLineTo(37.3914f)
                curveTo(26.2996f, 37.4356f, 26.2895f, 37.4667f, 26.2694f, 37.4848f)
                curveTo(26.2493f, 37.5029f, 26.2171f, 37.518f, 26.1729f, 37.53f)
                curveTo(26.0884f, 37.5502f, 25.9789f, 37.5702f, 25.8442f, 37.5905f)
                curveTo(25.7094f, 37.6104f, 25.5516f, 37.6206f, 25.3707f, 37.6206f)
                curveTo(24.9444f, 37.6206f, 24.6036f, 37.4899f, 24.3484f, 37.2284f)
                curveTo(24.093f, 36.9671f, 23.9654f, 36.5891f, 23.9654f, 36.0945f)
                verticalLineTo(35.5879f)
                curveTo(23.9654f, 35.0933f, 24.093f, 34.7153f, 24.3484f, 34.4541f)
                curveTo(24.6036f, 34.1926f, 24.9444f, 34.0619f, 25.3707f, 34.0619f)
                curveTo(25.5516f, 34.0619f, 25.7094f, 34.0719f, 25.8442f, 34.092f)
                curveTo(25.9789f, 34.1123f, 26.0884f, 34.1323f, 26.1729f, 34.1524f)
                curveTo(26.2171f, 34.1644f, 26.2493f, 34.1795f, 26.2694f, 34.1976f)
                curveTo(26.2895f, 34.2157f, 26.2996f, 34.2469f, 26.2996f, 34.2911f)
                verticalLineTo(34.8279f)
                curveTo(26.2996f, 34.8601f, 26.2885f, 34.8852f, 26.2664f, 34.9033f)
                curveTo(26.2443f, 34.9214f, 26.2171f, 34.9304f, 26.185f, 34.9304f)
                horizontalLineTo(26.1729f)
                curveTo(26.0603f, 34.9185f, 25.9528f, 34.9083f, 25.8502f, 34.9003f)
                curveTo(25.7477f, 34.8924f, 25.6099f, 34.8882f, 25.437f, 34.8882f)
                curveTo(25.3687f, 34.8882f, 25.3044f, 34.8993f, 25.244f, 34.9214f)
                curveTo(25.1837f, 34.9435f, 25.1314f, 34.9817f, 25.0872f, 35.036f)
                curveTo(25.0429f, 35.0903f, 25.0078f, 35.1626f, 24.9816f, 35.2531f)
                curveTo(24.9555f, 35.3436f, 24.9424f, 35.4552f, 24.9424f, 35.5879f)
                verticalLineTo(36.0945f)
                curveTo(24.9424f, 36.2272f, 24.9555f, 36.3388f, 24.9816f, 36.4293f)
                curveTo(25.0078f, 36.5198f, 25.0429f, 36.5922f, 25.0872f, 36.6464f)
                curveTo(25.1314f, 36.7007f, 25.1837f, 36.7389f, 25.244f, 36.761f)
                curveTo(25.3044f, 36.7832f, 25.3687f, 36.7942f, 25.437f, 36.7942f)
                curveTo(25.6099f, 36.7942f, 25.7477f, 36.7902f, 25.8502f, 36.7822f)
                curveTo(25.9528f, 36.7741f, 26.0603f, 36.764f, 26.1729f, 36.752f)
                horizontalLineTo(26.185f)
                curveTo(26.2171f, 36.752f, 26.2443f, 36.761f, 26.2664f, 36.7791f)
                curveTo(26.2885f, 36.7973f, 26.2996f, 36.8224f, 26.2996f, 36.8547f)
                close()
                moveTo(29.6472f, 35.6301f)
                curveTo(29.6472f, 35.3888f, 29.6139f, 35.1717f, 29.5474f, 34.9787f)
                curveTo(29.4809f, 34.7857f, 29.3842f, 34.6219f, 29.2573f, 34.4871f)
                curveTo(29.1304f, 34.3525f, 28.9732f, 34.2479f, 28.786f, 34.1735f)
                curveTo(28.5986f, 34.0992f, 28.382f, 34.0619f, 28.1362f, 34.0619f)
                curveTo(27.8905f, 34.0619f, 27.6739f, 34.0992f, 27.4866f, 34.1735f)
                curveTo(27.2992f, 34.2479f, 27.141f, 34.3525f, 27.0121f, 34.4871f)
                curveTo(26.8831f, 34.6219f, 26.7854f, 34.7857f, 26.7191f, 34.9787f)
                curveTo(26.6524f, 35.1717f, 26.6192f, 35.3888f, 26.6192f, 35.6301f)
                verticalLineTo(36.0523f)
                curveTo(26.6192f, 36.2936f, 26.6524f, 36.5107f, 26.7191f, 36.7037f)
                curveTo(26.7854f, 36.8968f, 26.8831f, 37.0606f, 27.0121f, 37.1953f)
                curveTo(27.141f, 37.3301f, 27.2992f, 37.4346f, 27.4866f, 37.509f)
                curveTo(27.6739f, 37.5832f, 27.8905f, 37.6206f, 28.1362f, 37.6206f)
                curveTo(28.382f, 37.6206f, 28.5986f, 37.5832f, 28.786f, 37.509f)
                curveTo(28.9732f, 37.4346f, 29.1304f, 37.3301f, 29.2573f, 37.1953f)
                curveTo(29.3842f, 37.0606f, 29.4809f, 36.8968f, 29.5474f, 36.7037f)
                curveTo(29.6139f, 36.5107f, 29.6472f, 36.2936f, 29.6472f, 36.0523f)
                verticalLineTo(35.6301f)
                close()
                moveTo(28.1362f, 36.7942f)
                curveTo(28.4921f, 36.7942f, 28.67f, 36.5469f, 28.67f, 36.0523f)
                verticalLineTo(35.6301f)
                curveTo(28.67f, 35.1395f, 28.4921f, 34.8942f, 28.1362f, 34.8942f)
                curveTo(27.9603f, 34.8942f, 27.8264f, 34.9556f, 27.7344f, 35.0782f)
                curveTo(27.6424f, 35.2009f, 27.5964f, 35.3849f, 27.5964f, 35.6301f)
                verticalLineTo(36.0523f)
                curveTo(27.5964f, 36.2976f, 27.6424f, 36.4826f, 27.7344f, 36.6072f)
                curveTo(27.8264f, 36.7319f, 27.9603f, 36.7942f, 28.1362f, 36.7942f)
                close()
                moveTo(33.2359f, 37.4396f)
                verticalLineTo(35.431f)
                curveTo(33.2359f, 35.2422f, 33.2206f, 35.0641f, 33.1907f, 34.8973f)
                curveTo(33.1605f, 34.7306f, 33.1061f, 34.5857f, 33.0276f, 34.463f)
                curveTo(32.9492f, 34.3403f, 32.8407f, 34.2428f, 32.7021f, 34.1705f)
                curveTo(32.5633f, 34.0981f, 32.3853f, 34.0619f, 32.1683f, 34.0619f)
                curveTo(31.9753f, 34.0619f, 31.8043f, 34.0852f, 31.6555f, 34.1318f)
                curveTo(31.5067f, 34.1784f, 31.3499f, 34.2604f, 31.1851f, 34.3779f)
                verticalLineTo(34.2318f)
                curveTo(31.1851f, 34.1994f, 31.1731f, 34.171f, 31.1488f, 34.1467f)
                curveTo(31.1249f, 34.1224f, 31.0966f, 34.1101f, 31.0645f, 34.1101f)
                horizontalLineTo(30.3889f)
                curveTo(30.3567f, 34.1101f, 30.3287f, 34.1222f, 30.3045f, 34.1463f)
                curveTo(30.2804f, 34.1705f, 30.2683f, 34.1987f, 30.2683f, 34.2308f)
                verticalLineTo(37.4396f)
                curveTo(30.2683f, 37.4718f, 30.2813f, 37.5009f, 30.3075f, 37.527f)
                curveTo(30.3337f, 37.5532f, 30.3627f, 37.5662f, 30.395f, 37.5662f)
                horizontalLineTo(31.1249f)
                curveTo(31.1569f, 37.5662f, 31.1851f, 37.5532f, 31.2093f, 37.5271f)
                curveTo(31.2333f, 37.5011f, 31.2455f, 37.472f, 31.2455f, 37.4398f)
                verticalLineTo(35.0687f)
                curveTo(31.3499f, 35.0125f, 31.4485f, 34.9665f, 31.5409f, 34.9304f)
                curveTo(31.6335f, 34.8942f, 31.7239f, 34.8762f, 31.8125f, 34.8762f)
                curveTo(31.9049f, 34.8762f, 31.9803f, 34.8852f, 32.0385f, 34.9033f)
                curveTo(32.0968f, 34.9214f, 32.1421f, 34.9524f, 32.1743f, 34.9968f)
                curveTo(32.2065f, 35.0407f, 32.2285f, 35.0988f, 32.2407f, 35.171f)
                curveTo(32.2527f, 35.2432f, 32.2587f, 35.3315f, 32.2587f, 35.4359f)
                verticalLineTo(37.4398f)
                curveTo(32.2587f, 37.472f, 32.2707f, 37.5011f, 32.2949f, 37.5271f)
                curveTo(32.3191f, 37.5532f, 32.3471f, 37.5662f, 32.3793f, 37.5662f)
                horizontalLineTo(33.1091f)
                curveTo(33.1413f, 37.5662f, 33.1705f, 37.5532f, 33.1967f, 37.527f)
                curveTo(33.2227f, 37.5009f, 33.2359f, 37.4718f, 33.2359f, 37.4396f)
                close()
                moveTo(35.8657f, 36.9863f)
                verticalLineTo(37.4531f)
                curveTo(35.8657f, 37.5209f, 35.8275f, 37.5608f, 35.7511f, 37.5726f)
                curveTo(35.6585f, 37.5886f, 35.5781f, 37.6005f, 35.5099f, 37.6085f)
                curveTo(35.4415f, 37.6165f, 35.3629f, 37.6206f, 35.2747f, 37.6206f)
                curveTo(35.1106f, 37.6206f, 34.9657f, 37.6074f, 34.8398f, 37.5813f)
                curveTo(34.7139f, 37.5552f, 34.6088f, 37.5039f, 34.5249f, 37.4275f)
                curveTo(34.4411f, 37.3511f, 34.3771f, 37.2456f, 34.3332f, 37.1108f)
                curveTo(34.2893f, 36.9762f, 34.2673f, 36.8024f, 34.2673f, 36.5891f)
                verticalLineTo(34.8401f)
                lineTo(33.7848f, 34.7615f)
                curveTo(33.7525f, 34.7535f, 33.7235f, 34.7385f, 33.6973f, 34.7163f)
                curveTo(33.6711f, 34.6943f, 33.6581f, 34.6671f, 33.6581f, 34.6349f)
                verticalLineTo(34.2368f)
                curveTo(33.6581f, 34.2047f, 33.6711f, 34.1755f, 33.6973f, 34.1493f)
                curveTo(33.7235f, 34.1233f, 33.7525f, 34.1101f, 33.7848f, 34.1101f)
                horizontalLineTo(34.2673f)
                verticalLineTo(33.6155f)
                curveTo(34.2673f, 33.5834f, 34.2793f, 33.5573f, 34.3032f, 33.5371f)
                curveTo(34.327f, 33.5171f, 34.3552f, 33.5031f, 34.3873f, 33.4949f)
                lineTo(35.1186f, 33.3684f)
                horizontalLineTo(35.1365f)
                curveTo(35.1684f, 33.3684f, 35.1945f, 33.3773f, 35.2145f, 33.3954f)
                curveTo(35.2344f, 33.4135f, 35.2445f, 33.4387f, 35.2445f, 33.4708f)
                verticalLineTo(34.1101f)
                horizontalLineTo(35.7391f)
                curveTo(35.7711f, 34.1101f, 35.7993f, 34.1223f, 35.8235f, 34.1466f)
                curveTo(35.8477f, 34.1709f, 35.8597f, 34.1994f, 35.8597f, 34.2318f)
                verticalLineTo(34.7244f)
                curveTo(35.8597f, 34.7569f, 35.8477f, 34.7852f, 35.8235f, 34.8095f)
                curveTo(35.7993f, 34.8338f, 35.7711f, 34.846f, 35.7391f, 34.846f)
                horizontalLineTo(35.2445f)
                verticalLineTo(36.6012f)
                curveTo(35.2445f, 36.7218f, 35.2545f, 36.7993f, 35.2747f, 36.8334f)
                curveTo(35.2947f, 36.8676f, 35.3509f, 36.8846f, 35.4434f, 36.8846f)
                horizontalLineTo(35.7391f)
                curveTo(35.8235f, 36.8846f, 35.8657f, 36.9185f, 35.8657f, 36.9863f)
                close()
                moveTo(39.0864f, 35.2923f)
                curveTo(39.0864f, 35.0713f, 39.0533f, 34.8832f, 38.9868f, 34.7284f)
                curveTo(38.9206f, 34.5737f, 38.8271f, 34.4469f, 38.7065f, 34.3484f)
                curveTo(38.5859f, 34.2499f, 38.4381f, 34.1777f, 38.2632f, 34.1313f)
                curveTo(38.0883f, 34.0851f, 37.8923f, 34.0619f, 37.6751f, 34.0619f)
                curveTo(37.4739f, 34.0619f, 37.278f, 34.0761f, 37.0871f, 34.1043f)
                curveTo(36.896f, 34.1323f, 36.7442f, 34.1605f, 36.6317f, 34.1885f)
                curveTo(36.555f, 34.2088f, 36.5171f, 34.2529f, 36.5171f, 34.3212f)
                verticalLineTo(34.8098f)
                curveTo(36.5171f, 34.8501f, 36.527f, 34.8783f, 36.5472f, 34.8942f)
                curveTo(36.5673f, 34.9103f, 36.5934f, 34.9185f, 36.6256f, 34.9185f)
                horizontalLineTo(36.6557f)
                lineTo(36.8367f, 34.9033f)
                curveTo(36.9091f, 34.8973f, 36.9905f, 34.8924f, 37.081f, 34.8882f)
                curveTo(37.1715f, 34.8843f, 37.2659f, 34.8813f, 37.3645f, 34.8792f)
                curveTo(37.463f, 34.8772f, 37.5605f, 34.8762f, 37.657f, 34.8762f)
                curveTo(37.7977f, 34.8762f, 37.9083f, 34.9023f, 37.9887f, 34.9546f)
                curveTo(38.0692f, 35.0069f, 38.1094f, 35.1195f, 38.1094f, 35.2923f)
                verticalLineTo(35.5095f)
                horizontalLineTo(37.7837f)
                curveTo(37.2648f, 35.5095f, 36.888f, 35.5909f, 36.6527f, 35.7538f)
                curveTo(36.4175f, 35.9166f, 36.2999f, 36.175f, 36.2999f, 36.5288f)
                verticalLineTo(36.5833f)
                curveTo(36.2999f, 36.7801f, 36.329f, 36.945f, 36.3873f, 37.0776f)
                curveTo(36.4455f, 37.2104f, 36.5231f, 37.317f, 36.6195f, 37.3975f)
                curveTo(36.7161f, 37.4778f, 36.8256f, 37.5351f, 36.9483f, 37.5692f)
                curveTo(37.0709f, 37.6034f, 37.1986f, 37.6206f, 37.3313f, 37.6206f)
                curveTo(37.5123f, 37.6206f, 37.668f, 37.5964f, 37.7987f, 37.5482f)
                curveTo(37.9294f, 37.4999f, 38.0529f, 37.4336f, 38.1697f, 37.3491f)
                verticalLineTo(37.4456f)
                curveTo(38.1697f, 37.4778f, 38.1817f, 37.506f, 38.2059f, 37.53f)
                curveTo(38.23f, 37.5542f, 38.2581f, 37.5662f, 38.2903f, 37.5662f)
                horizontalLineTo(38.9659f)
                curveTo(38.998f, 37.5662f, 39.0262f, 37.5542f, 39.0503f, 37.53f)
                curveTo(39.0744f, 37.506f, 39.0864f, 37.4778f, 39.0864f, 37.4456f)
                verticalLineTo(35.2923f)
                close()
                moveTo(37.8953f, 36.8454f)
                curveTo(37.9776f, 36.8193f, 38.0551f, 36.7882f, 38.1275f, 36.752f)
                verticalLineTo(36.0885f)
                horizontalLineTo(37.7837f)
                curveTo(37.6791f, 36.0885f, 37.5927f, 36.0976f, 37.5243f, 36.1156f)
                curveTo(37.4559f, 36.1338f, 37.4016f, 36.1609f, 37.3615f, 36.1971f)
                curveTo(37.3212f, 36.2332f, 37.293f, 36.2795f, 37.2771f, 36.3358f)
                curveTo(37.2609f, 36.3921f, 37.2529f, 36.4564f, 37.2529f, 36.5288f)
                verticalLineTo(36.5833f)
                curveTo(37.2529f, 36.7118f, 37.284f, 36.7942f, 37.3464f, 36.8304f)
                curveTo(37.4087f, 36.8666f, 37.5042f, 36.8846f, 37.6329f, 36.8846f)
                curveTo(37.7253f, 36.8846f, 37.8126f, 36.8717f, 37.8953f, 36.8454f)
                close()
                moveTo(42.054f, 37.3914f)
                verticalLineTo(36.8547f)
                curveTo(42.054f, 36.8224f, 42.0428f, 36.7973f, 42.0208f, 36.7791f)
                curveTo(41.9986f, 36.761f, 41.9716f, 36.752f, 41.9394f, 36.752f)
                horizontalLineTo(41.9274f)
                curveTo(41.8148f, 36.764f, 41.7072f, 36.7741f, 41.6046f, 36.7822f)
                curveTo(41.5022f, 36.7902f, 41.3644f, 36.7942f, 41.1915f, 36.7942f)
                curveTo(41.123f, 36.7942f, 41.0587f, 36.7832f, 40.9985f, 36.761f)
                curveTo(40.9382f, 36.7389f, 40.8858f, 36.7007f, 40.8416f, 36.6464f)
                curveTo(40.7974f, 36.5922f, 40.7622f, 36.5198f, 40.7361f, 36.4293f)
                curveTo(40.7098f, 36.3388f, 40.6969f, 36.2272f, 40.6969f, 36.0945f)
                verticalLineTo(35.5879f)
                curveTo(40.6969f, 35.4552f, 40.7098f, 35.3436f, 40.7361f, 35.2531f)
                curveTo(40.7622f, 35.1626f, 40.7974f, 35.0903f, 40.8416f, 35.036f)
                curveTo(40.8858f, 34.9817f, 40.9382f, 34.9435f, 40.9985f, 34.9214f)
                curveTo(41.0587f, 34.8993f, 41.123f, 34.8882f, 41.1915f, 34.8882f)
                curveTo(41.3644f, 34.8882f, 41.5022f, 34.8924f, 41.6046f, 34.9003f)
                curveTo(41.7072f, 34.9083f, 41.8148f, 34.9185f, 41.9274f, 34.9304f)
                horizontalLineTo(41.9394f)
                curveTo(41.9716f, 34.9304f, 41.9986f, 34.9214f, 42.0208f, 34.9033f)
                curveTo(42.0428f, 34.8852f, 42.054f, 34.8601f, 42.054f, 34.8279f)
                verticalLineTo(34.2911f)
                curveTo(42.054f, 34.2469f, 42.044f, 34.2157f, 42.0238f, 34.1976f)
                curveTo(42.0035f, 34.1795f, 41.9716f, 34.1644f, 41.9274f, 34.1524f)
                curveTo(41.843f, 34.1323f, 41.7332f, 34.1123f, 41.5986f, 34.092f)
                curveTo(41.4638f, 34.0719f, 41.3061f, 34.0619f, 41.1252f, 34.0619f)
                curveTo(40.6987f, 34.0619f, 40.3582f, 34.1926f, 40.1028f, 34.4541f)
                curveTo(39.8474f, 34.7153f, 39.7198f, 35.0933f, 39.7198f, 35.5879f)
                verticalLineTo(36.0945f)
                curveTo(39.7198f, 36.5891f, 39.8474f, 36.9671f, 40.1028f, 37.2284f)
                curveTo(40.3582f, 37.4899f, 40.6987f, 37.6206f, 41.1252f, 37.6206f)
                curveTo(41.3061f, 37.6206f, 41.4638f, 37.6104f, 41.5986f, 37.5905f)
                curveTo(41.7332f, 37.5702f, 41.843f, 37.5502f, 41.9274f, 37.53f)
                curveTo(41.9716f, 37.518f, 42.0035f, 37.5029f, 42.0238f, 37.4848f)
                curveTo(42.044f, 37.4667f, 42.054f, 37.4356f, 42.054f, 37.3914f)
                close()
                moveTo(44.6536f, 36.9863f)
                verticalLineTo(37.4531f)
                curveTo(44.6536f, 37.5209f, 44.6153f, 37.5608f, 44.539f, 37.5726f)
                curveTo(44.4465f, 37.5886f, 44.366f, 37.6005f, 44.2978f, 37.6085f)
                curveTo(44.2293f, 37.6165f, 44.1509f, 37.6206f, 44.0626f, 37.6206f)
                curveTo(43.8985f, 37.6206f, 43.7536f, 37.6074f, 43.6277f, 37.5813f)
                curveTo(43.5017f, 37.5552f, 43.3968f, 37.5039f, 43.313f, 37.4275f)
                curveTo(43.2291f, 37.3511f, 43.1651f, 37.2456f, 43.1211f, 37.1108f)
                curveTo(43.0773f, 36.9762f, 43.0552f, 36.8024f, 43.0552f, 36.5891f)
                verticalLineTo(34.8401f)
                lineTo(42.5728f, 34.7615f)
                curveTo(42.5405f, 34.7535f, 42.5114f, 34.7385f, 42.4852f, 34.7163f)
                curveTo(42.459f, 34.6943f, 42.446f, 34.6671f, 42.446f, 34.6349f)
                verticalLineTo(34.2368f)
                curveTo(42.446f, 34.2047f, 42.459f, 34.1755f, 42.4852f, 34.1493f)
                curveTo(42.5114f, 34.1233f, 42.5405f, 34.1101f, 42.5728f, 34.1101f)
                horizontalLineTo(43.0552f)
                verticalLineTo(33.6155f)
                curveTo(43.0552f, 33.5834f, 43.0672f, 33.5573f, 43.0912f, 33.5371f)
                curveTo(43.115f, 33.5171f, 43.143f, 33.5031f, 43.1751f, 33.4949f)
                lineTo(43.9064f, 33.3684f)
                horizontalLineTo(43.9244f)
                curveTo(43.9564f, 33.3684f, 43.9824f, 33.3773f, 44.0022f, 33.3954f)
                curveTo(44.0224f, 33.4135f, 44.0324f, 33.4387f, 44.0324f, 33.4708f)
                verticalLineTo(34.1101f)
                horizontalLineTo(44.527f)
                curveTo(44.559f, 34.1101f, 44.5872f, 34.1223f, 44.6114f, 34.1466f)
                curveTo(44.6354f, 34.1709f, 44.6476f, 34.1994f, 44.6476f, 34.2318f)
                verticalLineTo(34.7244f)
                curveTo(44.6476f, 34.7569f, 44.6354f, 34.7852f, 44.6114f, 34.8095f)
                curveTo(44.5872f, 34.8338f, 44.559f, 34.846f, 44.527f, 34.846f)
                horizontalLineTo(44.0324f)
                verticalLineTo(36.6012f)
                curveTo(44.0324f, 36.7218f, 44.0424f, 36.7993f, 44.0626f, 36.8334f)
                curveTo(44.0826f, 36.8676f, 44.1388f, 36.8846f, 44.2314f, 36.8846f)
                horizontalLineTo(44.527f)
                curveTo(44.6114f, 36.8846f, 44.6536f, 36.9185f, 44.6536f, 36.9863f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFF4785)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(1.0f, 4.0f)
                curveTo(1.0f, 2.3431f, 2.3431f, 1.0f, 4.0f, 1.0f)
                horizontalLineTo(54.0f)
                curveTo(55.6569f, 1.0f, 57.0f, 2.3431f, 57.0f, 4.0f)
                verticalLineTo(16.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(4.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(41.8752f, 7.8031f)
                curveTo(41.8749f, 8.2469f, 42.2447f, 8.6071f, 42.7013f, 8.6075f)
                curveTo(43.1579f, 8.6079f, 43.5284f, 8.2484f, 43.5289f, 7.8044f)
                curveTo(43.5292f, 7.3606f, 43.1594f, 7.0004f, 42.7028f, 7.0f)
                curveTo(42.2462f, 6.9996f, 41.8757f, 7.3592f, 41.8752f, 7.8031f)
                close()
                moveTo(43.4131f, 9.1197f)
                horizontalLineTo(41.9945f)
                verticalLineTo(13.8914f)
                horizontalLineTo(43.4131f)
                verticalLineTo(9.1197f)
                close()
                moveTo(33.3894f, 13.9074f)
                curveTo(32.0247f, 13.9074f, 30.9145f, 12.8281f, 30.9145f, 11.5014f)
                curveTo(30.9145f, 10.6034f, 31.4232f, 9.7861f, 32.2425f, 9.3691f)
                curveTo(32.2622f, 9.359f, 32.2823f, 9.35f, 32.3025f, 9.3419f)
                curveTo(32.6349f, 9.1832f, 33.0055f, 9.0954f, 33.3895f, 9.0954f)
                curveTo(34.7542f, 9.0954f, 35.8643f, 10.1747f, 35.8643f, 11.5014f)
                curveTo(35.8643f, 12.4928f, 35.2522f, 13.3705f, 34.305f, 13.7374f)
                curveTo(34.2918f, 13.7425f, 34.2786f, 13.7472f, 34.2654f, 13.7514f)
                curveTo(33.9901f, 13.8529f, 33.6941f, 13.9074f, 33.3894f, 13.9074f)
                close()
                moveTo(32.3329f, 11.5014f)
                curveTo(32.3329f, 11.3803f, 32.3546f, 11.2627f, 32.3953f, 11.1527f)
                lineTo(32.3996f, 11.1419f)
                curveTo(32.5528f, 10.7426f, 32.9506f, 10.4744f, 33.3895f, 10.4744f)
                curveTo(33.9719f, 10.4744f, 34.446f, 10.9352f, 34.446f, 11.5014f)
                curveTo(34.446f, 11.643f, 34.4168f, 11.7791f, 34.3628f, 11.9035f)
                lineTo(34.3555f, 11.9188f)
                curveTo(34.1857f, 12.2891f, 33.8066f, 12.5285f, 33.3894f, 12.5285f)
                curveTo(32.8069f, 12.5285f, 32.3329f, 12.0677f, 32.3329f, 11.5014f)
                close()
                moveTo(28.4378f, 13.9074f)
                curveTo(27.0731f, 13.9074f, 25.9628f, 12.8281f, 25.9628f, 11.5014f)
                curveTo(25.9628f, 10.1747f, 27.0731f, 9.0954f, 28.4378f, 9.0954f)
                curveTo(29.2721f, 9.0954f, 30.0448f, 9.5007f, 30.5048f, 10.1794f)
                lineTo(29.3202f, 10.938f)
                curveTo(29.1234f, 10.6477f, 28.7935f, 10.4743f, 28.4378f, 10.4743f)
                curveTo(27.8553f, 10.4743f, 27.3812f, 10.9352f, 27.3812f, 11.5014f)
                curveTo(27.3812f, 12.0677f, 27.8553f, 12.5285f, 28.4378f, 12.5285f)
                curveTo(28.7906f, 12.5285f, 29.1189f, 12.3581f, 29.316f, 12.0721f)
                lineTo(30.4942f, 12.8402f)
                curveTo(30.0331f, 13.5086f, 29.2644f, 13.9074f, 28.4378f, 13.9074f)
                close()
                moveTo(11.4185f, 14.9851f)
                horizontalLineTo(10.0f)
                verticalLineTo(9.1288f)
                horizontalLineTo(11.4185f)
                verticalLineTo(9.336f)
                curveTo(11.7446f, 9.1819f, 12.1105f, 9.0954f, 12.4969f, 9.0954f)
                curveTo(13.8615f, 9.0954f, 14.9717f, 10.1747f, 14.9717f, 11.5014f)
                curveTo(14.9717f, 12.8281f, 13.8615f, 13.9074f, 12.4969f, 13.9074f)
                curveTo(12.1105f, 13.9074f, 11.7446f, 13.8209f, 11.4185f, 13.6668f)
                verticalLineTo(14.9851f)
                close()
                moveTo(49.0f, 14.9851f)
                horizontalLineTo(47.5815f)
                verticalLineTo(13.672f)
                curveTo(47.2582f, 13.8229f, 46.8961f, 13.9074f, 46.5142f, 13.9074f)
                curveTo(45.1495f, 13.9074f, 44.0393f, 12.8281f, 44.0393f, 11.5014f)
                curveTo(44.0393f, 10.1747f, 45.1495f, 9.0954f, 46.5142f, 9.0954f)
                curveTo(46.8961f, 9.0954f, 47.2582f, 9.18f, 47.5815f, 9.3308f)
                verticalLineTo(9.1288f)
                horizontalLineTo(49.0f)
                verticalLineTo(14.9851f)
                close()
                moveTo(36.4789f, 13.8914f)
                horizontalLineTo(37.8974f)
                verticalLineTo(11.2516f)
                curveTo(37.9785f, 10.536f, 38.7053f, 10.5142f, 38.7924f, 10.5142f)
                curveTo(39.0297f, 10.5142f, 39.2445f, 10.5893f, 39.3971f, 10.7256f)
                curveTo(39.5712f, 10.8809f, 39.6593f, 11.1134f, 39.6593f, 11.4163f)
                verticalLineTo(13.8601f)
                horizontalLineTo(41.0777f)
                verticalLineTo(11.4163f)
                curveTo(41.0777f, 9.9189f, 39.928f, 9.1353f, 38.7924f, 9.1353f)
                curveTo(38.491f, 9.1353f, 38.1846f, 9.1919f, 37.8974f, 9.3029f)
                verticalLineTo(9.1288f)
                horizontalLineTo(36.4789f)
                verticalLineTo(11.1926f)
                curveTo(36.4741f, 11.2559f, 36.4717f, 11.3205f, 36.4717f, 11.3865f)
                horizontalLineTo(36.4789f)
                verticalLineTo(13.8914f)
                close()
                moveTo(20.3472f, 13.8914f)
                horizontalLineTo(18.9287f)
                verticalLineTo(13.6806f)
                curveTo(18.6101f, 13.8261f, 18.2546f, 13.9074f, 17.88f, 13.9074f)
                curveTo(16.5153f, 13.9074f, 15.405f, 12.8281f, 15.405f, 11.5014f)
                curveTo(15.405f, 10.1747f, 16.5153f, 9.0954f, 17.88f, 9.0954f)
                curveTo(18.2546f, 9.0954f, 18.6101f, 9.1768f, 18.9287f, 9.3222f)
                verticalLineTo(9.1288f)
                horizontalLineTo(20.3472f)
                verticalLineTo(11.311f)
                curveTo(20.3523f, 11.3739f, 20.3549f, 11.4374f, 20.3549f, 11.5014f)
                curveTo(20.3549f, 11.5655f, 20.3523f, 11.629f, 20.3472f, 11.6918f)
                verticalLineTo(13.8914f)
                close()
                moveTo(18.9287f, 11.6268f)
                verticalLineTo(11.376f)
                curveTo(18.8648f, 10.8687f, 18.4188f, 10.4744f, 17.88f, 10.4744f)
                curveTo(17.2975f, 10.4744f, 16.8234f, 10.9352f, 16.8234f, 11.5014f)
                curveTo(16.8234f, 12.0677f, 17.2975f, 12.5285f, 17.88f, 12.5285f)
                curveTo(18.4188f, 12.5285f, 18.8648f, 12.1342f, 18.9287f, 11.6268f)
                close()
                moveTo(12.4969f, 10.4744f)
                curveTo(11.9144f, 10.4744f, 11.4403f, 10.9352f, 11.4403f, 11.5014f)
                curveTo(11.4403f, 12.0677f, 11.9144f, 12.5285f, 12.4969f, 12.5285f)
                curveTo(13.0793f, 12.5285f, 13.5534f, 12.0677f, 13.5534f, 11.5014f)
                curveTo(13.5534f, 10.9352f, 13.0793f, 10.4744f, 12.4969f, 10.4744f)
                close()
                moveTo(45.4577f, 11.5014f)
                curveTo(45.4577f, 10.9352f, 45.9317f, 10.4744f, 46.5142f, 10.4744f)
                curveTo(47.0967f, 10.4744f, 47.5707f, 10.9352f, 47.5707f, 11.5014f)
                curveTo(47.5707f, 12.0677f, 47.0967f, 12.5285f, 46.5142f, 12.5285f)
                curveTo(45.9317f, 12.5285f, 45.4577f, 12.0677f, 45.4577f, 11.5014f)
                close()
                moveTo(23.5829f, 14.9914f)
                lineTo(23.5831f, 14.9918f)
                lineTo(23.717f, 14.6614f)
                lineTo(25.9602f, 9.1396f)
                horizontalLineTo(24.5207f)
                lineTo(23.498f, 11.657f)
                lineTo(22.3971f, 9.1396f)
                horizontalLineTo(20.8621f)
                lineTo(22.8147f, 13.3391f)
                lineTo(22.1399f, 15.0f)
                horizontalLineTo(23.5794f)
                lineTo(23.5829f, 14.9914f)
                close()
            }
        }
        .build()
        return _bancontactPayconiq!!
    }

private var _bancontactPayconiq: ImageVector? = null
