package com.decathlon.vitamin.compose.vitaminassets.payments

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.PaymentsGroup

public val PaymentsGroup.Amex: ImageVector
    get() {
        if (_amex != null) {
            return _amex!!
        }
        _amex = Builder(name = "Amex", defaultWidth = 58.0.dp, defaultHeight = 40.0.dp,
                viewportWidth = 58.0f, viewportHeight = 40.0f).apply {
            path(fill = SolidColor(Color(0xFF006FCF)), stroke = SolidColor(Color(0xFFF3F3F3)),
                    strokeLineWidth = 1.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                    strokeLineMiter = 4.0f, pathFillType = NonZero) {
                moveTo(4.0f, 0.5f)
                lineTo(54.0f, 0.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 57.5f, 4.0f)
                lineTo(57.5f, 36.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 54.0f, 39.5f)
                lineTo(4.0f, 39.5f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 0.5f, 36.0f)
                lineTo(0.5f, 4.0f)
                arcTo(3.5f, 3.5f, 0.0f, false, true, 4.0f, 0.5f)
                close()
            }
            path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(11.8632f, 28.8937f)
                verticalLineTo(20.6592f)
                horizontalLineTo(21.1869f)
                lineTo(22.1872f, 21.8787f)
                lineTo(23.2206f, 20.6592f)
                horizontalLineTo(57.0632f)
                verticalLineTo(28.3258f)
                curveTo(57.0632f, 28.3258f, 56.1782f, 28.8855f, 55.1546f, 28.8937f)
                horizontalLineTo(36.4152f)
                lineTo(35.2874f, 27.5957f)
                verticalLineTo(28.8937f)
                horizontalLineTo(31.5916f)
                verticalLineTo(26.6779f)
                curveTo(31.5916f, 26.6779f, 31.0867f, 26.9872f, 29.9953f, 26.9872f)
                horizontalLineTo(28.7373f)
                verticalLineTo(28.8937f)
                horizontalLineTo(23.1415f)
                lineTo(22.1426f, 27.6481f)
                lineTo(21.1284f, 28.8937f)
                horizontalLineTo(11.8632f)
                close()
                moveTo(1.0f, 14.4529f)
                lineTo(3.0977f, 9.8691f)
                horizontalLineTo(6.7256f)
                lineTo(7.9161f, 12.4368f)
                verticalLineTo(9.8691f)
                horizontalLineTo(12.4258f)
                lineTo(13.1346f, 11.7249f)
                lineTo(13.8216f, 9.8691f)
                horizontalLineTo(34.0657f)
                verticalLineTo(10.8021f)
                curveTo(34.0657f, 10.8021f, 35.1299f, 9.8691f, 36.8789f, 9.8691f)
                lineTo(43.4474f, 9.8907f)
                lineTo(44.6173f, 12.4247f)
                verticalLineTo(9.8691f)
                horizontalLineTo(48.3913f)
                lineTo(49.43f, 11.3247f)
                verticalLineTo(9.8691f)
                horizontalLineTo(53.2386f)
                verticalLineTo(18.1037f)
                horizontalLineTo(49.43f)
                lineTo(48.4346f, 16.6434f)
                verticalLineTo(18.1037f)
                horizontalLineTo(42.8898f)
                lineTo(42.3321f, 16.8056f)
                horizontalLineTo(40.8415f)
                lineTo(40.293f, 18.1037f)
                horizontalLineTo(36.5327f)
                curveTo(35.0277f, 18.1037f, 34.0657f, 17.1897f, 34.0657f, 17.1897f)
                verticalLineTo(18.1037f)
                horizontalLineTo(28.3961f)
                lineTo(27.2708f, 16.8056f)
                verticalLineTo(18.1037f)
                horizontalLineTo(6.1882f)
                lineTo(5.6309f, 16.8056f)
                horizontalLineTo(4.1451f)
                lineTo(3.5918f, 18.1037f)
                horizontalLineTo(1.0f)
                verticalLineTo(14.4529f)
                close()
                moveTo(1.0108f, 17.05f)
                lineTo(3.8402f, 10.8843f)
                horizontalLineTo(5.9853f)
                lineTo(8.812f, 17.05f)
                horizontalLineTo(6.9293f)
                lineTo(6.41f, 15.8154f)
                horizontalLineTo(3.375f)
                lineTo(2.8529f, 17.05f)
                horizontalLineTo(1.0108f)
                close()
                moveTo(5.8122f, 14.4768f)
                lineTo(4.8871f, 12.3192f)
                lineTo(3.9592f, 14.4768f)
                horizontalLineTo(5.8122f)
                close()
                moveTo(9.0068f, 17.049f)
                verticalLineTo(10.8832f)
                lineTo(11.6245f, 10.8924f)
                lineTo(13.147f, 14.8676f)
                lineTo(14.6331f, 10.8832f)
                horizontalLineTo(17.2299f)
                verticalLineTo(17.049f)
                horizontalLineTo(15.5853f)
                verticalLineTo(12.5058f)
                lineTo(13.8419f, 17.049f)
                horizontalLineTo(12.3996f)
                lineTo(10.6514f, 12.5058f)
                verticalLineTo(17.049f)
                horizontalLineTo(9.0068f)
                close()
                moveTo(18.3552f, 17.049f)
                verticalLineTo(10.8832f)
                horizontalLineTo(23.7219f)
                verticalLineTo(12.2624f)
                horizontalLineTo(20.0171f)
                verticalLineTo(13.3171f)
                horizontalLineTo(23.6353f)
                verticalLineTo(14.6151f)
                horizontalLineTo(20.0171f)
                verticalLineTo(15.7104f)
                horizontalLineTo(23.7219f)
                verticalLineTo(17.049f)
                horizontalLineTo(18.3552f)
                close()
                moveTo(24.674f, 17.05f)
                verticalLineTo(10.8843f)
                horizontalLineTo(28.3339f)
                curveTo(29.5465f, 10.8843f, 30.6331f, 11.5871f, 30.6331f, 12.8846f)
                curveTo(30.6331f, 13.9938f, 29.717f, 14.7082f, 28.8289f, 14.7784f)
                lineTo(30.9929f, 17.05f)
                horizontalLineTo(28.9831f)
                lineTo(27.0111f, 14.8596f)
                horizontalLineTo(26.3186f)
                verticalLineTo(17.05f)
                horizontalLineTo(24.674f)
                close()
                moveTo(28.1986f, 12.2635f)
                horizontalLineTo(26.3186f)
                verticalLineTo(13.5615f)
                horizontalLineTo(28.223f)
                curveTo(28.5526f, 13.5615f, 28.9776f, 13.3221f, 28.9776f, 12.9125f)
                curveTo(28.9776f, 12.5941f, 28.6496f, 12.2635f, 28.1986f, 12.2635f)
                close()
                moveTo(32.9837f, 17.049f)
                horizontalLineTo(31.3045f)
                verticalLineTo(10.8832f)
                horizontalLineTo(32.9837f)
                verticalLineTo(17.049f)
                close()
                moveTo(36.9655f, 17.049f)
                horizontalLineTo(36.603f)
                curveTo(34.8492f, 17.049f, 33.7844f, 15.754f, 33.7844f, 13.9915f)
                curveTo(33.7844f, 12.1854f, 34.8373f, 10.8832f, 37.052f, 10.8832f)
                horizontalLineTo(38.8698f)
                verticalLineTo(12.3436f)
                horizontalLineTo(36.9856f)
                curveTo(36.0865f, 12.3436f, 35.4507f, 13.0012f, 35.4507f, 14.0067f)
                curveTo(35.4507f, 15.2008f, 36.1777f, 15.7023f, 37.2251f, 15.7023f)
                horizontalLineTo(37.6579f)
                lineTo(36.9655f, 17.049f)
                close()
                moveTo(37.7147f, 17.05f)
                lineTo(40.5441f, 10.8843f)
                horizontalLineTo(42.6892f)
                lineTo(45.5159f, 17.05f)
                horizontalLineTo(43.6332f)
                lineTo(43.1139f, 15.8154f)
                horizontalLineTo(40.0789f)
                lineTo(39.5568f, 17.05f)
                horizontalLineTo(37.7147f)
                close()
                moveTo(42.5161f, 14.4768f)
                lineTo(41.591f, 12.3192f)
                lineTo(40.6632f, 14.4768f)
                horizontalLineTo(42.5161f)
                close()
                moveTo(45.708f, 17.049f)
                verticalLineTo(10.8832f)
                horizontalLineTo(47.7989f)
                lineTo(50.4687f, 14.7571f)
                verticalLineTo(10.8832f)
                horizontalLineTo(52.1134f)
                verticalLineTo(17.049f)
                horizontalLineTo(50.09f)
                lineTo(47.3526f, 13.0737f)
                verticalLineTo(17.049f)
                horizontalLineTo(45.708f)
                close()
                moveTo(12.9885f, 27.8391f)
                verticalLineTo(21.6733f)
                horizontalLineTo(18.3552f)
                verticalLineTo(23.0525f)
                horizontalLineTo(14.6504f)
                verticalLineTo(24.1072f)
                horizontalLineTo(18.2686f)
                verticalLineTo(25.4052f)
                horizontalLineTo(14.6504f)
                verticalLineTo(26.5005f)
                horizontalLineTo(18.3552f)
                verticalLineTo(27.8391f)
                horizontalLineTo(12.9885f)
                close()
                moveTo(39.2853f, 27.8391f)
                verticalLineTo(21.6733f)
                horizontalLineTo(44.6519f)
                verticalLineTo(23.0525f)
                horizontalLineTo(40.9472f)
                verticalLineTo(24.1072f)
                horizontalLineTo(44.5481f)
                verticalLineTo(25.4052f)
                horizontalLineTo(40.9472f)
                verticalLineTo(26.5005f)
                horizontalLineTo(44.6519f)
                verticalLineTo(27.8391f)
                horizontalLineTo(39.2853f)
                close()
                moveTo(18.5635f, 27.8391f)
                lineTo(21.1765f, 24.7942f)
                lineTo(18.5012f, 21.6733f)
                horizontalLineTo(20.5733f)
                lineTo(22.1665f, 23.6026f)
                lineTo(23.7651f, 21.6733f)
                horizontalLineTo(25.756f)
                lineTo(23.1159f, 24.7562f)
                lineTo(25.7338f, 27.8391f)
                horizontalLineTo(23.6621f)
                lineTo(22.1151f, 25.9402f)
                lineTo(20.6057f, 27.8391f)
                horizontalLineTo(18.5635f)
                close()
                moveTo(25.9291f, 27.8401f)
                verticalLineTo(21.6744f)
                horizontalLineTo(29.5619f)
                curveTo(31.0525f, 21.6744f, 31.9234f, 22.5748f, 31.9234f, 23.7482f)
                curveTo(31.9234f, 25.1647f, 30.8131f, 25.893f, 29.3482f, 25.893f)
                horizontalLineTo(27.617f)
                verticalLineTo(27.8401f)
                horizontalLineTo(25.9291f)
                close()
                moveTo(29.4402f, 23.0687f)
                horizontalLineTo(27.617f)
                verticalLineTo(24.4885f)
                horizontalLineTo(29.4348f)
                curveTo(29.9151f, 24.4885f, 30.2517f, 24.1901f, 30.2517f, 23.7786f)
                curveTo(30.2517f, 23.3406f, 29.9134f, 23.0687f, 29.4402f, 23.0687f)
                close()
                moveTo(32.6375f, 27.8391f)
                verticalLineTo(21.6733f)
                horizontalLineTo(36.2973f)
                curveTo(37.51f, 21.6733f, 38.5966f, 22.3761f, 38.5966f, 23.6736f)
                curveTo(38.5966f, 24.7828f, 37.6805f, 25.4972f, 36.7923f, 25.5675f)
                lineTo(38.9563f, 27.8391f)
                horizontalLineTo(36.9465f)
                lineTo(34.9746f, 25.6486f)
                horizontalLineTo(34.2821f)
                verticalLineTo(27.8391f)
                horizontalLineTo(32.6375f)
                close()
                moveTo(36.1621f, 23.0525f)
                horizontalLineTo(34.2821f)
                verticalLineTo(24.3505f)
                horizontalLineTo(36.1864f)
                curveTo(36.5161f, 24.3505f, 36.9411f, 24.1112f, 36.9411f, 23.7015f)
                curveTo(36.9411f, 23.3831f, 36.6131f, 23.0525f, 36.1621f, 23.0525f)
                close()
                moveTo(45.4137f, 27.8391f)
                verticalLineTo(26.5005f)
                horizontalLineTo(48.7051f)
                curveTo(49.1921f, 26.5005f, 49.403f, 26.2538f, 49.403f, 25.9833f)
                curveTo(49.403f, 25.7241f, 49.1928f, 25.462f, 48.7051f, 25.462f)
                horizontalLineTo(47.2177f)
                curveTo(45.9249f, 25.462f, 45.2048f, 24.7237f, 45.2048f, 23.6153f)
                curveTo(45.2048f, 22.6267f, 45.8642f, 21.6733f, 47.7854f, 21.6733f)
                horizontalLineTo(50.9881f)
                lineTo(50.2956f, 23.0606f)
                horizontalLineTo(47.5257f)
                curveTo(46.9962f, 23.0606f, 46.8332f, 23.321f, 46.8332f, 23.5697f)
                curveTo(46.8332f, 23.8253f, 47.0347f, 24.1072f, 47.4392f, 24.1072f)
                horizontalLineTo(48.9972f)
                curveTo(50.4384f, 24.1072f, 51.0638f, 24.8734f, 51.0638f, 25.8768f)
                curveTo(51.0638f, 26.9555f, 50.367f, 27.8391f, 48.9188f, 27.8391f)
                horizontalLineTo(45.4137f)
                close()
                moveTo(51.2088f, 27.8391f)
                verticalLineTo(26.5005f)
                horizontalLineTo(54.5002f)
                curveTo(54.9873f, 26.5005f, 55.1981f, 26.2538f, 55.1981f, 25.9833f)
                curveTo(55.1981f, 25.7241f, 54.9879f, 25.462f, 54.5002f, 25.462f)
                horizontalLineTo(53.0129f)
                curveTo(51.72f, 25.462f, 51.0f, 24.7237f, 51.0f, 23.6153f)
                curveTo(51.0f, 22.6267f, 51.6594f, 21.6733f, 53.5806f, 21.6733f)
                horizontalLineTo(56.7833f)
                lineTo(56.0908f, 23.0606f)
                horizontalLineTo(53.3209f)
                curveTo(52.7914f, 23.0606f, 52.6284f, 23.321f, 52.6284f, 23.5697f)
                curveTo(52.6284f, 23.8253f, 52.8298f, 24.1072f, 53.2343f, 24.1072f)
                horizontalLineTo(54.7924f)
                curveTo(56.2336f, 24.1072f, 56.859f, 24.8734f, 56.859f, 25.8768f)
                curveTo(56.859f, 26.9555f, 56.1621f, 27.8391f, 54.7139f, 27.8391f)
                horizontalLineTo(51.2088f)
                close()
            }
        }
        .build()
        return _amex!!
    }

private var _amex: ImageVector? = null
