package com.decathlon.vitamin.compose.vitaminassets.logos

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.LogosGroup

public val LogosGroup.DecathlonLogoWithOutline: ImageVector
    get() {
        if (_decathlonLogoWithOutline != null) {
            return _decathlonLogoWithOutline!!
        }
        _decathlonLogoWithOutline = Builder(name = "DecathlonLogoWithOutline", defaultWidth =
                202.0.dp, defaultHeight = 52.0.dp, viewportWidth = 202.0f, viewportHeight =
                52.0f).apply {
            path(fill = SolidColor(Color(0xFFffffff)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(1.0f, 1.0f)
                horizontalLineToRelative(200.0f)
                verticalLineToRelative(50.0f)
                horizontalLineToRelative(-200.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFFffffff)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(0.0f, 52.0f)
                verticalLineTo(0.0f)
                horizontalLineTo(202.0f)
                verticalLineTo(52.0f)
                horizontalLineTo(0.0f)
                close()
                moveTo(201.0f, 51.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(1.0f)
                horizontalLineTo(201.0f)
                verticalLineTo(51.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFF0082C3)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(1.0f, 51.0f)
                horizontalLineTo(201.0f)
                verticalLineTo(1.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(51.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFFffffff)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(64.815f, 39.251f)
                curveTo(64.299f, 39.251f, 63.77f, 39.225f, 63.244f, 39.174f)
                curveTo(60.235f, 38.866f, 57.409f, 37.581f, 55.198f, 35.517f)
                curveTo(52.564f, 32.995f, 51.117f, 29.479f, 51.211f, 25.834f)
                curveTo(51.319f, 22.95f, 52.313f, 20.17f, 54.057f, 17.871f)
                curveTo(55.172f, 16.4f, 56.6f, 15.196f, 58.238f, 14.346f)
                curveTo(60.275f, 13.327f, 62.519f, 12.79f, 64.796f, 12.778f)
                curveTo(64.896f, 12.778f, 65.004f, 12.778f, 65.106f, 12.778f)
                curveTo(69.129f, 12.807f, 72.938f, 14.598f, 75.526f, 17.678f)
                lineTo(75.586f, 17.755f)
                lineTo(72.225f, 23.141f)
                lineTo(72.001f, 22.875f)
                lineTo(71.844f, 22.701f)
                lineTo(71.538f, 22.379f)
                lineTo(71.288f, 22.132f)
                curveTo(70.125f, 21.014f, 67.745f, 19.137f, 64.871f, 19.137f)
                horizontalLineTo(64.738f)
                curveTo(61.016f, 19.201f, 58.03f, 22.233f, 58.023f, 25.956f)
                curveTo(58.023f, 29.056f, 59.887f, 32.697f, 65.139f, 32.778f)
                horizontalLineTo(65.216f)
                curveTo(68.27f, 32.778f, 70.266f, 30.535f, 71.183f, 29.198f)
                lineTo(71.383f, 28.898f)
                curveTo(71.494f, 28.725f, 71.752f, 28.298f, 72.174f, 27.598f)
                lineTo(80.675f, 13.287f)
                horizontalLineTo(87.553f)
                verticalLineTo(38.677f)
                horizontalLineTo(81.223f)
                verticalLineTo(34.868f)
                lineTo(76.18f, 34.846f)
                horizontalLineTo(75.507f)
                lineTo(75.323f, 34.854f)
                lineTo(75.291f, 34.86f)
                lineTo(75.155f, 35.01f)
                lineTo(74.993f, 35.177f)
                lineTo(74.764f, 35.399f)
                lineTo(74.572f, 35.576f)
                lineTo(74.35f, 35.776f)
                lineTo(74.1f, 35.986f)
                curveTo(71.472f, 38.108f, 68.193f, 39.261f, 64.815f, 39.251f)
                close()
                moveTo(81.353f, 23.806f)
                lineTo(77.96f, 29.556f)
                horizontalLineTo(81.353f)
                verticalLineTo(23.806f)
                close()
                moveTo(152.769f, 39.239f)
                curveTo(149.169f, 39.322f, 145.699f, 37.896f, 143.198f, 35.305f)
                verticalLineTo(38.694f)
                horizontalLineTo(128.988f)
                verticalLineTo(13.291f)
                horizontalLineTo(135.526f)
                verticalLineTo(33.08f)
                horizontalLineTo(141.434f)
                curveTo(140.075f, 30.873f, 139.379f, 28.322f, 139.426f, 25.731f)
                curveTo(139.421f, 24.01f, 139.765f, 22.305f, 140.438f, 20.721f)
                curveTo(141.12f, 19.13f, 142.115f, 17.693f, 143.363f, 16.494f)
                curveTo(145.879f, 14.028f, 149.284f, 12.68f, 152.807f, 12.756f)
                curveTo(156.269f, 12.756f, 159.593f, 14.109f, 162.071f, 16.526f)
                curveTo(163.634f, 18.02f, 164.803f, 19.878f, 165.471f, 21.934f)
                verticalLineTo(13.286f)
                horizontalLineTo(171.413f)
                lineTo(181.291f, 27.396f)
                verticalLineTo(13.286f)
                horizontalLineTo(187.878f)
                verticalLineTo(38.694f)
                horizontalLineTo(182.091f)
                lineTo(172.058f, 24.539f)
                verticalLineTo(38.694f)
                horizontalLineTo(165.475f)
                verticalLineTo(29.985f)
                curveTo(164.869f, 31.97f, 163.789f, 33.777f, 162.328f, 35.251f)
                curveTo(159.817f, 37.825f, 156.365f, 39.265f, 152.769f, 39.239f)
                close()
                moveTo(152.843f, 19.077f)
                curveTo(151.018f, 19.062f, 149.26f, 19.766f, 147.95f, 21.038f)
                curveTo(146.665f, 22.289f, 145.943f, 24.008f, 145.95f, 25.801f)
                curveTo(145.942f, 27.696f, 146.686f, 29.517f, 148.018f, 30.865f)
                curveTo(149.267f, 32.15f, 150.975f, 32.885f, 152.767f, 32.909f)
                curveTo(154.563f, 32.922f, 156.286f, 32.203f, 157.54f, 30.917f)
                curveTo(158.844f, 29.536f, 159.555f, 27.7f, 159.52f, 25.801f)
                curveTo(159.528f, 22.103f, 156.541f, 19.096f, 152.843f, 19.078f)
                verticalLineTo(19.077f)
                close()
                moveTo(113.638f, 38.695f)
                horizontalLineTo(107.068f)
                verticalLineTo(13.284f)
                horizontalLineTo(113.638f)
                verticalLineTo(22.932f)
                horizontalLineTo(120.404f)
                verticalLineTo(13.284f)
                horizontalLineTo(126.979f)
                verticalLineTo(38.693f)
                horizontalLineTo(120.404f)
                verticalLineTo(28.972f)
                horizontalLineTo(113.638f)
                verticalLineTo(38.694f)
                verticalLineTo(38.695f)
                close()
                moveTo(100.606f, 38.695f)
                horizontalLineTo(94.038f)
                verticalLineTo(19.35f)
                horizontalLineTo(88.926f)
                verticalLineTo(13.276f)
                horizontalLineTo(105.712f)
                verticalLineTo(19.35f)
                horizontalLineTo(100.612f)
                verticalLineTo(38.693f)
                lineTo(100.606f, 38.695f)
                close()
                moveTo(23.123f, 38.695f)
                horizontalLineTo(13.038f)
                verticalLineTo(13.287f)
                horizontalLineTo(22.226f)
                curveTo(26.44f, 13.287f, 29.436f, 13.787f, 32.276f, 16.322f)
                curveTo(34.34f, 18.2f, 35.666f, 20.753f, 36.014f, 23.522f)
                verticalLineTo(13.287f)
                horizontalLineTo(50.638f)
                verticalLineTo(18.876f)
                lineTo(42.592f, 18.885f)
                verticalLineTo(23.036f)
                lineTo(49.559f, 23.03f)
                verticalLineTo(28.494f)
                lineTo(42.592f, 28.501f)
                verticalLineTo(33.106f)
                horizontalLineTo(50.638f)
                verticalLineTo(38.677f)
                horizontalLineTo(36.013f)
                verticalLineTo(28.548f)
                curveTo(35.608f, 31.235f, 34.3f, 33.704f, 32.305f, 35.548f)
                curveTo(29.438f, 38.193f, 26.865f, 38.694f, 23.126f, 38.694f)
                lineTo(23.123f, 38.695f)
                close()
                moveTo(19.615f, 18.75f)
                verticalLineTo(33.114f)
                horizontalLineTo(22.256f)
                curveTo(24.809f, 33.114f, 26.638f, 32.548f, 27.848f, 31.384f)
                curveTo(29.058f, 30.22f, 29.666f, 28.414f, 29.666f, 25.904f)
                curveTo(29.666f, 21.291f, 27.024f, 18.75f, 22.226f, 18.75f)
                horizontalLineTo(19.615f)
                close()
            }
        }
        .build()
        return _decathlonLogoWithOutline!!
    }

private var _decathlonLogoWithOutline: ImageVector? = null
