package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Zm: ImageVector
    get() {
        if (_zm != null) {
            return _zm!!
        }
        _zm = Builder(name = "Zm", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.999f, 0.0f)
                    horizontalLineTo(-0.001f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(27.999f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF2A8815)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.999f, 0.0f)
                    horizontalLineTo(-0.001f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(27.999f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFEF8A34)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(21.593f, 4.8319f)
                    curveTo(21.593f, 4.8319f, 21.0555f, 5.0359f, 20.4816f, 4.8319f)
                    curveTo(20.0249f, 4.6696f, 19.5657f, 4.1206f, 19.1884f, 3.9298f)
                    curveTo(18.9697f, 3.8192f, 19.3756f, 3.2921f, 18.9427f, 3.4344f)
                    curveTo(18.5097f, 3.5766f, 17.8025f, 2.9157f, 17.8025f, 2.9157f)
                    curveTo(17.8025f, 2.9157f, 17.0719f, 2.0252f, 18.1481f, 2.0252f)
                    curveTo(19.2242f, 2.0252f, 21.4942f, 2.7984f, 21.4942f, 2.7984f)
                    curveTo(21.4942f, 2.7984f, 21.5792f, 2.3991f, 21.7643f, 2.215f)
                    curveTo(21.9494f, 2.031f, 22.0866f, 1.862f, 22.3899f, 1.9078f)
                    curveTo(22.6932f, 1.9537f, 22.8609f, 2.381f, 22.8609f, 2.381f)
                    lineTo(22.3899f, 2.5608f)
                    verticalLineTo(2.9157f)
                    curveTo(22.3899f, 2.9157f, 25.5384f, 1.9502f, 26.2826f, 2.0252f)
                    curveTo(27.0268f, 2.1002f, 26.4278f, 2.9167f, 25.9785f, 3.4344f)
                    curveTo(25.8048f, 3.6346f, 25.2373f, 4.0425f, 24.8924f, 3.7155f)
                    curveTo(24.5474f, 3.3884f, 24.6754f, 4.0691f, 24.3178f, 4.2888f)
                    curveTo(23.7347f, 4.6472f, 23.5158f, 4.9756f, 23.3154f, 5.0712f)
                    curveTo(23.1149f, 5.1667f, 22.6765f, 5.0712f, 22.6765f, 5.0712f)
                    lineTo(22.8046f, 5.3999f)
                    curveTo(22.8046f, 5.3999f, 22.8405f, 5.7949f, 22.6765f, 5.9524f)
                    curveTo(22.5125f, 6.11f, 22.3984f, 6.221f, 21.9987f, 6.1739f)
                    curveTo(21.599f, 6.1267f, 21.4104f, 6.227f, 21.2775f, 5.7873f)
                    curveTo(21.1445f, 5.3476f, 21.593f, 4.8319f, 21.593f, 4.8319f)
                    close()
                    moveTo(21.9223f, 4.3765f)
                    verticalLineTo(5.4051f)
                    lineTo(22.3745f, 5.027f)
                    lineTo(21.9223f, 4.3765f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF48D36)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.999f, 8.0f)
                    horizontalLineTo(23.999f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(27.999f)
                    verticalLineTo(8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(23.999f, 8.0f)
                    horizontalLineTo(19.999f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(23.999f)
                    verticalLineTo(8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFEC322B)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(19.999f, 8.0f)
                    horizontalLineTo(15.999f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(19.999f)
                    verticalLineTo(8.0f)
                    close()
                }
            }
        }
        .build()
        return _zm!!
    }

private var _zm: ImageVector? = null
