package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Yt: ImageVector
    get() {
        if (_yt != null) {
            return _yt!!
        }
        _yt = Builder(name = "Yt", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFF7F7F7)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 0.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFD8D8D8)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(10.6662f, 5.988f)
                    curveTo(10.6662f, 5.6265f, 10.9527f, 5.3334f, 11.3298f, 5.3334f)
                    horizontalLineTo(16.6693f)
                    curveTo(17.0358f, 5.3334f, 17.3329f, 5.6372f, 17.3329f, 5.988f)
                    verticalLineTo(12.6787f)
                    curveTo(17.3329f, 13.0403f, 17.0419f, 13.3439f, 16.6654f, 13.3746f)
                    curveTo(16.6654f, 13.3746f, 14.6662f, 13.3334f, 13.9995f, 14.5874f)
                    curveTo(13.3329f, 13.3334f, 11.3336f, 13.3746f, 11.3336f, 13.3746f)
                    curveTo(10.965f, 13.3518f, 10.6662f, 13.0295f, 10.6662f, 12.6787f)
                    verticalLineTo(5.988f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3329f, 5.3334f)
                    horizontalLineTo(10.6662f)
                    verticalLineTo(9.3334f)
                    horizontalLineTo(17.3329f)
                    verticalLineTo(5.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1B2CA9)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3329f, 5.3334f)
                    horizontalLineTo(10.6662f)
                    verticalLineTo(9.3334f)
                    horizontalLineTo(17.3329f)
                    verticalLineTo(5.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3329f, 9.3334f)
                    horizontalLineTo(10.6662f)
                    verticalLineTo(14.6667f)
                    horizontalLineTo(17.3329f)
                    verticalLineTo(9.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE6402C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3329f, 9.3334f)
                    horizontalLineTo(10.6662f)
                    verticalLineTo(14.6667f)
                    horizontalLineTo(17.3329f)
                    verticalLineTo(9.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFD0D0D0)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0524f, 6.3011f)
                    verticalLineTo(5.683f)
                    lineTo(20.667f, 5.3333f)
                    curveTo(20.667f, 5.3333f, 20.0602f, 4.5919f, 20.3602f, 4.5919f)
                    curveTo(20.7268f, 4.5919f, 22.2658f, 5.0799f, 22.667f, 5.3333f)
                    curveTo(23.0682f, 5.5867f, 23.2716f, 5.8913f, 23.3281f, 6.4663f)
                    curveTo(23.3845f, 7.0414f, 22.9068f, 7.7751f, 22.9068f, 7.7751f)
                    lineTo(22.667f, 8.333f)
                    lineTo(23.7178f, 8.0953f)
                    curveTo(23.7178f, 8.0953f, 23.8879f, 9.1966f, 23.1144f, 10.0f)
                    curveTo(22.3408f, 10.8034f, 21.2553f, 10.6527f, 21.2553f, 10.6527f)
                    lineTo(21.037f, 10.0f)
                    curveTo(21.037f, 10.0f, 20.3285f, 10.2752f, 19.9118f, 10.8988f)
                    curveTo(19.4952f, 11.5225f, 19.3777f, 12.6003f, 20.0524f, 13.2656f)
                    curveTo(20.7271f, 13.9309f, 21.8404f, 13.8745f, 22.3712f, 12.9392f)
                    curveTo(22.3712f, 12.9392f, 22.5842f, 12.112f, 22.0934f, 11.7231f)
                    curveTo(21.6026f, 11.3341f, 21.2704f, 12.1377f, 21.2553f, 12.0934f)
                    curveTo(21.16f, 11.8129f, 21.037f, 11.3341f, 21.8257f, 11.3341f)
                    curveTo(22.6145f, 11.3341f, 23.0202f, 12.1822f, 22.9068f, 12.8342f)
                    curveTo(22.7933f, 13.4862f, 22.5657f, 14.1053f, 21.037f, 14.2789f)
                    curveTo(19.5083f, 14.4525f, 19.1148f, 12.5148f, 19.1148f, 12.5148f)
                    curveTo(19.1148f, 12.5148f, 18.7251f, 10.7066f, 19.1148f, 9.401f)
                    curveTo(19.5044f, 8.0953f, 20.082f, 8.0629f, 21.2553f, 7.346f)
                    curveTo(22.4287f, 6.6291f, 20.547f, 7.103f, 20.547f, 7.103f)
                    curveTo(20.547f, 7.103f, 19.6534f, 7.7751f, 19.3733f, 7.5304f)
                    curveTo(19.0932f, 7.2858f, 20.0524f, 6.3011f, 20.0524f, 6.3011f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, fillAlpha = 0.3f,
                        strokeLineWidth = 0.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                        strokeLineMiter = 4.0f, pathFillType = NonZero) {
                    moveTo(21.0002f, 7.6667f)
                    curveTo(21.7366f, 7.6667f, 22.3335f, 7.0697f, 22.3335f, 6.3334f)
                    curveTo(22.3335f, 5.597f, 21.7366f, 5.0f, 21.0002f, 5.0f)
                    curveTo(20.2638f, 5.0f, 19.6669f, 5.597f, 19.6669f, 6.3334f)
                    curveTo(19.6669f, 7.0697f, 20.2638f, 7.6667f, 21.0002f, 7.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFD0D0D0)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(7.948f, 6.3011f)
                    verticalLineTo(5.683f)
                    lineTo(7.3334f, 5.3333f)
                    curveTo(7.3334f, 5.3333f, 7.9402f, 4.5919f, 7.6402f, 4.5919f)
                    curveTo(7.2736f, 4.5919f, 5.7346f, 5.0799f, 5.3334f, 5.3333f)
                    curveTo(4.9322f, 5.5867f, 4.7288f, 5.8913f, 4.6723f, 6.4663f)
                    curveTo(4.6159f, 7.0414f, 5.0936f, 7.7751f, 5.0936f, 7.7751f)
                    lineTo(5.3334f, 8.333f)
                    lineTo(4.2826f, 8.0953f)
                    curveTo(4.2826f, 8.0953f, 4.1125f, 9.1966f, 4.886f, 10.0f)
                    curveTo(5.6596f, 10.8034f, 6.7451f, 10.6527f, 6.7451f, 10.6527f)
                    lineTo(6.9634f, 10.0f)
                    curveTo(6.9634f, 10.0f, 7.6719f, 10.2752f, 8.0886f, 10.8988f)
                    curveTo(8.5052f, 11.5225f, 8.6227f, 12.6003f, 7.948f, 13.2656f)
                    curveTo(7.2733f, 13.9309f, 6.16f, 13.8745f, 5.6292f, 12.9392f)
                    curveTo(5.6292f, 12.9392f, 5.4162f, 12.112f, 5.907f, 11.7231f)
                    curveTo(6.3978f, 11.3341f, 6.73f, 12.1377f, 6.7451f, 12.0934f)
                    curveTo(6.8404f, 11.8129f, 6.9634f, 11.3341f, 6.1747f, 11.3341f)
                    curveTo(5.3859f, 11.3341f, 4.9802f, 12.1822f, 5.0936f, 12.8342f)
                    curveTo(5.2071f, 13.4862f, 5.4347f, 14.1053f, 6.9634f, 14.2789f)
                    curveTo(8.4921f, 14.4525f, 8.8856f, 12.5148f, 8.8856f, 12.5148f)
                    curveTo(8.8856f, 12.5148f, 9.2753f, 10.7066f, 8.8856f, 9.401f)
                    curveTo(8.496f, 8.0953f, 7.9184f, 8.0629f, 6.7451f, 7.346f)
                    curveTo(5.5717f, 6.6291f, 7.4534f, 7.103f, 7.4534f, 7.103f)
                    curveTo(7.4534f, 7.103f, 8.347f, 7.7751f, 8.6271f, 7.5304f)
                    curveTo(8.9072f, 7.2858f, 7.948f, 6.3011f, 7.948f, 6.3011f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, fillAlpha = 0.3f,
                        strokeLineWidth = 0.0f, strokeLineCap = Butt, strokeLineJoin = Miter,
                        strokeLineMiter = 4.0f, pathFillType = NonZero) {
                    moveTo(7.0002f, 7.6667f)
                    curveTo(6.2638f, 7.6667f, 5.6669f, 7.0697f, 5.6669f, 6.3334f)
                    curveTo(5.6669f, 5.597f, 6.2638f, 5.0f, 7.0002f, 5.0f)
                    curveTo(7.7366f, 5.0f, 8.3335f, 5.597f, 8.3335f, 6.3334f)
                    curveTo(8.3335f, 7.0697f, 7.7366f, 7.6667f, 7.0002f, 7.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.8452f, 6.6667f)
                    curveTo(12.7318f, 6.8628f, 12.6669f, 7.0905f, 12.6669f, 7.3333f)
                    curveTo(12.6669f, 8.0697f, 13.2638f, 8.6667f, 14.0002f, 8.6667f)
                    curveTo(14.7366f, 8.6667f, 15.3335f, 8.0697f, 15.3335f, 7.3333f)
                    curveTo(15.3335f, 7.0905f, 15.2686f, 6.8628f, 15.1552f, 6.6667f)
                    curveTo(14.9246f, 7.0652f, 14.4937f, 7.3333f, 14.0002f, 7.3333f)
                    curveTo(13.5067f, 7.3333f, 13.0758f, 7.0652f, 12.8452f, 6.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF7E04B)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.6669f, 12.0f)
                    curveTo(12.2987f, 12.0f, 12.0002f, 11.7015f, 12.0002f, 11.3333f)
                    curveTo(12.0002f, 10.9651f, 12.2987f, 10.6667f, 12.6669f, 10.6667f)
                    curveTo(13.0351f, 10.6667f, 13.3335f, 10.9651f, 13.3335f, 11.3333f)
                    curveTo(13.3335f, 11.7015f, 13.0351f, 12.0f, 12.6669f, 12.0f)
                    close()
                    moveTo(15.3335f, 12.0f)
                    curveTo(14.9653f, 12.0f, 14.6669f, 11.7015f, 14.6669f, 11.3333f)
                    curveTo(14.6669f, 10.9651f, 14.9653f, 10.6667f, 15.3335f, 10.6667f)
                    curveTo(15.7017f, 10.6667f, 16.0002f, 10.9651f, 16.0002f, 11.3333f)
                    curveTo(16.0002f, 11.7015f, 15.7017f, 12.0f, 15.3335f, 12.0f)
                    close()
                }
            }
        }
        .build()
        return _yt!!
    }

private var _yt: ImageVector? = null
