package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Xk: ImageVector
    get() {
        if (_xk != null) {
            return _xk!!
        }
        _xk = Builder(name = "Xk", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.001f, 0.0f)
                    horizontalLineTo(0.001f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.001f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF2F5FBF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.001f, 0.0f)
                    horizontalLineTo(0.001f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.001f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.0011f, 4.6667f)
                    lineTo(11.0583f, 4.9428f)
                    lineTo(11.3344f, 4.0f)
                    lineTo(11.0583f, 3.0572f)
                    lineTo(12.0011f, 3.3333f)
                    lineTo(12.9439f, 3.0572f)
                    lineTo(12.6677f, 4.0f)
                    lineTo(12.9439f, 4.9428f)
                    lineTo(12.0011f, 4.6667f)
                    close()
                    moveTo(16.0011f, 4.6667f)
                    lineTo(15.0583f, 4.9428f)
                    lineTo(15.3344f, 4.0f)
                    lineTo(15.0583f, 3.0572f)
                    lineTo(16.0011f, 3.3333f)
                    lineTo(16.9439f, 3.0572f)
                    lineTo(16.6677f, 4.0f)
                    lineTo(16.9439f, 4.9428f)
                    lineTo(16.0011f, 4.6667f)
                    close()
                    moveTo(20.0011f, 6.0f)
                    lineTo(19.0583f, 6.2762f)
                    lineTo(19.3344f, 5.3334f)
                    lineTo(19.0583f, 4.3905f)
                    lineTo(20.0011f, 4.6667f)
                    lineTo(20.9439f, 4.3905f)
                    lineTo(20.6677f, 5.3334f)
                    lineTo(20.9439f, 6.2762f)
                    lineTo(20.0011f, 6.0f)
                    close()
                    moveTo(22.6677f, 8.6667f)
                    lineTo(21.7249f, 8.9428f)
                    lineTo(22.0011f, 8.0f)
                    lineTo(21.7249f, 7.0572f)
                    lineTo(22.6677f, 7.3334f)
                    lineTo(23.6106f, 7.0572f)
                    lineTo(23.3344f, 8.0f)
                    lineTo(23.6106f, 8.9428f)
                    lineTo(22.6677f, 8.6667f)
                    close()
                    moveTo(5.3344f, 8.6667f)
                    lineTo(4.3916f, 8.9428f)
                    lineTo(4.6677f, 8.0f)
                    lineTo(4.3916f, 7.0572f)
                    lineTo(5.3344f, 7.3334f)
                    lineTo(6.2772f, 7.0572f)
                    lineTo(6.0011f, 8.0f)
                    lineTo(6.2772f, 8.9428f)
                    lineTo(5.3344f, 8.6667f)
                    close()
                    moveTo(8.0011f, 6.0f)
                    lineTo(7.0583f, 6.2762f)
                    lineTo(7.3344f, 5.3334f)
                    lineTo(7.0583f, 4.3905f)
                    lineTo(8.0011f, 4.6667f)
                    lineTo(8.9439f, 4.3905f)
                    lineTo(8.6677f, 5.3334f)
                    lineTo(8.9439f, 6.2762f)
                    lineTo(8.0011f, 6.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE9C072)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.001f, 13.3333f)
                    lineTo(10.6676f, 12.6667f)
                    lineTo(9.3343f, 10.0f)
                    horizontalLineTo(10.6676f)
                    lineTo(12.001f, 8.6667f)
                    lineTo(12.6676f, 7.3333f)
                    lineTo(14.001f, 6.6667f)
                    lineTo(14.6676f, 7.3333f)
                    lineTo(16.001f, 8.0f)
                    verticalLineTo(8.6667f)
                    lineTo(16.6676f, 9.3333f)
                    lineTo(18.6676f, 10.6667f)
                    lineTo(18.001f, 12.6667f)
                    lineTo(16.001f, 14.6667f)
                    lineTo(15.3343f, 13.3333f)
                    lineTo(13.3343f, 14.6667f)
                    verticalLineTo(16.0f)
                    lineTo(12.6676f, 15.3333f)
                    lineTo(12.001f, 13.3333f)
                    close()
                }
            }
        }
        .build()
        return _xk!!
    }

private var _xk: ImageVector? = null
