package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Vi: ImageVector
    get() {
        if (_vi != null) {
            return _vi!!
        }
        _vi = Builder(name = "Vi", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFF2F2F2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.9997f, 0.0f)
                    horizontalLineTo(-3.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(27.9997f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1583C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(21.7987f, 8.6727f)
                    lineTo(17.7044f, 16.5123f)
                    curveTo(17.6192f, 16.6755f, 17.6824f, 16.8769f, 17.8456f, 16.9621f)
                    curveTo(18.0088f, 17.0473f, 18.2101f, 16.9841f, 18.2954f, 16.821f)
                    lineTo(22.3896f, 8.9813f)
                    curveTo(22.4748f, 8.8181f, 22.4116f, 8.6167f, 22.2484f, 8.5315f)
                    curveTo(22.0853f, 8.4463f, 21.8839f, 8.5095f, 21.7987f, 8.6727f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1583C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(22.3744f, 10.4176f)
                    lineTo(17.7354f, 16.4638f)
                    curveTo(17.6233f, 16.6098f, 17.6509f, 16.8191f, 17.7969f, 16.9311f)
                    curveTo(17.943f, 17.0432f, 18.1522f, 17.0156f, 18.2643f, 16.8696f)
                    lineTo(22.9033f, 10.8234f)
                    curveTo(23.0154f, 10.6773f, 22.9878f, 10.4681f, 22.8418f, 10.356f)
                    curveTo(22.6957f, 10.2439f, 22.4864f, 10.2715f, 22.3744f, 10.4176f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1583C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(20.2969f, 9.8786f)
                    lineTo(17.6895f, 16.5453f)
                    curveTo(17.6224f, 16.7167f, 17.7071f, 16.9101f, 17.8785f, 16.9771f)
                    curveTo(18.0499f, 17.0442f, 18.2433f, 16.9595f, 18.3104f, 16.7881f)
                    lineTo(20.9178f, 10.1214f)
                    curveTo(20.9848f, 9.95f, 20.9002f, 9.7566f, 20.7288f, 9.6896f)
                    curveTo(20.5573f, 9.6225f, 20.364f, 9.7071f, 20.2969f, 9.8786f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF409347)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(5.681f, 8.7635f)
                    curveTo(5.7189f, 8.8883f, 5.7875f, 9.1047f, 5.8805f, 9.3824f)
                    curveTo(6.0356f, 9.8451f, 6.2022f, 10.308f, 6.3745f, 10.7412f)
                    curveTo(6.5722f, 11.2385f, 6.7649f, 11.6651f, 6.9498f, 12.0013f)
                    curveTo(6.9826f, 12.061f, 7.0152f, 12.1177f, 7.0474f, 12.1715f)
                    curveTo(7.2606f, 12.5269f, 7.599f, 12.9904f, 8.0372f, 13.54f)
                    curveTo(8.12f, 13.6438f, 8.2058f, 13.7501f, 8.2944f, 13.8585f)
                    curveTo(8.6136f, 14.2488f, 8.9551f, 14.6505f, 9.2965f, 15.0416f)
                    curveTo(9.5014f, 15.2762f, 9.6609f, 15.4554f, 9.7526f, 15.5568f)
                    curveTo(9.8761f, 15.6934f, 10.0868f, 15.7041f, 10.2234f, 15.5806f)
                    curveTo(10.36f, 15.4572f, 10.3707f, 15.2464f, 10.2472f, 15.1098f)
                    curveTo(10.1579f, 15.0111f, 10.0009f, 14.8347f, 9.7987f, 14.6031f)
                    curveTo(9.4616f, 14.2171f, 9.1246f, 13.8206f, 8.8105f, 13.4365f)
                    curveTo(8.7236f, 13.3301f, 8.6395f, 13.226f, 8.5584f, 13.1244f)
                    curveTo(8.1371f, 12.596f, 7.8137f, 12.1529f, 7.6191f, 11.8285f)
                    curveTo(7.5913f, 11.7821f, 7.5629f, 11.7326f, 7.534f, 11.6801f)
                    curveTo(7.3645f, 11.3719f, 7.1824f, 10.9687f, 6.994f, 10.4949f)
                    curveTo(6.8267f, 10.0743f, 6.6641f, 9.6226f, 6.5127f, 9.1706f)
                    curveTo(6.4218f, 8.8994f, 6.355f, 8.6889f, 6.3189f, 8.5698f)
                    curveTo(6.2654f, 8.3937f, 6.0792f, 8.2942f, 5.903f, 8.3477f)
                    curveTo(5.7269f, 8.4012f, 5.6275f, 8.5874f, 5.681f, 8.7635f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1583C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(25.3332f, 8.6667f)
                    verticalLineTo(12.0f)
                    curveTo(25.3332f, 12.3682f, 25.6316f, 12.6667f, 25.9998f, 12.6667f)
                    curveTo(26.368f, 12.6667f, 26.6665f, 12.3682f, 26.6665f, 12.0f)
                    verticalLineTo(8.6667f)
                    curveTo(26.6665f, 8.2985f, 26.368f, 8.0f, 25.9998f, 8.0f)
                    curveTo(25.6316f, 8.0f, 25.3332f, 8.2985f, 25.3332f, 8.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1583C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(3.3333f, 10.205f)
                    lineTo(2.619f, 8.4191f)
                    curveTo(2.4822f, 8.0772f, 2.0943f, 7.911f, 1.7524f, 8.0477f)
                    curveTo(1.4106f, 8.1844f, 1.2443f, 8.5724f, 1.381f, 8.9143f)
                    lineTo(2.7143f, 12.2476f)
                    curveTo(2.9379f, 12.8064f, 3.7288f, 12.8064f, 3.9523f, 12.2476f)
                    lineTo(5.2857f, 8.9143f)
                    curveTo(5.4224f, 8.5724f, 5.2561f, 8.1844f, 4.9143f, 8.0477f)
                    curveTo(4.5724f, 7.911f, 4.1844f, 8.0772f, 4.0477f, 8.4191f)
                    lineTo(3.3333f, 10.205f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF8CE61)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(19.9994f, 8.6666f)
                    curveTo(19.9994f, 8.6666f, 20.0469f, 9.5527f, 18.9286f, 10.0f)
                    curveTo(17.8104f, 10.4473f, 16.666f, 10.0f, 16.666f, 10.0f)
                    curveTo(16.666f, 10.0f, 17.4895f, 10.4836f, 17.9994f, 11.3333f)
                    curveTo(18.5092f, 12.183f, 18.2424f, 12.6443f, 18.666f, 13.0679f)
                    curveTo(19.0896f, 13.4915f, 19.8545f, 13.2026f, 20.1572f, 13.5657f)
                    curveTo(20.46f, 13.9287f, 20.4362f, 14.3441f, 19.9994f, 14.6667f)
                    curveTo(19.5625f, 14.9892f, 19.4238f, 14.8388f, 18.9286f, 14.5087f)
                    curveTo(18.4335f, 14.1786f, 18.666f, 13.8489f, 18.666f, 13.8489f)
                    curveTo(18.666f, 13.8489f, 17.8136f, 13.4075f, 17.1623f, 13.2169f)
                    curveTo(16.666f, 12.2909f, 15.9994f, 12.0f, 15.9994f, 12.0f)
                    verticalLineTo(12.6666f)
                    curveTo(15.9994f, 12.6666f, 17.3327f, 13.3504f, 17.3327f, 14.0f)
                    curveTo(17.3327f, 14.2839f, 16.7164f, 15.2219f, 15.9994f, 15.8892f)
                    curveTo(15.0761f, 16.7484f, 13.9994f, 16.9858f, 13.9994f, 16.9858f)
                    verticalLineTo(7.3333f)
                    lineTo(17.9994f, 6.6666f)
                    curveTo(17.9994f, 6.6666f, 16.1576f, 5.2176f, 20.3327f, 4.2043f)
                    curveTo(24.5078f, 3.1911f, 25.3723f, 2.9809f, 25.3723f, 2.9809f)
                    curveTo(26.0868f, 2.8073f, 26.3603f, 3.1692f, 25.9623f, 3.7885f)
                    curveTo(25.9623f, 3.7885f, 25.93f, 3.92f, 25.3327f, 4.6666f)
                    curveTo(24.7354f, 5.4133f, 24.6041f, 5.5464f, 23.9994f, 6.0f)
                    curveTo(23.3946f, 6.4535f, 23.3946f, 6.1202f, 22.666f, 6.6666f)
                    curveTo(21.9374f, 7.2131f, 21.9106f, 7.711f, 21.3327f, 8.0f)
                    curveTo(20.7548f, 8.2889f, 19.9994f, 8.0f, 19.9994f, 8.0f)
                    verticalLineTo(8.6666f)
                    close()
                    moveTo(7.999f, 8.6666f)
                    verticalLineTo(8.0f)
                    curveTo(7.999f, 8.0f, 7.2436f, 8.2889f, 6.6657f, 8.0f)
                    curveTo(6.0878f, 7.711f, 6.061f, 7.2131f, 5.3324f, 6.6666f)
                    curveTo(4.6038f, 6.1202f, 4.6038f, 6.4535f, 3.999f, 6.0f)
                    curveTo(3.3943f, 5.5464f, 3.263f, 5.4133f, 2.6657f, 4.6666f)
                    curveTo(2.0684f, 3.92f, 2.0361f, 3.7885f, 2.0361f, 3.7885f)
                    curveTo(1.6381f, 3.1692f, 1.9116f, 2.8073f, 2.6261f, 2.9809f)
                    curveTo(2.6261f, 2.9809f, 3.4906f, 3.1911f, 7.6657f, 4.2043f)
                    curveTo(11.8408f, 5.2176f, 9.999f, 6.6666f, 9.999f, 6.6666f)
                    lineTo(13.9994f, 7.3333f)
                    verticalLineTo(16.9858f)
                    curveTo(13.9994f, 16.9858f, 12.9223f, 16.7484f, 11.999f, 15.8892f)
                    curveTo(11.282f, 15.2219f, 10.6657f, 14.2839f, 10.6657f, 14.0f)
                    curveTo(10.6657f, 13.3504f, 11.999f, 12.6666f, 11.999f, 12.6666f)
                    verticalLineTo(12.0f)
                    curveTo(11.999f, 12.0f, 11.3324f, 12.2909f, 10.8361f, 13.2169f)
                    curveTo(10.1848f, 13.4075f, 9.3324f, 13.8489f, 9.3324f, 13.8489f)
                    curveTo(9.3324f, 13.8489f, 9.5649f, 14.1786f, 9.0698f, 14.5087f)
                    curveTo(8.5746f, 14.8388f, 8.4359f, 14.9892f, 7.999f, 14.6667f)
                    curveTo(7.5622f, 14.3441f, 7.5384f, 13.9287f, 7.8412f, 13.5657f)
                    curveTo(8.144f, 13.2026f, 8.9088f, 13.4915f, 9.3324f, 13.0679f)
                    curveTo(9.756f, 12.6443f, 9.4892f, 12.183f, 9.999f, 11.3333f)
                    curveTo(10.5089f, 10.4836f, 11.3324f, 10.0f, 11.3324f, 10.0f)
                    curveTo(11.3324f, 10.0f, 10.188f, 10.4473f, 9.0698f, 10.0f)
                    curveTo(7.9515f, 9.5527f, 7.999f, 8.6666f, 7.999f, 8.6666f)
                    close()
                    moveTo(12.3304f, 6.3018f)
                    curveTo(12.3028f, 6.1162f, 11.9058f, 5.9677f, 12.0828f, 5.9222f)
                    curveTo(12.4129f, 5.8372f, 12.5786f, 5.7322f, 12.7409f, 5.4522f)
                    curveTo(12.8122f, 5.3292f, 12.4913f, 5.4098f, 12.5959f, 5.2886f)
                    curveTo(13.1446f, 4.6523f, 13.2588f, 4.1581f, 12.9069f, 3.9922f)
                    curveTo(12.1461f, 3.6334f, 12.0521f, 4.5607f, 12.0828f, 4.1787f)
                    curveTo(12.1047f, 3.9061f, 12.1322f, 3.6873f, 12.1669f, 3.577f)
                    curveTo(12.32f, 3.0899f, 13.0969f, 3.1192f, 13.1446f, 3.0238f)
                    curveTo(13.3398f, 2.6333f, 13.5639f, 2.5965f, 13.9994f, 2.6667f)
                    curveTo(14.4348f, 2.7368f, 14.633f, 2.945f, 14.8062f, 3.2914f)
                    curveTo(14.9374f, 3.5538f, 14.8997f, 3.9617f, 15.0431f, 4.351f)
                    curveTo(15.1358f, 4.6029f, 15.271f, 4.7425f, 15.3726f, 4.9945f)
                    curveTo(15.4317f, 5.1414f, 14.9877f, 4.851f, 15.0431f, 4.9945f)
                    curveTo(15.1942f, 5.3864f, 15.5719f, 5.3695f, 15.7977f, 5.7239f)
                    curveTo(15.8903f, 5.8692f, 15.4568f, 5.6977f, 15.4852f, 5.9222f)
                    curveTo(15.5044f, 6.0738f, 15.9994f, 6.6666f, 15.9994f, 6.6666f)
                    horizontalLineTo(11.9994f)
                    curveTo(11.9994f, 6.6666f, 12.3544f, 6.4626f, 12.3304f, 6.3018f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFEEC55B)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(13.7538f, 2.6366f)
                    curveTo(13.8285f, 2.6405f, 13.912f, 2.6526f, 13.9994f, 2.6667f)
                    curveTo(14.1748f, 2.6949f, 14.3412f, 2.7471f, 14.4887f, 2.8649f)
                    curveTo(14.631f, 2.9786f, 14.7251f, 3.1293f, 14.8062f, 3.2914f)
                    curveTo(14.8666f, 3.4123f, 14.8911f, 3.5586f, 14.9178f, 3.7546f)
                    curveTo(14.9538f, 4.0185f, 14.9667f, 4.092f, 15.0011f, 4.2179f)
                    curveTo(15.0138f, 4.2644f, 15.0274f, 4.3086f, 15.0431f, 4.351f)
                    curveTo(15.0684f, 4.4199f, 15.0931f, 4.4735f, 15.1288f, 4.5398f)
                    lineTo(15.2639f, 4.7902f)
                    lineTo(15.0378f, 4.9629f)
                    curveTo(15.0372f, 4.9634f, 15.0367f, 4.9639f, 15.0363f, 4.9642f)
                    curveTo(15.0363f, 4.9648f, 15.0363f, 4.9656f, 15.0363f, 4.9667f)
                    curveTo(15.0366f, 4.9707f, 15.0374f, 4.9798f, 15.0431f, 4.9945f)
                    curveTo(15.0787f, 5.0869f, 15.1156f, 5.1441f, 15.1596f, 5.1923f)
                    curveTo(15.207f, 5.2442f, 15.2745f, 5.2981f, 15.3902f, 5.3716f)
                    lineTo(15.6764f, 5.5534f)
                    lineTo(15.4896f, 5.8365f)
                    curveTo(15.4895f, 5.8367f, 15.489f, 5.8374f, 15.4883f, 5.8391f)
                    curveTo(15.4876f, 5.8409f, 15.4864f, 5.8444f, 15.4852f, 5.8503f)
                    curveTo(15.483f, 5.8621f, 15.4805f, 5.8849f, 15.4852f, 5.9222f)
                    curveTo(15.4887f, 5.9497f, 15.5042f, 6.0027f, 15.6016f, 6.1459f)
                    lineTo(15.9556f, 6.6666f)
                    horizontalLineTo(13.5382f)
                    lineTo(14.0902f, 7.3182f)
                    lineTo(17.9994f, 6.6666f)
                    curveTo(17.9434f, 6.6226f, 17.8681f, 6.5465f, 17.7974f, 6.4521f)
                    curveTo(17.6417f, 6.2445f, 17.5198f, 5.9695f, 17.6287f, 5.6552f)
                    curveTo(17.7253f, 5.3764f, 17.9787f, 5.1542f, 18.3049f, 4.9537f)
                    curveTo(18.7652f, 4.6708f, 19.4405f, 4.4209f, 20.3327f, 4.2043f)
                    lineTo(25.3723f, 2.9809f)
                    curveTo(25.48f, 2.9547f, 25.5859f, 2.9321f, 25.6751f, 2.9252f)
                    curveTo(25.7194f, 2.9218f, 25.7796f, 2.9205f, 25.8429f, 2.9339f)
                    curveTo(25.9073f, 2.9476f, 26.0064f, 2.9837f, 26.08f, 3.081f)
                    curveTo(26.1552f, 3.1801f, 26.1625f, 3.2879f, 26.1558f, 3.3581f)
                    curveTo(26.1494f, 3.4251f, 26.1284f, 3.4834f, 26.1111f, 3.5242f)
                    curveTo(26.0788f, 3.6003f, 26.029f, 3.6844f, 25.9756f, 3.7683f)
                    curveTo(25.9375f, 3.8479f, 25.8759f, 3.9457f, 25.7896f, 4.0683f)
                    curveTo(25.6891f, 4.2111f, 25.5426f, 4.4043f, 25.3327f, 4.6666f)
                    curveTo(25.0422f, 5.0297f, 24.8576f, 5.2545f, 24.6695f, 5.4428f)
                    curveTo(24.4783f, 5.6343f, 24.2891f, 5.7826f, 23.9994f, 6.0f)
                    curveTo(23.8954f, 6.0779f, 23.8054f, 6.1388f, 23.7107f, 6.186f)
                    curveTo(23.6127f, 6.2348f, 23.5223f, 6.2628f, 23.4257f, 6.287f)
                    lineTo(23.4075f, 6.2915f)
                    curveTo(23.1459f, 6.3564f, 22.992f, 6.4221f, 22.666f, 6.6666f)
                    curveTo(22.4895f, 6.7991f, 22.41f, 6.8639f, 22.32f, 6.9607f)
                    curveTo(22.2223f, 7.0657f, 22.1107f, 7.2105f, 21.8824f, 7.511f)
                    curveTo(21.7085f, 7.74f, 21.5643f, 7.8842f, 21.3327f, 8.0f)
                    curveTo(21.2251f, 8.0538f, 21.1097f, 8.0885f, 20.9903f, 8.1081f)
                    curveTo(20.7356f, 8.1499f, 20.4649f, 8.1239f, 20.217f, 8.0642f)
                    curveTo(20.1227f, 8.0415f, 20.0459f, 8.0178f, 19.9994f, 8.0f)
                    lineTo(19.9997f, 8.6622f)
                    lineTo(20.0001f, 8.6756f)
                    curveTo(20.005f, 8.9023f, 19.9179f, 9.1905f, 19.7005f, 9.4593f)
                    curveTo(19.516f, 9.6875f, 19.2583f, 9.8681f, 18.9286f, 10.0f)
                    lineTo(18.9274f, 10.0006f)
                    lineTo(18.8917f, 10.0146f)
                    lineTo(18.8559f, 10.0279f)
                    lineTo(18.8543f, 10.0285f)
                    curveTo(18.2466f, 10.2502f, 17.598f, 10.2392f, 17.0045f, 10.0994f)
                    curveTo(16.9907f, 10.0961f, 16.9772f, 10.0929f, 16.9641f, 10.0896f)
                    lineTo(16.924f, 10.1722f)
                    curveTo(17.1074f, 10.3078f, 17.3198f, 10.4909f, 17.5301f, 10.7162f)
                    curveTo(17.7089f, 10.9077f, 17.8676f, 11.1138f, 17.9994f, 11.3333f)
                    curveTo(18.2208f, 11.7024f, 18.2849f, 11.9232f, 18.3741f, 12.4083f)
                    curveTo(18.4091f, 12.5987f, 18.442f, 12.719f, 18.4839f, 12.8128f)
                    curveTo(18.523f, 12.9005f, 18.5751f, 12.977f, 18.666f, 13.0679f)
                    curveTo(18.6997f, 13.1016f, 18.7338f, 13.1299f, 18.7683f, 13.1542f)
                    curveTo(18.8413f, 13.1898f, 18.9071f, 13.2229f, 18.9638f, 13.2521f)
                    curveTo(19.0596f, 13.2852f, 19.1765f, 13.3092f, 19.3282f, 13.3265f)
                    curveTo(19.3728f, 13.3312f, 19.394f, 13.3335f, 19.4153f, 13.3355f)
                    curveTo(19.4353f, 13.3375f, 19.4553f, 13.3393f, 19.4946f, 13.3429f)
                    curveTo(19.6442f, 13.3567f, 19.7646f, 13.3718f, 19.8576f, 13.3946f)
                    curveTo(19.9477f, 13.4166f, 20.0675f, 13.458f, 20.1572f, 13.5657f)
                    curveTo(20.2811f, 13.7141f, 20.3894f, 13.9138f, 20.3536f, 14.1505f)
                    curveTo(20.3187f, 14.3804f, 20.1619f, 14.5466f, 19.9994f, 14.6667f)
                    curveTo(19.9272f, 14.7199f, 19.8603f, 14.7642f, 19.7969f, 14.7945f)
                    curveTo(19.7356f, 14.8237f, 19.6399f, 14.8586f, 19.5265f, 14.8407f)
                    lineTo(19.5247f, 14.8405f)
                    curveTo(19.5066f, 14.8376f, 19.4667f, 14.8314f, 19.4184f, 14.8127f)
                    curveTo(19.376f, 14.7964f, 19.3376f, 14.7747f, 19.3037f, 14.7543f)
                    curveTo(19.2379f, 14.7146f, 19.1296f, 14.6424f, 18.9376f, 14.5144f)
                    lineTo(18.9286f, 14.5087f)
                    curveTo(18.8419f, 14.4509f, 18.7524f, 14.3839f, 18.6921f, 14.3012f)
                    curveTo(18.6574f, 14.2537f, 18.6234f, 14.1889f, 18.6124f, 14.1077f)
                    curveTo(18.6013f, 14.0246f, 18.6186f, 13.956f, 18.636f, 13.9102f)
                    lineTo(18.6509f, 13.8707f)
                    lineTo(18.6645f, 13.8516f)
                    curveTo(18.5855f, 13.8193f, 18.5097f, 13.7807f, 18.4368f, 13.7343f)
                    curveTo(18.2839f, 13.6603f, 18.0992f, 13.5751f, 17.8995f, 13.4898f)
                    curveTo(17.7786f, 13.4382f, 17.6619f, 13.3909f, 17.5504f, 13.3487f)
                    curveTo(17.457f, 13.3133f, 17.3686f, 13.282f, 17.2853f, 13.2549f)
                    lineTo(17.1644f, 13.2155f)
                    lineTo(17.1005f, 13.1056f)
                    curveTo(17.0213f, 12.9695f, 16.9359f, 12.8436f, 16.8454f, 12.7274f)
                    curveTo(16.5186f, 12.3078f, 16.1984f, 12.0868f, 15.9994f, 12.0f)
                    verticalLineTo(12.6666f)
                    curveTo(16.1663f, 12.7523f, 16.418f, 12.9019f, 16.6664f, 13.0897f)
                    curveTo(16.8333f, 13.216f, 16.9776f, 13.3462f, 17.0877f, 13.4732f)
                    curveTo(17.1898f, 13.5911f, 17.2935f, 13.7412f, 17.3243f, 13.907f)
                    curveTo(17.3296f, 13.936f, 17.3327f, 13.9672f, 17.3327f, 14.0f)
                    curveTo(17.3327f, 14.0943f, 17.2993f, 14.1812f, 17.2794f, 14.2288f)
                    curveTo(17.2543f, 14.2886f, 17.2209f, 14.3534f, 17.1835f, 14.4191f)
                    curveTo(17.1082f, 14.5514f, 17.0047f, 14.7088f, 16.8847f, 14.8741f)
                    curveTo(16.6452f, 15.2039f, 16.3241f, 15.587f, 15.9994f, 15.8892f)
                    curveTo(15.8876f, 15.9932f, 15.771f, 16.0909f, 15.6494f, 16.1825f)
                    curveTo(15.2881f, 16.4547f, 14.9009f, 16.6637f, 14.5152f, 16.8172f)
                    curveTo(14.4939f, 16.8257f, 14.4729f, 16.8339f, 14.4525f, 16.8417f)
                    lineTo(14.3091f, 16.8968f)
                    lineTo(13.3327f, 17.6813f)
                    verticalLineTo(16.0456f)
                    lineTo(13.7855f, 16.2193f)
                    curveTo(13.8689f, 16.2513f, 13.9409f, 16.2762f, 13.9997f, 16.2948f)
                    verticalLineTo(8.0092f)
                    lineTo(13.3327f, 7.8981f)
                    verticalLineTo(6.6666f)
                    horizontalLineTo(12.3208f)
                    lineTo(12.332f, 6.3225f)
                    curveTo(12.3322f, 6.316f, 12.3315f, 6.3092f, 12.3304f, 6.3018f)
                    curveTo(12.326f, 6.2723f, 12.3191f, 6.2535f, 12.3102f, 6.2377f)
                    lineTo(12.1521f, 5.9544f)
                    lineTo(12.4311f, 5.7887f)
                    curveTo(12.5472f, 5.7197f, 12.6415f, 5.6237f, 12.7409f, 5.4522f)
                    curveTo(12.7564f, 5.4254f, 12.7508f, 5.4093f, 12.7495f, 5.4067f)
                    lineTo(12.6581f, 5.2245f)
                    lineTo(12.7787f, 5.0601f)
                    curveTo(13.0127f, 4.7412f, 13.1123f, 4.4829f, 13.1186f, 4.3079f)
                    curveTo(13.1215f, 4.2271f, 13.1046f, 4.1712f, 13.0788f, 4.1295f)
                    curveTo(13.0527f, 4.0874f, 13.0034f, 4.0377f, 12.9069f, 3.9922f)
                    curveTo(12.7719f, 3.9285f, 12.6595f, 3.9062f, 12.569f, 3.907f)
                    lineTo(11.5383f, 3.9168f)
                    lineTo(12.3682f, 3.3053f)
                    curveTo(12.45f, 3.245f, 12.5463f, 3.2024f, 12.6442f, 3.1697f)
                    curveTo(12.706f, 3.1491f, 12.831f, 3.1187f, 12.9155f, 3.0987f)
                    curveTo(12.9617f, 3.0878f, 13.0037f, 3.0782f, 13.0311f, 3.0721f)
                    curveTo(13.0416f, 3.0697f, 13.0532f, 3.0672f, 13.0623f, 3.0654f)
                    curveTo(13.0914f, 3.0577f, 13.1107f, 3.0519f, 13.1248f, 3.0469f)
                    curveTo(13.1287f, 3.0455f, 13.1318f, 3.0443f, 13.1342f, 3.0433f)
                    curveTo(13.1367f, 3.0393f, 13.14f, 3.033f, 13.1446f, 3.0238f)
                    lineTo(13.1465f, 3.0206f)
                    curveTo(13.1961f, 2.9215f, 13.286f, 2.7416f, 13.4941f, 2.6682f)
                    curveTo(13.5876f, 2.6352f, 13.6794f, 2.6328f, 13.7538f, 2.6366f)
                    close()
                    moveTo(13.0443f, 3.07f)
                    lineTo(13.1169f, 3.356f)
                    lineTo(13.0443f, 3.07f)
                    close()
                    moveTo(13.1169f, 3.356f)
                    curveTo(13.0219f, 3.3164f, 12.9268f, 3.2866f, 12.832f, 3.2671f)
                    lineTo(13.1169f, 3.356f)
                    close()
                    moveTo(13.5023f, 3.6006f)
                    curveTo(13.6153f, 3.5275f, 13.6873f, 3.4297f, 13.7413f, 3.3219f)
                    curveTo(13.7444f, 3.3157f, 13.7472f, 3.31f, 13.7499f, 3.3048f)
                    curveTo(13.7836f, 3.3081f, 13.8292f, 3.3144f, 13.8937f, 3.3248f)
                    curveTo(14.0069f, 3.3431f, 14.0483f, 3.3664f, 14.0727f, 3.3859f)
                    curveTo(14.1024f, 3.4096f, 14.1444f, 3.458f, 14.2102f, 3.5895f)
                    curveTo(14.2094f, 3.5878f, 14.2147f, 3.5972f, 14.2237f, 3.6379f)
                    curveTo(14.233f, 3.6803f, 14.2434f, 3.7432f, 14.2573f, 3.8446f)
                    curveTo(14.2939f, 4.113f, 14.3114f, 4.2228f, 14.3579f, 4.3933f)
                    curveTo(14.3753f, 4.457f, 14.3951f, 4.5196f, 14.4178f, 4.5813f)
                    curveTo(14.4271f, 4.6064f, 14.4364f, 4.6305f, 14.4459f, 4.6539f)
                    curveTo(14.3584f, 4.82f, 14.3407f, 5.0253f, 14.4214f, 5.2345f)
                    curveTo(14.4819f, 5.3913f, 14.5589f, 5.5232f, 14.6674f, 5.6419f)
                    curveTo(14.715f, 5.6941f, 14.7666f, 5.7413f, 14.8214f, 5.7853f)
                    curveTo(14.8136f, 5.8552f, 14.8146f, 5.9271f, 14.8234f, 6.0f)
                    horizontalLineTo(13.1761f)
                    curveTo(13.2267f, 5.9342f, 13.2736f, 5.8631f, 13.318f, 5.7865f)
                    curveTo(13.3995f, 5.646f, 13.4346f, 5.4806f, 13.4114f, 5.3185f)
                    curveTo(13.6266f, 4.9954f, 13.7731f, 4.6563f, 13.7848f, 4.332f)
                    curveTo(13.7918f, 4.1403f, 13.7514f, 3.9494f, 13.6455f, 3.7785f)
                    curveTo(13.605f, 3.7131f, 13.5569f, 3.6539f, 13.5023f, 3.6006f)
                    close()
                    moveTo(14.6664f, 8.1203f)
                    verticalLineTo(16.016f)
                    curveTo(14.8659f, 15.9123f, 15.0616f, 15.7907f, 15.2483f, 15.65f)
                    curveTo(15.3521f, 15.5718f, 15.4513f, 15.4889f, 15.5455f, 15.4012f)
                    curveTo(15.8308f, 15.1357f, 16.1236f, 14.7875f, 16.3452f, 14.4824f)
                    curveTo(16.4557f, 14.3302f, 16.5445f, 14.1941f, 16.604f, 14.0895f)
                    curveTo(16.6246f, 14.0533f, 16.6403f, 14.0233f, 16.6517f, 13.9995f)
                    curveTo(16.6392f, 13.9793f, 16.6182f, 13.9494f, 16.5838f, 13.9097f)
                    curveTo(16.5124f, 13.8273f, 16.4054f, 13.7282f, 16.2642f, 13.6214f)
                    curveTo(16.0487f, 13.4584f, 15.8305f, 13.3291f, 15.6955f, 13.2599f)
                    lineTo(15.333f, 13.074f)
                    verticalLineTo(10.9817f)
                    lineTo(16.2664f, 11.389f)
                    curveTo(16.5856f, 11.5283f, 16.9897f, 11.8277f, 17.3714f, 12.3177f)
                    curveTo(17.4556f, 12.4259f, 17.5356f, 12.5404f, 17.611f, 12.6613f)
                    curveTo(17.6586f, 12.6779f, 17.707f, 12.6954f, 17.7562f, 12.7138f)
                    curveTo(17.7425f, 12.6543f, 17.7302f, 12.5928f, 17.7184f, 12.5289f)
                    curveTo(17.6374f, 12.0882f, 17.5937f, 11.9524f, 17.428f, 11.6763f)
                    curveTo(17.3233f, 11.5018f, 17.1937f, 11.3328f, 17.0428f, 11.1711f)
                    curveTo(16.7642f, 10.8727f, 16.4897f, 10.6693f, 16.3288f, 10.5748f)
                    lineTo(16.0632f, 10.4189f)
                    lineTo(16.6223f, 9.2669f)
                    lineTo(16.9091f, 9.3791f)
                    curveTo(16.9397f, 9.391f, 17.0252f, 9.4193f, 17.1574f, 9.4505f)
                    curveTo(17.6576f, 9.5683f, 18.1684f, 9.5688f, 18.6248f, 9.4026f)
                    curveTo(18.6252f, 9.4025f, 18.6255f, 9.4024f, 18.6258f, 9.4022f)
                    lineTo(18.6536f, 9.3919f)
                    lineTo(18.6814f, 9.381f)
                    curveTo(18.6817f, 9.3809f, 18.6821f, 9.3807f, 18.6824f, 9.3806f)
                    curveTo(18.9272f, 9.2825f, 19.0828f, 9.163f, 19.1821f, 9.0402f)
                    curveTo(19.3116f, 8.88f, 19.3349f, 8.7418f, 19.3334f, 8.6891f)
                    lineTo(19.3329f, 8.6666f)
                    lineTo(19.333f, 7.1203f)
                    lineTo(14.6664f, 7.8981f)
                    verticalLineTo(7.9984f)
                    lineTo(14.7866f, 8.1404f)
                    lineTo(14.6664f, 8.1203f)
                    close()
                    moveTo(19.4952f, 7.0932f)
                    lineTo(20.2379f, 7.3773f)
                    curveTo(20.25f, 7.3819f, 20.2973f, 7.3978f, 20.373f, 7.416f)
                    curveTo(20.563f, 7.4618f, 20.7403f, 7.4736f, 20.8823f, 7.4503f)
                    curveTo(20.9458f, 7.4398f, 20.9958f, 7.4233f, 21.0349f, 7.4037f)
                    curveTo(21.1402f, 7.351f, 21.2104f, 7.2936f, 21.3515f, 7.1078f)
                    curveTo(21.5719f, 6.8177f, 21.7063f, 6.6417f, 21.8318f, 6.5067f)
                    curveTo(21.965f, 6.3635f, 22.0855f, 6.2689f, 22.2664f, 6.1333f)
                    curveTo(22.6526f, 5.8436f, 22.8859f, 5.734f, 23.2466f, 5.6446f)
                    lineTo(23.264f, 5.6402f)
                    curveTo(23.3352f, 5.6224f, 23.3748f, 5.6085f, 23.4135f, 5.5892f)
                    curveTo(23.4554f, 5.5684f, 23.5085f, 5.535f, 23.5997f, 5.4666f)
                    curveTo(23.8872f, 5.251f, 24.0428f, 5.127f, 24.1978f, 4.9718f)
                    curveTo(24.3559f, 4.8134f, 24.5188f, 4.6172f, 24.8125f, 4.2502f)
                    curveTo(25.0095f, 4.0039f, 25.1434f, 3.8271f, 25.233f, 3.7009f)
                    lineTo(20.4903f, 4.8522f)
                    curveTo(19.6258f, 5.062f, 19.0278f, 5.292f, 18.6539f, 5.5217f)
                    curveTo(18.3547f, 5.7056f, 18.2757f, 5.8243f, 18.2586f, 5.8735f)
                    curveTo(18.2536f, 5.8879f, 18.2389f, 5.9297f, 18.3308f, 6.0522f)
                    curveTo(18.3504f, 6.0784f, 18.3698f, 6.1006f, 18.3859f, 6.1175f)
                    curveTo(18.401f, 6.1332f, 18.4103f, 6.1413f, 18.4118f, 6.1425f)
                    curveTo(18.4118f, 6.1426f, 18.4119f, 6.1427f, 18.4118f, 6.1425f)
                    lineTo(19.5983f, 7.0761f)
                    lineTo(19.4952f, 7.0932f)
                    close()
                    moveTo(25.4992f, 3.2591f)
                    curveTo(25.4992f, 3.2591f, 25.499f, 3.2597f, 25.4986f, 3.2608f)
                    lineTo(25.4992f, 3.2591f)
                    close()
                    moveTo(19.3731f, 14.0035f)
                    curveTo(19.4718f, 14.0692f, 19.5385f, 14.1135f, 19.5852f, 14.1438f)
                    curveTo(19.5911f, 14.1396f, 19.5972f, 14.1351f, 19.6037f, 14.1303f)
                    curveTo(19.6508f, 14.0956f, 19.6759f, 14.0695f, 19.6884f, 14.0535f)
                    curveTo(19.6861f, 14.0492f, 19.6831f, 14.044f, 19.6792f, 14.0377f)
                    curveTo(19.6345f, 14.0287f, 19.5596f, 14.0184f, 19.4339f, 14.0068f)
                    curveTo(19.4338f, 14.0068f, 19.434f, 14.0068f, 19.4339f, 14.0068f)
                    moveTo(19.6945f, 14.0687f)
                    curveTo(19.6944f, 14.0687f, 19.6942f, 14.0679f, 19.694f, 14.0664f)
                    lineTo(19.6945f, 14.0687f)
                    close()
                    moveTo(19.3731f, 14.0035f)
                    lineTo(19.3746f, 14.0014f)
                    lineTo(19.3731f, 14.0035f)
                    close()
                    moveTo(10.5073f, 12.621f)
                    curveTo(10.5554f, 12.6053f, 10.6028f, 12.5906f, 10.6492f, 12.577f)
                    lineTo(10.9529f, 13.1558f)
                    lineTo(10.7527f, 13.3182f)
                    lineTo(10.2489f, 12.9019f)
                    curveTo(10.2728f, 12.8573f, 10.2973f, 12.8134f, 10.3224f, 12.7703f)
                    lineTo(10.3864f, 12.6604f)
                    lineTo(10.5073f, 12.621f)
                    close()
                    moveTo(9.0262f, 13.2568f)
                    curveTo(9.0905f, 13.2235f, 9.1669f, 13.1852f, 9.2527f, 13.1435f)
                    lineTo(9.5823f, 13.7213f)
                    curveTo(9.5033f, 13.7736f, 9.4209f, 13.8164f, 9.3347f, 13.8515f)
                    lineTo(9.3399f, 13.8595f)
                    curveTo(9.3399f, 13.8595f, 9.3399f, 13.8595f, 9.3399f, 13.8595f)
                    curveTo(9.3382f, 13.8565f, 9.3362f, 13.854f, 9.3347f, 13.8515f)
                    curveTo(9.3303f, 13.8534f, 9.3257f, 13.8552f, 9.3212f, 13.857f)
                    lineTo(9.1214f, 13.9979f)
                    lineTo(9.156f, 13.984f)
                    moveTo(8.7406f, 14.1489f)
                    curveTo(8.7403f, 14.148f, 8.7399f, 14.1471f, 8.7396f, 14.1461f)
                    curveTo(8.7369f, 14.1393f, 8.7332f, 14.1288f, 8.7295f, 14.1158f)
                    curveTo(8.7277f, 14.1091f, 8.7255f, 14.1007f, 8.7236f, 14.0907f)
                    curveTo(8.7217f, 14.081f, 8.7195f, 14.0679f, 8.7183f, 14.0524f)
                    curveTo(8.7171f, 14.0373f, 8.7164f, 14.0156f, 8.7193f, 13.9898f)
                    curveTo(8.7221f, 13.9644f, 8.7291f, 13.9276f, 8.7479f, 13.8867f)
                    curveTo(8.7675f, 13.8441f, 8.8004f, 13.7969f, 8.8518f, 13.7587f)
                    curveTo(8.8521f, 13.7585f, 8.8524f, 13.7583f, 8.8527f, 13.7581f)
                    curveTo(8.8247f, 13.7788f, 8.8013f, 13.8028f, 8.7827f, 13.828f)
                    curveTo(8.753f, 13.8681f, 8.7379f, 13.9074f, 8.7299f, 13.9356f)
                    curveTo(8.7218f, 13.9641f, 8.719f, 13.9886f, 8.7179f, 14.0057f)
                    curveTo(8.7159f, 14.0385f, 8.7192f, 14.0645f, 8.7212f, 14.0772f)
                    curveTo(8.7234f, 14.0917f, 8.7262f, 14.1033f, 8.7282f, 14.1107f)
                    curveTo(8.7302f, 14.1185f, 8.7322f, 14.125f, 8.7338f, 14.1297f)
                    curveTo(8.7362f, 14.1374f, 8.7389f, 14.1445f, 8.7406f, 14.1489f)
                    curveTo(8.7403f, 14.148f, 8.7399f, 14.1471f, 8.7396f, 14.1461f)
                    lineTo(8.7413f, 14.1504f)
                    lineTo(9.0506f, 14.0263f)
                    moveTo(8.7406f, 14.1489f)
                    lineTo(8.7547f, 14.186f)
                    lineTo(8.7879f, 14.2331f)
                    curveTo(8.792f, 14.2383f, 8.7991f, 14.2453f, 8.8071f, 14.254f)
                    curveTo(8.8121f, 14.2593f, 8.8197f, 14.267f, 8.8296f, 14.2758f)
                    curveTo(8.8346f, 14.2803f, 8.8411f, 14.2857f, 8.8489f, 14.2916f)
                    curveTo(8.8565f, 14.2974f, 8.8668f, 14.3048f, 8.8796f, 14.3124f)
                    curveTo(8.8921f, 14.3199f, 8.9101f, 14.3296f, 8.933f, 14.3382f)
                    curveTo(8.9554f, 14.3466f, 8.989f, 14.3566f, 9.0308f, 14.359f)
                    curveTo(9.0742f, 14.3616f, 9.1286f, 14.3562f, 9.1851f, 14.3313f)
                    curveTo(9.1854f, 14.3311f, 9.1858f, 14.331f, 9.1861f, 14.3308f)
                    curveTo(9.2074f, 14.3213f, 9.2288f, 14.3092f, 9.2494f, 14.2938f)
                    curveTo(9.2533f, 14.2909f, 9.2571f, 14.288f, 9.2608f, 14.285f)
                    moveTo(8.7888f, 14.2325f)
                    lineTo(9.1401f, 13.9947f)
                    lineTo(9.3631f, 13.9102f)
                    curveTo(9.3656f, 13.9169f, 9.3687f, 13.9259f, 9.3717f, 13.9367f)
                    curveTo(9.3749f, 13.9482f, 9.3806f, 13.9709f, 9.3829f, 14.0001f)
                    curveTo(9.3841f, 14.0153f, 9.3848f, 14.0369f, 9.3819f, 14.0628f)
                    curveTo(9.3791f, 14.0881f, 9.3722f, 14.125f, 9.3533f, 14.1658f)
                    curveTo(9.3444f, 14.1853f, 9.3327f, 14.2056f, 9.3177f, 14.2257f)
                    curveTo(9.3052f, 14.2413f, 9.2785f, 14.2694f, 9.2627f, 14.2834f)
                    curveTo(9.2624f, 14.2837f, 9.2621f, 14.284f, 9.2618f, 14.2842f)
                    moveTo(9.2627f, 14.2834f)
                    curveTo(9.2846f, 14.2654f, 9.3028f, 14.2457f, 9.3177f, 14.2257f)
                    curveTo(9.318f, 14.2253f, 9.3183f, 14.225f, 9.3186f, 14.2246f)
                    curveTo(9.3483f, 14.1845f, 9.3634f, 14.1452f, 9.3714f, 14.117f)
                    curveTo(9.3794f, 14.0885f, 9.3823f, 14.064f, 9.3833f, 14.0469f)
                    curveTo(9.3844f, 14.0294f, 9.3839f, 14.0145f, 9.3832f, 14.0036f)
                    curveTo(9.3824f, 13.9924f, 9.3812f, 13.9829f, 9.3801f, 13.9754f)
                    curveTo(9.3778f, 13.9609f, 9.375f, 13.9493f, 9.3731f, 13.9419f)
                    curveTo(9.371f, 13.9341f, 9.3691f, 13.9276f, 9.3675f, 13.9229f)
                    curveTo(9.3659f, 13.9181f, 9.3644f, 13.9138f, 9.3631f, 13.9102f)
                    lineTo(9.3623f, 13.9081f)
                    curveTo(9.3614f, 13.9058f, 9.3606f, 13.9038f, 9.36f, 13.9022f)
                    curveTo(9.3554f, 13.8907f, 9.3511f, 13.8819f, 9.3485f, 13.8768f)
                    curveTo(9.3454f, 13.8704f, 9.3428f, 13.8644f, 9.3399f, 13.8595f)
                    lineTo(9.156f, 13.984f)
                    moveTo(8.7888f, 14.2325f)
                    lineTo(8.7906f, 14.2349f)
                    curveTo(8.7927f, 14.2374f, 8.7971f, 14.2428f, 8.803f, 14.2494f)
                    curveTo(8.806f, 14.2527f, 8.8111f, 14.2582f, 8.8177f, 14.2647f)
                    curveTo(8.8211f, 14.268f, 8.8258f, 14.2725f, 8.8316f, 14.2776f)
                    curveTo(8.8371f, 14.2824f, 8.8458f, 14.2896f, 8.8571f, 14.2977f)
                    curveTo(8.8671f, 14.3048f, 8.8873f, 14.3185f, 8.9155f, 14.331f)
                    curveTo(8.9301f, 14.3375f, 8.9516f, 14.3457f, 8.9786f, 14.3517f)
                    curveTo(9.0052f, 14.3576f, 9.0447f, 14.3629f, 9.0919f, 14.357f)
                    curveTo(9.1218f, 14.3533f, 9.1539f, 14.3451f, 9.1861f, 14.3308f)
                    curveTo(9.2063f, 14.3209f, 9.2428f, 14.2985f, 9.2608f, 14.285f)
                    moveTo(8.9303f, 13.7155f)
                    curveTo(8.9095f, 13.7244f, 8.8716f, 13.7452f, 8.8527f, 13.7581f)
                    curveTo(8.8717f, 13.744f, 8.8929f, 13.7316f, 8.9161f, 13.7213f)
                    curveTo(8.9209f, 13.7192f, 8.9256f, 13.7173f, 8.9303f, 13.7155f)
                    close()
                    moveTo(8.9325f, 13.7146f)
                    curveTo(8.9586f, 13.7047f, 8.984f, 13.6988f, 9.0078f, 13.6957f)
                    curveTo(8.9886f, 13.6989f, 8.9521f, 13.7079f, 8.9325f, 13.7146f)
                    close()
                    moveTo(8.9325f, 13.7146f)
                    curveTo(8.9318f, 13.7149f, 8.931f, 13.7152f, 8.9303f, 13.7155f)
                    curveTo(8.9306f, 13.7153f, 8.931f, 13.7151f, 8.9314f, 13.715f)
                    curveTo(8.9317f, 13.7149f, 8.9321f, 13.7147f, 8.9325f, 13.7146f)
                    close()
                    moveTo(9.2813f, 13.8663f)
                    lineTo(9.0594f, 14.0227f)
                    lineTo(9.2813f, 13.8663f)
                    close()
                    moveTo(9.2273f, 13.7436f)
                    lineTo(9.0153f, 13.2625f)
                    lineTo(9.0262f, 13.2568f)
                    moveTo(9.2273f, 13.7436f)
                    curveTo(9.2255f, 13.7425f, 9.2236f, 13.7414f, 9.2217f, 13.7402f)
                    curveTo(9.2129f, 13.7349f, 9.2007f, 13.7282f, 9.1857f, 13.7215f)
                    curveTo(9.1711f, 13.7151f, 9.1496f, 13.7068f, 9.1226f, 13.7008f)
                    curveTo(9.096f, 13.6949f, 9.0566f, 13.6896f, 9.0093f, 13.6955f)
                    curveTo(9.0088f, 13.6956f, 9.0083f, 13.6957f, 9.0078f, 13.6957f)
                    curveTo(9.0303f, 13.6928f, 9.0514f, 13.6924f, 9.0704f, 13.6936f)
                    curveTo(9.1123f, 13.696f, 9.1459f, 13.706f, 9.1683f, 13.7144f)
                    curveTo(9.1911f, 13.723f, 9.2093f, 13.7328f, 9.2217f, 13.7402f)
                    curveTo(9.2236f, 13.7414f, 9.2255f, 13.7425f, 9.2273f, 13.7436f)
                    lineTo(9.2813f, 13.8663f)
                    lineTo(9.2273f, 13.7436f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF2F2F2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(10.6665f, 8.6667f)
                    verticalLineTo(5.3334f)
                    curveTo(10.6665f, 5.3334f, 11.3311f, 5.9854f, 12.2169f, 5.9854f)
                    curveTo(13.1028f, 5.9854f, 13.9998f, 5.3334f, 13.9998f, 5.3334f)
                    curveTo(13.9998f, 5.3334f, 14.8353f, 5.9854f, 15.6679f, 5.9854f)
                    curveTo(16.5006f, 5.9854f, 17.3331f, 5.3334f, 17.3331f, 5.3334f)
                    verticalLineTo(8.6667f)
                    curveTo(17.3331f, 12.0f, 13.9998f, 13.3334f, 13.9998f, 13.3334f)
                    curveTo(13.9998f, 13.3334f, 10.6665f, 12.0f, 10.6665f, 8.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1E357F)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3331f, 5.3334f)
                    horizontalLineTo(10.6665f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(17.3331f)
                    verticalLineTo(5.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFBC1443)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(10.6665f, 8.0f)
                    lineTo(11.9997f, 8.0f)
                    verticalLineTo(13.3334f)
                    horizontalLineTo(10.6663f)
                    lineTo(10.6665f, 8.0f)
                    close()
                    moveTo(13.333f, 8.0f)
                    horizontalLineTo(14.6663f)
                    verticalLineTo(13.3334f)
                    horizontalLineTo(13.333f)
                    verticalLineTo(8.0f)
                    close()
                    moveTo(15.9997f, 8.0f)
                    lineTo(17.3331f, 8.0f)
                    lineTo(17.333f, 13.3334f)
                    horizontalLineTo(15.9997f)
                    verticalLineTo(8.0f)
                    close()
                }
            }
        }
        .build()
        return _vi!!
    }

private var _vi: ImageVector? = null
