package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.UsCa: ImageVector
    get() {
        if (_usCa != null) {
            return _usCa!!
        }
        _usCa = Builder(name = "UsCa", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp,
                viewportWidth = 28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 0.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE7413D)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 16.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(16.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 0.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(16.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF414B52)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(4.4442f, 14.1387f)
                    horizontalLineTo(4.4455f)
                    curveTo(4.4757f, 14.1529f, 4.4993f, 14.1734f, 4.5162f, 14.2f)
                    curveTo(4.5331f, 14.2267f, 4.5415f, 14.256f, 4.5415f, 14.288f)
                    curveTo(4.5415f, 14.32f, 4.5317f, 14.3511f, 4.5122f, 14.3814f)
                    curveTo(4.3913f, 14.5538f, 4.2233f, 14.64f, 4.0082f, 14.64f)
                    curveTo(3.8571f, 14.64f, 3.7308f, 14.5982f, 3.6295f, 14.5147f)
                    curveTo(3.5282f, 14.4311f, 3.4535f, 14.3187f, 3.4055f, 14.1774f)
                    curveTo(3.3575f, 14.036f, 3.3335f, 13.8791f, 3.3335f, 13.7067f)
                    curveTo(3.3335f, 13.536f, 3.3575f, 13.38f, 3.4055f, 13.2387f)
                    curveTo(3.4535f, 13.0974f, 3.5282f, 12.9845f, 3.6295f, 12.9f)
                    curveTo(3.7308f, 12.8156f, 3.8571f, 12.7734f, 4.0082f, 12.7734f)
                    curveTo(4.2108f, 12.7734f, 4.3717f, 12.8516f, 4.4908f, 13.008f)
                    curveTo(4.514f, 13.0365f, 4.5255f, 13.0694f, 4.5255f, 13.1067f)
                    curveTo(4.5255f, 13.1369f, 4.5184f, 13.1645f, 4.5042f, 13.1894f)
                    curveTo(4.49f, 13.2142f, 4.4695f, 13.2347f, 4.4429f, 13.2507f)
                    lineTo(4.4375f, 13.2534f)
                    curveTo(4.4144f, 13.2676f, 4.3868f, 13.2747f, 4.3548f, 13.2747f)
                    curveTo(4.3015f, 13.2747f, 4.2589f, 13.2542f, 4.2269f, 13.2134f)
                    curveTo(4.1664f, 13.1369f, 4.0935f, 13.0987f, 4.0082f, 13.0987f)
                    curveTo(3.9051f, 13.0987f, 3.8228f, 13.1534f, 3.7615f, 13.2627f)
                    curveTo(3.7002f, 13.372f, 3.6695f, 13.52f, 3.6695f, 13.7067f)
                    curveTo(3.6695f, 13.8969f, 3.7002f, 14.0462f, 3.7615f, 14.1547f)
                    curveTo(3.8228f, 14.2631f, 3.9051f, 14.3174f, 4.0082f, 14.3174f)
                    curveTo(4.1006f, 14.3174f, 4.1771f, 14.2756f, 4.2375f, 14.192f)
                    curveTo(4.2535f, 14.1689f, 4.2735f, 14.1511f, 4.2975f, 14.1387f)
                    curveTo(4.3215f, 14.1262f, 4.3468f, 14.12f, 4.3735f, 14.12f)
                    curveTo(4.3984f, 14.12f, 4.4215f, 14.1254f, 4.4429f, 14.136f)
                    lineTo(4.4442f, 14.1387f)
                    close()
                    moveTo(5.6002f, 14.64f)
                    curveTo(5.6926f, 14.64f, 5.7389f, 14.6f, 5.7389f, 14.52f)
                    curveTo(5.7389f, 14.5005f, 5.7362f, 14.4791f, 5.7309f, 14.456f)
                    lineTo(5.3602f, 12.9067f)
                    curveTo(5.3513f, 12.8711f, 5.3317f, 12.84f, 5.3015f, 12.8134f)
                    curveTo(5.2713f, 12.7867f, 5.2375f, 12.7734f, 5.2002f, 12.7734f)
                    horizontalLineTo(5.0642f)
                    curveTo(5.0286f, 12.7734f, 4.9957f, 12.7867f, 4.9655f, 12.8134f)
                    curveTo(4.9353f, 12.84f, 4.9157f, 12.8711f, 4.9068f, 12.9067f)
                    lineTo(4.5388f, 14.4507f)
                    curveTo(4.5317f, 14.4774f, 4.5282f, 14.5022f, 4.5282f, 14.5254f)
                    curveTo(4.5282f, 14.5716f, 4.5406f, 14.6022f, 4.5655f, 14.6174f)
                    curveTo(4.5904f, 14.6325f, 4.6224f, 14.64f, 4.6615f, 14.64f)
                    horizontalLineTo(4.7175f)
                    curveTo(4.7584f, 14.64f, 4.7913f, 14.6311f, 4.8162f, 14.6134f)
                    curveTo(4.8411f, 14.5956f, 4.8606f, 14.5627f, 4.8748f, 14.5147f)
                    lineTo(4.9149f, 14.368f)
                    curveTo(4.9166f, 14.3609f, 4.922f, 14.3422f, 4.9309f, 14.312f)
                    curveTo(4.9397f, 14.2818f, 4.9535f, 14.2591f, 4.9722f, 14.244f)
                    curveTo(4.9908f, 14.2289f, 5.0153f, 14.2214f, 5.0455f, 14.2214f)
                    horizontalLineTo(5.2135f)
                    curveTo(5.258f, 14.2214f, 5.2877f, 14.2334f, 5.3028f, 14.2574f)
                    curveTo(5.318f, 14.2814f, 5.3309f, 14.3182f, 5.3415f, 14.368f)
                    lineTo(5.3815f, 14.5147f)
                    curveTo(5.3957f, 14.5627f, 5.4153f, 14.5956f, 5.4402f, 14.6134f)
                    curveTo(5.4651f, 14.6311f, 5.4988f, 14.64f, 5.5415f, 14.64f)
                    horizontalLineTo(5.6002f)
                    close()
                    moveTo(5.2269f, 13.7574f)
                    curveTo(5.234f, 13.7929f, 5.2375f, 13.8196f, 5.2375f, 13.8374f)
                    curveTo(5.2375f, 13.8889f, 5.21f, 13.9147f, 5.1549f, 13.9147f)
                    horizontalLineTo(5.1122f)
                    curveTo(5.0553f, 13.9147f, 5.0269f, 13.8854f, 5.0269f, 13.8267f)
                    curveTo(5.0269f, 13.8018f, 5.0295f, 13.7778f, 5.0349f, 13.7547f)
                    lineTo(5.0695f, 13.5627f)
                    lineTo(5.1095f, 13.3654f)
                    curveTo(5.1113f, 13.3582f, 5.1144f, 13.352f, 5.1189f, 13.3467f)
                    curveTo(5.1233f, 13.3414f, 5.1273f, 13.3387f, 5.1308f, 13.3387f)
                    curveTo(5.1433f, 13.3387f, 5.1504f, 13.3494f, 5.1522f, 13.3707f)
                    lineTo(5.1895f, 13.5627f)
                    lineTo(5.2269f, 13.7574f)
                    close()
                    moveTo(6.7415f, 14.64f)
                    curveTo(6.7806f, 14.64f, 6.8131f, 14.6271f, 6.8389f, 14.6014f)
                    curveTo(6.8646f, 14.5756f, 6.8775f, 14.544f, 6.8775f, 14.5067f)
                    verticalLineTo(14.4427f)
                    curveTo(6.8775f, 14.4036f, 6.8646f, 14.3716f, 6.8389f, 14.3467f)
                    curveTo(6.8131f, 14.3218f, 6.7806f, 14.3094f, 6.7415f, 14.3094f)
                    horizontalLineTo(6.3629f)
                    curveTo(6.3237f, 14.3094f, 6.2913f, 14.296f, 6.2655f, 14.2694f)
                    curveTo(6.2397f, 14.2427f, 6.2269f, 14.2107f, 6.2269f, 14.1734f)
                    verticalLineTo(12.9067f)
                    curveTo(6.2269f, 12.8694f, 6.214f, 12.8378f, 6.1882f, 12.812f)
                    curveTo(6.1624f, 12.7862f, 6.1308f, 12.7734f, 6.0935f, 12.7734f)
                    horizontalLineTo(6.0108f)
                    curveTo(5.9753f, 12.7734f, 5.9442f, 12.7862f, 5.9175f, 12.812f)
                    curveTo(5.8909f, 12.8378f, 5.8775f, 12.8694f, 5.8775f, 12.9067f)
                    verticalLineTo(14.5067f)
                    curveTo(5.8775f, 14.544f, 5.8909f, 14.5756f, 5.9175f, 14.6014f)
                    curveTo(5.9442f, 14.6271f, 5.9753f, 14.64f, 6.0108f, 14.64f)
                    horizontalLineTo(6.7415f)
                    close()
                    moveTo(7.2348f, 14.64f)
                    curveTo(7.2722f, 14.64f, 7.3042f, 14.6271f, 7.3309f, 14.6014f)
                    curveTo(7.3575f, 14.5756f, 7.3709f, 14.544f, 7.3709f, 14.5067f)
                    verticalLineTo(12.904f)
                    curveTo(7.3709f, 12.8685f, 7.3575f, 12.8378f, 7.3309f, 12.812f)
                    curveTo(7.3042f, 12.7862f, 7.2722f, 12.7734f, 7.2348f, 12.7734f)
                    horizontalLineTo(7.1549f)
                    curveTo(7.1193f, 12.7734f, 7.0882f, 12.7862f, 7.0615f, 12.812f)
                    curveTo(7.0349f, 12.8378f, 7.0215f, 12.8685f, 7.0215f, 12.904f)
                    verticalLineTo(14.5067f)
                    curveTo(7.0215f, 14.544f, 7.0349f, 14.5756f, 7.0615f, 14.6014f)
                    curveTo(7.0882f, 14.6271f, 7.1193f, 14.64f, 7.1549f, 14.64f)
                    horizontalLineTo(7.2348f)
                    close()
                    moveTo(7.8882f, 14.64f)
                    curveTo(7.9255f, 14.64f, 7.9575f, 14.6271f, 7.9842f, 14.6014f)
                    curveTo(8.0108f, 14.5756f, 8.0242f, 14.544f, 8.0242f, 14.5067f)
                    verticalLineTo(13.9707f)
                    curveTo(8.0242f, 13.9334f, 8.0371f, 13.9014f, 8.0628f, 13.8747f)
                    curveTo(8.0886f, 13.848f, 8.1202f, 13.8347f, 8.1575f, 13.8347f)
                    horizontalLineTo(8.4322f)
                    curveTo(8.4677f, 13.8347f, 8.4984f, 13.8218f, 8.5242f, 13.796f)
                    curveTo(8.55f, 13.7702f, 8.5628f, 13.7396f, 8.5628f, 13.704f)
                    verticalLineTo(13.6347f)
                    curveTo(8.5628f, 13.5991f, 8.55f, 13.568f, 8.5242f, 13.5414f)
                    curveTo(8.4984f, 13.5147f, 8.4677f, 13.5014f, 8.4322f, 13.5014f)
                    horizontalLineTo(8.1575f)
                    curveTo(8.1184f, 13.5014f, 8.0864f, 13.4885f, 8.0615f, 13.4627f)
                    curveTo(8.0366f, 13.4369f, 8.0242f, 13.4054f, 8.0242f, 13.368f)
                    verticalLineTo(13.24f)
                    curveTo(8.0242f, 13.2027f, 8.0366f, 13.1711f, 8.0615f, 13.1454f)
                    curveTo(8.0864f, 13.1196f, 8.1184f, 13.1067f, 8.1575f, 13.1067f)
                    horizontalLineTo(8.5335f)
                    curveTo(8.5709f, 13.1067f, 8.6028f, 13.0938f, 8.6295f, 13.068f)
                    curveTo(8.6562f, 13.0422f, 8.6695f, 13.0107f, 8.6695f, 12.9734f)
                    verticalLineTo(12.9067f)
                    curveTo(8.6695f, 12.8711f, 8.6562f, 12.84f, 8.6295f, 12.8134f)
                    curveTo(8.6028f, 12.7867f, 8.5709f, 12.7734f, 8.5335f, 12.7734f)
                    horizontalLineTo(7.8082f)
                    curveTo(7.7726f, 12.7734f, 7.7415f, 12.7867f, 7.7148f, 12.8134f)
                    curveTo(7.6882f, 12.84f, 7.6748f, 12.8711f, 7.6748f, 12.9067f)
                    verticalLineTo(14.5067f)
                    curveTo(7.6748f, 14.544f, 7.6877f, 14.5756f, 7.7135f, 14.6014f)
                    curveTo(7.7393f, 14.6271f, 7.7709f, 14.64f, 7.8082f, 14.64f)
                    horizontalLineTo(7.8882f)
                    close()
                    moveTo(8.7522f, 14.1774f)
                    curveTo(8.8002f, 14.3187f, 8.8749f, 14.4311f, 8.9762f, 14.5147f)
                    curveTo(9.0775f, 14.5982f, 9.2037f, 14.64f, 9.3548f, 14.64f)
                    curveTo(9.506f, 14.64f, 9.6326f, 14.5982f, 9.7348f, 14.5147f)
                    curveTo(9.8371f, 14.4311f, 9.9126f, 14.3187f, 9.9615f, 14.1774f)
                    curveTo(10.0104f, 14.036f, 10.0349f, 13.8791f, 10.0349f, 13.7067f)
                    curveTo(10.0349f, 13.536f, 10.0104f, 13.38f, 9.9615f, 13.2387f)
                    curveTo(9.9126f, 13.0974f, 9.8371f, 12.9845f, 9.7348f, 12.9f)
                    curveTo(9.6326f, 12.8156f, 9.506f, 12.7734f, 9.3548f, 12.7734f)
                    curveTo(9.2037f, 12.7734f, 9.0775f, 12.8156f, 8.9762f, 12.9f)
                    curveTo(8.8749f, 12.9845f, 8.8002f, 13.0974f, 8.7522f, 13.2387f)
                    curveTo(8.7042f, 13.38f, 8.6802f, 13.536f, 8.6802f, 13.7067f)
                    curveTo(8.6802f, 13.8791f, 8.7042f, 14.036f, 8.7522f, 14.1774f)
                    close()
                    moveTo(9.6068f, 14.1547f)
                    curveTo(9.5437f, 14.2631f, 9.4597f, 14.3174f, 9.3548f, 14.3174f)
                    curveTo(9.2517f, 14.3174f, 9.1695f, 14.2631f, 9.1082f, 14.1547f)
                    curveTo(9.0469f, 14.0462f, 9.0162f, 13.8969f, 9.0162f, 13.7067f)
                    curveTo(9.0162f, 13.52f, 9.0469f, 13.372f, 9.1082f, 13.2627f)
                    curveTo(9.1695f, 13.1534f, 9.2517f, 13.0987f, 9.3548f, 13.0987f)
                    curveTo(9.4597f, 13.0987f, 9.5437f, 13.1534f, 9.6068f, 13.2627f)
                    curveTo(9.67f, 13.372f, 9.7015f, 13.52f, 9.7015f, 13.7067f)
                    curveTo(9.7015f, 13.8969f, 9.67f, 14.0462f, 9.6068f, 14.1547f)
                    close()
                    moveTo(11.3388f, 14.4107f)
                    curveTo(11.3495f, 14.4302f, 11.3548f, 14.4498f, 11.3548f, 14.4694f)
                    curveTo(11.3548f, 14.4925f, 11.3469f, 14.5147f, 11.3308f, 14.536f)
                    lineTo(11.2909f, 14.584f)
                    curveTo(11.2446f, 14.6356f, 11.1984f, 14.6614f, 11.1522f, 14.6614f)
                    curveTo(11.1255f, 14.6614f, 11.1015f, 14.6507f, 11.0802f, 14.6294f)
                    curveTo(10.9913f, 14.5529f, 10.9242f, 14.4698f, 10.8788f, 14.38f)
                    curveTo(10.8335f, 14.2902f, 10.8011f, 14.2071f, 10.7815f, 14.1307f)
                    curveTo(10.7744f, 14.1005f, 10.7602f, 14.0778f, 10.7388f, 14.0627f)
                    curveTo(10.7175f, 14.0476f, 10.6917f, 14.04f, 10.6615f, 14.04f)
                    curveTo(10.5673f, 14.04f, 10.5202f, 14.08f, 10.5202f, 14.16f)
                    verticalLineTo(14.5307f)
                    curveTo(10.5202f, 14.5627f, 10.5104f, 14.5902f, 10.4908f, 14.6134f)
                    curveTo(10.4713f, 14.6365f, 10.4411f, 14.648f, 10.4002f, 14.648f)
                    horizontalLineTo(10.3175f)
                    curveTo(10.2748f, 14.648f, 10.2397f, 14.636f, 10.2122f, 14.612f)
                    curveTo(10.1846f, 14.588f, 10.1708f, 14.5609f, 10.1708f, 14.5307f)
                    verticalLineTo(12.888f)
                    curveTo(10.1708f, 12.8578f, 10.1846f, 12.8311f, 10.2122f, 12.808f)
                    curveTo(10.2397f, 12.7849f, 10.2748f, 12.7734f, 10.3175f, 12.7734f)
                    horizontalLineTo(10.7175f)
                    curveTo(10.8455f, 12.7734f, 10.9531f, 12.8027f, 11.0402f, 12.8614f)
                    curveTo(11.1273f, 12.92f, 11.1917f, 12.9956f, 11.2335f, 13.088f)
                    curveTo(11.2753f, 13.1805f, 11.2962f, 13.2774f, 11.2962f, 13.3787f)
                    curveTo(11.2962f, 13.5582f, 11.2286f, 13.7218f, 11.0935f, 13.8694f)
                    curveTo(11.0828f, 13.8818f, 11.0757f, 13.8934f, 11.0722f, 13.904f)
                    curveTo(11.0686f, 13.9147f, 11.0668f, 13.9218f, 11.0668f, 13.9254f)
                    curveTo(11.0651f, 13.9431f, 11.0722f, 13.9782f, 11.0882f, 14.0307f)
                    curveTo(11.1042f, 14.0831f, 11.13f, 14.1396f, 11.1655f, 14.2f)
                    curveTo(11.2011f, 14.2605f, 11.2446f, 14.3129f, 11.2962f, 14.3574f)
                    curveTo(11.314f, 14.3734f, 11.3282f, 14.3911f, 11.3388f, 14.4107f)
                    close()
                    moveTo(10.8749f, 13.6f)
                    curveTo(10.9229f, 13.536f, 10.9468f, 13.4622f, 10.9468f, 13.3787f)
                    curveTo(10.9468f, 13.3005f, 10.9229f, 13.2329f, 10.8749f, 13.176f)
                    curveTo(10.8268f, 13.1191f, 10.7557f, 13.0907f, 10.6615f, 13.0907f)
                    curveTo(10.6206f, 13.0907f, 10.5869f, 13.1022f, 10.5602f, 13.1254f)
                    curveTo(10.5335f, 13.1485f, 10.5202f, 13.1751f, 10.5202f, 13.2054f)
                    verticalLineTo(13.5814f)
                    curveTo(10.5202f, 13.6222f, 10.5322f, 13.6516f, 10.5562f, 13.6694f)
                    curveTo(10.5802f, 13.6871f, 10.6153f, 13.696f, 10.6615f, 13.696f)
                    curveTo(10.7557f, 13.696f, 10.8268f, 13.664f, 10.8749f, 13.6f)
                    close()
                    moveTo(12.4215f, 14.616f)
                    curveTo(12.4482f, 14.632f, 12.4722f, 14.64f, 12.4935f, 14.64f)
                    horizontalLineTo(12.5709f)
                    curveTo(12.6046f, 14.64f, 12.6344f, 14.6262f, 12.6602f, 14.5987f)
                    curveTo(12.686f, 14.5711f, 12.6988f, 14.5387f, 12.6988f, 14.5014f)
                    verticalLineTo(12.9147f)
                    curveTo(12.6988f, 12.8738f, 12.686f, 12.84f, 12.6602f, 12.8134f)
                    curveTo(12.6344f, 12.7867f, 12.6046f, 12.7734f, 12.5709f, 12.7734f)
                    horizontalLineTo(12.5282f)
                    curveTo(12.4873f, 12.7734f, 12.4535f, 12.7867f, 12.4268f, 12.8134f)
                    curveTo(12.4002f, 12.84f, 12.3868f, 12.8738f, 12.3868f, 12.9147f)
                    verticalLineTo(13.784f)
                    curveTo(12.3868f, 13.8267f, 12.3824f, 13.848f, 12.3735f, 13.848f)
                    curveTo(12.3682f, 13.848f, 12.3566f, 13.8311f, 12.3388f, 13.7974f)
                    lineTo(11.8668f, 12.864f)
                    curveTo(11.8544f, 12.8374f, 11.8344f, 12.8156f, 11.8068f, 12.7987f)
                    curveTo(11.7793f, 12.7818f, 11.7477f, 12.7734f, 11.7122f, 12.7734f)
                    horizontalLineTo(11.6348f)
                    curveTo(11.594f, 12.7734f, 11.5602f, 12.7867f, 11.5335f, 12.8134f)
                    curveTo(11.5068f, 12.84f, 11.4935f, 12.8738f, 11.4935f, 12.9147f)
                    verticalLineTo(14.5014f)
                    curveTo(11.4935f, 14.5405f, 11.5073f, 14.5734f, 11.5349f, 14.6f)
                    curveTo(11.5624f, 14.6267f, 11.5957f, 14.64f, 11.6348f, 14.64f)
                    horizontalLineTo(11.6642f)
                    curveTo(11.7015f, 14.64f, 11.7335f, 14.6267f, 11.7602f, 14.6f)
                    curveTo(11.7868f, 14.5734f, 11.8002f, 14.5405f, 11.8002f, 14.5014f)
                    verticalLineTo(13.5947f)
                    curveTo(11.8002f, 13.5822f, 11.8024f, 13.5725f, 11.8068f, 13.5654f)
                    curveTo(11.8113f, 13.5582f, 11.8162f, 13.5547f, 11.8215f, 13.5547f)
                    curveTo(11.8322f, 13.5547f, 11.842f, 13.5636f, 11.8508f, 13.5814f)
                    lineTo(12.3682f, 14.5627f)
                    curveTo(12.3771f, 14.5822f, 12.3948f, 14.6f, 12.4215f, 14.616f)
                    close()
                    moveTo(13.1095f, 14.64f)
                    curveTo(13.1468f, 14.64f, 13.1789f, 14.6271f, 13.2055f, 14.6014f)
                    curveTo(13.2322f, 14.5756f, 13.2455f, 14.544f, 13.2455f, 14.5067f)
                    verticalLineTo(12.904f)
                    curveTo(13.2455f, 12.8685f, 13.2322f, 12.8378f, 13.2055f, 12.812f)
                    curveTo(13.1789f, 12.7862f, 13.1468f, 12.7734f, 13.1095f, 12.7734f)
                    horizontalLineTo(13.0295f)
                    curveTo(12.994f, 12.7734f, 12.9628f, 12.7862f, 12.9362f, 12.812f)
                    curveTo(12.9095f, 12.8378f, 12.8962f, 12.8685f, 12.8962f, 12.904f)
                    verticalLineTo(14.5067f)
                    curveTo(12.8962f, 14.544f, 12.9095f, 14.5756f, 12.9362f, 14.6014f)
                    curveTo(12.9628f, 14.6271f, 12.994f, 14.64f, 13.0295f, 14.64f)
                    horizontalLineTo(13.1095f)
                    close()
                    moveTo(14.4535f, 14.64f)
                    curveTo(14.546f, 14.64f, 14.5922f, 14.6f, 14.5922f, 14.52f)
                    curveTo(14.5922f, 14.5005f, 14.5895f, 14.4791f, 14.5842f, 14.456f)
                    lineTo(14.2135f, 12.9067f)
                    curveTo(14.2046f, 12.8711f, 14.1851f, 12.84f, 14.1549f, 12.8134f)
                    curveTo(14.1246f, 12.7867f, 14.0908f, 12.7734f, 14.0535f, 12.7734f)
                    horizontalLineTo(13.9175f)
                    curveTo(13.882f, 12.7734f, 13.8491f, 12.7867f, 13.8189f, 12.8134f)
                    curveTo(13.7886f, 12.84f, 13.7691f, 12.8711f, 13.7602f, 12.9067f)
                    lineTo(13.3922f, 14.4507f)
                    curveTo(13.3851f, 14.4774f, 13.3815f, 14.5022f, 13.3815f, 14.5254f)
                    curveTo(13.3815f, 14.5716f, 13.394f, 14.6022f, 13.4188f, 14.6174f)
                    curveTo(13.4437f, 14.6325f, 13.4757f, 14.64f, 13.5148f, 14.64f)
                    horizontalLineTo(13.5709f)
                    curveTo(13.6117f, 14.64f, 13.6446f, 14.6311f, 13.6695f, 14.6134f)
                    curveTo(13.6944f, 14.5956f, 13.714f, 14.5627f, 13.7282f, 14.5147f)
                    lineTo(13.7682f, 14.368f)
                    curveTo(13.77f, 14.3609f, 13.7753f, 14.3422f, 13.7842f, 14.312f)
                    curveTo(13.7931f, 14.2818f, 13.8069f, 14.2591f, 13.8255f, 14.244f)
                    curveTo(13.8442f, 14.2289f, 13.8686f, 14.2214f, 13.8988f, 14.2214f)
                    horizontalLineTo(14.0668f)
                    curveTo(14.1113f, 14.2214f, 14.1411f, 14.2334f, 14.1562f, 14.2574f)
                    curveTo(14.1713f, 14.2814f, 14.1842f, 14.3182f, 14.1948f, 14.368f)
                    lineTo(14.2348f, 14.5147f)
                    curveTo(14.2491f, 14.5627f, 14.2686f, 14.5956f, 14.2935f, 14.6134f)
                    curveTo(14.3184f, 14.6311f, 14.3522f, 14.64f, 14.3948f, 14.64f)
                    horizontalLineTo(14.4535f)
                    close()
                    moveTo(14.0802f, 13.7574f)
                    curveTo(14.0873f, 13.7929f, 14.0908f, 13.8196f, 14.0908f, 13.8374f)
                    curveTo(14.0908f, 13.8889f, 14.0633f, 13.9147f, 14.0082f, 13.9147f)
                    horizontalLineTo(13.9655f)
                    curveTo(13.9086f, 13.9147f, 13.8802f, 13.8854f, 13.8802f, 13.8267f)
                    curveTo(13.8802f, 13.8018f, 13.8829f, 13.7778f, 13.8882f, 13.7547f)
                    lineTo(13.9229f, 13.5627f)
                    lineTo(13.9628f, 13.3654f)
                    curveTo(13.9646f, 13.3582f, 13.9677f, 13.352f, 13.9722f, 13.3467f)
                    curveTo(13.9766f, 13.3414f, 13.9806f, 13.3387f, 13.9842f, 13.3387f)
                    curveTo(13.9966f, 13.3387f, 14.0037f, 13.3494f, 14.0055f, 13.3707f)
                    lineTo(14.0428f, 13.5627f)
                    lineTo(14.0802f, 13.7574f)
                    close()
                    moveTo(16.2962f, 14.4107f)
                    curveTo(16.3069f, 14.4302f, 16.3122f, 14.4498f, 16.3122f, 14.4694f)
                    curveTo(16.3122f, 14.4925f, 16.3042f, 14.5147f, 16.2882f, 14.536f)
                    lineTo(16.2482f, 14.584f)
                    curveTo(16.202f, 14.6356f, 16.1557f, 14.6614f, 16.1095f, 14.6614f)
                    curveTo(16.0828f, 14.6614f, 16.0588f, 14.6507f, 16.0375f, 14.6294f)
                    curveTo(15.9486f, 14.5529f, 15.8815f, 14.4698f, 15.8362f, 14.38f)
                    curveTo(15.7908f, 14.2902f, 15.7584f, 14.2071f, 15.7388f, 14.1307f)
                    curveTo(15.7317f, 14.1005f, 15.7175f, 14.0778f, 15.6962f, 14.0627f)
                    curveTo(15.6749f, 14.0476f, 15.6491f, 14.04f, 15.6188f, 14.04f)
                    curveTo(15.5246f, 14.04f, 15.4775f, 14.08f, 15.4775f, 14.16f)
                    verticalLineTo(14.5307f)
                    curveTo(15.4775f, 14.5627f, 15.4677f, 14.5902f, 15.4482f, 14.6134f)
                    curveTo(15.4286f, 14.6365f, 15.3984f, 14.648f, 15.3575f, 14.648f)
                    horizontalLineTo(15.2748f)
                    curveTo(15.2322f, 14.648f, 15.1971f, 14.636f, 15.1695f, 14.612f)
                    curveTo(15.142f, 14.588f, 15.1282f, 14.5609f, 15.1282f, 14.5307f)
                    verticalLineTo(12.888f)
                    curveTo(15.1282f, 12.8578f, 15.142f, 12.8311f, 15.1695f, 12.808f)
                    curveTo(15.1971f, 12.7849f, 15.2322f, 12.7734f, 15.2748f, 12.7734f)
                    horizontalLineTo(15.6748f)
                    curveTo(15.8028f, 12.7734f, 15.9104f, 12.8027f, 15.9975f, 12.8614f)
                    curveTo(16.0846f, 12.92f, 16.1491f, 12.9956f, 16.1908f, 13.088f)
                    curveTo(16.2326f, 13.1805f, 16.2535f, 13.2774f, 16.2535f, 13.3787f)
                    curveTo(16.2535f, 13.5582f, 16.186f, 13.7218f, 16.0508f, 13.8694f)
                    curveTo(16.0402f, 13.8818f, 16.0331f, 13.8934f, 16.0295f, 13.904f)
                    curveTo(16.026f, 13.9147f, 16.0242f, 13.9218f, 16.0242f, 13.9254f)
                    curveTo(16.0224f, 13.9431f, 16.0295f, 13.9782f, 16.0455f, 14.0307f)
                    curveTo(16.0615f, 14.0831f, 16.0873f, 14.1396f, 16.1229f, 14.2f)
                    curveTo(16.1584f, 14.2605f, 16.202f, 14.3129f, 16.2535f, 14.3574f)
                    curveTo(16.2713f, 14.3734f, 16.2855f, 14.3911f, 16.2962f, 14.4107f)
                    close()
                    moveTo(15.8322f, 13.6f)
                    curveTo(15.8802f, 13.536f, 15.9042f, 13.4622f, 15.9042f, 13.3787f)
                    curveTo(15.9042f, 13.3005f, 15.8802f, 13.2329f, 15.8322f, 13.176f)
                    curveTo(15.7842f, 13.1191f, 15.7131f, 13.0907f, 15.6188f, 13.0907f)
                    curveTo(15.578f, 13.0907f, 15.5442f, 13.1022f, 15.5175f, 13.1254f)
                    curveTo(15.4908f, 13.1485f, 15.4775f, 13.1751f, 15.4775f, 13.2054f)
                    verticalLineTo(13.5814f)
                    curveTo(15.4775f, 13.6222f, 15.4895f, 13.6516f, 15.5135f, 13.6694f)
                    curveTo(15.5375f, 13.6871f, 15.5726f, 13.696f, 15.6188f, 13.696f)
                    curveTo(15.7131f, 13.696f, 15.7842f, 13.664f, 15.8322f, 13.6f)
                    close()
                    moveTo(17.3095f, 14.64f)
                    curveTo(17.3469f, 14.64f, 17.3784f, 14.6271f, 17.4042f, 14.6014f)
                    curveTo(17.43f, 14.5756f, 17.4429f, 14.5431f, 17.4429f, 14.504f)
                    verticalLineTo(14.44f)
                    curveTo(17.4429f, 14.4045f, 17.43f, 14.3734f, 17.4042f, 14.3467f)
                    curveTo(17.3784f, 14.32f, 17.3469f, 14.3067f, 17.3095f, 14.3067f)
                    horizontalLineTo(16.9282f)
                    curveTo(16.8944f, 14.3067f, 16.8642f, 14.2934f, 16.8375f, 14.2667f)
                    curveTo(16.8109f, 14.24f, 16.7975f, 14.2098f, 16.7975f, 14.176f)
                    verticalLineTo(13.968f)
                    curveTo(16.7975f, 13.9307f, 16.8104f, 13.8991f, 16.8362f, 13.8734f)
                    curveTo(16.862f, 13.8476f, 16.8926f, 13.8347f, 16.9282f, 13.8347f)
                    horizontalLineTo(17.1575f)
                    curveTo(17.1949f, 13.8347f, 17.2264f, 13.8218f, 17.2522f, 13.796f)
                    curveTo(17.278f, 13.7702f, 17.2909f, 13.7396f, 17.2909f, 13.704f)
                    verticalLineTo(13.632f)
                    curveTo(17.2909f, 13.5965f, 17.278f, 13.5654f, 17.2522f, 13.5387f)
                    curveTo(17.2264f, 13.512f, 17.1949f, 13.4987f, 17.1575f, 13.4987f)
                    horizontalLineTo(16.9282f)
                    curveTo(16.8944f, 13.4987f, 16.8642f, 13.4854f, 16.8375f, 13.4587f)
                    curveTo(16.8109f, 13.432f, 16.7975f, 13.4018f, 16.7975f, 13.368f)
                    verticalLineTo(13.24f)
                    curveTo(16.7975f, 13.2045f, 16.8109f, 13.1729f, 16.8375f, 13.1454f)
                    curveTo(16.8642f, 13.1178f, 16.8944f, 13.104f, 16.9282f, 13.104f)
                    horizontalLineTo(17.3095f)
                    curveTo(17.3469f, 13.104f, 17.3784f, 13.0916f, 17.4042f, 13.0667f)
                    curveTo(17.43f, 13.0418f, 17.4429f, 13.0116f, 17.4429f, 12.976f)
                    verticalLineTo(12.904f)
                    curveTo(17.4429f, 12.8685f, 17.43f, 12.8378f, 17.4042f, 12.812f)
                    curveTo(17.3784f, 12.7862f, 17.3469f, 12.7734f, 17.3095f, 12.7734f)
                    horizontalLineTo(16.5868f)
                    curveTo(16.5477f, 12.7734f, 16.5153f, 12.7858f, 16.4895f, 12.8107f)
                    curveTo(16.4637f, 12.8356f, 16.4509f, 12.8667f, 16.4509f, 12.904f)
                    verticalLineTo(14.504f)
                    curveTo(16.4509f, 14.5431f, 16.4637f, 14.5756f, 16.4895f, 14.6014f)
                    curveTo(16.5153f, 14.6271f, 16.5477f, 14.64f, 16.5868f, 14.64f)
                    horizontalLineTo(17.3095f)
                    close()
                    moveTo(17.7282f, 14.6054f)
                    curveTo(17.7513f, 14.6285f, 17.7789f, 14.64f, 17.8109f, 14.64f)
                    horizontalLineTo(17.9202f)
                    curveTo(17.954f, 14.64f, 17.9824f, 14.6285f, 18.0055f, 14.6054f)
                    curveTo(18.0286f, 14.5822f, 18.0402f, 14.5538f, 18.0402f, 14.52f)
                    verticalLineTo(14.1627f)
                    curveTo(18.0402f, 14.1289f, 18.0517f, 14.1f, 18.0749f, 14.076f)
                    curveTo(18.098f, 14.052f, 18.1255f, 14.04f, 18.1575f, 14.04f)
                    curveTo(18.3033f, 14.04f, 18.43f, 14.0089f, 18.5375f, 13.9467f)
                    curveTo(18.6451f, 13.8845f, 18.7269f, 13.8036f, 18.7829f, 13.704f)
                    curveTo(18.8389f, 13.6045f, 18.8668f, 13.4987f, 18.8668f, 13.3867f)
                    curveTo(18.8668f, 13.2676f, 18.8415f, 13.1618f, 18.7909f, 13.0694f)
                    curveTo(18.7402f, 12.9769f, 18.666f, 12.9045f, 18.5682f, 12.852f)
                    curveTo(18.4704f, 12.7996f, 18.3522f, 12.7734f, 18.2135f, 12.7734f)
                    horizontalLineTo(17.8109f)
                    curveTo(17.7789f, 12.7734f, 17.7513f, 12.7849f, 17.7282f, 12.808f)
                    curveTo(17.7051f, 12.8311f, 17.6935f, 12.8596f, 17.6935f, 12.8934f)
                    verticalLineTo(14.52f)
                    curveTo(17.6935f, 14.5538f, 17.7051f, 14.5822f, 17.7282f, 14.6054f)
                    close()
                    moveTo(18.1575f, 13.7067f)
                    curveTo(18.1255f, 13.7067f, 18.098f, 13.6951f, 18.0749f, 13.672f)
                    curveTo(18.0517f, 13.6489f, 18.0402f, 13.6205f, 18.0402f, 13.5867f)
                    verticalLineTo(13.2187f)
                    curveTo(18.0402f, 13.1849f, 18.0517f, 13.156f, 18.0749f, 13.132f)
                    curveTo(18.098f, 13.108f, 18.1255f, 13.096f, 18.1575f, 13.096f)
                    horizontalLineTo(18.1735f)
                    curveTo(18.2784f, 13.096f, 18.3624f, 13.1196f, 18.4255f, 13.1667f)
                    curveTo(18.4886f, 13.2138f, 18.5202f, 13.288f, 18.5202f, 13.3894f)
                    curveTo(18.5202f, 13.4818f, 18.4873f, 13.5578f, 18.4215f, 13.6174f)
                    curveTo(18.3557f, 13.6769f, 18.2731f, 13.7067f, 18.1735f, 13.7067f)
                    horizontalLineTo(18.1575f)
                    close()
                    moveTo(19.8002f, 12.8067f)
                    curveTo(19.7771f, 12.8289f, 19.7655f, 12.8569f, 19.7655f, 12.8907f)
                    verticalLineTo(14.008f)
                    curveTo(19.7655f, 14.1058f, 19.7464f, 14.18f, 19.7082f, 14.2307f)
                    curveTo(19.67f, 14.2814f, 19.6055f, 14.3067f, 19.5149f, 14.3067f)
                    curveTo(19.426f, 14.3067f, 19.362f, 14.2818f, 19.3228f, 14.232f)
                    curveTo(19.2837f, 14.1822f, 19.2642f, 14.1102f, 19.2642f, 14.016f)
                    verticalLineTo(12.8907f)
                    curveTo(19.2642f, 12.8587f, 19.2517f, 12.8311f, 19.2269f, 12.808f)
                    curveTo(19.202f, 12.7849f, 19.1726f, 12.7734f, 19.1389f, 12.7734f)
                    horizontalLineTo(19.0482f)
                    curveTo(19.0108f, 12.7734f, 18.9811f, 12.7845f, 18.9589f, 12.8067f)
                    curveTo(18.9366f, 12.8289f, 18.9255f, 12.8569f, 18.9255f, 12.8907f)
                    verticalLineTo(13.9947f)
                    curveTo(18.9255f, 14.2098f, 18.9793f, 14.3711f, 19.0868f, 14.4787f)
                    curveTo(19.1944f, 14.5862f, 19.3389f, 14.64f, 19.5202f, 14.64f)
                    curveTo(19.6997f, 14.64f, 19.8424f, 14.5862f, 19.9482f, 14.4787f)
                    curveTo(20.054f, 14.3711f, 20.1069f, 14.2098f, 20.1069f, 13.9947f)
                    verticalLineTo(12.8907f)
                    curveTo(20.1069f, 12.8587f, 20.094f, 12.8311f, 20.0682f, 12.808f)
                    curveTo(20.0424f, 12.7849f, 20.0126f, 12.7734f, 19.9789f, 12.7734f)
                    horizontalLineTo(19.8882f)
                    curveTo(19.8526f, 12.7734f, 19.8233f, 12.7845f, 19.8002f, 12.8067f)
                    close()
                    moveTo(20.2322f, 14.6094f)
                    curveTo(20.2535f, 14.6298f, 20.2793f, 14.64f, 20.3095f, 14.64f)
                    horizontalLineTo(20.7362f)
                    curveTo(20.9549f, 14.64f, 21.1175f, 14.5871f, 21.2242f, 14.4814f)
                    curveTo(21.3309f, 14.3756f, 21.3842f, 14.2374f, 21.3842f, 14.0667f)
                    verticalLineTo(13.976f)
                    curveTo(21.3824f, 13.896f, 21.3597f, 13.8262f, 21.3162f, 13.7667f)
                    curveTo(21.2726f, 13.7071f, 21.2135f, 13.6596f, 21.1389f, 13.624f)
                    curveTo(21.1353f, 13.624f, 21.1335f, 13.6214f, 21.1335f, 13.616f)
                    lineTo(21.1362f, 13.6134f)
                    curveTo(21.1984f, 13.576f, 21.2451f, 13.5209f, 21.2762f, 13.448f)
                    curveTo(21.3073f, 13.3751f, 21.3229f, 13.2951f, 21.3229f, 13.208f)
                    curveTo(21.3229f, 13.08f, 21.2709f, 12.9756f, 21.1669f, 12.8947f)
                    curveTo(21.0629f, 12.8138f, 20.9157f, 12.7734f, 20.7255f, 12.7734f)
                    horizontalLineTo(20.3095f)
                    curveTo(20.2793f, 12.7734f, 20.2535f, 12.7836f, 20.2322f, 12.804f)
                    curveTo(20.2108f, 12.8245f, 20.2002f, 12.8498f, 20.2002f, 12.88f)
                    verticalLineTo(14.5334f)
                    curveTo(20.2002f, 14.5636f, 20.2108f, 14.5889f, 20.2322f, 14.6094f)
                    close()
                    moveTo(20.6615f, 13.4854f)
                    curveTo(20.6153f, 13.4854f, 20.5851f, 13.4782f, 20.5709f, 13.464f)
                    curveTo(20.5566f, 13.4498f, 20.5495f, 13.4205f, 20.5495f, 13.376f)
                    verticalLineTo(13.2134f)
                    curveTo(20.5495f, 13.1707f, 20.5562f, 13.1418f, 20.5695f, 13.1267f)
                    curveTo(20.5829f, 13.1116f, 20.6135f, 13.104f, 20.6615f, 13.104f)
                    horizontalLineTo(20.6829f)
                    curveTo(20.786f, 13.104f, 20.8602f, 13.1196f, 20.9055f, 13.1507f)
                    curveTo(20.9509f, 13.1818f, 20.9735f, 13.2222f, 20.9735f, 13.272f)
                    curveTo(20.9735f, 13.3307f, 20.9513f, 13.3809f, 20.9069f, 13.4227f)
                    curveTo(20.8624f, 13.4645f, 20.7886f, 13.4854f, 20.6855f, 13.4854f)
                    horizontalLineTo(20.6615f)
                    close()
                    moveTo(20.6615f, 14.3094f)
                    curveTo(20.6189f, 14.3094f, 20.5895f, 14.3018f, 20.5735f, 14.2867f)
                    curveTo(20.5575f, 14.2716f, 20.5495f, 14.2427f, 20.5495f, 14.2f)
                    verticalLineTo(13.9014f)
                    curveTo(20.5495f, 13.8551f, 20.5575f, 13.8254f, 20.5735f, 13.812f)
                    curveTo(20.5895f, 13.7987f, 20.6189f, 13.792f, 20.6615f, 13.792f)
                    horizontalLineTo(20.7602f)
                    curveTo(20.8455f, 13.792f, 20.9153f, 13.8142f, 20.9695f, 13.8587f)
                    curveTo(21.0237f, 13.9031f, 21.0509f, 13.9618f, 21.0509f, 14.0347f)
                    verticalLineTo(14.0667f)
                    curveTo(21.0509f, 14.2285f, 20.9549f, 14.3094f, 20.7628f, 14.3094f)
                    horizontalLineTo(20.6615f)
                    close()
                    moveTo(22.4402f, 14.64f)
                    curveTo(22.4793f, 14.64f, 22.5117f, 14.6271f, 22.5375f, 14.6014f)
                    curveTo(22.5633f, 14.5756f, 22.5762f, 14.544f, 22.5762f, 14.5067f)
                    verticalLineTo(14.4427f)
                    curveTo(22.5762f, 14.4036f, 22.5633f, 14.3716f, 22.5375f, 14.3467f)
                    curveTo(22.5117f, 14.3218f, 22.4793f, 14.3094f, 22.4402f, 14.3094f)
                    horizontalLineTo(22.0615f)
                    curveTo(22.0224f, 14.3094f, 21.99f, 14.296f, 21.9642f, 14.2694f)
                    curveTo(21.9384f, 14.2427f, 21.9255f, 14.2107f, 21.9255f, 14.1734f)
                    verticalLineTo(12.9067f)
                    curveTo(21.9255f, 12.8694f, 21.9126f, 12.8378f, 21.8869f, 12.812f)
                    curveTo(21.8611f, 12.7862f, 21.8295f, 12.7734f, 21.7922f, 12.7734f)
                    horizontalLineTo(21.7095f)
                    curveTo(21.674f, 12.7734f, 21.6429f, 12.7862f, 21.6162f, 12.812f)
                    curveTo(21.5895f, 12.8378f, 21.5762f, 12.8694f, 21.5762f, 12.9067f)
                    verticalLineTo(14.5067f)
                    curveTo(21.5762f, 14.544f, 21.5895f, 14.5756f, 21.6162f, 14.6014f)
                    curveTo(21.6429f, 14.6271f, 21.674f, 14.64f, 21.7095f, 14.64f)
                    horizontalLineTo(22.4402f)
                    close()
                    moveTo(22.9335f, 14.64f)
                    curveTo(22.9709f, 14.64f, 23.0028f, 14.6271f, 23.0295f, 14.6014f)
                    curveTo(23.0562f, 14.5756f, 23.0695f, 14.544f, 23.0695f, 14.5067f)
                    verticalLineTo(12.904f)
                    curveTo(23.0695f, 12.8685f, 23.0562f, 12.8378f, 23.0295f, 12.812f)
                    curveTo(23.0028f, 12.7862f, 22.9709f, 12.7734f, 22.9335f, 12.7734f)
                    horizontalLineTo(22.8535f)
                    curveTo(22.818f, 12.7734f, 22.7868f, 12.7862f, 22.7602f, 12.812f)
                    curveTo(22.7335f, 12.8378f, 22.7202f, 12.8685f, 22.7202f, 12.904f)
                    verticalLineTo(14.5067f)
                    curveTo(22.7202f, 14.544f, 22.7335f, 14.5756f, 22.7602f, 14.6014f)
                    curveTo(22.7868f, 14.6271f, 22.818f, 14.64f, 22.8535f, 14.64f)
                    horizontalLineTo(22.9335f)
                    close()
                    moveTo(24.3882f, 14.1387f)
                    horizontalLineTo(24.3895f)
                    curveTo(24.4197f, 14.1529f, 24.4433f, 14.1734f, 24.4602f, 14.2f)
                    curveTo(24.4771f, 14.2267f, 24.4855f, 14.256f, 24.4855f, 14.288f)
                    curveTo(24.4855f, 14.32f, 24.4757f, 14.3511f, 24.4562f, 14.3814f)
                    curveTo(24.3353f, 14.5538f, 24.1673f, 14.64f, 23.9522f, 14.64f)
                    curveTo(23.8011f, 14.64f, 23.6749f, 14.5982f, 23.5735f, 14.5147f)
                    curveTo(23.4722f, 14.4311f, 23.3975f, 14.3187f, 23.3495f, 14.1774f)
                    curveTo(23.3015f, 14.036f, 23.2775f, 13.8791f, 23.2775f, 13.7067f)
                    curveTo(23.2775f, 13.536f, 23.3015f, 13.38f, 23.3495f, 13.2387f)
                    curveTo(23.3975f, 13.0974f, 23.4722f, 12.9845f, 23.5735f, 12.9f)
                    curveTo(23.6749f, 12.8156f, 23.8011f, 12.7734f, 23.9522f, 12.7734f)
                    curveTo(24.1549f, 12.7734f, 24.3157f, 12.8516f, 24.4349f, 13.008f)
                    curveTo(24.458f, 13.0365f, 24.4695f, 13.0694f, 24.4695f, 13.1067f)
                    curveTo(24.4695f, 13.1369f, 24.4624f, 13.1645f, 24.4482f, 13.1894f)
                    curveTo(24.434f, 13.2142f, 24.4135f, 13.2347f, 24.3869f, 13.2507f)
                    lineTo(24.3815f, 13.2534f)
                    curveTo(24.3584f, 13.2676f, 24.3309f, 13.2747f, 24.2989f, 13.2747f)
                    curveTo(24.2455f, 13.2747f, 24.2029f, 13.2542f, 24.1709f, 13.2134f)
                    curveTo(24.1104f, 13.1369f, 24.0375f, 13.0987f, 23.9522f, 13.0987f)
                    curveTo(23.8491f, 13.0987f, 23.7668f, 13.1534f, 23.7055f, 13.2627f)
                    curveTo(23.6442f, 13.372f, 23.6135f, 13.52f, 23.6135f, 13.7067f)
                    curveTo(23.6135f, 13.8969f, 23.6442f, 14.0462f, 23.7055f, 14.1547f)
                    curveTo(23.7668f, 14.2631f, 23.8491f, 14.3174f, 23.9522f, 14.3174f)
                    curveTo(24.0446f, 14.3174f, 24.1211f, 14.2756f, 24.1815f, 14.192f)
                    curveTo(24.1975f, 14.1689f, 24.2175f, 14.1511f, 24.2415f, 14.1387f)
                    curveTo(24.2655f, 14.1262f, 24.2909f, 14.12f, 24.3175f, 14.12f)
                    curveTo(24.3424f, 14.12f, 24.3655f, 14.1254f, 24.3869f, 14.136f)
                    lineTo(24.3882f, 14.1387f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF319400)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(8.3649f, 11.5142f)
                    curveTo(7.278f, 11.4861f, 7.255f, 11.3069f, 8.3304f, 11.1221f)
                    curveTo(8.3304f, 11.1221f, 11.9613f, 10.4032f, 14.5775f, 10.4032f)
                    curveTo(17.2947f, 10.4032f, 20.7476f, 11.1133f, 20.7476f, 11.1133f)
                    curveTo(21.8154f, 11.3066f, 21.7966f, 11.4872f, 20.7086f, 11.5164f)
                    lineTo(14.7017f, 11.6779f)
                    lineTo(8.3649f, 11.5142f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF944200)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(9.7489f, 8.8002f)
                    curveTo(9.5485f, 8.6141f, 9.5578f, 8.9676f, 9.1076f, 8.9075f)
                    curveTo(8.9878f, 8.8915f, 8.8413f, 8.6192f, 8.8413f, 8.6192f)
                    curveTo(8.8413f, 8.6192f, 8.0899f, 8.5705f, 8.0494f, 8.2211f)
                    curveTo(8.0088f, 7.8716f, 8.5159f, 7.707f, 8.7048f, 7.4436f)
                    curveTo(8.8535f, 7.2363f, 8.7288f, 7.0617f, 8.8413f, 6.8333f)
                    curveTo(8.9539f, 6.6049f, 9.2874f, 6.5325f, 9.3213f, 6.4151f)
                    curveTo(9.3424f, 6.3422f, 9.144f, 6.0626f, 9.424f, 5.9678f)
                    curveTo(9.6946f, 5.8761f, 9.9456f, 6.1071f, 9.9456f, 6.1071f)
                    curveTo(9.9456f, 6.1071f, 9.9469f, 5.784f, 10.1663f, 5.746f)
                    curveTo(10.4842f, 5.6908f, 10.69f, 5.9678f, 10.69f, 5.9678f)
                    curveTo(10.69f, 5.9678f, 12.3108f, 4.6256f, 13.2227f, 4.6157f)
                    curveTo(14.0067f, 4.6073f, 14.3642f, 5.0995f, 15.1164f, 5.1807f)
                    curveTo(16.3415f, 5.3129f, 16.8854f, 4.6157f, 18.1309f, 5.1807f)
                    curveTo(19.7245f, 5.9035f, 19.8247f, 9.1699f, 19.8247f, 9.1699f)
                    curveTo(19.8247f, 9.1699f, 20.2254f, 9.7059f, 20.2885f, 10.0f)
                    curveTo(20.3481f, 10.2786f, 20.2885f, 10.4741f, 20.0153f, 10.6948f)
                    curveTo(19.7422f, 10.9155f, 18.8108f, 11.1921f, 18.6364f, 10.888f)
                    curveTo(18.4619f, 10.584f, 19.4502f, 10.3563f, 19.2838f, 10.2835f)
                    curveTo(18.6364f, 10.0f, 18.1309f, 9.1699f, 18.1309f, 9.1699f)
                    curveTo(18.1309f, 9.1699f, 17.44f, 9.5386f, 17.0574f, 10.0f)
                    curveTo(16.7428f, 10.3795f, 16.8776f, 10.888f, 16.4038f, 10.888f)
                    curveTo(15.4968f, 10.888f, 15.0813f, 10.9754f, 15.0294f, 10.6948f)
                    curveTo(14.9178f, 10.0902f, 16.2049f, 10.5373f, 15.9778f, 10.3869f)
                    curveTo(15.8217f, 10.2835f, 15.8217f, 8.6192f, 15.8217f, 8.6192f)
                    horizontalLineTo(14.8371f)
                    curveTo(14.8371f, 8.6192f, 15.0478f, 10.5353f, 14.6853f, 10.584f)
                    curveTo(13.74f, 10.711f, 14.1963f, 10.6965f, 13.4048f, 10.584f)
                    curveTo(12.9686f, 10.522f, 14.0f, 10.0f, 14.0f, 10.0f)
                    curveTo(14.0f, 10.0f, 13.8615f, 9.0086f, 13.4048f, 9.016f)
                    curveTo(12.6604f, 9.7564f, 11.499f, 11.1224f, 11.0365f, 11.1224f)
                    curveTo(10.4747f, 11.1224f, 10.5866f, 11.0598f, 10.1663f, 11.0275f)
                    curveTo(9.2802f, 10.9594f, 10.1663f, 10.2835f, 10.69f, 10.584f)
                    curveTo(10.9117f, 10.2835f, 11.7005f, 8.0787f, 11.7005f, 8.0787f)
                    curveTo(11.7005f, 8.0787f, 10.2651f, 9.2795f, 9.7489f, 8.8002f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF391800)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(10.21f, 6.4012f)
                    curveTo(10.2319f, 6.4061f, 10.2563f, 6.407f, 10.2804f, 6.4028f)
                    lineTo(10.2217f, 6.0648f)
                    lineTo(9.955f, 6.0163f)
                    curveTo(9.9591f, 5.9938f, 9.9664f, 5.9604f, 9.9794f, 5.9247f)
                    moveTo(9.9794f, 5.9247f)
                    curveTo(9.9934f, 5.8861f, 10.0116f, 5.8594f, 10.016f, 5.8528f)
                    curveTo(10.0235f, 5.8418f, 10.0304f, 5.8331f, 10.0348f, 5.8278f)
                    curveTo(10.0438f, 5.817f, 10.0519f, 5.8088f, 10.0577f, 5.8033f)
                    curveTo(10.0698f, 5.7918f, 10.0815f, 5.7828f, 10.0924f, 5.7757f)
                    curveTo(10.1149f, 5.761f, 10.1399f, 5.7505f, 10.1663f, 5.746f)
                    curveTo(10.2301f, 5.7349f, 10.2941f, 5.7368f, 10.3559f, 5.7507f)
                    lineTo(10.2913f, 6.0384f)
                    lineTo(10.6057f, 6.153f)
                    curveTo(10.6083f, 6.1458f, 10.6101f, 6.139f, 10.6101f, 6.139f)
                    lineTo(10.6109f, 6.1356f)
                    lineTo(10.5488f, 6.4772f)
                    lineTo(10.21f, 6.4012f)
                    moveTo(9.4909f, 6.1651f)
                    lineTo(9.274f, 6.1844f)
                    curveTo(9.2698f, 6.1366f, 9.2792f, 6.1033f, 9.2825f, 6.0928f)
                    curveTo(9.2868f, 6.0789f, 9.2916f, 6.0693f, 9.2954f, 6.0629f)
                    curveTo(9.299f, 6.0567f, 9.306f, 6.0458f, 9.319f, 6.0324f)
                    curveTo(9.3279f, 6.0231f, 9.3621f, 5.9887f, 9.424f, 5.9678f)
                    lineTo(9.4909f, 6.1651f)
                    close()
                    moveTo(9.7294f, 6.144f)
                    lineTo(9.9381f, 6.1255f)
                    curveTo(9.9375f, 6.1194f, 9.9369f, 6.1143f, 9.9363f, 6.1107f)
                    lineTo(9.9361f, 6.1088f)
                    lineTo(9.9346f, 6.0999f)
                    curveTo(9.9339f, 6.096f, 9.9334f, 6.0943f, 9.9334f, 6.0943f)
                    curveTo(9.9334f, 6.0943f, 9.9348f, 6.0999f, 9.9378f, 6.1102f)
                    curveTo(9.9409f, 6.1207f, 9.9438f, 6.1308f, 9.9467f, 6.1405f)
                    curveTo(9.955f, 6.1689f, 9.9623f, 6.1939f, 9.9683f, 6.2149f)
                    lineTo(10.1765f, 6.9454f)
                    lineTo(9.498f, 6.6041f)
                    curveTo(9.5007f, 6.6052f, 9.5078f, 6.6076f, 9.5192f, 6.6098f)
                    curveTo(9.5351f, 6.6128f, 9.58f, 6.6188f, 9.6379f, 6.5992f)
                    lineTo(9.5483f, 6.3346f)
                    moveTo(9.3728f, 8.2464f)
                    lineTo(9.4746f, 8.3725f)
                    lineTo(9.4822f, 8.3815f)
                    lineTo(9.4867f, 8.3868f)
                    lineTo(9.4898f, 8.3903f)
                    lineTo(9.4972f, 8.3994f)
                    curveTo(9.4989f, 8.4015f, 9.5024f, 8.4061f, 9.5067f, 8.412f)
                    curveTo(9.5089f, 8.4151f, 9.5218f, 8.433f, 9.5338f, 8.4571f)
                    curveTo(9.538f, 8.4653f, 9.5605f, 8.5097f, 9.5671f, 8.5698f)
                    curveTo(9.5706f, 8.6018f, 9.5745f, 8.6784f, 9.5306f, 8.7618f)
                    curveTo(9.4775f, 8.8624f, 9.3854f, 8.9163f, 9.3009f, 8.9331f)
                    curveTo(9.2315f, 8.947f, 9.176f, 8.935f, 9.1535f, 8.9292f)
                    curveTo(9.1266f, 8.9224f, 9.1062f, 8.9136f, 9.0952f, 8.9085f)
                    curveTo(9.0738f, 8.8986f, 9.0582f, 8.8884f, 9.0518f, 8.8842f)
                    curveTo(9.0638f, 8.8921f, 9.0756f, 8.8979f, 9.0862f, 8.9018f)
                    curveTo(9.0969f, 8.9057f, 9.1044f, 8.9071f, 9.1076f, 8.9075f)
                    lineTo(9.1435f, 8.6398f)
                    lineTo(8.9576f, 8.7899f)
                    curveTo(8.9523f, 8.7819f, 8.9449f, 8.7698f, 8.9376f, 8.7553f)
                    curveTo(8.9335f, 8.7472f, 8.911f, 8.7027f, 8.9044f, 8.6426f)
                    curveTo(8.9009f, 8.6107f, 8.8969f, 8.534f, 8.9409f, 8.4507f)
                    curveTo(8.994f, 8.35f, 9.0861f, 8.2962f, 9.1705f, 8.2793f)
                    curveTo(9.1779f, 8.2779f, 9.1851f, 8.2767f, 9.1921f, 8.2758f)
                    lineTo(9.196f, 8.2467f)
                    curveTo(9.2043f, 8.2478f, 9.2094f, 8.2483f, 9.2122f, 8.2485f)
                    lineTo(9.3728f, 8.2464f)
                    close()
                    moveTo(8.9576f, 8.7899f)
                    lineTo(8.9559f, 8.7913f)
                    curveTo(8.9655f, 8.8032f, 8.9736f, 8.8126f, 8.9788f, 8.8187f)
                    lineTo(8.9819f, 8.8222f)
                    lineTo(8.9806f, 8.8207f)
                    lineTo(8.9739f, 8.8125f)
                    curveTo(8.9723f, 8.8105f, 8.9689f, 8.806f, 8.9647f, 8.8002f)
                    curveTo(8.9647f, 8.8002f, 8.9611f, 8.7952f, 8.9576f, 8.7899f)
                    close()
                    moveTo(14.8425f, 8.6192f)
                    horizontalLineTo(15.819f)
                    lineTo(15.825f, 8.9464f)
                    curveTo(15.8281f, 9.1185f, 15.8339f, 9.312f, 15.8433f, 9.5055f)
                    curveTo(15.8533f, 9.7123f, 15.8627f, 9.8742f, 15.8752f, 10.0046f)
                    lineTo(15.8967f, 10.2285f)
                    curveTo(15.9044f, 10.2283f, 15.9121f, 10.2282f, 15.9198f, 10.228f)
                    curveTo(16.0674f, 10.2246f, 16.1808f, 10.2225f, 16.2946f, 10.2217f)
                    lineTo(17.2594f, 10.2151f)
                    lineTo(16.5044f, 10.8159f)
                    curveTo(16.4963f, 10.8223f, 16.4884f, 10.8287f, 16.4805f, 10.8349f)
                    curveTo(16.3629f, 10.9286f, 16.271f, 11.0018f, 16.2034f, 11.0403f)
                    curveTo(16.1611f, 11.0643f, 16.0786f, 11.1054f, 15.9707f, 11.0992f)
                    curveTo(15.9314f, 11.097f, 15.8979f, 11.089f, 15.8714f, 11.0802f)
                    curveTo(15.8181f, 11.0745f, 15.7547f, 11.0654f, 15.6759f, 11.0539f)
                    curveTo(15.5938f, 11.0428f, 15.5348f, 11.037f, 15.4838f, 11.0347f)
                    curveTo(15.4437f, 11.0329f, 15.4143f, 11.034f, 15.3973f, 11.0354f)
                    curveTo(15.3887f, 11.0362f, 15.3867f, 11.0368f, 15.39f, 11.0361f)
                    curveTo(15.39f, 11.0361f, 15.3971f, 11.0347f, 15.4049f, 11.0323f)
                    curveTo(15.409f, 11.0311f, 15.4145f, 11.0293f, 15.4212f, 11.0268f)
                    curveTo(15.4277f, 11.0244f, 15.4366f, 11.0207f, 15.4471f, 11.0155f)
                    lineTo(15.1507f, 10.4184f)
                    curveTo(15.1086f, 10.4393f, 15.0843f, 10.4644f, 15.076f, 10.4735f)
                    curveTo(15.0657f, 10.4848f, 15.0598f, 10.4937f, 15.057f, 10.4983f)
                    curveTo(15.0542f, 10.5029f, 15.0502f, 10.51f, 15.0456f, 10.521f)
                    curveTo(15.0435f, 10.526f, 15.0389f, 10.5376f, 15.0346f, 10.5539f)
                    curveTo(15.0324f, 10.5619f, 15.029f, 10.5761f, 15.0267f, 10.5943f)
                    curveTo(15.0249f, 10.6085f, 15.0205f, 10.6467f, 15.0294f, 10.6948f)
                    curveTo(15.0233f, 10.6616f, 15.0148f, 10.5956f, 15.0369f, 10.5185f)
                    curveTo(15.0485f, 10.4781f, 15.0662f, 10.442f, 15.0882f, 10.4106f)
                    lineTo(14.8723f, 10.4468f)
                    lineTo(14.8924f, 10.0335f)
                    curveTo(14.8985f, 9.909f, 14.8996f, 9.7661f, 14.8975f, 9.602f)
                    curveTo(14.895f, 9.4041f, 14.8847f, 9.1922f, 14.8689f, 8.977f)
                    lineTo(14.8425f, 8.6192f)
                    close()
                    moveTo(13.3222f, 10.5517f)
                    curveTo(13.3274f, 10.5559f, 13.3538f, 10.5768f, 13.4048f, 10.584f)
                    lineTo(13.4391f, 10.3436f)
                    curveTo(13.4307f, 10.3486f, 13.4239f, 10.3532f, 13.42f, 10.3559f)
                    lineTo(13.4224f, 10.354f)
                    curveTo(13.4243f, 10.3526f, 13.4268f, 10.3507f, 13.43f, 10.3482f)
                    curveTo(13.4327f, 10.3461f, 13.4359f, 10.3436f, 13.4395f, 10.3409f)
                    lineTo(13.4988f, 9.924f)
                    curveTo(13.6122f, 9.9401f, 13.7461f, 9.9623f, 13.8514f, 9.98f)
                    curveTo(13.8671f, 9.9826f, 13.8821f, 9.9851f, 13.8963f, 9.9875f)
                    curveTo(13.9307f, 9.9933f, 13.9604f, 9.9983f, 13.9845f, 10.0023f)
                    lineTo(14.008f, 10.006f)
                    curveTo(14.0154f, 10.0053f, 14.0257f, 10.004f, 14.0399f, 10.0022f)
                    lineTo(14.2394f, 10.627f)
                    curveTo(14.1701f, 10.6639f, 14.0839f, 10.7124f, 13.9998f, 10.7645f)
                    curveTo(13.9555f, 10.7919f, 13.9179f, 10.8168f, 13.8874f, 10.8384f)
                    curveTo(13.8703f, 10.8506f, 13.8573f, 10.8606f, 13.8431f, 10.8715f)
                    curveTo(13.8379f, 10.8756f, 13.8325f, 10.8798f, 13.8266f, 10.8842f)
                    curveTo(13.8266f, 10.8842f, 13.7973f, 10.9074f, 13.7663f, 10.9243f)
                    curveTo(13.758f, 10.9288f, 13.7309f, 10.9434f, 13.6936f, 10.9537f)
                    curveTo(13.6748f, 10.9588f, 13.6376f, 10.9675f, 13.5899f, 10.9654f)
                    curveTo(13.5407f, 10.9633f, 13.4595f, 10.9482f, 13.3855f, 10.8839f)
                    curveTo(13.2344f, 10.7528f, 13.2744f, 10.5766f, 13.2784f, 10.5591f)
                    curveTo(13.2878f, 10.5172f, 13.3034f, 10.4861f, 13.3079f, 10.4774f)
                    curveTo(13.3048f, 10.4834f, 13.3012f, 10.4954f, 13.3019f, 10.5098f)
                    curveTo(13.3024f, 10.5226f, 13.3059f, 10.5313f, 13.3084f, 10.5359f)
                    curveTo(13.3105f, 10.5398f, 13.314f, 10.545f, 13.3222f, 10.5517f)
                    close()
                    moveTo(19.0456f, 10.3653f)
                    curveTo(19.148f, 10.3423f, 19.2781f, 10.3079f, 19.3939f, 10.2675f)
                    lineTo(19.7222f, 10.8339f)
                    curveTo(19.6634f, 10.885f, 19.6028f, 10.921f, 19.5492f, 10.9503f)
                    curveTo(19.5086f, 10.9726f, 19.3491f, 11.0498f, 19.2864f, 11.0801f)
                    curveTo(19.2719f, 11.0872f, 19.2612f, 11.0924f, 19.2612f, 11.0924f)
                    curveTo(19.2612f, 11.0924f, 19.2576f, 11.0942f, 19.2554f, 11.0953f)
                    curveTo(19.2365f, 11.105f, 19.1983f, 11.1246f, 19.1619f, 11.1378f)
                    curveTo(19.1153f, 11.1546f, 19.0147f, 11.1833f, 18.8972f, 11.1421f)
                    curveTo(18.79f, 11.1045f, 18.7294f, 11.0288f, 18.7049f, 10.9961f)
                    curveTo(18.6781f, 10.9602f, 18.6539f, 10.9186f, 18.6364f, 10.888f)
                    lineTo(19.2048f, 10.5619f)
                    curveTo(19.1858f, 10.5461f, 19.157f, 10.5268f, 19.118f, 10.5131f)
                    curveTo(19.0516f, 10.4898f, 18.9946f, 10.4958f, 18.962f, 10.5031f)
                    curveTo(18.9485f, 10.5062f, 18.9393f, 10.5094f, 18.9352f, 10.5109f)
                    curveTo(18.9304f, 10.5126f, 18.9273f, 10.514f, 18.9273f, 10.514f)
                    curveTo(18.9273f, 10.514f, 18.9283f, 10.5135f, 18.9308f, 10.5123f)
                    curveTo(18.9363f, 10.5096f, 18.9427f, 10.5064f, 18.9539f, 10.5007f)
                    lineTo(18.9593f, 10.498f)
                    curveTo(18.9728f, 10.4911f, 19.0079f, 10.4742f, 19.0466f, 10.4554f)
                    curveTo(19.0615f, 10.4482f, 19.077f, 10.4407f, 19.092f, 10.4334f)
                    lineTo(19.0871f, 10.4307f)
                    curveTo(19.0547f, 10.4129f, 19.0264f, 10.4043f, 19.0108f, 10.4003f)
                    curveTo(18.9798f, 10.3923f, 18.9552f, 10.3908f, 18.9472f, 10.3904f)
                    curveTo(18.9281f, 10.3895f, 18.9149f, 10.3907f, 18.9149f, 10.3907f)
                    lineTo(18.9137f, 10.3908f)
                    curveTo(18.9137f, 10.3908f, 18.9182f, 10.3903f, 18.9288f, 10.3886f)
                    curveTo(18.9541f, 10.3845f, 18.9945f, 10.3767f, 19.0456f, 10.3653f)
                    close()
                    moveTo(9.8387f, 10.5678f)
                    curveTo(9.8715f, 10.5046f, 9.9264f, 10.4415f, 10.0083f, 10.4013f)
                    curveTo(10.0857f, 10.3633f, 10.1613f, 10.3584f, 10.2175f, 10.3627f)
                    curveTo(10.3635f, 10.374f, 10.4732f, 10.3893f, 10.5867f, 10.4131f)
                    lineTo(10.5884f, 10.4134f)
                    curveTo(10.6271f, 10.4218f, 10.628f, 10.422f, 10.6602f, 10.4292f)
                    curveTo(10.7333f, 10.4453f, 10.7897f, 10.4535f, 10.957f, 10.4554f)
                    lineTo(11.6083f, 10.4625f)
                    lineTo(10.8737f, 11.458f)
                    lineTo(10.3799f, 11.1746f)
                    curveTo(10.3753f, 11.1747f, 10.3693f, 11.1751f, 10.362f, 11.1761f)
                    curveTo(10.3478f, 11.1781f, 10.3341f, 11.1818f, 10.3233f, 11.186f)
                    curveTo(10.3154f, 11.1891f, 10.3119f, 11.1913f, 10.3119f, 11.1913f)
                    lineTo(10.3141f, 11.1896f)
                    lineTo(10.1867f, 11.0291f)
                    curveTo(10.18f, 11.0285f, 10.1732f, 11.028f, 10.1663f, 11.0275f)
                    curveTo(10.1717f, 11.0279f, 10.1783f, 11.0281f, 10.1859f, 11.0281f)
                    lineTo(9.8996f, 10.6675f)
                    curveTo(9.841f, 10.714f, 9.8154f, 10.7699f, 9.8048f, 10.8027f)
                    curveTo(9.7952f, 10.8326f, 9.7943f, 10.8544f, 9.7942f, 10.8572f)
                    lineTo(9.7941f, 10.859f)
                    curveTo(9.7941f, 10.859f, 9.7941f, 10.856f, 9.7937f, 10.8477f)
                    curveTo(9.7937f, 10.8477f, 9.7935f, 10.8442f, 9.7934f, 10.8417f)
                    curveTo(9.7929f, 10.8316f, 9.792f, 10.814f, 9.7916f, 10.7997f)
                    curveTo(9.7911f, 10.7798f, 9.7909f, 10.7485f, 9.795f, 10.7135f)
                    curveTo(9.799f, 10.6797f, 9.8089f, 10.6254f, 9.8387f, 10.5678f)
                    close()
                    moveTo(14.691f, 10.5832f)
                    lineTo(14.9693f, 10.5418f)
                    lineTo(15.0314f, 10.7316f)
                    curveTo(15.042f, 10.7481f, 15.0519f, 10.7666f, 15.0603f, 10.7876f)
                    curveTo(15.0933f, 10.8698f, 15.0895f, 10.9537f, 15.0654f, 11.0222f)
                    curveTo(15.0285f, 11.1272f, 14.9514f, 11.1787f, 14.9386f, 11.1872f)
                    lineTo(14.9376f, 11.1878f)
                    curveTo(14.8997f, 11.2135f, 14.8643f, 11.2253f, 14.8603f, 11.2266f)
                    curveTo(14.8498f, 11.2302f, 14.841f, 11.2327f, 14.8371f, 11.2337f)
                    curveTo(14.8289f, 11.2359f, 14.8224f, 11.2373f, 14.8201f, 11.2378f)
                    lineTo(14.809f, 11.24f)
                    lineTo(14.8009f, 11.2413f)
                    lineTo(14.7898f, 11.243f)
                    lineTo(14.5112f, 11.2849f)
                    lineTo(14.4235f, 11.0173f)
                    lineTo(14.4334f, 11.0133f)
                    curveTo(14.4358f, 11.0206f, 14.4386f, 11.0285f, 14.4415f, 11.0358f)
                    curveTo(14.4715f, 11.1106f, 14.5206f, 11.1558f, 14.5519f, 11.1791f)
                    curveTo(14.6068f, 11.22f, 14.6604f, 11.2328f, 14.6726f, 11.2357f)
                    curveTo(14.6926f, 11.2405f, 14.7094f, 11.2425f, 14.7173f, 11.2433f)
                    curveTo(14.7337f, 11.245f, 14.7466f, 11.245f, 14.7511f, 11.245f)
                    curveTo(14.7572f, 11.245f, 14.762f, 11.2448f, 14.7649f, 11.2447f)
                    curveTo(14.7683f, 11.2446f, 14.7714f, 11.2444f, 14.7741f, 11.2442f)
                    lineTo(14.7301f, 10.9167f)
                    lineTo(14.4334f, 11.0133f)
                    curveTo(14.4094f, 10.9384f, 14.4145f, 10.8635f, 14.4364f, 10.8012f)
                    curveTo(14.4733f, 10.6962f, 14.5504f, 10.6447f, 14.5632f, 10.6362f)
                    lineTo(14.5642f, 10.6356f)
                    curveTo(14.6021f, 10.6099f, 14.6375f, 10.5982f, 14.6415f, 10.5968f)
                    curveTo(14.652f, 10.5932f, 14.6607f, 10.5908f, 14.6645f, 10.5898f)
                    curveTo(14.6727f, 10.5876f, 14.6791f, 10.5862f, 14.6812f, 10.5857f)
                    lineTo(14.6853f, 10.584f)
                    lineTo(14.691f, 10.5832f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF391800)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.5362f, 5.8779f)
                    curveTo(12.6233f, 6.133f, 12.6903f, 6.5078f, 12.7f, 6.7373f)
                    curveTo(12.7064f, 6.8874f, 12.676f, 7.0702f, 12.6397f, 7.2365f)
                    curveTo(12.6017f, 7.4103f, 12.5502f, 7.5965f, 12.4994f, 7.7648f)
                    curveTo(12.4485f, 7.9338f, 12.3971f, 8.0889f, 12.3586f, 8.2014f)
                    curveTo(12.3393f, 8.2578f, 12.3231f, 8.3038f, 12.3117f, 8.3359f)
                    lineTo(12.2983f, 8.3732f)
                    lineTo(12.2947f, 8.3832f)
                    lineTo(12.2933f, 8.387f)
                    curveTo(12.2933f, 8.387f, 12.2933f, 8.3871f, 11.9803f, 8.2724f)
                    lineTo(12.2933f, 8.387f)
                    curveTo(12.23f, 8.5598f, 12.0385f, 8.6487f, 11.8656f, 8.5854f)
                    curveTo(11.6928f, 8.522f, 11.604f, 8.3305f, 11.6673f, 8.1577f)
                    lineTo(11.6683f, 8.1552f)
                    lineTo(11.6714f, 8.1466f)
                    lineTo(11.6836f, 8.1124f)
                    curveTo(11.6942f, 8.0826f, 11.7095f, 8.0391f, 11.7279f, 7.9855f)
                    curveTo(11.7646f, 7.8782f, 11.8132f, 7.7314f, 11.8611f, 7.5724f)
                    curveTo(11.9093f, 7.4127f, 11.9555f, 7.2447f, 11.9884f, 7.0942f)
                    curveTo(12.0229f, 6.9361f, 12.0364f, 6.8243f, 12.0339f, 6.7655f)
                    curveTo(12.0307f, 6.6883f, 12.017f, 6.5799f, 11.9967f, 6.4665f)
                    curveTo(11.9859f, 6.4733f, 11.9747f, 6.4798f, 11.9634f, 6.486f)
                    curveTo(11.7977f, 6.576f, 11.6252f, 6.5745f, 11.5004f, 6.555f)
                    curveTo(11.3735f, 6.5352f, 11.2617f, 6.4916f, 11.187f, 6.4574f)
                    curveTo(11.1484f, 6.4396f, 11.1164f, 6.4229f, 11.0933f, 6.4101f)
                    curveTo(11.0817f, 6.4037f, 11.0722f, 6.3982f, 11.0651f, 6.394f)
                    lineTo(11.0562f, 6.3887f)
                    lineTo(11.0532f, 6.3868f)
                    lineTo(11.052f, 6.3861f)
                    curveTo(11.052f, 6.3861f, 11.051f, 6.3855f, 11.228f, 6.103f)
                    moveTo(11.6411f, 5.8991f)
                    curveTo(11.6456f, 5.8907f, 11.6519f, 5.8756f, 11.6583f, 5.8505f)
                    curveTo(11.6783f, 5.7717f, 11.7106f, 5.6706f, 11.774f, 5.5886f)
                    curveTo(11.8081f, 5.5444f, 11.8684f, 5.4835f, 11.9626f, 5.4521f)
                    curveTo(12.0661f, 5.4177f, 12.1659f, 5.4336f, 12.2427f, 5.4704f)
                    curveTo(12.3649f, 5.5289f, 12.4284f, 5.6386f, 12.4526f, 5.6825f)
                    curveTo(12.4864f, 5.7436f, 12.5139f, 5.8126f, 12.5362f, 5.8779f)
                    moveTo(11.8686f, 6.0039f)
                    curveTo(11.8653f, 5.9995f, 11.8638f, 5.9965f, 11.8638f, 5.9965f)
                    curveTo(11.8638f, 5.9965f, 11.8655f, 5.9984f, 11.8686f, 6.0039f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF391800)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3718f, 6.3185f)
                    curveTo(17.5559f, 6.3185f, 17.7052f, 6.4678f, 17.7052f, 6.6519f)
                    curveTo(17.7052f, 6.9308f, 17.5876f, 7.1984f, 17.4515f, 7.4208f)
                    curveTo(17.3121f, 7.6487f, 17.1314f, 7.8641f, 16.9589f, 8.0461f)
                    curveTo(16.7853f, 8.2294f, 16.6129f, 8.3864f, 16.4845f, 8.4972f)
                    curveTo(16.42f, 8.5529f, 16.366f, 8.5974f, 16.3278f, 8.6283f)
                    curveTo(16.3086f, 8.6437f, 16.2934f, 8.6558f, 16.2827f, 8.6642f)
                    lineTo(16.2701f, 8.674f)
                    lineTo(16.2665f, 8.6768f)
                    lineTo(16.2654f, 8.6777f)
                    curveTo(16.2654f, 8.6777f, 16.2648f, 8.6781f, 16.062f, 8.4136f)
                    lineTo(16.2654f, 8.6777f)
                    curveTo(16.1193f, 8.7896f, 15.9095f, 8.7625f, 15.7975f, 8.6164f)
                    curveTo(15.6855f, 8.4703f, 15.7131f, 8.2611f, 15.8591f, 8.1491f)
                    moveTo(15.8591f, 8.1491f)
                    lineTo(15.8615f, 8.1473f)
                    lineTo(15.8708f, 8.14f)
                    curveTo(15.8793f, 8.1333f, 15.8922f, 8.1231f, 15.9089f, 8.1096f)
                    curveTo(15.9422f, 8.0827f, 15.9906f, 8.0428f, 16.0489f, 7.9925f)
                    curveTo(16.1661f, 7.8914f, 16.3211f, 7.7501f, 16.4749f, 7.5877f)
                    curveTo(16.63f, 7.424f, 16.7767f, 7.2463f, 16.8829f, 7.0729f)
                    curveTo(16.9924f, 6.8938f, 17.0385f, 6.7518f, 17.0385f, 6.6519f)
                    curveTo(17.0385f, 6.4678f, 17.1878f, 6.3185f, 17.3718f, 6.3185f)
                }
                path(fill = SolidColor(Color(0xFFE7413D)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(4.6665f, 5.6894f)
                    lineTo(3.0991f, 6.824f)
                    lineTo(3.6939f, 4.9827f)
                    lineTo(2.1304f, 3.8426f)
                    lineTo(4.0654f, 3.8393f)
                    lineTo(4.6665f, 2.0f)
                    lineTo(5.2677f, 3.8393f)
                    lineTo(7.2027f, 3.8426f)
                    lineTo(5.6392f, 4.9827f)
                    lineTo(6.234f, 6.824f)
                    lineTo(4.6665f, 5.6894f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(2.0E-4f, 0.0f)
                    horizontalLineTo(28.0002f)
                    lineTo(27.489f, 0.5f)
                    horizontalLineTo(0.4992f)
                    lineTo(2.0E-4f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 16.0034f)
                    lineTo(2.0E-4f, 0.0f)
                    lineTo(0.5f, 0.4864f)
                    lineTo(0.5f, 16.0034f)
                    horizontalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.5f, 16.0034f)
                    verticalLineTo(0.4864f)
                    lineTo(28.0002f, 0.0f)
                    lineTo(28.0f, 16.0034f)
                    horizontalLineTo(27.5f)
                    close()
                }
            }
        }
        .build()
        return _usCa!!
    }

private var _usCa: ImageVector? = null
