package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Ug: ImageVector
    get() {
        if (_ug != null) {
            return _ug!!
        }
        _ug = Builder(name = "Ug", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 2.0f)
                    curveTo(0.0f, 0.8954f, 0.8954f, 0.0f, 2.0f, 0.0f)
                    horizontalLineTo(26.0f)
                    curveTo(27.1046f, 0.0f, 28.0f, 0.8954f, 28.0f, 2.0f)
                    verticalLineTo(18.0f)
                    curveTo(28.0f, 19.1046f, 27.1046f, 20.0f, 26.0f, 20.0f)
                    horizontalLineTo(2.0f)
                    curveTo(0.8954f, 20.0f, 0.0f, 19.1046f, 0.0f, 18.0f)
                    verticalLineTo(2.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 2.6667f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(2.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 13.3333f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(10.6667f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(13.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFED1623)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 10.6667f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(6.6667f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(10.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFEE044)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 6.6667f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(2.6667f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(6.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFED1623)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(17.3333f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFEE044)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 17.3333f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(13.3333f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(17.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(14.0f, 14.6667f)
                    curveTo(16.5773f, 14.6667f, 18.6667f, 12.5773f, 18.6667f, 10.0f)
                    curveTo(18.6667f, 7.4227f, 16.5773f, 5.3333f, 14.0f, 5.3333f)
                    curveTo(11.4227f, 5.3333f, 9.3333f, 7.4227f, 9.3333f, 10.0f)
                    curveTo(9.3333f, 12.5773f, 11.4227f, 14.6667f, 14.0f, 14.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.9024f, 7.569f)
                    curveTo(12.7722f, 7.4389f, 12.7722f, 7.2278f, 12.9024f, 7.0976f)
                    lineTo(13.3142f, 6.6858f)
                    curveTo(13.3269f, 6.6731f, 13.3383f, 6.6597f, 13.3492f, 6.6453f)
                    curveTo(13.3842f, 6.5992f, 13.4735f, 6.4865f, 13.5778f, 6.3917f)
                    curveTo(13.7545f, 6.231f, 14.2579f, 6.2141f, 14.4323f, 6.3773f)
                    curveTo(14.4797f, 6.4216f, 14.5229f, 6.471f, 14.5591f, 6.5162f)
                    curveTo(14.631f, 6.6062f, 14.6353f, 6.7293f, 14.5838f, 6.8323f)
                    lineTo(14.0352f, 7.9296f)
                    curveTo(14.012f, 7.9759f, 14.0f, 8.0269f, 14.0f, 8.0787f)
                    verticalLineTo(8.4607f)
                    curveTo(14.0f, 8.5869f, 14.0713f, 8.7023f, 14.1843f, 8.7588f)
                    lineTo(15.285f, 9.3091f)
                    curveTo(15.317f, 9.3252f, 15.3462f, 9.3462f, 15.3716f, 9.3716f)
                    lineTo(16.4968f, 10.4968f)
                    curveTo(16.5982f, 10.5982f, 16.6234f, 10.7532f, 16.5592f, 10.8816f)
                    lineTo(16.2068f, 11.5863f)
                    curveTo(16.1051f, 11.7898f, 15.8339f, 11.8339f, 15.673f, 11.673f)
                    lineTo(15.569f, 11.569f)
                    curveTo(15.4389f, 11.4389f, 15.2278f, 11.4389f, 15.0976f, 11.569f)
                    lineTo(14.7643f, 11.9024f)
                    curveTo(14.7018f, 11.9649f, 14.6667f, 12.0497f, 14.6667f, 12.1381f)
                    verticalLineTo(12.5286f)
                    curveTo(14.6667f, 12.617f, 14.7018f, 12.7018f, 14.7643f, 12.7643f)
                    curveTo(14.9743f, 12.9743f, 14.8256f, 13.3333f, 14.5286f, 13.3333f)
                    horizontalLineTo(14.1381f)
                    curveTo(13.8411f, 13.3333f, 13.6924f, 12.9743f, 13.9024f, 12.7643f)
                    curveTo(13.9649f, 12.7018f, 14.0f, 12.617f, 14.0f, 12.5286f)
                    verticalLineTo(12.3333f)
                    curveTo(14.0f, 12.1492f, 13.8508f, 12.0f, 13.6667f, 12.0f)
                    horizontalLineTo(13.4714f)
                    curveTo(13.383f, 12.0f, 13.2982f, 12.0351f, 13.2357f, 12.0976f)
                    lineTo(12.9024f, 12.431f)
                    curveTo(12.7722f, 12.5611f, 12.5611f, 12.5611f, 12.431f, 12.431f)
                    lineTo(12.2357f, 12.2357f)
                    curveTo(12.1055f, 12.1055f, 12.1055f, 11.8945f, 12.2357f, 11.7643f)
                    lineTo(12.569f, 11.431f)
                    curveTo(12.6315f, 11.3685f, 12.7163f, 11.3333f, 12.8047f, 11.3333f)
                    horizontalLineTo(13.1953f)
                    curveTo(13.4922f, 11.3333f, 13.641f, 10.9743f, 13.431f, 10.7643f)
                    lineTo(12.2357f, 9.569f)
                    curveTo(12.1055f, 9.4389f, 12.1055f, 9.2278f, 12.2357f, 9.0976f)
                    lineTo(13.0976f, 8.2357f)
                    curveTo(13.2278f, 8.1055f, 13.2278f, 7.8945f, 13.0976f, 7.7643f)
                    lineTo(12.9024f, 7.569f)
                    close()
                }
            }
        }
        .build()
        return _ug!!
    }

private var _ug: ImageVector? = null
