package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Sx: ImageVector
    get() {
        if (_sx != null) {
            return _sx!!
        }
        _sx = Builder(name = "Sx", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0740AA)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 10.0f)
                    horizontalLineTo(2.0E-4f)
                    lineTo(0.0f, 20.0f)
                    horizontalLineTo(28.0f)
                    lineTo(28.0002f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF02C33)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    lineTo(2.0E-4f, 10.0f)
                    horizontalLineTo(28.0002f)
                    lineTo(28.0f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 0.0f)
                    lineTo(13.3333f, 10.0f)
                    lineTo(0.0f, 20.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE72C33)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(2.0002f, 9.3333f)
                    verticalLineTo(7.3415f)
                    curveTo(2.0002f, 6.6021f, 2.5845f, 6.0f, 3.3273f, 6.0f)
                    horizontalLineTo(6.0063f)
                    curveTo(6.7412f, 6.0f, 7.3335f, 6.6097f, 7.3335f, 7.3415f)
                    verticalLineTo(9.3333f)
                    curveTo(7.3335f, 10.4594f, 6.8211f, 11.2622f, 5.9955f, 11.73f)
                    curveTo(5.5184f, 12.0003f, 5.0523f, 12.1091f, 4.6225f, 12.1319f)
                    curveTo(4.2814f, 12.1091f, 3.8152f, 12.0003f, 3.3382f, 11.73f)
                    curveTo(2.5126f, 11.2622f, 2.0002f, 10.4594f, 2.0002f, 9.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF78C1F0)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(2.6668f, 9.3333f)
                    verticalLineTo(7.3415f)
                    curveTo(2.6668f, 6.9688f, 2.9545f, 6.6667f, 3.3273f, 6.6667f)
                    horizontalLineTo(6.0063f)
                    curveTo(6.3711f, 6.6667f, 6.6668f, 6.9762f, 6.6668f, 7.3415f)
                    verticalLineTo(9.3333f)
                    curveTo(6.6668f, 11.3333f, 4.6668f, 11.4667f, 4.6668f, 11.4667f)
                    curveTo(4.6668f, 11.4667f, 2.6668f, 11.3333f, 2.6668f, 9.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(4.0002f, 8.6667f)
                    lineTo(4.6668f, 8.0f)
                    lineTo(5.3335f, 8.6667f)
                    verticalLineTo(10.0f)
                    horizontalLineTo(4.0002f)
                    verticalLineTo(8.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF9D835)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(1.3352f, 12.4907f)
                    curveTo(2.1427f, 13.4213f, 3.415f, 14.0f, 4.6668f, 14.0f)
                    curveTo(5.9308f, 14.0f, 7.2206f, 13.4026f, 8.0282f, 12.4511f)
                    curveTo(8.2665f, 12.1704f, 8.2321f, 11.7497f, 7.9514f, 11.5115f)
                    curveTo(7.6707f, 11.2732f, 7.25f, 11.3076f, 7.0117f, 11.5883f)
                    curveTo(6.4573f, 12.2414f, 5.5392f, 12.6666f, 4.6668f, 12.6666f)
                    curveTo(3.8009f, 12.6666f, 2.8961f, 12.2552f, 2.3423f, 11.6168f)
                    curveTo(2.1009f, 11.3387f, 1.6799f, 11.3089f, 1.4018f, 11.5502f)
                    curveTo(1.1237f, 11.7915f, 1.0939f, 12.2126f, 1.3352f, 12.4907f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF7E14B)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(4.6668f, 7.3333f)
                    curveTo(5.4032f, 7.3333f, 6.0002f, 6.7364f, 6.0002f, 6.0f)
                    curveTo(6.0002f, 5.2636f, 5.4032f, 4.6667f, 4.6668f, 4.6667f)
                    curveTo(3.9304f, 4.6667f, 3.3335f, 5.2636f, 3.3335f, 6.0f)
                    curveTo(3.3335f, 6.7364f, 3.9304f, 7.3333f, 4.6668f, 7.3333f)
                    close()
                }
            }
        }
        .build()
        return _sx!!
    }

private var _sx: ImageVector? = null
