package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Pn: ImageVector
    get() {
        if (_pn != null) {
            return _pn!!
        }
        _pn = Builder(name = "Pn", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 0.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF07319C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 0.0f)
                    horizontalLineTo(2.0E-4f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0002f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF1F8BDE)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3333f, 12.6667f)
                    verticalLineTo(8.6795f)
                    curveTo(17.3333f, 8.3042f, 17.6198f, 8.0f, 17.9969f, 8.0f)
                    horizontalLineTo(23.3364f)
                    curveTo(23.7029f, 8.0f, 24.0f, 8.3021f, 24.0f, 8.6795f)
                    verticalLineTo(12.6667f)
                    curveTo(24.0f, 16.0f, 20.6667f, 17.3333f, 20.6667f, 17.3333f)
                    curveTo(20.6667f, 17.3333f, 17.3333f, 16.0f, 17.3333f, 12.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF7E14A)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(16.6667f, 16.0f)
                    lineTo(20.6667f, 8.0f)
                    lineTo(24.6667f, 16.0f)
                    verticalLineTo(18.6667f)
                    horizontalLineTo(16.6667f)
                    verticalLineTo(16.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF4B8C36)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3333f, 16.1574f)
                    verticalLineTo(18.0f)
                    horizontalLineTo(24.0f)
                    verticalLineTo(16.1574f)
                    lineTo(20.6667f, 9.4907f)
                    lineTo(17.3333f, 16.1574f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF07319C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(24.0f, 12.6667f)
                    curveTo(24.0f, 13.223f, 23.9072f, 13.7236f, 23.7525f, 14.1716f)
                    lineTo(24.6667f, 16.0f)
                    verticalLineTo(18.6667f)
                    horizontalLineTo(16.6667f)
                    verticalLineTo(16.0f)
                    lineTo(17.5809f, 14.1716f)
                    curveTo(18.3531f, 16.4079f, 20.6667f, 17.3333f, 20.6667f, 17.3333f)
                    curveTo(20.6667f, 17.3333f, 24.0f, 16.0f, 24.0f, 12.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0007f, 0.9474f)
                    lineTo(11.4315f, 3.1023f)
                    horizontalLineTo(14.0007f)
                    verticalLineTo(6.67f)
                    horizontalLineTo(11.432f)
                    lineTo(14.0007f, 8.8238f)
                    verticalLineTo(10.0025f)
                    horizontalLineTo(10.8046f)
                    lineTo(8.7865f, 8.3128f)
                    verticalLineTo(10.0025f)
                    horizontalLineTo(5.2151f)
                    verticalLineTo(8.3113f)
                    lineTo(3.1934f, 10.0025f)
                    horizontalLineTo(1.0E-4f)
                    verticalLineTo(8.8136f)
                    lineTo(2.5636f, 6.67f)
                    horizontalLineTo(1.0E-4f)
                    verticalLineTo(3.1023f)
                    horizontalLineTo(2.5673f)
                    lineTo(1.0E-4f, 0.952f)
                    verticalLineTo(0.0025f)
                    horizontalLineTo(3.4736f)
                    lineTo(5.2151f, 1.4601f)
                    verticalLineTo(0.0025f)
                    horizontalLineTo(8.7865f)
                    verticalLineTo(1.463f)
                    lineTo(10.5353f, 0.0025f)
                    horizontalLineTo(14.0007f)
                    verticalLineTo(0.9474f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.683f, 4.1023f)
                    lineTo(13.5711f, 0.0026f)
                    lineTo(12.0944f, -0.0f)
                    lineTo(7.7865f, 3.601f)
                    verticalLineTo(0.0044f)
                    lineTo(6.2151f, 0.0044f)
                    verticalLineTo(3.6011f)
                    lineTo(1.9282f, 0.0131f)
                    lineTo(0.4263f, 0.0045f)
                    lineTo(5.3184f, 4.1023f)
                    horizontalLineTo(7.0E-4f)
                    verticalLineTo(5.67f)
                    horizontalLineTo(5.3184f)
                    lineTo(0.1392f, 10.0008f)
                    lineTo(1.6392f, 9.9989f)
                    lineTo(6.2151f, 6.171f)
                    verticalLineTo(10.0004f)
                    horizontalLineTo(7.7865f)
                    verticalLineTo(6.1712f)
                    lineTo(12.3601f, 10.0008f)
                    lineTo(13.8504f, 10.0028f)
                    lineTo(8.6831f, 5.67f)
                    horizontalLineTo(14.0007f)
                    verticalLineTo(4.1023f)
                    horizontalLineTo(8.683f)
                    close()
                }
            }
        }
        .build()
        return _pn!!
    }

private var _pn: ImageVector? = null
