package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Pf: ImageVector
    get() {
        if (_pf != null) {
            return _pf!!
        }
        _pf = Builder(name = "Pf", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE02639)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(5.3333f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC2235)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0002f, 14.6667f)
                    horizontalLineTo(2.0E-4f)
                    lineTo(0.0f, 20.0f)
                    horizontalLineTo(28.0f)
                    lineTo(28.0002f, 14.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 5.3333f)
                    horizontalLineTo(0.0f)
                    lineTo(2.0E-4f, 14.6667f)
                    horizontalLineTo(28.0002f)
                    lineTo(28.0f, 5.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFA135)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3335f, 6.6667f)
                    horizontalLineTo(10.6668f)
                    verticalLineTo(10.0f)
                    horizontalLineTo(17.3335f)
                    verticalLineTo(6.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.0f, 8.6666f)
                    horizontalLineTo(16.0f)
                    lineTo(15.3333f, 10.0f)
                    horizontalLineTo(12.6667f)
                    lineTo(12.0f, 8.6666f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDF2034)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(13.3333f, 6.6666f)
                    horizontalLineTo(14.6667f)
                    verticalLineTo(8.6604f)
                    curveTo(14.6667f, 9.032f, 14.3574f, 9.3333f, 14.0f, 9.3333f)
                    curveTo(13.6318f, 9.3333f, 13.3333f, 9.0479f, 13.3333f, 8.6604f)
                    verticalLineTo(6.6666f)
                    close()
                    moveTo(12.0f, 8.0f)
                    curveTo(12.0f, 8.0f, 13.0f, 10.0f, 14.0f, 10.0f)
                    curveTo(15.0f, 10.0f, 16.0f, 8.0f, 16.0f, 8.0f)
                    verticalLineTo(9.3333f)
                    curveTo(16.0f, 10.0697f, 15.4098f, 10.6666f, 14.6681f, 10.6666f)
                    horizontalLineTo(13.3319f)
                    curveTo(12.5963f, 10.6666f, 12.0f, 10.0748f, 12.0f, 9.3333f)
                    verticalLineTo(8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0B4BAD)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3333f, 10.6666f)
                    horizontalLineTo(10.6667f)
                    verticalLineTo(13.3333f)
                    horizontalLineTo(17.3333f)
                    verticalLineTo(10.6666f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(10.6667f, 11.3333f)
                    horizontalLineTo(17.3333f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(10.6667f)
                    verticalLineTo(11.3333f)
                    close()
                }
            }
        }
        .build()
        return _pf!!
    }

private var _pf: ImageVector? = null
