package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Nz: ImageVector
    get() {
        if (_nz != null) {
            return _nz!!
        }
        _nz = Builder(name = "Nz", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    curveTo(9.3333f, 0.0f, 18.6667f, 0.0f, 28.0f, 0.0f)
                    curveTo(28.0f, 6.6667f, 28.0f, 13.3333f, 28.0f, 20.0f)
                    curveTo(18.6667f, 20.0f, 9.3333f, 20.0f, 0.0f, 20.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0A17A7)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFCA1931)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0f, 17.3333f)
                    lineTo(19.0572f, 17.6095f)
                    lineTo(19.3333f, 16.6667f)
                    lineTo(19.0572f, 15.7239f)
                    lineTo(20.0f, 16.0f)
                    lineTo(20.9428f, 15.7239f)
                    lineTo(20.6667f, 16.6667f)
                    lineTo(20.9428f, 17.6095f)
                    lineTo(20.0f, 17.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFCA1931)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0f, 4.6667f)
                    lineTo(19.0572f, 4.9428f)
                    lineTo(19.3333f, 4.0f)
                    lineTo(19.0572f, 3.0572f)
                    lineTo(20.0f, 3.3333f)
                    lineTo(20.9428f, 3.0572f)
                    lineTo(20.6667f, 4.0f)
                    lineTo(20.9428f, 4.9428f)
                    lineTo(20.0f, 4.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFCA1931)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(24.0f, 8.6667f)
                    lineTo(23.0572f, 8.9428f)
                    lineTo(23.3333f, 8.0f)
                    lineTo(23.0572f, 7.0572f)
                    lineTo(24.0f, 7.3333f)
                    lineTo(24.9428f, 7.0572f)
                    lineTo(24.6667f, 8.0f)
                    lineTo(24.9428f, 8.9428f)
                    lineTo(24.0f, 8.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFCA1931)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(16.0f, 10.0f)
                    lineTo(15.0572f, 10.2761f)
                    lineTo(15.3333f, 9.3333f)
                    lineTo(15.0572f, 8.3905f)
                    lineTo(16.0f, 8.6667f)
                    lineTo(16.9428f, 8.3905f)
                    lineTo(16.6667f, 9.3333f)
                    lineTo(16.9428f, 10.2761f)
                    lineTo(16.0f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0006f, 0.9446f)
                    lineTo(11.4314f, 3.0995f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(6.6672f)
                    horizontalLineTo(11.4319f)
                    lineTo(14.0006f, 8.821f)
                    verticalLineTo(9.9998f)
                    horizontalLineTo(10.8044f)
                    lineTo(8.7864f, 8.3101f)
                    verticalLineTo(9.9998f)
                    horizontalLineTo(5.215f)
                    verticalLineTo(8.3085f)
                    lineTo(3.1932f, 9.9998f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(8.8108f)
                    lineTo(2.5635f, 6.6672f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(3.0995f)
                    horizontalLineTo(2.5671f)
                    lineTo(0.0f, 0.9492f)
                    verticalLineTo(0.0f)
                    lineTo(3.4735f, -2.0E-4f)
                    lineTo(5.215f, 1.4573f)
                    verticalLineTo(-2.0E-4f)
                    horizontalLineTo(8.7864f)
                    verticalLineTo(1.4602f)
                    lineTo(10.5352f, -2.0E-4f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(0.9446f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6828f, 4.0995f)
                    lineTo(13.571f, -2.0E-4f)
                    lineTo(12.0943f, -0.0028f)
                    lineTo(7.7864f, 3.5982f)
                    verticalLineTo(0.0016f)
                    lineTo(6.215f, 0.0016f)
                    verticalLineTo(3.5983f)
                    lineTo(1.9281f, 0.0103f)
                    lineTo(0.4262f, 0.0017f)
                    lineTo(5.3183f, 4.0995f)
                    horizontalLineTo(6.0E-4f)
                    verticalLineTo(5.6672f)
                    horizontalLineTo(5.3183f)
                    lineTo(0.139f, 9.998f)
                    lineTo(1.6391f, 9.9961f)
                    lineTo(6.215f, 6.1682f)
                    verticalLineTo(9.9976f)
                    horizontalLineTo(7.7864f)
                    verticalLineTo(6.1684f)
                    lineTo(12.36f, 9.998f)
                    lineTo(13.8503f, 10.0f)
                    lineTo(8.6829f, 5.6672f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(4.0995f)
                    horizontalLineTo(8.6828f)
                    close()
                }
            }
        }
        .build()
        return _nz!!
    }

private var _nz: ImageVector? = null
