package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Np: ImageVector
    get() {
        if (_np != null) {
            return _np!!
        }
        _np = Builder(name = "Np", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(1.0E-4f, -0.0f)
                    lineTo(27.9951f, -0.0f)
                    curveTo(28.0318f, 6.6657f, 28.0f, 20.0f, 28.0f, 20.0f)
                    lineTo(2.0001f, 20.0f)
                    curveTo(0.8955f, 20.0f, 0.0f, 20.0f, 0.0f, 20.0f)
                    curveTo(0.0f, 13.3333f, -0.0f, 6.6666f, 1.0E-4f, -0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(1.0E-4f, -0.0f)
                    lineTo(2.4649f, -0.0f)
                    curveTo(2.5965f, -0.0f, 2.7252f, 0.0389f, 2.8347f, 0.112f)
                    lineTo(15.0026f, 8.2239f)
                    curveTo(16.1003f, 8.9557f, 15.5822f, 10.6667f, 14.263f, 10.6667f)
                    horizontalLineTo(8.0001f)
                    lineTo(15.9961f, 17.6632f)
                    curveTo(16.9227f, 18.4739f, 16.3493f, 20.0f, 15.1181f, 20.0f)
                    horizontalLineTo(2.0001f)
                    curveTo(0.8955f, 20.0f, 0.0f, 20.0f, 0.0f, 20.0f)
                    curveTo(0.0f, 13.3333f, -0.0f, 6.6666f, 1.0E-4f, -0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFEE1B44)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(1.0E-4f, -0.0f)
                    lineTo(2.4649f, -0.0f)
                    curveTo(2.5965f, -0.0f, 2.7252f, 0.0389f, 2.8347f, 0.112f)
                    lineTo(15.0026f, 8.2239f)
                    curveTo(16.1003f, 8.9557f, 15.5822f, 10.6667f, 14.263f, 10.6667f)
                    horizontalLineTo(8.0001f)
                    lineTo(15.9961f, 17.6632f)
                    curveTo(16.9227f, 18.4739f, 16.3493f, 20.0f, 15.1181f, 20.0f)
                    horizontalLineTo(0.0f)
                    lineTo(1.0E-4f, -0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0543A8)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(14.263f, 10.6667f)
                    curveTo(15.5822f, 10.6667f, 16.1003f, 8.9557f, 15.0026f, 8.2239f)
                    lineTo(2.8347f, 0.112f)
                    curveTo(2.7252f, 0.0389f, 2.5965f, -0.0f, 2.4649f, -0.0f)
                    lineTo(1.0E-4f, -0.0f)
                    lineTo(0.0f, 20.0f)
                    horizontalLineTo(15.1181f)
                    curveTo(16.3493f, 20.0f, 16.9227f, 18.4739f, 15.9961f, 17.6632f)
                    lineTo(8.0001f, 10.6667f)
                    horizontalLineTo(14.263f)
                    close()
                    moveTo(1.3334f, 18.6667f)
                    horizontalLineTo(15.1181f)
                    lineTo(7.1221f, 11.6701f)
                    curveTo(6.704f, 11.3043f, 6.5566f, 10.7177f, 6.7519f, 10.1977f)
                    curveTo(6.9473f, 9.6777f, 7.4446f, 9.3333f, 8.0001f, 9.3333f)
                    horizontalLineTo(14.263f)
                    lineTo(2.263f, 1.3333f)
                    horizontalLineTo(1.3334f)
                    verticalLineTo(18.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(6.8512f, 7.8007f)
                    curveTo(7.2353f, 7.6955f, 7.5894f, 7.5515f, 7.9026f, 7.3761f)
                    curveTo(7.5919f, 8.5045f, 6.5584f, 9.3333f, 5.3313f, 9.3333f)
                    curveTo(4.1042f, 9.3333f, 3.0707f, 8.5045f, 2.7601f, 7.3761f)
                    curveTo(3.0741f, 7.552f, 3.4293f, 7.6963f, 3.8147f, 7.8016f)
                    lineTo(4.3334f, 7.3333f)
                    lineTo(3.4856f, 6.5679f)
                    lineTo(4.6263f, 6.6262f)
                    lineTo(4.568f, 5.4856f)
                    lineTo(5.3334f, 6.3333f)
                    lineTo(6.0988f, 5.4856f)
                    lineTo(6.0405f, 6.6262f)
                    lineTo(7.1812f, 6.5679f)
                    lineTo(6.3334f, 7.3333f)
                    lineTo(6.8512f, 7.8007f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(4.313f, 17.1303f)
                    lineTo(5.3335f, 16.0f)
                    lineTo(6.354f, 17.1303f)
                    lineTo(6.2763f, 15.6095f)
                    lineTo(7.7972f, 15.6871f)
                    lineTo(6.6669f, 14.6667f)
                    lineTo(7.7972f, 13.6462f)
                    lineTo(6.2763f, 13.7238f)
                    lineTo(6.354f, 12.203f)
                    lineTo(5.3335f, 13.3333f)
                    lineTo(4.313f, 12.203f)
                    lineTo(4.3907f, 13.7238f)
                    lineTo(2.8698f, 13.6462f)
                    lineTo(4.0002f, 14.6667f)
                    lineTo(2.8698f, 15.6871f)
                    lineTo(4.3907f, 15.6095f)
                    lineTo(4.313f, 17.1303f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(2.522f, -0.0f)
                    horizontalLineTo(28.0f)
                    lineTo(27.5099f, 0.5f)
                    horizontalLineTo(3.4227f)
                    lineTo(2.522f, -0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(16.166f, 19.5f)
                    horizontalLineTo(27.5005f)
                    lineTo(28.0f, 20.0f)
                    curveTo(28.0f, 20.0f, 14.5311f, 20.0f, 15.1645f, 20.0f)
                    curveTo(15.7979f, 20.0f, 16.166f, 19.5f, 16.166f, 19.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(27.5f, 19.5025f)
                    verticalLineTo(0.5116f)
                    lineTo(28.0f, -0.0f)
                    lineTo(28.0f, 20.0f)
                    lineTo(27.5f, 19.5025f)
                    close()
                }
            }
        }
        .build()
        return _np!!
    }

private var _np: ImageVector? = null
