package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Ms: ImageVector
    get() {
        if (_ms != null) {
            return _ms!!
        }
        _ms = Builder(name = "Ms", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    curveTo(28.0f, 0.0f, 28.0f, 0.8954f, 28.0f, 2.0f)
                    verticalLineTo(20.0f)
                    curveTo(28.0f, 20.0f, 27.1046f, 20.0f, 26.0f, 20.0f)
                    horizontalLineTo(2.0f)
                    curveTo(0.8954f, 20.0f, 0.0f, 20.0f, 0.0f, 20.0f)
                    curveTo(0.0f, 13.3333f, 0.0f, 6.6667f, 0.0f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF07319C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFA63D09)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3335f, 10.0f)
                    curveTo(17.3335f, 8.9062f, 17.3335f, 7.6131f, 17.3335f, 6.6658f)
                    curveTo(17.3335f, 5.9294f, 17.9305f, 5.3333f, 18.6668f, 5.3333f)
                    horizontalLineTo(22.6668f)
                    curveTo(23.4032f, 5.3333f, 24.0002f, 5.9294f, 24.0002f, 6.6658f)
                    curveTo(24.0002f, 7.6131f, 24.0002f, 8.9062f, 24.0002f, 10.0f)
                    curveTo(24.0002f, 13.3333f, 20.6668f, 14.6666f, 20.6668f, 14.6666f)
                    curveTo(20.6668f, 14.6666f, 17.3335f, 13.3333f, 17.3335f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF08B9D6)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3335f, 6.6658f)
                    verticalLineTo(10.0f)
                    curveTo(17.3335f, 10.7709f, 17.5118f, 11.4348f, 17.7859f, 12.0f)
                    horizontalLineTo(23.5478f)
                    curveTo(23.8219f, 11.4348f, 24.0002f, 10.7709f, 24.0002f, 10.0f)
                    verticalLineTo(6.6658f)
                    curveTo(24.0002f, 5.9294f, 23.4032f, 5.3333f, 22.6668f, 5.3333f)
                    horizontalLineTo(18.6668f)
                    curveTo(17.9305f, 5.3333f, 17.3335f, 5.9294f, 17.3335f, 6.6658f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF262626)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(21.3338f, 6.6666f)
                    horizontalLineTo(20.0005f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(18.667f)
                    verticalLineTo(9.3333f)
                    horizontalLineTo(20.0005f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(21.3338f)
                    verticalLineTo(9.3333f)
                    horizontalLineTo(22.667f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(21.3338f)
                    verticalLineTo(6.6666f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0006f, 0.9474f)
                    lineTo(11.4314f, 3.1023f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(6.67f)
                    horizontalLineTo(11.4319f)
                    lineTo(14.0006f, 8.8238f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(10.8044f)
                    lineTo(8.7864f, 8.3129f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(5.215f)
                    verticalLineTo(8.3113f)
                    lineTo(3.1932f, 10.0026f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(8.8136f)
                    lineTo(2.5635f, 6.67f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(3.1023f)
                    horizontalLineTo(2.5671f)
                    lineTo(0.0f, 0.952f)
                    verticalLineTo(0.0026f)
                    horizontalLineTo(3.4735f)
                    lineTo(5.215f, 1.4601f)
                    verticalLineTo(0.0026f)
                    horizontalLineTo(8.7864f)
                    verticalLineTo(1.463f)
                    lineTo(10.5352f, 0.0026f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(0.9474f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6828f, 4.1023f)
                    lineTo(13.571f, 0.0026f)
                    lineTo(12.0943f, 0.0f)
                    lineTo(7.7864f, 3.601f)
                    verticalLineTo(0.0045f)
                    lineTo(6.215f, 0.0045f)
                    verticalLineTo(3.6011f)
                    lineTo(1.9281f, 0.0131f)
                    lineTo(0.4262f, 0.0045f)
                    lineTo(5.3183f, 4.1023f)
                    horizontalLineTo(6.0E-4f)
                    verticalLineTo(5.67f)
                    horizontalLineTo(5.3183f)
                    lineTo(0.139f, 10.0008f)
                    lineTo(1.6391f, 9.9989f)
                    lineTo(6.215f, 6.171f)
                    verticalLineTo(10.0004f)
                    horizontalLineTo(7.7864f)
                    verticalLineTo(6.1713f)
                    lineTo(12.36f, 10.0008f)
                    lineTo(13.8503f, 10.0028f)
                    lineTo(8.6829f, 5.67f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(4.1023f)
                    horizontalLineTo(8.6828f)
                    close()
                }
            }
        }
        .build()
        return _ms!!
    }

private var _ms: ImageVector? = null
