package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Mq: ImageVector
    get() {
        if (_mq != null) {
            return _mq!!
        }
        _mq = Builder(name = "Mq", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF345CB3)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.0f, 8.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(12.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(16.0f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(16.0f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(12.0f)
                    verticalLineTo(8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(6.3835f, 2.1475f)
                    curveTo(6.1795f, 2.1319f, 5.9588f, 2.1304f, 5.7564f, 2.1372f)
                    curveTo(5.6971f, 2.1396f, 5.6874f, 2.14f, 5.6779f, 2.1405f)
                    lineTo(5.672f, 2.1408f)
                    curveTo(5.4882f, 2.1515f, 5.3306f, 2.0111f, 5.32f, 1.8273f)
                    curveTo(5.3093f, 1.6435f, 5.4497f, 1.4859f, 5.6335f, 1.4753f)
                    curveTo(5.6541f, 1.4741f, 5.6541f, 1.4741f, 5.7337f, 1.471f)
                    curveTo(5.9586f, 1.4633f, 6.2022f, 1.465f, 6.4345f, 1.4828f)
                    curveTo(7.0302f, 1.5285f, 7.3882f, 1.6403f, 7.483f, 2.0046f)
                    curveTo(7.5505f, 2.264f, 7.4227f, 2.453f, 7.1925f, 2.6212f)
                    curveTo(7.1323f, 2.6651f, 7.0645f, 2.7081f, 6.9772f, 2.7591f)
                    curveTo(6.9297f, 2.7869f, 6.8676f, 2.822f, 6.7606f, 2.8826f)
                    lineTo(6.7585f, 2.8838f)
                    curveTo(6.4452f, 3.0631f, 6.3486f, 3.1601f, 6.3543f, 3.1804f)
                    curveTo(6.3601f, 3.2014f, 6.5319f, 3.2655f, 6.9335f, 3.3284f)
                    lineTo(7.0254f, 3.3427f)
                    curveTo(7.3721f, 3.3964f, 7.5261f, 3.4289f, 7.6859f, 3.4997f)
                    curveTo(7.984f, 3.6318f, 8.1448f, 3.8881f, 8.0481f, 4.2134f)
                    curveTo(7.9546f, 4.528f, 7.7575f, 4.6632f, 7.2955f, 4.7816f)
                    curveTo(7.4078f, 4.7905f, 7.5121f, 4.8044f, 7.6082f, 4.8236f)
                    curveTo(8.127f, 4.9274f, 8.4545f, 5.2098f, 8.4029f, 5.6812f)
                    curveTo(8.3217f, 6.4229f, 7.528f, 6.7245f, 6.6148f, 6.6045f)
                    curveTo(5.8717f, 6.5068f, 5.2542f, 6.1603f, 5.1087f, 5.6518f)
                    curveTo(4.8688f, 5.6975f, 4.6729f, 5.7402f, 4.5444f, 5.771f)
                    curveTo(4.3654f, 5.814f, 4.1855f, 5.7036f, 4.1426f, 5.5246f)
                    curveTo(4.0996f, 5.3456f, 4.21f, 5.1657f, 4.389f, 5.1227f)
                    curveTo(4.5618f, 5.0813f, 4.8412f, 5.0213f, 5.1823f, 4.9601f)
                    curveTo(5.3695f, 4.5904f, 5.8003f, 4.4114f, 6.5084f, 4.267f)
                    curveTo(6.6087f, 4.2469f, 6.6244f, 4.2438f, 6.6955f, 4.2298f)
                    curveTo(6.7035f, 4.2283f, 6.712f, 4.2266f, 6.7215f, 4.2247f)
                    curveTo(6.7278f, 4.2235f, 6.7345f, 4.2222f, 6.7417f, 4.2208f)
                    curveTo(7.0352f, 4.163f, 7.2187f, 4.1127f, 7.3173f, 4.0755f)
                    curveTo(7.2338f, 4.0529f, 7.1144f, 4.0311f, 6.9233f, 4.0015f)
                    lineTo(6.8302f, 3.9871f)
                    curveTo(6.1256f, 3.8766f, 5.8255f, 3.7647f, 5.7123f, 3.3602f)
                    curveTo(5.5831f, 2.8985f, 5.8382f, 2.6423f, 6.4274f, 2.3052f)
                    lineTo(6.6478f, 2.1791f)
                    curveTo(6.5749f, 2.1684f, 6.4847f, 2.1553f, 6.3835f, 2.1475f)
                    close()
                    moveTo(5.789f, 5.5364f)
                    curveTo(5.9077f, 5.7089f, 6.2492f, 5.884f, 6.7017f, 5.9435f)
                    curveTo(7.2938f, 6.0213f, 7.7124f, 5.8622f, 7.7402f, 5.6087f)
                    curveTo(7.7454f, 5.5612f, 7.6997f, 5.5218f, 7.4774f, 5.4774f)
                    curveTo(7.2044f, 5.4227f, 6.7989f, 5.4235f, 6.3035f, 5.4727f)
                    curveTo(6.1378f, 5.4892f, 5.9655f, 5.5107f, 5.789f, 5.5364f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(21.8503f, 2.1475f)
                    curveTo(21.6463f, 2.1319f, 21.4256f, 2.1304f, 21.2232f, 2.1372f)
                    curveTo(21.1524f, 2.14f, 21.1524f, 2.14f, 21.1388f, 2.1408f)
                    curveTo(20.955f, 2.1515f, 20.7974f, 2.0111f, 20.7868f, 1.8273f)
                    curveTo(20.7761f, 1.6435f, 20.9165f, 1.4859f, 21.1003f, 1.4753f)
                    curveTo(21.1209f, 1.4741f, 21.1209f, 1.4741f, 21.2005f, 1.471f)
                    curveTo(21.4254f, 1.4633f, 21.669f, 1.465f, 21.9013f, 1.4828f)
                    curveTo(22.497f, 1.5285f, 22.855f, 1.6403f, 22.9498f, 2.0046f)
                    curveTo(23.0173f, 2.264f, 22.8895f, 2.453f, 22.6593f, 2.6212f)
                    curveTo(22.5991f, 2.6651f, 22.5313f, 2.7081f, 22.444f, 2.7591f)
                    curveTo(22.3966f, 2.7868f, 22.3346f, 2.8219f, 22.2279f, 2.8823f)
                    lineTo(22.2253f, 2.8838f)
                    curveTo(21.912f, 3.0631f, 21.8154f, 3.1601f, 21.8211f, 3.1804f)
                    curveTo(21.8269f, 3.2014f, 21.9987f, 3.2655f, 22.4003f, 3.3284f)
                    lineTo(22.4922f, 3.3427f)
                    curveTo(22.8389f, 3.3964f, 22.9929f, 3.4289f, 23.1527f, 3.4997f)
                    curveTo(23.4508f, 3.6318f, 23.6116f, 3.8881f, 23.5149f, 4.2134f)
                    curveTo(23.4214f, 4.528f, 23.2243f, 4.6632f, 22.7623f, 4.7816f)
                    curveTo(22.8745f, 4.7905f, 22.9789f, 4.8044f, 23.075f, 4.8236f)
                    curveTo(23.5938f, 4.9274f, 23.9213f, 5.2098f, 23.8697f, 5.6812f)
                    curveTo(23.7885f, 6.4229f, 22.9948f, 6.7245f, 22.0816f, 6.6045f)
                    curveTo(21.3385f, 6.5068f, 20.721f, 6.1603f, 20.5755f, 5.6518f)
                    curveTo(20.3356f, 5.6975f, 20.1397f, 5.7402f, 20.0112f, 5.771f)
                    curveTo(19.8322f, 5.814f, 19.6523f, 5.7036f, 19.6094f, 5.5246f)
                    curveTo(19.5664f, 5.3456f, 19.6768f, 5.1657f, 19.8558f, 5.1227f)
                    curveTo(20.0286f, 5.0813f, 20.308f, 5.0213f, 20.6491f, 4.9601f)
                    curveTo(20.8363f, 4.5904f, 21.2671f, 4.4114f, 21.9752f, 4.267f)
                    curveTo(21.99f, 4.2641f, 22.0035f, 4.2613f, 22.015f, 4.259f)
                    curveTo(22.0959f, 4.2428f, 22.1085f, 4.2403f, 22.2086f, 4.2208f)
                    curveTo(22.5022f, 4.163f, 22.6855f, 4.1127f, 22.7841f, 4.0755f)
                    curveTo(22.7006f, 4.0529f, 22.5812f, 4.0311f, 22.3901f, 4.0015f)
                    lineTo(22.297f, 3.9871f)
                    curveTo(21.5924f, 3.8766f, 21.2923f, 3.7647f, 21.1791f, 3.3602f)
                    curveTo(21.0499f, 2.8985f, 21.305f, 2.6423f, 21.8942f, 2.3052f)
                    lineTo(22.1146f, 2.1791f)
                    curveTo(22.0417f, 2.1684f, 21.9515f, 2.1553f, 21.8503f, 2.1475f)
                    close()
                    moveTo(21.2558f, 5.5364f)
                    curveTo(21.3745f, 5.7089f, 21.716f, 5.884f, 22.1685f, 5.9435f)
                    curveTo(22.7606f, 6.0213f, 23.1792f, 5.8622f, 23.207f, 5.6087f)
                    curveTo(23.2122f, 5.5612f, 23.1665f, 5.5218f, 22.9443f, 5.4774f)
                    curveTo(22.6712f, 5.4227f, 22.2656f, 5.4235f, 21.7703f, 5.4727f)
                    curveTo(21.6046f, 5.4892f, 21.4323f, 5.5107f, 21.2558f, 5.5364f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(21.2232f, 14.1372f)
                    curveTo(21.4256f, 14.1303f, 21.6463f, 14.1319f, 21.8503f, 14.1475f)
                    curveTo(21.9515f, 14.1553f, 22.0417f, 14.1684f, 22.1146f, 14.1791f)
                    lineTo(21.8942f, 14.3052f)
                    curveTo(21.305f, 14.6423f, 21.0499f, 14.8985f, 21.1791f, 15.3602f)
                    curveTo(21.2923f, 15.7647f, 21.5924f, 15.8766f, 22.297f, 15.9871f)
                    lineTo(22.3901f, 16.0015f)
                    curveTo(22.5812f, 16.0311f, 22.7006f, 16.0529f, 22.7841f, 16.0755f)
                    curveTo(22.6855f, 16.1127f, 22.5022f, 16.163f, 22.2086f, 16.2208f)
                    curveTo(22.0942f, 16.2432f, 22.0941f, 16.2432f, 21.9757f, 16.2669f)
                    curveTo(21.2676f, 16.4113f, 20.8363f, 16.5904f, 20.6491f, 16.9601f)
                    curveTo(20.308f, 17.0213f, 20.0286f, 17.0813f, 19.8558f, 17.1228f)
                    curveTo(19.6768f, 17.1657f, 19.5664f, 17.3456f, 19.6094f, 17.5246f)
                    curveTo(19.6523f, 17.7036f, 19.8322f, 17.814f, 20.0112f, 17.771f)
                    curveTo(20.1397f, 17.7402f, 20.3356f, 17.6975f, 20.5755f, 17.6518f)
                    curveTo(20.721f, 18.1602f, 21.3385f, 18.5068f, 22.0816f, 18.6045f)
                    curveTo(22.9948f, 18.7245f, 23.7885f, 18.4229f, 23.8697f, 17.6812f)
                    curveTo(23.9213f, 17.2098f, 23.5938f, 16.9274f, 23.075f, 16.8236f)
                    curveTo(22.9789f, 16.8044f, 22.8745f, 16.7905f, 22.7623f, 16.7816f)
                    curveTo(23.2243f, 16.6632f, 23.4214f, 16.528f, 23.5149f, 16.2135f)
                    curveTo(23.6116f, 15.8881f, 23.4508f, 15.6318f, 23.1527f, 15.4997f)
                    curveTo(22.9929f, 15.4289f, 22.8389f, 15.3964f, 22.4922f, 15.3427f)
                    lineTo(22.4003f, 15.3284f)
                    curveTo(21.9987f, 15.2655f, 21.8269f, 15.2014f, 21.8211f, 15.1804f)
                    curveTo(21.8154f, 15.1601f, 21.912f, 15.0631f, 22.2253f, 14.8838f)
                    lineTo(22.2279f, 14.8823f)
                    curveTo(22.3344f, 14.822f, 22.3966f, 14.7868f, 22.444f, 14.7591f)
                    curveTo(22.5313f, 14.7081f, 22.5991f, 14.6651f, 22.6593f, 14.6212f)
                    curveTo(22.8895f, 14.453f, 23.0173f, 14.264f, 22.9498f, 14.0046f)
                    curveTo(22.855f, 13.6403f, 22.497f, 13.5285f, 21.9013f, 13.4828f)
                    curveTo(21.669f, 13.465f, 21.4254f, 13.4633f, 21.2005f, 13.471f)
                    curveTo(21.1209f, 13.4741f, 21.1209f, 13.4741f, 21.1003f, 13.4753f)
                    curveTo(20.9165f, 13.4859f, 20.7761f, 13.6435f, 20.7868f, 13.8273f)
                    curveTo(20.7974f, 14.0111f, 20.955f, 14.1515f, 21.1388f, 14.1408f)
                    curveTo(21.1523f, 14.14f, 21.1524f, 14.14f, 21.2232f, 14.1372f)
                    close()
                    moveTo(22.1685f, 17.9435f)
                    curveTo(21.716f, 17.884f, 21.3745f, 17.7089f, 21.2558f, 17.5364f)
                    curveTo(21.4323f, 17.5107f, 21.6046f, 17.4892f, 21.7703f, 17.4727f)
                    curveTo(22.2656f, 17.4235f, 22.6712f, 17.4228f, 22.9443f, 17.4774f)
                    curveTo(23.1665f, 17.5218f, 23.2122f, 17.5612f, 23.207f, 17.6087f)
                    curveTo(23.1792f, 17.8622f, 22.7606f, 18.0213f, 22.1685f, 17.9435f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(6.3835f, 14.1475f)
                    curveTo(6.1795f, 14.1319f, 5.9588f, 14.1303f, 5.7564f, 14.1372f)
                    curveTo(5.7431f, 14.1378f, 5.7323f, 14.1382f, 5.7235f, 14.1385f)
                    curveTo(5.6851f, 14.1401f, 5.683f, 14.1402f, 5.672f, 14.1408f)
                    curveTo(5.4882f, 14.1515f, 5.3306f, 14.0111f, 5.32f, 13.8273f)
                    curveTo(5.3093f, 13.6435f, 5.4497f, 13.4859f, 5.6335f, 13.4753f)
                    curveTo(5.6541f, 13.4741f, 5.6541f, 13.4741f, 5.7335f, 13.471f)
                    curveTo(5.9584f, 13.4633f, 6.2022f, 13.465f, 6.4345f, 13.4828f)
                    curveTo(7.0302f, 13.5285f, 7.3882f, 13.6403f, 7.483f, 14.0046f)
                    curveTo(7.5505f, 14.264f, 7.4227f, 14.453f, 7.1925f, 14.6212f)
                    curveTo(7.1323f, 14.6651f, 7.0645f, 14.7081f, 6.9772f, 14.7591f)
                    curveTo(6.9297f, 14.7868f, 6.8676f, 14.822f, 6.7608f, 14.8825f)
                    lineTo(6.7585f, 14.8838f)
                    curveTo(6.4452f, 15.0631f, 6.3486f, 15.1601f, 6.3543f, 15.1804f)
                    curveTo(6.3601f, 15.2014f, 6.5319f, 15.2655f, 6.9335f, 15.3284f)
                    lineTo(7.0254f, 15.3427f)
                    curveTo(7.3721f, 15.3964f, 7.5261f, 15.4289f, 7.6859f, 15.4997f)
                    curveTo(7.984f, 15.6318f, 8.1448f, 15.8881f, 8.0481f, 16.2135f)
                    curveTo(7.9546f, 16.528f, 7.7575f, 16.6632f, 7.2955f, 16.7816f)
                    curveTo(7.4078f, 16.7905f, 7.5121f, 16.8044f, 7.6082f, 16.8236f)
                    curveTo(8.127f, 16.9274f, 8.4545f, 17.2098f, 8.4029f, 17.6812f)
                    curveTo(8.3217f, 18.4229f, 7.528f, 18.7245f, 6.6148f, 18.6045f)
                    curveTo(5.8717f, 18.5068f, 5.2542f, 18.1602f, 5.1087f, 17.6518f)
                    curveTo(4.8688f, 17.6975f, 4.6729f, 17.7402f, 4.5444f, 17.771f)
                    curveTo(4.3654f, 17.814f, 4.1855f, 17.7036f, 4.1426f, 17.5246f)
                    curveTo(4.0996f, 17.3456f, 4.21f, 17.1657f, 4.389f, 17.1228f)
                    curveTo(4.5618f, 17.0813f, 4.8412f, 17.0213f, 5.1823f, 16.9601f)
                    curveTo(5.3695f, 16.5904f, 5.8003f, 16.4114f, 6.5084f, 16.267f)
                    curveTo(6.5233f, 16.264f, 6.5363f, 16.2614f, 6.5479f, 16.2591f)
                    curveTo(6.6291f, 16.2428f, 6.6416f, 16.2404f, 6.7418f, 16.2208f)
                    curveTo(7.0354f, 16.163f, 7.2187f, 16.1127f, 7.3173f, 16.0755f)
                    curveTo(7.2338f, 16.0529f, 7.1144f, 16.0311f, 6.9233f, 16.0015f)
                    lineTo(6.8302f, 15.9871f)
                    curveTo(6.1256f, 15.8766f, 5.8255f, 15.7647f, 5.7123f, 15.3602f)
                    curveTo(5.5831f, 14.8985f, 5.8382f, 14.6423f, 6.4274f, 14.3052f)
                    lineTo(6.6478f, 14.1791f)
                    curveTo(6.5749f, 14.1684f, 6.4847f, 14.1553f, 6.3835f, 14.1475f)
                    close()
                    moveTo(5.789f, 17.5364f)
                    curveTo(5.9077f, 17.7089f, 6.2492f, 17.884f, 6.7017f, 17.9435f)
                    curveTo(7.2938f, 18.0213f, 7.7124f, 17.8622f, 7.7402f, 17.6087f)
                    curveTo(7.7454f, 17.5612f, 7.6997f, 17.5218f, 7.4774f, 17.4774f)
                    curveTo(7.2044f, 17.4228f, 6.7989f, 17.4235f, 6.3035f, 17.4727f)
                    curveTo(6.1378f, 17.4892f, 5.9655f, 17.5107f, 5.789f, 17.5364f)
                    close()
                }
            }
        }
        .build()
        return _mq!!
    }

private var _mq: ImageVector? = null
