package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Mo: ImageVector
    get() {
        if (_mo != null) {
            return _mo!!
        }
        _mo = Builder(name = "Mo", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, -0.0f)
                    curveTo(9.3333f, 1.0E-4f, 18.6667f, -0.0f, 28.0f, -0.0f)
                    curveTo(28.0f, 6.6667f, 28.0f, 13.3333f, 28.0f, 20.0f)
                    curveTo(18.6667f, 20.0f, 9.3333f, 20.0f, 0.0f, 20.0f)
                    verticalLineTo(-0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF079D7B)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 20.0f)
                    lineTo(28.0f, 20.0f)
                    verticalLineTo(-0.0f)
                    lineTo(0.0f, -0.0f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(15.8849f, 8.6667f)
                    curveTo(15.8849f, 8.9586f, 15.8637f, 9.2416f, 15.8238f, 9.5114f)
                    curveTo(15.9261f, 9.48f, 16.0302f, 9.45f, 16.1361f, 9.4216f)
                    curveTo(17.9143f, 8.9452f, 19.5015f, 9.1024f, 19.6811f, 9.7728f)
                    curveTo(19.8435f, 10.3787f, 18.8006f, 11.1964f, 17.2858f, 11.6999f)
                    curveTo(17.0182f, 10.9062f, 15.6488f, 10.6667f, 13.9998f, 10.6667f)
                    curveTo(12.349f, 10.6667f, 10.9785f, 10.9067f, 10.713f, 11.7025f)
                    curveTo(9.2187f, 11.198f, 8.1945f, 10.3889f, 8.3555f, 9.7881f)
                    curveTo(8.5351f, 9.1177f, 10.1223f, 8.9605f, 11.9005f, 9.437f)
                    curveTo(11.9939f, 9.462f, 12.0859f, 9.4882f, 12.1765f, 9.5157f)
                    curveTo(12.1362f, 9.2446f, 12.1148f, 8.9601f, 12.1148f, 8.6667f)
                    curveTo(12.1148f, 6.8257f, 12.9587f, 5.3334f, 13.9998f, 5.3334f)
                    curveTo(15.0409f, 5.3334f, 15.8849f, 6.8257f, 15.8849f, 8.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(11.833f, 12.0f)
                    curveTo(11.6482f, 11.9638f, 11.4597f, 11.9204f, 11.2689f, 11.8698f)
                    curveTo(11.4835f, 11.8761f, 11.748f, 11.8944f, 12.0508f, 11.9154f)
                    curveTo(12.5989f, 11.9534f, 13.2721f, 12.0f, 13.9998f, 12.0f)
                    curveTo(14.7275f, 12.0f, 15.4007f, 11.9534f, 15.9488f, 11.9154f)
                    curveTo(16.2402f, 11.8952f, 16.4962f, 11.8775f, 16.7063f, 11.8705f)
                    curveTo(16.5088f, 11.9215f, 16.314f, 11.9646f, 16.1235f, 12.0f)
                    horizontalLineTo(19.3332f)
                    curveTo(19.175f, 12.4747f, 18.9622f, 12.922f, 18.7027f, 13.3334f)
                    horizontalLineTo(9.297f)
                    curveTo(9.0375f, 12.922f, 8.8246f, 12.4747f, 8.6665f, 12.0f)
                    horizontalLineTo(11.833f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.9996f, 16.0f)
                    curveTo(15.3463f, 16.0f, 16.5831f, 15.5005f, 17.5544f, 14.6667f)
                    horizontalLineTo(10.4448f)
                    curveTo(11.4161f, 15.5005f, 12.6529f, 16.0f, 13.9996f, 16.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFCD117)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0002f, 4.0f)
                    curveTo(14.3684f, 4.0f, 14.6668f, 3.7015f, 14.6668f, 3.3333f)
                    curveTo(14.6668f, 2.9652f, 14.3684f, 2.6667f, 14.0002f, 2.6667f)
                    curveTo(13.632f, 2.6667f, 13.3335f, 2.9652f, 13.3335f, 3.3333f)
                    curveTo(13.3335f, 3.7015f, 13.632f, 4.0f, 14.0002f, 4.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFCD117)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6667f, 7.3333f)
                    curveTo(9.0349f, 7.3333f, 9.3333f, 7.0349f, 9.3333f, 6.6667f)
                    curveTo(9.3333f, 6.2985f, 9.0349f, 6.0f, 8.6667f, 6.0f)
                    curveTo(8.2985f, 6.0f, 8.0f, 6.2985f, 8.0f, 6.6667f)
                    curveTo(8.0f, 7.0349f, 8.2985f, 7.3333f, 8.6667f, 7.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFCD117)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(19.9998f, 6.6666f)
                    curveTo(19.9998f, 7.0348f, 19.7014f, 7.3333f, 19.3332f, 7.3333f)
                    curveTo(18.965f, 7.3333f, 18.6665f, 7.0348f, 18.6665f, 6.6666f)
                    curveTo(18.6665f, 6.2985f, 18.965f, 6.0f, 19.3332f, 6.0f)
                    curveTo(19.7014f, 6.0f, 19.9998f, 6.2985f, 19.9998f, 6.6666f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFCD117)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3332f, 5.3333f)
                    curveTo(17.7014f, 5.3333f, 17.9998f, 5.0348f, 17.9998f, 4.6666f)
                    curveTo(17.9998f, 4.2985f, 17.7014f, 4.0f, 17.3332f, 4.0f)
                    curveTo(16.965f, 4.0f, 16.6665f, 4.2985f, 16.6665f, 4.6666f)
                    curveTo(16.6665f, 5.0348f, 16.965f, 5.3333f, 17.3332f, 5.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFCD117)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(11.3333f, 4.6667f)
                    curveTo(11.3333f, 5.0349f, 11.0349f, 5.3333f, 10.6667f, 5.3333f)
                    curveTo(10.2985f, 5.3333f, 10.0f, 5.0349f, 10.0f, 4.6667f)
                    curveTo(10.0f, 4.2985f, 10.2985f, 4.0f, 10.6667f, 4.0f)
                    curveTo(11.0349f, 4.0f, 11.3333f, 4.2985f, 11.3333f, 4.6667f)
                    close()
                }
            }
        }
        .build()
        return _mo!!
    }

private var _mo: ImageVector? = null
