package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Mn: ImageVector
    get() {
        if (_mn != null) {
            return _mn!!
        }
        _mn = Builder(name = "Mn", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    curveTo(9.3333f, -0.0f, 18.6666f, 0.0f, 27.9998f, 0.0f)
                    curveTo(28.0011f, 6.6667f, 28.0f, 13.3334f, 28.0f, 20.0f)
                    curveTo(18.6667f, 20.0f, 9.3333f, 20.0f, 0.0f, 20.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF146BBC)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(9.3335f, 20.0f)
                    horizontalLineTo(18.6668f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(9.3335f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE43642)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 20.0f)
                    horizontalLineTo(9.3335f)
                    verticalLineTo(0.0f)
                    lineTo(0.0f, 0.0f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE43642)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(18.6668f, 20.0f)
                    horizontalLineTo(28.0f)
                    lineTo(27.9998f, 0.0f)
                    horizontalLineTo(18.6668f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF8D246)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(4.6667f, 10.0f)
                    lineTo(5.3333f, 10.6667f)
                    horizontalLineTo(4.6667f)
                    horizontalLineTo(4.0f)
                    lineTo(4.6667f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF8D246)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(5.333f, 14.021f)
                    verticalLineTo(14.6667f)
                    horizontalLineTo(4.0f)
                    lineTo(4.6667f, 16.0f)
                    lineTo(5.333f, 14.6667f)
                    verticalLineTo(16.0f)
                    horizontalLineTo(6.6663f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(5.3333f)
                    horizontalLineTo(4.6719f)
                    curveTo(5.0377f, 11.9972f, 5.3333f, 11.6998f, 5.3333f, 11.3334f)
                    curveTo(5.3333f, 10.9652f, 5.0349f, 10.6667f, 4.6667f, 10.6667f)
                    curveTo(4.2985f, 10.6667f, 4.0f, 10.9652f, 4.0f, 11.3334f)
                    curveTo(4.0f, 11.6998f, 4.2956f, 11.9972f, 4.6614f, 12.0f)
                    horizontalLineTo(4.0f)
                    lineTo(4.6667f, 13.3333f)
                    curveTo(4.2985f, 13.3333f, 4.0f, 13.6318f, 4.0f, 14.0f)
                    curveTo(4.0f, 14.3682f, 4.2985f, 14.6667f, 4.6667f, 14.6667f)
                    curveTo(5.0278f, 14.6667f, 5.3219f, 14.3795f, 5.333f, 14.021f)
                    close()
                    moveTo(5.333f, 13.979f)
                    lineTo(5.3333f, 12.0f)
                    lineTo(4.6667f, 13.3333f)
                    curveTo(5.0278f, 13.3333f, 5.3219f, 13.6205f, 5.333f, 13.979f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFF8D246)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(2.6665f, 12.0f)
                    horizontalLineTo(4.0f)
                    lineTo(3.9998f, 16.0f)
                    horizontalLineTo(2.6665f)
                    verticalLineTo(12.0f)
                    close()
                }
            }
        }
        .build()
        return _mn!!
    }

private var _mn: ImageVector? = null
