package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Hm: ImageVector
    get() {
        if (_hm != null) {
            return _hm!!
        }
        _hm = Builder(name = "Hm", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0006f, 0.0028f)
                    horizontalLineTo(6.0E-4f)
                    verticalLineTo(20.0028f)
                    horizontalLineTo(28.0006f)
                    verticalLineTo(0.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0A17A7)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0006f, 0.0028f)
                    horizontalLineTo(6.0E-4f)
                    verticalLineTo(20.0028f)
                    horizontalLineTo(28.0006f)
                    verticalLineTo(0.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(6.0007f, 16.3362f)
                    lineTo(4.8251f, 16.9542f)
                    lineTo(5.0496f, 15.6452f)
                    lineTo(4.0986f, 14.7181f)
                    lineTo(5.4129f, 14.5271f)
                    lineTo(6.0007f, 13.3362f)
                    lineTo(6.5885f, 14.5271f)
                    lineTo(7.9028f, 14.7181f)
                    lineTo(6.9517f, 15.6452f)
                    lineTo(7.1763f, 16.9542f)
                    lineTo(6.0007f, 16.3362f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0007f, 17.3362f)
                    lineTo(19.0579f, 17.6123f)
                    lineTo(19.334f, 16.6695f)
                    lineTo(19.0579f, 15.7267f)
                    lineTo(20.0007f, 16.0028f)
                    lineTo(20.9435f, 15.7267f)
                    lineTo(20.6674f, 16.6695f)
                    lineTo(20.9435f, 17.6123f)
                    lineTo(20.0007f, 17.3362f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0007f, 4.6695f)
                    lineTo(19.0579f, 4.9457f)
                    lineTo(19.334f, 4.0029f)
                    lineTo(19.0579f, 3.06f)
                    lineTo(20.0007f, 3.3362f)
                    lineTo(20.9435f, 3.06f)
                    lineTo(20.6674f, 4.0029f)
                    lineTo(20.9435f, 4.9457f)
                    lineTo(20.0007f, 4.6695f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(24.0007f, 8.6695f)
                    lineTo(23.0579f, 8.9457f)
                    lineTo(23.334f, 8.0028f)
                    lineTo(23.0579f, 7.06f)
                    lineTo(24.0007f, 7.3362f)
                    lineTo(24.9435f, 7.06f)
                    lineTo(24.6674f, 8.0028f)
                    lineTo(24.9435f, 8.9457f)
                    lineTo(24.0007f, 8.6695f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(16.0007f, 10.0028f)
                    lineTo(15.0579f, 10.279f)
                    lineTo(15.334f, 9.3362f)
                    lineTo(15.0579f, 8.3934f)
                    lineTo(16.0007f, 8.6695f)
                    lineTo(16.9435f, 8.3934f)
                    lineTo(16.6674f, 9.3362f)
                    lineTo(16.9435f, 10.279f)
                    lineTo(16.0007f, 10.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(22.0006f, 11.6695f)
                    lineTo(21.5292f, 11.8076f)
                    lineTo(21.6673f, 11.3362f)
                    lineTo(21.5292f, 10.8648f)
                    lineTo(22.0006f, 11.0029f)
                    lineTo(22.472f, 10.8648f)
                    lineTo(22.334f, 11.3362f)
                    lineTo(22.472f, 11.8076f)
                    lineTo(22.0006f, 11.6695f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0006f, 0.9474f)
                    lineTo(11.4314f, 3.1023f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(6.67f)
                    horizontalLineTo(11.4319f)
                    lineTo(14.0006f, 8.8238f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(10.8044f)
                    lineTo(8.7864f, 8.3129f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(5.215f)
                    verticalLineTo(8.3113f)
                    lineTo(3.1932f, 10.0026f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(8.8136f)
                    lineTo(2.5635f, 6.67f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(3.1023f)
                    horizontalLineTo(2.5671f)
                    lineTo(0.0f, 0.952f)
                    lineTo(6.0E-4f, 0.0028f)
                    lineTo(3.4735f, 0.0026f)
                    lineTo(5.215f, 1.4601f)
                    verticalLineTo(0.0026f)
                    horizontalLineTo(8.7864f)
                    verticalLineTo(1.463f)
                    lineTo(10.5352f, 0.0026f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(0.9474f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6828f, 4.1023f)
                    lineTo(13.571f, 0.0026f)
                    lineTo(12.0943f, 0.0f)
                    lineTo(7.7864f, 3.601f)
                    verticalLineTo(0.0045f)
                    lineTo(6.215f, 0.0045f)
                    verticalLineTo(3.6011f)
                    lineTo(1.9281f, 0.0131f)
                    lineTo(0.4262f, 0.0045f)
                    lineTo(5.3183f, 4.1023f)
                    horizontalLineTo(6.0E-4f)
                    verticalLineTo(5.67f)
                    horizontalLineTo(5.3183f)
                    lineTo(0.139f, 10.0008f)
                    lineTo(1.6391f, 9.9989f)
                    lineTo(6.215f, 6.171f)
                    verticalLineTo(10.0004f)
                    horizontalLineTo(7.7864f)
                    verticalLineTo(6.1713f)
                    lineTo(12.36f, 10.0008f)
                    lineTo(13.8503f, 10.0028f)
                    lineTo(8.6829f, 5.67f)
                    horizontalLineTo(14.0006f)
                    verticalLineTo(4.1023f)
                    horizontalLineTo(8.6828f)
                    close()
                }
            }
        }
        .build()
        return _hm!!
    }

private var _hm: ImageVector? = null
