package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Gu: ImageVector
    get() {
        if (_gu != null) {
            return _gu!!
        }
        _gu = Builder(name = "Gu", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDE3149)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF053B94)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(25.6667f, 1.3333f)
                    horizontalLineTo(2.3334f)
                    curveTo(1.7811f, 1.3333f, 1.3334f, 1.781f, 1.3334f, 2.3333f)
                    verticalLineTo(17.6667f)
                    curveTo(1.3334f, 18.219f, 1.7811f, 18.6667f, 2.3334f, 18.6667f)
                    horizontalLineTo(25.6667f)
                    curveTo(26.219f, 18.6667f, 26.6667f, 18.219f, 26.6667f, 17.6667f)
                    verticalLineTo(2.3333f)
                    curveTo(26.6667f, 1.781f, 26.219f, 1.3333f, 25.6667f, 1.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDE3149)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(14.0f, 16.0f)
                    curveTo(14.0f, 16.0f, 18.0f, 13.3137f, 18.0f, 10.0f)
                    curveTo(18.0f, 6.6863f, 14.0f, 4.0f, 14.0f, 4.0f)
                    curveTo(14.0f, 4.0f, 10.0f, 6.6863f, 10.0f, 10.0f)
                    curveTo(10.0f, 13.3137f, 14.0f, 16.0f, 14.0f, 16.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0f, 15.3333f)
                    curveTo(14.0f, 15.3333f, 17.3334f, 12.6667f, 17.3334f, 10.0f)
                    curveTo(17.3334f, 7.3333f, 14.0f, 4.6667f, 14.0f, 4.6667f)
                    curveTo(14.0f, 4.6667f, 10.6667f, 7.3333f, 10.6667f, 10.0f)
                    curveTo(10.6667f, 12.6667f, 14.0f, 15.3333f, 14.0f, 15.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF81C1F3)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0f, 15.3333f)
                    curveTo(14.0f, 15.3333f, 17.3334f, 12.6667f, 17.3334f, 10.0f)
                    curveTo(17.3334f, 7.3333f, 14.0f, 4.6667f, 14.0f, 4.6667f)
                    curveTo(14.0f, 4.6667f, 10.6667f, 7.3333f, 10.6667f, 10.0f)
                    curveTo(10.6667f, 12.6667f, 14.0f, 15.3333f, 14.0f, 15.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFF048)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(10.7326f, 10.6666f)
                    curveTo(11.2003f, 13.0935f, 14.0f, 15.3333f, 14.0f, 15.3333f)
                    curveTo(14.0f, 15.3333f, 16.7998f, 13.0935f, 17.2675f, 10.6666f)
                    horizontalLineTo(10.7326f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF053B94)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(16.7612f, 12.0587f)
                    curveTo(17.102f, 11.405f, 17.3334f, 10.7025f, 17.3334f, 10.0f)
                    curveTo(17.3334f, 7.3333f, 14.0f, 4.6667f, 14.0f, 4.6667f)
                    curveTo(14.0f, 4.6667f, 10.6667f, 7.3333f, 10.6667f, 10.0f)
                    curveTo(10.6667f, 11.0745f, 11.2078f, 12.149f, 11.8541f, 13.049f)
                    curveTo(12.4368f, 13.5321f, 13.0692f, 14.0f, 13.3333f, 14.0f)
                    curveTo(13.6871f, 14.0f, 13.8516f, 13.7151f, 14.036f, 13.3958f)
                    curveTo(14.1909f, 13.1276f, 14.3598f, 12.8351f, 14.6667f, 12.6667f)
                    curveTo(15.3255f, 12.305f, 16.1969f, 12.1353f, 16.7612f, 12.0587f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF81C1F3)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.0818f, 11.3338f)
                    curveTo(17.2389f, 10.8977f, 17.3334f, 10.4488f, 17.3334f, 10.0f)
                    curveTo(17.3334f, 7.3333f, 14.0f, 4.6667f, 14.0f, 4.6667f)
                    curveTo(14.0f, 4.6667f, 10.6667f, 7.3333f, 10.6667f, 10.0f)
                    curveTo(10.6667f, 10.636f, 10.8562f, 11.2719f, 11.145f, 11.8717f)
                    curveTo(11.7146f, 11.7236f, 12.6347f, 11.5f, 12.9999f, 11.5f)
                    curveTo(13.1782f, 11.5f, 13.471f, 11.5277f, 13.8159f, 11.5603f)
                    curveTo(14.7304f, 11.6468f, 16.0118f, 11.768f, 16.4999f, 11.5f)
                    curveTo(16.7681f, 11.3528f, 16.9539f, 11.3123f, 17.0818f, 11.3338f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF27A07E)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(14.0002f, 9.4667f)
                    lineTo(12.8246f, 10.2847f)
                    lineTo(13.2393f, 8.9139f)
                    lineTo(12.098f, 8.0486f)
                    lineTo(13.5299f, 8.0194f)
                    lineTo(14.0002f, 6.6666f)
                    lineTo(14.4704f, 8.0194f)
                    lineTo(15.9023f, 8.0486f)
                    lineTo(14.761f, 8.9139f)
                    lineTo(15.1757f, 10.2847f)
                    lineTo(14.0002f, 9.4667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8F5715)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.6682f, 8.6334f)
                    curveTo(13.6565f, 8.7503f, 13.6391f, 8.949f, 13.6216f, 9.1975f)
                    curveTo(13.6004f, 9.5003f, 13.5852f, 9.7989f, 13.5786f, 10.0793f)
                    curveTo(13.564f, 10.7012f, 13.5912f, 11.1614f, 13.6837f, 11.4388f)
                    curveTo(13.7998f, 11.7871f, 14.0624f, 12.114f, 14.4262f, 12.4275f)
                    curveTo(14.7041f, 12.6671f, 14.9796f, 12.8499f, 15.1694f, 12.957f)
                    curveTo(15.3298f, 13.0475f, 15.5331f, 12.9908f, 15.6236f, 12.8305f)
                    curveTo(15.714f, 12.6701f, 15.6574f, 12.4668f, 15.497f, 12.3764f)
                    curveTo(15.3422f, 12.289f, 15.1006f, 12.1287f, 14.8614f, 11.9226f)
                    curveTo(14.5806f, 11.6804f, 14.3864f, 11.4388f, 14.3161f, 11.2279f)
                    curveTo(14.2566f, 11.0495f, 14.2323f, 10.6385f, 14.2451f, 10.0949f)
                    curveTo(14.2514f, 9.8259f, 14.2661f, 9.5373f, 14.2867f, 9.2441f)
                    curveTo(14.3036f, 9.0029f, 14.3204f, 8.8107f, 14.3316f, 8.7f)
                    curveTo(14.35f, 8.5168f, 14.2164f, 8.3534f, 14.0332f, 8.335f)
                    curveTo(13.8501f, 8.3166f, 13.6866f, 8.4502f, 13.6682f, 8.6334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.0f, 10.0f)
                    lineTo(13.3334f, 12.0f)
                    horizontalLineTo(12.0f)
                    verticalLineTo(10.0f)
                    close()
                }
            }
        }
        .build()
        return _gu!!
    }

private var _gu: ImageVector? = null
