package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Gp: ImageVector
    get() {
        if (_gp != null) {
            return _gp!!
        }
        _gp = Builder(name = "Gp", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF25A057)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.0f, 4.0027f)
                    horizontalLineTo(11.0f)
                    curveTo(10.8159f, 4.0027f, 10.6667f, 4.1519f, 10.6667f, 4.336f)
                    verticalLineTo(10.336f)
                    curveTo(10.6667f, 10.5201f, 10.8159f, 10.6694f, 11.0f, 10.6694f)
                    horizontalLineTo(17.0f)
                    curveTo(17.1841f, 10.6694f, 17.3333f, 10.5201f, 17.3333f, 10.336f)
                    verticalLineTo(4.336f)
                    curveTo(17.3333f, 4.1519f, 17.1841f, 4.0027f, 17.0f, 4.0027f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF31B8F4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(10.6667f, 4.3242f)
                    curveTo(10.6667f, 4.1467f, 10.8203f, 4.0027f, 11.0f, 4.0027f)
                    horizontalLineTo(15.6664f)
                    curveTo(15.8506f, 4.0027f, 15.926f, 4.1274f, 15.8338f, 4.2826f)
                    lineTo(14.0501f, 7.286f)
                    lineTo(10.91f, 7.7594f)
                    lineTo(10.6946f, 10.3355f)
                    curveTo(10.6792f, 10.5199f, 10.6667f, 10.5301f, 10.6667f, 10.3478f)
                    verticalLineTo(4.3242f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFE149)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(10.6667f, 8.6694f)
                    curveTo(11.7712f, 8.6694f, 12.6667f, 7.7739f, 12.6667f, 6.6694f)
                    curveTo(12.6667f, 5.5648f, 11.7712f, 4.6694f, 10.6667f, 4.6694f)
                    curveTo(9.5621f, 4.6694f, 8.6667f, 5.5648f, 8.6667f, 6.6694f)
                    curveTo(8.6667f, 7.7739f, 9.5621f, 8.6694f, 10.6667f, 8.6694f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFE149)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.0f, 14.6694f)
                    horizontalLineTo(11.0f)
                    curveTo(10.8159f, 14.6694f, 10.6667f, 14.8186f, 10.6667f, 15.0027f)
                    verticalLineTo(15.6694f)
                    curveTo(10.6667f, 15.8535f, 10.8159f, 16.0027f, 11.0f, 16.0027f)
                    horizontalLineTo(17.0f)
                    curveTo(17.1841f, 16.0027f, 17.3333f, 15.8535f, 17.3333f, 15.6694f)
                    verticalLineTo(15.0027f)
                    curveTo(17.3333f, 14.8186f, 17.1841f, 14.6694f, 17.0f, 14.6694f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(10.8541f, 11.9364f)
                    horizontalLineTo(10.88f)
                    curveTo(10.9333f, 11.9364f, 10.9745f, 11.9867f, 10.9745f, 12.0538f)
                    verticalLineTo(12.3814f)
                    curveTo(10.9745f, 12.4332f, 11.0019f, 12.4789f, 11.072f, 12.4789f)
                    horizontalLineTo(11.1512f)
                    curveTo(11.1589f, 12.4789f, 11.1665f, 12.4789f, 11.1665f, 12.4743f)
                    curveTo(11.1665f, 12.4698f, 11.1604f, 12.4637f, 11.1543f, 12.4576f)
                    lineTo(11.1055f, 12.4058f)
                    curveTo(11.0979f, 12.3981f, 11.0918f, 12.389f, 11.0918f, 12.3783f)
                    verticalLineTo(12.0598f)
                    curveTo(11.0918f, 11.976f, 11.0461f, 11.9166f, 10.9943f, 11.8892f)
                    curveTo(11.0476f, 11.8557f, 11.107f, 11.7871f, 11.107f, 11.6179f)
                    curveTo(11.107f, 11.4198f, 11.0248f, 11.336f, 10.8663f, 11.336f)
                    horizontalLineTo(10.6758f)
                    curveTo(10.6697f, 11.336f, 10.6667f, 11.3406f, 10.6667f, 11.3452f)
                    curveTo(10.6667f, 11.3498f, 10.6743f, 11.3543f, 10.6773f, 11.3589f)
                    lineTo(10.723f, 11.4031f)
                    curveTo(10.7337f, 11.4138f, 10.7368f, 11.4275f, 10.7368f, 11.4458f)
                    verticalLineTo(12.3692f)
                    curveTo(10.7368f, 12.3875f, 10.7337f, 12.4012f, 10.723f, 12.4118f)
                    lineTo(10.6773f, 12.456f)
                    curveTo(10.6743f, 12.4606f, 10.6667f, 12.4652f, 10.6667f, 12.4698f)
                    curveTo(10.6667f, 12.4743f, 10.6697f, 12.4789f, 10.6758f, 12.4789f)
                    horizontalLineTo(10.915f)
                    curveTo(10.9211f, 12.4789f, 10.9242f, 12.4743f, 10.9242f, 12.4698f)
                    curveTo(10.9242f, 12.4652f, 10.9166f, 12.4606f, 10.9135f, 12.456f)
                    lineTo(10.8678f, 12.4118f)
                    curveTo(10.8571f, 12.4012f, 10.8541f, 12.3875f, 10.8541f, 12.3692f)
                    verticalLineTo(11.9364f)
                    close()
                    moveTo(10.8541f, 11.4122f)
                    horizontalLineTo(10.877f)
                    curveTo(10.9516f, 11.4122f, 10.9821f, 11.4625f, 10.9821f, 11.6179f)
                    curveTo(10.9821f, 11.8008f, 10.9516f, 11.8602f, 10.877f, 11.8602f)
                    horizontalLineTo(10.8541f)
                    verticalLineTo(11.4122f)
                    close()
                    moveTo(11.3722f, 11.4122f)
                    horizontalLineTo(11.459f)
                    curveTo(11.4789f, 11.4122f, 11.4926f, 11.4214f, 11.4987f, 11.4412f)
                    lineTo(11.581f, 11.7277f)
                    curveTo(11.5825f, 11.7338f, 11.587f, 11.7383f, 11.5931f, 11.7383f)
                    curveTo(11.5977f, 11.7383f, 11.6008f, 11.7353f, 11.6008f, 11.7292f)
                    verticalLineTo(11.3498f)
                    curveTo(11.6008f, 11.3421f, 11.5947f, 11.336f, 11.5886f, 11.336f)
                    horizontalLineTo(11.1939f)
                    curveTo(11.1878f, 11.336f, 11.1848f, 11.3406f, 11.1848f, 11.3452f)
                    curveTo(11.1848f, 11.3498f, 11.1924f, 11.3543f, 11.1954f, 11.3589f)
                    lineTo(11.2411f, 11.4031f)
                    curveTo(11.2518f, 11.4138f, 11.2549f, 11.4275f, 11.2549f, 11.4458f)
                    verticalLineTo(12.3692f)
                    curveTo(11.2549f, 12.3875f, 11.2518f, 12.4012f, 11.2411f, 12.4118f)
                    lineTo(11.1954f, 12.456f)
                    curveTo(11.1924f, 12.4621f, 11.1848f, 12.4652f, 11.1848f, 12.4698f)
                    curveTo(11.1848f, 12.4743f, 11.1878f, 12.4789f, 11.1939f, 12.4789f)
                    horizontalLineTo(11.5886f)
                    curveTo(11.5962f, 12.4789f, 11.6008f, 12.4728f, 11.6008f, 12.4652f)
                    verticalLineTo(12.0827f)
                    curveTo(11.6008f, 12.0781f, 11.5977f, 12.0736f, 11.5931f, 12.0736f)
                    curveTo(11.5886f, 12.0736f, 11.584f, 12.0766f, 11.5825f, 12.0827f)
                    lineTo(11.5002f, 12.3753f)
                    curveTo(11.4941f, 12.3936f, 11.4789f, 12.4027f, 11.459f, 12.4027f)
                    horizontalLineTo(11.3722f)
                    verticalLineTo(11.9395f)
                    horizontalLineTo(11.4057f)
                    curveTo(11.4133f, 11.9395f, 11.4194f, 11.9425f, 11.4225f, 11.9501f)
                    lineTo(11.4743f, 12.0614f)
                    curveTo(11.4773f, 12.0675f, 11.4789f, 12.072f, 11.485f, 12.072f)
                    curveTo(11.4895f, 12.072f, 11.491f, 12.069f, 11.491f, 12.0644f)
                    verticalLineTo(11.7414f)
                    curveTo(11.491f, 11.7353f, 11.4895f, 11.7322f, 11.485f, 11.7322f)
                    curveTo(11.4804f, 11.7322f, 11.4789f, 11.7353f, 11.4758f, 11.7414f)
                    lineTo(11.4225f, 11.848f)
                    curveTo(11.4194f, 11.8557f, 11.4133f, 11.8587f, 11.4057f, 11.8587f)
                    horizontalLineTo(11.3722f)
                    verticalLineTo(11.4122f)
                    close()
                    moveTo(11.9589f, 12.2f)
                    curveTo(11.9589f, 12.3448f, 11.9253f, 12.4027f, 11.8781f, 12.4027f)
                    curveTo(11.8232f, 12.4027f, 11.805f, 12.3174f, 11.805f, 11.8785f)
                    curveTo(11.805f, 11.557f, 11.8232f, 11.4122f, 11.8872f, 11.4122f)
                    curveTo(11.9543f, 11.4122f, 12.0198f, 11.6088f, 12.0518f, 11.7231f)
                    curveTo(12.0549f, 11.7322f, 12.0594f, 11.7383f, 12.0655f, 11.7383f)
                    curveTo(12.0701f, 11.7383f, 12.0731f, 11.7338f, 12.0731f, 11.7277f)
                    verticalLineTo(11.3619f)
                    curveTo(12.0731f, 11.3467f, 12.0701f, 11.336f, 12.0625f, 11.336f)
                    curveTo(12.0549f, 11.336f, 12.0457f, 11.3437f, 12.032f, 11.3558f)
                    curveTo(12.0168f, 11.3696f, 12.0015f, 11.3802f, 11.9939f, 11.3802f)
                    curveTo(11.9878f, 11.3802f, 11.9771f, 11.3757f, 11.971f, 11.3711f)
                    curveTo(11.9558f, 11.3589f, 11.9253f, 11.336f, 11.875f, 11.336f)
                    curveTo(11.6876f, 11.336f, 11.68f, 11.6896f, 11.68f, 11.877f)
                    curveTo(11.68f, 12.1315f, 11.6876f, 12.4789f, 11.8781f, 12.4789f)
                    curveTo(11.9116f, 12.4789f, 11.9421f, 12.4606f, 11.9741f, 12.4317f)
                    curveTo(11.9802f, 12.4271f, 11.9848f, 12.4256f, 11.9893f, 12.4256f)
                    curveTo(11.9954f, 12.4256f, 11.9985f, 12.4271f, 12.0046f, 12.4317f)
                    lineTo(12.0503f, 12.4728f)
                    curveTo(12.0533f, 12.4758f, 12.0594f, 12.4789f, 12.0655f, 12.4789f)
                    curveTo(12.0701f, 12.4789f, 12.0731f, 12.4758f, 12.0731f, 12.4713f)
                    verticalLineTo(11.9928f)
                    curveTo(12.0731f, 11.9776f, 12.0777f, 11.9669f, 12.0884f, 11.9593f)
                    lineTo(12.1326f, 11.9227f)
                    curveTo(12.1371f, 11.9166f, 12.1402f, 11.9136f, 12.1402f, 11.9075f)
                    curveTo(12.1402f, 11.9014f, 12.1356f, 11.8983f, 12.1295f, 11.8983f)
                    horizontalLineTo(11.904f)
                    curveTo(11.8964f, 11.8983f, 11.8918f, 11.9014f, 11.8918f, 11.9075f)
                    curveTo(11.8918f, 11.9136f, 11.8933f, 11.9166f, 11.8994f, 11.9227f)
                    lineTo(11.9421f, 11.9593f)
                    curveTo(11.9528f, 11.9684f, 11.9589f, 11.9776f, 11.9589f, 11.9928f)
                    verticalLineTo(12.2f)
                    close()
                    moveTo(12.2286f, 12.3692f)
                    curveTo(12.2286f, 12.3875f, 12.2255f, 12.4012f, 12.2149f, 12.4118f)
                    lineTo(12.1691f, 12.456f)
                    curveTo(12.1661f, 12.4606f, 12.1585f, 12.4652f, 12.1585f, 12.4698f)
                    curveTo(12.1585f, 12.4743f, 12.1615f, 12.4789f, 12.1676f, 12.4789f)
                    horizontalLineTo(12.4069f)
                    curveTo(12.413f, 12.4789f, 12.416f, 12.4743f, 12.416f, 12.4698f)
                    curveTo(12.416f, 12.4652f, 12.4084f, 12.4606f, 12.4053f, 12.456f)
                    lineTo(12.3596f, 12.4118f)
                    curveTo(12.349f, 12.4012f, 12.3459f, 12.3875f, 12.3459f, 12.3692f)
                    verticalLineTo(11.4458f)
                    curveTo(12.3459f, 11.4275f, 12.349f, 11.4138f, 12.3596f, 11.4031f)
                    lineTo(12.4053f, 11.3589f)
                    curveTo(12.4084f, 11.3543f, 12.416f, 11.3498f, 12.416f, 11.3452f)
                    curveTo(12.416f, 11.3406f, 12.413f, 11.336f, 12.4069f, 11.336f)
                    horizontalLineTo(12.1676f)
                    curveTo(12.1615f, 11.336f, 12.1585f, 11.3406f, 12.1585f, 11.3452f)
                    curveTo(12.1585f, 11.3498f, 12.1661f, 11.3543f, 12.1691f, 11.3589f)
                    lineTo(12.2149f, 11.4031f)
                    curveTo(12.2255f, 11.4138f, 12.2286f, 11.4275f, 12.2286f, 11.4458f)
                    verticalLineTo(12.3692f)
                    close()
                    moveTo(12.6796f, 11.336f)
                    curveTo(12.4968f, 11.336f, 12.477f, 11.6576f, 12.477f, 11.877f)
                    curveTo(12.477f, 12.165f, 12.4968f, 12.4789f, 12.6796f, 12.4789f)
                    curveTo(12.864f, 12.4789f, 12.8838f, 12.165f, 12.8838f, 11.877f)
                    curveTo(12.8838f, 11.6576f, 12.864f, 11.336f, 12.6796f, 11.336f)
                    close()
                    moveTo(12.6796f, 11.4122f)
                    curveTo(12.7253f, 11.4122f, 12.7589f, 11.5402f, 12.7589f, 11.8785f)
                    curveTo(12.7589f, 12.2747f, 12.7253f, 12.4027f, 12.6796f, 12.4027f)
                    curveTo(12.6354f, 12.4027f, 12.6019f, 12.2747f, 12.6019f, 11.8785f)
                    curveTo(12.6019f, 11.5402f, 12.6354f, 11.4122f, 12.6796f, 11.4122f)
                    close()
                    moveTo(13.0072f, 12.3692f)
                    curveTo(13.0072f, 12.3875f, 13.0027f, 12.3997f, 12.9935f, 12.4118f)
                    lineTo(12.9554f, 12.456f)
                    curveTo(12.9524f, 12.4606f, 12.9448f, 12.4652f, 12.9448f, 12.4713f)
                    curveTo(12.9448f, 12.4743f, 12.9478f, 12.4789f, 12.9539f, 12.4789f)
                    horizontalLineTo(13.155f)
                    curveTo(13.1611f, 12.4789f, 13.1642f, 12.4743f, 13.1642f, 12.4713f)
                    curveTo(13.1642f, 12.4652f, 13.1581f, 12.4606f, 13.1535f, 12.456f)
                    lineTo(13.1124f, 12.4103f)
                    curveTo(13.1017f, 12.3997f, 13.0971f, 12.3875f, 13.0971f, 12.3692f)
                    verticalLineTo(11.6103f)
                    horizontalLineTo(13.1002f)
                    lineTo(13.2785f, 12.4408f)
                    curveTo(13.283f, 12.4637f, 13.2952f, 12.4789f, 13.309f, 12.4789f)
                    horizontalLineTo(13.373f)
                    curveTo(13.3836f, 12.4789f, 13.3882f, 12.4728f, 13.3882f, 12.4621f)
                    verticalLineTo(11.4458f)
                    curveTo(13.3882f, 11.4275f, 13.3928f, 11.4153f, 13.4019f, 11.4031f)
                    lineTo(13.44f, 11.3589f)
                    curveTo(13.4446f, 11.3543f, 13.4507f, 11.3498f, 13.4507f, 11.3437f)
                    curveTo(13.4507f, 11.3406f, 13.4476f, 11.336f, 13.4415f, 11.336f)
                    horizontalLineTo(13.2404f)
                    curveTo(13.2343f, 11.336f, 13.2312f, 11.3406f, 13.2312f, 11.3437f)
                    curveTo(13.2312f, 11.3498f, 13.2389f, 11.3543f, 13.2419f, 11.3589f)
                    lineTo(13.2846f, 11.4046f)
                    curveTo(13.2952f, 11.4153f, 13.2983f, 11.4275f, 13.2983f, 11.4458f)
                    verticalLineTo(12.0172f)
                    horizontalLineTo(13.2952f)
                    lineTo(13.155f, 11.3619f)
                    curveTo(13.152f, 11.3467f, 13.1474f, 11.336f, 13.1368f, 11.336f)
                    horizontalLineTo(12.9539f)
                    curveTo(12.9478f, 11.336f, 12.9448f, 11.3406f, 12.9448f, 11.3437f)
                    curveTo(12.9448f, 11.3498f, 12.9524f, 11.3543f, 12.9554f, 11.3589f)
                    lineTo(12.9935f, 11.4031f)
                    curveTo(13.0027f, 11.4153f, 13.0072f, 11.4275f, 13.0072f, 11.4458f)
                    verticalLineTo(12.3692f)
                    close()
                    moveTo(10.9699f, 13.7238f)
                    curveTo(10.9699f, 13.8686f, 10.9364f, 13.9265f, 10.8891f, 13.9265f)
                    curveTo(10.8343f, 13.9265f, 10.816f, 13.8412f, 10.816f, 13.4023f)
                    curveTo(10.816f, 13.0808f, 10.8343f, 12.936f, 10.8983f, 12.936f)
                    curveTo(10.9653f, 12.936f, 11.0309f, 13.1326f, 11.0629f, 13.2469f)
                    curveTo(11.0659f, 13.256f, 11.0705f, 13.2621f, 11.0766f, 13.2621f)
                    curveTo(11.0811f, 13.2621f, 11.0842f, 13.2576f, 11.0842f, 13.2515f)
                    verticalLineTo(12.8858f)
                    curveTo(11.0842f, 12.8705f, 11.0811f, 12.8598f, 11.0735f, 12.8598f)
                    curveTo(11.0659f, 12.8598f, 11.0568f, 12.8675f, 11.043f, 12.8797f)
                    curveTo(11.0278f, 12.8934f, 11.0126f, 12.904f, 11.005f, 12.904f)
                    curveTo(10.9989f, 12.904f, 10.9882f, 12.8995f, 10.9821f, 12.8949f)
                    curveTo(10.9669f, 12.8827f, 10.9364f, 12.8598f, 10.8861f, 12.8598f)
                    curveTo(10.6987f, 12.8598f, 10.691f, 13.2134f, 10.691f, 13.4008f)
                    curveTo(10.691f, 13.6553f, 10.6987f, 14.0027f, 10.8891f, 14.0027f)
                    curveTo(10.9227f, 14.0027f, 10.9531f, 13.9844f, 10.9851f, 13.9555f)
                    curveTo(10.9912f, 13.9509f, 10.9958f, 13.9494f, 11.0004f, 13.9494f)
                    curveTo(11.0065f, 13.9494f, 11.0095f, 13.9509f, 11.0156f, 13.9555f)
                    lineTo(11.0613f, 13.9966f)
                    curveTo(11.0644f, 13.9997f, 11.0705f, 14.0027f, 11.0766f, 14.0027f)
                    curveTo(11.0811f, 14.0027f, 11.0842f, 13.9997f, 11.0842f, 13.9951f)
                    verticalLineTo(13.5166f)
                    curveTo(11.0842f, 13.5014f, 11.0888f, 13.4907f, 11.0994f, 13.4831f)
                    lineTo(11.1436f, 13.4465f)
                    curveTo(11.1482f, 13.4404f, 11.1512f, 13.4374f, 11.1512f, 13.4313f)
                    curveTo(11.1512f, 13.4252f, 11.1467f, 13.4221f, 11.1406f, 13.4221f)
                    horizontalLineTo(10.915f)
                    curveTo(10.9074f, 13.4221f, 10.9029f, 13.4252f, 10.9029f, 13.4313f)
                    curveTo(10.9029f, 13.4374f, 10.9044f, 13.4404f, 10.9105f, 13.4465f)
                    lineTo(10.9531f, 13.4831f)
                    curveTo(10.9638f, 13.4922f, 10.9699f, 13.5014f, 10.9699f, 13.5166f)
                    verticalLineTo(13.7238f)
                    close()
                    moveTo(11.2244f, 13.8381f)
                    curveTo(11.2244f, 13.9326f, 11.2869f, 14.0027f, 11.4072f, 14.0027f)
                    curveTo(11.5109f, 14.0027f, 11.584f, 13.9326f, 11.584f, 13.8381f)
                    verticalLineTo(12.9696f)
                    curveTo(11.584f, 12.9513f, 11.5886f, 12.936f, 11.5962f, 12.9269f)
                    lineTo(11.6434f, 12.8827f)
                    curveTo(11.648f, 12.8781f, 11.651f, 12.8736f, 11.651f, 12.869f)
                    curveTo(11.651f, 12.8644f, 11.648f, 12.8598f, 11.6419f, 12.8598f)
                    horizontalLineTo(11.4331f)
                    curveTo(11.427f, 12.8598f, 11.424f, 12.8644f, 11.424f, 12.869f)
                    curveTo(11.424f, 12.8736f, 11.427f, 12.8781f, 11.4316f, 12.8827f)
                    lineTo(11.4789f, 12.9269f)
                    curveTo(11.488f, 12.936f, 11.491f, 12.9513f, 11.491f, 12.9696f)
                    verticalLineTo(13.7985f)
                    curveTo(11.491f, 13.8656f, 11.4758f, 13.9265f, 11.4194f, 13.9265f)
                    curveTo(11.3478f, 13.9265f, 11.3417f, 13.8656f, 11.3417f, 13.7985f)
                    verticalLineTo(12.9696f)
                    curveTo(11.3417f, 12.9513f, 11.3463f, 12.936f, 11.3539f, 12.9269f)
                    lineTo(11.4011f, 12.8827f)
                    curveTo(11.4057f, 12.8781f, 11.4088f, 12.8736f, 11.4088f, 12.869f)
                    curveTo(11.4088f, 12.8644f, 11.4057f, 12.8598f, 11.3996f, 12.8598f)
                    horizontalLineTo(11.1665f)
                    curveTo(11.1604f, 12.8598f, 11.1573f, 12.8644f, 11.1573f, 12.869f)
                    curveTo(11.1573f, 12.8736f, 11.1604f, 12.8781f, 11.165f, 12.8827f)
                    lineTo(11.2122f, 12.9269f)
                    curveTo(11.2213f, 12.936f, 11.2244f, 12.9513f, 11.2244f, 12.9696f)
                    verticalLineTo(13.8381f)
                    close()
                    moveTo(11.9802f, 13.9082f)
                    curveTo(11.9817f, 13.9219f, 11.9787f, 13.9326f, 11.9726f, 13.9387f)
                    lineTo(11.9314f, 13.9798f)
                    curveTo(11.9269f, 13.9844f, 11.9208f, 13.989f, 11.9208f, 13.9936f)
                    curveTo(11.9208f, 13.9981f, 11.9238f, 14.0027f, 11.9314f, 14.0027f)
                    horizontalLineTo(12.1509f)
                    curveTo(12.1585f, 14.0027f, 12.1615f, 13.9981f, 12.1615f, 13.9936f)
                    curveTo(12.1615f, 13.989f, 12.157f, 13.9844f, 12.1524f, 13.9798f)
                    lineTo(12.1082f, 13.9402f)
                    curveTo(12.0975f, 13.9311f, 12.093f, 13.9143f, 12.0914f, 13.8991f)
                    lineTo(11.9467f, 12.8766f)
                    curveTo(11.9451f, 12.8675f, 11.9406f, 12.8598f, 11.933f, 12.8598f)
                    horizontalLineTo(11.8766f)
                    curveTo(11.869f, 12.8598f, 11.8659f, 12.8659f, 11.8644f, 12.8736f)
                    lineTo(11.7257f, 13.8976f)
                    curveTo(11.7242f, 13.9113f, 11.7227f, 13.9265f, 11.7135f, 13.9357f)
                    lineTo(11.6709f, 13.9783f)
                    curveTo(11.6663f, 13.9829f, 11.6602f, 13.989f, 11.6602f, 13.9936f)
                    curveTo(11.6602f, 13.9981f, 11.6632f, 14.0027f, 11.6693f, 14.0027f)
                    horizontalLineTo(11.8446f)
                    curveTo(11.8522f, 14.0027f, 11.8552f, 13.9981f, 11.8552f, 13.9936f)
                    curveTo(11.8552f, 13.989f, 11.8461f, 13.9829f, 11.84f, 13.9753f)
                    lineTo(11.8065f, 13.9402f)
                    curveTo(11.8004f, 13.9326f, 11.7973f, 13.9235f, 11.7989f, 13.9128f)
                    lineTo(11.8217f, 13.7452f)
                    curveTo(11.8232f, 13.7391f, 11.8263f, 13.7345f, 11.8309f, 13.7345f)
                    horizontalLineTo(11.9436f)
                    curveTo(11.9512f, 13.7345f, 11.9558f, 13.7406f, 11.9573f, 13.7482f)
                    lineTo(11.9802f, 13.9082f)
                    close()
                    moveTo(11.84f, 13.6538f)
                    curveTo(11.837f, 13.6538f, 11.8339f, 13.6507f, 11.8354f, 13.6446f)
                    lineTo(11.8857f, 13.2698f)
                    horizontalLineTo(11.8888f)
                    lineTo(11.9421f, 13.6431f)
                    curveTo(11.9436f, 13.6492f, 11.9406f, 13.6538f, 11.936f, 13.6538f)
                    horizontalLineTo(11.84f)
                    close()
                    moveTo(12.253f, 13.893f)
                    curveTo(12.253f, 13.9113f, 12.2499f, 13.925f, 12.2392f, 13.9357f)
                    lineTo(12.1935f, 13.9798f)
                    curveTo(12.1905f, 13.9859f, 12.1829f, 13.989f, 12.1829f, 13.9936f)
                    curveTo(12.1829f, 13.9981f, 12.1859f, 14.0027f, 12.192f, 14.0027f)
                    horizontalLineTo(12.3931f)
                    curveTo(12.547f, 14.0027f, 12.6385f, 13.8991f, 12.6385f, 13.4023f)
                    curveTo(12.6385f, 13.0077f, 12.547f, 12.8598f, 12.3931f, 12.8598f)
                    horizontalLineTo(12.192f)
                    curveTo(12.1859f, 12.8598f, 12.1829f, 12.8644f, 12.1829f, 12.869f)
                    curveTo(12.1829f, 12.8736f, 12.1905f, 12.8781f, 12.1935f, 12.8827f)
                    lineTo(12.2392f, 12.9269f)
                    curveTo(12.2499f, 12.9376f, 12.253f, 12.9513f, 12.253f, 12.9696f)
                    verticalLineTo(13.893f)
                    close()
                    moveTo(12.3703f, 12.936f)
                    horizontalLineTo(12.3977f)
                    curveTo(12.4571f, 12.936f, 12.5135f, 12.9939f, 12.5135f, 13.4023f)
                    curveTo(12.5135f, 13.8686f, 12.4571f, 13.9265f, 12.3977f, 13.9265f)
                    horizontalLineTo(12.3703f)
                    verticalLineTo(12.936f)
                    close()
                    moveTo(12.8869f, 12.936f)
                    horizontalLineTo(12.9737f)
                    curveTo(12.9935f, 12.936f, 13.0072f, 12.9452f, 13.0133f, 12.965f)
                    lineTo(13.0956f, 13.2515f)
                    curveTo(13.0971f, 13.2576f, 13.1017f, 13.2621f, 13.1078f, 13.2621f)
                    curveTo(13.1124f, 13.2621f, 13.1154f, 13.2591f, 13.1154f, 13.253f)
                    verticalLineTo(12.8736f)
                    curveTo(13.1154f, 12.8659f, 13.1093f, 12.8598f, 13.1032f, 12.8598f)
                    horizontalLineTo(12.7086f)
                    curveTo(12.7025f, 12.8598f, 12.6994f, 12.8644f, 12.6994f, 12.869f)
                    curveTo(12.6994f, 12.8736f, 12.707f, 12.8781f, 12.7101f, 12.8827f)
                    lineTo(12.7558f, 12.9269f)
                    curveTo(12.7665f, 12.9376f, 12.7695f, 12.9513f, 12.7695f, 12.9696f)
                    verticalLineTo(13.893f)
                    curveTo(12.7695f, 13.9113f, 12.7665f, 13.925f, 12.7558f, 13.9357f)
                    lineTo(12.7101f, 13.9798f)
                    curveTo(12.707f, 13.9859f, 12.6994f, 13.989f, 12.6994f, 13.9936f)
                    curveTo(12.6994f, 13.9981f, 12.7025f, 14.0027f, 12.7086f, 14.0027f)
                    horizontalLineTo(13.1032f)
                    curveTo(13.1109f, 14.0027f, 13.1154f, 13.9966f, 13.1154f, 13.989f)
                    verticalLineTo(13.6065f)
                    curveTo(13.1154f, 13.6019f, 13.1124f, 13.5974f, 13.1078f, 13.5974f)
                    curveTo(13.1032f, 13.5974f, 13.0987f, 13.6004f, 13.0971f, 13.6065f)
                    lineTo(13.0149f, 13.8991f)
                    curveTo(13.0088f, 13.9174f, 12.9935f, 13.9265f, 12.9737f, 13.9265f)
                    horizontalLineTo(12.8869f)
                    verticalLineTo(13.4633f)
                    horizontalLineTo(12.9204f)
                    curveTo(12.928f, 13.4633f, 12.9341f, 13.4663f, 12.9371f, 13.4739f)
                    lineTo(12.989f, 13.5852f)
                    curveTo(12.992f, 13.5913f, 12.9935f, 13.5958f, 12.9996f, 13.5958f)
                    curveTo(13.0042f, 13.5958f, 13.0057f, 13.5928f, 13.0057f, 13.5882f)
                    verticalLineTo(13.2652f)
                    curveTo(13.0057f, 13.2591f, 13.0042f, 13.256f, 12.9996f, 13.256f)
                    curveTo(12.995f, 13.256f, 12.9935f, 13.2591f, 12.9905f, 13.2652f)
                    lineTo(12.9371f, 13.3718f)
                    curveTo(12.9341f, 13.3795f, 12.928f, 13.3825f, 12.9204f, 13.3825f)
                    horizontalLineTo(12.8869f)
                    verticalLineTo(12.936f)
                    close()
                    moveTo(13.2404f, 13.893f)
                    curveTo(13.2404f, 13.9113f, 13.2373f, 13.925f, 13.2267f, 13.9357f)
                    lineTo(13.181f, 13.9798f)
                    curveTo(13.1779f, 13.9859f, 13.1703f, 13.989f, 13.1703f, 13.9936f)
                    curveTo(13.1703f, 13.9981f, 13.1733f, 14.0027f, 13.1794f, 14.0027f)
                    horizontalLineTo(13.5528f)
                    curveTo(13.565f, 14.0027f, 13.5695f, 13.9951f, 13.5695f, 13.9814f)
                    verticalLineTo(13.608f)
                    curveTo(13.5695f, 13.6019f, 13.5665f, 13.5974f, 13.5619f, 13.5974f)
                    curveTo(13.5558f, 13.5974f, 13.5558f, 13.6019f, 13.5528f, 13.608f)
                    lineTo(13.4583f, 13.9037f)
                    curveTo(13.4522f, 13.9219f, 13.437f, 13.9265f, 13.4187f, 13.9265f)
                    horizontalLineTo(13.3577f)
                    verticalLineTo(12.9696f)
                    curveTo(13.3577f, 12.9513f, 13.3608f, 12.9376f, 13.3714f, 12.9269f)
                    lineTo(13.4171f, 12.8827f)
                    curveTo(13.4202f, 12.8781f, 13.4278f, 12.8736f, 13.4278f, 12.869f)
                    curveTo(13.4278f, 12.8644f, 13.4248f, 12.8598f, 13.4187f, 12.8598f)
                    horizontalLineTo(13.1794f)
                    curveTo(13.1733f, 12.8598f, 13.1703f, 12.8644f, 13.1703f, 12.869f)
                    curveTo(13.1703f, 12.8736f, 13.1779f, 12.8781f, 13.181f, 12.8827f)
                    lineTo(13.2267f, 12.9269f)
                    curveTo(13.2373f, 12.9376f, 13.2404f, 12.9513f, 13.2404f, 12.9696f)
                    verticalLineTo(13.893f)
                    close()
                    moveTo(13.8514f, 12.8598f)
                    curveTo(13.6686f, 12.8598f, 13.6488f, 13.1814f, 13.6488f, 13.4008f)
                    curveTo(13.6488f, 13.6888f, 13.6686f, 14.0027f, 13.8514f, 14.0027f)
                    curveTo(14.0358f, 14.0027f, 14.0556f, 13.6888f, 14.0556f, 13.4008f)
                    curveTo(14.0556f, 13.1814f, 14.0358f, 12.8598f, 13.8514f, 12.8598f)
                    close()
                    moveTo(13.8514f, 12.936f)
                    curveTo(13.8971f, 12.936f, 13.9307f, 13.064f, 13.9307f, 13.4023f)
                    curveTo(13.9307f, 13.7985f, 13.8971f, 13.9265f, 13.8514f, 13.9265f)
                    curveTo(13.8072f, 13.9265f, 13.7737f, 13.7985f, 13.7737f, 13.4023f)
                    curveTo(13.7737f, 13.064f, 13.8072f, 12.936f, 13.8514f, 12.936f)
                    close()
                    moveTo(14.1714f, 13.8381f)
                    curveTo(14.1714f, 13.9326f, 14.2339f, 14.0027f, 14.3543f, 14.0027f)
                    curveTo(14.4579f, 14.0027f, 14.531f, 13.9326f, 14.531f, 13.8381f)
                    verticalLineTo(12.9696f)
                    curveTo(14.531f, 12.9513f, 14.5356f, 12.936f, 14.5432f, 12.9269f)
                    lineTo(14.5905f, 12.8827f)
                    curveTo(14.595f, 12.8781f, 14.5981f, 12.8736f, 14.5981f, 12.869f)
                    curveTo(14.5981f, 12.8644f, 14.595f, 12.8598f, 14.589f, 12.8598f)
                    horizontalLineTo(14.3802f)
                    curveTo(14.3741f, 12.8598f, 14.371f, 12.8644f, 14.371f, 12.869f)
                    curveTo(14.371f, 12.8736f, 14.3741f, 12.8781f, 14.3787f, 12.8827f)
                    lineTo(14.4259f, 12.9269f)
                    curveTo(14.435f, 12.936f, 14.4381f, 12.9513f, 14.4381f, 12.9696f)
                    verticalLineTo(13.7985f)
                    curveTo(14.4381f, 13.8656f, 14.4229f, 13.9265f, 14.3665f, 13.9265f)
                    curveTo(14.2949f, 13.9265f, 14.2888f, 13.8656f, 14.2888f, 13.7985f)
                    verticalLineTo(12.9696f)
                    curveTo(14.2888f, 12.9513f, 14.2933f, 12.936f, 14.301f, 12.9269f)
                    lineTo(14.3482f, 12.8827f)
                    curveTo(14.3528f, 12.8781f, 14.3558f, 12.8736f, 14.3558f, 12.869f)
                    curveTo(14.3558f, 12.8644f, 14.3528f, 12.8598f, 14.3467f, 12.8598f)
                    horizontalLineTo(14.1135f)
                    curveTo(14.1074f, 12.8598f, 14.1044f, 12.8644f, 14.1044f, 12.869f)
                    curveTo(14.1044f, 12.8736f, 14.1074f, 12.8781f, 14.112f, 12.8827f)
                    lineTo(14.1592f, 12.9269f)
                    curveTo(14.1684f, 12.936f, 14.1714f, 12.9513f, 14.1714f, 12.9696f)
                    verticalLineTo(13.8381f)
                    close()
                    moveTo(14.6926f, 13.893f)
                    curveTo(14.6926f, 13.9113f, 14.6895f, 13.925f, 14.6789f, 13.9357f)
                    lineTo(14.6331f, 13.9798f)
                    curveTo(14.6301f, 13.9859f, 14.6225f, 13.989f, 14.6225f, 13.9936f)
                    curveTo(14.6225f, 13.9981f, 14.6255f, 14.0027f, 14.6316f, 14.0027f)
                    horizontalLineTo(14.8815f)
                    curveTo(14.8876f, 14.0027f, 14.8907f, 13.9981f, 14.8907f, 13.9936f)
                    curveTo(14.8907f, 13.989f, 14.8846f, 13.9844f, 14.88f, 13.9798f)
                    lineTo(14.8236f, 13.9357f)
                    curveTo(14.8114f, 13.9265f, 14.8099f, 13.9113f, 14.8099f, 13.893f)
                    verticalLineTo(13.4709f)
                    horizontalLineTo(14.8617f)
                    curveTo(14.9989f, 13.4709f, 15.0629f, 13.352f, 15.0629f, 13.1555f)
                    curveTo(15.0629f, 12.9223f, 14.9806f, 12.8598f, 14.8617f, 12.8598f)
                    horizontalLineTo(14.6316f)
                    curveTo(14.6255f, 12.8598f, 14.6225f, 12.8644f, 14.6225f, 12.869f)
                    curveTo(14.6225f, 12.8736f, 14.6301f, 12.8781f, 14.6331f, 12.8827f)
                    lineTo(14.6789f, 12.9269f)
                    curveTo(14.6895f, 12.9376f, 14.6926f, 12.9513f, 14.6926f, 12.9696f)
                    verticalLineTo(13.893f)
                    close()
                    moveTo(14.8099f, 12.936f)
                    horizontalLineTo(14.8541f)
                    curveTo(14.9181f, 12.936f, 14.9379f, 12.9863f, 14.9379f, 13.1555f)
                    curveTo(14.9379f, 13.3246f, 14.9181f, 13.3947f, 14.8541f, 13.3947f)
                    horizontalLineTo(14.8099f)
                    verticalLineTo(12.936f)
                    close()
                    moveTo(15.3051f, 12.936f)
                    horizontalLineTo(15.392f)
                    curveTo(15.4118f, 12.936f, 15.4255f, 12.9452f, 15.4316f, 12.965f)
                    lineTo(15.5139f, 13.2515f)
                    curveTo(15.5154f, 13.2576f, 15.52f, 13.2621f, 15.5261f, 13.2621f)
                    curveTo(15.5307f, 13.2621f, 15.5337f, 13.2591f, 15.5337f, 13.253f)
                    verticalLineTo(12.8736f)
                    curveTo(15.5337f, 12.8659f, 15.5276f, 12.8598f, 15.5215f, 12.8598f)
                    horizontalLineTo(15.1269f)
                    curveTo(15.1208f, 12.8598f, 15.1177f, 12.8644f, 15.1177f, 12.869f)
                    curveTo(15.1177f, 12.8736f, 15.1253f, 12.8781f, 15.1284f, 12.8827f)
                    lineTo(15.1741f, 12.9269f)
                    curveTo(15.1848f, 12.9376f, 15.1878f, 12.9513f, 15.1878f, 12.9696f)
                    verticalLineTo(13.893f)
                    curveTo(15.1878f, 13.9113f, 15.1848f, 13.925f, 15.1741f, 13.9357f)
                    lineTo(15.1284f, 13.9798f)
                    curveTo(15.1253f, 13.9859f, 15.1177f, 13.989f, 15.1177f, 13.9936f)
                    curveTo(15.1177f, 13.9981f, 15.1208f, 14.0027f, 15.1269f, 14.0027f)
                    horizontalLineTo(15.5215f)
                    curveTo(15.5291f, 14.0027f, 15.5337f, 13.9966f, 15.5337f, 13.989f)
                    verticalLineTo(13.6065f)
                    curveTo(15.5337f, 13.6019f, 15.5307f, 13.5974f, 15.5261f, 13.5974f)
                    curveTo(15.5215f, 13.5974f, 15.517f, 13.6004f, 15.5154f, 13.6065f)
                    lineTo(15.4331f, 13.8991f)
                    curveTo(15.427f, 13.9174f, 15.4118f, 13.9265f, 15.392f, 13.9265f)
                    horizontalLineTo(15.3051f)
                    verticalLineTo(13.4633f)
                    horizontalLineTo(15.3387f)
                    curveTo(15.3463f, 13.4633f, 15.3524f, 13.4663f, 15.3554f, 13.4739f)
                    lineTo(15.4072f, 13.5852f)
                    curveTo(15.4103f, 13.5913f, 15.4118f, 13.5958f, 15.4179f, 13.5958f)
                    curveTo(15.4225f, 13.5958f, 15.424f, 13.5928f, 15.424f, 13.5882f)
                    verticalLineTo(13.2652f)
                    curveTo(15.424f, 13.2591f, 15.4225f, 13.256f, 15.4179f, 13.256f)
                    curveTo(15.4133f, 13.256f, 15.4118f, 13.2591f, 15.4088f, 13.2652f)
                    lineTo(15.3554f, 13.3718f)
                    curveTo(15.3524f, 13.3795f, 15.3463f, 13.3825f, 15.3387f, 13.3825f)
                    horizontalLineTo(15.3051f)
                    verticalLineTo(12.936f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.2989f, 2.1111f)
                    curveTo(19.1314f, 1.5554f, 19.6827f, 1.4592f, 19.9381f, 2.2677f)
                    curveTo(20.1599f, 2.9699f, 19.7705f, 3.7189f, 19.0683f, 3.9407f)
                    curveTo(18.9788f, 3.969f, 18.8331f, 4.0192f, 18.6695f, 4.0793f)
                    curveTo(18.3468f, 4.1977f, 18.0425f, 4.3231f, 17.7721f, 4.45f)
                    curveTo(17.3599f, 4.6436f, 17.0589f, 4.8288f, 16.9453f, 4.943f)
                    curveTo(16.8594f, 5.0293f, 16.7339f, 5.192f, 16.5892f, 5.4105f)
                    curveTo(16.4528f, 5.6165f, 16.3034f, 5.8654f, 16.1441f, 6.1515f)
                    curveTo(15.8554f, 6.6703f, 13.4001f, 8.6976f, 12.8895f, 8.8205f)
                    curveTo(12.4921f, 8.9163f, 12.1949f, 9.0257f, 12.1089f, 9.0873f)
                    curveTo(12.04f, 9.1365f, 11.9187f, 9.256f, 11.7752f, 9.4246f)
                    curveTo(11.6366f, 9.5875f, 11.4829f, 9.7886f, 11.3184f, 10.0223f)
                    curveTo(11.1269f, 10.2944f, 10.929f, 10.5985f, 10.7329f, 10.9207f)
                    curveTo(10.6335f, 11.0841f, 10.5476f, 11.2301f, 10.4961f, 11.3219f)
                    curveTo(10.1356f, 11.9641f, 9.3229f, 12.1924f, 8.6807f, 11.832f)
                    curveTo(7.7985f, 11.3368f, 9.0866f, 8.4694f, 9.7444f, 7.6964f)
                    curveTo(10.0265f, 7.3649f, 10.2911f, 7.1088f, 10.5579f, 6.918f)
                    curveTo(10.9732f, 6.6211f, 11.5254f, 6.4062f, 12.2651f, 6.228f)
                    curveTo(12.6249f, 6.1414f, 13.0152f, 6.0676f, 13.4259f, 6.0069f)
                    curveTo(13.2263f, 6.0364f, 13.1964f, 6.0655f, 13.1718f, 6.1013f)
                    curveTo(13.2209f, 6.0298f, 13.2856f, 5.9156f, 13.3642f, 5.7622f)
                    curveTo(13.3958f, 5.7006f, 13.4152f, 5.6617f, 13.4671f, 5.5559f)
                    curveTo(13.5054f, 5.4774f, 13.632f, 5.2137f, 13.6459f, 5.185f)
                    curveTo(13.7169f, 5.0384f, 13.7673f, 4.9385f, 13.814f, 4.8546f)
                    curveTo(14.0057f, 4.5103f, 14.1894f, 4.2047f, 14.3658f, 3.9383f)
                    curveTo(14.6058f, 3.5759f, 14.8307f, 3.2875f, 15.0548f, 3.0623f)
                    curveTo(15.3225f, 2.7932f, 16.2265f, 2.4364f, 17.2989f, 2.1111f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF29568D)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(15.5275f, 3.5325f)
                    curveTo(15.3337f, 3.7273f, 15.1336f, 3.9865f, 14.9218f, 4.3064f)
                    curveTo(14.7522f, 4.5624f, 14.5767f, 4.8554f, 14.3967f, 5.1789f)
                    curveTo(14.1753f, 5.5766f, 13.7478f, 6.6333f, 13.5235f, 6.6664f)
                    curveTo(13.1495f, 6.7217f, 12.7748f, 6.791f, 12.4213f, 6.8762f)
                    curveTo(11.7912f, 7.028f, 11.2937f, 7.2116f, 10.9457f, 7.4604f)
                    curveTo(10.7226f, 7.6199f, 10.4941f, 7.8442f, 10.2522f, 8.1285f)
                    curveTo(10.068f, 8.3449f, 8.6861f, 11.0705f, 9.0072f, 11.2507f)
                    curveTo(9.3282f, 11.4309f, 9.7346f, 11.3167f, 9.9148f, 10.9957f)
                    curveTo(9.9608f, 10.9137f, 10.0469f, 10.7657f, 10.1636f, 10.574f)
                    curveTo(10.3583f, 10.2542f, 10.565f, 9.9347f, 10.7733f, 9.6386f)
                    curveTo(10.9463f, 9.393f, 11.1125f, 9.1749f, 11.2676f, 8.9926f)
                    curveTo(11.4449f, 8.7843f, 11.6013f, 8.6307f, 11.7212f, 8.545f)
                    curveTo(11.8944f, 8.4211f, 12.2577f, 8.2871f, 12.7335f, 8.1725f)
                    curveTo(13.044f, 8.0977f, 15.3541f, 6.2003f, 15.5617f, 5.8273f)
                    curveTo(15.7263f, 5.5317f, 15.8847f, 5.2672f, 16.0335f, 5.0425f)
                    curveTo(16.2008f, 4.7898f, 16.3511f, 4.5952f, 16.4728f, 4.4729f)
                    curveTo(16.6549f, 4.2898f, 17.0155f, 4.0689f, 17.4889f, 3.8466f)
                    curveTo(17.7892f, 3.7057f, 18.1143f, 3.573f, 18.4399f, 3.4535f)
                    curveTo(18.6351f, 3.3818f, 18.7854f, 3.331f, 18.8676f, 3.3051f)
                    curveTo(19.2187f, 3.1942f, 19.4134f, 2.8196f, 19.3025f, 2.4686f)
                    curveTo(19.1916f, 2.1175f, 15.8451f, 3.2132f, 15.5275f, 3.5325f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF8996A2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(0.0f, 0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(0.0f)
                    close()
                    moveTo(27.5f, 0.5f)
                    horizontalLineTo(0.5f)
                    lineTo(0.5f, 19.5f)
                    horizontalLineTo(27.5f)
                    verticalLineTo(0.5f)
                    close()
                }
            }
        }
        .build()
        return _gp!!
    }

private var _gp: ImageVector? = null
