package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Gd: ImageVector
    get() {
        if (_gd != null) {
            return _gd!!
        }
        _gd = Builder(name = "Gd", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    curveTo(9.3333f, -1.0E-4f, 18.6667f, -1.0E-4f, 28.0f, 0.0f)
                    verticalLineTo(20.0f)
                    curveTo(18.6667f, 20.0f, 9.3333f, 20.0f, 0.0f, 20.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE42235)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    lineTo(28.0f, 0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF079B77)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(2.6665f, 2.6667f)
                    horizontalLineTo(25.3332f)
                    verticalLineTo(17.3334f)
                    horizontalLineTo(2.6665f)
                    verticalLineTo(2.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFD938)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(4.3932f, 10.1318f)
                    curveTo(4.7707f, 10.736f, 5.3127f, 11.1348f, 5.8175f, 11.2371f)
                    curveTo(6.0954f, 11.2934f, 5.5866f, 10.0189f, 5.8083f, 9.8804f)
                    curveTo(5.9975f, 9.7621f, 6.9078f, 10.822f, 6.9875f, 10.6009f)
                    curveTo(7.1709f, 10.0921f, 7.0627f, 9.3717f, 6.6547f, 8.7187f)
                    curveTo(6.0693f, 7.782f, 6.0465f, 8.4003f, 4.4641f, 7.7292f)
                    curveTo(4.6296f, 8.6889f, 3.8079f, 9.1951f, 4.3932f, 10.1318f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFD938)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.9998f, 10.0f)
                    lineTo(25.3332f, 2.6667f)
                    horizontalLineTo(2.6665f)
                    lineTo(13.9998f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFD938)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.9998f, 10.0f)
                    lineTo(2.6665f, 17.3334f)
                    horizontalLineTo(25.3332f)
                    lineTo(13.9998f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE21C30)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(13.9998f, 13.3334f)
                    curveTo(15.8408f, 13.3334f, 17.3332f, 11.841f, 17.3332f, 10.0f)
                    curveTo(17.3332f, 8.1591f, 15.8408f, 6.6667f, 13.9998f, 6.6667f)
                    curveTo(12.1589f, 6.6667f, 10.6665f, 8.1591f, 10.6665f, 10.0f)
                    curveTo(10.6665f, 11.841f, 12.1589f, 13.3334f, 13.9998f, 13.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFD938)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(13.9997f, 11.0284f)
                    lineTo(12.4322f, 12.1574f)
                    lineTo(13.0216f, 10.3178f)
                    lineTo(11.4635f, 9.176f)
                    lineTo(13.3952f, 9.168f)
                    lineTo(13.9997f, 7.3334f)
                    lineTo(14.6042f, 9.168f)
                    lineTo(16.5358f, 9.176f)
                    lineTo(14.9777f, 10.3178f)
                    lineTo(15.5671f, 12.1574f)
                    lineTo(13.9997f, 11.0284f)
                    close()
                }
            }
        }
        .build()
        return _gd!!
    }

private var _gd: ImageVector? = null
