package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.GbNir: ImageVector
    get() {
        if (_gbNir != null) {
            return _gbNir!!
        }
        _gbNir = Builder(name = "GbNir", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp,
                viewportWidth = 28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE82739)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.0f, 8.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(12.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(16.0f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(16.0f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(12.0f)
                    verticalLineTo(8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(15.3553f, 12.3475f)
                    lineTo(14.0f, 14.6667f)
                    lineTo(12.6446f, 12.3475f)
                    lineTo(9.9585f, 12.3333f)
                    lineTo(11.2893f, 10.0f)
                    lineTo(9.9585f, 7.6667f)
                    lineTo(12.6446f, 7.6525f)
                    lineTo(14.0f, 5.3333f)
                    lineTo(15.3553f, 7.6525f)
                    lineTo(18.0414f, 7.6667f)
                    lineTo(16.7106f, 10.0f)
                    lineTo(18.0414f, 12.3333f)
                    lineTo(15.3553f, 12.3475f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE6101E)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(12.7342f, 9.3413f)
                    curveTo(12.6969f, 8.9687f, 12.9448f, 8.574f, 13.2995f, 8.4558f)
                    lineTo(14.0339f, 8.211f)
                    curveTo(14.3834f, 8.0945f, 14.6667f, 8.2951f, 14.6667f, 8.6771f)
                    verticalLineTo(10.0f)
                    curveTo(14.6667f, 10.0f, 15.0949f, 8.6179f, 15.3334f, 9.3334f)
                    curveTo(15.5719f, 10.0488f, 15.1629f, 11.3686f, 15.1629f, 11.3686f)
                    curveTo(15.073f, 11.7173f, 14.705f, 12.0f, 14.323f, 12.0f)
                    horizontalLineTo(13.6772f)
                    curveTo(13.3032f, 12.0f, 12.9693f, 11.6924f, 12.9326f, 11.3255f)
                    lineTo(12.7342f, 9.3413f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.9989f, 3.8779f)
                    curveTo(13.3181f, 3.8779f, 12.7111f, 4.2821f, 12.4421f, 4.8948f)
                    lineTo(12.3081f, 5.2f)
                    lineTo(12.9186f, 5.468f)
                    lineTo(13.0526f, 5.1628f)
                    curveTo(13.2161f, 4.7902f, 13.585f, 4.5446f, 13.9989f, 4.5446f)
                    curveTo(14.41f, 4.5446f, 14.7767f, 4.7868f, 14.942f, 5.1554f)
                    lineTo(15.0785f, 5.4595f)
                    lineTo(15.6867f, 5.1867f)
                    lineTo(15.5503f, 4.8825f)
                    curveTo(15.2785f, 4.2764f, 14.675f, 3.8779f, 13.9989f, 3.8779f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF5169E2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0001f, 6.5f)
                    curveTo(14.7364f, 6.5f, 15.3334f, 6.7364f, 15.3334f, 6.0f)
                    curveTo(15.3334f, 5.2636f, 14.7365f, 4.6666f, 14.0001f, 4.6666f)
                    curveTo(13.2637f, 4.6666f, 12.6667f, 5.2636f, 12.6667f, 6.0f)
                    curveTo(12.6667f, 6.7364f, 13.2637f, 6.5f, 14.0001f, 6.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFD34D43)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.5f, 6.5f)
                    curveTo(14.2364f, 6.5f, 16.0f, 5.7364f, 16.0f, 5.0f)
                    curveTo(16.0f, 4.9068f, 16.0698f, 4.6666f, 15.3334f, 4.6666f)
                    curveTo(14.597f, 4.6666f, 14.0001f, 5.2636f, 14.0001f, 6.0f)
                    curveTo(14.0001f, 6.7364f, 12.7636f, 6.5f, 13.5f, 6.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFD34D43)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0001f, 6.0f)
                    curveTo(14.0001f, 6.7364f, 14.7364f, 6.0f, 14.0001f, 6.0f)
                    curveTo(14.0001f, 5.2636f, 13.4031f, 4.6666f, 12.6668f, 4.6666f)
                    curveTo(11.9304f, 4.6666f, 12.0f, 4.8956f, 12.0f, 5.0f)
                    curveTo(12.0f, 5.7364f, 13.2637f, 6.0f, 14.0001f, 6.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFD148)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(12.0f, 5.0f)
                    lineTo(13.3334f, 5.3333f)
                    lineTo(14.0001f, 4.6666f)
                    lineTo(14.6667f, 5.3333f)
                    lineTo(16.0f, 5.0f)
                    lineTo(15.4619f, 6.3453f)
                    curveTo(15.3909f, 6.5228f, 15.19f, 6.6667f, 15.0064f, 6.6667f)
                    horizontalLineTo(12.9937f)
                    curveTo(12.8131f, 6.6667f, 12.6144f, 6.5359f, 12.5381f, 6.3453f)
                    lineTo(12.0f, 5.0f)
                    close()
                    moveTo(14.0f, 4.0f)
                    curveTo(13.6318f, 4.0f, 13.3334f, 3.7015f, 13.3334f, 3.3333f)
                    curveTo(13.3334f, 2.9651f, 13.6318f, 2.6667f, 14.0f, 2.6667f)
                    curveTo(14.3682f, 2.6667f, 14.6667f, 2.9651f, 14.6667f, 3.3333f)
                    curveTo(14.6667f, 3.7015f, 14.3682f, 4.0f, 14.0f, 4.0f)
                    close()
                }
            }
        }
        .build()
        return _gbNir!!
    }

private var _gbNir: ImageVector? = null
