package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Gb: ImageVector
    get() {
        if (_gb != null) {
            return _gb!!
        }
        _gb = Builder(name = "Gb", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(-1.0E-4f, 2.0f)
                    curveTo(-1.0E-4f, 0.8955f, -1.0E-4f, 0.0f, -1.0E-4f, 0.0f)
                    horizontalLineTo(27.9999f)
                    curveTo(27.9999f, 6.6667f, 27.9999f, 13.3334f, 27.9999f, 20.0f)
                    horizontalLineTo(-1.0E-4f)
                    curveTo(-1.0E-4f, 14.0f, -1.0E-4f, 8.0f, -1.0E-4f, 2.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0A17A7)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(-1.0E-4f, 0.0f)
                    horizontalLineTo(27.9999f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(-1.0E-4f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(1.4999f, 0.0f)
                    lineTo(10.6666f, 6.1434f)
                    verticalLineTo(-0.013f)
                    horizontalLineTo(17.3333f)
                    verticalLineTo(6.1434f)
                    lineTo(26.2788f, -0.0017f)
                    lineTo(27.9999f, 0.0f)
                    lineTo(28.0031f, 2.1677f)
                    lineTo(21.3262f, 6.6667f)
                    horizontalLineTo(27.9999f)
                    verticalLineTo(13.3334f)
                    horizontalLineTo(21.3262f)
                    lineTo(27.9946f, 17.8462f)
                    lineTo(27.9999f, 20.0f)
                    lineTo(26.4314f, 20.0029f)
                    lineTo(17.3333f, 13.8567f)
                    verticalLineTo(20.0009f)
                    horizontalLineTo(10.6666f)
                    verticalLineTo(13.8567f)
                    lineTo(1.6181f, 20.0032f)
                    lineTo(-1.0E-4f, 20.0f)
                    lineTo(-4.0E-4f, 17.8527f)
                    lineTo(6.6737f, 13.3334f)
                    horizontalLineTo(-1.0E-4f)
                    verticalLineTo(6.6667f)
                    horizontalLineTo(6.6737f)
                    lineTo(-1.0E-4f, 2.0f)
                    verticalLineTo(0.0f)
                    lineTo(1.4999f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDB1F35)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(27.9999f, 0.0f)
                    lineTo(28.0031f, 0.556f)
                    lineTo(18.8511f, 6.6107f)
                    curveTo(18.6973f, 6.7119f, 18.4906f, 6.6692f, 18.3894f, 6.5154f)
                    curveTo(18.2882f, 6.3616f, 18.3309f, 6.1549f, 18.4847f, 6.0538f)
                    lineTo(27.7012f, -0.0017f)
                    lineTo(27.9999f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDB1F35)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(28.001f, 18.6693f)
                    lineTo(20.199f, 13.4211f)
                    curveTo(20.0464f, 13.3182f, 19.8392f, 13.3586f, 19.7363f, 13.5112f)
                    curveTo(19.6334f, 13.6639f, 19.6737f, 13.8711f, 19.8264f, 13.9739f)
                    lineTo(28.001f, 19.4797f)
                    verticalLineTo(18.6693f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDB1F35)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(-1.0E-4f, 0.5f)
                    lineTo(8.1917f, 6.0341f)
                    curveTo(8.3444f, 6.137f, 8.3848f, 6.3441f, 8.2819f, 6.4968f)
                    curveTo(8.179f, 6.6494f, 7.9718f, 6.6898f, 7.8192f, 6.5869f)
                    lineTo(-1.0E-4f, 1.3086f)
                    verticalLineTo(0.5f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDB1F35)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(-1.0E-4f, 20.0f)
                    lineTo(0.3322f, 20.0032f)
                    lineTo(9.4742f, 13.8827f)
                    curveTo(9.6276f, 13.781f, 9.6695f, 13.5741f, 9.5678f, 13.4207f)
                    curveTo(9.466f, 13.2673f, 9.2592f, 13.2254f, 9.1058f, 13.3271f)
                    lineTo(-0.0078f, 19.3234f)
                    lineTo(-1.0E-4f, 20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE6273E)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(-1.0E-4f, 12.0f)
                    horizontalLineTo(11.9999f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(15.9999f)
                    verticalLineTo(12.0f)
                    horizontalLineTo(27.9999f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(15.9999f)
                    verticalLineTo(0.0f)
                    horizontalLineTo(11.9999f)
                    verticalLineTo(8.0f)
                    horizontalLineTo(-1.0E-4f)
                    verticalLineTo(12.0f)
                    close()
                }
            }
        }
        .build()
        return _gb!!
    }

private var _gb: ImageVector? = null
