package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Fk: ImageVector
    get() {
        if (_fk != null) {
            return _fk!!
        }
        _fk = Builder(name = "Fk", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(-1.0E-4f, 0.0028f)
                    curveTo(9.3333f, 0.0028f, 18.6666f, 0.0028f, 27.9999f, 0.0028f)
                    curveTo(27.9999f, 6.6695f, 27.9999f, 13.3361f, 27.9999f, 20.0028f)
                    curveTo(18.6666f, 20.0028f, 9.3333f, 20.0028f, -0.0f, 20.0028f)
                    lineTo(-1.0E-4f, 0.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF07319C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(-1.0E-4f, 0.0028f)
                    horizontalLineTo(27.9999f)
                    verticalLineTo(20.0028f)
                    horizontalLineTo(-0.0f)
                    lineTo(-1.0E-4f, 0.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0072C4)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3333f, 10.0028f)
                    curveTo(17.3333f, 8.909f, 17.3333f, 7.6159f, 17.3333f, 6.6686f)
                    curveTo(17.3333f, 5.9322f, 17.9302f, 5.3361f, 18.6666f, 5.3361f)
                    horizontalLineTo(22.6666f)
                    curveTo(23.403f, 5.3361f, 23.9999f, 5.9322f, 23.9999f, 6.6686f)
                    curveTo(23.9999f, 7.6159f, 23.9999f, 8.909f, 23.9999f, 10.0028f)
                    curveTo(23.9999f, 13.3361f, 20.6666f, 14.6695f, 20.6666f, 14.6695f)
                    curveTo(20.6666f, 14.6695f, 17.3333f, 13.3361f, 17.3333f, 10.0028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.5624f, 11.4533f)
                    curveTo(17.4858f, 11.2217f, 17.4257f, 10.9763f, 17.3863f, 10.7166f)
                    curveTo(17.6547f, 10.7894f, 17.9239f, 10.8596f, 18.1519f, 10.9136f)
                    curveTo(18.2825f, 10.9446f, 18.3968f, 10.9696f, 18.488f, 10.9866f)
                    curveTo(18.5337f, 10.9952f, 18.5714f, 11.0013f, 18.6011f, 11.0052f)
                    curveTo(18.6159f, 11.0071f, 18.6277f, 11.0084f, 18.6367f, 11.0091f)
                    lineTo(18.6401f, 11.0093f)
                    curveTo(18.6517f, 11.0076f, 18.6686f, 11.0048f, 18.6913f, 11.0007f)
                    curveTo(18.7394f, 10.992f, 18.8048f, 10.9794f, 18.8846f, 10.9636f)
                    lineTo(19.0509f, 10.9305f)
                    curveTo(19.1778f, 10.9051f, 19.3226f, 10.8762f, 19.4711f, 10.8475f)
                    curveTo(19.8931f, 10.766f, 20.4078f, 10.673f, 20.6677f, 10.673f)
                    curveTo(20.7371f, 10.673f, 20.8907f, 10.692f, 21.0514f, 10.7138f)
                    curveTo(21.2262f, 10.7374f, 21.4466f, 10.77f, 21.6736f, 10.8057f)
                    curveTo(22.1193f, 10.876f, 22.6173f, 10.9628f, 22.8361f, 11.0212f)
                    lineTo(22.8346f, 11.0208f)
                    curveTo(22.8325f, 11.0203f, 22.8315f, 11.0199f, 22.8315f, 11.0199f)
                    curveTo(22.8315f, 11.0199f, 22.8329f, 11.0197f, 22.8358f, 11.0198f)
                    curveTo(22.8464f, 11.0199f, 22.8775f, 11.0204f, 22.9372f, 11.0136f)
                    curveTo(23.0187f, 11.0043f, 23.1241f, 10.9852f, 23.2489f, 10.9574f)
                    curveTo(23.4538f, 10.9117f, 23.6943f, 10.8462f, 23.9378f, 10.7743f)
                    curveTo(23.8943f, 11.0378f, 23.8296f, 11.2864f, 23.7479f, 11.5206f)
                    curveTo(23.6251f, 11.5534f, 23.5056f, 11.5832f, 23.394f, 11.6081f)
                    curveTo(23.2578f, 11.6384f, 23.1271f, 11.6629f, 23.0129f, 11.6759f)
                    curveTo(22.9112f, 11.6876f, 22.779f, 11.696f, 22.6639f, 11.6653f)
                    curveTo(22.4856f, 11.6176f, 22.0248f, 11.536f, 21.5698f, 11.4643f)
                    curveTo(21.3464f, 11.4291f, 21.1309f, 11.3973f, 20.9619f, 11.3744f)
                    curveTo(20.8773f, 11.3629f, 20.8056f, 11.3539f, 20.751f, 11.3477f)
                    curveTo(20.6991f, 11.3419f, 20.6746f, 11.3402f, 20.6689f, 11.3398f)
                    lineTo(20.6677f, 11.3397f)
                    curveTo(20.4871f, 11.3397f, 20.0471f, 11.4152f, 19.5976f, 11.5021f)
                    curveTo(19.4511f, 11.5304f, 19.3104f, 11.5585f, 19.1846f, 11.5836f)
                    lineTo(19.0139f, 11.6176f)
                    curveTo(18.9339f, 11.6334f, 18.8635f, 11.6471f, 18.809f, 11.6569f)
                    curveTo(18.782f, 11.6617f, 18.7565f, 11.666f, 18.7347f, 11.6693f)
                    curveTo(18.7199f, 11.6714f, 18.6849f, 11.6766f, 18.6507f, 11.6766f)
                    curveTo(18.5688f, 11.6766f, 18.4644f, 11.6604f, 18.3657f, 11.642f)
                    curveTo(18.2596f, 11.6222f, 18.1339f, 11.5945f, 17.9981f, 11.5623f)
                    curveTo(17.8629f, 11.5303f, 17.715f, 11.493f, 17.5624f, 11.4533f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(22.1999f, 13.4028f)
                    curveTo(22.1999f, 13.8998f, 21.5284f, 14.3028f, 20.6999f, 14.3028f)
                    curveTo(19.8715f, 14.3028f, 19.1999f, 13.8998f, 19.1999f, 13.4028f)
                    curveTo(19.1999f, 12.9057f, 19.8715f, 12.5028f, 20.6999f, 12.5028f)
                    curveTo(21.5284f, 12.5028f, 22.1999f, 12.9057f, 22.1999f, 13.4028f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF005121)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(18.8691f, 9.2705f)
                    curveTo(18.1859f, 9.9605f, 19.5248f, 9.873f, 19.5248f, 9.873f)
                    lineTo(20.4784f, 9.5677f)
                    curveTo(20.4784f, 9.5677f, 20.9071f, 9.6196f, 21.1965f, 9.7068f)
                    curveTo(21.3882f, 9.7646f, 21.9217f, 10.0028f, 21.9217f, 10.0028f)
                    curveTo(21.9217f, 10.0028f, 23.0484f, 9.7779f, 22.6523f, 9.2705f)
                    curveTo(22.2561f, 8.7631f, 19.5522f, 8.5804f, 18.8691f, 9.2705f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(17.3332f, 9.3688f)
                    lineTo(17.3333f, 10.0028f)
                    curveTo(17.3333f, 10.0218f, 17.3334f, 10.0407f, 17.3336f, 10.0595f)
                    curveTo(17.5654f, 10.1216f, 17.796f, 10.1811f, 17.9981f, 10.229f)
                    curveTo(18.1339f, 10.2611f, 18.2596f, 10.2888f, 18.3657f, 10.3086f)
                    curveTo(18.4644f, 10.327f, 18.5688f, 10.3432f, 18.6507f, 10.3432f)
                    curveTo(18.6849f, 10.3432f, 18.7199f, 10.3381f, 18.7347f, 10.3359f)
                    curveTo(18.7565f, 10.3327f, 18.782f, 10.3284f, 18.809f, 10.3235f)
                    curveTo(18.8635f, 10.3137f, 18.9339f, 10.3001f, 19.0139f, 10.2843f)
                    lineTo(19.1845f, 10.2503f)
                    curveTo(19.3103f, 10.2252f, 19.4511f, 10.197f, 19.5976f, 10.1687f)
                    curveTo(20.0471f, 10.0818f, 20.4871f, 10.0063f, 20.6677f, 10.0063f)
                    lineTo(20.6689f, 10.0064f)
                    curveTo(20.6746f, 10.0068f, 20.6991f, 10.0086f, 20.751f, 10.0144f)
                    curveTo(20.8056f, 10.0205f, 20.8773f, 10.0296f, 20.9619f, 10.041f)
                    curveTo(21.1309f, 10.0639f, 21.3464f, 10.0957f, 21.5698f, 10.1309f)
                    curveTo(22.0248f, 10.2026f, 22.4856f, 10.2843f, 22.6639f, 10.3319f)
                    curveTo(22.779f, 10.3627f, 22.9112f, 10.3542f, 23.0129f, 10.3426f)
                    curveTo(23.1271f, 10.3296f, 23.2578f, 10.3051f, 23.394f, 10.2747f)
                    curveTo(23.5806f, 10.2331f, 23.7891f, 10.1778f, 23.9986f, 10.1176f)
                    curveTo(23.9995f, 10.0796f, 23.9999f, 10.0413f, 23.9999f, 10.0028f)
                    lineTo(23.9999f, 9.4225f)
                    curveTo(23.7355f, 9.5016f, 23.4712f, 9.5745f, 23.2489f, 9.624f)
                    curveTo(23.1241f, 9.6519f, 23.0187f, 9.6709f, 22.9372f, 9.6802f)
                    curveTo(22.8775f, 9.687f, 22.8464f, 9.6866f, 22.8358f, 9.6864f)
                    curveTo(22.8329f, 9.6864f, 22.8315f, 9.6865f, 22.8315f, 9.6865f)
                    curveTo(22.8315f, 9.6865f, 22.8325f, 9.6869f, 22.8346f, 9.6875f)
                    lineTo(22.8361f, 9.6879f)
                    curveTo(22.6173f, 9.6294f, 22.1193f, 9.5426f, 21.6736f, 9.4724f)
                    curveTo(21.4466f, 9.4366f, 21.2262f, 9.4041f, 21.0514f, 9.3804f)
                    curveTo(20.8907f, 9.3586f, 20.7371f, 9.3397f, 20.6677f, 9.3397f)
                    curveTo(20.4078f, 9.3397f, 19.8931f, 9.4326f, 19.4711f, 9.5142f)
                    curveTo(19.3226f, 9.5429f, 19.1778f, 9.5718f, 19.0509f, 9.5971f)
                    lineTo(18.8846f, 9.6302f)
                    curveTo(18.8048f, 9.646f, 18.7394f, 9.6587f, 18.6913f, 9.6673f)
                    curveTo(18.6686f, 9.6714f, 18.6517f, 9.6742f, 18.6401f, 9.676f)
                    lineTo(18.6367f, 9.6757f)
                    curveTo(18.6277f, 9.675f, 18.6159f, 9.6738f, 18.6011f, 9.6718f)
                    curveTo(18.5714f, 9.6679f, 18.5337f, 9.6618f, 18.488f, 9.6533f)
                    curveTo(18.3968f, 9.6362f, 18.2825f, 9.6112f, 18.1519f, 9.5803f)
                    curveTo(17.9089f, 9.5227f, 17.619f, 9.4467f, 17.3332f, 9.3688f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFA3A3A3)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(21.8251f, 8.5779f)
                    curveTo(21.8013f, 8.5488f, 21.7373f, 8.5474f, 21.7099f, 8.5536f)
                    curveTo(21.7087f, 8.5872f, 21.7057f, 8.6272f, 21.7026f, 8.6685f)
                    curveTo(21.6957f, 8.7601f, 21.6883f, 8.8582f, 21.6992f, 8.907f)
                    curveTo(21.7149f, 8.9779f, 21.6874f, 9.0032f, 21.6243f, 9.0032f)
                    curveTo(21.5613f, 9.0032f, 21.5062f, 8.9964f, 21.5062f, 8.9694f)
                    curveTo(21.5062f, 8.9452f, 21.5135f, 8.9126f, 21.5206f, 8.8807f)
                    curveTo(21.5264f, 8.8548f, 21.5321f, 8.8293f, 21.5337f, 8.8091f)
                    curveTo(21.5346f, 8.7979f, 21.5364f, 8.7797f, 21.5386f, 8.7576f)
                    curveTo(21.5441f, 8.7014f, 21.5522f, 8.6198f, 21.5534f, 8.5625f)
                    curveTo(21.538f, 8.5614f, 21.524f, 8.5634f, 21.5121f, 8.5728f)
                    curveTo(21.4909f, 8.5894f, 21.4649f, 8.5849f, 21.4383f, 8.5803f)
                    curveTo(21.408f, 8.575f, 21.3768f, 8.5696f, 21.3506f, 8.5948f)
                    curveTo(21.3241f, 8.6201f, 21.2722f, 8.6158f, 21.2245f, 8.6118f)
                    curveTo(21.1834f, 8.6084f, 21.1455f, 8.6053f, 21.13f, 8.6217f)
                    curveTo(21.1135f, 8.6392f, 21.0859f, 8.6394f, 21.0567f, 8.6396f)
                    curveTo(21.0268f, 8.6398f, 20.9953f, 8.6401f, 20.9724f, 8.6589f)
                    curveTo(20.9491f, 8.678f, 20.9189f, 8.6734f, 20.8876f, 8.6685f)
                    curveTo(20.8582f, 8.664f, 20.8278f, 8.6593f, 20.8011f, 8.674f)
                    curveTo(20.772f, 8.6901f, 20.7395f, 8.6835f, 20.7061f, 8.6767f)
                    curveTo(20.6763f, 8.6707f, 20.6458f, 8.6645f, 20.6161f, 8.674f)
                    curveTo(20.5668f, 8.6899f, 20.488f, 8.6538f, 20.4388f, 8.6302f)
                    curveTo(20.3896f, 8.6065f, 20.3205f, 8.5879f, 20.2891f, 8.6353f)
                    curveTo(20.2576f, 8.6824f, 20.1749f, 8.7331f, 20.1158f, 8.755f)
                    curveTo(20.0324f, 8.7861f, 20.0509f, 8.8393f, 20.0717f, 8.8989f)
                    curveTo(20.0814f, 8.9267f, 20.0915f, 8.9557f, 20.0921f, 8.9846f)
                    curveTo(20.0961f, 9.1686f, 20.0961f, 9.2091f, 20.0528f, 9.2244f)
                    curveTo(20.0094f, 9.2395f, 19.9032f, 9.2411f, 19.8992f, 9.2244f)
                    curveTo(19.8983f, 9.2137f, 19.8969f, 9.2018f, 19.8955f, 9.1893f)
                    curveTo(19.8908f, 9.1479f, 19.8853f, 9.0993f, 19.8912f, 9.0656f)
                    curveTo(19.8986f, 9.0245f, 19.9006f, 8.9572f, 19.9023f, 8.8976f)
                    curveTo(19.9024f, 8.8922f, 19.9026f, 8.8869f, 19.9027f, 8.8817f)
                    curveTo(19.9034f, 8.8592f, 19.9041f, 8.8382f, 19.9051f, 8.8209f)
                    curveTo(19.9075f, 8.7803f, 19.8555f, 8.7435f, 19.8008f, 8.7172f)
                    curveTo(19.7968f, 8.8252f, 19.8007f, 8.9981f, 19.8164f, 9.0691f)
                    curveTo(19.8323f, 9.1399f, 19.8045f, 9.1652f, 19.7417f, 9.1652f)
                    curveTo(19.6786f, 9.1652f, 19.6235f, 9.1585f, 19.6235f, 9.1315f)
                    curveTo(19.6235f, 9.1072f, 19.6308f, 9.0745f, 19.638f, 9.0425f)
                    curveTo(19.6438f, 9.0166f, 19.6495f, 8.9912f, 19.6511f, 8.9712f)
                    lineTo(19.6525f, 8.953f)
                    curveTo(19.6582f, 8.8841f, 19.6718f, 8.7169f, 19.6647f, 8.6679f)
                    lineTo(19.6581f, 8.6653f)
                    curveTo(19.6225f, 8.6512f, 19.5884f, 8.6376f, 19.5269f, 8.647f)
                    curveTo(19.476f, 8.6548f, 19.4446f, 8.638f, 19.4111f, 8.6201f)
                    curveTo(19.3862f, 8.6068f, 19.3602f, 8.5929f, 19.3241f, 8.5879f)
                    curveTo(19.2807f, 8.5819f, 19.272f, 8.5647f, 19.2629f, 8.5466f)
                    curveTo(19.2543f, 8.5295f, 19.2453f, 8.5117f, 19.206f, 8.5018f)
                    curveTo(19.1578f, 8.4898f, 19.1475f, 8.4614f, 19.1378f, 8.4348f)
                    curveTo(19.1312f, 8.4168f, 19.1249f, 8.3997f, 19.1075f, 8.3888f)
                    curveTo(19.0822f, 8.373f, 19.0776f, 8.347f, 19.0729f, 8.3199f)
                    curveTo(19.0677f, 8.2907f, 19.0624f, 8.2604f, 19.0308f, 8.2402f)
                    curveTo(18.9869f, 8.2124f, 18.9874f, 8.1153f, 19.017f, 8.0377f)
                    curveTo(19.0344f, 7.9918f, 19.034f, 7.9547f, 19.0336f, 7.9202f)
                    curveTo(19.0333f, 7.8964f, 19.033f, 7.8738f, 19.0386f, 7.8503f)
                    curveTo(19.0449f, 7.8244f, 19.037f, 7.8029f, 19.0291f, 7.7813f)
                    curveTo(19.0195f, 7.755f, 19.0097f, 7.7284f, 19.0248f, 7.6933f)
                    curveTo(19.0435f, 7.6498f, 19.0111f, 7.5734f, 18.9894f, 7.5482f)
                    curveTo(18.9677f, 7.5229f, 18.95f, 7.4959f, 18.9579f, 7.4706f)
                    curveTo(18.9742f, 7.4183f, 18.8791f, 7.4014f, 18.8121f, 7.4334f)
                    curveTo(18.7716f, 7.4528f, 18.7404f, 7.4438f, 18.717f, 7.437f)
                    curveTo(18.7016f, 7.4326f, 18.6896f, 7.4291f, 18.6803f, 7.435f)
                    curveTo(18.6229f, 7.4719f, 18.5677f, 7.4618f, 18.562f, 7.4283f)
                    curveTo(18.558f, 7.4047f, 18.5364f, 7.3878f, 18.5226f, 7.3776f)
                    curveTo(18.5201f, 7.3758f, 18.5165f, 7.3737f, 18.5125f, 7.3713f)
                    curveTo(18.4947f, 7.3607f, 18.4687f, 7.3453f, 18.4912f, 7.3287f)
                    curveTo(18.5068f, 7.3173f, 18.5054f, 7.2987f, 18.5037f, 7.2774f)
                    curveTo(18.5024f, 7.2612f, 18.501f, 7.2433f, 18.5069f, 7.2258f)
                    curveTo(18.5207f, 7.1852f, 18.5936f, 7.1616f, 18.6663f, 7.148f)
                    curveTo(18.7017f, 7.1415f, 18.7315f, 7.116f, 18.7624f, 7.0895f)
                    curveTo(18.7953f, 7.0613f, 18.8295f, 7.0319f, 18.8731f, 7.0232f)
                    curveTo(18.9183f, 7.0142f, 18.9165f, 6.9861f, 18.9146f, 6.9591f)
                    curveTo(18.9074f, 6.8608f, 18.9954f, 6.7987f, 19.0405f, 6.824f)
                    curveTo(19.0662f, 6.7818f, 19.1725f, 6.77f, 19.206f, 6.8089f)
                    curveTo(19.2217f, 6.7784f, 19.2848f, 6.77f, 19.3163f, 6.8089f)
                    curveTo(19.3656f, 6.7767f, 19.462f, 6.8172f, 19.4542f, 6.8696f)
                    curveTo(19.5231f, 6.8679f, 19.5644f, 6.9017f, 19.5585f, 6.9439f)
                    curveTo(19.596f, 6.9371f, 19.6373f, 6.9557f, 19.6411f, 6.9811f)
                    curveTo(19.7161f, 6.976f, 19.7494f, 6.9811f, 19.7771f, 7.0232f)
                    curveTo(19.7903f, 7.0434f, 19.8176f, 7.0441f, 19.8443f, 7.0448f)
                    curveTo(19.8735f, 7.0455f, 19.9021f, 7.0462f, 19.9111f, 7.0721f)
                    curveTo(19.9247f, 7.1115f, 19.9464f, 7.1185f, 19.9674f, 7.1253f)
                    curveTo(19.9859f, 7.1312f, 20.004f, 7.1371f, 20.0154f, 7.1649f)
                    curveTo(20.0291f, 7.1987f, 20.045f, 7.2072f, 20.0725f, 7.2056f)
                    lineTo(20.0774f, 7.2053f)
                    curveTo(20.1022f, 7.2037f, 20.1192f, 7.2026f, 20.1474f, 7.2292f)
                    curveTo(20.1847f, 7.2646f, 20.256f, 7.2834f, 20.3186f, 7.273f)
                    curveTo(20.5019f, 7.2427f, 20.7342f, 7.2562f, 20.8325f, 7.2697f)
                    curveTo(20.9311f, 7.2832f, 21.254f, 7.2628f, 21.4274f, 7.2427f)
                    curveTo(21.6007f, 7.2223f, 21.8468f, 7.1991f, 21.9788f, 7.2494f)
                    curveTo(21.9897f, 7.2535f, 22.0018f, 7.2579f, 22.0148f, 7.2627f)
                    curveTo(22.0864f, 7.2886f, 22.1851f, 7.3244f, 22.2583f, 7.3845f)
                    curveTo(22.345f, 7.4553f, 22.3687f, 7.5803f, 22.3411f, 7.6241f)
                    curveTo(22.3624f, 7.6457f, 22.357f, 7.6648f, 22.3512f, 7.6855f)
                    curveTo(22.3452f, 7.707f, 22.3388f, 7.73f, 22.3608f, 7.7592f)
                    curveTo(22.3835f, 7.7893f, 22.3716f, 7.8157f, 22.3602f, 7.8408f)
                    curveTo(22.3499f, 7.8636f, 22.34f, 7.8853f, 22.3568f, 7.9078f)
                    curveTo(22.3746f, 7.9314f, 22.3627f, 7.955f, 22.3504f, 7.9796f)
                    curveTo(22.3381f, 8.004f, 22.3254f, 8.0293f, 22.3411f, 8.0562f)
                    curveTo(22.3561f, 8.0821f, 22.346f, 8.0963f, 22.3352f, 8.1115f)
                    curveTo(22.3234f, 8.1282f, 22.3108f, 8.1459f, 22.3293f, 8.1812f)
                    curveTo(22.3492f, 8.2192f, 22.3305f, 8.2476f, 22.3117f, 8.2759f)
                    curveTo(22.2971f, 8.298f, 22.2825f, 8.32f, 22.286f, 8.3465f)
                    curveTo(22.2902f, 8.379f, 22.2697f, 8.3999f, 22.2515f, 8.4185f)
                    curveTo(22.2356f, 8.4348f, 22.2214f, 8.4493f, 22.2269f, 8.4682f)
                    curveTo(22.2388f, 8.5085f, 22.2072f, 8.5356f, 22.1718f, 8.566f)
                    curveTo(22.1865f, 8.7456f, 22.2233f, 8.833f, 22.2485f, 8.893f)
                    curveTo(22.2638f, 8.9294f, 22.2749f, 8.9558f, 22.2742f, 8.9864f)
                    curveTo(22.2714f, 9.1028f, 22.1816f, 9.1079f, 22.1165f, 9.1096f)
                    curveTo(22.0626f, 9.111f, 22.0536f, 9.1028f, 22.0517f, 9.0504f)
                    curveTo(22.051f, 9.0326f, 22.0526f, 8.9818f, 22.0543f, 8.9284f)
                    curveTo(22.0545f, 8.9223f, 22.0547f, 8.9161f, 22.0549f, 8.91f)
                    curveTo(22.0563f, 8.8672f, 22.0576f, 8.825f, 22.0576f, 8.799f)
                    curveTo(22.0576f, 8.7444f, 22.0245f, 8.7066f, 21.9912f, 8.6686f)
                    lineTo(21.9768f, 8.6521f)
                    curveTo(21.9583f, 8.6304f, 21.9302f, 8.6231f, 21.902f, 8.6159f)
                    curveTo(21.8731f, 8.6084f, 21.8441f, 8.6009f, 21.8251f, 8.5779f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(19.1567f, 7.5296f)
                    curveTo(19.1212f, 7.5431f, 19.1331f, 7.5836f, 19.1647f, 7.6005f)
                    curveTo(19.1962f, 7.6174f, 19.267f, 7.6241f, 19.3124f, 7.6157f)
                    curveTo(19.3575f, 7.6072f, 19.3675f, 7.6208f, 19.338f, 7.6377f)
                    curveTo(19.3084f, 7.6545f, 19.3832f, 7.6579f, 19.3772f, 7.6849f)
                    curveTo(19.3715f, 7.7119f, 19.4048f, 7.7068f, 19.4364f, 7.7051f)
                    curveTo(19.4679f, 7.7035f, 19.5092f, 7.6832f, 19.5447f, 7.6646f)
                    curveTo(19.5801f, 7.6461f, 19.6057f, 7.6595f, 19.5722f, 7.6917f)
                    curveTo(19.5389f, 7.7237f, 19.4266f, 7.7643f, 19.338f, 7.7592f)
                    curveTo(19.2492f, 7.7541f, 19.202f, 7.7743f, 19.2217f, 7.803f)
                    curveTo(19.2414f, 7.8317f, 19.3359f, 7.8368f, 19.3851f, 7.8216f)
                    curveTo(19.4344f, 7.8065f, 19.4266f, 7.8335f, 19.3891f, 7.8519f)
                    curveTo(19.3516f, 7.8706f, 19.2984f, 7.8722f, 19.2532f, 7.8706f)
                    curveTo(19.2079f, 7.8689f, 19.1685f, 7.9078f, 19.2276f, 7.9296f)
                    curveTo(19.2867f, 7.9516f, 19.3655f, 7.9381f, 19.395f, 7.9567f)
                    curveTo(19.4247f, 7.9752f, 19.5152f, 7.9465f, 19.5171f, 7.9787f)
                    curveTo(19.519f, 8.0106f, 19.4915f, 8.0225f, 19.4383f, 8.0192f)
                    curveTo(19.3851f, 8.0157f, 19.4008f, 8.0397f, 19.4404f, 8.0528f)
                    curveTo(19.4758f, 8.0647f, 19.5389f, 8.0647f, 19.5722f, 8.0613f)
                    curveTo(19.6057f, 8.058f, 19.5959f, 8.0917f, 19.5624f, 8.1035f)
                    curveTo(19.529f, 8.1153f, 19.4207f, 8.1322f, 19.3675f, 8.1305f)
                    curveTo(19.3143f, 8.1289f, 19.3398f, 8.1627f, 19.4088f, 8.1627f)
                    curveTo(19.6195f, 8.1627f, 19.6904f, 8.063f, 19.7436f, 7.9938f)
                    curveTo(19.7697f, 7.9599f, 19.8204f, 7.9415f, 19.8322f, 7.9618f)
                    curveTo(19.8441f, 7.9819f, 19.846f, 7.987f, 19.8224f, 8.0039f)
                    curveTo(19.7987f, 8.0208f, 19.8045f, 8.031f, 19.8479f, 8.0326f)
                    curveTo(19.8912f, 8.0343f, 19.9543f, 8.0225f, 19.9918f, 8.0124f)
                    curveTo(20.0291f, 8.0023f, 20.1393f, 8.0661f, 20.0488f, 8.0681f)
                    curveTo(19.8892f, 8.0715f, 19.6924f, 8.1289f, 19.6275f, 8.1525f)
                    curveTo(19.5624f, 8.1761f, 19.454f, 8.2206f, 19.3872f, 8.2183f)
                    curveTo(19.338f, 8.2166f, 19.3181f, 8.2352f, 19.338f, 8.2571f)
                    curveTo(19.3575f, 8.2791f, 19.4207f, 8.2791f, 19.4561f, 8.2689f)
                    curveTo(19.4915f, 8.2588f, 19.4993f, 8.2689f, 19.4758f, 8.2891f)
                    curveTo(19.4522f, 8.3095f, 19.3931f, 8.3178f, 19.3516f, 8.3247f)
                    curveTo(19.3104f, 8.3314f, 19.29f, 8.3578f, 19.3221f, 8.3685f)
                    curveTo(19.3832f, 8.3888f, 19.3281f, 8.4073f, 19.3715f, 8.4175f)
                    curveTo(19.4147f, 8.4277f, 19.3675f, 8.4597f, 19.4147f, 8.4698f)
                    curveTo(19.462f, 8.48f, 19.4895f, 8.4749f, 19.525f, 8.4513f)
                    curveTo(19.5605f, 8.4277f, 19.5801f, 8.4141f, 19.6175f, 8.4175f)
                    curveTo(19.655f, 8.4209f, 19.6807f, 8.4039f, 19.7023f, 8.3786f)
                    curveTo(19.7239f, 8.3534f, 19.7968f, 8.3078f, 19.8204f, 8.3298f)
                    curveTo(19.8441f, 8.3517f, 19.8932f, 8.3111f, 19.9032f, 8.3331f)
                    curveTo(19.913f, 8.355f, 19.9543f, 8.3416f, 19.9642f, 8.3719f)
                    curveTo(19.975f, 8.4057f, 20.0212f, 8.4124f, 20.0528f, 8.4006f)
                    curveTo(20.0842f, 8.3888f, 20.1098f, 8.3601f, 20.1098f, 8.3178f)
                    curveTo(20.1098f, 8.2757f, 20.1217f, 8.2588f, 20.1335f, 8.3044f)
                    curveTo(20.1452f, 8.35f, 20.1887f, 8.3634f, 20.2103f, 8.3416f)
                    curveTo(20.2319f, 8.3196f, 20.2398f, 8.2437f, 20.2241f, 8.2082f)
                    curveTo(20.2084f, 8.1727f, 20.2063f, 8.1271f, 20.2221f, 8.1187f)
                    curveTo(20.2378f, 8.1103f, 20.2753f, 8.1879f, 20.291f, 8.2217f)
                    curveTo(20.3069f, 8.2555f, 20.3481f, 8.2453f, 20.3501f, 8.2115f)
                    curveTo(20.3521f, 8.1778f, 20.3895f, 8.1609f, 20.4171f, 8.1863f)
                    curveTo(20.4447f, 8.2115f, 20.429f, 8.296f, 20.4368f, 8.3365f)
                    curveTo(20.4447f, 8.377f, 20.5214f, 8.3263f, 20.5294f, 8.3398f)
                    curveTo(20.5372f, 8.3534f, 20.5667f, 8.3567f, 20.5786f, 8.328f)
                    curveTo(20.5904f, 8.2993f, 20.618f, 8.274f, 20.6337f, 8.2909f)
                    curveTo(20.6495f, 8.3078f, 20.6731f, 8.3365f, 20.6829f, 8.3685f)
                    curveTo(20.6928f, 8.4006f, 20.7282f, 8.4175f, 20.7498f, 8.3837f)
                    curveTo(20.7715f, 8.35f, 20.7873f, 8.2842f, 20.7795f, 8.2385f)
                    curveTo(20.7715f, 8.193f, 20.7854f, 8.1643f, 20.805f, 8.1879f)
                    curveTo(20.8247f, 8.2115f, 20.8227f, 8.2757f, 20.8247f, 8.328f)
                    curveTo(20.8267f, 8.3803f, 20.8916f, 8.3753f, 20.8916f, 8.2976f)
                    curveTo(20.8916f, 8.2622f, 20.9113f, 8.2555f, 20.9172f, 8.2757f)
                    curveTo(20.9232f, 8.296f, 20.9232f, 8.3298f, 20.9291f, 8.3449f)
                    curveTo(20.9436f, 8.3823f, 20.9941f, 8.3618f, 20.9999f, 8.3365f)
                    curveTo(21.0058f, 8.3111f, 20.9961f, 8.2199f, 20.9842f, 8.1795f)
                    curveTo(20.9724f, 8.1389f, 20.9961f, 8.1103f, 21.0158f, 8.1322f)
                    curveTo(21.0355f, 8.1542f, 21.0393f, 8.2115f, 21.0433f, 8.2757f)
                    curveTo(21.0472f, 8.3398f, 21.0885f, 8.3432f, 21.1103f, 8.3247f)
                    curveTo(21.1319f, 8.306f, 21.1319f, 8.2521f, 21.1221f, 8.2132f)
                    curveTo(21.1122f, 8.1745f, 21.1438f, 8.1745f, 21.1575f, 8.1981f)
                    curveTo(21.1713f, 8.2217f, 21.195f, 8.2065f, 21.191f, 8.1879f)
                    curveTo(21.1872f, 8.1694f, 21.2067f, 8.1525f, 21.2264f, 8.1778f)
                    curveTo(21.2461f, 8.2032f, 21.2402f, 8.2606f, 21.2304f, 8.306f)
                    curveTo(21.2205f, 8.3517f, 21.2796f, 8.3465f, 21.3072f, 8.3078f)
                    curveTo(21.3347f, 8.2689f, 21.321f, 8.1627f, 21.2974f, 8.1289f)
                    curveTo(21.2737f, 8.0951f, 21.2758f, 8.0512f, 21.2894f, 8.0124f)
                    curveTo(21.3033f, 7.9736f, 21.329f, 7.9718f, 21.3309f, 7.9888f)
                    curveTo(21.3328f, 8.0056f, 21.3447f, 8.0343f, 21.3663f, 8.0562f)
                    curveTo(21.3879f, 8.0782f, 21.3998f, 8.0816f, 21.4036f, 8.0477f)
                    curveTo(21.4076f, 8.0141f, 21.4273f, 8.0225f, 21.4352f, 8.0477f)
                    curveTo(21.4432f, 8.0731f, 21.4568f, 8.0933f, 21.4765f, 8.0715f)
                    curveTo(21.4962f, 8.0495f, 21.5218f, 8.0664f, 21.5061f, 8.1002f)
                    curveTo(21.4903f, 8.134f, 21.4903f, 8.1643f, 21.5021f, 8.1981f)
                    curveTo(21.514f, 8.2319f, 21.5553f, 8.2268f, 21.5593f, 8.1879f)
                    curveTo(21.5675f, 8.1072f, 21.579f, 8.1609f, 21.5888f, 8.1963f)
                    curveTo(21.5986f, 8.2319f, 21.6282f, 8.2301f, 21.6341f, 8.2099f)
                    curveTo(21.6401f, 8.1896f, 21.646f, 8.1846f, 21.646f, 8.2065f)
                    curveTo(21.646f, 8.2284f, 21.6558f, 8.247f, 21.6814f, 8.247f)
                    curveTo(21.707f, 8.247f, 21.7011f, 8.2032f, 21.7128f, 8.1761f)
                    curveTo(21.7247f, 8.1491f, 21.7463f, 8.1863f, 21.7759f, 8.2486f)
                    curveTo(21.8054f, 8.3111f, 21.827f, 8.2521f, 21.8961f, 8.3939f)
                    curveTo(21.9242f, 8.4517f, 21.965f, 8.4023f, 21.963f, 8.3821f)
                    curveTo(21.961f, 8.3618f, 21.9669f, 8.3483f, 22.0004f, 8.3483f)
                    curveTo(22.0338f, 8.3483f, 22.0614f, 8.3416f, 22.0497f, 8.3196f)
                    curveTo(22.0378f, 8.2976f, 22.0457f, 8.2571f, 22.0438f, 8.2115f)
                    curveTo(22.0418f, 8.166f, 22.0476f, 8.1407f, 22.0535f, 8.166f)
                    curveTo(22.0595f, 8.1912f, 22.0792f, 8.2268f, 22.1106f, 8.2453f)
                    curveTo(22.1421f, 8.2639f, 22.1638f, 8.2132f, 22.1381f, 8.1812f)
                    curveTo(22.1127f, 8.1491f, 22.0772f, 8.0731f, 22.0792f, 8.009f)
                    curveTo(22.0807f, 7.9618f, 22.1027f, 7.9769f, 22.1027f, 8.0106f)
                    curveTo(22.1027f, 8.0444f, 22.1224f, 8.1053f, 22.1521f, 8.1187f)
                    curveTo(22.1815f, 8.1322f, 22.1934f, 8.0697f, 22.1796f, 8.0377f)
                    curveTo(22.1658f, 8.0056f, 22.158f, 7.9618f, 22.1875f, 7.9533f)
                    curveTo(22.217f, 7.9449f, 22.1796f, 7.9095f, 22.154f, 7.884f)
                    curveTo(22.1284f, 7.8588f, 22.1127f, 7.8335f, 22.158f, 7.8352f)
                    curveTo(22.2032f, 7.8368f, 22.1658f, 7.8081f, 22.1441f, 7.7896f)
                    curveTo(22.1224f, 7.771f, 22.0851f, 7.7338f, 22.1441f, 7.7389f)
                    curveTo(22.2032f, 7.744f, 22.1836f, 7.7136f, 22.1599f, 7.6968f)
                    curveTo(22.1362f, 7.6799f, 22.1224f, 7.6477f, 22.1638f, 7.6495f)
                    curveTo(22.2052f, 7.6512f, 22.2307f, 7.6308f, 22.2269f, 7.6157f)
                    curveTo(22.2118f, 7.5572f, 22.1127f, 7.4891f, 22.0516f, 7.4368f)
                    curveTo(21.9906f, 7.3845f, 21.8921f, 7.3322f, 21.8389f, 7.3237f)
                    curveTo(21.7857f, 7.3152f, 21.7838f, 7.3491f, 21.7975f, 7.3693f)
                    curveTo(21.8113f, 7.3895f, 21.8389f, 7.403f, 21.8429f, 7.3827f)
                    curveTo(21.8467f, 7.3625f, 21.8881f, 7.3845f, 21.9078f, 7.4114f)
                    curveTo(21.9275f, 7.4385f, 21.9944f, 7.4722f, 22.0359f, 7.5026f)
                    curveTo(22.0772f, 7.5329f, 21.9807f, 7.5178f, 21.9334f, 7.4773f)
                    curveTo(21.9064f, 7.4541f, 21.9097f, 7.4823f, 21.9452f, 7.5144f)
                    curveTo(21.9807f, 7.5465f, 21.9353f, 7.56f, 21.898f, 7.5329f)
                    curveTo(21.8605f, 7.506f, 21.7641f, 7.4301f, 21.703f, 7.3811f)
                    curveTo(21.642f, 7.3322f, 21.6321f, 7.344f, 21.6301f, 7.376f)
                    curveTo(21.6282f, 7.4081f, 21.6498f, 7.4301f, 21.6892f, 7.457f)
                    curveTo(21.7287f, 7.484f, 21.7778f, 7.5262f, 21.8153f, 7.5549f)
                    curveTo(21.8527f, 7.5836f, 21.8212f, 7.6021f, 21.7975f, 7.5818f)
                    curveTo(21.7738f, 7.5616f, 21.6932f, 7.506f, 21.646f, 7.4672f)
                    curveTo(21.5986f, 7.4283f, 21.5553f, 7.4098f, 21.5258f, 7.4148f)
                    curveTo(21.4962f, 7.4199f, 21.4983f, 7.4486f, 21.5337f, 7.479f)
                    curveTo(21.5691f, 7.5093f, 21.6125f, 7.5667f, 21.6125f, 7.6005f)
                    curveTo(21.6125f, 7.6343f, 21.581f, 7.6579f, 21.5651f, 7.5972f)
                    curveTo(21.5494f, 7.5364f, 21.4746f, 7.4655f, 21.4195f, 7.4114f)
                    curveTo(21.3644f, 7.3575f, 21.3091f, 7.3473f, 21.2678f, 7.3507f)
                    curveTo(21.2264f, 7.354f, 21.2284f, 7.3945f, 21.2284f, 7.4267f)
                    curveTo(21.2284f, 7.4587f, 21.2008f, 7.4401f, 21.1989f, 7.4165f)
                    curveTo(21.197f, 7.3929f, 21.1654f, 7.3727f, 21.1476f, 7.3743f)
                    curveTo(21.13f, 7.376f, 21.1359f, 7.425f, 21.13f, 7.447f)
                    curveTo(21.1241f, 7.4688f, 21.0965f, 7.4891f, 21.0965f, 7.4385f)
                    curveTo(21.0965f, 7.3878f, 21.0315f, 7.3625f, 21.0039f, 7.3608f)
                    curveTo(20.9764f, 7.3591f, 20.9507f, 7.3693f, 20.9645f, 7.3912f)
                    curveTo(20.9783f, 7.4131f, 20.9724f, 7.4722f, 20.9626f, 7.506f)
                    curveTo(20.9527f, 7.5397f, 20.9232f, 7.4806f, 20.9172f, 7.4181f)
                    curveTo(20.9113f, 7.3558f, 20.8189f, 7.3119f, 20.7538f, 7.3304f)
                    curveTo(20.6888f, 7.3491f, 20.7381f, 7.3895f, 20.7263f, 7.4283f)
                    curveTo(20.7144f, 7.4672f, 20.6967f, 7.4317f, 20.6907f, 7.3912f)
                    curveTo(20.685f, 7.3507f, 20.6534f, 7.3253f, 20.6101f, 7.3355f)
                    curveTo(20.5667f, 7.3456f, 20.5372f, 7.3658f, 20.5392f, 7.3929f)
                    curveTo(20.5411f, 7.4199f, 20.5411f, 7.4435f, 20.5313f, 7.4873f)
                    curveTo(20.5214f, 7.5313f, 20.5038f, 7.5093f, 20.5057f, 7.4806f)
                    curveTo(20.5078f, 7.4519f, 20.4978f, 7.4047f, 20.4879f, 7.3776f)
                    curveTo(20.4781f, 7.3507f, 20.4623f, 7.376f, 20.4663f, 7.4098f)
                    curveTo(20.4703f, 7.4435f, 20.4604f, 7.5211f, 20.4447f, 7.5685f)
                    curveTo(20.429f, 7.6157f, 20.4052f, 7.6174f, 20.4171f, 7.5533f)
                    curveTo(20.429f, 7.4891f, 20.3993f, 7.3945f, 20.3698f, 7.3507f)
                    curveTo(20.3487f, 7.3193f, 20.301f, 7.3086f, 20.301f, 7.3524f)
                    curveTo(20.301f, 7.3963f, 20.3147f, 7.4283f, 20.3501f, 7.4604f)
                    curveTo(20.3855f, 7.4924f, 20.358f, 7.5718f, 20.3226f, 7.6141f)
                    curveTo(20.287f, 7.6562f, 20.2891f, 7.5954f, 20.301f, 7.5498f)
                    curveTo(20.3127f, 7.5042f, 20.2478f, 7.4891f, 20.2221f, 7.4806f)
                    curveTo(20.1965f, 7.4722f, 20.2497f, 7.4267f, 20.2615f, 7.3658f)
                    curveTo(20.2673f, 7.3359f, 20.2595f, 7.3169f, 20.2359f, 7.3152f)
                    curveTo(20.2122f, 7.3135f, 20.1492f, 7.3709f, 20.1217f, 7.4131f)
                    curveTo(20.1295f, 7.3693f, 20.1217f, 7.3304f, 20.098f, 7.3304f)
                    curveTo(20.0744f, 7.3304f, 20.0488f, 7.3727f, 20.0312f, 7.403f)
                    curveTo(20.0134f, 7.4334f, 19.9956f, 7.4165f, 20.0134f, 7.3845f)
                    curveTo(20.0312f, 7.3524f, 20.0586f, 7.2663f, 20.0232f, 7.2477f)
                    curveTo(19.9878f, 7.2292f, 19.9562f, 7.3051f, 19.9189f, 7.2915f)
                    curveTo(19.8977f, 7.2839f, 19.9267f, 7.2359f, 19.9386f, 7.214f)
                    curveTo(19.9503f, 7.192f, 19.9267f, 7.1751f, 19.8735f, 7.2156f)
                    curveTo(19.8204f, 7.2562f, 19.7968f, 7.322f, 19.7829f, 7.3625f)
                    curveTo(19.7692f, 7.403f, 19.6747f, 7.4688f, 19.6235f, 7.5042f)
                    curveTo(19.5722f, 7.5397f, 19.5506f, 7.5262f, 19.5762f, 7.511f)
                    curveTo(19.6018f, 7.4959f, 19.653f, 7.4486f, 19.6786f, 7.4301f)
                    curveTo(19.7042f, 7.4114f, 19.6924f, 7.4005f, 19.6432f, 7.4325f)
                    curveTo(19.594f, 7.4646f, 19.5044f, 7.5229f, 19.4127f, 7.5431f)
                    curveTo(19.3589f, 7.555f, 19.3516f, 7.5449f, 19.4048f, 7.5296f)
                    curveTo(19.458f, 7.5144f, 19.5801f, 7.4418f, 19.6097f, 7.4081f)
                    curveTo(19.6282f, 7.3869f, 19.5801f, 7.4047f, 19.5565f, 7.4098f)
                    curveTo(19.533f, 7.4148f, 19.5133f, 7.4081f, 19.5605f, 7.3912f)
                    curveTo(19.6076f, 7.3743f, 19.7574f, 7.241f, 19.789f, 7.192f)
                    curveTo(19.8204f, 7.1431f, 19.7928f, 7.1244f, 19.7731f, 7.1262f)
                    curveTo(19.7534f, 7.1279f, 19.7258f, 7.1397f, 19.7318f, 7.1195f)
                    curveTo(19.7377f, 7.0992f, 19.7239f, 7.0721f, 19.6983f, 7.0806f)
                    curveTo(19.6727f, 7.089f, 19.6747f, 7.138f, 19.6648f, 7.1649f)
                    curveTo(19.655f, 7.192f, 19.5998f, 7.2275f, 19.5644f, 7.2275f)
                    curveTo(19.529f, 7.2275f, 19.4798f, 7.2343f, 19.4423f, 7.2595f)
                    curveTo(19.4048f, 7.2848f, 19.3872f, 7.2612f, 19.4048f, 7.241f)
                    curveTo(19.4226f, 7.2207f, 19.462f, 7.2156f, 19.5014f, 7.214f)
                    curveTo(19.5408f, 7.2123f, 19.5841f, 7.2072f, 19.6175f, 7.1751f)
                    curveTo(19.651f, 7.1431f, 19.653f, 7.1177f, 19.6275f, 7.116f)
                    curveTo(19.6018f, 7.1144f, 19.5584f, 7.0857f, 19.5447f, 7.0739f)
                    curveTo(19.4747f, 7.0138f, 19.3466f, 7.0975f, 19.2965f, 7.1464f)
                    curveTo(19.269f, 7.1734f, 19.1744f, 7.2512f, 19.145f, 7.2713f)
                    curveTo(19.1153f, 7.2915f, 19.1272f, 7.3202f, 19.1764f, 7.2815f)
                    curveTo(19.2257f, 7.2427f, 19.2414f, 7.2697f, 19.1962f, 7.2984f)
                    curveTo(19.1507f, 7.3271f, 19.1174f, 7.3693f, 19.1331f, 7.3845f)
                    curveTo(19.1488f, 7.3996f, 19.2098f, 7.3811f, 19.2433f, 7.3625f)
                    curveTo(19.2768f, 7.344f, 19.2927f, 7.3895f, 19.2098f, 7.4047f)
                    curveTo(19.1543f, 7.415f, 19.1349f, 7.4345f, 19.1784f, 7.4368f)
                    curveTo(19.2119f, 7.4385f, 19.263f, 7.425f, 19.3104f, 7.4014f)
                    curveTo(19.3575f, 7.3776f, 19.395f, 7.3912f, 19.3556f, 7.4148f)
                    curveTo(19.3162f, 7.4385f, 19.2295f, 7.4706f, 19.1863f, 7.4706f)
                    curveTo(19.15f, 7.4706f, 19.1922f, 7.5162f, 19.1567f, 7.5296f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.9999f, 10.0028f)
                    curveTo(17.9999f, 11.4215f, 18.7022f, 12.4213f, 19.4459f, 13.0906f)
                    curveTo(19.8182f, 13.4257f, 20.1929f, 13.6695f, 20.4744f, 13.829f)
                    curveTo(20.5454f, 13.8693f, 20.61f, 13.9039f, 20.6666f, 13.933f)
                    curveTo(20.7232f, 13.9039f, 20.7878f, 13.8693f, 20.8587f, 13.829f)
                    curveTo(21.1403f, 13.6695f, 21.5149f, 13.4257f, 21.8873f, 13.0906f)
                    curveTo(22.6309f, 12.4213f, 23.3332f, 11.4215f, 23.3332f, 10.0028f)
                    verticalLineTo(6.6686f)
                    curveTo(23.3332f, 6.301f, 23.0353f, 6.0028f, 22.6666f, 6.0028f)
                    horizontalLineTo(18.6666f)
                    curveTo(18.2978f, 6.0028f, 17.9999f, 6.301f, 17.9999f, 6.6686f)
                    verticalLineTo(10.0028f)
                    close()
                    moveTo(17.3333f, 6.6686f)
                    verticalLineTo(10.0028f)
                    curveTo(17.3333f, 13.3361f, 20.6666f, 14.6695f, 20.6666f, 14.6695f)
                    curveTo(20.6666f, 14.6695f, 23.9999f, 13.3361f, 23.9999f, 10.0028f)
                    verticalLineTo(6.6686f)
                    curveTo(23.9999f, 5.9322f, 23.403f, 5.3361f, 22.6666f, 5.3361f)
                    horizontalLineTo(18.6666f)
                    curveTo(17.9302f, 5.3361f, 17.3333f, 5.9322f, 17.3333f, 6.6686f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(13.9999f, 0.9474f)
                    lineTo(11.4307f, 3.1023f)
                    horizontalLineTo(13.9999f)
                    verticalLineTo(6.67f)
                    horizontalLineTo(11.4312f)
                    lineTo(13.9999f, 8.8238f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(10.8037f)
                    lineTo(8.7856f, 8.3129f)
                    verticalLineTo(10.0026f)
                    horizontalLineTo(5.2142f)
                    verticalLineTo(8.3113f)
                    lineTo(3.1925f, 10.0026f)
                    horizontalLineTo(-7.0E-4f)
                    verticalLineTo(8.8136f)
                    lineTo(2.5627f, 6.67f)
                    horizontalLineTo(-7.0E-4f)
                    verticalLineTo(3.1023f)
                    horizontalLineTo(2.5664f)
                    lineTo(-7.0E-4f, 0.952f)
                    lineTo(-1.0E-4f, 0.0028f)
                    lineTo(3.4728f, 0.0026f)
                    lineTo(5.2142f, 1.4601f)
                    verticalLineTo(0.0026f)
                    horizontalLineTo(8.7856f)
                    verticalLineTo(1.463f)
                    lineTo(10.5344f, 0.0026f)
                    horizontalLineTo(13.9999f)
                    verticalLineTo(0.9474f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6821f, 4.1023f)
                    lineTo(13.5702f, 0.0026f)
                    lineTo(12.0935f, 0.0f)
                    lineTo(7.7857f, 3.601f)
                    verticalLineTo(0.0045f)
                    lineTo(6.2143f, 0.0045f)
                    verticalLineTo(3.6011f)
                    lineTo(1.9274f, 0.0131f)
                    lineTo(0.4254f, 0.0045f)
                    lineTo(5.3175f, 4.1023f)
                    horizontalLineTo(-1.0E-4f)
                    verticalLineTo(5.67f)
                    horizontalLineTo(5.3175f)
                    lineTo(0.1383f, 10.0008f)
                    lineTo(1.6383f, 9.9989f)
                    lineTo(6.2143f, 6.171f)
                    verticalLineTo(10.0004f)
                    horizontalLineTo(7.7857f)
                    verticalLineTo(6.1713f)
                    lineTo(12.3593f, 10.0008f)
                    lineTo(13.8495f, 10.0028f)
                    lineTo(8.6822f, 5.67f)
                    horizontalLineTo(13.9999f)
                    verticalLineTo(4.1023f)
                    horizontalLineTo(8.6821f)
                    close()
                }
            }
        }
        .build()
        return _fk!!
    }

private var _fk: ImageVector? = null
