package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Fj: ImageVector
    get() {
        if (_fj != null) {
            return _fj!!
        }
        _fj = Builder(name = "Fj", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    curveTo(28.0f, 6.6667f, 28.0f, 13.3333f, 28.0f, 20.0f)
                    curveTo(18.6667f, 20.0f, 9.3333f, 20.0f, 0.0f, 20.0f)
                    curveTo(0.0f, 13.3333f, 0.0f, 6.6667f, 0.0f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF79CFF6)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(0.0f)
                    lineTo(0.0f, 0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3334f, 10.0f)
                    curveTo(17.3334f, 8.0f, 17.3334f, 5.3333f, 17.3334f, 5.3333f)
                    horizontalLineTo(24.0f)
                    curveTo(24.0f, 5.3333f, 24.0f, 8.0f, 24.0f, 10.0f)
                    curveTo(24.0f, 13.3333f, 20.6667f, 14.6667f, 20.6667f, 14.6667f)
                    curveTo(20.6667f, 14.6667f, 17.3334f, 13.3333f, 17.3334f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF2A915C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(19.3334f, 8.0f)
                    curveTo(19.3334f, 8.3682f, 19.0349f, 8.6667f, 18.6667f, 8.6667f)
                    curveTo(18.2985f, 8.6667f, 18.0f, 8.3682f, 18.0f, 8.0f)
                    curveTo(18.0f, 7.6318f, 18.2985f, 7.3333f, 18.6667f, 7.3333f)
                    curveTo(19.0349f, 7.3333f, 19.3334f, 7.6318f, 19.3334f, 8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF2A915C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(23.3334f, 8.0f)
                    curveTo(23.3334f, 8.3682f, 23.0349f, 8.6667f, 22.6667f, 8.6667f)
                    curveTo(22.2985f, 8.6667f, 22.0f, 8.3682f, 22.0f, 8.0f)
                    curveTo(22.0f, 7.6318f, 22.2985f, 7.3333f, 22.6667f, 7.3333f)
                    curveTo(23.0349f, 7.3333f, 23.3334f, 7.6318f, 23.3334f, 8.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFEB1D43)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3334f, 5.3333f)
                    horizontalLineTo(24.0f)
                    verticalLineTo(6.6667f)
                    horizontalLineTo(21.3334f)
                    verticalLineTo(9.3333f)
                    horizontalLineTo(24.0f)
                    verticalLineTo(10.6667f)
                    horizontalLineTo(21.3334f)
                    verticalLineTo(14.6667f)
                    horizontalLineTo(20.0f)
                    verticalLineTo(10.6667f)
                    horizontalLineTo(17.3334f)
                    verticalLineTo(9.3333f)
                    horizontalLineTo(20.0f)
                    verticalLineTo(6.6667f)
                    horizontalLineTo(17.3334f)
                    verticalLineTo(5.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF042C90)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0221f, 0.0287f)
                    horizontalLineTo(14.0221f)
                    verticalLineTo(10.0287f)
                    horizontalLineTo(0.0221f)
                    verticalLineTo(0.0287f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0221f, 0.9733f)
                    lineTo(11.4529f, 3.1282f)
                    horizontalLineTo(14.0221f)
                    verticalLineTo(6.6959f)
                    horizontalLineTo(11.4534f)
                    lineTo(14.0221f, 8.8497f)
                    verticalLineTo(10.0287f)
                    lineTo(10.826f, 10.0284f)
                    lineTo(8.8079f, 8.3387f)
                    verticalLineTo(10.0284f)
                    horizontalLineTo(5.2365f)
                    verticalLineTo(8.3372f)
                    lineTo(3.2148f, 10.0284f)
                    lineTo(0.0221f, 10.0287f)
                    lineTo(0.0215f, 8.8395f)
                    lineTo(2.585f, 6.6959f)
                    horizontalLineTo(0.0215f)
                    verticalLineTo(3.1282f)
                    horizontalLineTo(2.5886f)
                    lineTo(0.0215f, 0.9779f)
                    lineTo(0.0221f, 0.0287f)
                    lineTo(3.495f, 0.0284f)
                    lineTo(5.2365f, 1.486f)
                    verticalLineTo(0.0284f)
                    horizontalLineTo(8.8079f)
                    verticalLineTo(1.4889f)
                    lineTo(10.5567f, 0.0284f)
                    lineTo(14.0221f, 0.0287f)
                    verticalLineTo(0.9733f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.7044f, 4.1281f)
                    lineTo(13.5925f, 0.0285f)
                    lineTo(12.1158f, 0.0259f)
                    lineTo(7.8079f, 3.6269f)
                    verticalLineTo(0.0303f)
                    lineTo(6.2365f, 0.0303f)
                    verticalLineTo(3.627f)
                    lineTo(1.9375f, 0.0212f)
                    lineTo(0.4477f, 0.0304f)
                    lineTo(5.3398f, 4.1281f)
                    horizontalLineTo(0.0221f)
                    verticalLineTo(5.6958f)
                    horizontalLineTo(5.3398f)
                    lineTo(0.1606f, 10.0267f)
                    lineTo(1.6606f, 10.0248f)
                    lineTo(6.2365f, 6.1969f)
                    verticalLineTo(10.0263f)
                    horizontalLineTo(7.8079f)
                    verticalLineTo(6.1971f)
                    lineTo(12.3815f, 10.0267f)
                    lineTo(13.8718f, 10.0287f)
                    lineTo(8.7044f, 5.6958f)
                    horizontalLineTo(14.0221f)
                    verticalLineTo(4.1281f)
                    horizontalLineTo(8.7044f)
                    close()
                }
            }
        }
        .build()
        return _fj!!
    }

private var _fj: ImageVector? = null
