package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Cx: ImageVector
    get() {
        if (_cx != null) {
            return _cx!!
        }
        _cx = Builder(name = "Cx", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF0637C5)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(28.0f, 0.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(5.3334f, 17.3334f)
                    lineTo(4.3905f, 17.6095f)
                    lineTo(4.6667f, 16.6667f)
                    lineTo(4.3905f, 15.7239f)
                    lineTo(5.3334f, 16.0f)
                    lineTo(6.2762f, 15.7239f)
                    lineTo(6.0f, 16.6667f)
                    lineTo(6.2762f, 17.6095f)
                    lineTo(5.3334f, 17.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(5.3334f, 7.3334f)
                    lineTo(4.3905f, 7.6095f)
                    lineTo(4.6667f, 6.6667f)
                    lineTo(4.3905f, 5.7239f)
                    lineTo(5.3334f, 6.0f)
                    lineTo(6.2762f, 5.7239f)
                    lineTo(6.0f, 6.6667f)
                    lineTo(6.2762f, 7.6095f)
                    lineTo(5.3334f, 7.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(8.0f, 11.3334f)
                    lineTo(7.0572f, 11.6095f)
                    lineTo(7.3334f, 10.6667f)
                    lineTo(7.0572f, 9.7239f)
                    lineTo(8.0f, 10.0f)
                    lineTo(8.9428f, 9.7239f)
                    lineTo(8.6667f, 10.6667f)
                    lineTo(8.9428f, 11.6095f)
                    lineTo(8.0f, 11.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(2.6667f, 12.6667f)
                    lineTo(1.7239f, 12.9428f)
                    lineTo(2.0f, 12.0f)
                    lineTo(1.7239f, 11.0572f)
                    lineTo(2.6667f, 11.3334f)
                    lineTo(3.6095f, 11.0572f)
                    lineTo(3.3333f, 12.0f)
                    lineTo(3.6095f, 12.9428f)
                    lineTo(2.6667f, 12.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(7.3335f, 14.3333f)
                    lineTo(6.8621f, 14.4714f)
                    lineTo(7.0001f, 14.0f)
                    lineTo(6.8621f, 13.5286f)
                    lineTo(7.3335f, 13.6666f)
                    lineTo(7.8049f, 13.5286f)
                    lineTo(7.6668f, 14.0f)
                    lineTo(7.8049f, 14.4714f)
                    lineTo(7.3335f, 14.3333f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF3BA758)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(28.0f, 20.0f)
                    lineTo(16.1056f, 11.5039f)
                    curveTo(16.1056f, 11.5039f, 13.4624f, 12.8712f, 12.4522f, 12.1497f)
                    curveTo(11.4421f, 11.4281f, 11.99f, 8.5642f, 11.99f, 8.5642f)
                    lineTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(20.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFCC5D)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(19.2812f, 10.0f)
                    curveTo(19.2812f, 10.0f, 22.5004f, 9.4676f, 22.8844f, 7.9645f)
                    curveTo(23.2684f, 6.4614f, 19.8205f, 5.3855f, 19.684f, 4.845f)
                    curveTo(19.5475f, 4.3046f, 20.9512f, 4.6881f, 21.5714f, 4.845f)
                    curveTo(22.1725f, 4.9973f, 23.3479f, 5.7726f, 23.3479f, 5.7726f)
                    curveTo(23.3479f, 5.7726f, 23.3337f, 4.7053f, 23.1734f, 4.2124f)
                    curveTo(22.9041f, 3.3842f, 22.0592f, 1.8092f, 22.0592f, 1.8092f)
                    curveTo(22.0592f, 1.8092f, 23.4924f, 2.7285f, 24.1073f, 3.4622f)
                    curveTo(24.4597f, 3.8827f, 24.5915f, 5.7799f, 25.0271f, 6.4302f)
                    curveTo(25.8061f, 7.593f, 27.6237f, 6.2948f, 26.8515f, 7.5275f)
                    curveTo(26.0793f, 8.7602f, 24.3041f, 8.9277f, 22.8844f, 9.4676f)
                    curveTo(21.597f, 9.9572f, 18.7302f, 10.6159f, 18.7302f, 10.6159f)
                    lineTo(19.2812f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFCC5D)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(14.0001f, 13.3333f)
                    curveTo(12.1591f, 13.3333f, 10.6667f, 11.8409f, 10.6667f, 10.0f)
                    curveTo(10.6667f, 8.159f, 12.1591f, 6.6667f, 14.0001f, 6.6667f)
                    curveTo(15.841f, 6.6667f, 17.3334f, 8.159f, 17.3334f, 10.0f)
                    curveTo(17.3334f, 11.8409f, 15.841f, 13.3333f, 14.0001f, 13.3333f)
                    close()
                    moveTo(12.3444f, 10.0f)
                    lineTo(12.0001f, 10.6667f)
                    curveTo(12.0001f, 10.6667f, 13.119f, 10.4144f, 13.4973f, 10.6667f)
                    curveTo(14.0097f, 11.0082f, 14.0001f, 12.0f, 14.0001f, 12.0f)
                    horizontalLineTo(14.6667f)
                    curveTo(14.6667f, 12.0f, 14.4487f, 11.0272f, 14.791f, 10.3426f)
                    curveTo(15.1333f, 9.658f, 16.0001f, 9.3333f, 16.0001f, 9.3333f)
                    verticalLineTo(8.0f)
                    curveTo(16.0001f, 8.0f, 15.0918f, 8.9694f, 14.0001f, 9.3333f)
                    curveTo(12.9084f, 9.6972f, 12.0001f, 9.3333f, 12.0001f, 9.3333f)
                    lineTo(12.3444f, 10.0f)
                    close()
                }
            }
        }
        .build()
        return _cx!!
    }

private var _cx: ImageVector? = null
