package com.decathlon.vitamin.compose.vitaminassets.flags

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminassets.FlagsGroup

public val FlagsGroup.Bm: ImageVector
    get() {
        if (_bm != null) {
            return _bm!!
        }
        _bm = Builder(name = "Bm", defaultWidth = 28.0.dp, defaultHeight = 20.0.dp, viewportWidth =
                28.0f, viewportHeight = 20.0f).apply {
            group {
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0f, 0.0f)
                    horizontalLineTo(28.0f)
                    verticalLineTo(20.0f)
                    horizontalLineTo(0.0f)
                    verticalLineTo(0.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(17.3335f, 10.0f)
                    curveTo(17.3335f, 8.0f, 17.3335f, 6.6667f, 17.3335f, 6.6667f)
                    horizontalLineTo(22.6668f)
                    curveTo(22.6668f, 6.6667f, 22.6668f, 8.0f, 22.6668f, 10.0f)
                    curveTo(22.6668f, 12.0f, 20.0002f, 13.3333f, 20.0002f, 13.3333f)
                    curveTo(20.0002f, 13.3333f, 17.3335f, 12.0f, 17.3335f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF65B5D2)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = EvenOdd) {
                    moveTo(20.0003f, 12.0f)
                    curveTo(20.7367f, 12.0f, 21.3337f, 11.4031f, 21.3337f, 10.6667f)
                    curveTo(21.3337f, 9.9303f, 20.7367f, 9.3334f, 20.0003f, 9.3334f)
                    curveTo(19.2639f, 9.3334f, 18.667f, 9.9303f, 18.667f, 10.6667f)
                    curveTo(18.667f, 11.4031f, 19.2639f, 12.0f, 20.0003f, 12.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE20B0C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(20.0003f, 9.3334f)
                    curveTo(20.3685f, 9.3334f, 20.6668f, 9.0349f, 20.6668f, 8.6667f)
                    curveTo(20.6668f, 8.2985f, 20.3684f, 8.0f, 20.0002f, 8.0f)
                    curveTo(19.632f, 8.0f, 19.3335f, 8.2985f, 19.3335f, 8.6667f)
                    curveTo(19.3335f, 9.0349f, 19.6321f, 9.3334f, 20.0003f, 9.3334f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE20B0C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(18.667f, 10.6667f)
                    curveTo(19.0352f, 10.6667f, 19.3333f, 10.3682f, 19.3333f, 10.0f)
                    curveTo(19.3333f, 9.6318f, 19.0349f, 9.3333f, 18.6667f, 9.3333f)
                    curveTo(18.2985f, 9.3333f, 18.0f, 9.6318f, 18.0f, 10.0f)
                    curveTo(18.0f, 10.3682f, 18.2988f, 10.6667f, 18.667f, 10.6667f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFE20B0C)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(21.9998f, 10.0f)
                    curveTo(21.9998f, 10.3682f, 21.7019f, 10.6667f, 21.3337f, 10.6667f)
                    curveTo(20.9655f, 10.6667f, 20.6665f, 10.3682f, 20.6665f, 10.0f)
                    curveTo(20.6665f, 9.6318f, 20.965f, 9.3333f, 21.3332f, 9.3333f)
                    curveTo(21.7014f, 9.3333f, 21.9998f, 9.6318f, 21.9998f, 10.0f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF2F8F22)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(21.7629f, 12.0f)
                    curveTo(20.9895f, 12.8387f, 20.0002f, 13.3333f, 20.0002f, 13.3333f)
                    curveTo(20.0002f, 13.3333f, 19.0109f, 12.8387f, 18.2374f, 12.0f)
                    horizontalLineTo(21.7629f)
                    close()
                }
                path(fill = SolidColor(Color(0xFF042C90)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(0.0084f, 0.0046f)
                    horizontalLineTo(14.0084f)
                    verticalLineTo(10.0046f)
                    horizontalLineTo(0.0084f)
                    verticalLineTo(0.0046f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFFFFFFF)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(14.0084f, 0.9492f)
                    lineTo(11.4392f, 3.1041f)
                    horizontalLineTo(14.0084f)
                    verticalLineTo(6.6718f)
                    horizontalLineTo(11.4397f)
                    lineTo(14.0084f, 8.8256f)
                    verticalLineTo(10.0046f)
                    lineTo(10.8123f, 10.0043f)
                    lineTo(8.7942f, 8.3146f)
                    verticalLineTo(10.0043f)
                    horizontalLineTo(5.2228f)
                    verticalLineTo(8.3131f)
                    lineTo(3.2011f, 10.0043f)
                    lineTo(0.0084f, 10.0046f)
                    lineTo(0.0078f, 8.8154f)
                    lineTo(2.5713f, 6.6718f)
                    horizontalLineTo(0.0078f)
                    verticalLineTo(3.1041f)
                    horizontalLineTo(2.5749f)
                    lineTo(0.0078f, 0.9538f)
                    lineTo(0.0084f, 0.0046f)
                    lineTo(3.4813f, 0.0043f)
                    lineTo(5.2228f, 1.4619f)
                    verticalLineTo(0.0043f)
                    horizontalLineTo(8.7942f)
                    verticalLineTo(1.4648f)
                    lineTo(10.543f, 0.0043f)
                    lineTo(14.0084f, 0.0046f)
                    verticalLineTo(0.9492f)
                    close()
                }
                path(fill = SolidColor(Color(0xFFDC1F37)), stroke = null, strokeLineWidth = 0.0f,
                        strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                        pathFillType = NonZero) {
                    moveTo(8.6907f, 4.104f)
                    lineTo(13.5788f, 0.0043f)
                    lineTo(12.0898f, 0.0039f)
                    lineTo(7.7942f, 3.6027f)
                    verticalLineTo(0.0078f)
                    lineTo(6.2228f, 0.0078f)
                    verticalLineTo(3.6029f)
                    lineTo(1.9359f, 0.0149f)
                    lineTo(0.434f, 0.0063f)
                    lineTo(5.3261f, 4.104f)
                    horizontalLineTo(0.0084f)
                    verticalLineTo(5.6717f)
                    horizontalLineTo(5.3261f)
                    lineTo(0.1469f, 10.0026f)
                    lineTo(1.6469f, 10.0006f)
                    lineTo(6.2228f, 6.1728f)
                    verticalLineTo(10.0022f)
                    horizontalLineTo(7.7942f)
                    verticalLineTo(6.173f)
                    lineTo(12.3678f, 10.0026f)
                    lineTo(13.8581f, 10.0046f)
                    lineTo(8.6908f, 5.6717f)
                    horizontalLineTo(14.0084f)
                    verticalLineTo(4.104f)
                    horizontalLineTo(8.6907f)
                    close()
                }
            }
        }
        .build()
        return _bm!!
    }

private var _bm: ImageVector? = null
