var JsUtils = {
	isValidJson : function(str) {
		try {
			JSON.parse(str);
		} catch (e) {
			return false;
		}
		return true;
	},

	buildExceptionMessage : function(code, message) {
		return "{\"error\":\"decoding failed\", \"code\":\"" + code + "\", \"message\":\"" + message + "\"}";
	},

	toErrorString : function(exception) {
		var msg = JsUtils.buildExceptionMessage(exception.name, exception.message);
		if (JsUtils.isValidJson(msg)) {
			return msg;
		} else {
			return JsUtils.buildExceptionMessage("exception_raised_during_js_execution", "invalid json format");
		}
	}
};

var JsSplitUtils = {
	buildErrorObject: function(code, message) {
		return [{
			value: {
				error: "decoding failed",
				code: code,
				message: message
			}
		}];
	},
	toErrorString: function(exception) {
		var splitDecoderError;
		if(exception instanceof Error) {
			splitDecoderError = this.buildErrorObject(exception.name, exception.message);
		} else {
			splitDecoderError = this.buildErrorObject(null, "invalid error" );
		}
		return  JSON.stringify(splitDecoderError);
	},
	toJavaArrayList: function(jsArray) {
		var list = new java.util.ArrayList();
		jsArray.forEach(function (item) {
			list.add(item);
		})
		return list;
	},
	stringify: function(jsonObj) {
		try {
			if(Array.isArray(jsonObj)) {
				jsonObj = this.toJavaArrayList(jsonObj);
			}
			var GsonBuilder = Java.type("com.google.gson.GsonBuilder");
			var gsonBuilder = new GsonBuilder().disableHtmlEscaping();
			var gson = gsonBuilder.create();
			return gson.toJson(jsonObj);
		} catch (e) {
			return JSON.stringify(this.buildErrorObject("exception_raised_during_js_execution", "invalid json format"));
		}
	}
};

var JsonUtils = {
	stringify : function(jsonObj) {
		try {
			var GsonBuilder = Java.type("com.google.gson.GsonBuilder");
			var gsonBuilder = new GsonBuilder().disableHtmlEscaping();
			var gson = gsonBuilder.create();
			return gson.toJson(jsonObj);
		} catch (e) {
			return JsUtils.buildExceptionMessage("exception_raised_during_js_execution", "invalid json format");
		}
	}
};
