CsvDecoder = {

decode : function (columns, options, encoded) {
            var decoded = '';
            var csvColumnsDescription = CsvDecoder.toJavaColumns(columns);
            var options = CsvDecoder.toJavaOptions(options);
            /* Instantiate a csv java decoder */
            var csvDecoderFactory = Java.type("com.orange.decoder.csv.CsvDecoderFactory");
            var csvDecoder = csvDecoderFactory.buildDecoder(csvColumnsDescription, options);
            /* Decode the input data using the java csv decoder */
            return csvDecoder.toJson(encoded);
},

toJavaColumns : function (columns) {
    var CsvcolumnsDescription = Java.type("com.orange.decoder.csv.CSVcolumnsDescription");
    var csvColumnsDescription = new CsvcolumnsDescription();
    var Column = Java.type("com.orange.decoder.csv.CSVcolumnsDescription$Column");
    var nbColumns = columns.length;

    for (var i = 0; i < nbColumns; i++) {
        var column = new Column(csvColumnsDescription, columns[i].name, CsvDecoder.getJavaJSONType(columns[i].type));
        csvColumnsDescription.addColumn(column);
    }
    return csvColumnsDescription;
},

getJavaJSONType : function (typeName) {
            var JSONType = Java.type("com.orange.decoder.csv.CSVcolumnsDescription$JSONType");
            switch (typeName) {
            case 'STRING':
                return JSONType.STRING;
            case 'NUMERIC':
                return JSONType.NUMERIC;
            case 'BOOLEAN':
                return JSONType.BOOLEAN;
            default:
                return JSONType.STRING;
            }
},

toJavaOptions : function (jsOptions) {
    var CsvDecodingOptions = Java.type("com.orange.decoder.csv.CsvDecodingOptions");
    var options = new CsvDecodingOptions();
    // check if the property exists and its value is not null
    if (jsOptions.hasOwnProperty('useHeader') && jsOptions['useHeader']) {
        options.setUseHeader(jsOptions.useHeader);
    }
    if (jsOptions.hasOwnProperty('columnSeparator') && jsOptions['columnSeparator']) {
        options.setColumnSeparator(jsOptions.columnSeparator);
    }
    if (jsOptions.hasOwnProperty('multiLine') && jsOptions['multiLine']) {
        options.setMultiLine(jsOptions.multiLine);
    }
    if (jsOptions.hasOwnProperty('lineFeedSeparator') && jsOptions['lineFeedSeparator']) {
        options.setLineFeedSeparator(jsOptions.lineFeedSeparator);
    }
    if (jsOptions.hasOwnProperty('quoteChar') && jsOptions['quoteChar']) {
        options.setQuoteChar(jsOptions.quoteChar);
    }
    if (jsOptions.hasOwnProperty('useEscapeChar') && jsOptions['useEscapeChar']) {
        options.setUseEscapeChar(jsOptions.useEscapeChar);
    }
    if (jsOptions.hasOwnProperty('escapeChar') && jsOptions['escapeChar']) {
        options.setEscapeChar(jsOptions.escapeChar);
    }
    if (jsOptions.hasOwnProperty('nullValue') && jsOptions['nullValue']) {
        options.setNullValue(jsOptions.nullValue);
    }
    if (jsOptions.hasOwnProperty('skipWhiteSpace') && jsOptions['skipWhiteSpace']) {
        options.setSkipWhiteSpace(jsOptions.skipWhiteSpace);
    }

    return options;
}

};