/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Try;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.repository.util.VavrCollections;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.concurrent.ListenableFuture;
import scala.Function0;
import scala.Option;
import scala.runtime.AbstractFunction0;

public abstract class QueryExecutionConverters {
    private static final boolean GUAVA_PRESENT = ClassUtils.isPresent("com.google.common.base.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean JDK_8_PRESENT = ClassUtils.isPresent("java.util.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean SCALA_PRESENT = ClassUtils.isPresent("scala.Option", QueryExecutionConverters.class.getClassLoader());
    private static final boolean VAVR_PRESENT = ClassUtils.isPresent("io.vavr.control.Option", QueryExecutionConverters.class.getClassLoader());
    private static final Set<WrapperType> WRAPPER_TYPES = new HashSet<WrapperType>();
    private static final Set<WrapperType> UNWRAPPER_TYPES = new HashSet<WrapperType>();
    private static final Set<Converter<Object, Object>> UNWRAPPERS = new HashSet<Converter<Object, Object>>();
    private static final Set<Class<?>> ALLOWED_PAGEABLE_TYPES = new HashSet();
    private static final Map<Class<?>, ExecutionAdapter> EXECUTION_ADAPTER = new HashMap();
    private static final Map<Class<?>, Boolean> SUPPORTS_CACHE = new ConcurrentReferenceHashMap();

    private QueryExecutionConverters() {
    }

    public static boolean supports(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        return SUPPORTS_CACHE.computeIfAbsent(type, key -> {
            for (WrapperType candidate : WRAPPER_TYPES) {
                if (!candidate.getType().isAssignableFrom((Class<?>)key)) continue;
                return true;
            }
            if (ReactiveWrappers.supports(type)) {
                return true;
            }
            return false;
        });
    }

    public static boolean supportsUnwrapping(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        for (WrapperType candidate : UNWRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleValue(Class<?> type) {
        for (WrapperType candidate : WRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return candidate.isSingleValue();
        }
        return ReactiveWrappers.supports(type) && ReactiveWrappers.isSingleValueType(type);
    }

    public static Set<Class<?>> getAllowedPageableTypes() {
        return Collections.unmodifiableSet(ALLOWED_PAGEABLE_TYPES);
    }

    public static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        conversionService.removeConvertible(Collection.class, Object.class);
        if (GUAVA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToGuavaOptionalConverter(conversionService));
        }
        if (JDK_8_PRESENT) {
            conversionService.addConverter(new NullableWrapperToJdk8OptionalConverter(conversionService));
            conversionService.addConverter(new NullableWrapperToCompletableFutureConverter(conversionService));
        }
        if (SCALA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToScalaOptionConverter(conversionService));
        }
        if (VAVR_PRESENT) {
            conversionService.addConverter(new NullableWrapperToVavrOptionConverter(conversionService));
            conversionService.addConverter(VavrCollections.FromJavaConverter.INSTANCE);
        }
        conversionService.addConverter(new NullableWrapperToFutureConverter(conversionService));
        conversionService.addConverter(new IterableToStreamableConverter());
    }

    @Nullable
    public static Object unwrap(@Nullable Object source) {
        if (source == null || !QueryExecutionConverters.supports(source.getClass())) {
            return source;
        }
        for (Converter<Object, Object> converter : UNWRAPPERS) {
            Object result = converter.convert(source);
            if (result == source) continue;
            return result;
        }
        return source;
    }

    public static TypeInformation<?> unwrapWrapperTypes(TypeInformation<?> type) {
        Assert.notNull(type, "type must not be null");
        Class<?> rawType = type.getType();
        boolean needToUnwrap = type.isCollectionLike() || Slice.class.isAssignableFrom(rawType) || GeoResults.class.isAssignableFrom(rawType) || rawType.isArray() || QueryExecutionConverters.supports(rawType) || Stream.class.isAssignableFrom(rawType);
        return needToUnwrap ? QueryExecutionConverters.unwrapWrapperTypes(type.getRequiredComponentType()) : type;
    }

    @Nullable
    public static ExecutionAdapter getExecutionAdapter(Class<?> returnType) {
        Assert.notNull(returnType, "Return type must not be null!");
        return EXECUTION_ADAPTER.get(returnType);
    }

    static {
        WRAPPER_TYPES.add(WrapperType.singleValue(Future.class));
        UNWRAPPER_TYPES.add(WrapperType.singleValue(Future.class));
        WRAPPER_TYPES.add(WrapperType.singleValue(ListenableFuture.class));
        UNWRAPPER_TYPES.add(WrapperType.singleValue(ListenableFuture.class));
        ALLOWED_PAGEABLE_TYPES.add(Slice.class);
        ALLOWED_PAGEABLE_TYPES.add(Page.class);
        ALLOWED_PAGEABLE_TYPES.add(List.class);
        if (GUAVA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPERS.add(GuavaOptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPERS.add(Jdk8OptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
        }
        if (SCALA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPERS.add(ScalOptionUnwrapper.INSTANCE);
        }
        if (VAVR_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToVavrOptionConverter.getWrapperType());
            WRAPPER_TYPES.add(VavrCollections.ToJavaConverter.INSTANCE.getWrapperType());
            UNWRAPPERS.add(VavrOptionUnwrapper.INSTANCE);
            WRAPPER_TYPES.add(WrapperType.singleValue(Try.class));
            EXECUTION_ADAPTER.put(Try.class, it -> Try.of(it::get));
            ALLOWED_PAGEABLE_TYPES.add(Seq.class);
        }
    }

    public static final class WrapperType {
        private final Class<?> type;
        private final Cardinality cardinality;

        public static WrapperType singleValue(Class<?> type) {
            return new WrapperType(type, Cardinality.SINGLE);
        }

        public static WrapperType multiValue(Class<?> type) {
            return new WrapperType(type, Cardinality.MULTI);
        }

        public static WrapperType noValue(Class<?> type) {
            return new WrapperType(type, Cardinality.NONE);
        }

        boolean isSingleValue() {
            return this.cardinality.equals((Object)Cardinality.SINGLE);
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrapperType)) {
                return false;
            }
            WrapperType other = (WrapperType)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Cardinality this$cardinality = this.cardinality;
            Cardinality other$cardinality = other.cardinality;
            return !(this$cardinality == null ? other$cardinality != null : !((Object)((Object)this$cardinality)).equals((Object)other$cardinality));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Cardinality $cardinality = this.cardinality;
            result = result * 59 + ($cardinality == null ? 43 : ((Object)((Object)$cardinality)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QueryExecutionConverters.WrapperType(type=" + this.getType() + ", cardinality=" + (Object)((Object)this.cardinality) + ")";
        }

        @Generated
        private WrapperType(Class<?> type, Cardinality cardinality) {
            this.type = type;
            this.cardinality = cardinality;
        }

        static enum Cardinality {
            NONE,
            SINGLE,
            MULTI;

        }
    }

    private static class IterableToStreamableConverter
    implements ConditionalGenericConverter {
        private static final TypeDescriptor STREAMABLE = TypeDescriptor.valueOf(Streamable.class);
        private final Map<TypeDescriptor, Boolean> TARGET_TYPE_CACHE = new ConcurrentHashMap<TypeDescriptor, Boolean>();
        private final ConversionService conversionService = DefaultConversionService.getSharedInstance();

        @Override
        @org.springframework.lang.NonNull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Iterable.class, Object.class));
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (sourceType.isAssignableTo(targetType)) {
                return false;
            }
            if (!Iterable.class.isAssignableFrom(sourceType.getType())) {
                return false;
            }
            if (Streamable.class.equals(targetType.getType())) {
                return true;
            }
            return this.TARGET_TYPE_CACHE.computeIfAbsent(targetType, it -> this.conversionService.canConvert(STREAMABLE, targetType));
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Streamable streamable = source == null ? Streamable.empty() : Streamable.of((Iterable)Iterable.class.cast(source));
            return Streamable.class.equals(targetType.getType()) ? streamable : this.conversionService.convert(streamable, STREAMABLE, targetType);
        }

        @Generated
        public IterableToStreamableConverter() {
        }
    }

    private static enum VavrOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object convert(Object source) {
            if (source instanceof io.vavr.control.Option) {
                return ((io.vavr.control.Option)source).getOrElse(() -> null);
            }
            if (source instanceof Traversable) {
                return VavrCollections.ToJavaConverter.INSTANCE.convert(source);
            }
            return source;
        }
    }

    private static enum ScalOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;

        private final Function0<Object> alternative = new AbstractFunction0<Object>(){

            @Nullable
            public Option<Object> apply() {
                return null;
            }
        };

        @Override
        @Nullable
        public Object convert(Object source) {
            return source instanceof Option ? ((Option)source).getOrElse(this.alternative) : source;
        }
    }

    private static enum Jdk8OptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object convert(Object source) {
            return source instanceof Optional ? ((Optional)source).orElse(null) : source;
        }
    }

    private static enum GuavaOptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object convert(Object source) {
            return source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source;
        }
    }

    private static class NullableWrapperToVavrOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToVavrOptionConverter(ConversionService conversionService) {
            super(conversionService, io.vavr.control.Option.none(), Collections.singleton(io.vavr.control.Option.class));
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(io.vavr.control.Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return io.vavr.control.Option.of((Object)source);
        }
    }

    private static class NullableWrapperToScalaOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToScalaOptionConverter(ConversionService conversionService) {
            super(conversionService, Option.empty(), Collections.singleton(Option.class));
        }

        @Override
        protected Object wrap(Object source) {
            return Option.apply((Object)source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Option.class);
        }
    }

    private static class NullableWrapperToCompletableFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToCompletableFutureConverter(ConversionService conversionService) {
            super(conversionService, CompletableFuture.completedFuture(null));
        }

        @Override
        protected Object wrap(Object source) {
            return source instanceof CompletableFuture ? source : CompletableFuture.completedFuture(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(CompletableFuture.class);
        }
    }

    private static class NullableWrapperToFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToFutureConverter(ConversionService conversionService) {
            super(conversionService, new AsyncResult(null), Arrays.asList(Future.class, ListenableFuture.class));
        }

        @Override
        protected Object wrap(Object source) {
            return new AsyncResult(source);
        }
    }

    private static class NullableWrapperToJdk8OptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJdk8OptionalConverter(ConversionService conversionService) {
            super(conversionService, Optional.empty());
        }

        @Override
        protected Object wrap(Object source) {
            return Optional.of(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Optional.class);
        }
    }

    private static class NullableWrapperToGuavaOptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToGuavaOptionalConverter(ConversionService conversionService) {
            super(conversionService, com.google.common.base.Optional.absent(), Collections.singleton(com.google.common.base.Optional.class));
        }

        @Override
        protected Object wrap(Object source) {
            return com.google.common.base.Optional.of(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(com.google.common.base.Optional.class);
        }
    }

    private static abstract class AbstractWrapperTypeConverter
    implements GenericConverter {
        @NonNull
        private final ConversionService conversionService;
        @NonNull
        private final Object nullValue;
        @NonNull
        private final Iterable<Class<?>> wrapperTypes;

        protected AbstractWrapperTypeConverter(ConversionService conversionService, Object nullValue) {
            Assert.notNull((Object)conversionService, "ConversionService must not be null!");
            Assert.notNull(nullValue, "Null value must not be null!");
            this.conversionService = conversionService;
            this.nullValue = nullValue;
            this.wrapperTypes = Collections.singleton(nullValue.getClass());
        }

        @Override
        @Nonnull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Streamable.of(this.wrapperTypes).map(it -> new GenericConverter.ConvertiblePair(NullableWrapper.class, (Class<?>)it)).stream().collect(StreamUtils.toUnmodifiableSet());
        }

        @Override
        @Nullable
        public final Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return null;
            }
            NullableWrapper wrapper = (NullableWrapper)source;
            Object value = wrapper.getValue();
            return value == null ? this.nullValue : this.wrap(value);
        }

        protected abstract Object wrap(Object var1);

        @Generated
        public AbstractWrapperTypeConverter(@NonNull ConversionService conversionService, @NonNull Object nullValue, @NonNull Iterable<Class<?>> wrapperTypes) {
            if (conversionService == null) {
                throw new IllegalArgumentException("conversionService is marked non-null but is null");
            }
            if (nullValue == null) {
                throw new IllegalArgumentException("nullValue is marked non-null but is null");
            }
            if (wrapperTypes == null) {
                throw new IllegalArgumentException("wrapperTypes is marked non-null but is null");
            }
            this.conversionService = conversionService;
            this.nullValue = nullValue;
            this.wrapperTypes = wrapperTypes;
        }
    }

    public static interface ExecutionAdapter {
        public Object apply(ThrowingSupplier var1) throws Throwable;
    }

    public static interface ThrowingSupplier {
        public Object get() throws Throwable;
    }
}

