/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExtensionAwareEvaluationContextProvider;
import org.springframework.data.spel.spi.EvaluationContextExtension;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ExtensionAwareQueryMethodEvaluationContextProvider
implements QueryMethodEvaluationContextProvider {
    private final ExtensionAwareEvaluationContextProvider delegate;

    public ExtensionAwareQueryMethodEvaluationContextProvider(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, "ListableBeanFactory must not be null!");
        this.delegate = new ExtensionAwareEvaluationContextProvider(beanFactory);
    }

    public ExtensionAwareQueryMethodEvaluationContextProvider(List<? extends EvaluationContextExtension> extensions) {
        Assert.notNull(extensions, "EvaluationContextExtensions must not be null!");
        this.delegate = new ExtensionAwareEvaluationContextProvider(extensions);
    }

    @Override
    public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
        StandardEvaluationContext evaluationContext = this.delegate.getEvaluationContext(parameterValues);
        evaluationContext.setVariables(ExtensionAwareQueryMethodEvaluationContextProvider.collectVariables(parameters, parameterValues));
        return evaluationContext;
    }

    private static Map<String, Object> collectVariables(Parameters<?, ?> parameters, Object[] arguments) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        parameters.stream().filter(Parameter::isSpecialParameter).forEach(it -> variables.put(StringUtils.uncapitalize(it.getType().getSimpleName()), arguments[it.getIndex()]));
        parameters.stream().filter(Parameter::isNamedParameter).forEach(it -> variables.put(it.getName().orElseThrow(() -> new IllegalStateException("Should never occur!")), arguments[it.getIndex()]));
        return variables;
    }

    private static List<EvaluationContextExtension> getExtensionsFrom(ListableBeanFactory beanFactory) {
        Stream<EvaluationContextExtension> extensions = beanFactory.getBeansOfType(EvaluationContextExtension.class, true, false).values().stream();
        return extensions.collect(Collectors.toList());
    }

    static class DelegatingMethodInterceptor
    implements MethodInterceptor {
        private static final Map<Method, Method> METHOD_CACHE = new ConcurrentReferenceHashMap<Method, Method>();
        private final Object target;
        private final Map<String, Function<Object, Object>> directMappings = new HashMap<String, Function<Object, Object>>();

        public void registerResultMapping(String methodName, Function<Object, Object> mapping) {
            this.directMappings.put(methodName, mapping);
        }

        @Nullable
        public Object invoke(@Nullable MethodInvocation invocation) throws Throwable {
            Method targetMethod;
            Object result;
            if (invocation == null) {
                throw new IllegalArgumentException("Invocation must not be null!");
            }
            Method method = invocation.getMethod();
            Object object = result = method.equals(targetMethod = METHOD_CACHE.computeIfAbsent(method, it -> Optional.ofNullable(this.findTargetMethod((Method)it)).orElse((Method)it))) ? invocation.proceed() : ReflectionUtils.invokeMethod(targetMethod, this.target, invocation.getArguments());
            if (result == null) {
                return result;
            }
            Function<Object, Object> mapper = this.directMappings.get(targetMethod.getName());
            return mapper != null ? mapper.apply(result) : result;
        }

        @Nullable
        private Method findTargetMethod(Method method) {
            try {
                return this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Generated
        public DelegatingMethodInterceptor(Object target) {
            this.target = target;
        }
    }
}

