/*
 * Decompiled with CFR 0.152.
 */
package com.orange.lo.decoder.js.utils.validation;

import com.orange.lo.decoder.js.utils.DecoderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsScriptValidator {
    private static final Logger log = LoggerFactory.getLogger(JsScriptValidator.class);
    private static final String DECODE_FUNCTION_NAME = "decode";
    private static final String FUNCTION_PATTERN = "\\Wfunction\\W";
    private static final String MAIN_FUNCTION_PATTERN = "(decode\\s*=\\s*function\\s*\\(.*\\{)";
    private static final String FUNCTION_IN_OBJECT_PATTERN = "(.*\\s*:\\s*function\\s*\\(.*\\{)";
    private static final String NAMED_FUNCTION_PATTERN = "(\\Wfunction\\s*\\w*\\(.*\\{)";
    private static final String VARIABLE_PATTERN = "var\\s*(.*?);";
    private static final String PRINT_PATTERN = "print\\s*\\((.*?)\\);";
    private static final String CONSOLE_PATTERN = "console.log\\s*\\((.*?)\\);";
    private static final String WHILE_PATTERN = "while\\s*\\((.+)\\{";
    private static final String DO_WHILE_PATTERN = "while\\s*\\((.+);";
    private static final String FOR_PATTERN = "for\\s*\\((.+)\\{";
    private static final String COMMENT_PATTERN = "\\/\\/(.*)";
    private static final String THREAD_INTERRUPTION_CODE = " !(java.lang.Thread.interrupted()) && (";
    private static final String GLOBAL_VARIABLE_CONSTRAINT = "Global variables must not be used (but global constants can be used) : ";
    private static final String LOOP_INTERRUPTION_CONSTRAINT = "Loop should contain an interruption check : ";
    private static final String PRINT_CONSTRAINT = "Print function must be removed : ";
    private static final String FOR_LOOP_EMPTY_STATEMENT_CONSTRAINT = "For loop : 2nd statement should not be empty or a break should be present inside the loop : ";
    private static final String RECURSIVITY_CONSTRAINT = "Recursivity must not be used : ";
    private static final String COMMENT_STATEMENT_CONSTRAINT = "Please do not use // for comments. Use /**/ instead. ";
    @NonNull
    private String jsScriptPath;
    private String jsScript;
    private List<Integer> lineStartIndexes = new ArrayList<Integer>();
    private List<String> constraintChecks = new ArrayList<String>();

    public JsScriptValidator(String jsScriptPath) throws IOException {
        this.jsScriptPath = jsScriptPath;
        this.jsScript = DecoderUtils.loadJavascriptFile(jsScriptPath);
    }

    public List<String> validateJavascript() {
        this.buildLineStartIndexes();
        this.checkGlobalVariable();
        this.checkScript();
        this.checkRecursiveFunction();
        this.logConstraintCheckResults();
        return this.constraintChecks;
    }

    private void buildLineStartIndexes() {
        String pattStr = "\\n";
        Pattern p = Pattern.compile(pattStr);
        Matcher m3 = p.matcher(this.jsScript);
        while (m3.find()) {
            this.lineStartIndexes.add(m3.start());
        }
    }

    private void checkGlobalVariable() {
        int startIndexMainFunction = 0;
        Pattern p = Pattern.compile(FUNCTION_PATTERN);
        Matcher m3 = p.matcher(this.jsScript);
        if (m3.find()) {
            startIndexMainFunction = m3.start();
        }
        String globalVarBeforeMainFunction = this.jsScript.substring(0, startIndexMainFunction);
        p = Pattern.compile(VARIABLE_PATTERN);
        m3 = p.matcher(globalVarBeforeMainFunction);
        while (m3.find()) {
            String fullMatch = m3.group(0);
            this.addConstraintCheckToList(GLOBAL_VARIABLE_CONSTRAINT, m3.start(), fullMatch);
        }
    }

    private void checkScript() {
        Pattern p = Pattern.compile("print\\s*\\((.*?)\\);|console.log\\s*\\((.*?)\\);|while\\s*\\((.+)\\{|while\\s*\\((.+);|for\\s*\\((.+)\\{|\\/\\/(.*)");
        Matcher m3 = p.matcher(this.jsScript);
        while (m3.find()) {
            String fullMatch = m3.group(0);
            String printStatement = m3.group(1);
            String consoleStatement = m3.group(2);
            String whileStatement = m3.group(3);
            String doWhileStatement = m3.group(4);
            String forStatement = m3.group(5);
            String commentStatement = m3.group(6);
            if (printStatement != null || consoleStatement != null) {
                this.checkPrintLoop(fullMatch, m3);
                continue;
            }
            if (whileStatement != null) {
                this.checkWhileLoop(fullMatch, whileStatement, m3);
                continue;
            }
            if (doWhileStatement != null) {
                this.checkWhileLoop(fullMatch, doWhileStatement, m3);
                continue;
            }
            if (forStatement != null) {
                this.checkForLoop(fullMatch, forStatement, m3);
                continue;
            }
            if (commentStatement == null) continue;
            this.checkCommentWrongFormat(fullMatch, m3);
        }
    }

    private void logConstraintCheckResults() {
        for (String constaintCheck : this.constraintChecks) {
            log.debug("Constraint check : '{}'", (Object)constaintCheck);
        }
    }

    private Integer getLineNumber(int matchStart) {
        int i = 0;
        while (i < this.lineStartIndexes.size()) {
            Integer listStartIndex = this.lineStartIndexes.get(i);
            if (listStartIndex >= matchStart) {
                return i + 1;
            }
            ++i;
        }
        log.debug("Line not found for match '{}'", (Object)matchStart);
        return -1;
    }

    private void checkPrintLoop(String fullMatch, Matcher m3) {
        this.addConstraintCheckToList(PRINT_CONSTRAINT, m3.start(), fullMatch);
    }

    private void checkWhileLoop(String fullMatch, String loopStatement, Matcher m3) {
        String checkOutput = null;
        if (fullMatch != null && !fullMatch.contains(THREAD_INTERRUPTION_CODE)) {
            checkOutput = fullMatch.replace(loopStatement, THREAD_INTERRUPTION_CODE + loopStatement + " )");
            this.addConstraintCheckToList(LOOP_INTERRUPTION_CONSTRAINT, m3.start(), checkOutput);
        }
    }

    private void checkForLoop(String fullMatch, String loopStatement, Matcher m3) {
        String[] loopStatements = loopStatement.split(";");
        if (StringUtils.isBlank(loopStatements[1])) {
            this.addConstraintCheckToList(FOR_LOOP_EMPTY_STATEMENT_CONSTRAINT, m3.start(), fullMatch);
        }
    }

    private void checkCommentWrongFormat(String fullMatch, Matcher m3) {
        this.addConstraintCheckToList(COMMENT_STATEMENT_CONSTRAINT, m3.start(), fullMatch);
    }

    private void addConstraintCheckToList(String logText, int matchStartIndex, String checkOutput) {
        StringBuilder constraintCheckText = new StringBuilder();
        constraintCheckText.append("line ");
        constraintCheckText.append(this.getLineNumber(matchStartIndex));
        constraintCheckText.append(" : ");
        constraintCheckText.append(logText);
        constraintCheckText.append(checkOutput);
        this.constraintChecks.add(constraintCheckText.toString());
    }

    private void checkRecursiveFunction() {
        Pattern p = Pattern.compile("(decode\\s*=\\s*function\\s*\\(.*\\{)|(\\Wfunction\\s*\\w*\\(.*\\{)|(.*\\s*:\\s*function\\s*\\(.*\\{)");
        Matcher m3 = p.matcher(this.jsScript);
        while (m3.find()) {
            String functionName = this.extractFunctionName(m3);
            this.checkRecursiveCall(functionName, m3);
        }
    }

    private void checkRecursiveCall(String functionName, Matcher m3) {
        int nbOpenBraces = 1;
        int endFunctionMatch = m3.end();
        int i = endFunctionMatch + 1;
        while (i < this.jsScript.length()) {
            if (this.jsScript.charAt(i) == '{') {
                ++nbOpenBraces;
            } else if (this.jsScript.charAt(i) == '}') {
                --nbOpenBraces;
            }
            if (nbOpenBraces == 0) {
                Pattern p = Pattern.compile("\\s" + functionName + "\\W");
                Matcher matcherRecursiveCall = p.matcher(this.jsScript.subSequence(endFunctionMatch + 1, i));
                while (matcherRecursiveCall.find()) {
                    this.addConstraintCheckToList(RECURSIVITY_CONSTRAINT, endFunctionMatch + 1 + matcherRecursiveCall.start(), matcherRecursiveCall.group(0));
                }
                break;
            }
            ++i;
        }
    }

    private String extractFunctionName(Matcher m3) {
        if (m3.group(1) != null) {
            return DECODE_FUNCTION_NAME;
        }
        if (m3.group(2) != null) {
            String group2 = m3.group(2);
            if (group2.indexOf("(") > "function".length() + 1) {
                String functionName = group2.substring("function".length() + 1, group2.indexOf("("));
                return functionName;
            }
            return null;
        }
        if (m3.group(3) != null) {
            String group3 = m3.group(3);
            return group3.substring(0, group3.indexOf(":")).trim();
        }
        return null;
    }
}

