/*
 * Decompiled with CFR 0.152.
 */
package com.orange.lo.decoder.js.utils;

import java.beans.ConstructorProperties;

public class ProfilingScore {
    private String name;
    private Double compilation;
    private Double execution;
    private Double objectCount;
    private Double properties;

    public ProfilingScore normalize(ProfilingScore reference) {
        this.compilation = this.compilation / reference.getCompilation();
        this.execution = this.execution / reference.getExecution();
        this.objectCount = this.objectCount / reference.getObjectCount();
        this.properties = this.properties / reference.getProperties();
        return this;
    }

    public static ProfilingScoreBuilder builder() {
        return new ProfilingScoreBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Double getCompilation() {
        return this.compilation;
    }

    public Double getExecution() {
        return this.execution;
    }

    public Double getObjectCount() {
        return this.objectCount;
    }

    public Double getProperties() {
        return this.properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCompilation(Double compilation) {
        this.compilation = compilation;
    }

    public void setExecution(Double execution) {
        this.execution = execution;
    }

    public void setObjectCount(Double objectCount) {
        this.objectCount = objectCount;
    }

    public void setProperties(Double properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfilingScore)) {
            return false;
        }
        ProfilingScore other = (ProfilingScore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Double this$compilation = this.getCompilation();
        Double other$compilation = other.getCompilation();
        if (this$compilation == null ? other$compilation != null : !((Object)this$compilation).equals(other$compilation)) {
            return false;
        }
        Double this$execution = this.getExecution();
        Double other$execution = other.getExecution();
        if (this$execution == null ? other$execution != null : !((Object)this$execution).equals(other$execution)) {
            return false;
        }
        Double this$objectCount = this.getObjectCount();
        Double other$objectCount = other.getObjectCount();
        if (this$objectCount == null ? other$objectCount != null : !((Object)this$objectCount).equals(other$objectCount)) {
            return false;
        }
        Double this$properties = this.getProperties();
        Double other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfilingScore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Double $compilation = this.getCompilation();
        result = result * 59 + ($compilation == null ? 43 : ((Object)$compilation).hashCode());
        Double $execution = this.getExecution();
        result = result * 59 + ($execution == null ? 43 : ((Object)$execution).hashCode());
        Double $objectCount = this.getObjectCount();
        result = result * 59 + ($objectCount == null ? 43 : ((Object)$objectCount).hashCode());
        Double $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ProfilingScore(name=" + this.getName() + ", compilation=" + this.getCompilation() + ", execution=" + this.getExecution() + ", objectCount=" + this.getObjectCount() + ", properties=" + this.getProperties() + ")";
    }

    public ProfilingScore() {
    }

    @ConstructorProperties(value={"name", "compilation", "execution", "objectCount", "properties"})
    public ProfilingScore(String name, Double compilation, Double execution, Double objectCount, Double properties) {
        this.name = name;
        this.compilation = compilation;
        this.execution = execution;
        this.objectCount = objectCount;
        this.properties = properties;
    }

    public static class ProfilingScoreBuilder {
        private String name;
        private Double compilation;
        private Double execution;
        private Double objectCount;
        private Double properties;

        ProfilingScoreBuilder() {
        }

        public ProfilingScoreBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProfilingScoreBuilder compilation(Double compilation) {
            this.compilation = compilation;
            return this;
        }

        public ProfilingScoreBuilder execution(Double execution) {
            this.execution = execution;
            return this;
        }

        public ProfilingScoreBuilder objectCount(Double objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public ProfilingScoreBuilder properties(Double properties) {
            this.properties = properties;
            return this;
        }

        public ProfilingScore build() {
            return new ProfilingScore(this.name, this.compilation, this.execution, this.objectCount, this.properties);
        }

        public String toString() {
            return "ProfilingScore.ProfilingScoreBuilder(name=" + this.name + ", compilation=" + this.compilation + ", execution=" + this.execution + ", objectCount=" + this.objectCount + ", properties=" + this.properties + ")";
        }
    }
}

