/*
 * Decompiled with CFR 0.152.
 */
package com.orange.lo.decoder.js.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.exception.js.JsDecoderBuildingException;
import com.orange.decoder.js.JsDecoderFactory;
import com.orange.decoder.js.simple.JsDecoder;
import com.orange.decoder.js.split.JsSplitDecoder;
import com.orange.decoder.split.SplitDecoderResult;
import com.orange.iaes.datazone.resources.ResourcesListing;
import com.orange.lo.decoder.js.exception.JsDecodingException;
import com.orange.lo.decoder.js.utils.StringUtils;
import com.orange.lo.decoder.js.utils.validation.JsScriptValidator;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderUtils {
    private static final Logger log = LoggerFactory.getLogger(DecoderUtils.class);
    protected static final ResourcesListing JS_LIB_RESOURCES = new ResourcesListing("javascript/", ".js");
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private DecoderUtils() {
    }

    public static String loadJavascriptFile(String scriptPath) throws IOException {
        log.debug("loading script : '{}'", (Object)scriptPath);
        String script = JS_LIB_RESOURCES.getRawResourceContent(scriptPath);
        log.debug("Javascript to be provided to Orange administrator : {}", (Object)StringUtils.formatDecodingScript(script));
        return script;
    }

    public static List<String> validateJavascript(String jsScriptPath) throws JsDecodingException {
        JsScriptValidator jsScriptValidator;
        try {
            jsScriptValidator = new JsScriptValidator(jsScriptPath);
        }
        catch (IOException e) {
            log.warn("Error while decoding : '{}'", (Object)e.getMessage());
            throw new JsDecodingException(e.getMessage());
        }
        return jsScriptValidator.validateJavascript();
    }

    public static String formatAndDecode(String scriptPathName, String input, String inputDataMessage) throws JsDecodingException {
        JsPayloadDescriptionTestRequest jsPayloadDescriptionTestRequest;
        try {
            jsPayloadDescriptionTestRequest = DecoderUtils.loadAndFormatScript(scriptPathName);
        }
        catch (IOException e) {
            log.warn("I/O Error while decoding : '{}'", (Object)e.getMessage());
            throw new JsDecodingException(e.getMessage());
        }
        return DecoderUtils.decode(jsPayloadDescriptionTestRequest.getDecodingFunction(), input, inputDataMessage);
    }

    public static String decode(String jsScript, String input, String inputDataMessage) throws JsDecodingException {
        try {
            JsDecoder decoder = JsDecoderFactory.buildDefaultDecoder(jsScript);
            return decoder.toJson(input, new Gson().fromJson(inputDataMessage, Object.class));
        }
        catch (DecodingException | JsDecoderBuildingException e) {
            log.warn("Error while decoding : '{}'", (Object)e.getMessage());
            throw new JsDecodingException(e.getMessage());
        }
    }

    public static SplitDecoderResult formatAndDecodeSplit(String scriptPathName, String inputDataMessage) throws JsDecodingException {
        try {
            JsPayloadDescriptionTestRequest jsPayloadDescriptionTestRequest = DecoderUtils.loadAndFormatScript(scriptPathName);
            return DecoderUtils.decodeSplit(jsPayloadDescriptionTestRequest.getDecodingFunction(), inputDataMessage);
        }
        catch (DecodingException | JsDecoderBuildingException | IOException e) {
            log.warn("Error while decoding : '{}'", (Object)e.getMessage());
            throw new JsDecodingException(e.getMessage());
        }
    }

    public static SplitDecoderResult decodeSplit(String jsScript, String inputDataMessage) throws JsDecoderBuildingException, DecodingException {
        JsSplitDecoder decoder = JsDecoderFactory.buildSplitDecoder(jsScript);
        return decoder.decode(new Gson().fromJson(inputDataMessage, Object.class));
    }

    private static JsPayloadDescriptionTestRequest loadAndFormatScript(String scriptPathName) throws IOException {
        String script = DecoderUtils.loadJavascriptFile(scriptPathName);
        String functionIn = "{\"decodingFunction\":\"" + StringUtils.formatDecodingScript(script) + "\"}";
        return new Gson().fromJson(functionIn, JsPayloadDescriptionTestRequest.class);
    }

    public static void log(String input, JsonObject decodedJsonObject) {
        log.debug("input: '{}'", (Object)input);
        log.debug(GSON.toJson(decodedJsonObject));
    }

    public class JsPayloadDescriptionTestRequest {
        private String decodingFunction;

        public JsPayloadDescriptionTestRequest(String decodingFunction) {
            this.decodingFunction = decodingFunction;
        }

        public String getDecodingFunction() {
            return this.decodingFunction;
        }

        public void setDecodingFunction(String decodingFunction) {
            this.decodingFunction = decodingFunction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsPayloadDescriptionTestRequest)) {
                return false;
            }
            JsPayloadDescriptionTestRequest other = (JsPayloadDescriptionTestRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$decodingFunction = this.getDecodingFunction();
            String other$decodingFunction = other.getDecodingFunction();
            return !(this$decodingFunction == null ? other$decodingFunction != null : !this$decodingFunction.equals(other$decodingFunction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JsPayloadDescriptionTestRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $decodingFunction = this.getDecodingFunction();
            result = result * 59 + ($decodingFunction == null ? 43 : $decodingFunction.hashCode());
            return result;
        }

        public String toString() {
            return "DecoderUtils.JsPayloadDescriptionTestRequest(decodingFunction=" + this.getDecodingFunction() + ")";
        }

        public JsPayloadDescriptionTestRequest() {
        }
    }
}

