/*
 * Decompiled with CFR 0.152.
 */
package com.orange.lo.decoder.js.utils;

import com.google.gson.Gson;
import com.orange.decoder.DataMessageDecoder;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.js.JsDecoderFactory;
import com.orange.decoder.js.metrics.JsDecodingMetrics;
import com.orange.decoder.js.split.JsSplitDecoder;
import com.orange.decoder.simple.SimpleDecoder;
import com.orange.iaes.datazone.resources.ResourcesListing;
import com.orange.lo.decoder.js.utils.DecoderUtils;
import com.orange.lo.decoder.js.utils.ProfilingScore;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderProfiler {
    private static final Logger log = LoggerFactory.getLogger(DecoderProfiler.class);
    private static final ResourcesListing INPUT_RESOURCES = new ResourcesListing("javascript/", ".input");
    private static final ResourcesListing MESSAGE_RESOURCES = new ResourcesListing("javascript/", ".message");
    private static final SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
    private static final JsDecodingMetrics decodingMetrics = new JsDecodingMetrics(meterRegistry, 8, 0, 0);
    private static final int PROFILE_LOOPS = 200;
    private static final int WARMUP_LOOPS = 50;
    private static ProfilingScore scoreReference = null;
    private static final String REFERENCE_SCRIPT = "profiler/reference";

    public static SimpleDecoder buildProfiledDefaultDecoder(String jsScript) {
        return JsDecoderFactory.buildDefaultDecoder(jsScript, decodingMetrics);
    }

    public static JsSplitDecoder buildProfiledSplitDecoder(String jsScript) {
        return JsDecoderFactory.buildSplitDecoder(jsScript, decodingMetrics);
    }

    public static ProfilingScore profileSimpleScript(String name, String jsScript, String input, String inputDataMessage) {
        DecoderProfiler.calibrate();
        IntStream.of(50, 200).forEach(loops -> {
            meterRegistry.clear();
            DecoderProfiler.profileSimpleCompilation(jsScript, loops);
            DecoderProfiler.profileSimpleDecode(jsScript, loops, input, inputDataMessage);
        });
        return DecoderProfiler.getScore(name).normalize(scoreReference);
    }

    public static ProfilingScore profileSimple(String scriptPath, String input, String inputDataMessage) {
        return DecoderProfiler.profileSimpleScript(scriptPath, DecoderProfiler.loadScript(scriptPath), input, inputDataMessage);
    }

    public static ProfilingScore profileSplit(String scriptPath, String input, String inputDataMessage) {
        DecoderProfiler.calibrate();
        String jsScript = DecoderProfiler.loadScript(scriptPath);
        IntStream.of(50, 200).forEach(loops -> {
            meterRegistry.clear();
            DecoderProfiler.profileSplitCompilation(jsScript, loops);
            DecoderProfiler.profileSplitDecode(jsScript, loops, input, inputDataMessage);
        });
        return DecoderProfiler.getScore(scriptPath).normalize(scoreReference);
    }

    private static String loadScript(String path) {
        try {
            return DecoderUtils.loadJavascriptFile(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void calibrate() {
        System.gc();
        if (scoreReference == null) {
            log.info("Profiler calibration started");
            String jsScript = DecoderProfiler.loadScript(REFERENCE_SCRIPT);
            String input = INPUT_RESOURCES.getRawResourceContent(REFERENCE_SCRIPT);
            String message = MESSAGE_RESOURCES.getRawResourceContent(REFERENCE_SCRIPT);
            IntStream.of(50, 200).forEach(loops -> {
                meterRegistry.clear();
                DecoderProfiler.profileSimpleCompilation(jsScript, loops);
                DecoderProfiler.profileSimpleDecode(jsScript, loops, input, message);
            });
            scoreReference = DecoderProfiler.getScore("reference");
            log.info("Profiler calibration finished");
        }
        meterRegistry.clear();
    }

    private static void profileSimpleCompilation(String jsScript, int loops) {
        DecoderProfiler.profileCompilation(jsScript, loops, DecoderProfiler::buildProfiledDefaultDecoder);
    }

    private static void profileSplitCompilation(String jsScript, int loops) {
        DecoderProfiler.profileCompilation(jsScript, loops, DecoderProfiler::buildProfiledSplitDecoder);
    }

    private static void profileCompilation(String jsScript, int loops, Function<String, DataMessageDecoder> compile) {
        int i = 0;
        while (i < loops) {
            meterRegistry.timer("compile", new String[0]).record(() -> {
                DataMessageDecoder decoder = (DataMessageDecoder)compile.apply(jsScript);
                Object var2_2 = null;
            });
            ++i;
        }
    }

    private static void profileSimpleDecode(String jsScript, int loops, String input, String inputDataMessage) {
        DecoderProfiler.profileDecode(jsScript, loops, input, inputDataMessage, DecoderProfiler::buildProfiledDefaultDecoder);
    }

    private static void profileSplitDecode(String jsScript, int loops, String input, String inputDataMessage) {
        DecoderProfiler.profileDecode(jsScript, loops, input, inputDataMessage, DecoderProfiler::buildProfiledSplitDecoder);
    }

    private static void profileDecode(String jsScript, int loops, String input, String inputDataMessage, Function<String, DataMessageDecoder> compile) {
        DataMessageDecoder decoder = compile.apply(jsScript);
        int i = 0;
        while (i < loops) {
            meterRegistry.timer("decode", new String[0]).record(() -> {
                try {
                    decoder.decode(input, new Gson().fromJson(inputDataMessage, Object.class));
                }
                catch (DecodingException e) {
                    log.warn("Error while decoding : '{}'", (Object)e.getMessage());
                }
            });
            ++i;
        }
    }

    private static ProfilingScore getScore(String name) {
        double objectCount = DecoderProfiler.getCounterValue("nashorn.script.object.count");
        double properties = DecoderProfiler.getCounterValue("nashorn.script.object.properties.count");
        double compileTime = DecoderProfiler.getTimerMeanTime("compile");
        double decodeTime = DecoderProfiler.getTimerMeanTime("decode");
        return ProfilingScore.builder().name(name).compilation(Math.max(compileTime, 1.0)).execution(Math.max(decodeTime, 1.0)).objectCount(Math.max(objectCount, 1.0)).properties(Math.max(properties, 1.0)).build();
    }

    private static double getTimerMeanTime(String name) {
        return DecoderProfiler.getTimerTime(name, t -> t.mean(TimeUnit.NANOSECONDS));
    }

    private static double getTimerTime(String name, Function<Timer, Double> extract) {
        return meterRegistry.get(name).timers().stream().findFirst().map(extract).orElse(0.0);
    }

    private static double getCounterValue(String name) {
        return meterRegistry.get(name).counters().stream().findFirst().map(Counter::count).orElse(0.0);
    }
}

