/*
 * Decompiled with CFR 0.152.
 */
package com.orange.iaes.datazone.resources;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourcesListing {
    private final String resourcesDirectory;
    private final String resourcesExtension;
    private List<String> resourcesNames = new ArrayList<String>();

    @PostConstruct
    public void buildList() throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
        Resource[] resourceArray = resources = resolver.getResources("classpath*:/" + this.resourcesDirectory + "*" + this.resourcesExtension);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            this.resourcesNames.add(resource.getFilename().replace(this.resourcesExtension, ""));
            ++n2;
        }
    }

    public String getRawResourceContent(String resourceName) throws IOException {
        return IOUtils.toString(ResourcesListing.class.getClassLoader().getResource(String.valueOf(this.resourcesDirectory) + resourceName + this.resourcesExtension));
    }

    public String getResourceFullPath(String resourceName) throws IOException {
        return String.valueOf(this.resourcesDirectory) + resourceName + this.resourcesExtension;
    }

    public String getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public String getResourcesExtension() {
        return this.resourcesExtension;
    }

    public List<String> getResourcesNames() {
        return this.resourcesNames;
    }

    public void setResourcesNames(List<String> resourcesNames) {
        this.resourcesNames = resourcesNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcesListing)) {
            return false;
        }
        ResourcesListing other = (ResourcesListing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourcesDirectory = this.getResourcesDirectory();
        String other$resourcesDirectory = other.getResourcesDirectory();
        if (this$resourcesDirectory == null ? other$resourcesDirectory != null : !this$resourcesDirectory.equals(other$resourcesDirectory)) {
            return false;
        }
        String this$resourcesExtension = this.getResourcesExtension();
        String other$resourcesExtension = other.getResourcesExtension();
        if (this$resourcesExtension == null ? other$resourcesExtension != null : !this$resourcesExtension.equals(other$resourcesExtension)) {
            return false;
        }
        List<String> this$resourcesNames = this.getResourcesNames();
        List<String> other$resourcesNames = other.getResourcesNames();
        return !(this$resourcesNames == null ? other$resourcesNames != null : !((Object)this$resourcesNames).equals(other$resourcesNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcesListing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourcesDirectory = this.getResourcesDirectory();
        result = result * 59 + ($resourcesDirectory == null ? 43 : $resourcesDirectory.hashCode());
        String $resourcesExtension = this.getResourcesExtension();
        result = result * 59 + ($resourcesExtension == null ? 43 : $resourcesExtension.hashCode());
        List<String> $resourcesNames = this.getResourcesNames();
        result = result * 59 + ($resourcesNames == null ? 43 : ((Object)$resourcesNames).hashCode());
        return result;
    }

    public String toString() {
        return "ResourcesListing(resourcesDirectory=" + this.getResourcesDirectory() + ", resourcesExtension=" + this.getResourcesExtension() + ", resourcesNames=" + this.getResourcesNames() + ")";
    }

    @ConstructorProperties(value={"resourcesDirectory", "resourcesExtension"})
    public ResourcesListing(String resourcesDirectory, String resourcesExtension) {
        this.resourcesDirectory = resourcesDirectory;
        this.resourcesExtension = resourcesExtension;
    }
}

