/*
 * Decompiled with CFR 0.152.
 */
package com.orange.iaes.commons.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orange.iaes.commons.json.JsonEncodingException;
import java.io.IOException;

public class JsonUtils {
    public static final ObjectMapper MAPPER = JsonUtils.initializeMapper();
    public static final ObjectMapper MAPPER_IGNORE_UNKNOWN_PROPERTIES = JsonUtils.mapperIgnoreUnknownProperties();
    public static final ObjectMapper MAPPER_SERIALIZING_NULLS = JsonUtils.mapperSerializingNulls();
    public static final Gson GSON_SERIALIZING_NULLS = new GsonBuilder().serializeNulls().create();

    public static ObjectMapper initializeMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new JodaModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        return mapper;
    }

    private static ObjectMapper mapperIgnoreUnknownProperties() {
        return JsonUtils.initializeMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private static ObjectMapper mapperSerializingNulls() {
        return JsonUtils.initializeMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).enable(SerializationFeature.WRITE_NULL_MAP_VALUES);
    }

    public static String encode(Object o) throws JsonEncodingException {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonEncodingException(String.format("failure while encoding '%s' : %s", o, e.getMessage()), e);
        }
    }

    public static <T> T decode(Object s2, Class<T> classT) throws JsonEncodingException {
        return JsonUtils.decode(JsonUtils.encode(s2), classT);
    }

    public static <T> T decode(String s2, Class<T> classT) throws JsonEncodingException {
        try {
            return MAPPER.readValue(s2, classT);
        }
        catch (IOException e) {
            throw new JsonEncodingException(String.format("failure while decoding POJO into '%s' : %s", classT.getName(), e.getMessage()), e);
        }
    }

    public static <T> T decode(String s2, TypeReference<T> typeReference) throws JsonEncodingException {
        try {
            return MAPPER.readValue(s2, typeReference);
        }
        catch (IOException e) {
            throw new JsonEncodingException(String.format("failure while decoding POJO into TypeRef '%s' : %s", typeReference.getType().getTypeName(), e.getMessage()), e);
        }
    }

    public static <T> T decode(byte[] s2, Class<T> classT) throws JsonEncodingException {
        try {
            return MAPPER.readValue(s2, classT);
        }
        catch (IOException e) {
            throw new JsonEncodingException(String.format("failure while decoding POJO into '%s' : %s", classT.getName(), e.getMessage()), e);
        }
    }

    public static <T> T decodeIgnoreUnknownProperties(Object o, Class<T> classT) throws JsonEncodingException {
        return JsonUtils.decodeIgnoreUnknownProperties(JsonUtils.encode(o), classT);
    }

    public static <T> T decodeIgnoreUnknownProperties(String s2, Class<T> classT) throws JsonEncodingException {
        try {
            return MAPPER_IGNORE_UNKNOWN_PROPERTIES.readValue(s2, classT);
        }
        catch (IOException e) {
            throw new JsonEncodingException(String.format("failure while decoding '%s' into '%s' : %s", s2, classT.getName(), e.getMessage()), e);
        }
    }

    public static <T> T decodeIgnoreUnknownProperties(byte[] s2, Class<T> classT) throws JsonEncodingException {
        try {
            return MAPPER_IGNORE_UNKNOWN_PROPERTIES.readValue(s2, classT);
        }
        catch (IOException e) {
            throw new JsonEncodingException(String.format("failure while decoding POJO into '%s' : %s", classT.getName(), e.getMessage()), e);
        }
    }

    public static boolean isJsonObject(Object o) {
        try {
            JsonNode json = MAPPER.convertValue(o, JsonNode.class);
            return json.isObject();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isStringJsonObject(String jsonString) {
        try {
            JsonNode json = MAPPER.readValue(jsonString, JsonNode.class);
            return json.isObject();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBytesJsonObject(byte[] bytes) {
        try {
            JsonNode json = JsonUtils.decode(bytes, JsonNode.class);
            return json.isObject();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isStringJsonBoolean(String jsonString) {
        try {
            JsonNode json = MAPPER.readValue(jsonString, JsonNode.class);
            return json.isBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }
}

