/*
 * Decompiled with CFR 0.152.
 */
package com.orange.iaes.commons;

import com.orange.iaes.commons.utils.RunnableWithException;
import com.orange.iaes.commons.utils.SupplierWithException;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class LangUtils {
    private LangUtils() {
    }

    public static <T> T nullCoalescing(T object, T defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static String nullCoalescingToString(Object object) {
        return LangUtils.nullCoalescingToString(object, null);
    }

    public static String nullCoalescingToString(Object object, String defaultValue) {
        return object == null ? defaultValue : object.toString();
    }

    public static String emptyCoalescing(String test, String defaultValue) {
        return StringUtils.isEmpty(test) ? defaultValue : test;
    }

    public static String emptyCoalescing(String test) {
        return LangUtils.emptyCoalescing(test, null);
    }

    public static <R> R nullSafe(Supplier<R> supply) {
        return LangUtils.nullSafe(supply, null);
    }

    public static <R> R nullSafe(Supplier<R> supply, R defaultResult) {
        try {
            return supply.get();
        }
        catch (NullPointerException | NoSuchElementException e) {
            return defaultResult;
        }
    }

    public static void exceptionSafe(RunnableWithException runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <R> R exceptionSafe(SupplierWithException<R> supply, R defaultResult) {
        try {
            return supply.get();
        }
        catch (Exception e) {
            return defaultResult;
        }
    }

    public static <R> R exceptionSafe(SupplierWithException<R> supply) {
        return LangUtils.exceptionSafe(supply, null);
    }
}

