/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.simple;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.orange.decoder.DataMessageDecoder;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.simple.SimpleDecoderResult;
import com.orange.iaes.commons.json.JsonEncodingException;
import com.orange.iaes.commons.json.JsonUtils;
import com.orange.iaes.logging.ErrorCode;
import com.orange.iaes.utils.MarkerUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.ValidationResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleDecoder
implements DataMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(SimpleDecoder.class);
    private static final HashMap<String, Object> TEMPLATING_FUNCTION_MAP = new HashMap();
    private String outputTemplate = null;
    private Boolean mathEvalEnabled = true;
    protected static final Gson gson = new GsonBuilder().create();
    private final MustacheFactory mf = new DefaultMustacheFactory();

    public JsonObject toJsonObject(String encodedValue, Object wholeDataMessage) throws DecodingException {
        return this.decode(encodedValue, wholeDataMessage).getResult();
    }

    public abstract SimpleDecoderResult decode(String var1, Object var2) throws DecodingException;

    public final String toJson(String encodedValue, Object wholeDataMessage) throws DecodingException {
        return gson.toJson(this.toJsonObject(encodedValue, wholeDataMessage));
    }

    protected SimpleDecoderResult applyOutputTemplate(JsonObject decoded) {
        if (StringUtils.isEmpty(this.outputTemplate)) {
            return SimpleDecoderResult.builder().result(decoded).templatingOK(null).build();
        }
        JsonObject templateResult = this.applyMustach(this.outputTemplate, decoded);
        if (templateResult == null) {
            return SimpleDecoderResult.builder().result(decoded).templatingOK(false).build();
        }
        return SimpleDecoderResult.builder().result(templateResult).templatingOK(true).build();
    }

    private JsonObject applyMustach(String template, JsonObject decoded) {
        HashMap<String, Object> decodedHashMap;
        try {
            decodedHashMap = this.jsonObjectToHashMap(decoded);
        }
        catch (JsonEncodingException e) {
            log.warn(MarkerUtils.marker((ErrorCode)ErrorCode.ILLEGAL_STATE_ERROR), "Failure when converting JSonObject '{}' in HashMap : {} ", (Object)decoded, (Object)e.getMessage());
            return null;
        }
        if (!this.checkSafeDecodedValuesForTemplating(decodedHashMap)) {
            log.debug("Found potential security issues, do not apply Mustache");
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            Mustache mustache = this.mf.compile(new StringReader(template), null);
            ArrayList<Object> scopesList = new ArrayList<Object>(TEMPLATING_FUNCTION_MAP.values());
            scopesList.add(decodedHashMap);
            mustache.execute((Writer)writer, scopesList.toArray());
        }
        catch (Exception e) {
            log.debug("cannot apply mustache : {} ", (Object)e.getMessage());
            return null;
        }
        String result = Boolean.TRUE.equals(this.mathEvalEnabled) ? this.mathEval(((Object)writer).toString()) : ((Object)writer).toString();
        try {
            return JsonParser.parseString(result).getAsJsonObject();
        }
        catch (Exception e) {
            log.debug("Templating result is not a valid Json : {} ", (Object)writer);
            return null;
        }
    }

    private boolean checkSafeDecodedValuesForTemplating(HashMap<String, Object> decodedHashMap) {
        return decodedHashMap.values().stream().noneMatch(this::isNotSafe);
    }

    private boolean isNotSafe(Object value) {
        if (value instanceof String) {
            return ((String)value).contains("{") || ((String)value).contains("(");
        }
        return false;
    }

    private String mathEval(String json) {
        try {
            HashMap<String, Object> map = JsonUtils.decode(json, new TypeReference<HashMap<String, Object>>(){});
            map.replaceAll(this::compute);
            return JsonUtils.encode(map);
        }
        catch (JsonEncodingException e) {
            log.debug("cannot do math evaluation of input string, not a Json Object : {}", (Object)json);
            return json;
        }
    }

    private Object compute(String k, Object v) {
        if (v instanceof String) {
            try {
                return SimpleDecoder.math((String)v);
            }
            catch (Exception e) {
                log.trace("cannot evaluate : {} ", v);
                return v;
            }
        }
        if (v instanceof HashMap) {
            ((HashMap)v).replaceAll(this::compute);
            return v;
        }
        if (v instanceof List) {
            return ((List)v).stream().map(x -> this.compute(null, x)).collect(Collectors.toList());
        }
        return v;
    }

    private static Object math(String v) {
        Expression exp = new ExpressionBuilder(v).build();
        ValidationResult validate = exp.validate();
        if (!validate.isValid()) {
            log.trace("Not a valid math expression :{} ", (Object)v);
            return v;
        }
        return exp.evaluate();
    }

    private static Object safeMath(String v) {
        try {
            return SimpleDecoder.math(v);
        }
        catch (Exception e) {
            return v;
        }
    }

    private static String safeUpperCase(String s2) {
        if (StringUtils.isEmpty(s2)) {
            return "";
        }
        return s2.toUpperCase(Locale.ROOT);
    }

    private static String safeLowerCase(String s2) {
        if (StringUtils.isEmpty(s2)) {
            return "";
        }
        return s2.toLowerCase(Locale.ROOT);
    }

    HashMap<String, Object> jsonObjectToHashMap(JsonObject json) throws JsonEncodingException {
        return JsonUtils.decode(gson.toJson(json), new TypeReference<HashMap<String, Object>>(){});
    }

    public String getOutputTemplate() {
        return this.outputTemplate;
    }

    public Boolean getMathEvalEnabled() {
        return this.mathEvalEnabled;
    }

    public MustacheFactory getMf() {
        return this.mf;
    }

    public void setOutputTemplate(String outputTemplate) {
        this.outputTemplate = outputTemplate;
    }

    public void setMathEvalEnabled(Boolean mathEvalEnabled) {
        this.mathEvalEnabled = mathEvalEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleDecoder)) {
            return false;
        }
        SimpleDecoder other = (SimpleDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$mathEvalEnabled = this.getMathEvalEnabled();
        Boolean other$mathEvalEnabled = other.getMathEvalEnabled();
        if (this$mathEvalEnabled == null ? other$mathEvalEnabled != null : !((Object)this$mathEvalEnabled).equals(other$mathEvalEnabled)) {
            return false;
        }
        String this$outputTemplate = this.getOutputTemplate();
        String other$outputTemplate = other.getOutputTemplate();
        if (this$outputTemplate == null ? other$outputTemplate != null : !this$outputTemplate.equals(other$outputTemplate)) {
            return false;
        }
        MustacheFactory this$mf = this.getMf();
        MustacheFactory other$mf = other.getMf();
        return !(this$mf == null ? other$mf != null : !this$mf.equals(other$mf));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $mathEvalEnabled = this.getMathEvalEnabled();
        result = result * 59 + ($mathEvalEnabled == null ? 43 : ((Object)$mathEvalEnabled).hashCode());
        String $outputTemplate = this.getOutputTemplate();
        result = result * 59 + ($outputTemplate == null ? 43 : $outputTemplate.hashCode());
        MustacheFactory $mf = this.getMf();
        result = result * 59 + ($mf == null ? 43 : $mf.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleDecoder(outputTemplate=" + this.getOutputTemplate() + ", mathEvalEnabled=" + this.getMathEvalEnabled() + ", mf=" + this.getMf() + ")";
    }

    public SimpleDecoder(String outputTemplate, Boolean mathEvalEnabled) {
        this.outputTemplate = outputTemplate;
        this.mathEvalEnabled = mathEvalEnabled;
    }

    public SimpleDecoder() {
    }

    static {
        TEMPLATING_FUNCTION_MAP.put("math", new Object(){

            Function<String, String> math() {
                return input -> SimpleDecoder.safeMath(input).toString();
            }
        });
        final Function<String, String> toUpperCase = SimpleDecoder::safeUpperCase;
        TEMPLATING_FUNCTION_MAP.put("toUpperCase", new Object(){

            public Function<String, String> toUpperCase() {
                return toUpperCase;
            }
        });
        TEMPLATING_FUNCTION_MAP.put("toLowerCase", new Object(){

            Function<String, String> toLowerCase() {
                return x$0 -> SimpleDecoder.safeLowerCase(x$0);
            }
        });
    }
}

