/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.split;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.orange.decoder.DataMessageDecoder;
import com.orange.decoder.exception.js.JsDecodingException;
import com.orange.decoder.js.JsDecodingHelper;
import com.orange.decoder.js.JsDecodingTask;
import com.orange.decoder.js.JsDecodingTaskRunner;
import com.orange.decoder.js.metrics.JsDecodingMetrics;
import com.orange.decoder.split.SplitDecoderResult;
import com.orange.iaes.commons.json.JsonEncodingException;
import com.orange.iaes.commons.json.JsonUtils;
import javax.script.CompiledScript;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsSplitDecoder
implements DataMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(JsSplitDecoder.class);
    private static final String JS_SPLIT_ENTRYPOINT_FUNCTION = "decodeAndSplit";
    private static final int JS_SPLIT_MAX_NUMBER_OF_ITEMS = 1000;
    private final NashornScriptEngine scriptEngine;
    private final CompiledScript script;
    private final JsDecodingMetrics jsDecodingMetrics;

    public SplitDecoderResult decode(String encodedValue, Object encodedDataMessage) throws JsDecodingException {
        return this.decode(encodedDataMessage);
    }

    public SplitDecoderResult decode(Object wholeDataMessage) throws JsDecodingException {
        SplitDecoderResult result;
        try {
            String wholeDataMessageAsJsonString = JsonUtils.MAPPER.writeValueAsString(wholeDataMessage);
            result = JsonUtils.decode(this.jsConvert(wholeDataMessageAsJsonString, JsDecodingHelper.getEncoding(wholeDataMessage)), SplitDecoderResult.class);
        }
        catch (JsonProcessingException e) {
            throw new JsDecodingException("Unable to jsonify data message '" + wholeDataMessage + "' : " + e.getMessage());
        }
        catch (JsonEncodingException e) {
            throw new JsDecodingException("The decoding result has a wrong format: " + e.getMessage());
        }
        if (CollectionUtils.isEmpty(result)) {
            log.debug("The result of JS split decoding cannot be an empty list");
            throw new JsDecodingException("The result of JS split decoding cannot be an empty list");
        }
        if (result.size() > 1000) {
            log.debug(String.format("The result of JS split decoding cannot have more than '%s' items. Number of items : '%s'", 1000, result.size()));
            throw new JsDecodingException(String.format("The result of JS split decoding cannot have more than '%s' items. Number of items : '%s'", 1000, result.size()));
        }
        return result;
    }

    private String jsConvert(String wholeDataMessage, String encoding) throws JsDecodingException {
        String parseResult = this.runDecode(wholeDataMessage, encoding);
        if (parseResult == null) {
            log.debug("Error during JS decoding execution : null result returned ");
            throw new JsDecodingException("Error during JS decoding execution : null result returned ");
        }
        return parseResult;
    }

    private String runDecode(String encodedDataMessage, String encoding) throws JsDecodingException {
        JsDecodingTask task = new JsDecodingTask(JS_SPLIT_ENTRYPOINT_FUNCTION, this.scriptEngine, this.jsDecodingMetrics, encoding, this.script, encodedDataMessage);
        return JsDecodingTaskRunner.runJSDecodingTask(task);
    }

    public JsSplitDecoder(NashornScriptEngine scriptEngine, CompiledScript script, JsDecodingMetrics jsDecodingMetrics) {
        this.scriptEngine = scriptEngine;
        this.script = script;
        this.jsDecodingMetrics = jsDecodingMetrics;
    }
}

