/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.simple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.exception.js.JsDecodingException;
import com.orange.decoder.js.JsDecodingHelper;
import com.orange.decoder.js.JsDecodingTask;
import com.orange.decoder.js.JsDecodingTaskRunner;
import com.orange.decoder.js.metrics.JsDecodingMetrics;
import com.orange.decoder.simple.SimpleDecoder;
import com.orange.decoder.simple.SimpleDecoderResult;
import com.orange.iaes.commons.LangUtils;
import com.orange.iaes.commons.json.JsonUtils;
import javax.script.CompiledScript;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDecoder
extends SimpleDecoder {
    private static final Logger log = LoggerFactory.getLogger(JsDecoder.class);
    private static final String JS_ENTRYPOINT_FUNCTION = "decode";
    private final NashornScriptEngine scriptEngine;
    private final CompiledScript script;
    private final JsDecodingMetrics jsDecodingMetrics;

    public JsDecoder(NashornScriptEngine scriptEngine, String template, Boolean mathEvalEnabled, CompiledScript script, JsDecodingMetrics jsDecodingMetrics) {
        super(template, mathEvalEnabled);
        this.scriptEngine = scriptEngine;
        this.script = script;
        this.jsDecodingMetrics = jsDecodingMetrics;
    }

    @Override
    public SimpleDecoderResult decode(String encodedValue, Object wholeDataMessage) throws DecodingException {
        String wholeDataMessageAsJsonString;
        try {
            wholeDataMessageAsJsonString = JsonUtils.MAPPER.writeValueAsString(wholeDataMessage);
        }
        catch (JsonProcessingException e) {
            throw new JsDecodingException("Unable to jsonify data message '" + wholeDataMessage + "' : " + e.getMessage());
        }
        String jsDecoded = this.jsConvert(encodedValue, wholeDataMessageAsJsonString, JsDecodingHelper.getEncoding(wholeDataMessage));
        JsonElement parsed = LangUtils.exceptionSafe(() -> JsonParser.parseString(jsDecoded));
        if (parsed == null || !parsed.isJsonObject()) {
            throw new JsDecodingException("Result of JS decoding should be a JsonObject, but it is not : " + jsDecoded);
        }
        return this.applyOutputTemplate((JsonObject)parsed);
    }

    private String jsConvert(String encodedValue, String wholeDataMessage, String encoding) throws DecodingException {
        String parseResult = this.runDecode(encodedValue, wholeDataMessage, encoding);
        if (parseResult == null) {
            log.debug("Error during JS decoding execution : null result returned ");
            throw new JsDecodingException("Error during JS decoding execution : null result returned ");
        }
        return parseResult;
    }

    private String runDecode(String encodedValue, String encodedDataMessage, String encoding) throws JsDecodingException {
        JsDecodingTask task = new JsDecodingTask(JS_ENTRYPOINT_FUNCTION, this.scriptEngine, this.jsDecodingMetrics, encoding, this.script, encodedValue, encodedDataMessage);
        return JsDecodingTaskRunner.runJSDecodingTask(task);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsDecoder)) {
            return false;
        }
        JsDecoder other = (JsDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NashornScriptEngine this$scriptEngine = this.scriptEngine;
        NashornScriptEngine other$scriptEngine = other.scriptEngine;
        if (this$scriptEngine == null ? other$scriptEngine != null : !this$scriptEngine.equals(other$scriptEngine)) {
            return false;
        }
        CompiledScript this$script = this.script;
        CompiledScript other$script = other.script;
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        JsDecodingMetrics this$jsDecodingMetrics = this.jsDecodingMetrics;
        JsDecodingMetrics other$jsDecodingMetrics = other.jsDecodingMetrics;
        return !(this$jsDecodingMetrics == null ? other$jsDecodingMetrics != null : !((Object)this$jsDecodingMetrics).equals(other$jsDecodingMetrics));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsDecoder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NashornScriptEngine $scriptEngine = this.scriptEngine;
        result = result * 59 + ($scriptEngine == null ? 43 : $scriptEngine.hashCode());
        CompiledScript $script = this.script;
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        JsDecodingMetrics $jsDecodingMetrics = this.jsDecodingMetrics;
        result = result * 59 + ($jsDecodingMetrics == null ? 43 : ((Object)$jsDecodingMetrics).hashCode());
        return result;
    }
}

